;       SCCSID = @(#)thkmacs.inc	6.2 91/05/04
;---------------------------Module-Header-------------------------------;
; Module Name:  THKMACS.INC
;
; Abstract:     Assembler macros for hand-coded thunks
;
; Created:      23-Jun-89
; Author:       Jeff Parsons [jeffpar]
;
; Copyright (c) 1988, 1989 Microsoft Corporation
;
; Description:
;
;   Since a picture is worth a thousand words, here's an example of
;   how to use the macros in a 16->32 thunk (note that this thunk does
;   nothing whatsoever to the stack segment;  it assumes that we are
;   thunking to nothing more than a call gate in the kernel):
;
;       cProc   DOSREQUESTVDD,<PUBLIC,FAR,NONWIN>
;       parmD   hVDD
;       parmW   sgid
;       parmW   cmdReq
;       parmD   cbBuf1
;       parmD   pBuf1
;       parmD   cbBuf2
;       parmD   pBuf2
;
;       cBegin
;       T16Beg  CODE16,CODE32
;       flatPtr eax,pBuf2               ; parm is 16:16, convert to 0:32
;       PushArg eax
;       PushArg cbBuf2                  ; parm is ulong, so push directly
;       flatPtr eax,pBuf1               ; parm is 16:16, convert to 0:32
;       PushArg eax
;       PushArg cbBuf1                  ; parm is ulong, so push directly
;       movzx   eax,cmdReq              ; parm is ushort, so zero-extend first
;       PushArg eax
;       movzx   eax,sgid                ; parm is ushort, so zero-extend first
;       PushArg eax
;       PushArg hVDD                    ; parm is ulong, so push directly
;       T16Call DOS32REQUESTVDD
;       T16End
;       cEnd
;
;   And here's an example of a 32->16 thunk (in this case, we ARE concerned
;   about switching the stack back and forth correctly, because we are calling
;   into a 16-bit subsystem rather than straight into the kernel).
;
;       Procedure KBD32CHARIN,near
;
;       ArgVar  hkbd,DWORD              ; pascal args in inverted order
;       ArgVar  fIOWait,DWORD
;       ArgVar  pChar,DWORD
;
;       EnterProc
;
;       T32Beg
;       T32Bump edx                     ; insure enough space on stack
;
;       push    ss
;       push    edx                     ; save old stack level
;       getRPL  dx,ss
;
;       ; Create new call frame, using 16-bit semantics
;
;       segPtr  eax,pChar,dx            ; start pushing arguments
;       push    eax
;       push    word ptr [fIOWait]
;       push    word ptr [hKbd]
;       mov     ecx,offset DATA:pfnKbdCharIn
;
;       T32Stack eax,esp,dx             ; switch stacks
;       T32Call  ecx,indirect           ; call the 16-bit API
;       T32End                          ; extend return code, and restore stack
;
;       ExitProc
;
;       EndProc Kbd32CharIn
;-----------------------------------------------------------------------;


        .386p

ThkBeg  equ     <T16Beg>
ThkEnd  equ     <T16End>
ThkCall equ     <T16Call>


T16Beg  macro   cseg,c32seg
        ?thkargs=0
        ?cseg   equ <CODE16>
        ifnb    <cseg>
        ?cseg   equ <cseg>
        endif
        ?c32seg equ <CODE32>
        ifnb    <c32seg>
        ?c32seg equ <c32seg>
        endif
endm


flatPtr macro   reg,hi,lo,input         ;;syntax similar to cmacros "farPtr"
        ifnb <input>
          mov     reg,eax                 ;;preserve eax
          ifnb <lo>
            mov   eax,hi
            shl   eax,16
            mov   ax,lo                   ;;(eax) = offset:segment
          else
            mov   eax,hi
          endif
          call  DOSSELTOFLAT            ;;convert sel:offset to flat address
          xchg  eax,reg                   ;;restore eax
        else
          ?r substr <reg>,2
          ifb <lo>
            mov   reg,hi                  ;;swap high/low words of eax
            ror   reg,16                  ;;swap high/low words of eax
            shr   ?r,3                    ;;discard LDT and RPL bits
            rol   reg,16                  ;;unswap high/low words of eax
          else
            % ifidni <lo>,<?r>
            rol   reg,16
            endif
            % ifdifi <hi>,<?r>
            mov   ?r,hi
            endif
            shr   ?r,3                    ;;discard LDT and RPL bits
            rol   reg,16                  ;;unswap high/low words of eax
            % ifdifi <lo>,<?r>
            mov   ?r,lo
            endif
          endif
        endif
endm


PushArg macro   arg,lo
        push    arg
        ifnb <lo>
          push  lo
        endif
        ?thkargs=?thkargs+4
endm


T16Call macro   name,noextrn
        local   l1,l2
% ?c32seg segment
        ifb <noextrn>
        extrn   name:near
        endif
        assume  cs:FLAT
  l1&_&name label near
      % assume  cs:?cseg
% ?c32seg ends

        movzx   esp,sp                  ;;zero upper half of ESP
        jmp     far ptr FLAT:l1&_&name  ;;jump to 32-bit code segment
l2&_&name:                              ;;return here from 32-bit call

% ?c32seg segment
        assume  cs:FLAT
        .errnz ($ - l1&_&name)          ;;make sure label points here
        call    name                    ;;call 32-bit API
        jmp     far ptr l2&_&name       ;;jump back to 16-bit code segment
      % assume  cs:?cseg
% ?c32seg ends
endm


T16End  macro
        add     esp,?thkargs
endm


T32Beg  macro   cseg,c32seg,dseg,d32seg
        ?argoff = 8
        ?tmpoff = 0
        ?cseg   equ <CODE16>
        ifnb    <cseg>
        ?cseg   equ <cseg>
        endif
        ?c32seg equ <CODE32>
        ifnb    <c32seg>
        ?c32seg equ <c32seg>
        endif
        ?dseg   equ <DATA>
        ifnb    <dseg>
        ?dseg   equ <dseg>
        endif
        ?d32seg equ <DATA32>
        ifnb    <d32seg>
        ?d32seg equ <d32seg>
        endif
endm


DefVar  macro   var,type,s,off
        var equ <type ptr [ebp&s&off]>
endm


Parm    macro   var,size
        ifb <size>
        DefVar  var,dword,+,%?argoff
        ?argoff = ?argoff + 4
        else
        ifidni <size>,<dword>
        DefVar  var,size,+,%?argoff
        ?argoff = ?argoff + 4
        elseifidni <size>,<word>
        DefVar  var,size,+,%?argoff
        ?argoff = ?argoff + 2
        elseifidni <size>,<byte>
        DefVar  var,size,+,%?argoff
        ?argoff = ?argoff + 1
        else
        DefVar  var,byte,+,%?argoff
        ?argoff = ?argoff + size
        endif
        endif
endm


Temp    macro   var,size
        ifb <size>
        ?tmpoff = ?tmpoff + 4
        DefVar  var,dword,-,%?tmpoff
        else
        ifidni <size>,<dword>
        ?tmpoff = ?tmpoff + 4
        DefVar  var,size,-,%?tmpoff
        elseifidni <size>,<word>
        ?tmpoff = ?tmpoff + 2
        DefVar  var,size,-,%?tmpoff
        elseifidni <size>,<byte>
        ?tmpoff = ?tmpoff + 1
        DefVar  var,size,-,%?tmpoff
        else
        ?tmpoff = ?tmpoff + size
        DefVar  var,byte,-,%?tmpoff
        endif
        endif
endm


PushVar macro   var,val
        push    val
        ?tmpoff = ?tmpoff + 4
        DefVar  var,dword,-,%?tmpoff
endm


T32Bump macro   reg
        local   l1

        ifnb    <reg>
        mov     reg,esp                 ;;save stack level to restore
        endif
        mov     ax,ss
        cmp     ax,seg FLAT:?d32seg     ;;standard 32 bit stack?
        jne     short l1                ;;if not, skip bumping code
        cmp     sp,1024
        jae     short l1
        xor     sp,sp                   ;;bump the stack down
    l1:
endm


fixPtr  macro   reg,src,cb,chk          ;;fix pointer if crosses 64k
        local   l1
        ?r substr <reg>,2
        mov     reg,src                 ;; PTR B720442
        ifidni <chk>,<null>
        or      reg,reg
        jz      short l1
        endif
        cmp     ?r,65535-cb+1
        jbe     short l1
        sub     esp,cb-2                ;;alloc mem
        and     esp,0FFFFFFFCh          ;;DWORD align
        mov     reg,esp                 ;;points to new data area
    l1:
endm


getRPL  macro   reg,src                 ;;get RPL from source selector
        mov     reg,src
        and     reg,3
        or      reg,4                   ;;force LDT bit on
endm


segPtr  macro   reg,src,rpl,input       ;;syntax similar to cmacros "farPtr"
        ifnb <input>
          mov     reg,eax                 ;;preserve eax
          mov     eax,src
          call  DOS32FLATTOSEL          ;;convert flat address to sel:offset
          xchg    eax,reg
        else
          ?r substr <reg>,2
          mov   reg,src
          ror   reg,16                    ;;do CRMA on pointer
          shl   ?r,3
          ifnb <rpl>
            or    ?r,rpl
          endif
          rol   reg,16
        endif
endm


T32Stack macro  reg,src,rpl             ;;switch to 16:16 stack
        ?r substr <reg>,2
        mov     reg,src                 ;;use CRMA
        ror     reg,16
        shl     ?r,3
        or      ?r,rpl
        rol     reg,16
        push    reg                     ;;push new stack pointer
        lss     sp,DWORD PTR [esp]      ;;SS:SP = 16-bit ptr
endm


T32Call macro   name,ind
        local   l1,l2

% ?cseg segment
  l1&_&name label far
% ?cseg ends

        jmp     far ptr l1&_&name       ;;jump to 16-bit code segment
l2&_&name:                              ;;return here from 16-bit call

% ?cseg segment
      % assume  cs:?cseg
        .errnz  ($ - l1&_&name)         ;;make sure label points here
        push    seg ?dseg
        pop     ds
      % assume  ds:?dseg
        ifb <ind>
        call    far ptr name            ;;call 16-bit API
        else
        call    dword ptr [name]        ;;call 16-bit API
        endif
        push    seg FLAT:?d32seg
        pop     ds
        assume  ds:FLAT
        jmp     far ptr FLAT:l2&_&name  ;;jump back to 32-bit code segment
% ?cseg ends

        assume  cs:FLAT
endm


T32End  macro                           ;;switch back to 0:32 stack
        movzx   esp,sp                  ;;make sure that ESP is correct
        lss     esp,[esp]
endm
