;*****************************************************************************
;*
;* SOURCE FILE NAME = SVGADEFS.H
;*
;* DESCRIPTIVE NAME =
;*
;* Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
;*             Copyright Microsoft Corporation, 1990
;*             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*             RESTRICTED MATERIALS OF IBM
;*             IBM CONFIDENTIAL
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION  Contains SVGA definitions.
;*
;* FUNCTIONS
;*
;* NOTES        When included into VVID sources, #ifdef SVGA
;*              must be used before #include!
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx   xxxxx xxxxxxx
;*   12/29/92  @V2.0SEN00         Created.
;*   03/12/93  @V2.0SEN01         OEMINFO structure changed.
;*   08/31/93  @V2.1YEE02         Recognize Cirrus Logic GD5428 chip
;*   10/28/93  @V2.1MNH00         Recognize Additional Adapters
;*   12/06/93  @V2.1YEE05 D 76476 Add ID for Chips & Technologies
;*   12/15/93  @V2.1YEE06 D 76685 Add Artist Graphics manufacturer
;*   02/21/94  @V2.1MNH01 D 79562 Recognize Additional Adapters/Chips
;*   04/14/94  @V2.1MNH05 D 81883 WD90C24 allow more unlocks
;*   04/26/94  @V2.1MNH08 D 82003 WD90C24 preserve locks for BIOS setmodes
;*   05/12/94  @V2.1YEE08         Add more Cirrus chipsets
;*   05/13/94  @V2.1MNH13 F 74819 ATI Mach8/32 check in files
;*   05/18/94  @V2.1MNH14         WD90C33 Parse new style PMI
;*   06/22/94  @V2.1JWK02 D 87347 Define Tseng Chip Names for consistant use
;*   07/25/94  @V2.1JWK03 D 89911 Define Tseng W32xD Revisions
;*   07/28/94  @V2.1YEE09 D 88172 Define a Chips and Technologies chiptype
;*   08/02/94  @V2.1MNH25 D 91551 Fix various DAC programming problems
;*   08/19/94  @V2.1MNH37 D 94209 Add more DAC detection
;*   09/01/94  @V2.1YEE10 D 89853 Add support for S3864 with ICD2061 clock chip
;*   09/10/94  @V2.2TSU00 D 86373 Weitek: PCI screen01 incorrect
;*   09/15/94  @V2.1YEE11         Identify DAC as RGB (blue first) or BGR (red first)
;*   09/17/94  @V2.2DAI01 D 92593 Adding monitor configuration enhancements.
;*   09/26/94  @V2.2SEN05 D 97637 Changing Music DAC 4910 from BGR to RGB.
;*   10/05/94  @V2.1MNH51 D101610 Increase size of CLEANDATA for MACH32
;*   10/25/94  @V2.2JWK23 D103192 TSENG Rev D wont install
;*   11/30/94  @V3.0YEE01 D105950 Support S3 964
;*   01/20/95  @V3.0YEE02 D 99391 Support TBird-Enhanced (800x600 flat panel)
;*   01/16/95  @V3.0YEE03 D114992 Add new chip manufacturers
;*   01/24/95  @V3.0ITO01         ThinkPad 230 Support (IBM-J local)
;*   04/19/95  @V3.0DAI01 D119247 Add DevEscape functions and structures for extra capability support
;*   04/28/95  @V3.0YEE04 D120303 Treat ICS5342 unique from ICS5341
;*   05/17/95  @V3.0JWK04 D113889 Add Toshiba manufacturer and models
;*   05/30/95  @V3.0JWK11 D123835 allow displayless machines to init.  Requires
;*                                /nodisplay on device driver statement in config.sys
;*   07/25/95  @IBMJ-S3GEN   D386 More S3 chips support
;*   07/27/95  @V3.0JWK18 D131213 fix AT&T 408/409/499 DAC programming
;*   08/02/95  @V3.0JWK21 D131829 Identify and Support ATI MACH64 version 'CT'
;*   09/11/95  @V3.2SEN01 D133791 Adding real mode software interrupt support to
;*                                VIDEOPMI.
;*   09/14/95  @V3.0JWK25 D126118 NEC C24 prevent 800x600x64k.  Add NEC Manufacturer and model
;*   11/10/95  @V3.2JWK09 D143505 provide compatability with new VIDEO_ADAPTER structures
;*   12/15/95  @V3.0TSU00         Make videopmi backward compatible
;*   02/12/96  @V3.1MNH01 D148203 Merge DBCS-J source w/SBCS source
;*   02/14/96  @V3.2TSU00 D148283 Merlin PBE, support linear aperture
;*   02/16/96  @V3.0YEE06 D148329 APM support
;*   05/14/96  @V3.1MNH10 D151513 S3 Trio Chips Identification
;*   08/15/97  @V4.0MNH19 D157752 Identify new Trident Chips
;*   09/17/97  @V4.0MNH21 D184552 Add Generic SVGA PCI Register Trapping
;****************************************************************************  
INCL_DOSERRORS	EQU	1

MAX_LOCKUNLOCKCMD	EQU	40                               ; @V2.1MNH08  
MAX_CLEANDATA	EQU	200       ;  Includes DACs        /*@V3.0YEE01*/
MAX_SETBANK_CMD	EQU	25                               ; @V2.1MNH14  
MAX_GETBANK_CMD	EQU	20                               ; @V2.1MNH14  
MAX_MODESET_CMD	EQU	84                               ; @V2.1MNH14  
DEFAULT_ADAPTER	EQU	(-1 )
UNKNOWN_ADAPTER	EQU	0 
VIDEO7_ADAPTER	EQU	1        ;  bugbug line up with cleanups!   
TRIDENT_ADAPTER	EQU	2 
TSENG_ADAPTER	EQU	3 
WESTERNDIG_ADAPTER	EQU	4 
ATI_ADAPTER	EQU	5 
IBM_ADAPTER	EQU	6 
CIRRUS_ADAPTER	EQU	7 
S3_ADAPTER	EQU	8 
CHIPS_ADAPTER	EQU	9                       ;  @V2.1YEE05   
WEITEK_ADAPTER	EQU	10                      ;  @V2.1MNH00   
NUMBER9_ADAPTER	EQU	11                      ;  @V2.1YEE10   
GENERIC_PCISVGA_ADAPTER	EQU	12                       ; @senja
OAK_ADAPTER	EQU	13                      ;  @V3.0YEE03   
MATROX_ADAPTER	EQU	14                      ;  @V3.0YEE03   
BROOKTREE_ADAPTER	EQU	15                      ;  @V3.0YEE03   
NVIDIA_ADAPTER	EQU	16                      ;  @V3.0YEE03   
ALLIANCE_ADAPTER	EQU	17                      ;  @V3.0YEE03   
AVANCE_ADAPTER	EQU	18                      ;  @V3.0YEE03   
MEDIAVISION_ADAPTER	EQU	19                      ;  @V3.0YEE03   
ARKLOGIC_ADAPTER	EQU	20                      ;  @V3.0YEE03   
RADIUS_ADAPTER	EQU	21                      ;  @V3.0YEE03   
THREE_D_LABS_ADAPTER	EQU	22                      ;  @V3.0YEE03   
NCR_ADAPTER	EQU	23                      ;  @V3.0YEE03   
IIT_ADAPTER	EQU	24                      ;  @V3.0YEE03   
APPIAN_ADAPTER	EQU	25                      ;  @V3.0YEE03   
SIERRA_ADAPTER	EQU	26                      ;  @V3.0YEE03   
CORNERSTONE_ADAPTER	EQU	27                      ;  @V3.0YEE03   
DIGITAL_ADAPTER	EQU	28                      ;  @V3.0YEE03   
COMPAQ_ADAPTER	EQU	29                      ;  @V3.0YEE03   
INFOTRONIC_ADAPTER	EQU	30                      ;  @V3.0YEE03   
OPTI_ADAPTER	EQU	31                      ;  @V3.0YEE03   
NULL_ADAPTER	EQU	32                      ;  @V3.0JWK11   
 ;  remember to update SVGA_LASTADAPTER when adding new adapter support   
SVGA_FIRSTADAPTER	EQU	VIDEO7_ADAPTER         ;  @V2.1YEE03   
SVGA_LASTADAPTER	EQU	NULL_ADAPTER           ;  @V3.0JWK11   
;  @V2.1MNH13 start   
ifdef FAMILY2
ORCHID_MC_ADAPTER	EQU	2        ;  @V2.0SEN06   
ORCHID_MC_ID	EQU	86H     ;  @V2.0SEN06   
endif
; 
;* DAC types
VGA_DAC	EQU	0                                      ; @V2.1MNH23  
DEFAULT_DAC	EQU	VGA_DAC                               ; @V2.1MNH23  
HICOLOR_DAC	EQU	1       ;  Unidentified                /*@V2.1MNH17*/
WINBOND_DAC	EQU	HICOLOR_DAC                           ; @V2.1MNH23  
BT485_DAC	EQU	2       ;  Brooktree 485               /*@V2.1MNH20*/
Weitek_BT485DAC	EQU	3       ;  BT485 used by Weitek        
SC15025_DAC	EQU	4       ;  SC15025                     
SierraDAC	EQU	SC15025_DAC ;  Use more specific name!   
ATT490_DAC	EQU	5 
ATTDAC	EQU	ATT490_DAC ;  Use more specific name!   
MU9C1880_DAC	EQU	6       ;  MU9C4870, MU9C1880, SS2410  
MU9C4870_DAC	EQU	MU9C1880_DAC                          ; @V2.1MNH23  
TRUECOLOR_DAC	EQU	7                                      ; @V2.1MNH17  
IMSG173_DAC	EQU	8       ; These DACS identified, but not programmed  
InmosDAC	EQU	IMSG173_DAC ;  Use more specific name!   
CH8398_DAC	EQU	9 
ChrontelDAC	EQU	CH8398_DAC ;  Use more specific name!   
CIRRUS_DAC	EQU	10 
ICS5341_DAC	EQU	11 
SGS1702_DAC	EQU	12 
SGSThomsonDAC16	EQU	SGS1702_DAC ;  Use more specific name!   
SGS1703_DAC	EQU	13                                      ; @V2.1MNH23  
MU9C4910_DAC	EQU	14       ;  MU9C4910 (blue byte first)   
                                 ;   note that the MU9C1880 is also true color, but   
                                 ;        it does not need to be identified because   
                                 ;        behaves like the others in its group        
MusicDAC16RGB	EQU	MU9C4910_DAC ;  Use more specific name!   
ATI68830_DAC	EQU	15       ;  ATI 68830 & compatible  @V2.1MNH29    
S3SDAC_DAC	EQU	16       ;  S3 SDAC                 @V2.1MNH29    
ATT498_DAC	EQU	17       ;  AT&T 498 CLOCKDAC ID=$98 no programmable clocks      @V2.1MNH29    
SGS1700_DAC	EQU	18       ;  SGS 1700 DAC            @V2.1MNH29    
TLC34075_DAC	EQU	19       ;  Texas Instruments TLC34075  
ATI68875_DAC	EQU	TLC34075_DAC
BT476_DAC	EQU	20       ;  Brooktree 476/478       @V2.1MNH29    
BT478_DAC	EQU	BT476_DAC
BT481_DAC	EQU	21       ;  Brooktree 481/482       @V2.1MNH29    
BT482_DAC	EQU	BT481_DAC
ATI68860_DAC	EQU	22       ;  ATI 68860/68880         @V2.1MNH29    
MU9CBUG_DAC	EQU	23 
CH8391_DAC	EQU	24 
W82C490_DAC	EQU	25 
ATT491_DAC	EQU	26 
ATT492_DAC	EQU	27 
ATT493_DAC	EQU	28 
ATT497_DAC	EQU	29 
WD90C24_DAC	EQU	30 
MU9C9910_DAC	EQU	31       ;  (blue byte first)   
ATT409_DAC	EQU	32           ; ID=$09 16 bit pixel I/O
ATT499_DAC	EQU	33           ; ID=$99 24 bit Pixel I/0  /*@V3.0YEE03*/
TI3025_DAC	EQU	34       /* TI Viewpoint 3025  CLOCKDAC*; *@V3.0YEE01*/
TI3020_DAC	EQU	35       /* TI Viewpoint 3020  CLOCKDAC*; *@V3.0YEE03*/
ICS5342_DAC	EQU	36                                      ; @V3.0YEE04  
ATT408_DAC	EQU	ATT409_DAC  ; ID=$09 HW pinouts diff   /*@V3.0JWK18*/
NULL_DAC	EQU	37                                      ; @V3.0JWK11  
IMBEDDED_DAC	EQU	38       ; ATI MACH64 'CT'              /*@V3.0JWK21*/
S3TRIO_DAC	EQU	39       /* S3 TRIO DAC               *; *@V3.0YEE05*/
MAX_DAC	EQU	40                                      ; @V3.0JWK21  
VGADAC_NAME	EQU	<"VGA_RGB">
HICOLOR_NAME	EQU	<"HICOLOR_RGB">
BT485_NAME	EQU	<"BT485_RGB">
VIPER_NAME	EQU	<"BT485_RGB">
SC15025_NAME	EQU	<"SC15025_RGB">
ATT490_NAME	EQU	<"ATT20C490_RGB">
MU9C1880_NAME	EQU	<"MU9C1880_BGR">
TRUECOLOR_NAME	EQU	<"TRUECOLOR_RGB">
IMSG173_NAME	EQU	<"IMSG173_RGB">
CH8398_NAME	EQU	<"CH8398_RGB">
CIRRUS_NAME	EQU	<"CIRRUS_RGB">
ICS5341_NAME	EQU	<"ICS5341_RGB">
SGS1702_NAME	EQU	<"SGS1702_RGB">
SGS1703_NAME	EQU	<"SGS1703_RGB">
MU9C4910_NAME	EQU	<"MU9C4910_RGB">
ATI68830_NAME	EQU	<"ATI68830_RGB">
S3SDAC_NAME	EQU	<"S3SDAC_RGB">
ATT498_NAME	EQU	<"ATT20C498_RGB">
SGS1700_NAME	EQU	<"SGS1700_RGB">
TLC34075_NAME	EQU	<"TLC34075_RGB">
ATI68875_NAME	EQU	<"ATI68875_RGB">
BT476_NAME	EQU	<"BT476_RGB">
BT481_NAME	EQU	<"BT481_RGB">
ATI68860_NAME	EQU	<"ATI68860_RGB">
MU9CBUG_NAME	EQU	<"MU9C1880BUG_BGR">
CH8391_NAME	EQU	<"CH8391_RGB">
W82C490_NAME	EQU	<"W82C490_RGB">
ATT491_NAME	EQU	<"ATT20C491_RGB">
ATT492_NAME	EQU	<"ATT20C492_RGB">
ATT493_NAME	EQU	<"ATT20C493_RGB">
ATT497_NAME	EQU	<"ATT20C497_RGB">
WD90C24_NAME	EQU	<"WD90C24_RGB">
MU9C9910_NAME	EQU	<"MU9C9910_RGB">
ATT499_NAME	EQU	<"ATT20C499_RGB">
ATT498_NAME	EQU	<"ATT20C498_RGB">
ATT409_NAME	EQU	<"ATT20C409_RGB">
TI3025_NAME	EQU	<"TVP3025_RGB">
TI3020_NAME	EQU	<"TVP3020_RGB">
ICS5342_NAME	EQU	<"ICS5342_RGB">
NULL_DAC_NAME	EQU	<"NULLDAC_RGB">
IMBEDDED_NAME	EQU	<"IMBEDDED_RGB">
S3TRIODAC_NAME	EQU	<"S3_RGB">
WEITEK_P9000_INCREMENT	EQU	0040H  ; Spacing between potential bases.
WEITEK_P9000_REGISTERS	EQU	0010H  ; Base address offset for registers.
WEITEK_P9000_VRAM	EQU	0020H  ; Base address offset for VRAM.
WEITEK_P9000_SYSCONFIG	EQU	0004H  ; Offset for config reg
WEITEK_P9000_INTERRUPT	EQU	0008H  ; Offset for interrupt reg
WEITEK_P9000_ENABLE	EQU	000cH  ; Offset for interrupt enable reg
WEITEK_P9000_MEMCONFIG	EQU	0184H  ; Offset for memory config reg
WEITEK_P9000_REGLENGTH	EQU	2000H  ; Length for register addressability
;  @V2.1MNH13 end     
UNKNOWN_CHIP	EQU	0 
VIDEO7_HT205_CHIP	EQU	1 
VIDEO7_HT208_CHIP	EQU	2 
VIDEO7_HT209_CHIP	EQU	3 
MAX_VIDEO7_CHIP	EQU	VIDEO7_HT209_CHIP               ; @V2.1MNH01  
VIDEO7_HT205_NAME	EQU	<"HT205">
VIDEO7_HT208_NAME	EQU	<"HT208">
VIDEO7_HT209_NAME	EQU	<"HT209">
TRIDENT_8800_CHIP	EQU	1 
TRIDENT_8900_CHIP	EQU	2 
TRIDENT_9320_CHIP	EQU	3                                ; @V4.0MNH19  
TRIDENT_9660_CHIP	EQU	4                                ; @V4.0MNH19  
TRIDENT_9680_CHIP	EQU	5                                ; @V4.0MNH19  
TRIDENT_9385_CHIP	EQU	6                                ; @V4.0MNH19  
TRIDENT_9382_CHIP	EQU	7                                ; @V4.0MNH19  
TRIDENT_9386_CHIP	EQU	8                                ; @V4.0MNH19  
TRIDENT_9783_CHIP	EQU	9                                ; @V4.0MNH19  
TRIDENT_9440_CHIP	EQU	10                               ; @V4.0MNH19  
TRIDENT_9470_CHIP	EQU	11                               ; @V4.0MNH19  
TRIDENT_9792_CHIP	EQU	12                               ; @V4.0MNH19  
TRIDENT_9395_CHIP	EQU	13                               ; @V4.0MNH19  
TRIDENT_9692_CHIP	EQU	14                               ; @V4.0MNH19  
MAX_TRIDENT_CHIP	EQU	TRIDENT_9692_CHIP               ; @V4.0MNH19  
TRIDENT_8800_NAME	EQU	<"TR8800">
TRIDENT_8900_NAME	EQU	<"TR8900">
TRIDENT_9320_NAME	EQU	<"CYBER9320">
TRIDENT_9660_NAME	EQU	<"TGUI9660">
TRIDENT_9680_NAME	EQU	<"TGUI9680">
TRIDENT_9385_NAME	EQU	<"CYBER9385">
TRIDENT_9382_NAME	EQU	<"CYBER9382">
TRIDENT_9386_NAME	EQU	<"CYBER9386">
TRIDENT_9783_NAME	EQU	<"TGUI9783">
TRIDENT_9440_NAME	EQU	<"TGUI9440">
TRIDENT_9470_NAME	EQU	<"TVG9470">
TRIDENT_9792_NAME	EQU	<"T3D9792">
TRIDENT_9395_NAME	EQU	<"CYBER9395">
TRIDENT_9692_NAME	EQU	<"T3D9692">
TSENG_ET3000_CHIP	EQU	1 
TSENG_ET4000_CHIP	EQU	2 
TSENG_ET4000W32_CHIP	EQU	3     ;  w32                   @V2.1MNH01  
TSENG_ET4000W32I_CHIP	EQU	4     ;  w32i (level a)        @V2.1JWK01  
TSENG_ET4000W32IB_CHIP	EQU	5     ;  w32i level b          @V2.1JWK01  
TSENG_ET4000W32IC_CHIP	EQU	6     ;  w32i level c          @V2.1JWK01  
TSENG_ET4000W32PA_CHIP	EQU	7     ;  w32p level a          @V2.1JWK01  
TSENG_ET4000W32PB_CHIP	EQU	8     ;  w32p level b          @V2.1JWK01  
TSENG_ET4000W32PC_CHIP	EQU	9     ;  w32p level c          @V2.1JWK01  
TSENG_ET4000W32ID_CHIP	EQU	10     ;  w32i level d          @V2.1JWK03  
TSENG_ET4000W32PD_CHIP	EQU	11     ;  w32p level d          @V2.1JWK03  
TSENG_ET4000W32PX_CHIP	EQU	12     ;  all others            @V2.1JWK23  
MAX_TSENG_CHIP	EQU	12 
TSENG_ET3000_NAME	EQU	<"ET3000">
TSENG_ET4000_NAME	EQU	<"ET4000">
TSENG_ET4000W32_NAME	EQU	<"ET4000W32">
TSENG_ET4000W32I_NAME	EQU	<"ET4000W32IREVA">
TSENG_ET4000W32IB_NAME	EQU	<"ET4000W32IREVB">
TSENG_ET4000W32IC_NAME	EQU	<"ET4000W32IREVC">
TSENG_ET4000W32PA_NAME	EQU	<"ET4000W32PREVA">
TSENG_ET4000W32PB_NAME	EQU	<"ET4000W32PREVB">
TSENG_ET4000W32PC_NAME	EQU	<"ET4000W32PREVC">
TSENG_ET4000W32ID_NAME	EQU	<"ET4000W32IREVD">
TSENG_ET4000W32PD_NAME	EQU	<"ET4000W32PREVD">
TSENG_ET4000W32PX_NAME	EQU	<"ET4000W32PREVC_COMPATABLE">
WESTERNDIG_PVGA1A_CHIP	EQU	1 
WESTERNDIG_WD9000_CHIP	EQU	2  ;  PVGA1B   
WESTERNDIG_WD9011_CHIP	EQU	3  ;  PVGA1C   
WESTERNDIG_WD9030_CHIP	EQU	4  ;  PVGA1D   
WESTERNDIG_WD9026_CHIP	EQU	5  ;  PVGA1F                     /*@V2.1MNH01*/
WESTERNDIG_WD9027_CHIP	EQU	6                                ; @V2.1MNH01  
WESTERNDIG_WD9031_CHIP	EQU	7  ;  PVGA1DW                    /*@V2.1MNH01*/
WESTERNDIG_WD9024_CHIP	EQU	8                                ; @V2.1MNH01  
WESTERNDIG_WD9033_CHIP	EQU	9  ;  PVGA2DW                    /*@V2.1MNH01*/
MAX_WESTERNDIG_CHIP	EQU	WESTERNDIG_WD9033_CHIP          ; @V2.1MNH01  
WESTERNDIG_PVGA1A_NAME	EQU	<"PVGA1A">
WESTERNDIG_WD9000_NAME	EQU	<"PVGA1B">
WESTERNDIG_WD9011_NAME	EQU	<"PVGA1C">
WESTERNDIG_WD9030_NAME	EQU	<"PVGA1D">
WESTERNDIG_WD9026_NAME	EQU	<"WD90C26">
WESTERNDIG_WD9027_NAME	EQU	<"WD90C27">
WESTERNDIG_WD9031_NAME	EQU	<"WD90C31">
WESTERNDIG_WD9024_NAME	EQU	<"WD90C24">
WESTERNDIG_WD9033_NAME	EQU	<"WD90C33">
ATI_18800_CHIP	EQU	1  ; VGAWONDER  
ATI_28800_CHIP	EQU	2  ; VGAWONDER+/XL  
ATI_38800_CHIP	EQU	3  ; MACH8/GraphicsUltra         /*@V2.1MNH01*/
ATI_68800_CHIP	EQU	4  ; MACH32/GraphicsUltraPro     /*@V2.1MNH01*/
ATI_88800_CHIP	EQU	5  ; MACH64                      /*@V2.1MNH01*/
ATI_88800CT_CHIP	EQU	6  ; MACH64CT                    /*@V3.0JWK21*/
MAX_ATI_CHIP	EQU	ATI_88800CT_CHIP                ; @V3.0JWK21  
ATI_18800_NAME	EQU	<"ATI18800">
ATI_28800_NAME	EQU	<"ATI28800">
ATI_38800_NAME	EQU	<"ATI38800MACH8">
ATI_68800_NAME	EQU	<"ATI68800MACH32">
ATI_88800_NAME	EQU	<"ATI88800MACH64">
ATI_88800CT_NAME	EQU	<"ATI88800MACH64CT">
IBM_SVGA_CHIP	EQU	1 
MAX_IBM_CHIP	EQU	IBM_SVGA_CHIP                   ; @V2.1MNH01  
IBM_SVGA_NAME	EQU	<"IBMSVGA">
CIRRUS_5420_CHIP	EQU	1                                ; @V2.1YEE08  
CIRRUS_5422_CHIP	EQU	2 
CIRRUS_5424_CHIP	EQU	3 
CIRRUS_5426_CHIP	EQU	4 
CIRRUS_5428_CHIP	EQU	5                                ; @V2.1YEE02  
CIRRUS_5429_CHIP	EQU	6                                ; @V2.1YEE08  
CIRRUS_543X_CHIP	EQU	7                                ; @V2.1YEE08  
CIRRUS_5434_CHIP	EQU	8                                ; @V2.1YEE08  
CIRRUS_6235_CHIP	EQU	9                                ; @V3.0ITO01  
MAX_CIRRUS_CHIP	EQU	CIRRUS_6235_CHIP                ; @V3.0ITO01  
CIRRUS_5420_NAME	EQU	<"GD5420">
CIRRUS_5422_NAME	EQU	<"GD5422">
CIRRUS_5424_NAME	EQU	<"GD5424">
CIRRUS_5426_NAME	EQU	<"GD5426">
CIRRUS_5428_NAME	EQU	<"GD5428">
CIRRUS_5429_NAME	EQU	<"GD5429">
CIRRUS_543X_NAME	EQU	<"GD543X">
CIRRUS_5434_NAME	EQU	<"GD5434">
CIRRUS_6235_NAME	EQU	<"GD6235">
S3_86C805_CHIP	EQU	1            ;  801 or 805   
S3_86C928_CHIP	EQU	2 
S3_86C911_CHIP	EQU	3            ;  @V2.1YEE04   
S3_86C864_CHIP	EQU	4                                ; @V2.1MNH01  
; #define S3_DXP_CHIP              S3_86C864_CHIP               /*@IBMJ-S3GEN*/
S3_86C964_CHIP	EQU	5                                ; @V2.1MNH01  
; #define S3_VXP_CHIP              S3_86C964_CHIP               /*@IBMJ-S3GEN*/
;  These chip IDs added by S3                                   /*@V3.1MNH10*/
S3_86C868_CHIP	EQU	6                                ; @V3.1MNH10  
; #define S3_V868_CHIP             S3_86C868_CHIP               /*@V3.1MNH10*/
S3_86C968_CHIP	EQU	7                                ; @V3.1MNH10  
; #define S3_V968_CHIP             S3_86C968_CHIP               /*@V3.1MNH10*/
S3_86C732_CHIP	EQU	8                                ; @V3.1MNH10  
; #define S3_Trio32_CHIP           S3_86C732_CHIP               /*@V3.1MNH10*/
S3_86C764_CHIP	EQU	9                                ; @V3.1MNH10  
; #define S3_Trio64_CHIP           S3_86C764_CHIP               /*@V3.1MNH10*/
S3_86C765_CHIP	EQU	10                                ; @V3.1MNH10  
; #define S3_V765_CHIP             S3_86C765_CHIP               /*@V3.1MNH10*/
S3_86CM65_CHIP	EQU	11  ;  Aurora64V                  /*@V3.1MNH10*/
S3_86C325_CHIP	EQU	12  ;  ViRGE                      /*@V3.1MNH10*/
S3_86C988_CHIP	EQU	13  ;  ViRGE/vX chip              /*@V3.1MNH10*/
S3_86C767_CHIP	EQU	14  ;  Trio64UV+                  /*@V3.1MNH10*/
S3_86C765_FAMILY	EQU	15  ;  Trio65V+ family compat     /*@V3.1MNH10*/
S3_86C924_CHIP	EQU	16                                ; @V3.1MNH10  
S3_86C866_CHIP	EQU	17                                ; @V3.1MNH10  
; #define S3_V866_CHIP             S3_86C866_CHIP               /*@V3.1MNH10*/
S3_86C928PCI_CHIP	EQU	18                                ; @V3.1MNH10  
MAX_S3_CHIP	EQU	S3_86C928PCI_CHIP              ; @V3.1MNH10  
S3_86C805_NAME	EQU	<"S386C80X">
S3_86C928_NAME	EQU	<"S386C928">
S3_86C911_NAME	EQU	<"S386C911">
S3_86C864_NAME	EQU	<"VISION864">
S3_86C964_NAME	EQU	<"VISION964">
S3_86C868_NAME	EQU	<"VISION868">
; #define S3_V868_NAME            S3_86C868_NAME                /*@V3.1MNH10*/
S3_86C968_NAME	EQU	<"VISION968">
; #define S3_V968_NAME            S3_86C968_NAME                /*@V3.1MNH10*/
S3_86C732_NAME	EQU	<"S3TRIO32">
; #define S3_Trio32_NAME          S3_86C764_NAME                /*@V3.1MNH10*/
S3_86C764_NAME	EQU	<"S3TRIO64">
; #define S3_Trio64_NAME          S3_86C732_NAME                /*@V3.1MNH10*/
S3_86C765_NAME	EQU	<"S3TRIO64V+">
; #define S3_V765_NAME            S3_86C765_NAME                /*@V3.1MNH10*/
S3_86CM65_NAME	EQU	<"S3AURORA64V+">
S3_86C325_NAME	EQU	<"S3VIRGE">
S3_86C988_NAME	EQU	<"S3VIRGE/VX">
S3_86C767_NAME	EQU	<"S3TRIO64UV+">
S3_86C765_FAMILY_NAME	EQU	<"S3TRIO64V+COMPATIBLE">
S3_86C924_NAME	EQU	<"S386C924">
S3_86C866_NAME	EQU	<"S386C866">
; #define S3_V866_NAME            S3_86C866_NAME                /*@V3.1MNH10*/
S3_86C928PCI_NAME	EQU	<"S386C928PCI">
CHIPS_FIRST_CHIP	EQU	1                 ;  bogus chip    @V2.1YEE09  
MAX_CHIPS_CHIP	EQU	1                                ; @V2.1YEE09  
WEITEK_P9000_CHIP	EQU	1                                ; @V2.1MNH01  
WEITEK_W5186_CHIP	EQU	2                                ; @V2.1MNH01  
WEITEK_W5286_CHIP	EQU	3                                ; @V2.1MNH01  
WEITEK_P9100_CHIP	EQU	4                                ; @V2.2TSU00  
MAX_WEITEK_CHIP	EQU	WEITEK_P9100_CHIP               ; @V2.2TSU00  
WEITEK_P9000_NAME	EQU	<"P9000">
WEITEK_W5186_NAME	EQU	<"W5186">
WEITEK_W5286_NAME	EQU	<"W5286">
NULL_CHIP	EQU	1                                ; @V3.0JWK11  
MAX_NULL_CHIP	EQU	NULL_CHIP                       ; @V3.0JWK11  
                                                                ; @V3.0JWK11  
NULL_NAME	EQU	<"NULL">
; 
;* OEM manufacturer defines.
UNKNOWN_MANUFACTURER	EQU	0                                ; @V2.1MNH13  
DIAMOND_MANUFACTURER	EQU	1                                ; @V2.1YEE01  
ORCHID_MANUFACTURER	EQU	2                                ; @V2.1MNH01  
NUMBER9_MANUFACTURER	EQU	3                                ; @V2.1YEE04  
ARTIST_MANUFACTURER	EQU	4                                ; @V2.1YEE07  
LACUNA_MANUFACTURER	EQU	5                                ; @V2.1YEE07  
STB_MANUFACTURER	EQU	6                                ; @V2.2SEN02  
S3_MANUFACTURER	EQU	7                                ; @V2.1YEE10  
CIRRUS_MANUFACTURER	EQU	8 
MIROCRYSTAL_MANUFACTURER	EQU	9                             ; @V2.1YEE11  
VIDEOLOGIC_MANUFACTURER	EQU	10                            ; @V2.1YEE11  
THINKPAD_MANUFACTURER	EQU	11                                ; @V3.0YEE02  
TOSHIBA_MANUFACTURER	EQU	12                                ; @V3.0JWK04  
NEC_MANUFACTURER	EQU	13                                ; @V3.0JWK25  
IBM_VISION_MANUFACTURER	EQU	14                            ; @V3.1MNH01  
MANUFACTURER_MAX	EQU	IBM_VISION_MANUFACTURER         ; @V3.0MUT02  
DEFAULT_MANUFACTURER	EQU	UNKNOWN_MANUFACTURER            ; @V2.2SEN02  
; 
;* OEM manufacturer MODEL defines.
UNKNOWN_MODEL	EQU	0                                ; @V3.0JWK04  
TOSHIBA_6600_MODEL	EQU	1                                ; @V3.0JWK04  
TOSHIBA_2100_MODEL	EQU	2                                ; @V3.0JWK04  
TOSHIBA_2100CS_MODEL	EQU	3                                ; @V3.0JWK04  
TOSHIBA_2100CT_MODEL	EQU	4                                ; @V3.0JWK04  
TOSHIBA_4700CS_MODEL	EQU	5                                ; @V3.0JWK04  
TOSHIBA_4700CT_MODEL	EQU	6                                ; @V3.0JWK04  
TOSHIBA_4800CT_MODEL	EQU	7                                ; @V3.0JWK04  
TOSHIBA_4850CT_MODEL	EQU	8                                ; @V3.0JWK04  
NEC_VERSA_MODEL	EQU	1                                ; @V3.0JWK25  
