; static char *SCCSID = "@(#)strat2.h   6.3 91/04/29";  
; static char *SCCSID = "@(#)strat2.h   6.3 91/04/29";  
;*****************************************************************************                                                                            *
; Strat2.inc - definitions for HPFS strategy-2 request list support 10/3/89  *
;                                                                            *
;***************************************************************************  
; 
;***************************
;** Request List Structure *
;***************************
;*
;* Request Lists have the following format:
;*
;*       ==================================
;*       | BYTE 16   Request List Header  |
;*       | -------------------------------|
;*       | ARRAY     Requests             |
;*       ==================================
;*
;* Where the Request List Header has the following structure:
;  

Req_List_Header	STRUC
RLH_Count	DD	?             ;  number of requests in Req List          
RLH_Notify_Address	DD	?    ;  16:16 address of notification routine   
RLH_Request_Control	DW	?   ;  bitfield of flags defined below         
RLH_Block_Dev_Unit	DB	?    ;  logical unit number of volume           
RLH_Lst_Status	DB	?        ;  overall status for Req List             
RLH_y_Done_Count	DD	?      ;  count of request completed (internal)   
RLH_y_PhysAddr	DD	?        ;  32 bit phys addr of RLH    (internal)   
Req_List_Header	ENDS
; 
;* this redefines some fields for use by DISK01

Req_List_Header_1	STRUC
RLH_Short_Count	DW	?     ;  number of requests in Req List             
RLH_Dummy1	DW	?          ;  reserved must be zero                      
RLH_Dummy2	DD	?          ;  16:16 address of notification routine      
RLH_Dummy3	DW	?          ;  bitfield of flags defined below            
RLH_Dummy4	DB	?          ;  logical unit number of volume              
RLH_Dummy5	DB	?          ;  overall status for Req List                
RLH_Count_Done	DW	?      ;  count of request completed (internal)      
RLH_Queued	DW	?          ;  number of RH that caused queuing (int)     
RLH_Next_RH	DW	?         ;  address of next RH to process (internal)   
RLH_Current_RH	DW	?      ;  address of RH currently in process (int)   
Req_List_Header_1	ENDS
; 
;* List Request Control bit masks  (RLH_Request_Control)
;  
RLH_Req_From_PB	EQU	0001H  ;  Request came directly from Pinball   
RLH_Single_Req	EQU	0002H  ;  Single request in list   
RLH_Exe_Req_Seq	EQU	0004H  ;  Requests to be executed in sequence   
RLH_Abort_Err	EQU	0008H  ;  Abort on error   
RLH_Notify_Err	EQU	0010H  ;  Notify immediately on error   
RLH_Notify_Done	EQU	0020H  ;  Notify on completion   
RLH_Phys_Addr	EQU	0040H  ;  Phys Addr      154306   
RLH_NoEndOfInt	EQU	0080H  ;  Do not call FSD_EndOfInt 154932   
; 
;* List Status bit masks (RLH_Lst_Status)
;*       - low nibble indicates completion status of reqs
;  
RLH_No_Req_Queued	EQU	00H  ;  No requests queued   
RLH_Req_Not_Queued	EQU	01H  ;  Some, but not all, requests queued   
RLH_All_Req_Queued	EQU	02H  ;  All requests queued   
RLH_All_Req_Done	EQU	04H  ;  All requests done or aborted   
RLH_Seq_In_Process	EQU	08H  ;  Requests being processed in sequence   
RLH_Abort_pendings	EQU	08H  ;  Abort list processing in progress   
; 
;* List Status bit masks (RLH_Lst_Status)
;*       - high nibble indicates error status of reqs in list
;  
RLH_No_Error	EQU	00H  ;  No error   
RLH_Rec_Error	EQU	10H  ;  Recoverable error has occurred   
RLH_Unrec_Error	EQU	20H  ;  Unrecoverable error has occurred   
RLH_Unrec_Error_Retry	EQU	30H  ;  Unrecoverable error after retry   
; 
;* Individual requests within the request list have the following format:
;*
;*       ===============================
;*       | BYTE 32   Request Header    |
;*       | ----------------------------|
;*       | BYTE      Command-Specific  |
;*       ===============================
;*
;* Where the Request Header has the following structure:
;  

Req_Header	STRUC
RH_Length	DW	?          ;  offset of the next request             
RH_Old_Command	DB	?     ;  reserved, always 1Ch, same offset      
                                ;  as command code in OS/2 req header     
RH_Command_Code	DB	?    ;  Pinball command request code           
RH_Head_Offset	DD	?     ;  offset from begin of Req List Header   
RH_Req_Control	DB	?     ;  control flags bits defined below       
RH_Priority	DB	?        ;  Priority of request defined below      
RH_Status	DB	?          ;  status bitfield defined below          
RH_Error_Code	DB	?      ;  Pinball errors defined below           
RH_Notify_Address	DD	?  ;  16:16 address called when done         
RH_Hint_Pointer	DD	?    ;  16:16 pointer to req packet in list    
RH_Waiting	DD	?         ;  Waiting queue link pointer (internal)  
RH_FT_Orig_Pkt	DD	?     ;  32b ptr to original request(internal)  
RH_Physical	DD	?        ;  32 bit phys addr of RLH    (internal)  
Req_Header	ENDS
RHL_Waiting   equ   RH_Waiting + size Req_List_Header
RH_pIORB      equ   word ptr RH_Physical ; pointer back to IORB on queue

; 
;* Pinball Length flag
;  
RH_LAST_REQ	EQU	0FFFFH   ;  value of Length if last req in list   
; 
;* Pinball Command Prefix  (RH_Old_Command)
;  
PB_REQ_LIST	EQU	1CH  ;  pinball request list   
; 
;* Pinball Command Codes (RH_Command_Code)
;  
PB_READ_X	EQU	1EH  ;  pinball read   
PB_WRITE_X	EQU	1FH  ;  pinball write   
PB_WRITEV_X	EQU	20H  ;  pinball write/verify   
PB_PREFETCH_X	EQU	21H  ;  pinball prefetch read   
; 
;* Pinball Status (RH_Status) - low nibble
;  
RH_NOT_QUEUED	EQU	00H  ;  not yet queued   
RH_QUEUED	EQU	01H  ;  queued and waiting   
RH_PROCESSING	EQU	02H  ;  in process   
RH_DONE	EQU	04H  ;  done   
; 
;* Pinball Status (RH_Status) - high nibble
;  
RH_NO_ERROR	EQU	00H  ;  No error                              
RH_RECOV_ERROR	EQU	10H  ;  A recoverable error has occurred      
RH_UNREC_ERROR	EQU	20H  ;  An unrecoverable error has occurred   
RH_UNREC_ERROR_RETRY	EQU	30H  ;  An unrecoverable error with retry     
RH_ABORTED	EQU	40H  ;  The request was aborted               
; 
;* Pinball Error Codes - see error.inc, device driver error codes
;*
;* Pinball Request Control bit masks (RH_Req_Control)
;  
RH_PB_REQUEST	EQU	01H  ;  Request came directly from Pinball   
RH_NOTIFY_ERROR	EQU	10H  ;  Notify on Error   
RH_NOTIFY_DONE	EQU	20H  ;  Notify on completion   
; 
;* Priorities
;  
PRIO_PREFETCH	EQU	00H     ;  Prefetch requests.   
PRIO_LAZY_WRITE	EQU	01H     ;  Lazy writer.   
PRIO_PAGER_READ_AHEAD	EQU	02H     ;  Read ahead, low priority pager I/O   
PRIO_BACKGROUND_USER	EQU	04H     ;  Background synchronous user I/O.   
PRIO_FOREGROUND_USER	EQU	08H     ;  Foreground synchronous user I/O.   
PRIO_PAGER_HIGH	EQU	10H     ;  High priority pager I/O.   
PRIO_URGENT	EQU	80H     ;  Urgent (e.g. power fail).   
; 
;* Pinball Read/Write request list entry
;  

PB_Read_Write	STRUC
PB_RqHdr	DB	SIZE Req_Header DUP (?)      ;  request header   
PB_Start_Block	DD	?     ;  start block for data transfer   
PB_Block_Count	DD	?     ;  number of blocks to transfer   
PB_Blocks_Xferred	DD	?  ;  number of blocks transferred   
PB_RW_Flags	DW	?        ;  command specific control flags   
PB_SG_Desc_Count	DW	?   ;  number of SG descriptors   
PB_SG_Desc_Count2	DW	?  ;  number of SG descriptors   (internal)   
PB_reserved	DW	?        ;  reserved for dd alignment  (internal)   
PB_Read_Write	ENDS
; 
;* Pinball Read/Write flags (PB_RW_Flags)
;  
RW_Cache_WriteThru	EQU	0001H  ;  Cache write thru   
RW_Cache_Req	EQU	0002H  ;  Cache the request   

PB_SG_Array_Offset              equ size PB_Read_Write



SG_Descriptor	STRUC
SG_BufferPtr	DD	?       ;  32 bit physcial pointer to the buffer   
SG_BufferSize	DD	?      ;  size of the buffer in bytes   
SG_Descriptor	ENDS
; 
;; DriverCaps is the the Driver Capabilities structure.  This structure is
;; used by FSD's to determine the specific features supported by the
;; device driver.

DriverCaps	STRUC
GDC_DD_Reserved	DW	?                ;  reserved, set to zero                  
GDC_DD_VerMajor	DB	?                ;  major version of interface supported   
GDC_DD_VerMinor	DB	?                ;  minor version of interface supported   
GDC_DD_Capabilities	DD	?            ;  bitfield for driver capabilties        
GDC_DD_Strategy2	DD	?               ;  entry point for strategy-2             
GDC_DD_EndofInt	DD	?                ;  entry point for DD_EndOfInt            
GDC_DD_ChgPriority	DD	?             ;  entry point for DD_ChgPriority         
GDC_DD_SetRestPos	DD	?              ;  entry point for DD_SetRestPos          
GDC_DD_GetBoundary	DD	?             ;  entry point for DD_GetBoundary         
GDC_DD_Strategy3	DD	?               ;  entry point for strategy-3 @189811     
DriverCaps	ENDS
; 
;; Driver Capabilites bit mask (GDC_DD_Capabilities)
GDC_DD_Read2	EQU	00000001H   ;  Read2 supported with DMA hardware       
GDC_DD_DMA_Word	EQU	00000002H   ;  DMA on word-aligned buffers supported   
GDC_DD_DMA_Byte	EQU	00000006H   ;  DMA on byte-aligned buffers supported   
GDC_DD_Mirror	EQU	00000008H   ;  Disk Mirroring supported by driver    
GDC_DD_Duplex	EQU	00000010H   ;  Disk Duplexing supported by driver    
GDC_DD_No_Block	EQU	00000020H   ;  Driver does not block in Strategy 2   
GDC_DD_16M	EQU	00000040H   ;  >16M memory supported                 
GDC_DD_STRAT3	EQU	00000080H   ;  strat-3 entry point @189811           
; 
;; VolChars is the volume charactieristics table.  This table describes the
;; physical characteristics of the logical volume, under the simplifying (but
;; not necessarily true) assumption that this is the only volume on the
;; physical drive.

VolChars	STRUC
VC_VolDescriptor	DW	?           ;  see equates below                      
VC_AvgSeekTime	DW	?             ;  milliseconds, if unknown, FFFFh        
VC_AvgLatency	DW	?              ;  milliseconds, if unknown, FFFFh        
VC_TrackMinBlocks	DW	?          ;  blocks on smallest track               
VC_TrackMaxBlocks	DW	?          ;  blocks on largest track                
VC_HeadsPerCylinder	DW	?        ;  if unknown or not applicable use 1     
VC_VolCylinderCount	DD	?        ;  number of cylinders on volume          
VC_VolMedianBlock	DD	?          ;  block in center of volume for seek     
VC_MaxSGList	DW	?               ;  Adapter scatter/gather list limit      
VolChars	ENDS
; 
;; Volume Descriptor bit masks (VC_VolDescriptor)
VC_REMOVABLE_MEDIA	EQU	0001H   ;  Volume resides on removable media     
VC_READ_ONLY	EQU	0002H   ;  Volume is read-only                   
VC_RAM_DISK	EQU	0004H   ;  Seek time independant of position     
VC_HWCACHE	EQU	0008H   ;  Outboard cache supported              
VC_SCB	EQU	0010H   ;  SCB protocol supported                
VC_PREFETCH	EQU	0020H   ;  Prefetch read supported               
; 
;* The rest of this file is not needed by standard HPFS
;  
;
;
;***************************
;* Queue Linkage Structure *
;***************************
;
; This structure is private to the driver
;
; Queue linkage will be allocated from the local data segment. A word
;       pointer will point to the next link structure in the queue and a
;       double word will serve as a far pointer to the actual request.
;
; The linkage provided in the elements of the Pinball request array will
;       point back to the queue linkage to fascilitate removal of a request
;       if a request list was cancelled or a request's priority changed.
;
NUMQLINKS = 50                          ; number of QLink elements
;
QLink struc
        QLinkNext               dw ?    ; pointer to next queue link
        QLinkPriority           db ?    ; request priority
        QLinkFlags              db ?    ; pinball indicator
        QLinkRequest            dd ?    ; far pointer to pinball request
        QLinkStartBlock         dd ?    ; disk I/O start block for sort key
        QLinkReqHandle          dw ?    ; used when notifying FT_Done
        QLinkPartNumber         db ?    ; FT partition number
        QLinkDevUnit            db ?    ; device unit number from packet
        QLinkRelBlock           dd ?    ; FT relative start block
QLink ends
;
; QLinkFlags Values
;
        QL_OS2          equ     00h     ; this is standard OS/2 I/O
        QL_Pinball      equ     01h     ; this is HPFS386 I/O
        QL_HPFS386      equ     01h     ; this is HPFS386 I/O
        FT_AUX_PKT      equ     02h     ; this is an auxilliary packet
        FT_MIRROR_IO    equ     04h     ; mirrored I/O
;
; end of assembly section


;***********************************
;* GetDeviceSupport Request Packet *
;***********************************


;
;; define the device driver request packet for the get device
;; capabilities (hex 1d) command
;
Pkt_1d      struc
                db  PktHeadSize dup (?) ; device driver request packet header.
                db  3 dup (?)           ; reserved.
Pkt_1d_DCS_Addr dd  ?                   ; pointer to dcs area in 16:16 format.
Pkt_1d_VCS_Addr dd  ?                   ; pointer to vcs area in 16:16 format.
Pkt_1d      ends

access_type_write equ   1
access_type_read  equ   0


;
ERROR_INT13_BAD_COMMAND         EQU     01h
ERROR_INT13_DRIVE_NOT_READY     EQU     80h
;
;***********************************************************
;* IOCTL Packet for IOPD_SB - Set Simulated Bad sectors *  *
;* NOTE: THIS IS AN INTERNAL IOCTL FOR DEBUG PURPOSES ONLY *
;***********************************************************

IOPD_SB             equ 04Bh    ; category 9 function 4Bh
SSB_MAXCNT          equ 012h    ; only allow 18 simulated bad sectors
;* SSB commands
SSB_SET             equ 0
SSB_CLEAR           equ 1
SSB_CLEARALL        equ 2
SSB_LIST            equ 3

IOCTLSETSBAD struc
    ssb_cmd         db  ?
    ssb_cnt         db  ?       ; on return will be
    ssb_sec         dd  ?       ; sector to be marked bad/ cleared
IOCTLSETSBAD ends

;* cnt field returns # of slots clear on a SET cmd and # of slots used
;* on a clear cmd.

;PBTEST equ 1   ; for Pinball testing, enabling simbad code

;
; this next routine is two macros for spin-locking
; critical sections. In the first macro a semaphore
; is tested for availability. It is tested in such
; a way start after the first test the data should
; be in the cache and there should be no more memory
; accesses. Once it is available we try to grab it
; and if someone beats us to it, we go back to
; checking the semaphore in the cache.
; The second routine simply writes a zero to the
; semaphore to clear it (and enables interrupts).
;
STARTCRITICAL macro semaphore
        push    ax
        mov     al, 1
@@:     sti
        cmp     semaphore, 0    ; Q: semaphore available?
        jnz     @B              ;    N: try again
        cli
        xchg    semaphore, al   ; this is where we actually set it
        or      al,al           ; Q: did we set it?
        jnz     @B              ;   N: start over again
        pop     ax
        endm

X_STARTCRITICAL macro semaphore
        push    ax
        mov     al, 1
@@:     xchg    semaphore, al
        or      al,al           ; Q: did we set it?
        jnz     @B              ;   N: start over again
        pop     ax
        endm

ENDCRITICAL macro semaphore
        mov     semaphore, 0
        sti
        endm

X_ENDCRITICAL macro semaphore
        mov     semaphore, 0
        endm

; State Trace Buffer Pointer Mask
        ST_BufferPtr_Mask   equ 0FFFh       ; only 4k state trace buffer
;       STATETRACE          equ 1           ; enable state trace debugging

; SimBad
        CACHETEST           equ 1           ; enable Bad Sector Simulation

; Minimum MaxSgList
; If the scsi card can't handle at least 16 s/g entries then (for fat)
; volumes feed it strat1.
   FAT_MIN_MAX_SGLIST equ 16


; FAT strat2 request packet. Note that the SG field is pre-set for 60 pages.
; The worst case is around 18 pages. But we need more for the Lazy Writer
; which will not require more SG_Descriptior but just a few more RB_Read_Write.
; If we add more PB_Read_Writes then the old FAT strategy2 would not work, so
; for now we fake it out.

fats2   struc
fs2_rlh db      size Req_List_Header dup(?)
fs2_rh  db      size PB_Read_Write dup(?)
fs2_sg  db 60 * size SG_Descriptor dup(?)
fs2_sem dd      ?
fats2   ends

;---------------------------------------------------------------
; Raw File System Strat2 Request Packet Definitions     154932
; Strat2 Request List Entry Definition                  154932
raw_ent struc
raw_rle db size PB_Read_Write dup(?)
raw_sg  db size SG_Descriptor dup(?)
raw_ent ends

; Raw File System request packet.                       154932
rawfs   struc
raw_rlh db  size Req_List_Header dup(?)
raw_rl  db  size raw_ent         dup(?)
rawfs   ends

; Used as the max size of a strat2 req pkt
; 175241 emp: double the size of req pkt. S2..._SWP is same as before
S2_RW_RQPKT_SIZE_SWP  EQU   size fats2                ; static/swapper pool
S2_RW_RQPKT_SIZE      EQU   2 * S2_RW_RQPKT_SIZE_SWP  ; all others


