;       SCCSID = @(#)realmac.inc	6.1 90/11/16
;      SCCSID = @(#)realmac.inc	13.3 89/02/09

;
; Macro file for old macros that have to run on pre-386 processors
;


;***	LJ<cc> - Long conditional jumps
;
;	Generates code to simulate a long conditional jump. Actually
;	if the jump is backward and the distance is short, it generates
;	a short conditional jump. Forward jumps are implemented as
;	short conditional jumps around long unconditional jumps.
;
;	ENTRY:	l = jump target
;
;	EXIT:	code generated to do conditional jump.

LJE macro l
 LJ JE JNE l
endm

LJNE macro l
 LJ jne JE l
endm

LJZ macro l
 LJE l
endm

LJNZ macro l
 LJNE l
endm

LJC macro l
 LJ jc JNC l
endm

LJNC macro l
 LJ jnc JC l
endm

LJA macro l
 LJ ja JNA l
endm

LJNA macro l
 LJ jna JA l
endm

LJB macro l
 LJ jb JNB l
endm

LJNB macro l
 LJ jnb JB l
endm

LJS macro l
 LJ js JNS l
endm

LJNS macro l
 LJ jns JS l
endm

LJAE macro l
 LJ jae JNAE l
endm

LJBE macro l
 LJ jbe JNBE l
endm

LJL macro l
 LJ jl JNL l
endm

LJG macro l
 LJ jg JNG l
endm

LJLE macro l
 LJ jle JNLE l
endm

DLJE macro l
 DLJ JE JNE l
endm

DLJNE macro l
 DLJ jne JE l
endm

DLJZ macro l
 DLJE l
endm

DLJNZ macro l
 DLJNE l
endm

DLJC macro l
 DLJ jc JNC l
endm

DLJNC macro l
 DLJ jnc JC l
endm

DLJA macro l
 DLJ ja JNA l
endm

DLJNA macro l
 DLJ jna JA l
endm

DLJB macro l
 DLJ jb JNB l
endm

DLJNB macro l
 DLJ jnb JB l
endm

DLJS macro l
 DLJ js JNS l
endm

DLJNS macro l
 DLJ jns JS l
endm

DLJAE macro l
 DLJ jae JNAE l
endm

DLJBE macro l
 DLJ jbe JNBE l
endm

DLJG macro l
 DLJ jg JNG l
endm

DLJL macro l
 DLJ jl JNL l
endm

DLJLE macro l
 DLJ jle JNLE l
endm


;**	LJ - Generate long conditional jump
;
;	If target preceeds us and is in range just use a short jump
;	else use a jump around long jump.
;
;	ENTRY:	dirop  = mnemonic of conditional jump
;		idirop = mnemonic of negative conditional jump
;		l      = jump target
;
;	EXIT:	code generated to do the conditional jump.

LJ MACRO dirop,idirop,l
 local a
 IF ((.TYPE l) XOR 20h) AND 0A0h
  idirop a			       ;; not defined or is external
  jmp l
a:
 ELSE				       ;; is local definied
  IF (($-l) LT 124) AND ($ GT l)
   dirop l			      ;; is before and within range
  ELSE
   idirop a			      ;; is out of range or forward (pass 2)
   jmp l
a:
  ENDIF
 ENDIF
ENDM


ifndef Debug
    Debug = 0
endif

;**	DLJ - generate conditional jump; long if Debug; else short.
;
;	If Debug is non-zero then we generate a jump around long jump,
;	else a short jump.
;
;	ENTRY:	dirop  = mnemonic of conditional jump
;		idirop = mnemonic of negative conditional jump
;		l      = jump target
;	(global variables)
;		Debug  = 0 - generate short jump
;		       = not 0 - generate long jump
;
;	EXIT:	code generated to do the conditional jump.

DLJ MACRO dirop,idirop,l
 local a
 IF Debug
  idirop a
  jmp l
a:
 ELSE
  dirop l
 ENDIF
ENDM


;***	DLJMP - generate unconditional jump
;
;	If Debug is defined then generate a normal jump, else try to
;	generate a short jump even if we have to jump to a previous
;	jump (that jumps to a previous jump...).
;
;	ENTRY:	lbl    = jump target
;	(global variables)
;		Debug  = 0 - try to generate short jump
;		       = non-zero - generate normal jump
;		lbl&_J = undefined - first time jump sees the label
;			 "lbl".
;		       = defined - labeled the last jump that jumps
;			 to "lbl". This may be used as the target
;			 instead of "lbl" to minimize the jump distance.
;
;	EXIT:	generated code to jump to "lbl" directly or indirectly.
;	(global variables)
;		lbl&_J = labels the current jump to "lbl".

DLJMP macro lbl
 IF Debug
  jump lbl
 ELSE
  jmp short lbl
 ENDIF
ENDM


.xcref	LJE, LJNE, LJZ, LJNZ, LJC, LJNC, LJA, LJNA
.xcref	LJB, LJNB, LJS, LJNS, LJAE, LJBE, LJG, LJL, LJLE
.xcref	DLJE, DLJNE, DLJZ, DLJNZ, DLJC, DLJNC, DLJA, DLJNA
.xcref	DLJB, DLJNB, DLJS, DLJNS, DLJAE, DLJBE, DLJG, DLJL, DLJLE
.xcref	LJ,DLJ
