; static char *SCCSID = "@(#)pvwxport.h 6.2 92/02/05";  
;       SCCSID = "@(#)pvwxport.h        6.2 92/02/05"         
;****************************** Module Header *******************************
; Module Name: PVWXPORT.H
;
; OS/2 Perfview (PVW) Definitions File
;
; Copyright (c) International Business Machines Corporation 1981, 1988-1992
;
; ===========================================================================
;
;  This include file contains the definitions and constants for the
;  registration of a performance counter group. This header file should be
;  included when DosRegisterPerfCtrs(), dh_RegisterPerfCtrs(),
;  fsh_RegisterPerfCtrs() are needed.
;
;
;**************************************************************************  
;  Miscellaneous constants   
;  Types   
;*** Quad-Word (qw) definitions   

qw_s	STRUC
qw_ulLo	DD	?
qw_ulHi	DD	?
qw_s	ENDS

QWRD struc
db size qw_s dup(?)
QWRD ends

PQWRD struc
	dd ?
PQWRD ends

QW_MAX_HI	EQU	7fffffffH 
QW_MAX_LO	EQU	0ffffffffH 
QW_MIN_HI	EQU	80000000H 
QW_MIN_LO	EQU	00000000H 
CNT struc
	dd ?
CNT ends

TIMR struc
db size qw_s dup(?)
TIMR ends

SUMSQ struc
db size qw_s dup(?)
SUMSQ ends

BULKCNT struc
db size qw_s dup(?)
BULKCNT ends

QCT struc
	dd ?
QCT ends

PCNT struc
	dd ?
PCNT ends

PTIMR struc
	dd ?
PTIMR ends

PSUMSQ struc
	dd ?
PSUMSQ ends

PBULKCNT struc
	dd ?
PBULKCNT ends

PQCT struc
	dd ?
PQCT ends

;*** Queue Length (ql) definitions   

qlen_s	STRUC
ql_tm	DB	SIZE TIMR DUP (?)
ql_ct	DD	?
qlen_s	ENDS

qlen_t struc
db size qlen_s dup(?)
qlen_t ends

QLEN struc
db size qlen_s dup(?)
QLEN ends

PQLEN struc
	dd ?
PQLEN ends

;  This definition satisfies MASM happy when it sees the results of H2INC; it
;* provides a convenient way to define a pointer size.
;  

ul_s	STRUC
ul_ul	DD	?
ul_s	ENDS

;*************************************************************************  
;  RegisterPerfCtrs (RPC) definitions
;*
;*      For DosRegisterPerfCtrs(), dh_RegisterPerfCtrs(),
;*      fsh_RegisterPerfCtrs(), vdh_RegisterPerfCtrs().
;  
;       FLAGS   RegisterPerfCtrs Flags -- valid values for 'flFlags' of Data
;*              block are:
;*
;*              {RPC_FL_16BIT | RPC_FL_32BIT} |
;*              {RPC_FL_PERS | RPC_FL_TRAN} |
;*              {RPC_FL_KRNL | RPC_FL_DD | RPC_FL_FSD | RPC_FL_VDD | RPC_FL_APP} |
;*              RPC_FL_TMR_INIT |
;*              RPC_FL_DEREG
;  
RPC_FL_16BIT	EQU	0000H         ;  16-bit interface               
RPC_FL_32BIT	EQU	0001H         ;  32-bit interface               
RPC_FL_PERS	EQU	0002H         ;  Persistent entity type         
RPC_FL_TRAN	EQU	0004H         ;  Transient entity type          
RPC_FL_KRNL	EQU	0008H 
RPC_FL_DD	EQU	0010H         ;  Device driver entity type      
RPC_FL_FSD	EQU	0020H         ;  FSD entity type                
RPC_FL_VDD	EQU	0040H         ;  VDD entity type                
RPC_FL_APP	EQU	0080H         ;  Application entity type        
RPC_FL_TMR_INIT	EQU	0100H         ;  Init Tmr function ptrs at
;                                        * registration time.
;                                          
RPC_FL_DEREG	EQU	0200H         ;  Deregister entity              
;       The following flags are reserved for private use by the kernel; they
;*      are cleared at registration time.
;  
RPC_FL_CONFIG	EQU	0400H         ;  Configured                     
;               Flag Masks
;  
RPC_FLM_KRNL_PERS	EQU	(RPC_FL_KRNL  OR  RPC_FL_PERS)
RPC_FLM_KRNL_TRAN	EQU	(RPC_FL_KRNL  OR  RPC_FL_TRAN)
RPC_FLM_DRV	EQU	(RPC_FL_DD  OR  RPC_FL_FSD  OR  RPC_FL_VDD) ;  Driver entities   
RPC_FLM_PRIVATE	EQU	(RPC_FL_CONFIG) ;  Private flags for kernel use   
RPC_FLM_ET	EQU	(RPC_FL_KRNL  OR  RPC_FL_DD  OR  RPC_FL_FSD  OR  RPC_FL_VDD  OR  RPC_FL_APP) ;  Entity Type   
;       Perfview Block IDentifier (bid)
;  

pvbid_s	STRUC
bid_usInstance	DW	? ;  Block Instance ID                      
bid_usGroup	DW	?    ;  Block Group ID                         
pvbid_s	ENDS

pvbid_t struc
db size pvbid_s dup(?)
pvbid_t ends

BID struc
db size pvbid_s dup(?)
BID ends

ppvbid_t struc
	dd ?
ppvbid_t ends

PBID struc
	dd ?
PBID ends

RPC_MAX_ID	EQU	0ffffH           ;  Maximum ID must fit in USHORT   
;       PerfView Text Block Name (tbn)
;*
;*      FLAGS   Valid values for 'tbn_ulFlags' are:
;*
;*              for Counter Names:
;*
;*              {TBN_FL_CT_UNKNOWN | TBN_FL_CT_CNT | TBN_FL_CT_TIMR |
;*              TBN_FL_CT_QLEN | TBN_FL_CT_SUMSQ | TBN_FL_BULKCT | TBN_FL_CT_QCT}
;*              TBN_FL_CT_QCT
;*              for Group and Instance Names:
;*
;*              {TBN_FL_PERS | TBN_FL_TRAN} |
;*              {TBN_FL_KRNL} |
;*              {TBN_FL_MULTIPROC}
;*
;*      NOTES   The structure members take on slightly different meanings
;*              when they are used to describe a Transient Entity Instance.
;*              In this case, the tbh_atbnName member of the Text Block
;*              Header (TBH) serves as a pointer to an array of instance
;*              descriptor blocks which have the same form as pvtbName_s, but
;*              rather than describing counters in a separate Data Block,
;*              they are self-describing:  tbn_pszName describes the contents
;*              of tbn_ulFlags, tbn_usMsgID would retain its usual meaning,
;*              and tbn_usSize would be unused.
;*
;*              For example, if tbn_pszName = "PID", then tbn_ulFlags will
;*              contain the pid of the process which created this instance.
;*              Typical descriptors for kernel transient instances would be
;*              "PID", "TID", and "SLOT #".  By convention, the first TBN
;*              block of the tbh_atbnName array will contain the name of the
;*              creating process in tbn_pszName; in this case, tbn_ulFlags
;*              will be unused.
;  

pvtbName_s	STRUC
tbn_ulFlags	DD	?    ;  Flags, see TBN_FL_***                  
tbn_usSize	DW	?     ;  Counter Size                           
tbn_usMsgID	DW	?    ;  Message ID                             
tbn_pszName	DD	?    ;  Name (default message)                 
pvtbName_s	ENDS

pvtbName_t struc
db size pvtbName_s dup(?)
pvtbName_t ends

TBN struc
db size pvtbName_s dup(?)
TBN ends

ppvtbName_t struc
	dd ?
ppvtbName_t ends

PTBN struc
	dd ?
PTBN ends

_PVWNAME	EQU	pvtbName_s
PVWNAME struc
db size pvtbName_s dup(?)
PVWNAME ends

;       Flags values (tbn_ulFlags)
;  
TBN_FLM_CT	EQU	000FH  ;  Counter Flag Mask (values 0 -> 0xF)  
TBN_FL_CT_CNT	EQU	0000H  ;    Count                              
TBN_FL_CT_TIMR	EQU	0001H  ;    Timer                              
TBN_FL_CT_QLEN	EQU	0002H  ;    Queue length                       
TBN_FL_CT_SUMSQ	EQU	0003H  ;    Sum of Squares                     
TBN_FL_CT_BULKCT	EQU	0004H  ;    Bulk Counter                       
TBN_FL_CT_UNKNOWN	EQU	0005H  ;    Unknown type                       
TBN_FL_CT_QCT	EQU	0006H  ;    Count that increases or decreases   
                                   ;  These are used in the tbh_tbnGroup and
;                                   * tbh_tbnInstance Name blocks (see pvtbh_s).
;                                     
TBN_FL_PERS	EQU	0010H  ;  Persistent Entity                    
TBN_FL_TRAN	EQU	0020H  ;  Transient Entity                     
TBN_FL_KRNL	EQU	0040H  ;  Kernel Entity                        
TBN_FL_MULTIPROC	EQU	0080H  ;  Multiple Processor Entity            
                                   ;  General purpose (per counter) flags  
TBN_FL_ADVANCED	EQU	0100H  ;  Advanced property                    
TBN_FL_HISTOGRAM	EQU	0200H  ;  Start/End histogram counters         
TBN_FLM_UNKNOWN	EQU	0F000H  ;  For Unknown counter types
;                                   * (TBN_FL_CT_UNKNOWN), these flags are
;                                   * reserved for use by the Registrant.
;                                     
;       PerfView Text Block Header (tbh)
;*
;*      NOTES   Values for the version number, tbh_ulVersion, are defined
;*              below (TBH_VER_...).
;*
;*              See NOTES for Perfview Text Block Name (tbn) concerning
;*              the tbh_atbnName member.
;  

pvtbh_s	STRUC
tbh_ulVersion	DD	?  ;  Version number (MUST BE FIRST MEMBER)     
tbh_bidID	DB	SIZE BID DUP (?)      ;  Block IDentifier                          
tbh_tbnGroup	DB	SIZE TBN DUP (?)   ;  Text block Group name                     
tbh_tbnInstance	DB	SIZE TBN DUP (?) ;  Text block Instance name                 
tbh_pszMsgFile	DD	? ;  Message File name                         
tbh_pszHelpFile	DD	? ;  Help File name                           
tbh_culName	DD	?    ;  Number of counters Names                  
tbh_atbnName	DD	?   ;  Pointer to array of counter Name blocks   
pvtbh_s	ENDS

pvtbh_t struc
db size pvtbh_s dup(?)
pvtbh_t ends

TBH struc
db size pvtbh_s dup(?)
TBH ends

_PVWFSDTEXTH	EQU	pvtbh_s         ;  for File System Driver (FSD)   
PVWFSDTEXTH struc
db size pvtbh_s dup(?)
PVWFSDTEXTH ends

ppvtbh_t struc
	dd ?
ppvtbh_t ends

PTBH struc
	dd ?
PTBH ends

NUM_TBH_PSZ	EQU	4                ;  Number of ASCIIZ ptrs in TBH   
;       Version number values (tbh_ulVersion)
;*
;*      Format: A.B.C.D where   A = Major version #
;*                              B = Major release #
;*                              C = Minor release #
;*                              D = Development revision #
;  
TBH_VER_2_0_0_0	EQU	02000000H               ;  2.0.0.0   
;       PerfView Data Block Header (dbh)
;*
;*      FLAGS   Valid values for 'dbh_ulFlags' are:
;*
;*              {RPC_FL_16BIT | RPC_FL_32BIT} |
;*              {RPC_FL_PERS | RPC_FL_TRAN} |
;*              {RPC_FL_KRNL | RPC_FL_DD | RPC_FL_FSD | RPC_FL_VDD | RPC_FL_APP} |
;*
;*      NOTES   If modifying pvdbh_s, be sure to change both the 'C' AND
;*              MASM definitions below.  They are separated because h2inc.exe
;*              doesn't handle the pfnTmr declaration conversion properly.
;*
;*              Semaphore:  Kernel counters and Drivers use 'dbh_ulSem' as a
;*              "data modified" flag (increment each time block modified).
;*              Applications use 'dbh_ulSem' as a semaphore handle
;*              (semaphore is created by the Application).
;  
pvdbh_s STRUC
dbh_ulTotLen    DD      ?       ;  Total Length of data block (including hdr)
dbh_bidID       DB SIZE BID DUP (?) ;  IDentifier (Block ID)
dbh_flFlags     DD      ?       ;  Flags
dbh_ulSem       DD      ?       ;  Semaphore or Semaphore handle
dbh_pfnTmrAdd   DD      ?       ;  Ptr to timer Addition function
dbh_pfnTmrSub   DD      ?       ;  Ptr to timer Subtract function
pvdbh_s ENDS

pvdbh_t struc
db size pvdbh_s dup(?)
pvdbh_t ends

DBH struc
db size pvdbh_s dup(?)
DBH ends

_PVWFSDDATAH	EQU	pvdbh_s         ;  for File System Driver (FSD)   
PVWFSDDATAH struc
db size pvdbh_s dup(?)
PVWFSDDATAH ends

ppvdbh_t struc
	dd ?
ppvdbh_t ends

PDBH struc
	dd ?
PDBH ends

;**************************************************************************  
;       Counter Types (CT) (************ -- USE TBN_FL_... ***)
;  
PVW_CT_UNKNOWN	EQU	TBN_FL_CT_UNKNOWN
PVW_CT_CNT	EQU	TBN_FL_CT_CNT
PVW_CT_TIMR	EQU	TBN_FL_CT_TIMR
PVW_CT_QLEN	EQU	TBN_FL_CT_QLEN
PVW_CT_SUMSQ	EQU	TBN_FL_CT_SUMSQ
PVW_CT_BULKCT	EQU	TBN_FL_CT_BULKCT
PVW_CT_QCT	EQU	TBN_FL_CT_QCT
