;***	propname.inc - property names for language translation
;
;
;	IBM Confidential
;
;	Copyright (c) IBM Corporation 1987, 1992
;
;	All Rights Reserved
;
;
;	Modification History:
;	---------------------
;	25-Nov-1989 wayneca    Initial version.
;
;	07-May-1991 Richard Wooley
;
;		    Changed all occurences of the single line comment
;		    notation to the standard notation to allow users to
;		    maintain ANSI compatibility.  This is in response to
;		    PTR B718526.  All future updates to this and all other
;		    header files should use the standard commenting format.
;
;	06-13-91   ;BN003 HARE	Added LASTDRIVE advanced properties
;	06-27-91   Bill Madden	 Added DPMI advanced property	   BN004
;	08-05-91   Mary Nolterieke, Information Development.
;		   Edited property names for consistency.
;	09-18-91   Bill Madden	 Changed DPX and DPMI advanced properties
;	09-22-91   Kip Harris	 Implemented DCR cp20 1532, specifies that
;		   property names and enumerated text values should not be
;		   represented as national langauage MRI, but instead rep-
;		   resented as strings that look like environment variables.
;	01-16-92   J. Hlavaty	 Added DPX_NETBUFFSIZE
;	01-22-92   Jeff Muir	 Added DOS_BACKGROUND_EXECUTION
;	01-18-94   J. Tran	 Added VDM_PRIORITY   - 77667
;	06-16-94   J. Tran	 Changed VDM_PRIORITY to SESSION_PRIORITY - 85737
;	02-15-96   M. Hersey	 Merge VVIDEO DBCS-J (IBM J) source w/SBCS source
;	08-07-96   N. Sugimasa	 remove PM_FEP rename OS2_FS_FEP to OS2_FEP defect355j
;	03-07-97   M. Hersey	 Merge VVIDEO DBCS-K (IBM K) source w/SBCS source
;	12-12-97   mapl		 Added HW_SHARE_IRQ9 property - 190239
;/

;***********************************************************************;BN001
; 14Jul92 - Jeff Muir							;BN001
; Added INT_DURING_IO property						;BN001
;***********************************************************************;BN001
; 18Jul92 - Y.Nishida							;BN002
; Added COM_SELECT property						;BN002
;***********************************************************************;BN002
; ?????92 - ?								;BN003
; Add DDE and CLIPBOARD							;BN003
;***********************************************************************;BN003
; ?????92 - ?								;BN004
; Add windows 3.1 support						;BN004
;***********************************************************************;BN004
; 19Mar92 - E. Akahane							;J-EA0319
; Changed DBCS version unique properties				;J-EA0319
;***********************************************************************;J-EA0319
; 21Aug92 - G.L.Fulk							;BN005
; Add Multi-Autoexec support						;BN005
;***********************************************************************;BN005
; 28Sep92 - K. Yokomizo							;J-KY001
; Added PROP_NAME_GETRELEASE (DCR JC20 #240)				;J-KY001
;***********************************************************************;J-KY001
; 04Dec92 - TPL								;BN006
; Windows 3.1 changes (58090)						;BN006
;***********************************************************************;BN006
; 01Feb93 - S. A. Barnes						;BN007
; Added PRINT_SEPARATE_OUTPUT (58213)					;BN007
;***********************************************************************;BN007
; 02Mar93 - TPL								;BN008
; Change I/O Trap setting (63263)					;BN008
;***********************************************************************;BN008
; 19Mar93 - B. J. Thompson						;BN009
; Add AUDIO_ADAPTER_SHARING						;BN009
;***********************************************************************;BN009
; 25Mar93 - TPL								;BN010
; Change I/O Trap BACK!!! (64862)					;BN010
;***********************************************************************;BN010
;***********************************************************************;BN009
; 29Mar93 - TPL								;BN011
; add COM_RECEIVE_BUFFER_FLUSH						;BN011
;***********************************************************************;BN011
; 05Aug93 - T. Sobue							;J-TS269
; add PROP_NAME_LOAD_DBCS24_FONT					;J-TS269
; to implement DCR 269 to support VTEXT in GALE VDM.			;J-TS269
;***********************************************************************;J-TS269
;/


;--- DEM Property Names ---

PROP_NAME_AUTOEXEC	EQU	"DOS_AUTOEXEC"			  ;BN005


;--- VKBD Property Names ---

PROP_NAME_POLL	EQU	"IDLE_SENSITIVITY"
PROP_NAME_DELAY		EQU	"IDLE_SECONDS"
PROP_NAME_FAST_PASTE	EQU	"VIDEO_FASTPASTE"
PROP_NAME_EXTRA_KEYS	EQU	"KBD_BUFFER_EXTEND"
PROP_NAME_KBD_RESTRICT	EQU	"KBD_RATE_LOCK"
PROP_NAME_KBD_CTRL_BP	EQU	"KBD_CTRL_BYPASS"
PROP_NAME_KBD_ALTHOM_BP		EQU	"KBD_ALTHOME_BYPASS"
PROP_NAME_INPUT_ENV	EQU	"*FEP_MODE"				;@IBM J-EA0319
SINGLE_INPUT_METHOD	EQU	"OS2_FS_FEP"			       ;@IBM J-EA0319

ifndef DOSK						       ;@K-BS1116A
DUAL_INPUT_METHODS	EQU	"PM_FEP"			       ;@IBM J-EA0319
endif ;!DOSK						   ;@K-BS1116A*/

DOS_KKC_MODE	EQU	"DOS_FEP"			       ;@IBM J-EA0319

;DCR 1195
;*** WARNING - Do not change the order of the following **
HOT_KEY_LIST	EQU	\
 "NONE\0ALT_ESC\0CTRL_ESC\0"


;--- VTIMER Property Names ---

PROP_NAME_DIRECT_ACCESS		EQU	"HW_TIMER"
PROP_NAME_SOUND_INHIBIT		EQU	"HW_NOSOUND"
PROP_NAME_BGND_EXEC	EQU	"DOS_BACKGROUND_EXECUTION"


;--- VLPT Property Names ---

PROP_NAME_LPT1TIMEOUT	EQU	"PRINT_TIMEOUT"
PROP_NAME_LPTSEPARATE	EQU	"PRINT_SEPARATE_OUTPUT"			;BN007
PROP_NAME_LPT1TYPE	EQU	"PRINT_TYPE_LPT1"			;@IBM J-EA0124
PROP_NAME_LPT2TYPE	EQU	"PRINT_TYPE_LPT2"			;@IBM J-EA0124
PROP_NAME_LPT3TYPE	EQU	"PRINT_TYPE_LPT3"			;@IBM J-EA0124
PROP_NAME_LPT0TYPE	EQU	"PRINT_TYPE_LPT_N"			;@IBM J-EA0319
PROP_NAME_LPT1GRPHPRT	EQU	"PRINT_SCREEN"				;@IBM J-EA0319
PROP_NAME_GETRELEASE	EQU	"PRINT_GET_RELEASE"			;@IBM J-KY001
PRINTER_SELSTR_PS55	EQU	"IBM_PS55_EMULATION"			;@IBM J-EA0319
PRINTER_SELSTR_ESCP	EQU	"ESCP_EMULATION"			;@IBM J-EA0319
PRINTER_SELSTR_OTHER	EQU	"OTHER_EMULATION"			;@IBM J-EA0319
PRINTER_SELSTR_NATIVE	EQU	"PRINTER_HW_DEPENDENT"			;@IBM J-EA0319
PRINT_GRPHPRT_NORMAL	EQU	"NORMAL"				;@IBM J-EA0319
PRINT_GRPHPRT_REVERSE	EQU	"REVERSE"				;@IBM J-EA0319
PRINT_GRPHPRT_OFF	EQU	"DISABLE"				;@IBM J-EA0319

;--- VBIOS Property Names ---

PROP_NAME_BREAK		EQU	"DOS_BREAK"
PROP_NAME_SHELL		EQU	"DOS_SHELL"
PROP_NAME_RMSIZE	EQU	"DOS_RMSIZE"
PROP_NAME_FCB	EQU	"DOS_FCBS"
PROP_NAME_FCB2	EQU	"DOS_FCBS_KEEP"
PROP_NAME_FILES		EQU	"DOS_FILES"
PROP_NAME_DOSDD		EQU	"DOS_DEVICE"
PROP_NAME_DOS_OWN_UMB	EQU	"DOS_UMB"
PROP_NAME_DOS_LOADED_HIGH	EQU	"DOS_HIGH"
PROP_NAME_COPYROM	EQU	"HW_ROM_TO_RAM"
PROP_NAME_IOPL3		EQU	"HW_IOPL_LOCK"
PROP_NAME_INCLUDE_REGIONS	EQU	"MEM_INCLUDE_REGIONS"
PROP_NAME_EXCLUDE_REGIONS	EQU	"MEM_EXCLUDE_REGIONS"
PROP_NAME_LASTDRIVE	EQU	"DOS_LASTDRIVE"
PROP_NAME_VM_BOOT	EQU	"DOS_STARTUP_DRIVE"
PROP_NAME_BIOSMODE	EQU	"*DOS_MODE"		    ;@J-EA0319
PCDOS_MODE_STR	EQU	"PC-DOS"		   ;@J-EA0319
DOSJ_MODE_STR	EQU	"J-DOS"			   ;@J-EA0319
DOSV_MODE_STR	EQU	"DOS/V"			   ;@J-EA0319
DOSK_MODE_STR	EQU	"DOS/K"			   ;@K-BS1116A


;--- VPIC Property Names ---

PROP_NAME_INT_DURING_IO		EQU	"INT_DURING_IO"			  ;BN001
PROP_NAME_SHARE_IRQ9	EQU	"HW_SHARE_IRQ9"			  ;190239

VIDEO_DRIVER_NAME	EQU	"MDOS Video Device Driver"


;--- VVIDEO Property Names ---

PROP_NAME_INT10EMULATE	EQU	"VIDEO_ROM_EMULATION"
PROP_NAME_RTRCEMULATE	EQU	"VIDEO_RETRACE_EMULATION"
PROP_NAME_MODERESTRICT	EQU	"VIDEO_MODE_RESTRICTION"
PROP_NAME_NORESTRICT	EQU	"NONE        "
PROP_NAME_CGARESTRICT	EQU	"CGA            "
PROP_NAME_MONORESTRICT	EQU	"MONO           "   ;length must match CGARESTRICT
PROP_NAME_ONDEMAND	EQU	"VIDEO_ONDEMAND_MEMORY"
PROP_NAME_INT2F		EQU	"VIDEO_SWITCH_NOTIFICATION"
PROP_NAME_UPDATEWINDOW	EQU	"VIDEO_WINDOW_REFRESH"
PROP_NAME_SYNCOUTPUT	EQU	"Video_Window_scroll_synchronization"
PROP_NAME_8514A_IOTRAP	EQU	"VIDEO_8514A_XGA_IOTRAP"	     ;BN010


;--- VXMS Property Names ---


;  Giving VXMS_PER_VDM_LIMIT as 0 will stop XMS operation in that
;  VDM. This field is restricted to 0-65535KB with default value as
;  1024K. VXMS_MIN_HMA_USAGE are restricted to be in 0-63k with default
;  as 0. VXMS_NUM_HANDLES are restricted to 0-128 with default as 32.
;  VXMS_UMB_STATE is bool and defaults to deactive.
;

PROP_NAME_VXMS_PER_VDM_LIMIT	EQU	"XMS_MEMORY_LIMIT"
PROP_NAME_VXMS_MIN_HMA	EQU	"XMS_MINIMUM_HMA"
PROP_NAME_VXMS_NUM_HANDLES	EQU	"XMS_HANDLES"


;--- VEMM Property Names ---

PROP_VEMM_LIMIT		EQU	"EMS_MEMORY_LIMIT"
PROP_VEMM_HIGH	EQU	"EMS_HIGH_OS_MAP_REGION"
PROP_VEMM_LOW	EQU	"EMS_LOW_OS_MAP_REGION"
PROP_VEMM_FRAME		EQU	"EMS_FRAME_LOCATION"

;*** WARNING - Do not change the order of the following **
PROP_VEMM_LIST	EQU	\
 "AUTO\0NONE\0C000\0C400\0C800\0CC00\0D000\0D400\0D800\0DC00\0" \
 "8000\08400\08800\08C00\09000\0"


;--- VMOUSE Property Names ---

PROP_NAME_MOUSECAPTURE	EQU	"MOUSE_EXCLUSIVE_ACCESS"

;***	FAKEVERINFO defines a fake version entry for a DOS app.
;
;	MVDMR.LIB -> OS2KRNL
;
;	DOSEM fakes out the specified version for a DOS app which
;	listed on a FAKEVERINFO structure.
;

PROP_NAME_FAKE_VERSION	EQU	"DOS_VERSION"


;--- DPMI Property Name ---

; This property enables or disables DPMI support for this VDM.

PROP_NAME_DPMI	EQU	"DPMI_MEMORY_LIMIT"
PROP_NAME_DPX_ENABLE	EQU	"DPMI_DOS_API"
PROP_NAME_DPX_NETBUFSIZE	EQU	"DPMI_NETWORK_BUFF_SIZE"

PROP_DPX_TRANS_ALWAYS	EQU	"ENABLED"
PROP_DPX_TRANS_APP_SEL	EQU	"AUTO"
PROP_DPX_TRANS_NEVER	EQU	"DISABLED"

PROP_DPX_TRANS_LIST	EQU	\
   PROP_DPX_TRANS_APP_SEL "\0" \
   PROP_DPX_TRANS_ALWAYS "\0" \
   PROP_DPX_TRANS_NEVER "\0"

;--- This property supports VDM Priority

; PROP_NAME_PRIORITY	EQU	"VDM_PRIORITY"
PROP_NAME_PRIORITY	EQU	"SESSION_PRIORITY"		    ;85737

;--- VCOM Property Name ---

PROP_NAME_HOLD_RES	EQU	"COM_HOLD"
PROP_NAME_HW_COM	EQU	"COM_DIRECT_ACCESS"
PROP_NAME_COM_SELECT	EQU	"COM_SELECT"			      ;BN002
PROP_NAME_COM_RX_BUFFER_FLUSH	EQU	"COM_RECEIVE_BUFFER_FLUSH"   ;BN011


;--- VTOUCH Property Name ---

PROP_NAME_EXCLUSIVE_TOUCH	EQU	"TOUCH_EXCLUSIVE_ACCESS"


;--- Windows properties ---

PROP_NAME_WIN_RUNMODE	EQU	"WIN_RUN_MODE"			     ;BN006
PROP_NAME_DDE	EQU	"WIN_DDE"			     ;BN003
PROP_NAME_CLIPBOARD	EQU	"WIN_CLIPBOARD"			     ;BN003
PROP_NAME_ATM	EQU	"WIN_ATM"			     ;atm

PROP_WMODE_STD	EQU	"3.0 Standard"			     ;BN006
PROP_WMODE_REAL		EQU	"Real"				     ;BN006
PROP_WMODE_AUTO		EQU	"Auto"				     ;BN006

ifdef  JLFX
 PROP_WMODE_31STD	EQU	"3.1 X^_[h"
 PROP_WMODE_31ENH	EQU	"3.1 GnXg݊"
else   ;JLFX
 ifdef KLFX
  PROP_WMODE_31STD	EQU	"3.1 ǥ "	  ;@IBM K-BS1116A
  PROP_WMODE_31ENH	EQU	"3.1 Ȯ "	  ;@IBM K-BS1116A
 else	;JLFX
  PROP_WMODE_31STD	EQU	"3.1 Standard"			     ;BN006
  PROP_WMODE_31ENH	EQU	"3.1 Enhanced Compatibility"	     ;BN006
 endif	;JLFX
endif  ;JLFX

;--- Audio properties ---

PROP_NAME_AUDIO_ADAPTER		EQU	"AUDIO_ADAPTER_SHARING"		     ;BN009

ifdef  JLFX
 PROP_SHARMODE_OPTIONAL		EQU	"Cӎw"
 PROP_SHARMODE_NONE	EQU	"Ȃ"
 PROP_SHARMODE_REQUIRED		EQU	"K{"
else   ;JLFX
 ifdef KLFX					   ;@IBM K-BS1116A
  PROP_SHARMODE_OPTIONAL	EQU	" "    ;@IBM K-BS1116A
  PROP_SHARMODE_NONE	EQU	""	       ;@IBM K-BS1116A
  PROP_SHARMODE_REQUIRED	EQU	"ʼ"	       ;@IBM K-BS1116A
 else	;JLFX
  PROP_SHARMODE_OPTIONAL	EQU	"Optional"			  ;BN009
  PROP_SHARMODE_NONE	EQU	"None"				  ;BN009
  PROP_SHARMODE_REQUIRED	EQU	"Required"			  ;BN009
 endif	;JLFX
endif  ;JLFX

;--- VFNTV Property Name ---					     ;@IBM J-TS269
									;@IBM J-TS269
PROP_NAME_LOAD_DBCS24_FONT	EQU	"FNT_LOAD_DBCS24_FONT"		    ;@IBM J-TS269

