;*****************************************************************************
;*
;* SOURCE FILE NAME = PCI.H
;*
;* DESCRIPTIVE NAME =
;*
;* Copyright : COPYRIGHT IBM CORPORATION, 1994, 1997
;*             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*             RESTRICTED MATERIALS OF IBM
;*             IBM CONFIDENTIAL
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION  Contains PCI BIOS definitions.
;*
;* FUNCTIONS
;*
;* NOTES
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx   xxxxx xxxxxxx
;*   05/21/94  Jon Grimm  D083385 Created PCI.INC
;*   09/02/94  Bob Carney D094979
;*   09/17/97  @V4.0MNH21 D184552 Add Generic SVGA PCI Register Trapping
;****************************************************************************  
OEM_PCI_BIOS_INFO	EQU	0 

PciBiosInfo_P	STRUC
pbi_bPCIFunc	DB	?
PciBiosInfo_P	ENDS
PCI_PBI_PARM_SIZE	EQU	SIZE    PciBiosInfo_P  

PciBiosInfo_D	STRUC
pbi_bReturn	DB	?
pbi_bHWMech	DB	?
pbi_bMajorRev	DB	?
pbi_bMinorRev	DB	?
pbi_bLastBus	DB	?
PciBiosInfo_D	ENDS
PCI_PBI_DATA_SIZE	EQU	SIZE    PciBiosInfo_D  
OEM_PCI_FIND_DEVICE	EQU	1 

PciFindDevice_P	STRUC
pfd_bPCIFunc	DB	?
pfd_usDeviceID	DW	?
pfd_usVendorID	DW	?
pfd_bIndex	DB	?
PciFindDevice_P	ENDS
PCI_PFD_PARM_SIZE	EQU	SIZE    PciFindDevice_P  

PciFindDevice_D	STRUC
pfd_bReturn	DB	?
pfd_bBusNum	DB	?
pfd_bDevFunc	DB	?
PciFindDevice_D	ENDS
PCI_PFD_DATA_SIZE	EQU	SIZE    PciFindDevice_D  
OEM_PCI_FIND_CLASS_CODE	EQU	2 

PciFindClassCode_P	STRUC
pfcc_bPCIFunc	DB	?
pfcc_ulClassCode	DD	?
pfcc_bIndex	DB	?
PciFindClassCode_P	ENDS
PCI_PFCC_PARM_SIZE	EQU	SIZE    PciFindClassCode_P  

PciFindClassCode_D	STRUC
pfcc_bReturn	DB	?
pfcc_bBusNum	DB	?
pfcc_bDevFunc	DB	?
PciFindClassCode_D	ENDS
PCI_PFCC_DATA_SIZE	EQU	SIZE    PciFindClassCode_D  
OEM_PCI_READ_CONFIG	EQU	3 

PciReadConfig_P	STRUC
prc_bPCIFunc	DB	?
prc_bBusNum	DB	?
prc_bDevFunc	DB	?
prc_bConfigReg	DB	?
prc_bSize	DB	?
PciReadConfig_P	ENDS
PCI_PRC_PARM_SIZE	EQU	SIZE    PciReadConfig_P  

PciReadConfig_D	STRUC
prc_bReturn	DB	?
prc_ulData	DD	?
PciReadConfig_D	ENDS
PCI_PRC_DATA_SIZE	EQU	SIZE    PciReadConfig_D  
OEM_PCI_WRITE_CONFIG	EQU	4 

PciWriteConfig_P	STRUC
pwc_bPCIFunc	DB	?
pwc_bBusNum	DB	?
pwc_bDevFunc	DB	?
pwc_bConfigReg	DB	?
pwc_bSize	DB	?
pwc_ulData	DD	?
PciWriteConfig_P	ENDS
PCI_PWC_PARM_SIZE	EQU	SIZE    PciWriteConfig_P  

PciWriteConfig_D	STRUC
pwc_bReturn	DB	?
PciWriteConfig_D	ENDS
PCI_PWC_DATA_SIZE	EQU	SIZE    PciWriteConfig_D  
PCI_STACK_SIZE	EQU	1024 
PCI_ROM_ADDR	EQU	000F0000H 
PCI_ENTRY_OFFSET	EQU	0FE6EH 
PCI_BIOS_PRESENT	EQU	0B101H 
PCI_FIND_DEVICE	EQU	0B102H 
PCI_FIND_CLASS_CODE	EQU	0B103H 
PCI_GENERATE_S_CYCLE	EQU	0B106H 
PCI_READ_CONFIG_BYTE	EQU	0B108H 
PCI_READ_CONFIG_WORD	EQU	0B109H 
PCI_READ_CONFIG_DWORD	EQU	0B10AH 
PCI_WRITE_CONFIG_BYTE	EQU	0B10BH 
PCI_WRITE_CONFIG_WORD	EQU	0B10CH 
PCI_WRITE_CONFIG_DWORD	EQU	0B10DH 
;  only for 2.1 BIOS - unused now   
PCI_GET_IRQ_ROUTING	EQU	0B10EH 
PCI_SET_IRQ	EQU	0B10FH 
PCI_BAD_VID	EQU	0FFFFH 
PCI_BAD_DID	EQU	0FFFFH 
PCI_NO_INTERRUPT_PIN	EQU	0000H 
PCI_FUNC_MASK	EQU	0080H 
PCI_MULTI_FUNC	EQU	0007H 
PCI_SINGLE_FUNC	EQU	0000H 
PCI_BASE_ADDR_IO_SPACE	EQU	00000001H                       ; @V4.0MNH21  
PCI_BASE_ADDR_TYPE	EQU	00000006H                       ; @V4.0MNH21  
PCI_BASE_ADDR_32_BIT	EQU	00000000H                   ; @V4.0MNH21  
PCI_BASE_ADDR_BELOW_1M	EQU	00000002H                   ; @V4.0MNH21  
PCI_BASE_ADDR_64_BIT	EQU	00000004H                   ; @V4.0MNH21  
PCI_BASE_ADDR_PREFETCH	EQU	00000008H                       ; @V4.0MNH21  
PCI_BASE_ADDR_IO_ONLY	EQU	0fffffffcH                       ; @V4.0MNH21  
PCI_BASE_ADDR_MEM_ONLY	EQU	0fffffff0H                       ; @V4.0MNH21  
PCI_CFG_BASE_ADDR_COUNT	EQU	6                                ; @V4.0MNH21  

SPCICONFIGHEADER	STRUC
pci_usVendorID	DW	?                                        ; @V4.0MNH21  
pci_usDeviceID	DW	?                                        ; @V4.0MNH21  
pci_usCmdReg	DW	?                                          ; @V4.0MNH21  
pci_usStatusReg	DW	?                                       ; @V4.0MNH21  
pci_bRevisionID	DB	?                                       ; @V4.0MNH21  
pci_bProgIF	DB	?                                           ; @V4.0MNH21  
pci_bSubClassCode	DB	?                                     ; @V4.0MNH21  
pci_bClassCode	DB	?                                        ; @V4.0MNH21  
pci_bCacheLineSize	DB	?                                    ; @V4.0MNH21  
pci_bLatencyTimer	DB	?                                     ; @V4.0MNH21  
pci_bHeaderType	DB	?                                       ; @V4.0MNH21  
pci_bBIST	DB	?                                             ; @V4.0MNH21  
pci_aulBaseAddr	DD	PCI_CFG_BASE_ADDR_COUNT DUP (?)             ; @V4.0MNH21  
pci_ulCardBusCISPtr	DD	?                                   ; @V4.0MNH21  
pci_usSubsystemVendorID	DW	?                               ; @V4.0MNH21  
pci_usSubsystemDeviceID	DW	?                               ; @V4.0MNH21  
pci_ulExpansionROMBaseAddr	DD	?                            ; @V4.0MNH21  
pci_ulReserved1	DD	?                                       ; @V4.0MNH21  
pci_ulReserved2	DD	?                                       ; @V4.0MNH21  
pci_bInterruptLine	DB	?                                    ; @V4.0MNH21  
pci_bInterruptPin	DB	?                                     ; @V4.0MNH21  
pci_bMin_Gnt	DB	?                                          ; @V4.0MNH21  
pci_bMax_Lat	DB	?                                          ; @V4.0MNH21  
SPCICONFIGHEADER	ENDS
;  PCI Configuration Space   
PCI_CFG_VID	EQU	(offset pci_usVendorID)         ; @V4.0MNH21  
PCI_CFG_DID	EQU	(offset pci_usDeviceID)         ; @V4.0MNH21  
PCI_CFG_CMD_REG	EQU	(offset pci_usCmdReg)           ; @V4.0MNH21  
PCI_CFG_STAT_REG	EQU	(offset pci_usStatusReg)        ; @V4.0MNH21  
PCI_CFG_REV_ID	EQU	(offset pci_bRevisionID)        ; @V4.0MNH21  
PCI_CFG_CLASS_CODE	EQU	(offset pci_bProgIF)            ; @V4.0MNH21  
PCI_CFG_CACHE_LINE_SIZE	EQU	(offset pci_bCacheLineSize)     ; @V4.0MNH21  
PCI_CFG_LAT_TIMER	EQU	(offset pci_bLatencyTimer)      ; @V4.0MNH21  
PCI_CFG_HEADER	EQU	(offset pci_bHeaderType)        ; @V4.0MNH21  
PCI_CFG_BIST	EQU	(offset pci_bBIST)              ; @V4.0MNH21  
PCI_CFG_INT_LEVEL	EQU	(offset pci_bInterruptLine)     ; @V4.0MNH21  
PCI_CFG_INT_PIN	EQU	(offset pci_bInterruptPin)      ; @V4.0MNH21  
PCI_CFG_MIN_GNT	EQU	(offset pci_bMin_Gnt)           ; @V4.0MNH21  
PCI_CFG_MAX_LAT	EQU	(offset pci_bMax_Lat)           ; @V4.0MNH21  
PCI_CFG_SPACE_SIZE	EQU	0100H                           ; @V4.0MNH21  
PCI_CFG_USER_DEF_SIZE	EQU	(PCI_CFG_SPACE_SIZE - SIZE    SPCICONFIGHEADER  ) ; @V4.0MNH21  

SPCICONFIGURATION	STRUC
pci_sPCIConfigHeader	DB	SIZE SPCICONFIGHEADER DUP (?)                        ; @V4.0MNH21  
pci_abPCIUserDefined	DB	PCI_CFG_USER_DEF_SIZE DUP (?)          ; @V4.0MNH21  
SPCICONFIGURATION	ENDS
PCI_MAX_NUM_DEV	EQU	20H 
PCI_FNNUMBER	EQU	0BH 
BIOS32_NAME	EQU	5f32335fH 
PCI_NAME	EQU	49435024H 
