;       SCCSID = @(#)oldmaca.inc	6.1 90/11/16
;	OLD AND OBSOLETE MACROS
;
;	SCCSID = @(#)oldmaca.inc	13.7 90/02/10
;
;	This file provides the following macros:
;
;	  RMONLY
;	  PMONLY
;	  DUALMODE
;	  RMPROCONLY
;	  RMPM
;	  invoke
;	  transfer
;	  short_addr
;	  long_addr
;	  error
;	  jump
;	  return
;	  condret
;	  retz
;	  retnz
;	  retc
;	  retnc
;	  LJE
;	  LJNE
;	  LJZ
;	  LJNZ
;	  LJC
;	  LJNC
;	  LJA
;	  LJNA
;	  LJB
;	  LJNB
;	  LJS
;	  LJNS
;	  LJAE
;	  LJBE
;	  LJL
;	  LJG
;	  LJLE
;	  DLJE
;	  DLJNE
;	  DLJZ
;	  DLJNZ
;	  DLJC
;	  DLJNC
;	  DLJA
;	  DLJNA
;	  DLJB
;	  DLJNB
;	  DLJS
;	  DLJNS
;	  DLJAE
;	  DLJBE
;	  DLJG
;	  DLJL
;	  DLJLE
;	  LJ
;	  DLJ
;	  DLJMP
;	  ERRNZ
;	  POPFF
;	  POPAF
;	  SegAssert
;	  Assert

;***	RMONLY - Verify that the processor is in real mode
;
;	If MODECHECK is defined, generate code to verify that the
;	current process is in real mode.
;
;	ENTRY:	task = "TASKTIME" - generate code to also verify that
;			 the current process is running at task time.
;		     = blank - don't check for task time.
;	(global variables)
;		MODECHECK = defined - generated code
;			  = undefined - don't generate any code
;
;	EXIT:	code generated to call routines that checks processor
;		mode.
;
;	SEE ALSO: PMONLY, DUALMODE, RMPROCONLY.

RMONLY	macro	task
	RMPM	Real,<task>
endm

;***	PMONLY - Verify that the processor is in protected mode
;
;	If MODECHECK is defined, generate code to verify that the
;	current process is in real mode.
;
;	ENTRY:	task = "TASKTIME" - generate code to also verify that
;			 the current process is running at task time.
;		     = blank - don't check for task time.
;	(global variables)
;		MODECHECK = defined - generated code
;			  = undefined - don't generate any code
;
;	EXIT:	code generated to call routines that checks processor
;		mode.
;
;	SEE ALSO: RMONLY, DUALMODE, RMPROCONLY.

PMONLY	macro	task
	RMPM	Prot,<task>
endm

;***	DUALMODE - document that the processor may be in either mode
;
;	This macro is used more for documentation purpose than to
;	generate anything useful.
;
;	ENTRY:	task = "TASKTIME" - if MODECHECK is also defined, then
;			  generate code to verify the current process
;			  is running at task time.
;		     = blank - do nothing.
;	(global variables)
;		MODECHECK = defined - see above
;			  = undefined - do nothing
;
;	EXIT:	if MODECHECK is defined and task is "TASKTIME" then
;		generate code to call routine to verify task time.
;
;	SEE ALSO: RMONLY, PMONLY, RMPROCONLY.

DUALMODE macro	task
	RMPM	<>,<task>
endm

;***	RMPROCONLY - verify the current process is 3xbox
;
;	If MODECHECK is defined, generate code to verify that the
;	current process is the 3xbox and is at tasktime.
;
;	ENTRY:	(global variables)
;		MODECHECK = defined - generate code
;			  = undefined - do nothing
;
;	EXIT:	if MODECHECK defined, code generated to call the routine
;		that does the check.
;
;	SEE ALSO: RMONLY, PMONLY, DUALMODE.

RMPROCONLY	macro
	RMPM	RealProc,TASKTIME
endm

;**	RMPM - RMONLY/PMONLY support
;
;	Generates code to call mode/process checking routines if
;	MODECHECK is defined.
;
;	ENTRY:	rmpm = name of the checking routine to call
;		task = "TASKTIME" - call the routine that checks for
;			 task time as well.
;		       blank - don't check for task time
;	(global variables)
;		MODECHECK = defined - enables this macro
;			    undefined - do nothing
;		?farcode  = used to control types of call generated
;			    (see ?GenCall).
;
;	EXIT:	if MODECHECK is defined, code generated to call the
;		checking routines.
;
;	SEE ALSO: RMONLY, PMONLY, DUALMODE, RMPROCONLY.

RMPM	macro	rmpm,task
ifdef MODECHECK
ifnb <task>
    if2
	ifdif <task>,<TASKTIME>
	    %out RMONLY/PMONLY/DUALMODE/RMPROCONLY: bad macro arg: task
	    .ERR
	endif
    endif
    ifb <rmpm>
	?GenCall TaskOnly, SN_DosCode
    else
	?GenCall rmpm&TaskOnly, SN_DosCode
    endif
else
    ifnb <rmpm>
	?GenCall rmpm&Only, SN_DosCode
    endif
endif
endif
endm

;***	invoke - call a procedure
;
;	WARNING: Use is discouraged because it increases link time and
;		 encourages people to not declare external procedures
;		 explicitly.
;
;	Generate a call to procedure "name." If the procedure "name"
;	is not defined in the current file then an extrn name:near is
;	also generated. This also causes larger .obj file and slower
;	link time because the extrn causes a flush of the LEDATA
;	record (data structure used by the assembler) for the current
;	segment, generates an extrn record, then re-opens the LEDATA
;	record. The fast way is to lump all extrn's in one place.
;
;	ENTRY:	name = name of procedure to call
;
;	EXIT:	call and extrn (if necessary) generated.

invoke	macro	name
IF2
IFNDEF name
	extrn	name:near
ENDIF
ENDIF
	CALL	name
ENDM

;***	transfer - jump to a label
;
;	WARNING: Use is discouraged because it may slow link time and/or
;		 execution time.
;
;	If the given label is not defined in the current file then an
;	extrn name:near is generated. May generate short jmp that
;	jumps to another jump to reduce code size at the expense of
;	execution time.
;
;	ENTRY:	name = jump target
;
;	EXIT:	Code generated for jump and, if necessary, extrn.
;
;	SEE ALSO: jump


transfer    macro   name
IF2
IFNDEF name
	extrn	name:near
ENDIF
ENDIF
.cref
	jump	name
ENDM

;***	short_addr - declare near address
;
;	Declares a word (dw) containing the offset of the label "name"
;	from group DOSCODE. If "name" is not defined in the current
;	file, then an extrn name:near is also generated. If "name" is
;	"?", then this macro is equivalent to "dw ?".
;
;	ENTRY:	name = a label in DOSCODE group.
;
;	EXIT:	generated a word containing the offset of "name."
;
;	SEE ALSO: long_addr

CSOFFSET EQU OFFSET DOSCODE:

short_addr  macro   name
IFDIF	<name>,<?>
IF2
IFNDEF name
	extrn	name:near
ENDIF
ENDIF
	DW  CSOFFSET name
ELSE
	DW  ?
ENDIF
ENDM

;***	long_addr - declare far address
;
;	Declares a double word (dd) containing the address (segment,
;	offset) of the label "name." If "name" is not defined in the
;	current file, then an extrn name:near is also generated.
;
;	ENTRY:	name = a near label
;
;	EXIT:	generated a double word containing the address of
;		"name."
;
;	SEE ALSO: short_addr

long_addr   macro   name
IF2
IFNDEF name
	extrn	name:near
ENDIF
ENDIF
	DD  name
ENDM

;***	error - return error code to user
;
;	WARNING: Use is discouraged because this passes only 8-bit error
;		 code and depends on 3xbox pecularities.
;
;	Generates code to pass the error code to Sys_Ret_Err_AL
;	routine. Used by 3xbox to return error conditions to user
;	routine.
;
;	ENTRY:	code = error code (byte)
;
;	EXIT:	generated code to pass "code" to Sys_Ret_Err_AL

error macro code
	mov	al,code
	transfer Sys_Ret_Err_AL
ENDM

;***	jump - smart jump that optimizes code size but increases
;	       execution time.
;
;	WARNING: Use is strongly discouraged because of performance
;		 penalty.
;
;	This macros tries to generate a short jump (2 bytes) to "lbl".
;	It may generate a short jump to another jump that jumps to
;	"lbl". If short jump is not possible, it generates a long jump
;	(3 bytes).
;
;	ENTRY:	lbl    = jump target
;	(global variables)
;		lbl&_J = undefined - first time jump sees the label
;			 "lbl".
;		       = defined - labeled the last jump that jumps
;			 to "lbl". This may be used as the target
;			 instead of "lbl" to minimize the jump distance.
;
;	EXIT:	generated code to jump to "lbl" directly or indirectly.
;	(global variables)
;		lbl&_J = labels the current jump to "lbl".

jump	macro lbl
	local a
	ifndef lbl&_J		;; is this the first invocation
a:  JMP lbl
	ELSE
	IF (lbl&_J GE $) OR ($-lbl&_J GT 126)
a:  JMP lbl		;; is the jump too far away?
	ELSE
a:  JMP lbl&_J		;; do the short one...
	ENDIF
	ENDIF
	lbl&_J = a
endm

;***	return - return from a procedure
;
;	Generates a RET instruction. It creates a label ret_l on this
;	instruction used by the conditional returns.
;
;	EXIT:	Generated a RET instruction.
;	(global variables)
;		ret_l = label the RET instruction. This is used by the
;			conditional returns.
;
;	SEE ALSO: ret<cc> - the conditional returns

return	macro x
	local a
a:
	RET
ret_l = a
endm

;**	condret - generate code to simulate conditional returns
;
;	If a label on a previous RET instruction, ret_l, is defined,
;	and is near enough, this generates a short conditional jump
;	to that return. Else it generates a RET instruction and a
;	negative conditional jump to jump around it.
;
;	BUG BUG: The conditional jump generated may jump to a RET
;		 instruction in a previous procedure of different type
;		 (far/near) than the current one. This will cause run
;		 time error that is hard to catch. Possible solution
;		 is to have the Procedure macro do something to the
;		 ret_l symbol.
;
;	ENTRY:	cc  = conditional jump mnemonic
;		ncc = conditional jump that's opposite of "cc".
;	(global variables)
;		ret_l = if defined, labels the last RET instruction
;			generated by the return or the conditional
;			return macros.
;
;	EXIT:	code generated to simulate a conditional return that
;		returns on the same condition as "cc".
;	(global variables)
;		ret_l = either no change or labels the new RET
;			instruction generated.
;
;	SEE ALSO: ret<cc> - the conditional returns

condret macro	cc,ncc
	local	a
	ifndef	NOMESS
	if2
		%out Warning: conditional return macros are unreliable
	endif
	endif
	ifdef	ret_l		;; if ret_l is defined
	if (($ - ret_l) le 126) and ($ gt ret_l)
					;;     if ret_l is near enough then
		a:  j&cc    ret_l	;;     a: j<CC> to ret_l
		ret_&cc = a	    ;;	   define ret_<CC> to be a:
		exitm
	endif
	endif
	ifdef	ret_&cc		;; if ret_<CC> defined
	if (($ - ret_&cc) le 126) and ($ gt ret_&cc)
					;;     if ret_<CC> is near enough
		a:  j&cc    ret_&cc	;;     a: j<CC> to ret_<CC>
		ret_&cc = a	    ;;	   define ret_<CC> to be a:
		exitm
	endif
	endif
	j&ncc	a		;; j<NCC> a:
	return		    ;; return
	a:		    ;; a:
	ret_&cc = ret_l		;; define ret_<CC> to be ret_l
endm

;***	retz - return if zero
;
;	WARNING: BROKEN, may cause run time error.
;
;	Generates code to simulate a return-if-zero instruction.
;
;	BUG BUG: the conditional return generated may be of a
;		 different type (far/near) than the current
;		 procedure type. See the condret macro.
;
;	ENTRY: (global variables)
;		ret_l = if defined, labels the last RET instruction
;			generated by the return or the conditional
;			return macros.
;
;	EXIT:	code generated to simulate return if zero
;	(global variables)
;		ret_l = either no change or labels the new RET
;			instruction generated.
;
;	SEE ALSO: return, retnc, retc, retnz, condret.

retz	macro
	condret z,nz
endm

;***	retnz - return if not zero
;
;	WARNING: BROKEN, may cause run time error.
;
;	Generates code to simulate a return-if-not zero instruction. Use
;	with the return macro.
;
;	BUG BUG: the conditional return generated may be of a
;		 different type (far/near) than the current
;		 procedure type. See the condret macro.
;
;	ENTRY: (global variables)
;		ret_l = if defined, labels the last RET instruction
;			generated by the return or the conditional
;			return macros.
;
;	EXIT:	code generated to simulate return if not zero
;	(global variables)
;		ret_l = either no change or labels the new RET
;			instruction generated.
;
;	SEE ALSO: return, retnc, retc, retz, condret.

retnz	macro
	condret nz,z
endm

;***	retc - return if carry
;
;	WARNING: BROKEN, may cause run time error.
;
;	Generates code to simulate a return-if-carry instruction. Use
;	with the return macro.
;
;	BUG BUG: the conditional return generated may be of a
;		 different type (far/near) than the current
;		 procedure type. See the condret macro.
;
;	ENTRY: (global variables)
;		ret_l = if defined, labels the last RET instruction
;			generated by the return or the conditional
;			return macros.
;
;	EXIT:	code generated to simulate return if carry.
;	(global variables)
;		ret_l = either no change or labels the new RET
;			instruction generated.
;
;	SEE ALSO: return, retnc, retnz, retz, condret.

retc	macro
	condret c,nc
endm

;***	retnc - return if not carry
;
;	WARNING: BROKEN, may cause run time error.
;
;	Generates code to simulate a return-if-not carry instruction.
;	Use with the return macro.
;
;	BUG BUG: the conditional return generated may be of a
;		 different type (far/near) than the current
;		 procedure type. See the condret macro.
;
;	ENTRY: (global variables)
;		ret_l = if defined, labels the last RET instruction
;			generated by the return or the conditional
;			return macros.
;
;	EXIT:	code generated to simulate return if not carry.
;	(global variables)
;		ret_l = either no change or labels the new RET
;			instruction generated.
;
;	SEE ALSO: return, retnc, retc, retz, condret.

retnc	macro
	condret nc,c
endm

;***	LJ<cc> - Long conditional jumps
;
;	Generates code to simulate a long conditional jump. Actually
;	if the jump is backward and the distance is short, it generates
;	a short conditional jump. Forward jumps are implemented as
;	short conditional jumps around long unconditional jumps.
;
;	ENTRY:	l = jump target
;
;	EXIT:	code generated to do conditional jump.

LJE macro l
 LJ JE JNE l
endm

LJNE macro l
 LJ jne JE l
endm

LJZ macro l
 LJE l
endm

LJNZ macro l
 LJNE l
endm

LJC macro l
 LJ jc JNC l
endm

LJNC macro l
 LJ jnc JC l
endm

LJA macro l
 LJ ja JNA l
endm

LJNA macro l
 LJ jna JA l
endm

LJB macro l
 LJ jb JNB l
endm

LJNB macro l
 LJ jnb JB l
endm

LJS macro l
 LJ js JNS l
endm

LJNS macro l
 LJ jns JS l
endm

LJAE macro l
 LJ jae JNAE l
endm

LJBE macro l
 LJ jbe JNBE l
endm

LJL macro l
 LJ jl JNL l
endm

LJG macro l
 LJ jg JNG l
endm

LJLE macro l
 LJ jle JNLE l
endm

DLJE macro l
 DLJ JE JNE l
endm

DLJNE macro l
 DLJ jne JE l
endm

DLJZ macro l
 DLJE l
endm

DLJNZ macro l
 DLJNE l
endm

DLJC macro l
 DLJ jc JNC l
endm

DLJNC macro l
 DLJ jnc JC l
endm

DLJA macro l
 DLJ ja JNA l
endm

DLJNA macro l
 DLJ jna JA l
endm

DLJB macro l
 DLJ jb JNB l
endm

DLJNB macro l
 DLJ jnb JB l
endm

DLJS macro l
 DLJ js JNS l
endm

DLJNS macro l
 DLJ jns JS l
endm

DLJAE macro l
 DLJ jae JNAE l
endm

DLJBE macro l
 DLJ jbe JNBE l
endm

DLJG macro l
 DLJ jg JNG l
endm

DLJL macro l
 DLJ jl JNL l
endm

DLJLE macro l
 DLJ jle JNLE l
endm

;**	LJ - Generate long conditional jump
;
;	If target preceeds us and is in range just use a short jump
;	else if 386 instructions enabled use a 386 jump instruction,
;	else use a jump around long jump.
;
;	ENTRY:	dirop  = mnemonic of conditional jump
;		idirop = mnemonic of negative conditional jump
;		l      = jump target
;
;	EXIT:	code generated to do the conditional jump.

LJ macro dirop,idirop,l
local a
    ?lm = 1				;; assume short jmp won't do
    if (((.type l) xor 20h) and 0a0h)	;; if not defined or is external
    else				;; else is locally defined
    if (($-l) lt 124) and ($ gt l)	;; if before and within range
	?lm = 0				;; short jump was ok
	dirop short l			;; use 286 short jump
    endif
    endif
    if (?lm)		;; if external, out of range or forward reference
	ifdef MAC_NO386CODE
	    idirop a			;; generate jump around jump
	    jmp l
	a:
	else
	    .386p
	    dirop l			;; use 386 form of jump
	    CpuMode reset
	endif
    endif
endm

ifndef Debug
    Debug = 0
endif

;**	DLJ - generate conditional jump; long if Debug; else short.
;
;	If Debug is non-zero then we generate a jump around long jump,
;	else a short jump.
;
;	ENTRY:	dirop  = mnemonic of conditional jump
;		idirop = mnemonic of negative conditional jump
;		l      = jump target
;	(global variables)
;		Debug  = 0 - generate short jump
;		       = not 0 - generate long jump
;
;	EXIT:	code generated to do the conditional jump.

DLJ macro dirop,idirop,l
    if Debug
	LJ <dirop>,<idirop>,<l>
    else
	dirop short l
    endif
endm

;***	DLJMP - generate unconditional jump
;
;	If Debug is defined then generate a normal jump, else try to
;	generate a short jump even if we have to jump to a previous
;	jump (that jumps to a previous jump...).
;
;	ENTRY:	lbl    = jump target
;	(global variables)
;		Debug  = 0 - try to generate short jump
;		       = non-zero - generate normal jump
;		lbl&_J = undefined - first time jump sees the label
;			 "lbl".
;		       = defined - labeled the last jump that jumps
;			 to "lbl". This may be used as the target
;			 instead of "lbl" to minimize the jump distance.
;
;	EXIT:	generated code to jump to "lbl" directly or indirectly.
;	(global variables)
;		lbl&_J = labels the current jump to "lbl".

DLJMP macro lbl
    if Debug
	jump lbl
    else
	jmp short lbl
    endif
endm

;**	ERRNZ - generate assembly error if expr is not zero
;
;	Short hand of .errnz for people who cannot type period.
;
;	ENTRY:	expr = expression to test
;
;	EXIT:	if expr is not zero then generate assembly error

ERRNZ	macro	expr
.errnz	expr
ENDM

;*	On a 386, there is no popf bug!

POPFF	macro
	popf
endm

POPAF	macro	reg
	popf
endm

;****	SegAssert - Ensure register(s) point to specified segment
;
;	SegAssert ensures that the register(s) point(s) to the
;	specified segment. Currently, we only support tests for
;	TASKAREA and DOSGROUP, but this can be easily expanded.
;
;	Usage:	SegAssert SS,<reg[,reg]>,<message> to test for TASKAREA
;		SegAssert segname,<reg[,reg]>,<message> for any other segment
;
;	Code generated:
;		If the SELSTRICT flag is set for conditional assembly, then
;		the checking code is enabled. If this code finds that the
;		registers specified are not what they should be, then an
;		InternalError is generated.  If <message> is nonblank, it
;		will appear in the InternalError, else, a default message
;		will appear there.
;
;	ENTRY	seg	= SS for TASKAREA, groupname for any other group
;		reglist = list of regs to check for correct value
;		msg	= message to print when error found
;			  (Default used if left blank)
;
;	USES	NONE
;
;	NOTE	This macro uses AX and BX as temporary registers. Therefore,
;		they can not be used as part of reglist.

SegAssert   Macro   seg,reglist,msg
local a
ifdef SELSTRICT
irp r,<reglist>
    ifidni <r>,<ax>
	%out ****** Cannot use AX in SegAssert *****
    endif
    ifidni <r>,<bx>
	%out ****** Cannot use BX in SegAssert *****
    endif
endm

    pushf				; Save flags
    SaveReg <ax,bx>			; Save registers used in macro
    mov	    bx,seg			; BX = Segment to test for

IRP r,<reglist>
    MOV	    AX,r
    CMP	    AX,BX
    JZ	    a				; Register valid, go exit.
ENDM
IFB <msg>
    InternalError <SegAssert: Invalid>
ELSE
    InternalError <msg>
ENDIF

a:  RestoreReg <BX,AX>			; Restore temporary registers
    POPF				; Restore Flags
endif ; SELSTRICT
ENDM

;***	Assert - sanity checks (contolled by Debug switch)
;
;	WARNING: OBSOLETE as a result of not being maintained.
;
;	Generates code to check register content against expected
;	value.
;
;	ENTRY:	kind	= one of Z, NZ, ISBUF, ISCURBUF, ISSFT, ISVPB
;			  (case is significant)
;		objs	= register pair which should point to given
;			  structure for IS???; an expression for Z or NZ
;		message = message printed if assertion fails; should
;			  identify the calling routine
;	(global variables)
;		Debug
;		ShareF
;		DOSGROUP = group defined in dosseg.inc
;		TABLE	 = segment defined in dosseg.inc
;
;	EXIT:	code generated to test register value or to call other
;		routines for other kind of checks.

IF Debug
Assert	macro	kind, objs, message
	LOCAL	a,b
	IFIDN	<kind>,<Z>
	CMP objs,0
	JZ  a
	DBPRT	<>,<>,<message>
a:
	ELSE
	IFIDN	<kind>,<NZ>
	CMP objs,0
	JNZ a
	DBPRT	<>,<>,<message>
a:
	ELSE
		IFIDN	<kind>,<ISDPB>
%out ISDPB referenced... Needs to be examined (someday) and changed to ISVPB
	EXITM
		ENDIF
	PUSH	AX
		IRP obj,<objs>
	PUSH	obj
		ENDM
		IF ShareF
	MOV	AX,OFFSET b
		ELSE
	MOV	AX,OFFSET DOSGROUP:b
		ENDIF
	PUSH	AX
		ifidni	<kind>,<ISBUF>
	invoke	BUFCheck
		ENDIF
		ifidni	<kind>,<ISCURBUF>
	invoke	CURBUFCheck
		ENDIF
		ifidni	<kind>,<ISSFT>
	invoke	SFTCheck
		ENDIF
		ifidni	<kind>,<ISVPB>
	invoke	xVPBCheck
		ENDIF
	POP	AX
		IF ShareF
	JMP SHORT a
b   DB	message,0
a:
		ELSE
TABLE	segment
b   DB	message,0
TABLE	ends
		ENDIF
	ENDIF
	ENDIF
ENDM
ELSE
Assert	Macro
ENDM
ENDIF
