;       SCCSID = @(#)ioctl.inc  6.4 91/08/29
;***    IOCTL.INC - IOCTL Definitions
;

;---------------------------------------------------------------------- ;54297;
; 93Jan20 - G.L.Fulk                                                    ;54297;
; The category should be at +0Dh and the function at +0Eh.  They were   ;54297;
; backwards.                                                            ;54297;
;---------------------------------------------------------------------- ;54297;

;**     Device Driver COM Block format

IOGC    STRUC

IOGCDM  DB      size SrHead dup(?)      ; fixed header
IOGCMA  DB      ?               ; major function code                   ;54297;
IOGCMI  DB      ?               ; minor function code                   ;54297;
IOGCSI  DW      ?               ; SI contents
IOGCDI  DW      ?               ; DI contents
IOGCAD  DD      ?               ; data address

IOGC    ENDS



;**     Major and Minor Codes
;       Category(Major) and Function(Minor) Codes
;       -----------------------------------------
;
;       The Major and Minor values are each contained in a byte.
;
;
;       Category Code:
;       (Major Code)
;
;               0... ....               - Microsoft Defined
;               1... ....               - Oem/User Defined
;               .xxx xxxx               - Code
;
;       WARNING:  When adding new category codes update the MAX_CAT_CODE equ.
;
;       Function Code
;       (Minor Code)
;
;               0... ....               - Return error if unsupported
;               1... ....               - Ignore if unsupported
;               .0.. ....               - Intercepted by DOS
;               .1.. ....               - Passed to driver
;               ..0. ....               - Function sends data/commands to device
;               ..1. ....               - Function querys data/info from device
;               ...x xxxx               - Subfunction
;
;
;       Note that the "sends/querys" data bit is intended only to
;       regularize the function set.  It plays no critical role; some
;       functions may contain elements of both command and query.  The
;       convention is that such commands are defined as "sends data".

IOFUNC_SUBFUNC  equ     1Fh             ; Function code subfunction
IOFUNC_READ     equ     20h             ; Read subfunction bit
IOFUNC_DRIVER   equ     40h             ; passed to driver
IOFUNC_IGNERR   equ     80h             ; ignore if unsupported
IOCAT_USERDEF   equ     80h             ; user defined category

IOMIN_SUBFUNC   equ     1fh             ; Minor code subfunction
IOMIN_READ      equ     20h             ; Read subfunction bit
IOMIN_DRIVER    equ     40h             ; Passed to driver
IOMIN_IGNERR    equ     80h             ; Ignore if unsupported


;**     Major and Minor Codes


IOC_SE  equ      1              ; serial device control
        IOSW_RE equ     14H             ; restore the 40:0 com port area
        IOSW_ZO equ     34H             ; zero out the 40:0 com port area
        IOSW_BR equ     41H             ; set baud rate
        IOSR_BR equ     61H             ; return baud rate
        IOSW_LC equ     42h             ; set line control (stop bits, parity)
        IOSR_LC equ     62h             ; return line control
        IOSW_FI equ     03h             ; flush input (seen by DOS and driver)
        IOSW_FO equ     04h             ; flush output (seen by DOS and driver)
        IOSR_LS equ     65h             ; return current line status
        IOSW_MC equ     46h             ; return modem control
        IOSR_MC equ     66h             ; set modem control
        IOSR_MS equ     67h             ; return modem status
        IOSR_SI equ     68h             ; return # of input chars available
        IOSR_SO equ     69h             ; return # of queued output chars
        IOSW_TI equ     4ah             ; transmit immediate
        IOSW_TB equ     4bh             ; transmit "break"
        IOSW_XF equ     4ch             ; behave as if XOFF received
        IOSW_XN equ     4dh             ; behave as if XON received
        IOSW_XE equ     4eh             ; enable automatic XON/XOFF behaviour
        IOSW_XD equ     4fh             ; disable automatic XON/XOFF behaviour

IOC_TC  EQU      2              ; Terminal Control
        IOTW_KI EQU     03H             ; set keyboard intercept characters
        IOTR_KI EQU     23H             ; get keyboard intercept characters
        IOTW_VS EQU     44H             ; Set video state
        IOTR_VS EQU     64H             ; Return video state
        IOTW_SS EQU     45H             ; screen shift
        IOTR_SS EQU     66H             ; return screen shift status

IOC_SC  EQU      3              ; Screen Control
        IOSC_LS EQU     41H             ; Locate SIB
        IOSC_SS EQU     42H             ; save segment
        IOSC_RS EQU     43H             ; restore segment
        IOSC_EI EQU     44H             ; re-enable I/O
        IOSC_IS EQU     45H             ; initialize screen
        IOSC_RW EQU     47H             ; reset pop-up window
        IOSC_PW EQU     48H             ; establish pop-up window
        IOSC_DW EQU     49H             ; destroy pop-up window
        IOSC_DI EQU     4AH             ; disable I/O
        IOSC_VS EQU     4BH             ; Set/return video mode
        IOSC_SH EQU     4CH             ; Set/return screen shift
        IOSC_MS EQU     4DH             ; Set/return maximum screensegsize
        IOSC_CS EQU     4FH             ; Close Screen

IOC_KC  EQU      4              ; Keyboard Control
        IOKC_IM EQU     51H             ; Set Input Mode
        IOKC_LK EQU     41H             ; Locate KIB
        IOKC_SS EQU     42H             ; save segment
        IOKC_RS EQU     43H             ; restore segment
        IOKC_CK EQU     44H             ; change keyboard images
        IOKC_IK EQU     45H             ; initialize keyboard
        IOKC_SL EQU     06H             ; set console locus
        IOKC_RL EQU     07H             ; reset console locus
        IOKC_PK EQU     48H             ; establish pop-up keyboard
        IOKC_DK EQU     49H             ; drop pop-up keyboard
        IOKC_DI EQU     4AH             ; disable I/O
        IOKC_MS EQU     6DH             ; Return keyboard size.
        IOKC_KC EQU     6FH             ; Close Keyboard.

IOC_PC  EQU     5                       ; Printer Control
        IOLR_QJ EQU     21H             ; PRT_QUERYJOBHANDLE
        IOLW_IL EQU     41H             ; Illegal Command
        IOLW_FC EQU     42H             ; Set Frame Control (CPL, LPI)
        IOLW_RD EQU     43H             ; Set Redirection
        IOLW_IR EQU     44H             ; Set Infinite Retry
        IOLW_IC EQU     45H             ; Illegal Command
        IOLW_IP EQU     46H             ; Initialize Printer
        IOLW_J1 EQU     47H             ; Reserved OS/2-Japan
        IOLW_AF EQU     48H             ; Activate Code Page and Font
        IOLW_17 EQU     4BH             ; Set Int 17h Printing Timeout
        IOLW_MS EQU     4CH             ; Set Spooler Status
        IOLW_ST EQU     4DH             ; Set Print Job Title
        IOLW_TO EQU     4EH             ; Set Timeout Value
        IOLW_J2 EQU     4FH             ; Reserved OS/2-Japan
        IOLW_DM EQU     51H             ; Set Direct Mode Access
        IOLR_FC EQU     62H             ; Query Frame Control (CPL, LPI)
        IOLR_RD EQU     63H             ; Query Redirection
        IOLR_IR EQU     64H             ; Query Infinite Retry
        IOLR_GS EQU     66H             ; Query Printer Status
        IOLR_J1 EQU     67H             ; Reserved OS/2-Japan
        IOLR_QF EQU     69H             ; Query Code Page and Font
        IOLR_VF EQU     6AH             ; Verify Code Page and Font
        IOLR_17 EQU     6BH             ; Query Int 17h Printing Timeout
        IOLR_MS EQU     6CH             ; Query Spooler Status
        IOLR_TO EQU     6EH             ; Query Timeout Value
        IOLR_J2 EQU     6FH             ; Reserved OS/2-Japan
        IOLW_SD EQU     70H             ; PRT_SETDATATYPE
        IOLR_DM EQU     71H             ; Query Direct Mode Access

IOC_LP  EQU      6              ; light pen
;;      <undefined>

IOC_MC  EQU      7              ; mouse Control
;;      <undefined>

;IOC_PA EQU     8               ; print arbitrater
;       IOPA_SP EQU     040H            ; Set arbitrator pushout buffer
;       IOPA_EN EQU     041H            ; Enable arbitration
;       IOPA_RG EQU     042H            ; Register process as spooler


IOC_DC  EQU     8               ; disk control
        IODC_LK EQU     00H             ; Lock drive
        IODC_UL EQU     01H             ; Unlock drive
        IODC_RM EQU     02H             ; Redetermine media
        IODC_SL EQU     03H             ; Set Logical Map
        IODC_BF EQU     04H             ; Begin Format
        IODC_BR EQU     20H             ; Block removable
        IODC_GL EQU     21H             ; Get Logical Map
        IODC_PLK EQU    40H             ; Physical lock drive
        IODC_Z1 EQU     40H             ; DOS ONLY: map to function 43h ;59535;
        IODC_Z2 EQU     41H             ; DOS ONLY: map to function 44h ;59535;
        IODC_Z3 EQU     42H             ; DOS ONLY: map to function 45h ;59535;
        IODC_SP EQU     43H             ; Set device parameters
        IODC_WT EQU     44H             ; Write track
        IODC_FT EQU     45H             ; Format track
        IODC_SM EQU     46H             ; DOS ONLY: Set media ID        ;59535;
        IODC_TS EQU     47H             ; Set tray    @135221 / @189584 / 191152
        IODC_SA EQU     47H             ; DOS ONLY: Set access flag     ;59535;
        IODC_PL EQU     4CH             ; DOS ONLY: map to function 40h ;59535;
        IODC_WS EQU     4FH             ; Passthru:  Write control string @189584 / 191152
        IODC_QD EQU     5DH             ; Quiesce/Restart Diskette       ;@2410
        IODC_MS EQU     60H             ; Format track
        IODC_Z4 EQU     60H             ; DOS ONLY: map to function 63h ;59535;
        IODC_Z5 EQU     61H             ; DOS ONLY: map to function 64h ;59535;
        IODC_Z6 EQU     62H             ; DOS ONLY: map to function 65h ;59535;
        IODC_GP EQU     63H             ; Get device parameters
        IODC_RT EQU     64H             ; Read track
        IODC_VT EQU     65H             ; Verify track
        IODC_PLS EQU    66H             ; Physical Lock status
        IODC_GM EQU     66H             ; DOS ONLY: get media id        ;59535;
        IODC_TQ EQU     67H             ; Query tray   @135221 / @189584 / 191152
        IODC_GA EQU     67H             ; DOS ONLY: get access flag     ;59535;
        IODC_LM EQU     68H             ; Get Disk Mapping             @189584 / 191152
        IODC_MT EQU     68H             ; DOS ONLY: sense media type    ;59535;
        IODC_PS EQU     6CH             ; DOS ONLY: map to function 66h ;59535;
        IODC_RS EQU     6FH             ; Passthru:  Read control string @189584 / 191152
;;;;;;;;IODC_   EQU       H             ; DOS ONLY: map to function 60h ;59535;


IOC_PD  EQU     9               ; @@ Physical Disk Control
        IOPD_LK EQU     00H             ; @@ Lock physical drive
        IOPD_UL EQU     01H             ; @@ Unlock physical drive
        IOPD_ED EQU     22H             ; InstallBDS function
        IOPD_DO EQU     5FH             ; Dma Overrun function
        IOPD_RB EQU     5EH             ; @@READBACK function


IOC_MO  EQU     10              ; Monitor control
        IOMO_RE EQU     40H             ; Register
        IOMO_IO EQU     41H             ; I/O

IOC_BC  EQU     11              ; Device buffer control
        IOBC_FI EQU     01H             ; flush input
        IOBC_FO EQU     02H             ; flush output
        IOBC_MS EQU     60H             ; Query Monitor Support

IOC_SQ  EQU     12              ; Single Queue device driver

IOC_CK  EQU     13              ; CLOCK$ control
        IOCK_RD EQU     60H             ; Read CMOS bytes

MAX_CAT_CODE    EQU     13      ; the largest legal category code
                                ; change this equ as new IOCTL
                                ; categories get added

;
; Command code definitions for certain functions
;

; Category 8, Function 43 - Set Device Parameters

        IODC_SP_DEV     EQU     01H     ; Set BPB for physical device
        IODC_SP_MEDIA   EQU     02H     ; Set fake BPB for medium


;********************************;*
; CHARACTER DEVICES (PRINTERS)   ;*
;********************************;*

;RAWIO sub-functions

GET_RETRY_COUNT         EQU     65H
SET_RETRY_COUNT         EQU     45H
SET_PRINTJOB_TITLE      EQU     4DH                                     ;54297;

a_RetryCount            struc
RC_Count                dw      ?
a_RetryCount            ends
