;       SCCSID = @(#)devhlpp.inc 6.10 91/11/13
; ****************************************************************************
; *                                                                          *
; *                       IBM Confidential                                   *
; *                                                                          *
; *                 Copyright (c) IBM Corporation  1993                      *
; *                           All Rights Reserved                            *
; *                                                                          *
; ****************************************************************************

SUBTTL  DevHlpP - Private include file, not to be shipped with Toolkit

ifndef SMP
    ifndef DOSIODELAYCNT
        EXTRN           DOSIODELAYCNT:ABS
    endif

    .xlist
        include iodelay.inc
    .list
endif

; new macro for doing EOIs

DevEOI  MACRO   ByteIRQ,DevHlpEntry
        local   eoi1, eoierr, eoiexit
ifdef SMP
        mov     al,ByteIRQ
        mov     dl,DevHlp_EOI           ; end of interrupt
        call    DWORD PTR [DevHlpEntry]
else
        pushf
        mov     al,ByteIRQ          ;get IRQ level in AL
        shr     al,4                ;    sets Z flag if AL <= 15
                                    ;and sets C flag if AL is between 8 and 15

        jnz     eoierr              ;jump if IRQLevel > 15 (out of range)
        mov     al,20h
        cli
        jnc     eoi1                ;jump if IRQLevel <  8 (on primary PIC)
                                    ;  (else on slave PIC, gotta do two OUTs)
        out     0a0h,al

 ;  Delay out to port between out instructions note ax is destroyed
 ;  but it only contains 020h, so we can easily reload it
        DevIODelay ax
        mov     al,020h

eoi1:   out     020h,al
        xor     ax,ax
        popf
        clc                             ; clear carry
        jmp     eoiexit

eoierr: popf
        mov     ax,8000h
        stc
eoiexit:

endif
        ENDM
