; static char *SCCSID = "@(#)dbgapi.h   6.7 92/02/24";  
;***    DBGAPI.H - DosDebug Exported API Definitions
;*
;*      SCCSID = @(#)dbgapi.h   6.7 92/02/24
;*
;*      THIS IS AN OS/2 VERSION 2.x SPECIFIC FILE
;*
;*       IBM/Microsoft Confidential
;*
;*       Copyright (c) IBM Corporation 1987, 1998
;*       Copyright (c) Microsoft Corporation 1987, 1989
;*
;*       All Rights Reserved
;*
;*      This file defines the API interfaces for the DosDebug function.
;*
;*****************************************************************************
;*  Change                                                               Chg *
;*  Activity      Date    BY   Reason                                    Num *
;*  --------      ----    ---  -------                                   --- *
;*  DCR 1320    05/25/91  ARJ  Pack Segement Support                     001 *
;*  B723886     07/13/91  ARJ  Add CoProcessor Structure                 002 *
;*  B724733     07/14/91  ARJ  Remove PRAGMA lines caused build break    003 *
;*  DCR 1372    10/19/91  ARJ  Add Defines For IFDEF statements          004 *
;*  B729735     11/14/91  ARJ  Correct IFDEF Statement Defines (no Chg Num)  *
;*  B732889     02/14/92  ARJ  Add IFDEF for exceptions        (no Chg Num)  *
;*  DEF   80689 03/25/94  AJR  Support registration of GRESEM            010 *
;*  DEF   85764 06/29/94  AJR  Support IBMH                              011 *
;*  DEF   81953 06/29/94  AJR  Fix for MASM not working properly         012 *
;*  @198945     06/01/98  MT   Add JIT debugging support                     *
;*****************************************************************************
;  
ifndef DBG_INCL_DOSDEBUG                ;   added for IBMH support   A011   
DBG_INCL_DOSDEBUG2	EQU	1
;   added for IBMH support   A012   
endif                                   ;   added for IBMH support   A011   
ifdef DBG_INCL_DOSDEBUG2                ;   added for IBMH support   A012   
DBG_INCL_DOSDEBUG	EQU	1
;   added for IBMH support   A011   
;***ET+ uDB -   User's Debug Buffer structure
;*
;*      A pointer to a uDB is the sole parameter to DosDebug.  It
;*      contains all the information required for each DosDebug
;*      command.
;*
;  

uDB	STRUC
uDB_Pid	DD	?            ;  Debuggee Process id            
uDB_Tid	DD	?            ;  Debuggee Thread id             
uDB_Cmd	DD	?            ;  Command or Notification        
uDB_Value	DD	?          ;  Generic Data Value             
uDB_Addr	DD	?           ;  Debuggee Address               
uDB_Buffer	DD	?         ;  Debugger Buffer Address        
uDB_Len	DD	?            ;  Length of Range                
uDB_Index	DD	?          ;  Generic Identifier Index       
uDB_MTE	DD	?            ;  Module Table Entry Handle      
uDB_EAX	DD	?            ;  Register Set                   
uDB_ECX	DD	?
uDB_EDX	DD	?
uDB_EBX	DD	?
uDB_ESP	DD	?
uDB_EBP	DD	?
uDB_ESI	DD	?
uDB_EDI	DD	?
uDB_EFlags	DD	?
uDB_EIP	DD	?
uDB_CSLim	DD	?
uDB_CSBase	DD	?
uDB_CSAcc	DB	?
uDB_CSAtr	DB	?
uDB_CS	DW	?
uDB_DSLim	DD	?
uDB_DSBase	DD	?
uDB_DSAcc	DB	?
uDB_DSAtr	DB	?
uDB_DS	DW	?
uDB_ESLim	DD	?
uDB_ESBase	DD	?
uDB_ESAcc	DB	?
uDB_ESAtr	DB	?
uDB_ES	DW	?
uDB_FSLim	DD	?
uDB_FSBase	DD	?
uDB_FSAcc	DB	?
uDB_FSAtr	DB	?
uDB_FS	DW	?
uDB_GSLim	DD	?
uDB_GSBase	DD	?
uDB_GSAcc	DB	?
uDB_GSAtr	DB	?
uDB_GS	DW	?
uDB_SSLim	DD	?
uDB_SSBase	DD	?
uDB_SSAcc	DB	?
uDB_SSAtr	DB	?
uDB_SS	DW	?
uDB	ENDS
; end  
;*****************************************************************************
;*  These are the coprocessor environment and state structures            002*
;*  for use in the DBG_C_ReadCoRegs and DBG_C_WriteCoRegs Calls           002*
;*****************************************************************************
;* NOTE: The Coprocessor Structures below needs to be aligned on a byte   003*
;*        Otherwise, the structure contains erroneous information.        003*
;****************************************************************************  
; end  
;***EK+ DBG_C - DosDebug Command Numbers
;*
;*      These numbers are placed in the Cmd field of the uDB on
;*      entry to DosDebug.
;*
;*      These numbers identify which command DosDebug is requested
;*      to perform.
;*
;  
DBG_C_Null	EQU	0        ;  Null                           
DBG_C_ReadMem	EQU	1        ;  Read Word                      
DBG_C_ReadMem_I	EQU	1        ;  Read Word                      
DBG_C_ReadMem_D	EQU	2        ;  Read Word (same as 1)          
DBG_C_ReadReg	EQU	3        ;  Read Register Set              
DBG_C_WriteMem	EQU	4        ;  Write Word                     
DBG_C_WriteMem_I	EQU	4        ;  Write Word                     
DBG_C_WriteMem_D	EQU	5        ;  Write Word (same as 4)         
DBG_C_WriteReg	EQU	6        ;  Write Register Set             
DBG_C_Go	EQU	7        ;  Go                             
DBG_C_Term	EQU	8        ;  Terminate                      
DBG_C_SStep	EQU	9        ;  Single Step                    
DBG_C_Stop	EQU	10       ;  Stop                           
DBG_C_Freeze	EQU	11       ;  Freeze Thread                  
DBG_C_Resume	EQU	12       ;  Resume Thread                  
DBG_C_NumToAddr	EQU	13       ;  Object Number to Address       
DBG_C_ReadCoRegs	EQU	14       ;  Read Coprocessor Registers     
DBG_C_WriteCoRegs	EQU	15       ;  Write Coprocessor Registers    
                                        ;  16 is reserved                 
DBG_C_ThrdStat	EQU	17       ;  Get Thread Status              
DBG_C_MapROAlias	EQU	18       ;  Map read-only alias            
DBG_C_MapRWAlias	EQU	19       ;  Map read-write alias           
DBG_C_UnMapAlias	EQU	20       ;  Unmap Alias                    
DBG_C_Connect	EQU	21       ;  Connect to Debuggee            
DBG_C_ReadMemBuf	EQU	22       ;  Read Memory Buffer             
DBG_C_WriteMemBuf	EQU	23       ;  Write Memory Buffer            
DBG_C_SetWatch	EQU	24       ;  Set Watchpoint                 
DBG_C_ClearWatch	EQU	25       ;  Clear Watchpoint               
DBG_C_RangeStep	EQU	26       ;  Range Step                     
DBG_C_Continue	EQU	27       ;  Continue after an Exception    
DBG_C_AddrToObject	EQU	28       ;  Address to Object              
DBG_C_XchgOpcode	EQU	29       ;  Exchange opcode and go         
DBG_C_LinToSel	EQU	30       ;  32 to 16 conversion      A001  
DBG_C_SelToLin	EQU	31       ;  16 to 32 conversion      A001  
DBG_C_RegisterSemList	EQU	32       ;  Internal use only              
DBG_C_Attach	EQU	33       ;  Attach to Debug Process          /* @198945 */
DBG_C_Detach	EQU	34       ;  Detach to Debug Process          /* @198945 */
DBG_C_RegDebug	EQU	35       ;  Register Debugger                /* @198945 */
DBG_C_QueryDebug	EQU	36       ;  Query Currently Reg Debugger     /* @198945 */
DBG_C_LastCommand	EQU	36       ;  Highest Command Number           /* @198945 */
;***EK+ DBG_C_RegDebug - Register JIT Debug Information
;*
;*      These are the possible values which can be passed into
;*      the register routine for the per-process JIT debugger
;*      registration.
;*
;*      These values are passing through kDB_t->Value field.
;  
JIT_REG_INHERIT	EQU	00010000H                                   ;  @198945   
JIT_REG_NOINHERIT	EQU	00020000H                                   ;  @198945   
JIT_REG_DETACH	EQU	00030000H                                   ;  @198945   
JIT_REG_FG	EQU	00040000H                                   ;  @198945   
;***EK+ DBG_C_QueryDebug - Query JIT Debug Information
;*
;*      These are the possible values which can be passed into
;*      the query routine for the JIT debugger. These
;*      bits identify query operation to perform.
;*
;*      These values are passing through kDB_t->Offset field.
;  
DBGQ_JIT_GLOBAL	EQU	10000000H                                   ;  @198945   
DBGQ_JIT_PERPROC	EQU	20000000H                                   ;  @198945   
; end  
;***EK+ DBG_N - DosDebug Notification Numbers
;*
;*      These numbers are placed in the Cmd field of the uDB upon
;*      exit from DosDebug.
;*
;*      These numbers identify which DosDebug Event just occured,
;*      or whether a particular command succeeded or failed.
;*
;  
DBG_N_Success	EQU	0       ;  Command completed successfully    
DBG_N_Error	EQU	-1      ;  Error detected during command     
DBG_N_ProcTerm	EQU	-6      ;  Process exiting - ExitList done   
DBG_N_Exception	EQU	-7      ;  Exception detected                
DBG_N_ModuleLoad	EQU	-8      ;  Module loaded                     
DBG_N_CoError	EQU	-9      ;  Coprocessor not in use error      
DBG_N_ThreadTerm	EQU	-10     ;  Thread exiting - Exitlist soon    
DBG_N_AsyncStop	EQU	-11     ;  Async Stop detected               
DBG_N_NewProc	EQU	-12     ;  New Process started               
DBG_N_AliasFree	EQU	-13     ;  Alias needs to be freed           
DBG_N_Watchpoint	EQU	-14     ;  Watchpoint hit                    
DBG_N_ThreadCreate	EQU	-15     ;  New thread created                
DBG_N_ModuleFree	EQU	-16     ;  Module freed                      
DBG_N_RangeStep	EQU	-17     ;  Range Step completed              
; end  
;***ET+ TStat - Thread Status Buffer structure
;*
;*      A pointer to a TStat structure is required for the
;*      DBG_C_ThrdStat command.
;*
;*      The TStat structure returns information about a thread.
;*
;*      DbgState in the Thread Status buffer contains info about the
;*      current state of debugging, and will have one of the following
;*      values upon return :
;*
;*      DBG_D_Thawed, DBG_D_Frozen
;*
;*      TState in the Thread Status buffer contains info about the
;*      scheduling state of the thread, and will have one of the
;*      following values upon return.
;*
;*      DBG_T_Runnable, DBG_T_Suspended, DBG_T_Blocked, DBG_T_CritSec
;*
;*      TPriority in the Thread Status buffer contains the thread's
;*      base scheduling priority.  This priority will be expressed as
;*      scheduling class and delta values upon return.
;*
;  

TStat	STRUC
TS_DbgState	DB	?       ;  Thread's Debugging State        
TS_TState	DB	?         ;  Thread's Scheduler State       
TS_TPriority	DW	?      ;  Thread's Scheduler Priority    
TStat	ENDS
; end  
;***EK+ DBG_D - DbgState values
;*
;*      These are the possible values which can be returned
;*      in the DbgState field of the TStat structure. These
;*      bits identify debugging information.
;*
;  
DBG_D_Thawed	EQU	0 
DBG_D_Frozen	EQU	1 
; end  
;***EK+ DBG_T - TState values
;*
;*      These are the possible values which can be returned in
;*      the TState field of the TStat structure.  These values
;*      identify scheduler state information.
;*
;  
DBG_T_Runnable	EQU	0 
DBG_T_Suspended	EQU	1 
DBG_T_Blocked	EQU	2 
DBG_T_CritSec	EQU	3 
; end  
;***EK+ DBG_CO - Coprocessor Type Parameters
;*
;*      These are the possible values identifying the coprocessor
;*      types supported by DosDebug used when accessing the
;*      coprocessor register set.
;*
;  
DBG_CO_387	EQU	1 
; end  
;***EK+ DBG_LEN - Coprocessor Buffer Lengths
;*
;*      These are the possible values identifying the length of
;*      the coprocessor buffer when accessing the coprocessor
;*      register set.
;*
;  
DBG_LEN_387	EQU	108 
; end  
;***EK+ DBG_L - Debugging Level Parameter
;*
;*      This is the only possible value for the DBG_C_Connect command,
;*      and identifies that debugging on the 386 envoronment is desired.
;*
;  
DBG_L_386	EQU	1 
; end  
;***EK+ DBG_W - Watchpoint Scope and Type Parameters
;*
;*      These are the possible Watchpoint Scope values, as used by
;*      the DBG_C_SetWatch command.     The DBG_C_SetWatch command
;*      expects a  combination (using either an ADD or an OR) of
;*      the Scope and Type parameters to be passed as a single value.
;*
;  
;       Watchpoint Scope Parameters       
DBG_W_Global	EQU	00000001H 
DBG_W_Local	EQU	00000002H 
;       Watchpoint Type Parameters        
DBG_W_Execute	EQU	00010000H 
DBG_W_Write	EQU	00020000H 
DBG_W_ReadWrite	EQU	00030000H 
DBG_W_IOBreak	EQU	00040000H 
; end  
;***EK+ DBG_O - Object flags
;*
;*      This flag indicates whether the MTE field contains the object's
;*      MTE after a DBG_C_AddrToObject call.
;*
;  
DBG_O_OBJMTE	EQU	10000000H 
; end  
;***EK+ DBG_X - Exception chances
;*
;*      The three scenarios under which a debug exception is reported
;*      are pre-1st, 1st, and last chance. The value field of the
;*      user debug buffer will indicate which chance a given call is
;*      for. Additional parameter values will be:
;*
;*         For pre-1st chance (XCPT_BREAKPOINT):
;*              Addr   = Linear address of breakpoint
;*              Buffer = XCPT_BREAKPOINT
;*
;*         For pre-1st change (XCPT_SINGLE_STEP):
;*              Addr   = Linear address of instruction after Single Step
;*              Buffer = XCPT_SINGLE_STEP
;*
;*         For 1st chance (all exceptions):
;*              Addr   = Linear address of exception
;*              Buffer = Pointer to Exception Report Record in
;*                       Debuggee's context
;*              Len    = Pointer to Exception Context Record in
;*                       Debuggee's context
;*
;*         For Last chance (all exceptions):
;*              Addr   = Linear address of exception
;*              Buffer = Pointer to Exception Report Record in
;*                       Debuggee's context
;*              Len    = Pointer to Exception Context Record in
;*                       Debuggee's context
;*
;*         For Invalid stack notification (all exceptions)
;*              Addr   = Linear address of exception
;*              Buffer = Exception number
;  
DBG_X_PRE_FIRST_CHANCE	EQU	00000000H 
DBG_X_FIRST_CHANCE	EQU	00000001H 
DBG_X_LAST_CHANCE	EQU	00000002H 
DBG_X_STACK_INVALID	EQU	00000003H 
; end  
endif       ;       DBG_INCL_DOSDEBUG2      added for IBMH support   A012   
;***ET+ semList - List of semaphores DOSDEBUG must check.
;*
;*      This structure is composed of pointers to semaphores which
;*      DOSDEBUG must check before entering a critical section.
;*      These strucs are all linked together and anchored off the
;*      pSemListHead.
;*
;  
; 
;* DBSEM_USER_SPECIFIED must be used by subsyems (e.g. pmwin, pmgre, etc) to
;* register semaphore lists.
;* This flag must not be specified when building the kernel
;  
ifdef DBSEM_USER_SPECIFIED
DBSEM_cDEFAULT	EQU	DBSEM_USER_SPECIFIED
else
DBSEM_cDEFAULT	EQU	1             ;  Default number of dbSems in semList   
endif

dbSem	STRUC
dbSem_flags	DD	?                   ;  Flags   
dbSem_addr	DD	?                    ;  Address of semaphore structure   
dbSem_alias	DD	?                   ;  Global alias to sem struc   
dbSem	ENDS

semList	STRUC
semList_next	DD	?         ;  Pointer to the next list   
semList_count	DD	?                   ;  Count of dbSem strucs in this list   
semList_sem	DB	SIZE dbSem * DBSEM_cDEFAULT DUP (?)     ;  Variable number of dbSem strucs   
semList	ENDS
DBSEM_FSRST	EQU	00000001H        ;  Def for Fast safe ramsem w/timeout   
DBSEM_GRESEMT	EQU	00000002H        ;  Def for GRESEM            A010   
DBSEM_INVALID	EQU	80000000H        ;  This dbSem is no longer valid   
DBSEM_TYPEMASK	EQU	(DBSEM_FSRST  OR  DBSEM_GRESEMT) ;  Valid type mask A010
;  Fast safe ramsem with timeout   

FSRST	STRUC
FSRST_fs_Length	DW	?              ;  #bytes in this data structure   
FSRST_fs_Padding	DW	?             ;  padding for 32 bit alignment   
FSRST_fs_ProcID	DW	?              ;  Process ID of owner or zero   
FSRST_fs_ThrdID	DW	?              ;  Thread ID of owner or zero   
FSRST_fs_Usage	DW	?               ;  reference count   
FSRST_fs_Client	DW	?              ;  16 bit field for use by owner   
FSRST_fs_Timeout	DD	?             ;  Timeout value   
FSRST_fs_RAMSem	DD	?         ;  RAM Semaphore   
FSRST	ENDS
;  GRESEM - semaphore for 32-bit pmwin   

GRESEMT	STRUC
gresem_gs_acIdent	DB	7 DUP (?)         ;  GRESEM
gresem_gs_fcSet	DB	?              ;  386 Actual Semaphore
gresem_gs_ulProcessThread	DD	?    ;  owner process and thread id (PTid)
gresem_gs_ulNestedUseCount	DD	?   ;  # of times same PTid has accessed sem
gresem_gs_ulWaitingCount	DD	?     ;  # of PTids waiting on semaphore
gresem_gs_ulUseCount	DD	?         ;  # of times semaphore has been used
gresem_gs_ulEventHandle	DD	?      ;  Event Handle Semaphore
gresem_gs_ulCallerAddr	DD	?       ;  Semaphore Caller
GRESEMT	ENDS
; 
; Used to indicate that DosDebug owns the ram sem or gresem.
; Placed in RamSemOwner field of fs_RAMSem structure
DBG_RAMSEM_OWNED	EQU	0DBH 
DBG_GRESEM_OWNED	EQU	0DBH                                           ; A010
; end  
ifdef DBGSTRICT
; 
;*      These are flags used to display information about DosDebug.
;*
;*   0x00000000  -  Do Not Display any DeBug information (initial setting)
;*   DBGinput    -  Display Input DOSDEBUG Only (DBG32APIDebug)
;*   DBGoutput   -  Display Output DOSDEBUG Only (DBG32APIDebug)
;*   DBGXCPTo    -  Display Exceptions in DBGEXCEPTION only
;*   DBGERc      -  Display DBGER.C surroutine Flow
;*   DBGEEc      -  Display DBGEE.C surroutine Flow
;*   DBGWPc      -  Display DBGWP.C surroutine Flow
;*   DBGallinfo  -  Display ALL Debug Information
;  
DBGinput	EQU	01000000H 
DBGoutput	EQU	02000000H 
DBGXCPTo	EQU	00000010H 
DBGERc	EQU	10000000H 
DBGEEc	EQU	20000000H 
DBGWPc	EQU	40000000H 
DBGallinfo	EQU	0ffffffffH 
; end  
endif
