;       SCCSID = inc/config.inc, ibmh, r206 93/03/18

;       Change History
;
; 64012 03/16/93 BJH    Implement a permanent solution to the AT-class
;                       machines with PS/2 style CMOS

;       Format of DevConfigTbl data structure

Config  struc

Config_printers         db ?          ; number of printers
Config_serial_ports     db ?          ; number of RS-232 ports
Config_diskettes        db ?          ; number of diskette drives
Config_math_coprocessor db ?          ; math coprocessor presence:
                                      ;   0 = no math coprocessor
                                      ;   1 = math coprocessor
Config_type             db ?          ; machine type
Config_model            db ?          ; machine model
Config_primary_display  db ?          ; type of primary display adapter
                                      ;   0 = monochorome/printer
                                      ;       display adapter
                                      ;   1 = other display adapter
Config_century_location db ?          ; location of century byte if ABIOS not present   64012

Config                  ends
CENTURY_BYTE_PS2        equ     037h            ;64012
CENTURY_BYTE_AT         equ     032h            ;64012

;       Values for machine model and type bytes

Config_model_pc         equ 0ffh      ; PC

Config_model_pcxt       equ 0feh      ; PC/XT

Config_model_pcjr       equ 0fdh      ; PC jr

Config_model_286        equ 0fch      ; Machine with 286 processor
Config_type_pcat        equ 00h       ;   PC/AT
Config_type_pcat_239    equ 00h       ;   PC/AT model 239
Config_type_pcat_339    equ 01h       ;   PC/AT model 339
Config_type_pcxt_286    equ 02h       ;   XT/286
Config_type_pcrt        equ 03h       ;   PC/RT
Config_type_x1          equ 04h       ;
Config_type_x2          equ 05h       ;
Config_type_x4          equ 09h       ;

Config_model_convert    equ 0f9h      ; PC Convertible

Config_model_386        equ 0f8h      ; Machine with 386 processor
Config_type_x3          equ 00h       ;
Config_type_x5          equ 19h       ; Tortugas
Config_type_x6          equ 23h       ; Aloha
Config_type_x7          equ 30h       ; Belmont   D1488
Config_type_x8          equ 31h       ;           D1488
Config_type_x9          equ 32h       ;           D1488
Config_type_x10         equ 33h       ;           D1488
Config_type_x11         equ 34h       ;           D1488
Config_type_x12         equ 36h       ;           D1488
Config_type_x13         equ 0Eh       ; Kelso
Config_type_x14         equ 0Fh       ; Kelso
Config_type_x15         equ 4Ah       ; ValuePoint
Config_type_x16         equ 4Bh       ; ValuePoint
Config_type_x17         equ 49h       ; Cirrus    59854
Config_type_x18         equ 24h       ; Tasmania  60210
Config_type_x19         equ 4Fh       ; Willow    60571


;       Format of the memory performance map data structure              ;F/SMS
                                                                         ;F/SMS
PerfMap struc     ;               R1 = [1M,16M), R2 = [16M,4G]           ;F/SMS
                                                                         ;F/SMS
PerfMap_sig_bytes  dw 0          ; number of significant bytes following ;F/SMS
                                 ; number of 1K blocks                   ;F/SMS
PerfMap_L1         dd 0          ;     of local memory in R1             ;F/SMS
PerfMap_L2         dd 0          ;     of local memory in R2             ;F/SMS
PerfMap_S1         dd 0          ;     of system memory in R1            ;F/SMS
PerfMap_S2         dd 0          ;     of system memory in R2            ;F/SMS
PerfMap_C1         dd 0          ;     of cacheable memory in R1         ;F/SMS
PerfMap_C2         dd 0          ;     of cacheable memory in R2         ;F/SMS
PerfMap_N1         dd 0          ;     before non-system memory in R1    ;F/SMS
PerfMap_N2         dd 0          ;     before non-system memory in R1    ;F/SMS
PerfMap_Reserved   dd 8 DUP (0)  ; reserved for future use               ;F/SMS
                                                                         ;F/SMS
PerfMap           ends                                                   ;F/SMS
