;***	Physical CMOS Device (CMOS)
;
;
;	CMOS hardware constant declaration.  This includes port
;	addresses and bit fields.
;
;	Copyright (c) 1988,1989 Microsoft Corporation
;
;	MODIFICATION HISTORY
;	    04/27/89	MTS	created
;


;CMOS/RT Ports

PORT_ADDRLATCH	EQU	070h	;write-only, MSB is NMI enable
PORT_DATALATCH	EQU	071h	;read/write

;PORT_ADDRLATCH bit mask

ADDR_NMIENABLE	EQU	080h	;NMI enable bit

;CMOS/RT Register Addresses (only support read-only accesses)

ADDR_SECONDS	EQU	000h	;supported through global system info
ADDR_SECALARM	EQU	001h	;supported (always use initial value)
ADDR_MINUTES	EQU	002h	;supported through global system info
ADDR_MINALARM	EQU	003h	;supported (always use initial value)
ADDR_HOURS	EQU	004h	;supported through global system info
ADDR_HOURALARM	EQU	005h	;supported (always use initial value)
ADDR_WEEKDAY	EQU	006h	;supported through global system info
ADDR_MONTHDAY	EQU	007h	;supported through global system info
ADDR_MONTH	EQU	008h	;supported through global system info
ADDR_YEAR	EQU	009h	;supported through global system info
ADDR_STATUSA	EQU	00ah	;supported through bit by bit simulation
ADDR_STATUSB	EQU	00bh	;supported (always use initial value)
ADDR_STATUSC	EQU	00ch	;supported (always use initial value)
ADDR_STATUSD	EQU	00dh	;supported (always use initial value)

ADDR_DIAGS	EQU	00eh	;Diagnostic Status Byte
ADDR_SHUTDOWN	EQU	00fh	;Shut Down Status Byte
ADDR_FDTYPE	EQU	010h	;Floppy Disk Type Byte
ADDR_HDTYPE	EQU	012h	;Fixed Disk Type Byte
ADDR_EQUIP	EQU	014h	;Equipment Byte
ADDR_BASEMEMLO	EQU	015h	;Low byte of base memory size (in KBytes)
ADDR_BASEMEMHI	EQU	016h	;High byte of base memory size
ADDR_MEMEXPLO	EQU	017h	;Low byte of memory expansion size (in Kbytes)
ADDR_MEMEXPHI	EQU	018h	;High byte of memory expansion size
ADDR_CHECKSUMHI		EQU	02eh	;High byte of CMOS RAM checksum
ADDR_CHECKSUMLO		EQU	02fh	;Low byte of CMOS RAM checksum
ADDR_EXPMEMLO	EQU	030h	;Low byte of expansion memory size (in KBytes)
ADDR_EXPMEMHI	EQU	031h	;High byte of expansion memory size
ADDR_DATECENT	EQU	032h	;Date Century Byte (BCD value)
ADDR_INFOFLAG	EQU	033h	;Information Flag

ADDR_CMOSRAMLO	EQU	00eh	;first CMOS RAM location
ADDR_CMOSRAMHI	EQU	03fh	;last CMOS RAM location
ADDR_MASK	EQU	03fh	;CMOS RAM has only 6-bit address

;StatusA Register Bit Mask

STATUSA_UIP	EQU	080h	;update-in-progress (toggle on access)
STATUSA_DV	EQU	070h	;freq. divider (always read initial value)
STATUSA_RS	EQU	00fh	;rate selection (always read initial value)

;StatusB Register Bit Mask

STATUSB_NOUPDATE	EQU	080h   ;disable clock update cycle (always cleared)
STATUSB_PIE	EQU	040h	;Periodic Interrupt Enable (always disabled)
STATUSB_AIE	EQU	020h	;Alarm Interrupt Enable (always disabled)
STATUSB_UIE	EQU	010h	;Update-Ended Interrupt Enable(always disabled)
STATUSB_SQWE	EQU	008h	;Square Wave Enable (always disabled)
STATUSB_DM	EQU	004h	;Date Mode (always cleared i.e. BCD mode)
STATUSB_HM	EQU	002h	;Hour Mode (always set i.e. 24-hour mode)
STATUSB_DSE	EQU	001h	;Daylight Savings Enable (always disabled)

;StatusC Register Bit Mask (Read-Only)

STATUSC_IRQF	EQU	080h	;IRQ flag (always cleared)
STATUSC_PF	EQU	040h	;Periodic interrupt flag (always cleared)
STATUSC_AF	EQU	020h	;Alarm interrupt flag (always cleared)
STATUSC_UF	EQU	010h	;Update interrupt flag (always cleared)
STATUSC_RESERVED	EQU	00fh   ;reserved bits

;StatusD Register Bit Mask (Read-Only)

STATUSD_VRB	EQU	080h	;Valid RAM Bit (always set)
STATUSD_RESERVED	EQU	07fh   ;reserved bits (always cleared)

;Diagnostic Status Byte Bit Mask

DIAGS_POWERLOST		EQU	080h	;CMOS has lost power
DIAGS_CHKSUMBAD		EQU	040h	;CMOS RAM checksum bad
DIAGS_BADEQUIP	EQU	020h	;CMOS configuration does not match equipment
DIAGS_BADMEMSIZE	EQU	010h   ;CMOS memory size is wrong
DIAGS_FIXDSKERR		EQU	008h	;Drive C initialization error
DIAGS_BADTIME	EQU	004h	;Time is invalid
DIAGS_RESERVED	EQU	003h	;reserved bits

;Floppy Disk Type Byte Bit Mask
;     0000 - No drive is present
;     0001 - Double Sided Diskette Drive (48 TPI)
;     0010 - High Capacity Diskette Drive (96 TPI)
;     0011~1111 - reserved

FDTYPE_FD1	EQU	0f0h	;type of first diskette drive
FDTYPE_FD2	EQU	00fh	;type of second diskette drive

;Fixed Disk Type Byte Bit Mask
;     0000 - No fixed disk drive is present
;     0001~1110 - Fixed disk type 1~14
;     1111 - reserved

HDTYPE_HD1	EQU	0f0h	;type of first fixed disk drive
HDTYPE_HD2	EQU	0f2h	;type of second fixed disk drive

;Equipment Byte Bit Mask

EQUIP_NUMFD	EQU	0c0h	;Number of diskette drives installed
				;   00 - 1 drive  01 - 2 drives
				;   10 - reserved 11 - reserved
EQUIP_PRIVIDEO	EQU	030h	;Primary display
				;   00 - reserved
				;   01 - Color in 40 column mode
				;   10 - Color in 80 column mode
				;   11 - Mono.
EQUIP_RESERVED	EQU	00ch	;reserved bits
EQUIP_NPX	EQU	002h	;Math Coprocessor present
EQUIP_FDPRESENT		EQU	001h	;Diskette drive(s) are installed

;Information Flag Bit Mask

INFO_MEM128K	EQU	080h	;128K memory expansion option is installed
INFO_SETUP	EQU	040h	;used by setup utility
INFO_RESERVED	EQU	03fh	;reserved bits
