;       SCCSID = @(#)cdib.inc	6.1 90/11/16
;      SCCSID = @(#)cdib.inc	13.1 88/10/14

;	Codepage Data Information Block

;	Base Section

CDIB			      struc
CDIB_length		      dw  ?   ; length of the CDIB
CDIB_codepage_ptr	      dw  ?   ; offset to code page section
CDIB_country_ptr	      dw  ?   ; offset to country section
CDIB_screen_ptr		      dw  ?   ; offset to screen section
CDIB_keyboard_ptr	      dw  ?   ; offset to keyboard section
CDIB_lpt1_ptr		      dw  ?   ; offset to LPT1 section
CDIB_lpt2_ptr		      dw  ?   ; offset to LPT2 section
CDIB_lpt3_ptr		      dw  ?   ; offset to LPT3 section
CDIB			      ends

;	Code Page Section
;	This section appears once

CDIB_codepage_section	      struc
CDIB_cp_length		      dw  ?   ; length of code page section
CDIB_cp_number_codepages      dw  ?   ; number of prepared code pages
;CDIB_cp_first_id	      db  (size CDIB_cp_id_section) dup (?)
CDIB_codepage_section	      ends
CDIB_cp_first_id	      equ (CDIB_codepage_section+size CDIB_codepage_section)

;	The following 2 fields appear once for each prepared code page

CDIB_cp_id_section	      struc
CDIB_cp_id		      dw  ?   ; code page identifier
CDIB_cp_data_ptr	      dw  ?   ; offset to code page data section
CDIB_cp_id_section	      ends

;	Code Page Data Section
;	This section appears once for each prepared code page

CDIB_codepage_data_section    struc
CDIB_cpd_length		      dw  ?   ; length of codepage data section
CDIB_cpd_format_ptr	      dw  ?   ; offset to format section
CDIB_cpd_collate_ptr	      dw  ?   ; offset to collate table section
CDIB_cpd_casemap_ptr	      dw  ?   ; offset to case map table section
CDIB_cpd_DBCS_ptr	      dw  ?   ; offset to DBCS vector section
CDIB_codepage_data_section    ends

;	Format Table Section
;	This section appears once for each prepared code page

CDIB_format_section	      struc
CDIB_fmt_length		      dw  ?   ; length of format section
CDIB_fmt_date_format	      dw  ?   ; date format:
				      ;	  0 = mm/dd/yy
				      ;	  1 = dd/mm/yy
				      ;	  2 = yy/mm/dd
CDIB_fmt_currency_symbol      db  5 dup(?) ; currency symbol,
					   ; null terminated
CDIB_fmt_thousands_separator  db  2 dup(?) ; thousands separator,
					   ; null terminated
CDIB_fmt_decimal_separator    db  2 dup(?) ; decimal separator,
					   ; null terminated
CDIB_fmt_date_separator	      db  2 dup(?) ; date separator,
					   ; null terminated
CDIB_fmt_time_separator	      db  2 dup(?) ; time separator,
					   ; null terminated
CDIB_fmt_currency_format      db  ?   ; currency format flags
				      ;	  .....0.0 = currency symbol
				      ;		     preceeds money value
				      ;	  .....0.1 = currency symbol
				      ;		     follows money value
				      ;	  .....00. = zero spaces between
				      ;		     currency symbol
				      ;		     and money value
				      ;	  .....01. = one space between
				      ;		     currency symbol
				      ;		     and money value
				      ;	  .....1.. = currency symbol
				      ;		     replaces decimal
				      ;		     separator
CDIB_fmt_decimal_places	      db  ?   ; number of decimal places in
				      ; money value
CDIB_fmt_time_format	      db  ?   ; time format
				      ;	  .......0 = 12 hour
				      ;		     with "a" or "p"
				      ;	  .......1 = 24 hour
CDIB_fmt_monocase_routine     dd  ?   ; Monocase Routine
CDIB_fmt_data_list_separator  db  2 dup(?) ; data list separator,
					   ; null terminated
CDIB_fmt_reserved	      dw  5 dup(?) ; reserved
CDIB_format_section	      ends

;	Values for CDIB_fmt_date_format (date format)

CDIB_fmt_date_mmddyy	      equ 0   ;	  0 = mm/dd/yy
CDIB_fmt_date_ddmmyy	      equ 1   ;	  1 = dd/mm/yy
CDIB_fmt_date_yymmdd	      equ 2   ;	  2 = yy/mm/dd

;	Collate Table Section
;	This section appears once for each prepared code page

CDIB_collate_section	      struc
CDIB_col_length		      dw  ?   ; length of collate table section
CDIB_col_weight		      db  256 dup(?) ; weight in the collating
					     ; sequence for each ASCII
					     ; character
CDIB_collate_section	      ends

;	Case Map Table Section
;	This section appears once for each prepared code page

CDIB_casemap_section	      struc
CDIB_cm_length		      dw  ?   ; length of case map table section
CDIB_cm_data		      db  128 dup(?) ; upper case equivalent for
					     ; each ASCII chracter from
					     ; 80h to FFh
CDIB_casemap_section	      ends

;	DBCS Environment Vector Section
;	This section appears once for each prepared code page

CDIB_DBCS_section	      struc
CDIB_DBCS_length	      dw  ?   ; length of DBCS vector section
;CDIB_DBCS_first_range	      db  (size CDIB_DBCS_range_section) dup (?)
CDIB_DBCS_section	      ends
CDIB_DBCS_first_range	      equ     (CDIB_DBCS_section+size CDIB_DBCS_section)

;	The following field appears once for each DBCS range:

CDIB_DBCS_range_section	      struc
CDIB_DBCS_start		      db  ?   ; start of range
CDIB_DBCS_end		      db  ?   ; end of range
CDIB_DBCS_range_section	      ends

;	Country Section
;	This section appears only once

CDIB_country_section	      struc
CDIB_ct_length		      dw  ?   ; length of country section
CDIB_ct_code		      dw  ?   ; country code
CDIB_ct_filename	      db 128 dup(?) ; name of country information
					    ; file
CDIB_country_section	      ends

;	Device Section
;	This section appears once for each device (screen, keyboard,
;	LPT1, LPT2, and LPT3) for which a DEVINFO= statement was
;	specified in the CONFIG.SYS file

CDIB_device_section	      struc
CDIB_dev_length		      dw  ?   ; length of device section
CDIB_dev_subtype	      db  8 dup(?) ; subtype
CDIB_dev_filename_ptr	      dw  ?   ; offset to font file name
CDIB_dev_number_ROM_fonts     dw  ?   ; number of ROM resident fonts
;CDIB_dev_first_ROM_font      db  (size CDIB_dev_ROM_font_section) dup (?)
CDIB_device_section	      ends

;	The following 2 fields appear once for each ROM resident font:

CDIB_dev_ROM_font_section     struc
CDIB_dev_ROM_codepage	      dw  ?   ; code page identifier
CDIB_dev_ROM_font	      dw  ?   ; font identifier
CDIB_dev_ROM_font_section     ends

;	The following field follows the ROM resident font definitions:

CDIB_dev_filename_section     struc
CDIB_dev_filename	      db  128 dup(?) ; font file name
CDIB_dev_filename_section     ends
