;SCCSID = @(#)bvsparms.inc	6.4 91/08/01
;STJFMT,,16                             ;Formatting parms for STJFMT
; ****************************************************************************
; *                                                                          *
; *                       IBM/Microsoft Confidential                         *
; *                                                                          *
; *                 Copyright (c) IBM Corporation  1987, 1990                *
; *                 Copyright (c) Microsoft Corp.  1987, 1990                *
; *                           All Rights Reserved                            *
; *                                                                          *
; ****************************************************************************

; Parameter list used by all BVS routines

ParmList        STRUC                   ;Stack frame used by all BVS routines

; Space reserved for the VDH parameter list by BVSMAIN

vp_parmlength   dw      ?               ;ParmList length (=8 by BVSMAIN)
vp_flags        dw      ?               ;Flags           (=0 by BVSMAIN)
vp_offset       dw      ?               ;Offset of data buffer   (if any)
vp_selector     dw      ?               ;Selector of data buffer (if any)
vp_parm1        dw      ?               ;1st variable VDH parameter
vp_parm2        dw      ?               ;2nd variable VDH parameter
vp_parm3        dw      ?               ;3rd variable VDH parameter
vp_parm4        dw      ?               ;4th variable VDH parameter
vp_parm5        dw      ?               ;5th variable VDH parameter
vp_parm6        dw      ?               ;6th variable VDH parameter
vp_parm7        dw      ?               ;7th variable VDH parameter
vp_parm8        dw      ?               ;8th variable VDH parameter
vp_parm9        dw      ?               ;9th variable VDH parameter
vp_parm10       dw      ?               ;10th variable VDH parameter
vp_parm11       dw      ?               ;11th variable VDH parameter
vp_parm12       dw      ?               ;12th variable VDH parameter
vp_parm13       dw      ?               ;13th variable VDH parameter
vp_parm14       dw      ?               ;14th variable VDH parameter
vp_parm15       dw      ?               ;15th variable VDH parameter
vp_parm16       dw      ?               ;16th variable VDH parameter
vp_parm17       dw      ?               ;17th variable VDH parameter
vp_parm18       dw      ?               ;18th variable VDH parameter
vp_parm19       dw      ?               ;19th variable VDH parameter
vp_parm20       dw      ?               ;20th variable VDH parameter ;D261

; Registers saved for all BVS routines by BVSMAIN

;*********  MUST MATCH oldstackframe Struc in BVSCB.INC ***********************
;*********  if the following structure changes, then BVSCB.INC needs to be    *
;*********  updated and the statement below may need to change also           *
;*********  'lea     bp,[si].p_regfs' in EXTVIO (wdhmain.asm)        **********

p_regfs         dw      ?               ;Reg FS save area ;@D549
p_reges         dw      ?               ;Reg ES save area
p_regds         dw      ?               ;Reg DS save area
p_regdi         dw      ?               ;Reg DI save area
p_regsi         dw      ?               ;Reg SI save area
p_regbp         dw      ?               ;Reg BP save area
p_regsp         dw      ?               ;Reg SP save area
p_regbx         dw      ?               ;Reg BX save area
p_regdx         dw      ?               ;Reg DX save area
p_regcx         dw      ?               ;Reg CX save area
p_regax         dw      ?               ;Reg AX save area
p_regfl         dw      ?               ;Reg FL save area ;D198

; Parameters on stack at entry to BVSMAIN

p_vioroutip     dw      ?               ;VIOROUT return offset
p_vioroutcs     dw      ?               ;VIOROUT return selector
p_vioroutds     dw      ?               ;VIOROUT data selector
p_vioip         dw      ?               ;VIOxxx return offset
p_viofunc       dw      ?               ;VIOxxx Function code
p_userip        dw      ?               ;User return offset
p_usercs        dw      ?               ;User return segment
p_viohandle     dw      ?               ;Vio Device Handle
p_parmn         dw      ?               ;Nth parameter
p_parmnm1       dw      ?               ;(N-1)st parameter
p_parmnm2       dw      ?               ;(N-2)nd parameter
p_parmnm3       dw      ?               ;(N-3)rd parameter
p_parmnm4       dw      ?               ;(N-4)th parameter
p_parmnm5       dw      ?               ;(N-5)th parameter
p_parmnm6       dw      ?               ;(N-6)th parameter
p_parmnm7       dw      ?               ;(N-7)th parameter
p_parmnm8       dw      ?               ;(N-8)th parameter
p_parmnm9       dw      ?               ;(N-9)th parameter

ParmList        ENDS

; Stack frame used by all VDH routines

p_vdh_retaddr   equ     p_vioroutip     ;Return Address ;D198
p_vdh_function  equ     p_vioroutds     ;Function Number ;D198
p_vdh_parmblock equ     p_viofunc       ;Parameter Block Address ;D198
p_vdh_envblock  equ     p_usercs        ;Environment Block Address ;D198

; Equates used by most BVS routines or initialization

p_offset        equ     p_parmn         ;Offset of parameter block
p_selector      equ     p_parmnm1       ;Selector of parameter block

vp_f_physical   equ     0001h           ;Update physical buffer/hardware
vp_f_3xBox      equ     0002h           ;Initialize the 3xBox ;D198

; Values for VioFunc, set by VioCalls

vf_GetPhysBuf   equ     00h             ;00 = VioGetPhysBuf
vf_GetBuf       equ     01h             ;01 = VioGetBuf
vf_ShowBuf      equ     02h             ;02 = VioShowBuf
vf_GetCurPos    equ     03h             ;03 = VioGetCurPos
vf_GetCurType   equ     04h             ;04 = VioGetCurType
vf_GetMode      equ     05h             ;05 = VioGetMode
vf_SetCurPos    equ     06h             ;06 = VioSetCurPos
vf_SetCurType   equ     07h             ;07 = VioSetCurType
vf_SetMode      equ     08h             ;08 = VioSetMode
vf_ReadCharStr  equ     09h             ;09 = VioReadCharStr
vf_ReadCellStr  equ     0Ah             ;10 = VioReadCellStr
vf_WrtNChar     equ     0Bh             ;11 = VioWrtNChar
vf_WrtNAttr     equ     0Ch             ;12 = VioWrtNAttr
vf_WrtNCell     equ     0Dh             ;13 = VioWrtNCell
vf_WrtCharStr   equ     0Eh             ;14 = VioWrtCharStr
vf_WrtCharStrAtt equ    0Fh             ;15 = VioWrtCharStrAtt
vf_WrtCellStr   equ     10h             ;16 = VioWrtCellStr
vf_WrtTTY       equ     11h             ;17 = VioWrtTTY
vf_ScrollUp     equ     12h             ;18 = VioScrollUp
vf_ScrollDn     equ     13h             ;19 = VioScrollDn
vf_ScrollLf     equ     14h             ;20 = VioScrollLf
vf_ScrollRt     equ     15h             ;21 = VioScrollRt
vf_SetAnsi      equ     16h             ;22 = VioSetAnsi
vf_GetAnsi      equ     17h             ;23 = VioGetAnsi
vf_PrtSc        equ     18h             ;24 = VioPrtSc
vf_Save2        equ     19h             ;25 = VioSave2
vf_Restore2     equ     1Ah             ;26 = VioRestore2
vf_Free2        equ     1Bh             ;27 = VioFree2
vf_TogglePrtSc  equ     1Fh             ;31 = VioTogglePrtSc
vf_GetFont      equ     22h             ;34 = VioGetFont
vf_GetConfig    equ     23h             ;35 = VioGetConfig
vf_SetCP        equ     24h             ;36 = VioSetCP
vf_GetCP        equ     25h             ;37 = VioGetCP
vf_SetFont      equ     26h             ;38 = VioSetFont
vf_GetState     equ     27h             ;39 = VioGetState
vf_SetState     equ     28h             ;40 = VioSetState
vf_CreateCA     equ     2Ch             ;44 = XVioCreateCA
vf_GetCAState   equ     2Dh             ;45 = XVioGetCAState
vf_SetCAState   equ     2Eh             ;46 = XVioSetCAState
vf_DestroyCA    equ     2Fh             ;47 = XVioDestroyCA
vf_CheckCharType equ    30h             ;48 = VioCheckCharType/XVioCheckCharType
vf_Save         equ     41h             ;65 = VioSave
vf_Restore      equ     42h             ;66 = VioRestore
vf_Free         equ     43h             ;67 = VioFree
vf_ShellInit    equ     44h             ;68 = VioShellInit
vf_NextAvail    equ     31h             ;49 = Next Available Base Vio

vf_AssociateDC  equ     50h             ;80 = VioAssociate
vf_CreatePS     equ     51h             ;81 = Create Presentation Space
vf_DeleteSetId  equ     52h             ;82 =
vf_DestroyPS    equ     53h             ;83 = Destroy Presentation Space
vf_GetDevCellSz equ     54h             ;84 =
vf_GetOrg       equ     55h             ;85 =
vf_CreateLogFont equ    56h             ;86 =
vf_QuerySetIds  equ     57h             ;87 =
vf_QueryFonts   equ     58h             ;88 =
vf_SetDevCellSz equ     59h             ;89 =
vf_SetOrg       equ     5Ah             ;90 =
vf_ShowPS       equ     5Bh             ;91 =
vf_GetPSAddress equ     5Ch             ;92 =

vf_ShieldInit   equ     60h             ;96 =
vf_ShieldTerm   equ     61h             ;97 =
vf_QueryConsole equ     62h             ;98 =

; Function Numbers for VDH Routines

fn_BufferUpdate equ     100h            ;256 = Text Buffer Update
fn_InitEnv      equ     101h            ;257 = Initialize Environment
fn_SaveEnv      equ     102h            ;258 = Save Environment
fn_RestoreEnv   equ     103h            ;259 = Restore Environment
fn_GetConfig    equ     104h            ;260 = Return Config Info
fn_GetDBCSInfo  equ     105h            ;261 = Get DBCS Display Info
fn_GetCLUT      equ     106h            ;262 = Get Color Lookup Table
fn_SetCLUT      equ     107h            ;263 = Set Color Lookup Table
fn_GetCursor    equ     108h            ;264 = Get Cursor Info
fn_SetCursor    equ     109h            ;265 = Set Cursor Info
fn_GetFont      equ     10Ah            ;266 = Get Font
fn_SetFont      equ     10Bh            ;267 = Set Font
fn_GetMode      equ     10Ch            ;268 = Get Mode
fn_SetMode      equ     10Dh            ;269 = Set Mode
fn_GetPalette   equ     10Eh            ;270 = Get Palette Registers
fn_SetPalette   equ     10Fh            ;271 = Set Palette Registers
fn_GetPhysBuf   equ     110h            ;272 = Get Phys Buf
fn_FreePhysBuf  equ     111h            ;273 = Free Phys Buf
fn_GetVarInfo   equ     112h            ;274 = Get Variable Info
fn_SetVarInfo   equ     113h            ;275 = Set Variable Info
fn_ExtVIO       equ     114h            ;276 = Extended VIO Calls
fn_PrintScreen  equ     115h            ;277 = Print Screen ;D198
fn_WriteTTY     equ     116h            ;278 = Write TTY ;D198
fn_GetLVBInfo   equ     117h            ;279 = Get LVB Info
fn_GetState     equ     118h            ;280 = get video state          ;D811
fn_SetState     equ     119h            ;281 = set video state          ;D811
fn_NextAvail    equ     11Ah            ;282 = Next Available Func. #   ;D811

; Additional VDH Buffer Update parameters

vp_secondoff    equ     vp_parm1        ;Offset of second data item
vp_secondsel    equ     vp_parm2        ;Selector of second data item
vp_index        equ     vp_parm3        ;Index of subroutine (see x_* below)
vp_startrow     equ     vp_parm4        ;Starting row
vp_startcol     equ     vp_parm5        ;Starting column
vp_secondrow    equ     vp_parm6        ;Second row
vp_secondcol    equ     vp_parm7        ;Second column
vp_repeatlength equ     vp_parm8        ;Repeat factor or length of string
vp_lvbsel       equ     vp_parm9        ;Selector of Logical Buffer
vp_touchxleft   equ     vp_parm10       ;Left most column affected by write
vp_touchytop    equ     vp_parm11       ;Top most row affected by write
vp_touchxright  equ     vp_parm12       ;Left most column affected by write
vp_touchybottom equ     vp_parm13       ;Bottom most row affected by write
vp_lvbrowoff    equ     vp_parm14       ;Screen row offset of LVB in cells
vp_lvbcoloff    equ     vp_parm15       ;Screen row offset of LVB in cells
vp_lvbwidth     equ     vp_parm16       ;Width of LVB in cells
vp_lvbheight    equ     vp_parm17       ;Height of LVB in cells
vp_lvbfidattr   equ     vp_parm18       ;Format ID and attribute count of LVB

vp_f_logical    equ     0002h           ;Update logical buffer/hardware
vp_f_attrxlate  equ     0004h           ;Attribute translation required

; Indexes for VDH Buffer Update subroutines

sx_ReadCellTypes equ    0
sx_ReadCharStr  equ     1
sx_ReadCellStr  equ     2
sx_ScrollUp     equ     3
sx_ScrollDn     equ     4
sx_ScrollLf     equ     5
sx_ScrollRt     equ     6
sx_WriteCellStr equ     7
sx_WriteCharStr equ     8
sx_WriteCharStrAtt equ  9
sx_WriteNChar   equ     10
sx_WriteNAttr   equ     11
sx_WriteNCell   equ     12
sx_CopyRect     equ     13

; Additional VDH Variable Info parameters

vp_blink        equ     vp_offset       ;Blink state
vp_border       equ     vp_selector     ;Border color
vp_underscore   equ     vp_parm1        ;Underscore line
vp_enable       equ     vp_parm2        ;Video Enable/Disable state
vp_dispmask1    equ     vp_parm3        ;Display mask (bits 0-15)
vp_dispmask2    equ     vp_parm4        ;Display mask (bits 16-31)
vp_codepage     equ     vp_parm5        ;Codepage
vp_scrlleft     equ     vp_parm6        ;Video Enable/Disable state
vp_scrltop      equ     vp_parm7        ;Display mask (bits 0-15)
vp_scrlright    equ     vp_parm8        ;Display mask (bits 16-31)
vp_scrlbottom   equ     vp_parm9        ;Codepage
vp_scrnrows     equ     vp_parm10       ;Video Enable/Disable state
vp_scrncols     equ     vp_parm11       ;Display mask (bits 0-15)
vp_videopage    equ     vp_parm12       ;Current video page             @C32

vp_f_blink      equ     0002h           ;Blink state requested
vp_f_border     equ     0004h           ;Border color requested
vp_f_underscore equ     0008h           ;Underscore requested
vp_f_enable     equ     0010h           ;Video Enable/Disable requested
vp_f_dispmask   equ     0020h           ;Display Mask requested
vp_f_codepage   equ     0040h           ;Codepage requested
vp_f_forcecp    equ     0080h           ;Force Codepage set (change DBCS mode)
vp_f_scrlrect   equ     0100h           ;Scrollable rectangle
vp_f_scrndim    equ     0200h           ;Actual screen dimensions

;Equates for Bvs?etAnsi routines

ansi_parm       equ     p_parmn         ;New value for the ansi_on flag

;Equates used by BvsGetBuf routine

gb_offset       equ     p_parmnm2       ;Offset of address ptr
gb_selector     equ     p_parmnm3       ;Selector of address ptr

;Equates used by BvsGetConfig routine

gc_confignum    equ     p_parmnm2       ;Requested config number

configdata      struc
cf_length       dw      40              ;Length of control block (=40) ;@BB7
cf_adapter      dw      0               ;Adapter type
cf_display      dw      0               ;Display type
cf_memory       dd      0               ;Memory on adapter
cf_confignum    dw      0               ;Configuration number
cf_version      dw      0               ;VDH version number
cf_flags        dw      0               ;Flags
cf_envsize      dd      0               ;Environment Buffer size
cf_fullsize     dd      0               ;Full save size
cf_partsize     dd      0               ;Partial save size
cf_adapteroff   dw      0               ;Offset to emulated adapters
cf_displayoff   dw      0               ;Offset to emulated displays
;Following fields are in default location only
cf_lemadapterdata  dw      1            ;Length of emulated adapter data (words) ;@BB7
cf_emadapters      dw      0            ;Emulated adapters
cf_lemdisplaydata  dw      1            ;Length of emulated display data (words) ;@BB7
cf_emdisplays      dw      0            ;Emulated displays
configdata      ends

cf_a_mpa        equ     0               ;Adapter type = MPA
cf_a_cga        equ     1               ;Adapter type = CGA
cf_a_ega        equ     2               ;Adapter type = EGA
cf_a_vga        equ     3               ;Adapter type = VGA
cf_a_8514a      equ     7               ;Adapter type = 8514A
cf_a_xga        equ     9               ;Adapter type = XGA             ;@T72

cf_af_mpa       equ     0001h           ;Adapter type flag = MPA
cf_af_cga       equ     0002h           ;Adapter type flag = CGA
cf_af_ega       equ     0004h           ;Adapter type flag = EGA
cf_af_vga       equ     0008h           ;Adapter type flag = VGA
cf_af_8514a     equ     0080h           ;Adapter type flag = 8514A
cf_af_xga       equ     0200h           ;Adapter type flag = XGA        ;@T72f

cf_d_mono       equ     0               ;Display type = Monochrome
cf_d_color      equ     1               ;Display type = Color
cf_d_ecolor     equ     2               ;Display type = Enhanced Color
cf_d_vmono      equ     3               ;Display type = VGA Monochrome
cf_d_vcolor     equ     4               ;Display type = VGA Color
cf_d_8514       equ     9               ;Display type = 8514
cf_d_plasma     equ     10              ;Display type = Plasma
cf_d_8507_8604  equ     11              ;Display type = 8507/8604 ;D184
cf_d_8515       equ     12              ;Display type = 8515 ;D184

cf_df_mono      equ     0001h           ;Display type flag = Monochrome
cf_df_color     equ     0002h           ;Display type flag = Color
cf_df_ecolor    equ     0004h           ;Display type flag = Enhanced Color
cf_df_vmono     equ     0008h           ;Display type flag = VGA Monochrome
cf_df_vcolor    equ     0010h           ;Display type flag = VGA Color
cf_df_8514      equ     0200h           ;Display type flag = 8514
cf_df_plasma    equ     0400h           ;Display type flag = Plasma
cf_df_8507_8604 equ     0800h           ;Display type flag = 8507/8604 ;D184
cf_df_8515      equ     1000h           ;Display type flag = 8515 ;D184

;Equates for Bvs?etCP routines

cp_cpid         equ     p_parmn         ;New code page id

;Equates for Bvs?etCur* routines

c_col           equ     p_parmn         ;Column
c_row           equ     p_parmnm1       ;Row
c_coloff        equ     p_parmn         ;Offset of column
c_colsel        equ     p_parmnm1       ;Selector of column
c_rowoff        equ     p_parmnm2       ;Offset of row
c_rowsel        equ     p_parmnm3       ;Selector of row

vp_f_curpos     equ     0002h           ;Cursor position request
vp_f_curtype    equ     0004h           ;Cursor type request

vp_c_row        equ     vp_offset       ;Row of cursor
vp_c_col        equ     vp_selector     ;Column of cursor
vp_c_startline  equ     vp_parm1        ;Starting scan line of cursor
vp_c_endline    equ     vp_parm2        ;Ending scan line of cursor
vp_c_width      equ     vp_parm3        ;Width of cursor
vp_c_attr       equ     vp_parm4        ;Attribute of cursor

cursordata      STRUC                   ;Cursor data structure
cursor_start    dw      0               ;Current cursor start line
cursor_end      dw      0               ;Current cursor end line
cursor_width    dw      0               ;Current cursor width
cursor_attr     dw      0               ;Current cursor attribute
cursordata      ENDS

;Parameter block passed to Bvs?etFont

fontparms       STRUC
fp_rblength     dw      14              ;Length of request block (=14)
fp_reqtype      dw      0               ;Request type
fp_cols         dw      0               ;Character pel columns
fp_rows         dw      0               ;Character pel rows
fp_offset       dw      0               ;Offset of Font
fp_selector     dw      0               ;Selector of Font
fp_length       dw      0               ;Length of Font
fontparms       ENDS

vp_fp_length    equ     vp_parm1        ;Font length
vp_fp_cols      equ     vp_parm2        ;# columns per character
vp_fp_rows      equ     vp_parm3        ;# rows per character

;Equates used by BvsFree routine

fr_sgnum        equ     p_viohandle     ;Screen group to be freed

;Equates used by GetLVBInfo

vp_li_fidatt    equ     vp_offset       ;Format ID/Attribute Count
vp_li_width     equ     vp_selector     ;Width of the LVB
vp_li_height    equ     vp_parm1        ;Height of the LVB
vp_li_allocl    equ     vp_parm2        ;Low word of the LVB allocation size
vp_li_alloch    equ     vp_parm3        ;High word of the LVB allocation size
vp_li_attrsize  equ     vp_parm4        ;Byte of space for the default attribute
vp_li_attroffst equ     vp_parm5        ;Offset of default attribute buffer
vp_li_attrseg   equ     vp_parm6        ;Segment of default attribute buffer

;Equates used by GetDBCSInfo

vp_di_tbllen    equ     vp_offset       ;length of the table
vp_di_tbloff    equ     vp_selector     ;offset to the beginning of the table
vp_di_codepage  equ     vp_parm1        ;Beginning of table
vp_di_table     equ     vp_parm2        ;Beginning of table
di_tblbuflen    equ     vp_parm19-vp_parm1 ;Number of bytes for table
di_totallen     equ     vp_parm19-vp_parmlength+2 ;# of bytes in parm block

;Equates used by Bvs?etMode routines

modedata        STRUC                   ;Mode data structure
mode_datalen    dw      34              ;Length of mode data (=34)
mode_type       db      0               ;Type for Mode
mode_colors     db      0               ;Colors for Mode
mode_cols       dw      0               ;Number of screen columns for text
mode_rows       dw      0               ;Number of screen rows for text
mode_gcols      dw      0               ;Number of screen columns for graphics
mode_grows      dw      0               ;Number of screen rows for graphics
mode_attrformat db      0               ;Attribute format
mode_attrbytes  db      0               ;Number of attribute bytes
mode_bufaddr    dd      0               ;Address of video buffer
mode_bufsize    dd      0               ;Size of video buffer
mode_fullbufsz  dd      0               ;Full buffer save size
mode_partbufsz  dd      0               ;Partial buffer save size
mode_extdata    dd      0               ;Extended mode data address
modedata        ENDS

;Mode type flags

mode_f_color    equ     001h            ;Color display flag
mode_f_graphics equ     002h            ;Graphics flag
mode_f_uncolor  equ     004h            ;Suppress color
mode_f_afmode   equ     008h            ;Advance Function mode

;Equates for BvsGetPhysBuf

physdata        STRUC                   ;PhysBuf Control Block
pd_bufaddrl     dw      0               ;Low word of buffer address
pd_bufaddrh     dw      0               ;High word of buffer address
pd_buflenl      dw      0               ;Low word of buffer length
pd_buflenh      dw      0               ;High word of buffer length
pd_prisel       dw      0               ;Primary buffer selector
pd_secsel       dw      0               ;Secondary buffer selector
physdata        ENDS

physblock       STRUC                   ;PhysBuf Control Block
pb_length       dw      4               ;Length of this data
pb_selector     dw      0               ;First selector in the list
physblock       ENDS

vp_fpb_selector equ     vp_offset       ;Selector to be freed by VDH

;Equates for BvsPrtSc routine

vp_pr_lvbsel    equ     vp_offset       ;LVB selector ;D198
vp_pr_handle    equ     vp_selector     ;Printer handle ;D198

;Equates for BvsRead* routines

r_col           equ     p_parmn         ;Column
r_row           equ     p_parmnm1       ;Row
r_lenoff        equ     p_parmnm2       ;Offset of Length
r_lensel        equ     p_parmnm3       ;Selector of Length
r_stroff        equ     p_parmnm4       ;Offset of String
r_strsel        equ     p_parmnm5       ;Selector of String

;Equates for BvsCheckCharType routine

ct_col          equ     p_parmn         ; column of cell to be examined
ct_row          equ     p_parmnm1       ; row of cell to be examined
ct_typeoff      equ     p_parmnm2       ; offset of type return buffer address
ct_typesel      equ     p_parmnm3       ; segment of type return buffer address

;Equates used by BvsSave/Restore routines

sr_type         equ     p_viohandle     ;Type of save/restore
sr_sgnum        equ     p_parmn         ;Screen group to be saved/restored

sr_f_popup      equ     0001h           ;Popup type flag

vp_f_hardware   equ     0002h           ;Hardware state to be saved/restored
vp_f_full       equ     0004h           ;Full buffer save/restore
vp_f_partial    equ     0008h           ;Partial buffer save/restore
vp_f_saveVDM    equ     0010h           ;MVDM save                      @C39
not_readable_hardware   equ     0FFFFh  ;Special saveenv return code    @C39

vp_sr_lvbsel    equ     vp_offset       ;First selector of huge LVB

;Equates used by BvsScroll* routines

s_celloff       equ     p_parmn         ;Offset of fill Cell
s_cellsel       equ     p_parmnm1       ;Selector of fill Cell
s_times         equ     p_parmnm2       ;Number of times to scroll
s_rightcol      equ     p_parmnm3       ;Rightmost column of window
s_botrow        equ     p_parmnm4       ;Bottom row of window
s_leftcol       equ     p_parmnm5       ;Leftmost column of window
s_toprow        equ     p_parmnm6       ;Top row of window

;Equates used by BvsShowBuf routine

sb_length       equ     p_parmn         ;Length of data to show
sb_offset       equ     p_parmnm1       ;Starting offset in LVB

;Parameter block passed to Bvs?etState

stateparms      STRUC
sp_rblength     dw      12              ;Request block length (=12)
sp_reqtype      dw      0               ;Request type
sp_data         dw      0               ;Data word
sp_palregs      dw      0               ;First palette register
sp_offset       dw      0               ;Offset of data area
sp_selector     dw      0               ;Selector of data area
stateparms      ENDS

sp_firstreg     equ     sp_data         ;Index of first register
sp_numregs      equ     sp_palregs      ;Number of registers
sp_dispmask1    equ     sp_data         ;Display mask (bits 0-15)
sp_dispmask2    equ     sp_palregs      ;Display mask (bits 16-31)
sp_oemoffset    equ     sp_data         ;OEM defined data offset        ;D811
sp_oemselector  equ     sp_palregs      ;OEM defined data selector      ;D811

STATE_OEMFUNCTIONS      EQU  8000h      ;Get/Setstate user defined func ;D811

vp_sp_index     equ     vp_parm1        ;Index of first register
vp_sp_number    equ     vp_parm2        ;Number of registers

;Equates for the BvsWrtTTY routine

tty_length      equ     p_parmn         ;Length of String
tty_stroff      equ     p_parmnm1       ;Offset of String
tty_strsel      equ     p_parmnm2       ;Selector of String

vp_tt_lvbsel    equ     vp_offset       ;LVB selector ;D198
vp_tt_offset    equ     vp_selector     ;Offset of string ;D198
vp_tt_selector  equ     vp_parm1        ;Selector of string ;D198
vp_tt_length    equ     vp_parm2        ;Length of string ;D198
vp_tt_handle    equ     vp_parm3        ;Printer handle ;D198

vp_f_ansi       equ     0004h           ;ANSI active ;D198
vp_f_ctrlprtsc  equ     0008h           ;Ctrl-PrtSc active ;D198

;Equates for the BvsWrtCharStrAtt routine

wa_attroff      equ     p_parmn         ;Offset of Attribute
wa_attrsel      equ     p_parmnm1       ;Selector of Attribute
wa_col          equ     p_parmnm2       ;Starting column
wa_row          equ     p_parmnm3       ;Starting row
wa_length       equ     p_parmnm4       ;Number of bytes to write
wa_stroff       equ     p_parmnm5       ;Offset of Item
wa_strsel       equ     p_parmnm6       ;Selector of Item

;Equates for other BvsWrt* routines

w_col           equ     p_parmn         ;Starting column
w_row           equ     p_parmnm1       ;Starting row
w_times         equ     p_parmnm2       ;Number of times to write
w_length        equ     p_parmnm2       ;Number of bytes to write
w_stroff        equ     p_parmnm3       ;Offset of Item
w_strsel        equ     p_parmnm4       ;Selector of Item

;Equates for Extended VIO Calls

vp_ev_selector  equ     vp_offset       ;Selector of Global data segment
vp_ev_session   equ     vp_selector     ;Session number

;Structure passed to BvsCreateCA

CAB             STRUC
cab_length      dw      size CAB
cab_Srow        dw      ?               ; starting row
cab_Scol        dw      ?               ; starting col
cab_rows        dw      ?               ; number of rows
cab_cols        dw      ?               ; number of cols
cab_option      dw      ?               ; options
cab_formatID    db      ?               ; attribute formatId
cab_attrcount   db      ?               ; attribute count
CAB             ENDS

CABMIN          equ     10              ; minmum size of a CA Block
CABOPTION       equ     12              ; minmum size of a CA Block with options
CABFORMAT       equ     13              ; minmum size of a CA Block with format ID
CABATTRCOUNT    equ     14              ; minmum size of a CA Block with attr count
CABMAX          equ     size CAB        ; maximum size of a CA Block

;Equates for BvsCreateCA

x_CABoff        equ     p_parmn         ; Offset of CA Block
x_CABsel        equ     p_parmnm1       ; Selector of CA Block
x_hCAoff        equ     p_parmnm2       ; Offset of CA Handle
x_hCAsel        equ     p_parmnm3       ; Selector of CA Handle

;Equates for BvsGetCAState

x_gfCAoff       equ     p_parmn         ; offset to CA flags storage area
x_gfCAseg       equ     p_parmnm1       ; segment to CA flags storage area
x_ghCA          equ     p_parmnm2       ; Handle to the CA to be gotten

;Equates for BvsSetCAState

x_sfCA          equ     p_parmn         ; Flags to set in the CA
x_shCA          equ     p_parmnm1       ; Handle to the CA to be set

;Equate for BvsDestroyCA

x_dhCA          equ     p_parmn         ; Handle to the CA to be destroyed

;@C50 Mou_Open        equ     17      ; ordinal number for MOUCALLS.MOUOPEN   ;@T25
;@C50 Mou_Close       equ     9       ; ordinal number for MOUCALLS.MOUCLOSE  ;@T25
;@C50 Ansi_Interp     equ     3       ; ordinal number for ANSICALL.ANSITERP  ;@T25

;@C50 tnk     struc                                                           ;@T25
;@C50 pfnCall  dd     ?               ; pointer to function to call           ;@T25
;@C50 pfnTnk   dw     ?               ; offset to thunk routine               ;@T25
;@C50 szModOff dw     ?               ; offset to module name                 ;@T25
;@C50 hOrdinal dw     ?               ; ordinal number of the entry point     ;@T25
;@C50 tnk     ends                                                            ;@T25

;@C50 THUNKDEF    macro   rtn, szMod, hOrd                                    ;@T25
;@C50 tnk&rtn tnk <ThunkerFarRet, Thunker, szMod, hOrd>                       ;@T25
;@C50         public  tnk&rtn                                                 ;@T25
;@C50 endm                                                                    ;@T25

;@C50 THUNKCALL   macro   thunkname                                           ;@T25
;@C50         mov     [bp].vp_parm20,ds                                       ;@T29
;@C50         push    BVSISEG                                                 ;@T29
;@C50         pop     ds                                                      ;@T29
;@C50         mov     ax,offset tnk&thunkname                                 ;@T25
;@C50         call    ds:tnk&thunkname.pfnTnk                                 ;@T25
;@C50         call    ds:tnk&thunkname.pfnCall                                ;@T25
;@C50         mov     ds,[bp].vp_parm20                                       ;@T25
;@C50 endm                                                                    ;@T29

;@@A = 01/13/89 STJ, Equates for adapter and display types added, P2986
;D184 = 03/13/89 STJ, Equates for additional display types
;D261 = 03/29/89 STJ, Use CONFIG.SYS instead of OS2.INI and optimize
;@T25 = 04/04/89 TPL, Sizzle work, B701685
;D198 = 04/13/89 STJ, Install BvsPrtSc and BvsWrtTTY as VDH default routines
;@T29 = 05/01/89 TPL, B701685 fix; see @T25, B702128
;@BB7 = 05/09/89 WKB, Restructure config data structure, B702184
;@C32 = 08/16/89 CJJ, Add video page parm, B706548
;@D549 = 11/02/89 CJJ, Seltable changes due to rangeless sessions, DCR 549
;D811 = 2.0 UNIQUE - 11/30/89 MS,  DCR 811
;@T72 = 07/23/90 TPL, DCR 1295 - Support recognition of XGA device
;@T72f= 10/02/90 TPL, DCR 1295 fix - use emulated adapter type bit 9, B716888
;@C39 = 01/15/91 CJJ, MVDM transparent popup changes, PTR SM84577
;@C50 = 08/01/91 CJJ, B724984 Don't use thunk calls anymore.
