;SCCSID = @(#)bvscb.inc 6.4 91/07/22
; ****************************************************************************
; *                                                                          *
; *                       IBM/Microsoft Confidential                         *
; *                                                                          *
; *                 Copyright (c) IBM Corporation  1987, 1990                *
; *                 Copyright (c) Microsoft Corp.  1987, 1990                *
; *                           All Rights Reserved                            *
; *                                                                          *
; ****************************************************************************

;STJFMT,,16                             ;Formatting parms for STJFMT

BVS3SEG         equ     <CTEXT>         ;                               ;MDLL
BVSISEG         equ     <OS2CHAR_I>     ;                               ;MDLL
BVSGSEG         equ     <OS2CHAR>       ;                               ;MDLL

;-----------------------------------------------------------------------
; The following structures are used by DBCS support
;-----------------------------------------------------------------------

; This structure is used to get the correct function from CallTbl in BVSMAIN

FUNCTYPE        STRUC                   ;@P1
func_sbcs       dw      ?               ; normal use SBCS function ;@P1
func_dbcs       dw      ?               ; function to use when CAs present;@P1
func_flags      dw      ?               ; function access flags ;@P1
FUNCTYPE        ENDS                    ;@P1

; The following structure is used for rectangle calculations

RECT            STRUC                   ;@P1
rec_xLeft       dw      ?               ; left pos. in screen coordinate ;@P1
rec_yTop        dw      ?               ; top pos. ;@P1
rec_xRight      dw      ?               ; right pos. ;@P1
rec_yBottom     dw      ?               ; bottom pos. ;@P1
RECT            ENDS                    ;@P1

; The following structure is used for Conversion Areas

CAS             STRUC                   ;@P1
cas_Up          dw      ?               ; pointer to next in list ;@P1
cas_Dn          dw      ?               ; pointer to previous in list ;@P1
cas_flags       dw      ?               ; visible and busy flags ;@P1
cas_areaoff     dw      ?               ; area memory offset ;@P1
cas_areasel     dw      ?               ; selector ;@P1
cas_length      dw      ?               ; size in characters ;@P1
cas_xLeft       dw      ?               ; left pos. in screen coordinate ;@P1
cas_yTop        dw      ?               ; top pos. ;@P1
cas_xRight      dw      ?               ; right pos. ;@P1
cas_yBottom     dw      ?               ; bottom pos. ;@P1
cas_formatid    db      ?               ; attribute format ID ;@P1
cas_attrcount   db      ?               ; attribute count ;@P1
CAS             ENDS                    ;@P1

; CAS flags

cas_f_visible   equ     00001h          ; 1 - visible, 0 - invisible ;@P1
cas_f_format    equ     00002h          ; 1 - special attr format, 0 - as curnt mode;@P1
cas_f_inactive  equ     00004h          ; 1 - inactive, 0 - CA is active ;@P1
cas_f_nomove    equ     00008h          ; 1 - do not move the CA on SetState ;@P1

; CallTbl flags

call_f_allowCA  equ     00001h          ; 1 - allowed for CA proc, 0 - not allowed ;@P1

; DBCS Display table equate

MaxDispTblLen   equ     00020h          ; # of bytes of DBCS display width info ;@P1

;-----------------------------------------------------------------------
; BVS Screen Group data, assume ptr in DS:BX
;-----------------------------------------------------------------------

bvscb           STRUC                   ;BVS Control Block Entry

bvs_flags       dw      0               ;Flags used by BVS
bvs_bvssize     dw      0               ;Current BVSCB size
bvs_envsize     dd      0               ;Current ENVB size
bvs_lvbsize     dd      0               ;Current LVB size

bvs_ActiveCP    dw      0               ;Current active CodePage
bvs_numconfigs  dw      0               ;Number of valid configurations

; The following fields are saved/restored as a unit

bvs_confignum   dw      0               ;Configuration number
bvs_curconfig   dw      0               ;Current configuration

bvs_cursorrow   dw      0               ;Current cursor row
bvs_cursorcol   dw      0               ;Current cursor column

bvs_cursorstart dw      6               ;Current cursor start line
bvs_cursorend   dw      7               ;Current cursor end line
bvs_cursorwidth dw      1               ;Current cursor width
bvs_cursorattr  dw      0               ;Current cursor attribute

bvs_mdlen       dw      12              ;Length of mode data
bvs_type        db      1               ;Type for Mode
bvs_colors      db      0               ;Colors for Mode
bvs_cols        dw      80              ;Number of screen columns for text
bvs_rows        dw      25              ;Number of screen rows for text
bvs_gcols       dw      640             ;Number of screen columns for graphics
bvs_grows       dw      200             ;Number of screen rows for graphics
bvs_attrformat  db      ?               ;Attribute format
bvs_attrbytes   db      ?               ;Number of attribute bytes
bvs_bufaddr     dd      ?               ;Address of video buffer
bvs_bufsize     dd      ?               ;Size of video buffer
bvs_fullbufsz   dd      ?               ;Full buffer save size
bvs_partbufsz   dd      ?               ;Partial buffer save size
bvs_extdata     dd      ?               ;Extended mode data address

; End of save/restore unit

; Used for the scrollable region of the screen

bvs_ScrlRectLft dw      ?               ; Left most column ;@P1
bvs_ScrlRectTop dw      ?               ; Top most row ;@P1
bvs_ScrlRectRt  dw      ?               ; Right most column ;@P1
bvs_ScrlRectBtm dw      ?               ; Bottom most row ;@P1

bvs_ttycell     db      ' '             ;Cell for WrtTTY scrolling (w/next)
bvs_scrattr     db      007h            ;Screen attribute byte #1
bvs_scrattr2    db      0               ;Screen attribute byte #2
bvs_scrattr3    db      0               ;Screen attribute byte #3

bvs_scratch     dw      0               ;Scratch area for output operation

; The following varibles 7 words must remain together (DOSGETDBCSEV)

bvs_DBCSEvBuff  db      10  dup (0)     ;DBCS environmental vector area
bvs_CountryCode dw      0               ;Country code area ;@P1
bvs_AuxCP       dw      0               ;Code page requested ;@P1

; The following fields support ANSI variables:

bvs_TTYOff      DW      0               ;Offset of string between TTY/Interp
bvs_TTYSel      DW      0               ;Selector of string between TTY/Interp
bvs_TTYLen      DW      0               ;Length of string between TTY/Interp
bvs_SaveCursor  DW      0               ; cursor position save
bvs_AIStatus    DW      0               ; status of AnsiInterp
bvs_ParmCount   DW      0               ; count of parameters saved
bvs_Parameter   DB      0               ; partial parameter save
bvs_QuoteChar   DB      0               ; start quote character
bvs_cprTemp     DB      01Bh,'[00;00R',00Dh ; template for CurPos Report
                DB      0               ; realign the struture ;@P1
bvs_ParmBuffPtr DB      256 DUP (?)     ; ANSI Parameter Buffer
bvs_Kd_CP0      DW      0               ; bvs_kdSegSize
                DW      0               ; bvs_kdFreeBytes
                DW      0               ; bvs_kdLastDef
bvs_Kd_CP1      DW      0               ; bvs_kdSegSize
                DW      0               ; bvs_kdFreeBytes
                DW      0               ; bvs_kdLastDef
bvs_Kd_CP2      DW      0               ; bvs_kdSegSize
                DW      0               ; bvs_kdFreeBytes
                DW      0               ; bvs_kdLastDef

; The following fields support Conversion Area Support

bvs_flags2      dw      0               ; second BVS flags word ;@P1
bvs_TouchRect   db      size RECT dup (?) ;@P1
bvs_WriteRect   db      size RECT dup (?) ;@P1
bvs_ScratchRect db      size RECT dup (?) ;@P1
bvs_ActCARect   db      size RECT dup (?) ;@P1
bvs_VisCARect   db      size RECT dup (?) ;@P1

bvs_CA_died     dw      0               ;CA owner died badly, repair screen;@P1
bvs_CA_pid      dw      0               ;CA owner pid ;@P1
bvs_CA_free     dw      0               ;free CAS list pointer ;@P1
bvs_CA_lru      dw      ?               ;least recently used CAS pointer ;@P1
bvs_CA_crnt     dw      ?                ;@P1
bvs_CAS         db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
                db      size CAS dup (?) ;@P1           ;@B43
bvs_dbcstbllen  dw      0               ;@P1
bvs_dbcstbl     dw      MaxDispTblLen/2  dup (?) ;@P1

bvscb           ENDS

CAMAX           equ     16      ;@B43   ;@P1    ; Number of CAs per screen group
EXLST_ADD       equ     01h             ;@P1    ; continue to next exit list routine
EXLST_REMOVE    equ     02h             ;@P1    ; continue to next exit list routine
EXLST_EXIT      equ     03h             ;@P1    ; continue to next exit list routine
CA_OWNER_DIED   equ     0ffffh          ;@P1    ; clean up after dead CA process

; BVS flags

bvs_f_ansi      equ     00001h          ;Ansi enabled flag
bvs_f_ansicprs  equ     00002h          ;Ansi CPR status flag
bvs_f_ansijunk  equ     00004h          ;Ansi throw away during wrap flag
bvs_f_ansiprog  equ     00008h          ;Ansi in progress flag
bvs_f_ansiwrap  equ     00010h          ;Ansi wrap flag
bvs_f_cprtsc    equ     00020h          ;Ctrl-PrtSc in progress flag
bvs_f_closeprt  equ     00040h          ;Close printer flag
bvs_f_mounotify equ     00080h          ;Mouse notification required
bvs_f_window    equ     00100h          ;Vio windowable session
bvs_f_avio      equ     00200h          ;AVIO session
bvs_f_wrtthru   equ     02000h          ;Write Thru required, LVB exposed
bvs_f_mouactive equ     04000h          ;Mouse Support Active for this session
bvs_f_ansikey   equ     08000h          ;Ansi Enhanced Keyboard support

; BVS flags for the second flags word

bvs_f2_dbcscp   equ     00001h          ;current CP is DBCS ;@P1

cbAttr          equ     03h             ;bytes of space for attributes ;@P1

; Registered VIO function bit mask definition                           ;@T46
                                                                        ;@T46
rf_GetCurPos    equ     0001h           ;VioGetCurPos                   ;@T46
rf_GetCurType   equ     0002h           ;VioGetCurType                  ;@T46
rf_GetMode      equ     0004h           ;VioGetMode                     ;@T46
rf_SetCurPos    equ     0008h           ;VioSetCurPos                   ;@T46
rf_SetCurType   equ     0010h           ;VioSetCurType                  ;@T46
rf_SetMode      equ     0020h           ;VioSetMode                     ;@T46
rf_ReadCharStr  equ     0040h           ;VioReadCharStr                 ;@T46
rf_ReadCellStr  equ     0080h           ;VioReadCellStr                 ;@T46
rf_WrtNChar     equ     0100h           ;VioWrtNChar                    ;@T46
rf_WrtNAttr     equ     0200h           ;VioWrtNAttr                    ;@T46
rf_WrtNCell     equ     0400h           ;VioWrtNCell                    ;@T46
rf_WrtTTY       equ     0800h           ;VioWrtTTY                      ;@T46
rf_WrtCharStr   equ     1000h           ;VioWrtCharStr                  ;@T46
rf_WrtCharStrAtt equ    2000h           ;VioWrtCharStrAtt               ;@T46
rf_WrtCellStr   equ     4000h           ;VioWrtCellStr                  ;@T46
rf_ScrollUp     equ     8000h           ;VioScrollUp                    ;@T46


;-----------------------------------------------------------------------
; BVS Global Data Segment
;
;-----------------------------------------------------------------------
; If BVSGDATA is changed, the corresponding structure
; _bvscommon in BVSLDRVR.H and BVSGSEG in BVSMAIN.ASM must also be changed.
;
; Besure to remake all BVH DLLs in the VDH directory also.
;-----------------------------------------------------------------------

bvsgdata        STRUC                   ;BVS Global Data Segment

bvsgCallTables  dd      16 dup (0)      ;Allow for WDH and 15 real devices

bvsgFlags       dw      0               ;Global flags
bvsgInstance    dw      0               ;Instance Selector
bvsgBvscbSize   dw      0FFFEh AND (1+SIZE bvscb) ;Size of the BVSCB

bvsgSISsel      dw      0               ;System InfoSeg GDT selector
bvsgLISsel      dw      0               ;Local InfoSeg LDT selector
bvsgMaxBase     dw      0               ;Maximum Base session number

bvsgInitPid     dw      0               ;Process ID at initialization time
bvsgScrHandle   dw      0               ;Base Video Subsystem File Handle

bvsgSg0Flag     dw      0               ;SG0 on behalf of other SG
bvsgSg0Bvssel   dw      0               ;SG0 BVSCB selector
bvsgSg0Envsel   dw      0               ;SG0 ENVB selector
bvsgSg0Lvbsel   dw      0               ;SG0 LVB selector

bvsgOpen_a      dw      0               ;Open action return field
bvsgPrtsclen    dw      0               ;Print screen length
bvsgPrtsc_Buffer db     134 dup (' ')   ;Print screen buffer @B719871
bvsgCprTemp     db      01Bh,'[00;00R',00Dh ;Template for CurPos Report * Do
bvsgBvscbName   db      '\SHAREMEM\BVS\BVSsg',0 ;Name of BVSCB          * Not
bvsgMouddName   db      'MOUSE$',0      ;Mouse DD name            ;@T25 * Move
bvsgPrtName     db      'PRN',0         ;Printer name asciiz string     ;@T25
bvsgScrddName   db      'SCREEN$',0     ;Screen DD name                 ;@T25
bvsgBlanks      db      8 dup (' ')     ;Blanks for tab removal
bvsg3xBcPos     dw      0               ;3X Box cursor position save area

bvsgParmPkt     db      0               ; parameter packet area          @D663
bvsgPjTitleLen  dw      ?               ; length of print job title      @D663
bvsgPjTitleOff  dw      ?               ; offset of print job title      @D663
bvsgPjTitleSel  dw      ?               ; segment of print job title     @D663
bvsgCPrtscTitle db      'Ctrl PrtSc',0      ; asciiz of cprtsc job title @D663
bvsgCPrtscTitlelen db   $ - bvsgCPrtscTitle ;length of title             @D663
bvsgPrtscTitle  db      'Print Screen',0    ; asciiz of cprtsc job title @D663
bvsgPrtscTitleLen db    $ - bvsgPrtscTitle  ;length of title             @D663
bvsgVdd1        db      'VVIDEO1$',0    ;primary display for MVDM       ;@C39
bvsgVdd2        db      'VVIDEO2$',0    ;secondary display for MVDM     ;@C39
                db      0               ;Word alignment                 ;@T73
bvsgVddhandle   dd      0               ;MVDM VDD handle                ;@C39

bvsgSelTablesz  dw      0               ;Selector table entry size      ;@D549
bvsgSelTable    dd      256 dup (0)     ;Selector table offset          ;@D549

;bvsgWndwConfig dw     0               ;Config number in use by Shell ;@@A,@T46

bvsgdata        ENDS

;@T52bvsg_cprlen     equ     bvsg_bvscbname-bvsg_cprtemp ;Length of CPR
;@T52bvsg_bvscbnameln equ    bvsg_mouddname-bvsg_bvscbname ;Length of BVSCB name

bvsg_f_mouactive equ    0001h           ;Mouse active
bvsg_f_harderror equ    0002h           ;Hard error active
bvsg_f_popup     equ    0004h           ;Normal popup in effect         ;@T14ff
bvsg_f_tpopup    equ    0008h           ;Transparent popup in effect    ;@T14ff

; the following are for per VDH data.  The per VDH data consists of a
; call table, a device string, a real mode pointer draw name string,
; a protect mode pointer draw name string, a device table entry and
; a word of "in use" flags.
; Per VDH data is allocated at the end of BVSCNSEG.  The segment is
; reallocated when more space is needed.


ccalltbls       equ     10h             ;number of calltables ;@P1
cbcalltbl       equ     4*11ah          ;size of a calltable ;@P1
cbMaxDevName    equ     512             ;@P1
cbMaxPtrName    equ     32              ;@P1
cbDevTblEnt     equ     714             ;@P1

cbDevGroup      equ     cbcalltbl+cbMaxDevName+cbMaxPtrName+cbMaxPtrName+cbDevTblEnt+2

gf_devtblinit   equ     0001h           ;@P1
gf_calltblsinit equ     0002h           ;@P1
gf_initgenvec   equ     0004h           ;@P1
gf_globinitdone equ     0008h           ;@P1

;-----------------------------------------------------------------------
; BVS Instance Data Segment
;-----------------------------------------------------------------------

;@T52bvsidata        STRUC                   ;BVS Instance Data Segment

;@T52bvsi_bvssel     dw      0               ;BVSCB Selector, same order as SELSEG
;@T52bvsi_envsel     dw      0               ;ENVB Selector, same order as SELSEG
;@T52bvsi_lvbsel     dw      0               ;LVB Selector, same order as SELSEG
;@T52bvsi_sgnum      dw      0               ;Screen group number

;@T52bvsi_gdtsel     dw      0               ;DOS Info GDT Selector
;@T52bvsi_ldtsel     dw      0               ;DOS Info LDT Selector
;@T52bvsi_level      dw      0               ;Level of Recursion
;@T52bvsi_flags      dw      0               ;Per Process flags

;@T52bvsi_pvbsel     dw      0               ;PVB Selector
;@T52bvsi_biosel     dw      0               ;BIOS Selector

;@T52bvsi_physaddrl  dw      0               ;Physical offset of video buffer
;@T52bvsi_physaddrh  dw      0               ;Physical segment of video buffer
;@T52bvsi_length     dw      0               ;Length of video buffer
;@T52bvsi_lenhigh    dw      0               ;Length of video buffer

;@T52bvsi_srflen     dw      0               ;Length return area for BVSSRF
;@T52bvsi_retlen     dw      0               ;Length return area
;@T52bvsi_scrhandle  dw      0               ;Alternate handle for SCR DD
;@T52bvsi_prthandle  dw      0               ;Handle for print requests

;@T52bvsi_pop_sgnum  dw      0               ;Original SG number
;@T52bvsi_pop_bvssel dw      0               ;Original BVSCB sel
;@T52bvsi_pop_popsel dw      0               ;Previous popup selector
;@T52bvsi_pop_vdh    dw      0               ;1 - fullscreen VDH(s) loaded   ;@T48

;@T52bvsi_tty_dbcs   db      0               ;dbcs flag for TTY
;@T52bvsi_tty_dbcsl  db      0               ;leading byte (if tty_f_leading set);@P1
;@T52bvsi_tty_dbcst  db      0               ;trailing byte ;@P1
; end of Warning
;@T52bvsi_tty_flag   db      0               ;dbcs flags for TTY ;@P1
;@T52bvsi_register   dw      0               ;Registration info from AX ;@S22

;@T52bvsidata        ENDS

fs_vdh_loaded   equ     1               ;use to set bvsi_pop_vdh        ;@T48
tty_f_leading   equ     1               ;previous was leading byte ;@P1
tty_f_off       equ     0               ;flag clear (must be 0) [reserved];@P1

bvsi_f_dbcs     equ     001h            ;DBCS flag
bvsi_f_popup    equ     002h            ;On=Change to Popup,Off=return
bvsi_f_p1lvb    equ     004h            ;First popup LVB in use
bvsi_f_p2lvb    equ     008h            ;Second popup LVB in use
bvsi_f_caproc   equ     010h            ;This is the CA process ;@P1

on              equ     1               ;flag for dbcs
off             equ     0               ;flag for dbcs

;-----------------------------------------------------------------------
; Structure defining the BIOS data area
;-----------------------------------------------------------------------

realdata        STRUC                   ;Real Mode data area (based at 40:0)
                db      00010h dup (?)
real_equipflag  dw      ?               ;Bios Equipment Flag
                db      00037h dup (?)
real_crtmode    db      ?               ;Bios Video Mode
real_crtcols    dw      ?               ;Bios Video Columns
real_crtlen     dw      ?               ;Bios Video Length
real_crtstart   dw      ?               ;Bios Video Start Address
real_cursorposn dw      8 dup (?)       ;Bios Cursor Positions
real_cursormode dw      ?               ;Bios Cursor Mode
real_activepage db      ?               ;Bios Active Video Page
real_addr6845   dw      ?               ;Bios Video Port Address
real_crtmodeset db      ?               ;Bios Video Mode Control Register
real_crtpalette db      ?               ;Bios Palette
                db      0001Dh dup (?)
real_rows       db      ?               ;Bios Video Rows
real_points     dw      ?               ;Bios Video Font Pels
real_info       db      ?               ;Bios EGA Info Byte
real_info3      db      ?               ;Bios EGA Info3 Byte
                db      0001Fh dup (?)
real_saveptr    dd      ?               ;Bios Video Save Area Pointer
realdata        ENDS

real_f_cgaemu   equ     01h             ;INFO byte, CGA emulation flag

;-----------------------------------------------------------------------
; The seltable structure represents one entry in the selector table
;       which is allocated in BVSGSEG.  The header is the same size
;       as the pairs of ENVB/LVB selectors to allow easy addressing.
;-----------------------------------------------------------------------

seltable        STRUC                   ;@S10
selt_size       dw      0               ;size of this structure           ;@D549
selt_bvscb      dw      0               ;Master BVSCB selector ;@S10
selt_flags      dw      0               ;Active config flags ;@S10
selt_envb       dw      0               ;First master ENVB selector ;@S10
selt_lvb        dw      0               ;First master LVB selector ;@S10
selt_nextenvb   dw      0               ;Next master ENVB selector, if any ;@S10
selt_nextlvb    dw      0               ;Next master ENB selector, if any ;@S10
seltable        ENDS                    ;@S10

;-----------------------------------------------------------------------
; Instance data used by the BVH Device Handlers
;-----------------------------------------------------------------------

bvhidata        STRUC                                                   ;@T52

; start of BVH instance data            ;BESURE ALL CHANGES ARE         ;@T52
                                        ;  REFLECTED IN BVSMAIN ALSO    ;@T52
bvhi_ScreenDD   dw      0               ;Screen DD handle               ;@T52
bvhi_PVBAddrLo  dw      0               ;BVH physical address           ;@T52
bvhi_PVBAddrHi  dw      0               ;                               ;@T52
bvhi_PVBSizeLo  dw      0               ;PVB buffer size                ;@T52
bvhi_PVBSizeHi  dw      0               ;                               ;@T52
bvhi_PVBOffset  dw      0               ;PVB virtual address            ;@T52
bvhi_PVBSel     dw      0               ;                               ;@T52

; start of WDH instance data            ;BESURE ALL CHANGES ARE         ;@T52
                                        ;  REFLECTED IN BVSMAIN ALSO    ;@T52
LastBaseSG      dw      0               ;to hold (MaxBaseSG_from_InfoSeg - 1)
Scratch_Area1   dw      0               ;***keep together***      LastBaseSG)
Scratch_Area2   dw      0               ;***keep together***
save_viohandle  dw      0               ;needed when 'enterb' is used
ppbvs_sema4     dw      0               ;0 = clear, 1 = set
ppbvs_pssel     dw      0               ;PS selector for base vio
cell_size       dw      2               ;2 or 4 dependent on defined num_attr
attr1           dw      0               ;first attr word (lo=attr1, hi=attr2)
attr2           dw      0               ;second attr word (lo=attr3, hi=0)
addr_list       dw      129 dup (0)     ;list of Avio PS segments       ;@@SW

ppbvs_bvssel    dw      0               ;BVSCBsg Selector
ppbvs_lvbsel    dw      0               ;LVBsg Selector
ppbvs_gdtsel    dw      0               ;DOS Info GDT Selector
ppbvs_ldtsel    dw      0               ;DOS Info LDT Selector

wdhi_wininits   db      32 dup (0)      ;Threads that called WinInitialize

wdhi_start_row  dw      0               ;start row lo word
                dw      0               ;start row hi word
wdhi_start_col  dw      0               ;start col lo word
                dw      0               ;start col hi word
wdhi_length_width dw    0               ;length or width lo word (RtCol-LeftCol)
                dw      0               ;length or width hi word
wdhi_rect_height dw     0               ;height lo word          (BotRow-TopRow)
                dw      0               ;height hi word
wdhi_horiz_count dw     0               ;left or right moves lo word
                dw      0               ;left or right moves hi word
wdhi_vert_count dw      0               ;up or down moves lo word
                dw      0               ;up or down moves hi word
wdhi_fill_cell_off dw   0               ;filler cell offset
wdhi_fill_cell_sel dw   0               ;filler cell selector

wdhi_Scratch    dd      0               ;Scratch area

;avio_entry     dd      0               ;Address to call AVIO
;avio_filler    dw      54h dup (0)     ;Filler to make it match

cmn_bvscbsize   dw      0FFFEh AND (1+SIZE bvscb) ;Size of the BVSCB
cmn_SISsel      dw      0               ;System InfoSeg selelector
cmn_LISsel      dw      0               ;Local InfoSeg sel   ;MUST BE   ;@T52
bvsi_bvs        dw      0               ;WDH needs this      ; KEPT     ;@T52
bvsi_env        dw      0               ;                    ; TOGETHER ;@T52
bvsi_lvb        dw      0               ;                    ; !!!!!!!! ;@T52

bvhidata        ENDS                                                    ;@T52

wdhi_GreDat     equ     wdhi_start_row  ;Start of GreDat sub-structure

wdhi_sema4      equ     ppbvs_sema4     ;0 = clear, 1 = set
wdhi_pssel      equ     ppbvs_pssel     ;PS selector save area

;-----------------------------------------------------------------------
; The following items are for AVIO compatibility only.
;-----------------------------------------------------------------------

bvs_f_backgrnd  equ     0               ;Dummy background flag
bvs_length      equ     bvs_scratch     ;Dummy length field

;*********  MUST MATCH portion of Parmlist Struc in BVSPARMS.INC   ************
oldstackframe   STRUC                   ;Parameter Stack Area

regfs           dw      ?               ;Reg FS save area                ;D549
reges           dw      ?               ;Reg ES save area
regds           dw      ?               ;Reg DS save area
regdi           dw      ?               ;Reg DI save area
regsi           dw      ?               ;Reg SI save area
regbp           dw      ?               ;Reg BP save area
regspworkarea   dw      ?               ;Reg SP save area
regbx           dw      ?               ;Reg BX save area
regdx           dw      ?               ;Reg DX save area
regcx           dw      ?               ;Reg CX save area
regax           dw      ?               ;Reg AX save area
regfl           dw      ?               ;Reg FL save area                ;D549
vioroutip       dw      ?               ;VIOROUT return offset
vioroutcs       dw      ?               ;VIOROUT return selector
vioroutds       dw      ?               ;VIOROUT data selector
vioip           dw      ?               ;VIOxxx return offset
viofunc         dw      ?               ;VIOxxx Function code
userip          dw      ?               ;User return offset
usercs          dw      ?               ;User return segment
viohandle       dw      ?               ;Vio Device Handle
parmn           dw      ?               ;Nth parameter
parmnm1         dw      ?               ;(N-1)st parameter
parmnm2         dw      ?               ;(N-2)nd parameter
parmnm3         dw      ?               ;(N-3)rd parameter
parmnm4         dw      ?               ;(N-4)th parameter
parmnm5         dw      ?               ;(N-5)th parameter
parmnm6         dw      ?               ;(N-6)th parameter
parmnm7         dw      ?               ;(N-7)th parameter
parmnm8         dw      ?               ;(N-8)th parameter
parmnm9         dw      ?               ;(N-9)th parameter

oldstackframe   ENDS

GreStruc        STRUC

start_row       dw      0               ;start row lo word
                dw      0               ;start row hi word
start_col       dw      0               ;start col lo word
                dw      0               ;start col hi word
length_width    dw      0               ;length or width lo word (RtCol-LeftCol)
                dw      0               ;length or width hi word
rect_height     dw      0               ;height lo word          (BotRow-TopRow)
                dw      0               ;height hi word
horiz_count     dw      0               ;left or right moves lo word
                dw      0               ;left or right moves hi word
vert_count      dw      0               ;up or down moves lo word
                dw      0               ;up or down moves hi word
fill_cell_off   dw      0               ;filler cell offset
fill_cell_sel   dw      0               ;filler cell selector

GreStruc        ENDS

;-----------------------------------------------------------------------
; Macro definitions
;-----------------------------------------------------------------------
;STJFMT,                                ;Formatting parms for STJFMT

        .286p                           ;Generate 386 Protect Mode Instructions @D549

break   macro                           ;Dummy macro to avoid DOSMACS.INC
        endm

bvsfunc macro   bvsfuncnum,argn,vpflags ;@P1;@S22

        ifndef  CallTbl                 ;@P1
            extrn   CallTbl:NEAR        ;@P1
        endif                           ;@P1

        push    bp                      ;@P1
        push    es                      ;@P1
        sub     sp,p_viohandle-4        ;@P1

        mov     ax,BVSISEG              ;@P1
        mov     es,ax                   ;@P1

        mov     ax,[bp].p_regax         ;Get registration bit mask      ;@T46
        mov     bp,sp                   ;@P1
        mov     [bp].p_regax,ax         ;Pass on registration info      ;@T46

        mov     [bp].vp_parmlength,8    ;Set default Parm block length ;@C20
        ifb     <vpflags>               ;@S22
            mov     [bp].vp_flags,bx    ;@P1
        else                            ;@S22
            mov     [bp].vp_flags,&vpflags ;@S22
        endif                           ;@S22

        mov     [bp].p_regdx,dx         ;@P1
        mov     [bp].p_regcx,cx         ;@P1
        mov     [bp].p_regdi,di         ;@P1
        mov     [bp].p_regsi,si         ;@P1

        mov     si,bvsfuncnum * 6       ;@P1
        .if     <[bx].bvs_CA_pid eq bx> ; No CAs are active ;@P1
            Call    CS:CallTbl[si].func_sbcs ;Call the BVS routine ;@P1
        .else                           ;@P1
            mov     ax,ERROR_VIO_INVALID_PARMS ;D198
            .if     <BIT es:[bx].bvsi_flags nand bvsi_f_caproc> or ;@P1;D198
            .if     <BIT CS:CallTbl[si].func_flags and call_f_allowCA> ;@P1;D198;@T31
                Call    CS:CallTbl[si].func_dbcs ;Call the BVS routine
            .endif                      ;@P1
        .endif                          ;@P1

        mov     dx,[bp].p_regdx         ;@P1
        mov     cx,[bp].p_regcx         ;@P1
        mov     di,[bp].p_regdi         ;@P1
        mov     si,[bp].p_regsi         ;@P1

        add     sp,p_viohandle-4        ;@P1
        pop     es                      ;@P1
        pop     bp                      ;@P1
        add     sp,argn*2               ;@P1

        endm                            ;@P1

;@@A  = 12/02/88 STJ, Save shell's config number for windows, P2813
;@P1  = 03/25/89  PL, DCR 132 changes
;@T25 = 04/04/89 TPL, Sizzle work, B701685
;D198 = 04/06/89 STJ, Install BvsPrtSc and BvsWrtTTY as default VDH routines
;D261 = 04/21/89 STJ, Combine BVSSSEG with BVSGSEG along with DCR0261
;@C20 = 05/10/89 CJJ, Set up default parameter length, B702273
;@S10 = 05/11/89 STJ, Retain separate ENVB/LVB for each config, B701174
;@T31 = 05/18/89 TPL, PhilipL suggested changes for DCR 132, B783850
;@S22 = 08/15/89 STJ, Pass registration info to WrtTTY and IBM-J fix, B785244
;@T46 = 09/05/89 TPL, Use the compress registration mask from VIO, PTR B707524
;@T48 = 09/13/89 TPL, Load VDH after a popup, fix to PTR B707495, PTR B707542
;@D549 = 11/02/89 CJJ, Seltable changes due to rangeless sessions, DCR 549
;@D663 = 01/02/90 TLB, Put name of print screen print job in spool queue, DCR 663
;@T52  = 01/18/90 TPL, DCR 704 work
;@B43  = 02/19/90 WKB, Increased CAMAX to 16, B788133
;@T73  = 07/27/90 TPL, Code/data reduction/optimization and swap tune
;@C39  = 01/15/91 CJJ, MVDM transparent popup changes, PTR SM84577
;@B719871 = 01/28/91 WKB, Increase prt-sc buffer for 132 col modes
;@@SW  = 03/03/92 TPL  Increase # of PS from 32 to 128 (62978)
