;/* SCCSID = "h/apmioctl.h, apm, r206, 6.508 93/03/26" */
;/****************************************************************************/
;/*                                                                          */
;/*                           IBM Confidential                               */
;/*                                                                          */
;/*                 Copyright (c) IBM Corporation 1993                       */
;/*                           All Rights Reserved                            */
;/*                                                                          */
;/****************************************************************************/
;/************************** START OF SPECIFICATIONS *************************/
;/*                                                                          */
;/*   SOURCE FILE NAME:  APMIDC.INC                                          */
;/*                                                                          */
;/*   DESCRIPTIVE NAME:  Constants and structures used by the APM device     */
;/*                      driver for IDC communication.                       */
;/*                                                                          */
;/*   FUNCTION: This module is the Advanced Power Management (APM) device    */
;/*             driver IDC constants and structures.                         */
;/*                                                                          */
;/*   NOTES:                                                                 */
;/*      DEPENDENCIES: None                                                  */
;/*      RESTRICTIONS: None                                                  */
;/*                                                                          */
;/*   ENTRY POINTS:  None                                                    */
;/*                                                                          */
;/*   EXTERNAL REFERENCES:  None                                             */
;/*                                                                          */
;/* Change Log                                                               */
;/*                                                                          */
;/*  Mark    yy/mm/dd  Programmer      Comment                               */
;/*  ----    --------  ----------      -------                               */
;/*          93/04/22  Frank Schroeder Original developer.                   */
;/*                                                                          */
;/**************************** END OF SPECIFICATIONS *************************/

; APM IDC Function Codes

APMIDC_Register          EQU    0
APMIDC_Deregister        EQU    1
APMIDC_SendEvent         EQU    2
APMIDC_QueryStatus       EQU    3
APMIDC_QueryInfo         EQU    4

; APM IDC Return Codes

APMIDC_InvalidFunction   EQU    0000h
APMIDC_InvalidHandle     EQU    0001h
APMIDC_InvalidDevice     EQU    0002h
APMIDC_InvalidEvent      EQU    0003h
APMIDC_InvalidOther      EQU    0004h
APMIDC_InterfaceBusy     EQU    0005h
APMIDC_RequestRejected   EQU    0006h
APMIDC_InvalidMask       EQU    0007h

;APMIDC_InvalidFunction  EQU    128
;APMIDC_InvalidHandle    EQU    129
;APMIDC_TooManyClients   EQU    130
;APMIDC_Busy             EQU    131

; APM Notification Mask Definitions

APMMASK_EnableAPM        EQU    0008h
APMMASK_DisableAPM       EQU    0010h
APMMASK_BIOS_Defaults    EQU    0020h
APMMASK_SetPowerState    EQU    0040h
APMMASK_BatteryLow       EQU    0080h
APMMASK_NormalResume     EQU    0100h
APMMASK_CriticalResume   EQU    0200h
APMMASK_AllAppNotifyBits EQU    03f8h

; APM Event Identification (aka SubId)

APMEVENT_EnableAPM       EQU    3
APMEVENT_DisableAPM      EQU    4
APMEVENT_BIOS_Defauts    EQU    5
APMEVENT_SetPowerState   EQU    6
APMEVENT_BatteryLow      EQU    7
APMEVENT_NormalResume    EQU    8
APMEVENT_CriticalResume  EQU    9

; APM IDC Structures

APMIDC_REGISTER_PKT     STRUC
REG_Function            DW      ?
REG_hClient             DW      ?
REG_EventHandler_off    DW      ?
REG_EventHandler_sel    DW      ?
REG_NotifyMask          DD      ?
REG_ClientDS            DW      ?
REG_DeviceId            DW      ?
APMIDC_REGISTER_PKT     ENDS


APMIDC_NOTIFY_PKT       STRUC
NOTIFY_Function         DW      ?
NOTIFY_SubId            DW      ?
NOTIFY_reserved         DW      ?
NOTIFY_DevId            DW      ?
NOTIFY_PwrState         DW      ?
APMIDC_NOTIFY_PKT       ENDS


APMIDC_DEREGISTER_PKT   STRUC
DEREG_Function          DW      ?
DEREG_hClient           DW      ?
APMIDC_DEREGISTER_PKT   ENDS


APMIDC_SENDEVENT_PKT    STRUC
SENDEV_Function         DW      ?
SENDEV_SubId            DW      ?
SENDEV_reserved         DW      ?
SENDEV_DevId            DW      ?
SENDEV_PwrState         DW      ?
APMIDC_SENDEVENT_PKT    ENDS


APMIDC_QSTATUS_PKT      STRUC
QSTAT_Function          DW      ?
QSTAT_ParmLength        DW      ?
QSTAT_Flags             DW      ?
QSTAT_ACStatus          DB      ?
QSTAT_BatteryStatus     DB      ?
QSTAT_BatteryLife       DB      ?
APMIDC_QSTATUS_PKT      ENDS


APMIDC_QINFO_PKT        STRUC
QINFO_Function          DW      ?
QINFO_ParmLength        DW      ?
QINFO_BIOSFlags         DW      ?
QINFO_BIOSMajor         DB      ?
QINFO_BIOSMinor         DB      ?
QINFO_DDMajor           DB      ?
QINFO_DDMinor           DB      ?
APMIDC_QINFO_PKT        ENDS

