/*static char *SCCSID = "@(#)vxvio.h    6.00 92/07/08";*/
/***    VVD.H
 *
 *      SCCSID = @(#)vxvio.h    6.00 92/07/08
 *
 *      MVDM Virtual Video Exported Definitions
 *      Copyright (c) 1988,1989 Microsoft Corporation
 *
 *      For include file hierarchy, see MVDM.H
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *   02/15/96  @V3.1MNH01 D148300 Merge DBCS-J (IBM J) source w/SBCS source
 ***********************************************************************/

#define VXVIO_NAME  "VXVIO$"            /* registered name of VXVIO */

/***LT+ Mode Data tables
 */
typedef struct vxmode_s {
    USHORT vxm_cb;
    UCHAR  vxm_fbType;
    UCHAR  vxm_color;
    USHORT vxm_col;
    USHORT vxm_row;
    USHORT vxm_hres;
    USHORT vxm_vres;
    UCHAR  vxm_FormatID;
    UCHAR  vxm_attrib;
} VXMODE;

typedef VXMODE FAR *PVXMODE;

/***EK+ VXVIO constants for system communication
 */

#ifndef DSP2OLD                         /* if vxvio.sys,           */ //j-ea0610
#define VXSYSREQ_WAITEVENT          1
#define VXSYSREQ_GETCURSOR          2
#define VXSYSREQ_SETCURSOR          3
#define VXSYSREQ_COPYLVB            4
#define VXSYSREQ_WRITESTR           5
#define VXSYSREQ_SAVESCREEN         6
#define VXSYSREQ_RESTORESCREEN      7
#define VXSYSREQ_SETEVENTFILTER     8

#define VXSYSREQ_MAX                8
#else                                                                 //j-ea1210
#define VXSYSREQ_WAITEVENT          1   + VVDSYSREQ_MAX
#define VXSYSREQ_GETCURSOR          6   + VVDSYSREQ_MAX
#define VXSYSREQ_SETCURSOR          3   + VVDSYSREQ_MAX
#define VXSYSREQ_COPYLVB            4   + VVDSYSREQ_MAX
#define VXSYSREQ_WRITESTR           2   + VVDSYSREQ_MAX
#define VXSYSREQ_SAVESCREEN         5   + VVDSYSREQ_MAX
#define VXSYSREQ_RESTORESCREEN      8   + VVDSYSREQ_MAX
#define VXSYSREQ_SETEVENTFILTER     7   + VVDSYSREQ_MAX

#define VXSYSREQ_MAX                8   + VVDSYSREQ_MAX

//#define VVDSYSREQ_WAITSGEVENT   18
//#define VVDSYSREQ_WRITESTR      19
//#define VVDSYSREQ_SETCURSOR     20
//#define VVDSYSREQ_COPYLVBX      21
//#define VVDSYSREQ_SAVESCREEN    22
//#define VVDSYSREQ_GETCURSOR     23
//#define VVDSYSREQ_SETEVENTFILTER 24
//#define VVDSYSREQ_RESTORESCREEN     25
#endif                                                                //j-ea1210

/* VX event IDs for VXSYSREQ_WAITEVENT
 */

#define VXEVENT_NONE                0    /* no events                    */
#define VXEVENT_MODE                1    /* change in VDM's mode         */
#define VXEVENT_LVB                 2    /* change in VDM's LVB          */
#define VXEVENT_CURSOR              3    /* cursor position/type change  */
#define VXEVENT_REDRAW              4    /* redraw request from vvideo   */
#define VXEVENT_HIDE                5    /* change in foreground session */
#define VXEVENT_FOREGROUND          6    /* change in foreground session */
#define VXEVENT_BACKGROUND          7    /* change in foreground session */
#define VXEVENT_STRING              8    /* string output                */

#define VXEVENT_MAX                 8

#define VXEVENTMASK_MODE            0x00000001  /* change in VDM's mode         */
#define VXEVENTMASK_LVB             0x00000002  /* change in VDM's LVB          */
#define VXEVENTMASK_CURSOR          0x00000004  /* cursor position/type change  */
#define VXEVENTMASK_REDRAW          0x00000008  /* redraw request from vvideo   */
#define VXEVENTMASK_HIDE            0x00000010  /* redraw request from vvideo   */
#define VXEVENTMASK_FOREGROUND      0x00000020  /* change in foreground session */
#define VXEVENTMASK_BACKGROUND      0x00000040  /* change in foreground session */
#define VXEVENTMASK_STRING          0x00000080  /* string output                */
#define VXEVENTMASK_ANY             0xffffffff

#define XEVENT_FLUSH                0x0002      /* flush event immediately           */
#define XEVENT_ASYNC                0x0008      /* asynchronous event                */
#define XEVENT_FORCE                0x0010      /* force to add even if the event is masked */
#define XEVENT_OWNER                0x1000      /* caller owns EventUpdate semaphore */

typedef struct vxe_s {
    LONG   vxe_iEvent;          /* one of the VVDEVENT_* constants       */
    ULONG  vxe_sgID;            /* screen group ID of VDM --- Input !!   */
    ULONG  vxe_nData;           /* # of entries of information returned  */
    ULONG  vxe_iEventMask;      /* event mask                            */
} VXEVENT;

typedef VXEVENT FAR *PVXEVENT;

/*** VXVIO exported function prototypes
 */

 /* vvc (input for SETCURSOR and output for WaitEvent request) */
typedef struct vxc_s {
    ULONG  vxc_row;             /* row (y position) of VDM's cursor            */
    ULONG  vxc_col;             /* column (x position) of VDM's cursor         */
    ULONG  vxc_ulScanStart;     /* starting scan-line for VDM's cursor         */
    ULONG  vxc_ulScanEnd;       /* ending scan-line for VDM's cursor           */
    ULONG  vxc_attribute;       /* cursor color( hide )/blink etc.             */
    ULONG  vxc_frequest;        /* indicate request type. posion, type or both.*/
} VXCURSOR;

typedef VXCURSOR FAR *PVXCURSOR;

/* bit definition for vxc_attribute */

#define CURS_MASKBLINK              0x0300
#define CURS_BLINKOFF               0x0000
#define CURS_BLINKLOW               0x0100
#define CURS_BLINKMED               0x0200
#define CURS_BLINKHI                0x0300
#define CURS_MASKCOLOR              0x00f0   /* CURS_COLOR is always 0 for output parmeter */
#define CURS_HIDDEN                 0x0001

/* definition for vxc_frequest */

#define VXC_SETPOSITION             0x00000001
#define VXC_SETCTYPE                0x00000002

typedef struct vxws_s {         /* vvws (write string event) */
    ULONG  vxws_row;            /*start row position        */
    ULONG  vxws_col;            /*start column position     */
    ULONG  vxws_depth;          /*write depth               */
    ULONG  vxws_psinfo;         /*indicate presence of PS   */
} VXWSTR;

typedef VXWSTR FAR *PVXWSTR;

typedef struct vxs_s {          /* vvs (output for SCROLL event) */
    RECTL  vxs_rcl;             /* rectangle being scrolled */
    LONG   vxs_fill;            /* fill value */
    LONG   vxs_nRows;           /* # rows (negative means reverse scroll) */
    LONG   vxs_nCols;           /* # columns (0,0 means rectangle blankfilled) */
} VXSCROLL;

typedef VXSCROLL FAR *PVXSCROLL;

typedef struct vxa_s {          /* vva (output for STRING event) */
    ULONG  vxa_row;             /* beginning row of string */
    ULONG  vxa_col;             /* beginning column of string */
    ULONG  vxa_nChars;          /* # characters in string */
} VXSTRING;

typedef VXSTRING FAR *PVXSTRING;

#define FORMATID_EPOCHCOLOR         0x41
#define FORMATID_EPOCHMONO          0x81
#define FORMATID_MCKCOLOR           0x20
#define FORMATID_COMMON             0x70

typedef RECTL  VXLVB;
typedef VXLVB  FAR *PVXLVB;

/*** VXVIO - VVD entry table
 */

typedef LONG (PRIVENTRY *PVVDENTRY)(HVDM, ULONG, PVOID, ULONG, PVOID);
typedef VOID (PRIVENTRY *PXVIOENTRY)();

typedef struct vxex_s {             /* vxex (VXVIO service entries) */
    PXVIOENTRY  vxex_SetVVDType;
    PXVIOENTRY  vxex_AddEvent;
    PXVIOENTRY  vxex_FlushEvent;
    PXVIOENTRY  vxex_SetStatus;
} VXENTRYSX;

typedef VXENTRYSX FAR *PVXENTRYSX;

typedef struct vxev_s {             /* vxev (VVD service entries) */
    PVVDENTRY   vxev_GetCursor;
    PVVDENTRY   vxev_SetCursor;
    PVVDENTRY   vxev_CopyLVB;
    PVVDENTRY   vxev_WriteString;
    PVVDENTRY   vxev_SaveScreen;
    PVVDENTRY   vxev_RestoreScreen;
} VXENTRYSV;

typedef VXENTRYSV FAR *PVXENTRYSV;

#define XVIO_RESET_FLAG             0
#define XVIO_SET_FLAG               1

#define XVIO_STATUS_MODECHANGING    0
#define XVIO_STATUS_XVIOUPDATING    1
#define XVIO_STATUS_STATEINIT       2

/***EK+ VXVIO constants for inter-VDD communication
 */

#define VXDEVREQ_REGISTERVVD    1   /* register VVD into VXVIO */

#define VXDEVREQ_MAX            1

typedef struct vxr_s {
    ULONG       vxr_VVDID;
    VXENTRYSX   vxr_XVIOEntry;
} VXREGISTER;

typedef VXREGISTER FAR *PVXREGISTER;
