/*static char *SCCSID = "@(#)vfdpfd.h	6.9 91/10/31";*/
/***    Virtual Floppy Device Driver VDD/PDD Communication Interface
 *
 *      SCCSID = @(#)vfdpfd.h	6.9 91/10/31
 *
 *      IBM/Microsoft Confidential
 *
 *      Copyright (c) IBM Corporation 1987, 1989
 *      Copyright (c) Microsoft Corporation 1987, 1989
 *
 *      All Rights Reserved
 *
 *      DESCRIPTION
 *      Floppy VDD/PDD shared structures/constants
 *
 *      MODIFICATION HISTORY
 *      --------------------
 *      06/13/90 MTS  Created.
 *
 *      05/07/91 RCW  Changed all occurences of the single line comment
 *                    notation to the standard notation to allow users to
 *                    maintain ANSI compatibility.  This is in response to
 *                    PTR B718526.  All future updates to this and all other
 *                    header files should use the standard commenting format.
 *
 */

/* Floppy PDD component definitions */

#define FLPY_NAME       "FLPY$"


/***    PDD function commands
 *
 *  Format:
 *      (*fpfnPFDProc)(PFDCMD_*, ul1, ul2);
 *
 *  PFDCMD_REGISTER:
 *      ENTRY
 *          ul1 == segment of 16:32 VDD entry point
 *          ul2 ==  offset of 16:32 VDD entry point
 *      EXIT
 *          Returns TRUE
 *      CONTEXT
 *          Init-time
 *
 *  PFDCMD_DEREGISTER:
 *      ENTRY
 *          ul1 == 0                    //not used
 *          ul2 == 0                    //not used
 *      EXIT
 *          Returns TRUE
 *      CONTEXT
 *          Task-time
 *
 *  PFDCMD_REQFLOPPY:
 *      ENTRY
 *          ul1 == 0                    //not used
 *          ul2 == 0                    //not used
 *      EXIT-SUCCESS
 *          returns TRUE - ownership granted
 *      EXIT-FAILURE
 *          return FALSE - floppy currently busy
 *                         delay ownership notification required
 *      CONTEXT
 *          VDM Task-time
 *      NOTE
 *          This request is non-blocking.
 *
 *  PFDCMD_FREEFLOPPY:
 *      ENTRY
 *          ul1 == 0                    //not used
 *          ul2 == 0                    //not used
 *      EXIT
 *          Returns TRUE
 *      CONTEXT
 *          VDM Task-time
 *      NOTE
 *          VFD may call PFD to free the floppy even if PFD has never
 *          requested it.  This may occur if the VDM owner has died
 *          in which case the ownership is returned to the PFD.
 */

//masm-begin
//PDDCMD_REGISTER      EQU     0
//masm-end

#define PFDCMD_REGISTER         PDDCMD_REGISTER         /* register VDD          */
#define PFDCMD_DEREGISTER       (PFDCMD_REGISTER+1)     /* de-register of VDD    */
#define PFDCMD_REQFLOPPY        (PFDCMD_REGISTER+2)     /* req. floppy ownership */
#define PFDCMD_FREEFLOPPY       (PFDCMD_REGISTER+3)     /* free floppy ownership */
#define PFDCMD_HOOKIRQ6         (PFDCMD_REGISTER+4)     /* HOOK IRQ6 INTS */

#define PFDCMD_LASTEVENT        PFDCMD_FREEFLOPPY


/***    VDD function commands
 *
 *  Format:
 *      (*fpfnVFDProc)(VFDCMD_*, ul1, ul2);
 *
 *  VFDCMD_REQFLOPPY:
 *      ENTRY
 *          ul1 == 0                    //not used
 *          ul2 == 0                    //not used
 *      EXIT-SUCCESS
 *          returns TRUE - ownership granted
 *      EXIT-FAILURE
 *          returns FALSE - floppy currently busy
 *                          delay ownership notification required
 *      CONTEXT
 *          Task-time
 *          Interrupt-time
 *      NOTE
 *          This request is non-blocking.
 *
 *  VFDCMD_FREEFLOPPY:
 *      ENTRY
 *          ul1 == 0                    //not used
 *          ul2 == 0                    //not used
 *      EXIT-SUCCESS
 *          Returns TRUE
 *      EXIT-FAILURE
 *          Returns FALSE - ownership not accepted because requester has died
 *      CONTEXT
 *          Task-time
 *          Interrupt-time
 *
 *  VFDCMD_INTERRUPTEVENT:
 *      ENTRY
 *          ul1 == 0                    //not used
 *          ul2 == 0                    //not used
 *      EXIT
 *          Returns TRUE
 *      CONTEXT
 *          Interrupt-time
 */

#define VFDCMD_REQFLOPPY        0x00
#define VFDCMD_FREEFLOPPY       0x01
#define VFDCMD_INTERRUPTEVENT   0x02

#define VFDCMD_LASTEVENT        VFDCMD_INTERRUPTEVENT
