/*static char *SCCSID = "@(#)sysbloks.h	6.1 90/11/16";*/
/*static char *SCCSID = "@(#)sysbloks.h 13.2 89/02/01";*/
/* Tom Burke - 04/16/86 */

/* bios parameter block */

struct BPB {			     /* bios parameter block		 */
  unsigned bytes_per_sector;	     /* sector size		      2	 */
  unsigned char sectors_per_cluster; /* sectors per allocation unit   1	 */
  unsigned reserved_sectors;	     /* number of reserved sectors    2	 */
  unsigned char nbr_fats;	     /* number of fats		      1	 */
  unsigned root_entries;	     /* number of directory entries   2	 */
  unsigned total_sectors;	     /* number of sectors	      2	 */
  char media_type;		     /* fatid byte		      1	 */
  unsigned sectors_per_fat;	     /* sectors in a copy of the FAT  2	 */
  unsigned sectors_per_track;	     /* number of sectors per track   2	 */
  unsigned number_of_heads;	     /* number of heads		      2	 */
  unsigned hidden_sectors;	     /* number of hidden sectors      2	 */
  unsigned reserved_1;		     /*				      2	 */
  unsigned large_total_sectors;	     /* large total sectors	      2	 */
  unsigned reserved_2;		     /*				      2	 */
  char reserved_3[6];		     /* 6 reserved bytes	      6	 */
};				     /*	    total byte size = 31	 */

/* device parameter block */

struct DPB {			     /* device parameter block		 */
  struct BPB dev_bpb;		     /* 31 byte extended bpb		 */
  unsigned number_of_tracks;	     /* number of tracks		 */
  char device_type;		     /* device type	   see DT_	 */
  unsigned device_attributes;	     /* device attributes  see DA_	 */
};

#define DT_FLOPPY_LD   0	     /* 48 TPI low density diskette	 */
#define DT_FLOPPY_HD   1	     /* 96 TPI high density diskette	 */
#define DT_SMALL_DRIVE 2	     /* 3 1/2 inch drive		 */
#define DT_8IN_SD      3	     /* 8 inch single density floppy	 */
#define DT_8IN_DD      4	     /* 8 inch double density floppy	 */
#define DT_HARD_DISK   5	     /* hard disk drive			 */
#define DT_TAPE_DRIVE  6	     /* tape drive			 */
#define DT_OTHER       7	     /* unknown device type		 */

#define DA_REMOVABLE   0x0001	     /* removable media flag		 */
#define DA_CHANGELINE  0x0002	     /* detects when it has been changed */

/* directory entry */

struct DIR_ENTRY {		     /* directory entry, 32 bytes	 */
  char file_name[8];		     /*	 0 -  7				 */
  char ext_name[3];		     /*	 8 - 10				 */
  char attribute;		     /* 11				 */
  char reserved[10];		     /* 12 - 21				 */
  unsigned int time;		     /* 22 - 23				 */
  unsigned int date;		     /* 24 - 25				 */
  unsigned int first_cluster;	     /* 26 - 27				 */
  unsigned long file_size;	     /* 28 - 31				 */
};

/* fat table entry */

union FAT {			     /* 512 byte fat sector		 */
  unsigned fat16[256];		     /* 16 bit fat entries		 */
  char fat8[512];		     /* fat as a byte stream		 */
};
