/* SCCSID = @(#)shcrt.h	6.3 91/11/14 */
/**********************************************************************\
 *                                                                    *
 *                     IBM/Microsoft Confidential                     *
 *                                                                    *
 *               Copyright (c) IBM Corporation  1987, 1990            *
 *               Copyright (c) Microsoft Corp.  1987, 1990            *
 *                         All Rights Reserved                        *
 *                                                                    *
\**********************************************************************/

/**********************************************************************\
 * C RunTime Header File for PMWP DLL                                 *
\**********************************************************************/

#define STRIP_LEADING  1
#define STRIP_TRAILING 2
VOID APIENTRY stripblanks( PSZ pszString, USHORT flags );

USHORT APIENTRY strlen( PSZ pszString );
PSZ    APIENTRY strchr( PSZ pszString, UCHAR c );
PSZ    APIENTRY strrchr( PSZ pszString, UCHAR c );
VOID   APIENTRY strcpy( PSZ pszDestination, PSZ pszSource );
VOID   APIENTRY memcpy( PSZ pbDestination, PSZ pbSource, USHORT cb );
USHORT APIENTRY memcmp( PSZ pbDestination, PSZ pbSource, USHORT cb );
VOID   APIENTRY memset( PSZ pbDestination, UCHAR ch, ULONG cb);
VOID   APIENTRY strcat( PSZ pszDestination, PSZ pszSource );
SHORT  APIENTRY strcmp( PSZ pszString1, PSZ pszString2 );
VOID   APIENTRY itoa( USHORT n, PSZ s );
VOID   APIENTRY itoah( USHORT usValue, PSZ szValue );
SHORT  APIENTRY atoi( PSZ szValue );                 /* @sign */
BOOL   APIENTRY isnumber( PSZ pszValue );             /* JudyL */
VOID   APIENTRY ultoa( ULONG n, PSZ s );
VOID   APIENTRY ultoac( ULONG n, PSZ s );
USHORT APIENTRY isdbcs (UCHAR ch);
PCH APIENTRY nextpch (PCH pszString);
PCH APIENTRY prevpch (PCH pszBegin, PCH pszString);
USHORT APIENTRY strcmpi (PCH pszString1, PCH pszString2);
USHORT APIENTRY strncmpi (PCH pszString1, PCH pszString2, USHORT n);
PCH APIENTRY strncat_trunc (PCH pszString1, PCH pszString2, USHORT n);
PCH APIENTRY strncat (PCH pszString, PCH pszString2, USHORT n);
PCH APIENTRY strncpy_trunc (PCH pszString1, PCH pszString2, USHORT n);
PCH APIENTRY strncpy (PCH pszString, PCH pszString2, USHORT n);
PCH APIENTRY strstr (PCH pszString1, PCH pszString2);
PCH APIENTRY strupr (PCH pszString);
VOID APIENTRY xlatblank (PCH pszString);
USHORT APIENTRY strncmp (PCH pszString1, PCH pszString2, USHORT n);
ULONG  APIENTRY atol  (PSZ pszString);
PSZ APIENTRY strpbrk (PSZ, PSZ);
#define decpch(pszBegin,pszString) (pszString=prevpch(pszBegin,pszString))
#define incpch(pszString) (pszString=nextpch(pszString))


/* Macros */
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#define toupper(c) (((c >= 'a') && (c <= 'z')) ? c + 'A' - 'a' : c )

/* Macros for isalpha, isupper, etc. */
#ifndef _INC_CTYPE

/* Look-up array, _ctype, is in ctype.obj. */

extern unsigned char _cdecl _ctype[];


/* set bit masks for the possible character types */

#define _UPPER          0x1     /* upper case letter */
#define _LOWER          0x2     /* lower case letter */
#define _DIGIT          0x4     /* digit[0-9] */
#define _SPACE          0x8     /* tab, carriage return, newline, */
                                /* vertical tab or form feed */
#define _PUNCT          0x10    /* punctuation character */
#define _CONTROL        0x20    /* control character */
#define _BLANK          0x40    /* space char */
#define _HEX            0x80    /* hexadecimal digit */


/* the character classification macro definitions */

#define isalpha(_c)     ( (_ctype+1)[_c] & (_UPPER|_LOWER) )
#define isupper(_c)     ( (_ctype+1)[_c] & _UPPER )
#define islower(_c)     ( (_ctype+1)[_c] & _LOWER )
#define isdigit(_c)     ( (_ctype+1)[_c] & _DIGIT )
#define isxdigit(_c)    ( (_ctype+1)[_c] & _HEX )
#define isspace(_c)     ( (_ctype+1)[_c] & _SPACE )
#define ispunct(_c)     ( (_ctype+1)[_c] & _PUNCT )
#define isalnum(_c)     ( (_ctype+1)[_c] & (_UPPER|_LOWER|_DIGIT) )
#define isprint(_c)     ( (_ctype+1)[_c] & (_BLANK|_PUNCT|_UPPER|_LOWER|_DIGIT) )
#define isgraph(_c)     ( (_ctype+1)[_c] & (_PUNCT|_UPPER|_LOWER|_DIGIT) )
#define iscntrl(_c)     ( (_ctype+1)[_c] & _CONTROL )
#ifndef NO_EXT_KEYS
#undef  toupper
#define toupper(_c)     ( (islower(_c)) ? _toupper(_c) : (_c) )
#define tolower(_c)     ( (isupper(_c)) ? _tolower(_c) : (_c) )
#endif
#define _tolower(_c)    ( (_c)-'A'+'a' )
#define _toupper(_c)    ( (_c)-'a'+'A' )
#define isascii(_c)     ( (unsigned)(_c) < 0x80 )
#define toascii(_c)     ( (_c) & 0x7f )

/* 2.0 extended ctype macros */

#define iscsymf(_c)     (isalpha(_c) || ((_c) == '_'))
#define iscsym(_c)      (isalnum(_c) || ((_c) == '_'))

#define _INC_CTYPE

#endif  /* _INC_CTYPE */
