/****************************** Module Header ******************************\
*
* Module Name: PMTKTP.H
*
* Private OS/2 Presentation Manager Help Toolkit include file
*
* Copyright (c) International Business Machines Corporation 1981, 1988-1992
*
* PRIVATE VERSION - IBM CONFIDENTIAL
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
#ifndef __IBMC__
   * The 32-bit version of this file (as placed into the IBMH directory)
   * excludes all non 32-bit material marked in this file as well
   * as any areas specifically marked with __IBMC__ conditional
   * sections - including this paragraph. The H2IBMH rexx command file
   * removes these sections.
#endif
* ===========================================================================
*
* History:
*   7-Dec-87  ??????  who created this file ?????
*   8-Dec-87  MPerks  changed file to meet include file standards
*
\***************************************************************************/

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( none )
      #endif
   #pragma info( restore )
#endif
/* INC */

#define PMTKTP_INCLUDED

#ifndef INCL_32         /* If neither INCL_32 or INCL_16 set already */
   #ifndef INCL_16      /* find out from compiler if 32-bit or not.  */
     #ifdef M_I386
        #define INCL_32 /* Compiling for 32-bit */
     #else
        #define INCL_16 /* Compiling for 16-bit */
     #endif
  #endif
#endif

#ifdef INCL_HELP
/* values for help resources and predefined resource ids */
#define RT_TEXT   256        /* text resource type */

#define THI_UNDEFINED -1        /* unknown index (do not use !!!) */
#define THI_INDEX      1        /* index panel */
#define THI_KEYS       2        /* keys panel */
#define THI_ABOUT      3        /* first panel number available for user */

#ifndef RC_INVOKED

/* Help handle */
typedef ULONG HHELP;

/* Help Initialization structure */
typedef struct _HIS {   /* his */
    USHORT cxWidth;
    USHORT cyHeight;
} HIS;
typedef HIS FAR *PHIS;

#ifdef INCL_16
/*** Toolkit Help functions */
HHELP EXPENTRY HlpInit (HAB hab, HMODULE hmod, HWND hwndReg, PSZ pszApp,
        USHORT cb, PHIS lphis);
BOOL  EXPENTRY HlpRegisterContext (HHELP hhelp, HMODULE hmod, SHORT idRes);
BOOL  EXPENTRY HlpDestroy (HHELP hhelp);
BOOL  EXPENTRY HlpRequest (HHELP hhelp, SHORT idRes, SHORT idMainRes,
        USHORT cch, PSZ pszText, SHORT x, SHORT y, USHORT cx, USHORT cy);
BOOL  EXPENTRY HlpQueryStatus (HHELP hhelp, PHWND phwndFrame);
BOOL  EXPENTRY HlpHide (HHELP hhelp);
#endif

#endif /* RC_INVOKED */

#endif /* INCL_HELP */

#ifdef INCL_TKTP
/* Common strings (for use by WtiAlertBox() */

#define IDS_MERGE1      0      /* merge string (%%) */
#define IDS_IFN         1      /* %% is not a valid filename. */
#define IDS_FNF         2      /* %% not found - Create new file? */
#define IDS_REF         3      /* Replace existing %%? */
#define IDS_SCC         4      /* %% has changed. Save current changes? */
#define IDS_EOF         5      /* Error opening %% */
#define IDS_ECF         6      /* Error creating %% */

/* Common msg     box Help Ids */
#define IDMB_IFN        -1
#define IDMB_FNF        -2
#define IDMB_REF        -3
#define IDMB_SCC        -4
#define IDMB_EOF        -5
#define IDMB_ECF        -6

/* Dialog box IDs Open/Save IDs */
#define IDD_FILEOPEN    -1
#define IDD_FILESAVE    -2
#define IDD_PMTKT_OPEN          255
#define IDD_PMTKT_SAVEAS        254
#define IDD_PMTKT_LOGO          253

#define ATTRDIRLIST     0x4010 /* include directories and drives in listbox */

#define APPNAMEMAX        40   /* for help use, truncated if larger */
#define MAX_FNAME_LEN     260
#define CBEXTMAX           6
#define CBROOTNAMEMAX    (MAX_FNAME_LEN - CBEXTMAX - 1)
#define MAXMESSAGELENGTH (MAX_FNAME_LEN + 120) /* maximum cb of a msg
                                (instruction or warning). */

/* Action value for WtiDlgFile, the values may be ORed, except DLG_OPENDLG */
/* and DLG_SAVEDLG. */
#define DLG_OPENDLG 0x00        /* Use the Open dialog box. */
#define DLG_SAVEDLG 0x01        /* Use the Save (As) dialog box */
#define DLG_NOOPEN  0x02        /* Don't Open the file we selected */
#define DLG_HELP    0x04        /* The dialog box supports Help */

/* Return values from WtiDlgFile : */
#define TDF_ERRMEM   0
#define TDF_INVALID  1
#define TDF_NOOPEN   2
#define TDF_NEWOPEN  3
#define TDF_OLDOPEN  4
#define TDF_NOSAVE   5
#define TDF_NEWSAVE  6
#define TDF_OLDSAVE  7


/* Some ROP GPICALLS.H doesn't define */
#define ROP_Pn           (LONG)0x0000000f
#define ROP_DSan         (LONG)0x00000077

/* Flags for WtiOpenFile */
#define OF_REOPEN 0x8000
#define OF_EXIST  0x4000
#define OF_PROMPT 0x2000
#define OF_CREATE 0x1000
#define OF_CANCEL 0x0800
#define OF_VERIFY 0x0400
#define OF_DELETE 0x0200
#define OF_PARSE  0x0100

#define OF_READ      0x0080
#define OF_WRITE     0x0040
#define OF_READWRITE 0x0020

/* flAttributes used to filter entries provided by DlgFillListBox */
#define BITATTRDRIVE 0x4000
#define BITATTRDIR   0x0010

#ifndef RC_INVOKED

/* Useful abreviations */
typedef char *PSTR;
typedef SHANDLE FAR *PHANDLE;

/* Data structure used to pass information to WtiDlgFile(). */
typedef struct _DLF {   /* dlf */
        USHORT   rgbAction;             /* action usType:  eg. DLG_OPEN     */
        USHORT   rgbFlags;              /* open file flAttributes         */
        PHANDLE  phFile;                /* file handle                    */
        PSZ      pszExt;                /* default file extension "\.ext" */
        PSZ      pszAppName;            /* application name               */
        PSZ      pszTitle;              /* panel title or NULL            */
        PSZ      pszInstructions;       /* panel instructions or NULL     */
        CHAR szFileName[MAX_FNAME_LEN]; /* relative file name             */
        CHAR szOpenFile[MAX_FNAME_LEN]; /* full path name of current file */
} DLF;
typedef DLF *NPDLF;
typedef DLF FAR *PDLF;

/*  Brush structure */
typedef struct _BRUSH { /* tkbr */
    LONG   lColor;
    USHORT usSymbol;
    ULONG  rop;
    } BRUSH;
typedef BRUSH *NPBRUSH;
typedef BRUSH FAR *PBRUSH;

#ifdef INCL_16
/*  Exported functions of the Tool Kit library. */
PSZ   EXPENTRY WtiItoa (int n, PSZ pszResult);
int   EXPENTRY WtiAlertBox (HWND hwndOwner, int idMes, PSZ pszTextIns,
        PSZ pszCaption, USHORT idMB, USHORT usStyle);
BOOL  EXPENTRY WtiMergeStrings (PSZ pszSrc, PSZ pszMerge, PSZ pszDst);
VOID  EXPENTRY WtiLCopyStruct (PCH pchSrc, PCH pchDst, int cb);
VOID  EXPENTRY WtiLFillStruct (PCH pchDst, int cb, BYTE fillByte);
int   EXPENTRY Wtilstrlen (PSZ psz);
PSZ   EXPENTRY Wtilstrcpy (PSZ pszDst, PSZ pszSrc);
PSZ   EXPENTRY Wtilstrcat (PSZ pszDst, PSZ pszSrc);
int   EXPENTRY Wtilstrcmp (PSZ psz1, PSZ psz2);
USHORT  EXPENTRY WtiMultDiv (USHORT num1, USHORT num2, USHORT denominator);
VOID  EXPENTRY WtiBitBlt(HPS hpsDst, int xDst, int yDst, int cx, int cy,
        HPS hpsSrc, int xSrc, int ySrc, ULONG rop);
VOID  EXPENTRY WtiPatBlt(HPS hpsDst, int xDst, int yDst, int cx, int cy,
        ULONG rop);
VOID  EXPENTRY WtiStretchBlt(HPS hpsDst, int xDst, int yDst, int cxDst,
        int cyDst, HPS hpsSrc, int xSrc, int ySrc, int cxSrc, int cySrc,
        ULONG rop, USHORT mode);
BOOL  EXPENTRY WtiSetEAString(HFILE hfile,PSZ pszName,PSZ pszString);
HPS   EXPENTRY WtiCreateMemoryPS(HDC hdsCompat, HDC FAR * lphdcOut);
ULONG EXPENTRY WtiGetTextExtent(HPS hps, PCH lpstr, int cch);
int   EXPENTRY WtiSetBitmapBits (HDC hdc, HBITMAP hbm, BOOL fSelect,
        USHORT cLines, PBYTE pBits);
int   EXPENTRY WtiGetBitmapBits (HDC hdc, HBITMAP hbm, BOOL fSelect,
        USHORT cLines, PBYTE pBits);
HBITMAP EXPENTRY WtiCreateCompatibleBitmap (HPS hps, USHORT cx, USHORT cy);
ULONG EXPENTRY WtiDevQueryCaps (HDC hdc, USHORT index);

int EXPENTRY WtiDlgFile(HWND hwndOwner, PDLF pdlf);
BOOL EXPENTRY WtiOpenFile(PSZ pszFileIn, PHANDLE hf, PSZ pszFileOpen,
        USHORT usOFMode);
VOID EXPENTRY WtiAddExt(PSZ pszFile, PSZ pszExt);
PSZ  EXPENTRY WtiFileInPath(PSZ pszPath);
SHORT EXPENTRY WtiLogo(HWND hwndMainFrame, PSZ pszApp, PSZ pszVersion,
        PSZ pszIBM, PSZ pszMS);
#endif
#endif

#endif /* INCL_TKTP */

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( restore )
      #endif
   #pragma info( restore )
#endif
/* INC */

/**************************** end of file **********************************/
