/****************************** Module Header ******************************\
*
* Module Name: PMSPLP.H
*
* OS/2 Presentation Manager Spooler PRIVATE function declarations
*
* Copyright (c) International Business Machines Corporation 1981, 1988-1992
*
* PRIVATE VERSION - IBM CONFIDENTIAL
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
#ifndef __IBMC__
   * The 32-bit version of this file (as placed into the IBMH directory)
   * excludes all non 32-bit material marked in this file as well
   * as any areas specifically marked with __IBMC__ conditional
   * sections - including this paragraph. The H2IBMH rexx command file
   * removes these sections.
#endif
\***************************************************************************/

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( none )
      #endif
   #pragma info( restore )
#endif
/* INC */

#define PMSPLP_INCLUDED

#ifndef INCL_32         /* If neither INCL_32 or INCL_16 set already */
   #ifndef INCL_16      /* find out from compiler if 32-bit or not.  */
     #ifdef M_I386
        #define INCL_32 /* Compiling for 32-bit */
     #else
        #define INCL_16 /* Compiling for 16-bit */
     #endif
  #endif
#endif

/* IOctl for DosPrintJobGetId */
#define SPOOL_LMCAT                     83
#define SPOOL_LMGetPrintId              0x60


#ifdef INCL_32
#define SplQmInitialize        Spl32QmInitialize
#define SplQmTerminate         Spl32QmTerminate
#define SplQmSpoolerPresent    Spl32QmSpoolerPresent
#define SplQmChooseLogAddr     Spl32QmChooseLogAddr
#define SplPrmSpool            Spl32PrmSpool
#define SplQmCancelPrintingJob Spl32QmCancelPrintingJob
#define SplQmCancelWaitingJobs Spl32QmCancelWaitingJobs
#define SplQmQueryPrintRes     Spl32QmQueryPrintRes
#define SplVqIfInit            Spl32VqIfInit
#define SplInit                Spl32Init
#endif /*INCL_32*/


/*** Spooler Initialization (called by PMSHELL at boot time) */
#ifdef INCL_32
BOOL   APIENTRY Spl32Init(VOID);

SPLERR APIENTRY SplQueryJobFile(PSZ   pszComputer,
                                PSZ   pszQname,
                                ULONG ulJobID,
                                PSZ   pszFile);

SPLERR APIENTRY SplRenameQueue (PSZ    pszComputerName,
                                 PSZ    pszQueueName,
                                 PSZ    pszNewQueueName);
SPLERR APIENTRY SplQueryDriver(PSZ    pszComputerName,
                               PSZ    pszDriverName,
                               PSZ    pszPrinterName,
                               ULONG  ulLevel,
                               PVOID  pBuf,
                               ULONG  cbBuf,
                               PULONG pcbNeeded);

SPLERR APIENTRY SplSetDriver(PSZ   pszComputerName,
                             PSZ   pszDriverName,
                             PSZ   pszPrinterName,
                             ULONG ulLevel,
                             PVOID pBuf,
                             ULONG cbBuf,
                             ULONG ulParmNum);

#else
BOOL   EXPENTRY SplInit(VOID);

SPLERR APIENTRY DosPrintJobAdd2(
            PSZ     pszServer,
            PSZ     pszQueueName,
            USHORT  uLevel,
            PBYTE   pbBuf,
            USHORT  cbBuf,
            PSZ     pszFileName,
            PUSHORT puJobId);

SPLERR APIENTRY DosPrintJobSchedule(
            PSZ     pszServer,
            USHORT  uJobId);

SPLERR APIENTRY CorePrintJobEnum(
        PSZ     pszServer,
        PSZ     pszQueueName,
        USHORT  uLevel,
        PBYTE   pbBuf,
        USHORT  cbBuf,
        PUSHORT pcReturned,
        PUSHORT pcTotal);

SPLERR APIENTRY Spl16EnumPrinter(PSZ     pszComputerName,
                                 ULONG   uLevel,
                                 ULONG   flType,
                                 PVOID   pbBuf,
                                 ULONG   cbBuf,
                                 PULONG  pcReturned,
                                 PULONG  pcTotal,
                                 PULONG  pcbNeeded,
                                 PVOID   pReserved);

SPLERR APIENTRY Spl16CopyJob(PSZ    pszSrcComputerName,
                             PSZ    pszSrcQueue,
                             ULONG  ulSrcJob,
                             PSZ    pszTrgComputerName,
                             PSZ    pszTrgQueueName,
                             PULONG pulTrgJob);


#endif

typedef char SPLLOGADDR[9];     /* ASCIIZ 8 char address               */
typedef char SPLQUNAME[9];      /* ASCIIZ 8 char queue name            */
typedef char SPLUNCQUNAME[28];  /* ASCIIZ 27 char UNC queue name -     */
                                /* \\server\queue (server<=16,queue<=8)*/

typedef struct _QNLIST {        /* qnlst */
    USHORT    QueueCount;
    SPLUNCQUNAME QueueName[1];
} QNLIST;
typedef QNLIST FAR *PQNLIST;

typedef struct _LOGADDRLIST {   /* lgadr */
    USHORT      LogAddrCount;
    SPLLOGADDR  LogAddr[1];
} LOGADDRLIST;
typedef LOGADDRLIST FAR *PLOGADDRLIST;

typedef struct _JOBTIMESTAMP {  /* jbt */
    UCHAR  Hour;
    UCHAR  Mins;
    UCHAR  Secs;
    UCHAR  Hsecs;
    UCHAR  Day;
    UCHAR  Month;
    USHORT Year;
} JOBTIMESTAMP;
typedef JOBTIMESTAMP FAR *PJOBTIMESTAMP;

typedef struct _SPLCONTROL {    /* sctl */
    USHORT DriverName;
    USHORT DriverData;
    USHORT LogAddr;
    USHORT DataType;
    USHORT Comment;
    USHORT ProcName;
    USHORT ProcParams;
    USHORT SplParams;
    USHORT NetParams;
    USHORT DocName;
    CHAR   CtrlData[1];
} SPLCONTROL;
typedef SPLCONTROL FAR *PSPLCONTROL;

/*** Spooler Job Control functions */
BOOL   EXPENTRY SplQmHoldQueue(PSZ);

BOOL   EXPENTRY SplQmReleaseQueue(PSZ);

BOOL   EXPENTRY SplQmHoldJob(PSZ, USHORT);

BOOL   EXPENTRY SplQmReleaseJob(PSZ, USHORT);

BOOL   EXPENTRY SplQmCancelJob(PSZ, USHORT);

BOOL   EXPENTRY SplQmRestartJob(PSZ, USHORT);

USHORT EXPENTRY SplQmRepeatJob(PSZ, USHORT);

BOOL   EXPENTRY SplQmPrintJobNext(PSZ, USHORT);

BOOL   EXPENTRY SplQmListQueues(PQNLIST, PUSHORT);

BOOL   EXPENTRY SplQmListJobs(PSZ, PUSHORT, PUSHORT);

BOOL   EXPENTRY SplQmQueryJinfo(PSZ, USHORT, PUSHORT, PSZ,
                                PUSHORT, PUSHORT, PJOBTIMESTAMP, PSPLCONTROL,
                                PUSHORT, PSZ, PUSHORT);

USHORT EXPENTRY SplQmQueryPinfo(PSZ);

BOOL   EXPENTRY SplQmChangeJobPrty(PSZ, USHORT, USHORT);

BOOL   EXPENTRY SplQmWriteFile(HSPL, PSZ);

BOOL   EXPENTRY SplQmSetStatus(PSZ, USHORT, USHORT, PSZ);

typedef USHORT SPLVQ_QU_CALL;

#define SPLVQ_QU_CREATE         1
#define SPLVQ_QU_DESTROY        2
#define SPLVQ_QU_HOLD           3
#define SPLVQ_QU_RELEASE        4
#define SPLVQ_QU_WAITJOBSCANCEL 5

typedef USHORT SPLVQ_JB_CALL;
#define SPLVQ_JB_ENQUEUE        1
#define SPLVQ_JB_CANCEL         2
#define SPLVQ_JB_STATUSSET      3
#define SPLVQ_JB_HOLD           4
#define SPLVQ_JB_RELEASE        5
#define SPLVQ_JB_PRINTCANCEL    6
#define SPLVQ_JB_RESTART        7
#define SPLVQ_JB_START          8
#define SPLVQ_JB_REPEAT         9
#define SPLVQ_JB_PRINTNEXT      10
#define SPLVQ_JB_DEQUEUE        11

#ifdef INCL_32
BOOL  APIENTRY Spl32VqIfInit(HWND hWndNotify);
#else
/* Print Manager */
BOOL  EXPENTRY SplVqIfInit(HWND hWndNotify);
/* update message sent to the Print Manager */
#endif

#define WM_SPOOLER_NOTIFY       (WM_SPLFIRST + 7)

#ifdef INCL_32

BOOL  APIENTRY Spl32QmInitialize(PULONG pusError);

BOOL  APIENTRY Spl32QmTerminate(VOID);

BOOL  APIENTRY Spl32QmSpoolerPresent(VOID);

ULONG APIENTRY Spl32QmChooseLogAddr(PSZ pszQueueName, PSZ pszLogAddr);

ULONG APIENTRY Spl32PrmSpool(PSZ pszInLogAddr, PSZ pszOutLogAddr);

ULONG APIENTRY Spl32QmCancelPrintingJob(PSZ pszDevice, PULONG pOS2ErrCode, PULONG pSeverity);

ULONG APIENTRY Spl32QmCancelWaitingJobs(PSZ pszDevice, PULONG pOS2ErrCode, PULONG pSeverity);

#else

/*** Spooler Process Identification (called by PMSPOOL at startup time) */

BOOL   EXPENTRY SplQmInitialize(PUSHORT pusError);

BOOL   EXPENTRY SplQmTerminate(VOID);


/*** API call to determine if the PM spooler is running.  Returns TRUE  */
/*** if SplSetSpoolerPID succeeded.  Used by DevOpenDC in PMGPI to see  */
/*** if OD_QUEUED is a valid DC type.  If not, then mapped to OD_DIRECT */

BOOL   EXPENTRY SplQmSpoolerPresent(VOID);

/*** API call to map a queue name into a logical device name.  Used by  */
/*** DevOpenDC in PMGPI to map the queue name specified by an app. into */
/*** the appropriate logical name that is printer jobs for that queue.  */

USHORT EXPENTRY SplQmChooseLogAddr(PSZ pszQueueName, PSZ pszLogAddr);


/*** API call to define a mapping from one logical device name to       */
/*** another.                                                           */
USHORT EXPENTRY SplPrmSpool(PSZ pszInLogAddr, PSZ pszOutLogAddr);



/*** API calls used by PRINT.COM to manipulate print queues             */
USHORT EXPENTRY SplQmCancelPrintingJob(PSZ pszDevice, PUSHORT pOS2ErrCode, PUSHORT pSeverity);

USHORT EXPENTRY SplQmCancelWaitingJobs(PSZ pszDevice, PUSHORT pOS2ErrCode, PUSHORT pSeverity);
#endif   /* INCL_32 */

/*  This change is specific to Cutter  --  Roc                          */

BOOL   EXPENTRY SplQmQueryQinfo(PSZ, PUSHORT, PUSHORT);         /* @D3C */


/*** API call to retrieve the mapping associated with a logical device  */
/*** (i.e. returns the name of the destination logical device)          */
USHORT APIENTRY SplPrmRoute(PSZ pszInLogAddr, PSZ pszOutLogAddr);


/* API to get the print resouces the user has access to (Print Manager) */
typedef struct _PRINTRESINFO0 {             /* prres */
      ULONG flType;
      PSZ   pszName;
      PSZ   pszDescription;
} PRINTRESINFO0;
typedef PRINTRESINFO0 FAR *PPRINTRESINFO0;

#define SPLQM_PR_QUEUE             0x0001
#define SPLQM_PR_DIRECT_PRINTER    0x0002
#define SPLQM_PR_SPOOLED_PRINTER   0x0004
#define SPLQM_PR_DISPLAY_QUEUE     0x8000


#ifdef INCL_32
BOOL APIENTRY Spl32QmQueryPrintRes(HAB hab,
                                 ULONG usLevel,
                                 ULONG fsType,
                                 PVOID pbBuf,
                                 PULONG pcbBuf,
                                 PULONG pcRes);
#else
BOOL EXPENTRY SplQmQueryPrintRes(HAB hab,
                                 USHORT usLevel,
                                 USHORT fsType,
                                 PBYTE pbBuf,
                                 PUSHORT pcbBuf,
                                 PUSHORT pcRes);
#endif

#define SPL_INI_QPROC              "PM_SPOOLER_QP"
#define SPL_INI_DRIVER             "PM_SPOOLER_DD"
#define SPL_INI_PORT               "PM_SPOOLER_PORT"

#define SPL_INI_QUEUE_STATUS       "PM_SPOOLER_QUEUE_STATUS"
#define SPL_INI_QUEUE_TYPE         "PM_SPOOLER_QUEUE_TYPE"
#define SPL_INI_QUEUE_COMPUTER     "PM_SPOOLER_QUEUE_COMPUTER"
#define SPL_INI_QUEUE_REMOTEQNAME  "PM_SPOOLER_QUEUE_REMOTEQNAME"


#define CINF struct caller_info
#define PCINF struct caller_info FAR *


/**
 ** Defines for refresh messages for CP20 DCR 1499
 **/

/* Parmnum - LOUSHORT(MP2) bits 0 - 4 */

#define SPLMSG_PARMNUM_MASK        0x001F

/* Added parameter number for changing port's port driver  @24904 */
#define SPLMSG_PARMNUM_PORTDRIVER  0x0001

/* The Print destination is Direct(not connected to a Queue) */
#define SPLMSG_DIRECT              0x0080

/* All jobs in given Queue are affected */
#define SPLMSG_ALL                 0x0040

/* Object type - LOUSHORT(MP2) bits 8 - 11 */

#define SPLMSG_QUEUE               0x0100
#define SPLMSG_JOB                 0x0200
#define SPLMSG_PORT                0x0300
#define SPLMSG_DEVICE              0x0400
#define SPLMSG_PRINTER_DRIVER      0x0500
#define SPLMSG_QUEUE_DRIVER        0x0600
#define SPLMSG_QUEUE_APP_DEFAULT   0x0700
#define SPLMSG_DEVICE_APP_DEFAULT  0x0800
#define SPLMSG_OBJECT_MASK         0x0F00

/* Action type - LOUSHORT(MP2) bits 12 - 15 */

#define SPLMSG_ADD                 0x1000
#define SPLMSG_CHANGE              0x2000
#define SPLMSG_DELETE              0x3000
#define SPLMSG_HOLD                0x4000
#define SPLMSG_RELEASE             0x5000
#define SPLMSG_ACTION_MASK         0xF000

typedef struct _PRQINFO90 {        /* prq90 */
    PSZ     pszRemoteComputerName;
    PSZ     pszRemoteQueueName;
} PRQINFO90;
typedef PRQINFO90  *PPRQINFO90;

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( restore )
      #endif
   #pragma info( restore )
#endif
/* INC */

/**************************** end of file **********************************/
