/****************************** Module Header ******************************\
*
* Module Name: PMSHL.H
*
* OS/2 Presentation Manager Shell constants, types, messages and
* function declarations include file.
*
* Copyright (c) International Business Machines Corporation 1981, 1988-1992
*
* ===========================================================================
*
* The following symbols are used in this file for conditional sections.
*
*   INCL_SHLERRORS       defined if INCL_ERRORS is defined
*   INCL_WINPROGRAMLIST  Include Program List Calls
*   INCL_WINSHELLDATA    Include Presentation Manager profile calls
*   INCL_WINSWITCHLIST   Include Switch List Calls
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between XLATOFF
* and XLATON comments.
*
#ifndef __IBMC__
   * The public version of this file (as shipped with the OS/2 Toolkit
   * product) excludes all non 32-bit material marked in this file
   * as well as any areas specifically marked with __IBMC__ conditional
   * sections - including this paragraph. The H2IBMH rexx command file
   * removes these sections.
#endif
\***************************************************************************/

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( none )
      #endif
   #pragma info( restore )
#endif
/* INC */

#define SHL_INCLUDED

#ifndef INCL_32         /* If neither INCL_32 or INCL_16 set already */
   #ifndef INCL_16      /* find out from compiler if 32-bit or not.  */
     #ifdef M_I386
        #define INCL_32 /* Compiling for 32-bit */
     #else
        #define INCL_16 /* Compiling for 16-bit */
     #endif
  #endif
#endif

/*** if error definitions are required then allow Shell errors *************/
#ifdef INCL_ERRORS
   #define INCL_SHLERRORS
#endif /* INCL_ERRORS */


#ifndef SESMGR
   /*** common types, constants and function declarations ******************/


   /*** maximum title length ***********************************************/
   #define MAXNAMEL 60


   /*** program handle *****************************************************/
   typedef LHANDLE HPROGRAM;       /* hprog */
   typedef HPROGRAM FAR * PHPROGRAM;
   typedef LHANDLE HAPP;


   /*** ini file handle ****************************************************/
   typedef LHANDLE HINI;           /* hini */
   typedef HINI FAR * PHINI;


   #define HINI_PROFILE         (HINI) NULL
   #define HINI_USERPROFILE     (HINI) -1L
   #define HINI_SYSTEMPROFILE   (HINI) -2L
   #define HINI_USER    HINI_USERPROFILE
   #define HINI_SYSTEM  HINI_SYSTEMPROFILE


   typedef struct _PRFPROFILE {  /* prfpro */
      ULONG  cchUserName;
      PSZ    pszUserName;
      ULONG  cchSysName;
      PSZ    pszSysName;
   } PRFPROFILE;
   typedef PRFPROFILE FAR *PPRFPROFILE;

#endif  /* end #ifndef SESMGR */

#ifdef INCL_WINPROGRAMLIST
   /*** program list section ***********************************************/
   #ifndef SESMGR

      /*** maximum path length *********************************************/
      #define MAXPATHL 128

      /*** root group handle ***********************************************/
      #define SGH_ROOT      (HPROGRAM)-1L

      typedef struct _HPROGARRAY {     /* hpga */
         HPROGRAM ahprog[1];
      } HPROGARRAY;
      typedef HPROGARRAY FAR *PHPROGARRAY;

   #endif  /* end of #ifndef SESMGR */

   #ifdef INCL_32
      typedef ULONG PROGCATEGORY;       /* progc */
   #else
      typedef char  PROGCATEGORY;       /* progc */
   #endif

   typedef PROGCATEGORY FAR *PPROGCATEGORY;

   /*** values acceptable for PROGCATEGORY for PM groups *******************/
   #define PROG_DEFAULT             (PROGCATEGORY)0
   #define PROG_FULLSCREEN          (PROGCATEGORY)1
   #define PROG_WINDOWABLEVIO       (PROGCATEGORY)2
   #define PROG_PM                  (PROGCATEGORY)3
   #define PROG_GROUP               (PROGCATEGORY)5
   #define PROG_REAL                (PROGCATEGORY)4
   #define PROG_VDM                 (PROGCATEGORY)4
   #define PROG_WINDOWEDVDM         (PROGCATEGORY)7
   #define PROG_DLL                 (PROGCATEGORY)6
   #define PROG_PDD                 (PROGCATEGORY)8
   #define PROG_VDD                 (PROGCATEGORY)9
   #define PROG_WINDOW_REAL         (PROGCATEGORY)10
   #define PROG_WINDOW_PROT         (PROGCATEGORY)11
   #define PROG_30_STD              (PROGCATEGORY)11
   #define PROG_WINDOW_AUTO         (PROGCATEGORY)12
   #define PROG_SEAMLESSVDM         (PROGCATEGORY)13
   #define PROG_30_STDSEAMLESSVDM   (PROGCATEGORY)13
   #define PROG_SEAMLESSCOMMON      (PROGCATEGORY)14
   #define PROG_30_STDSEAMLESSCOMMON (PROGCATEGORY)14
   #define PROG_31_STDSEAMLESSVDM   (PROGCATEGORY)15
   #define PROG_31_STDSEAMLESSCOMMON (PROGCATEGORY)16
   #define PROG_31_ENHSEAMLESSVDM   (PROGCATEGORY)17
   #define PROG_31_ENHSEAMLESSCOMMON (PROGCATEGORY)18
   #define PROG_31_ENH              (PROGCATEGORY)19
   #define PROG_31_STD              (PROGCATEGORY)20
   #define PROG_DOS_GAME            (PROGCATEGORY)21
   #define PROG_WIN_GAME            (PROGCATEGORY)22
   #define PROG_DOS_MODE            (PROGCATEGORY)23
   #define PROG_RESERVED            (PROGCATEGORY)255

   #ifndef SESMGR

      #ifdef INCL_32
         typedef struct _PROGTYPE {       /* progt */
            PROGCATEGORY progc;
            ULONG        fbVisible;
         } PROGTYPE;
      #else
         typedef struct _PROGTYPE {       /* progt */
            char         progc;          /* should be PROGCATEGORY */
            UCHAR        fbVisible;
         } PROGTYPE;
      #endif
      typedef PROGTYPE FAR *PPROGTYPE;


      /*** visibility flag for PROGTYPE structure **************************/
      #define SHE_VISIBLE         0x00
      #define SHE_INVISIBLE       0x01
      #define SHE_RESERVED        0xFF

      /*** Protected group flag for PROGTYPE structure *********************/
      #define SHE_UNPROTECTED     0x00
      #define SHE_PROTECTED       0x02

      #ifndef INCL_32
         /*** window size structure ****************************************/
         typedef struct _XYWINSIZE {      /* xywin */
            SHORT x;
            SHORT y;
            SHORT cx;
            SHORT cy;
            USHORT fsWindow;
         } XYWINSIZE;
         typedef XYWINSIZE FAR *PXYWINSIZE;

         /*** Definitions for Window Positioning ***************************/
         #define XYF_NOAUTOCLOSE  0x0008
         #define XYF_MINIMIZED    0x0004
         #define XYF_MAXIMIZED    0x0002
         #define XYF_INVISIBLE    0x0001
         #define XYF_NORMAL       0X0000

         /*** these structures and definitions not used in 32-bit **********/
         typedef struct _PROGRAMENTRY {   /* proge */
            HPROGRAM hprog;
            PROGTYPE progt;
            CHAR     szTitle[MAXNAMEL+1];
         } PROGRAMENTRY;
         typedef PROGRAMENTRY FAR *PPROGRAMENTRY;

         typedef struct _PIBSTRUCT {      /* pib */
            PROGTYPE  progt;
            CHAR      szTitle[MAXNAMEL+1];
            CHAR      szIconFileName[MAXPATHL+1];
            CHAR      szExecutable[MAXPATHL+1];
            CHAR      szStartupDir[MAXPATHL+1];
            XYWINSIZE xywinInitial;
            USHORT    res1;
            LHANDLE   res2;
            USHORT    cchEnvironmentVars;
            PCH       pchEnvironmentVars;
            USHORT    cchProgramParameter;
            PCH       pchProgramParameter;
         } PIBSTRUCT;
         typedef  PIBSTRUCT FAR *PPIBSTRUCT;
      #endif


      /*** Structures associated with 'Prf' calls **************************/
      #ifdef INCL_32
         typedef struct _PROGDETAILS {  /* progde */
            ULONG     Length;         /* set this to sizeof(PROGDETAILS)  */
            PROGTYPE  progt;
            PSZ       pszTitle;       /* any of the pointers can be NULL  */
            PSZ       pszExecutable;
            PSZ       pszParameters;
            PSZ       pszStartupDir;
            PSZ       pszIcon;
            PSZ       pszEnvironment; /* this is terminated by  /0/0      */
            SWP       swpInitial;     /* this replaces XYWINSIZE          */
         } PROGDETAILS;
      #else
         typedef struct _PROGDETAILS {  /* progde */
            ULONG     Length;         /* set this to sizeof(PROGDETAILS)  */
            PROGTYPE  progt;
            USHORT    pad1[3];
            PSZ       pszTitle;       /* any of the pointers can be NULL  */
            PSZ       pszExecutable;
            PSZ       pszParameters;
            PSZ       pszStartupDir;
            PSZ       pszIcon;
            PSZ       pszEnvironment; /* this is terminated by  /0/0      */
            SWP       swpInitial;     /* this replaces XYWINSIZE          */
            USHORT    pad2[5];
         } PROGDETAILS;
      #endif
      typedef  PROGDETAILS FAR *PPROGDETAILS;

      #ifdef INCL_32
         typedef struct _PROGTITLE {           /* progti */
            HPROGRAM hprog;
            PROGTYPE progt;
            PSZ      pszTitle;
         } PROGTITLE;
      #else
         typedef struct _PROGTITLE {           /* progti */
            HPROGRAM hprog;
            PROGTYPE progt;
            USHORT   pad1[3];
            PSZ      pszTitle;
         } PROGTITLE;
      #endif
      typedef PROGTITLE FAR *PPROGTITLE;

      /*** Program List API Function Definitions ***************************/
      #ifdef INCL_16
         /* XLATOFF */
         #ifndef INCL_NOXLATE_WIN16
            #define WinQueryProgramTitles Win16QueryProgramTitles
            #define WinAddProgram Win16AddProgram
            #define WinQueryDefinition Win16QueryDefinition
            #define WinCreateGroup Win16CreateGroup
            #define PrfQueryProgramTitles Prf16QueryProgramTitles
            #define PrfAddProgram Prf16AddProgram
            #define PrfChangeProgram Prf16ChangeProgram
            #define PrfQueryDefinition Prf16QueryDefinition
            #define PrfRemoveProgram Prf16RemoveProgram
            #define PrfQueryProgramHandle Prf16QueryProgramHandle
            #define PrfCreateGroup Prf16CreateGroup
            #define PrfDestroyGroup Prf16DestroyGroup
            #define PrfQueryProgramCategory Prf16QueryProgramCategory
            #define WinStartApp Win16StartApp
            #define WinTerminateApp Win16TerminateApp
         #endif /* INCL_NOXLATE_WIN16  */
         /* XLATON */
      #endif /* INCL_16 */

      #ifndef INCL_32
         /*** these API calls not used in 32-bit ***************************/
         BOOL    APIENTRY WinQueryProgramTitles(HAB hab,
                                                HPROGRAM hprogGroup,
                                                PPROGRAMENTRY aprogeBuffer,
                                                USHORT usBufferLen,
                                                PUSHORT pusTotal);

         HPROGRAM  APIENTRY WinAddProgram(HAB hab,
                                          PPIBSTRUCT ppibProgramInfo,
                                          HPROGRAM hprogGroupHandle);

         USHORT  APIENTRY WinQueryDefinition(HAB hab,
                                             HPROGRAM hprogProgHandle,
                                             PPIBSTRUCT ppibProgramInfo,
                                             USHORT usMaxLength);

         HPROGRAM  APIENTRY WinCreateGroup(HAB hab,
                                           PSZ pszTitle,
                                           UCHAR ucVisibility,
                                           ULONG flres1,
                                           ULONG flres2);
      #endif  /* ifndef INCL_32 */

      /*** Program List API available 'Prf' calls **************************/

      ULONG APIENTRY PrfQueryProgramTitles(HINI hini,
                                           HPROGRAM hprogGroup,
                                           PPROGTITLE pTitles,
                                           ULONG cchBufferMax,
                                           PULONG pulCount);

      /*********************************************************************/
      /*  NOTE: string information is concatanated after the array of      */
      /*        PROGTITLE structures so you need to allocate storage       */
      /*        greater than sizeof(PROGTITLE)*cPrograms to query programs */
      /*        in a group.                                                */
      /*                                                                   */
      /*  PrfQueryProgramTitles recommended usage to obtain titles of all  */
      /*  programs in a group (Hgroup=SGH_ROOT is for all groups):         */
      /*                                                                   */
      /*  BufLen = PrfQueryProgramTitles(Hini, Hgroup,                     */
      /*                                  (PPROGTITLE)NULL, 0, &Count);    */
      /*                                                                   */
      /*  Alocate buffer of  Buflen                                        */
      /*                                                                   */
      /*  Len = PrfQueryProgramTitles(Hini, Hgroup, (PPROGTITLE)pBuffer,   */
      /*                               BufLen, pCount);                    */
      /*                                                                   */
      /*********************************************************************/

      HPROGRAM APIENTRY PrfAddProgram(HINI hini,
                                      PPROGDETAILS pDetails,
                                      HPROGRAM hprogGroup);

      BOOL     APIENTRY PrfChangeProgram(HINI hini,
                                         HPROGRAM hprog,
                                         PPROGDETAILS pDetails);

      ULONG    APIENTRY PrfQueryDefinition(HINI hini,
                                           HPROGRAM hprog,
                                           PPROGDETAILS pDetails,
                                           ULONG cchBufferMax);

      /*********************************************************************/
      /*  NOTE: string information is concatanated after the PROGDETAILS   */
      /*        field structure so you need to allocate storage greater    */
      /*        than sizeof(PROGDETAILS) to query programs                 */
      /*                                                                   */
      /*  PrfQueryDefinition recomended usage:                             */
      /*                                                                   */
      /*  bufferlen = PrfQueryDefinition(Hini,Hprog,(PPROGDETAILS)NULL,0)  */
      /*                                                                   */
      /*  Alocate buffer of bufferlen bytes                                */
      /*  set Length field (0 will be supported)                           */
      /*                                                                   */
      /*  (PPROGDETAILS)pBuffer->Length=sizeof(PPROGDETAILS)               */
      /*                                                                   */
      /*  len = PrfQueryDefinition(Hini, Hprog, (PPROGDETAILS)pBuffer,     */
      /*      bufferlen)                                                   */
      /*********************************************************************/

      BOOL     APIENTRY PrfRemoveProgram(HINI hini,
                                         HPROGRAM hprog);

      ULONG    APIENTRY PrfQueryProgramHandle(HINI hini,
                                              PSZ pszExe,
                                              PHPROGARRAY phprogArray,
                                              ULONG cchBufferMax,
                                              PULONG pulCount);

      HPROGRAM APIENTRY PrfCreateGroup(HINI hini,
                                       PSZ pszTitle,
                                       UCHAR chVisibility);

      BOOL     APIENTRY PrfDestroyGroup(HINI hini,
                                        HPROGRAM hprogGroup);

      PROGCATEGORY  APIENTRY PrfQueryProgramCategory(HINI hini,
                                                     PSZ pszExe);

      HAPP APIENTRY WinStartApp(HWND hwndNotify,
                                PPROGDETAILS pDetails,
                                PSZ pszParams,
                                PVOID Reserved,
                                ULONG fbOptions);

      /*** bit values for Options parameter ********************************/
      #define SAF_VALIDFLAGS  0x001F

      #define SAF_INSTALLEDCMDLINE  0x0001     /* use installed parameters */
      #define SAF_STARTCHILDAPP     0x0002     /* related application      */
      #define SAF_MAXIMIZED         0x0004     /* Start App maximized */
      #define SAF_MINIMIZED         0x0008     /* Start App minimized, if !SAF_MAXIMIZED */
      #define SAF_BACKGROUND        0x0010     /* Start app in the background */


      BOOL APIENTRY WinTerminateApp(HAPP happ);

   #endif /* end of #ifndef SESMGR */
#endif /* INCL_WINPROGRAMLIST */


/*** switch list section ***************************************************/

typedef LHANDLE HSWITCH;        /* hsw */
typedef HSWITCH FAR *PHSWITCH;

#ifndef SESMGR
   #if (defined(INCL_WINSWITCHLIST) || !defined(INCL_NOCOMMON))

      #ifdef INCL_32
         typedef struct _SWCNTRL {        /* swctl */
            HWND     hwnd;
            HWND     hwndIcon;
            HPROGRAM hprog;
            PID      idProcess;
            ULONG    idSession;
            ULONG    uchVisibility;
            ULONG    fbJump;
            CHAR     szSwtitle[MAXNAMEL+4];
            ULONG    bProgType;
         } SWCNTRL;
      #else
         typedef struct _SWCNTRL {        /* swctl */
            HWND     hwnd;
            HWND     hwndIcon;
            HPROGRAM hprog;
            USHORT   idProcess;
            USHORT   idSession;
            BYTE     uchVisibility;
            BYTE     fbJump;
            CHAR     szSwtitle[MAXNAMEL+1];
            BYTE     bProgType;
         } SWCNTRL;
      #endif

      typedef SWCNTRL FAR *PSWCNTRL;

      /*** visibility flag for SWCNTRL structure ***************************/
      #define SWL_VISIBLE    0x04
      #define SWL_INVISIBLE  0x01
      #define SWL_GRAYED     0x02

      /*** jump flag for SWCNTRL structure *********************************/
      #define SWL_JUMPABLE    0x02
      #define SWL_NOTJUMPABLE 0x01

      #ifdef INCL_16
         /* XLATOFF */
         #ifndef INCL_NOXLATE_WIN16
            #define WinAddSwitchEntry Win16AddSwitchEntry
            #define WinRemoveSwitchEntry Win16RemoveSwitchEntry
         #endif /* INCL_NOXLATE_WIN16  */
         /* XLATON */
      #endif /* INCL_16 */

      /*** Switching Program functions *************************************/
      HSWITCH APIENTRY WinAddSwitchEntry(PSWCNTRL);
      #ifdef INCL_32
         ULONG   APIENTRY WinRemoveSwitchEntry(HSWITCH);
      #else
         USHORT  APIENTRY WinRemoveSwitchEntry(HSWITCH);
      #endif

   #endif  /* not INCL_NOCOMMON */

   #ifdef INCL_WINSWITCHLIST

      typedef struct _SWENTRY {        /* swent */
         HSWITCH hswitch;
         SWCNTRL swctl;
      } SWENTRY;
      typedef SWENTRY FAR *PSWENTRY;

      #ifdef INCL_32
         typedef struct _SWBLOCK {        /* swblk */
            ULONG    cswentry;
            SWENTRY aswentry[1];
         } SWBLOCK;
      #else
         typedef struct _SWBLOCK {        /* swblk */
            USHORT   cswentry;
            SWENTRY aswentry[1];
         } SWBLOCK;
      #endif
      typedef SWBLOCK FAR *PSWBLOCK;

      #ifdef INCL_16
         /* XLATOFF */
         #ifndef INCL_NOXLATE_WIN16
            #define WinChangeSwitchEntry Win16ChangeSwitchEntry
            #define WinCreateSwitchEntry Win16CreateSwitchEntry
            #define WinQuerySessionTitle Win16QuerySessionTitle
            #define WinQuerySwitchEntry Win16QuerySwitchEntry
            #define WinQuerySwitchHandle Win16QuerySwitchHandle
            #define WinQuerySwitchList Win16QuerySwitchList
            #define WinQueryTaskSizePos Win16QueryTaskSizePos
            #define WinQueryTaskTitle Win16QueryTaskTitle
            #define WinSwitchToProgram Win16SwitchToProgram
            #define WinInstStartApp Win16InstStartApp
         #endif /* INCL_NOXLATE_WIN16  */
         /* XLATON */
      #endif /* INCL_16 */

      #ifdef INCL_32
         /*** 32-bit versions of these APIs have 32-bit parameters *********/
         ULONG   APIENTRY WinChangeSwitchEntry(HSWITCH hswitchSwitch,
                                               PSWCNTRL pswctlSwitchData);

         HSWITCH  APIENTRY WinCreateSwitchEntry(HAB hab,
                                                PSWCNTRL pswctlSwitchData);

         ULONG   APIENTRY WinQuerySessionTitle(HAB hab,
                                               ULONG usSession,
                                               PSZ pszTitle,
                                               ULONG usTitlelen);

         ULONG   APIENTRY WinQuerySwitchEntry(HSWITCH hswitchSwitch,
                                              PSWCNTRL pswctlSwitchData);

         HSWITCH  APIENTRY WinQuerySwitchHandle(HWND hwnd,
                                                PID pidProcess);
         ULONG   APIENTRY WinQuerySwitchList(HAB hab,
                                             PSWBLOCK pswblkSwitchEntries,
                                             ULONG usDataLength);

         ULONG   APIENTRY WinQueryTaskSizePos(HAB hab,
                                              ULONG usScreenGroup,
                                              PSWP pswpPositionData);

         ULONG   APIENTRY WinQueryTaskTitle(ULONG usSession,
                                            PSZ pszTitle,
                                            ULONG usTitlelen);

         ULONG   APIENTRY WinSwitchToProgram(HSWITCH hswitchSwHandle);
      #else
         USHORT   APIENTRY WinChangeSwitchEntry(HSWITCH hswitchSwitch,
                                                PSWCNTRL pswctlSwitchData);

         HSWITCH  APIENTRY WinCreateSwitchEntry(HAB hab,
                                                PSWCNTRL pswctlSwitchData);

         USHORT   APIENTRY WinQuerySessionTitle(HAB hab,
                                                USHORT usSession,
                                                PSZ pszTitle,
                                                USHORT usTitlelen);

         USHORT   APIENTRY WinQuerySwitchEntry(HSWITCH hswitchSwitch,
                                               PSWCNTRL pswctlSwitchData);

         HSWITCH  APIENTRY WinQuerySwitchHandle(HWND hwnd,
                                                PID pidProcess);

         USHORT   APIENTRY WinQuerySwitchList(HAB hab,
                                              PSWBLOCK pswblkSwitchEntries,
                                              USHORT usDataLength);

         USHORT   APIENTRY WinQueryTaskSizePos(HAB hab,
                                               USHORT usScreenGroup,
                                               PSWP pswpPositionData);

         USHORT   APIENTRY WinQueryTaskTitle(USHORT usSession,
                                             PSZ pszTitle,
                                             USHORT usTitlelen);

         USHORT   APIENTRY WinSwitchToProgram(HSWITCH hswitchSwHandle);
      #endif

      #ifndef INCL_32
         /*** this API calls not used in 32-bit ****************************/
         HAPP APIENTRY WinInstStartApp(HINI hini,
                                       HWND hwndNotifyWindow,
                                       USHORT cCount,
                                       PSZ FAR * aszApplication,
                                       PSZ pszCmdLine,
                                       PVOID pData,
                                       USHORT fsOptions);
      #endif  /* ifndef INCL_32 */

   #endif /* end of INCL_WINSWITCHLIST */

   #ifdef INCL_WINSHELLDATA
      #ifdef INCL_16
         /* XLATOFF */
         #ifndef INCL_NOXLATE_WIN16
            #define WinQueryProfileInt Win16QueryProfileInt
            #define WinQueryProfileString Win16QueryProfileString
            #define WinWriteProfileString Win16WriteProfileString
            #define WinQueryProfileSize Win16QueryProfileSize
            #define WinQueryProfileData Win16QueryProfileData
            #define WinWriteProfileData Win16WriteProfileData
            #define PrfQueryProfileInt Prf16QueryProfileInt
            #define PrfQueryProfileString Prf16QueryProfileString
            #define PrfWriteProfileString Prf16WriteProfileString
            #define PrfQueryProfileSize Prf16QueryProfileSize
            #define PrfQueryProfileData Prf16QueryProfileData
            #define PrfWriteProfileData Prf16WriteProfileData
            #define PrfOpenProfile Prf16OpenProfile
            #define PrfCloseProfile Prf16CloseProfile
            #define PrfReset Prf16Reset
            #define PrfQueryProfile Prf16QueryProfile
         #endif /* INCL_NOXLATE_WIN16  */
         /* XLATON */
      #endif /* INCL_16 */

      /*** OS2.INI Access functions ****************************************/
      #ifndef INCL_32
         /*** these API calls not used in 32-bit ***************************/
         SHORT   APIENTRY WinQueryProfileInt(HAB hab,
                                             PSZ pszAppName,
                                             PSZ pszKeyName,
                                             SHORT sDefault);

         USHORT  APIENTRY WinQueryProfileString(HAB hab,
                                                PSZ pszAppName,
                                                PSZ pszKeyName,
                                                PSZ pszDefault,
                                                PVOID pProfileString,
                                                USHORT usMaxPstring);

         BOOL    APIENTRY WinWriteProfileString(HAB hab,
                                                PSZ pszAppName,
                                                PSZ pszKeyName,
                                                PSZ pszValue);

         USHORT  APIENTRY WinQueryProfileSize(HAB hab,
                                              PSZ pszAppName,
                                              PSZ pszKeyName,
                                              PUSHORT pusValue);

         BOOL    APIENTRY WinQueryProfileData(HAB hab,
                                              PSZ pszAppName,
                                              PSZ pszKeyName,
                                              PVOID pValue,
                                              PUSHORT pusSize);

         BOOL    APIENTRY WinWriteProfileData(HAB hab,
                                              PSZ pszAppName,
                                              PSZ pszKeyName,
                                              PVOID pValue,
                                              USHORT usSize);
      #endif  /* ifndef INCL_32 */

      #ifdef INCL_32
         LONG   APIENTRY PrfQueryProfileInt(HINI hini,
                                            PSZ pszApp,
                                            PSZ pszKey,
                                            LONG  sDefault);
      #else
         SHORT  APIENTRY PrfQueryProfileInt(HINI hini,
                                            PSZ pszApp,
                                            PSZ pszKey,
                                            SHORT sDefault);
      #endif

      ULONG  APIENTRY PrfQueryProfileString(HINI hini,
                                            PSZ pszApp,
                                            PSZ pszKey,
                                            PSZ pszDefault,
                                            PVOID pBuffer,
                                            ULONG cchBufferMax);

      BOOL   APIENTRY PrfWriteProfileString(HINI hini,
                                            PSZ pszApp,
                                            PSZ pszKey,
                                            PSZ pszData);

      BOOL   APIENTRY PrfQueryProfileSize(HINI hini,
                                          PSZ pszApp,
                                          PSZ pszKey,
                                          PULONG pulReqLen);

      BOOL   APIENTRY PrfQueryProfileData(HINI hini,
                                          PSZ pszApp,
                                          PSZ pszKey,
                                          PVOID pBuffer,
                                          PULONG pulBuffLen);

      BOOL   APIENTRY PrfWriteProfileData(HINI hini,
                                          PSZ pszApp,
                                          PSZ pszKey,
                                          PVOID pData,
                                          ULONG cchDataLen);

      HINI   APIENTRY PrfOpenProfile(HAB hab,
                                     PSZ pszFileName);

      BOOL   APIENTRY PrfCloseProfile(HINI hini);

      BOOL   APIENTRY PrfReset(HAB hab,
                               PPRFPROFILE pPrfProfile);

      BOOL   APIENTRY PrfQueryProfile(HAB hab,
                                      PPRFPROFILE pPrfProfile);

      /*** public message, broadcast on WinReset ***************************/
      #define PL_ALTERED 0x008E  /* WM_SHELLFIRST + 0E */

   #endif /* INCL_WINSHELLDATA */

   #ifdef INCL_SHLERRORS
      #include <pmerr.h>
   #endif /* INCL_SHLERRORS */

#endif /* of #ifndef SESMGR */


/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( restore )
      #endif
   #pragma info( restore )
#endif
/* INC */

/**************************** end of file **********************************/
