/****************************** Module Header *******************************\
*
* Module Name: PMSEI.H
*
* OS/2 Presentation Manager SetErrorInfo constants and function declaration
*
* Copyright (c) International Business Machines Corporation 1981, 1988-1992
*
* ===========================================================================
*
* This is included from PMWIN.H when appropriate INCL symbols are defined
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between XLATOFF
* and XLATON comments.
*
#ifndef __IBMC__
   * The public version of this file (as shipped with the OS/2 Toolkit
   * product) excludes all non 32-bit material marked in this file
   * as well as any areas specifically marked with __IBMC__ conditional
   * sections - including this paragraph. The H2IBMH rexx command file
   * removes these sections.
#endif
\***************************************************************************/

/* XLATOFF */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( none )
      #endif
   #pragma info( restore )
#endif
/* XLATON */

#define SEI_INCLUDED

#ifdef INCL_32
   ERRORID APIENTRY WinSetErrorInfo(ERRORID, ULONG, ...);
#else
   /* XLATOFF */
   #define WinSetErrorInfo WINSETERRORINFO
   /* XLATON */

   ERRORID _cdecl FAR WINSETERRORINFO(ERRORID, USHORT, ...);
#endif

#define SEI_BREAKPOINT   0x8000  /* Always enter an INT 3 breakpt       */
#define SEI_NOBEEP       0x4000  /* Do not call DosBeep                 */
#define SEI_NOPROMPT     0x2000  /* Do not prompt the user              */
#define SEI_DBGRSRVD     0x1000  /* Reserved for debug use              */
#define SEI_DEBUGONLY    (SEI_BREAKPOINT | SEI_NOBEEP | SEI_NOPROMPT | SEI_RESERVED)

#define SEI_STACKTRACE   0x0001  /* save the stack trace                */
#define SEI_REGISTERS    0x0002  /* save the registers                  */
#define SEI_ARGCOUNT     0x0004  /* first USHORT in args is arg count   */
#define SEI_DOSERROR     0x0008  /* first USHORT in args is OS2 error code */
#ifndef INCL_32
   #define SEI_MSGSTR    0x0010  /* first PSZ in arg -> msg string      */
#endif
#define SEI_RESERVED     0x0FE0  /* Reserved for future use             */

#ifdef INCL_32
/****************************************************************************
* Note that when SEI_ARGCOUNT, SEI_DOSERROR are specified
* together, then the implied order of the parameters is:
*
*
*  WinSetErrorInfo( MAKEERRORID( .... ),
*                   SEI_ARGCOUNT | SEI_DOSERROR,
*                   argCount,
*                   dosErrorCode);
*
****************************************************************************/
#else
/***************************************************************************
* The DOS_MSGSTR flag is not supported in 32-bit yet, put two separate
* comments in file so that 32-bit only version has correct info.
*
* Note that when SEI_ARGCOUNT, SEI_DOSERROR and DOS_MSGSTR are specified
* together, then the implied order of the parameters is:
*
*
*  WinSetErrorInfo( MAKEERRORID( .... ),
*                   SEI_ARGCOUNT | SEI_DOSERROR | SEI_MSGSTR,
*                   argCount,
*                   dosErrorCode,
*                   "This is the error msg string: %s\n",
*                   "This is an insert for the %s format specifier" );
*
****************************************************************************/
#endif

/* XLATOFF */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( restore )
      #endif
   #pragma info( restore )
#endif
/* XLATON */

/**************************** end of file **********************************/
