/****************************** Module Header ******************************\
*
* Module Name: PMGPIP.H
*
* OS/2 Presentation Manager GPI PRIVATE function declarations
*
* Copyright (c) International Business Machines Corporation 1981, 1988-1992
*
* PRIVATE VERSION - IBM CONFIDENTIAL
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
#ifndef __IBMC__
   * The 32-bit version of this file (as placed into the IBMH directory)
   * excludes all non 32-bit material marked in this file as well
   * as any areas specifically marked with __IBMC__ conditional
   * sections - including this paragraph. The H2IBMH rexx command file
   * removes these sections.
#endif
* ===========================================================================
*
* CHANGE ACTIVITY:
* FLAG REASON   RLSE DATE   ORIGIN  COMMENTS
* ---- -------- ---- ------ ------  --------------------------
* @P1= PTR6603  0300 890130 HDKJSR  Remove direct segment editing functions.
* @P2= PTR6619  0300 890201 HDKJSR  Remove compatible segment functions.
* @D1= DCR25044 0300 890802 HDGPL   Add GpiPolyLineDisjoint.
* ...= PTR 7824 Cruiser     PaulDev INCL16 changes for mixed programs
* @D2= D25109   R200 900301 HDSKS   Porthole requirements.
* @P3  SM07992  R201 911211 DLO     Add GpiInstallIFIFont
*
\***************************************************************************/

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( none )
      #endif
   #pragma info( restore )
#endif
/* INC */

#define PMGPIP_INCLUDED

#ifndef INCL_32         /* If neither INCL_32 or INCL_16 set already */
   #ifndef INCL_16      /* find out from compiler if 32-bit or not.  */
     #ifdef M_I386
        #define INCL_32 /* Compiling for 32-bit */
     #else
        #define INCL_16 /* Compiling for 16-bit */
     #endif
  #endif
#endif

/* data truncated error on GpiMoveData and others */
#define GPI_TRUNCATED    2

/* control parameter for GpiSetDrawControl */
#define DCTL_PICKMODE         6L
#define DCTL_CORRELATE_FORMAT 7L

/* correlation type GpiSetDrawControl */
#define DCTL_CORRELATE_ALL    0L
#define DCTL_CORRELATE_FIRST  1L
#define DCTL_CORRELATE_LAST   2L

/* correlate format type GpiSetDrawControl */
#define DCTL_FORMAT_0         0L
#define DCTL_FORMAT_1         1L

/* segment attributes used by GpiSet/QuerySegmentAttrs and others */
#define ATTR_PROLOG           7L

/* option masks for PS options used by GpiSetPs */
#define PS_KEEPALL                 0x10000L

/* options for GpiSaveMetaFile2 flags field */
#define SMF_OVERWRITE_EXIST   1L  // allow overwrite of existing metafile

                                                              /* 2@P2D */
                                                              /* 2@P1D */
                                                               /* @P2D */
                                                              /* 4@P1D */
                                                              /* 3@P2D */

/* NOINC */
#ifdef INCL_16
#ifndef INCL_NOXLATE_WIN16
    #define GpiVectorSymbol Gpi16VectorSymbol
    #define GpiOpenMetafile Gpi16OpenMetafile
    #define GpiCloseMetafile Gpi16CloseMetafile
    #define GpiConvPsH Gpi16ConvPsH
    #define GpiMTAssociate Gpi16MTAssociate
    #define GpiMTDisassociate Gpi16MTDisassociate
    #define GpiAccessMetaFile Gpi16AccessMetaFile
    #define GpiResumePlay Gpi16ResumePlay
    #define GpiSuspendPlay Gpi16SuspendPlay
    #define GpiSetDCOwner Gpi16SetDCOwner
    #define GpiSetBitmapOwner Gpi16SetBitmapOwner
    #define GpiSetRegionOwner Gpi16SetRegionOwner
    #define GpiInstallIFIFont Gpi16InstallIFIFont
#endif  /* INCL_NOXLATE_WIN16  */
#endif /* INCL_16 */
/* INC */

BOOL APIENTRY GpiSaveMetaFile2( HMF MetafileHandle,
                                PCH FileName,
                                ULONG Flags );

LONG  APIENTRY GpiVectorSymbol( HPS, HDC, PBYTE );

BOOL  APIENTRY GpiOpenMetafile( HDC, PBYTE );

HMF   APIENTRY GpiCloseMetafile( HDC );

HDC   APIENTRY GpiConvPsH( HPS );

BOOL  APIENTRY GpiMTAssociate( HDC );

BOOL  APIENTRY GpiMTDisassociate( HDC );

BOOL  APIENTRY GpiAccessMetaFile( HMF );

BOOL  APIENTRY GpiResumePlay( HPS );

BOOL  APIENTRY GpiSuspendPlay( HPS );

BOOL  APIENTRY GpiSetDCOwner( HDC, ULONG );                   /* @D2A*/

BOOL  APIENTRY GpiSetBitmapOwner( HPS, HBITMAP, ULONG );      /* @D2A*/

BOOL  APIENTRY GpiSetRegionOwner( HPS, HRGN, ULONG );         /* @D2A*/

LONG  APIENTRY GpiInstallIFIFont ( ULONG, PSZ, PSZ, PSZ );

#ifdef INCL_32
   //@bidi
   //
   // For use in GpiSet/QueryAttrs.
   // This is the value that sets/queries the BidiAttr field
   // in the DC structure.
   //
   #define PRIM_BIDIATTR   65

   #ifdef INCL_GPIP_NLSEX

      /* Definition for flNlsProcess.  */
      #define GNLS_PROCESS_BIDI      0x00000001
      #define GNLS_PROCESS_HEBREW    0x00000002
      #define GNLS_PROCESS_ARABIC    0x00000004
      #define GNLS_PROCESS_THAI      0x00000008
      #define GNLS_PROCESS_GREEK     0x00000010    /*@BIDI_PI  added definition for Greek */
      #define GNLS_PROCESS_TURKISH   0x00000020

      /* structure for extended NLS */
      typedef struct _GNLSEX {  /* gnlsex */
           ULONG   flNlsProcess;      //leave at beginning of struc for performance
           ULONG   ulCodepageOverride;
           PULONG  pProcess_BidiAttr;
           PFN     pfnBidiConvertString;
           ULONG   ulCodepageOverrideEBCDIC;          //@Ebcdic
           ULONG   ulReserved;
      }  GNLSEX ;
      typedef GNLSEX *PGNLSEX;
   #endif //incl_GpiNlsEx

   //@bidi end
#endif

PVOID APIENTRY GpiAllocateDCData(HDC, ULONG);

PVOID APIENTRY GpiQueryDCData(HDC);

#ifdef INCL_GPIDISPPRF
   /* structures for Disp Profile Functions */
   typedef struct _DSPINFO {  /* dspnfo */
      PSZ   pszDriverName;
      ULONG cchDriverName;
      PSZ   pszDesc;
      ULONG cchDesc;
      PSZ   pszFileName;
      ULONG cchFileName;
      PSZ   pszOptionalParameters;
      ULONG cchOptionalParameters;
   } DSPINFO;
   typedef DSPINFO FAR *PDSPINFO;

   typedef struct _SCREENRESCOUNT {  /* scrcnt */
      ULONG maxcount;
      ULONG count;
      ULONG res_struct_length;
   } SCREENRESCOUNT;
   typedef SCREENRESCOUNT FAR *PSCREENRESCOUNT;

   typedef struct _SCREENRESOLUTION { /* scrres */
      ULONG width;
      ULONG height;
      ULONG colors;
      ULONG planes;
      ULONG floptions;
   } SCREENRESOLUTION;
   typedef SCREENRESOLUTION FAR *PSCREENRESOLUTION;

   #define DSP_DELETE_DRIVER                  1
   #define DSP_OPT_PARMS_PRESENT              2
   #define DSP_QUERY_OPT_PARMS                2
   #define DSP_SET_DEFAULT_DRIVER             4
   #define DSP_QUERY_DEFAULT_DRIVER           4
   #define DSP_SET_INSTALL_ON_IPL             8
   #define DSP_QUERY_INSTALL_ON_IPL           8
   #define DSP_SET_CURRENT_DRIVER            16
   #define DSP_QUERY_CURRENT_DRIVER          16
   #define DSP_SET_DEFAULT_RESOLUTION        32
   #define DSP_RESOLUTION_OBTAINABLE         64
   #define DSP_RESOLUTION_DEFAULT           128
   #define DSP_FILENAME_PRESENT             256
   #define DSP_QUERY_FILENAME               256
   #define DSP_DESC_PRESENT                 512
   #define DSP_QUERY_DESC                   512

   #ifndef INCL_DDIDEFS

      #ifdef INCL_16
         /* NOINC */
         #ifndef INCL_NOXLATE_WIN16
            #define DspSetDriverInfo             Dsp16SetDriverInfo
            #define DspQueryDriverInfo           Dsp16QueryDriverInfo
            #define DspQueryDriverNames          Dsp16QueryDriverNames
            #define DspDefaultResolution         Dsp16DefaultResolution
            #define DevQueryDisplayResolutions   Dev16QueryDisplayResolutions
            #define DspInitSystemDriverName      Dsp16InitSystemDriverName
         #endif
         /* INC */
      #endif /* INCL_16 */

      /*** Display Driver functions */
      BOOL  APIENTRY DspSetDriverInfo(PDSPINFO pDSPInfo,
                                      ULONG flOptions);

      ULONG APIENTRY DspQueryDriverInfo(PDSPINFO pDSPInfo,
                                        ULONG flOptions);

      ULONG APIENTRY DspQueryDriverNames(PVOID pBuffer,
                                         ULONG ulCount);

      BOOL  APIENTRY DspDefaultResolution(PVOID pScreenResolution,
                                          PULONG pcbScreenResolution,
                                          ULONG flOptions);

      ULONG APIENTRY DevQueryDisplayResolutions(PSZ pszDriverName,
                                                PVOID pBuf,
                                                PULONG pcbBuf);

      BOOL  APIENTRY DspInitSystemDriverName(PSZ pszDriverFileName,
                                             ULONG ccbDriverFileName );
   #endif /* no INCL_DDIDEFS */
#endif /* non-common GPIDISPPRF */

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( restore )
      #endif
   #pragma info( restore )
#endif
/* INC */

/**************************** end of file **********************************/
