/*static char *SCCSID = "@(#)perfhook.h 6.3 92/05/08";*/
/*      SCCSID = @(#)perfhook.h 6.3 92/05/08                         */
/***************************************************************************/
/*                                                                         */
/*                 Copyright (c) IBM Corporation  1987, 1990               */
/*                 Copyright (c) Microsoft Corp.  1987, 1990               */
/*                           All Rights Reserved                           */
/*                                                                         */
/***************************************************************************/
/*                                      */
/*    Performance hook include file     */
/*                                      */

#define PERFTRACE 1                             /* Set for major code '01' */
#define PERFBIT x040                            /* Bit for major code 1    */

/***
 *  Dekko card memory mapped I/O address data area
 */
struct Dekko_Addr
{
    unsigned long   reserved;           /* +0 - not used                   */
    unsigned short  majmin_code;        /* +4 - Major (hi) minor (lo) code */
    unsigned short  start_stop_sync;    /* +6 - not used                   */
    unsigned long   perf_data_4byte;    /* +8 - 4 byte performance data    */
    unsigned short  perf_data;          /* +C - 2 byte performance data    */
};

#if defined(MMIOPH)

#if defined(PINBALL_MMIOPH)
#define mmptr   far
#else
#define mmptr
#endif


/***
 *  Local variables used by the performance hook internal macros
 */
static volatile struct Dekko_Addr mmptr  *dekko_addr;           /* d204575 */
static unsigned char mmptr      *dekko_ptr;
static          short            dekko_idx;
static unsigned long             dekko_quad;


/***************************************************************************/
/*                                                                         */
/*  TEST_TRACING........... Determines if tracing is active for the given  */
/*                          major code and if the "master" tracing switch  */
/*                          is currently active.                           */
/*                                                                         */
/***************************************************************************/

#define TEST_TRACING(PERF_RMT,Maj)   \
        (*PERF_RMT & 0x40) && (*(PERF_RMT+(Maj>>3)) & (0x80>>(Maj&7)))

/***************************************************************************/     /* varga 2/20/97 - 175192 */
/*                                                                         */     /* varga 2/20/97 - 175192 */
/*  TEST_HOOK...........    Determines if tracing is active for the given  */     /* varga 2/20/97 - 175192 */
/*                          major code.                                    */     /* varga 2/20/97 - 175192 */
/*                                                                         */     /* varga 2/20/97 - 175192 */
/***************************************************************************/     /* varga 2/20/97 - 175192 */
#define TEST_HOOK(PERF_RMT,Maj)   \
        (*(PERF_RMT+(Maj>>3)) & (0x80>>(Maj&7)))


/***************************************************************************/
/*                                                                         */
/*  SET_DEKKO_ADDRESS...... Loads the dekko card address into the variable */
/*                          "dekko_addr". Address value is obtained from   */
/*                          the info segment data.                         */
/*                                                                         */
/***************************************************************************/

#define SET_DEKKO_ADDRESS(infoseg_ptr) \
    dekko_addr = (struct Dekko_Addr *) infoseg_ptr.SIS_MMIOAddr;

#define SET_DEKKO_ADDRESS2(infoseg_ptr) \
    dekko_addr = (struct Dekko_Addr *) infoseg_ptr->SIS_MMIOAddr;


/***************************************************************************/
/*                                                                         */
/*  FORCE_WRITE............ Macro used to break the optimization of the    */
/*                          C complier. This macro will force it to        */
/*                          generate code for consecutive statements which */
/*                          write to the same memory location. This may    */
/*                          stop working without notice. It should be      */
/*                          checked each time the "C" compiler is changed. */
/*                                                                         */
/*                          d204575 note:                                  */
/*                          -------------                                  */
/*                          As stated above, this appears to have been     */
/*                          done in order to force the Microsoft C         */
/*                          compiler to break optimization and do all the  */
/*                          writes to the dekko memory mapped I/O area.    */
/*                          However, this doesn't work for VisualAge C++.  */
/*                          The way I fixed the problem was to declare     */
/*                          the Dekko memory mapped I/O area as volatile   */
/*                          (in the declare of the dekko_addr pointer).    */
/*                          CL (Microsoft C) generates the correct code    */
/*                          without FORCE_WRITE.                           */
/*                          As such, we don't need this macro anymore.     */
/***************************************************************************/

/*#define FORCE_WRITE if(dekko_addr!=0);*/                      /* d204575 */
#define FORCE_WRITE                                             /* d204575 */


/***************************************************************************/
/*                                                                         */
/*  WRITE_MAJ_MNR_CODES.... Writes the given major and minor codes into    */
/*                          the "majmin_code" element of the dekko addr.   */
/*                                                                         */
/***************************************************************************/

#define WRITE_MAJMNR_CODES(MajMnr) dekko_addr->majmin_code = MajMnr;


/***************************************************************************/
/*                                                                         */
/*  WRITE_BYTE_VALUE....... Writes the given byte value at the +C offset   */
/*                          data area of the dekko card. The byte is       */
/*                          written into the high byte of the data area    */
/*                          and the low byte is padded with a zero.        */
/*                                                                         */
/***************************************************************************/

#define WRITE_BYTE_VALUE(val) \
    dekko_addr->perf_data=(unsigned short)val; \
    FORCE_WRITE


/***************************************************************************/
/*                                                                         */
/*  WRITE_WORD_VALUE....... Writes the given word value at the +C offset   */
/*                          data area of the dekko card.                   */
/*                                                                         */
/***************************************************************************/

#define WRITE_WORD_VALUE(val) \
    dekko_addr->perf_data=(unsigned short)val; \
    FORCE_WRITE


/***************************************************************************/
/*                                                                         */
/*  WRITE_DWORD_VALUE...... Writes the double word value at the +8 offset  */
/*                          data area of the dekko card.                   */
/*                                                                         */
/*Modified by RYH Aug 8, 1995 for the 32 bit write from 16 bit segs prob.  */
/***************************************************************************/
#define WRITE_DWORD_VALUE(val) \
    dekko_addr->perf_data_4byte=(unsigned long)val; \
    FORCE_WRITE

/***************************************************************************/
/*                                                                         */
/*  WRITE_BYTE_STREAM...... Write the stream of bytes indicated by         */
/*                          dekko_ptr and dekko_idx to the +8 offset of    */
/*                          the dekko card as a series of double words.    */
/*                                                                         */
/*  07/09/90 - Fixed extra quad written when last byte of string was on    */
/*             the quad boundry.                                           */
/*                                                                         */
/***************************************************************************/

#define WRITE_BYTE_STREAM                    \
        while (dekko_idx > 0) {              \
            dekko_quad = *(long mmptr *)dekko_ptr; \
            WRITE_DWORD_VALUE (dekko_quad)   \
            dekko_ptr += 4; dekko_idx -= 4; }


/***************************************************************************/
/*                                                                         */
/*  WRITE_ASCIIZ_STRING.... Writes the asciiz string to the dekko card as  */
/*                          a series of double words to the +8 offset. The */
/*                          final "dword" is padded with as many blanks as */
/*                          needed. The null terminator is always written. */
/*                                                                         */
/*  06/21/90 - Modified to check for null string. Write zeros if NULL.     */
/*                                                                         */
/***************************************************************************/

#define WRITE_ASCIIZ_STRING(str)              \
        if (str != NULL) {                    \
            dekko_ptr = (unsigned char mmptr *)str; \
            dekko_idx = 1;                    \
            while (*dekko_ptr++) dekko_idx++; \
            dekko_ptr = (unsigned char mmptr *)str; \
            WRITE_BYTE_STREAM  }              \
        else                                  \
            WRITE_DWORD_VALUE(0)


/***************************************************************************/
/*                                                                         */
/*  WRITE_NUMB_STRING...... Writes the length byte of the string to the +C */
/*                          offset of the dekko card. The data part of the */
/*                          string is then written to the +8 offset as a   */
/*                          series of double words.                        */
/*                                                                         */
/*  06/21/90 - Fixed pointer incrememt problem. Also allowed for fact that */
/*             length byte value includes the length byte.                 */
/*                                                                         */
/***************************************************************************/

#define WRITE_NUMB_STRING(str)                \
        if (str != NULL) {                    \
            dekko_ptr = (unsigned char mmptr *)str; \
            dekko_idx = *dekko_ptr - 1;       \
            dekko_ptr++;                      \
            WRITE_WORD_VALUE (dekko_idx)      \
            WRITE_BYTE_STREAM }               \
        else                                  \
            WRITE_DWORD_VALUE(0)


#if defined(PINBALL_MMIOPH)
/***************************************************************************/
/*                                                                         */
/*  WRITE_CRACKED_PATH..... Writes a cracked path to the dekko card. See   */
/*                          file \drv6\src\pinball\hdrs\misc.h for cracked */
/*                          path structure.                                */
/*                                                                         */
/***************************************************************************/

#define WRITE_CRACKED_PATH(pckpth)              \
        {   unsigned char far *p = &(pckpth->sp.c); \
            unsigned char far *ep= p-2;             \
            ep += pckpth->cbPath; ep += *ep;    \
            WRITE_WORD_VALUE (pckpth->hVPB)     \
            WRITE_WORD_VALUE (pckpth->cbPath)   \
            while (p!=ep){WRITE_NUMB_STRING(p) p+=*p;}\
        }
#endif


/* 151129  begin */

/***************************************************************************/
/*                                                                         */
/*  TEST_TRACING_S......... Determines if tracing is active for the given  */
/*                          major code.					   */
/*                                                                         */
/***************************************************************************/

#define TEST_TRACING_S(PERF_RMT,Maj)   \
        (*(PERF_RMT+(Maj>>3)) & (0x80>>(Maj&7)))

/***************************************************************************/
/*                                                                         */
/*  TEST_TRACING_Dekko......... Determines if tracing is active for Dekko  */
/***************************************************************************/

#define TEST_TRACING_Dekko(PERF_RMT)   \
        (*PERF_RMT & 0x40)

/* 151129  end */

#endif
