/*****************************************************************************
 *
 * SOURCE FILE NAME = PCI.H
 *
 * DESCRIPTIVE NAME =
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1994, 1997
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  Contains PCI BIOS definitions.
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @Vr.mpppxx   xxxxx xxxxxxx
 *   05/21/94  Jon Grimm  D083385 Created PCI.INC
 *   09/02/94  Bob Carney D094979
 *   09/17/97  @V4.0MNH21 D184552 Add Generic SVGA PCI Register Trapping
 *****************************************************************************/

#define OEM_PCI_BIOS_INFO  0

typedef struct PciBiosInfo_P { /* */
  BYTE pbi_bPCIFunc;
} PciBiosInfo_P;

#define PCI_PBI_PARM_SIZE sizeof( PciBiosInfo_P )

typedef struct _PciBiosInfo_D { /* */
  BYTE  pbi_bReturn;
  BYTE  pbi_bHWMech;
  BYTE  pbi_bMajorRev;
  BYTE  pbi_bMinorRev;
  BYTE  pbi_bLastBus;
} PciBiosInfo_D;

#define PCI_PBI_DATA_SIZE sizeof( PciBiosInfo_D )

#define OEM_PCI_FIND_DEVICE 1

typedef struct _PciFindDevice_P { /* */
  BYTE   pfd_bPCIFunc;
  USHORT pfd_usDeviceID;
  USHORT pfd_usVendorID;
  BYTE   pfd_bIndex;
} PciFindDevice_P;

#define PCI_PFD_PARM_SIZE sizeof( PciFindDevice_P )

typedef struct _PciFindDevice_D { /* */
  BYTE   pfd_bReturn;
  BYTE   pfd_bBusNum;
  BYTE   pfd_bDevFunc;
} PciFindDevice_D;

#define PCI_PFD_DATA_SIZE sizeof( PciFindDevice_D )

#define OEM_PCI_FIND_CLASS_CODE 2

typedef struct PciFindClassCode_P { /* */
  BYTE   pfcc_bPCIFunc;
  ULONG  pfcc_ulClassCode;
  BYTE   pfcc_bIndex;
} PciFindClassCode_P;

#define PCI_PFCC_PARM_SIZE sizeof( PciFindClassCode_P )

typedef struct PciFindClassCode_D { /* */
  BYTE   pfcc_bReturn;
  BYTE   pfcc_bBusNum;
  BYTE   pfcc_bDevFunc;
} PciFindClassCode_D;

#define PCI_PFCC_DATA_SIZE sizeof( PciFindClassCode_D )

#define OEM_PCI_READ_CONFIG  3

typedef struct PciReadConfig_P { /* */
  BYTE   prc_bPCIFunc;
  BYTE   prc_bBusNum;
  BYTE   prc_bDevFunc;
  BYTE   prc_bConfigReg;
  BYTE   prc_bSize;
} PciReadConfig_P;

#define PCI_PRC_PARM_SIZE sizeof( PciReadConfig_P )

typedef struct PciReadConfig_D { /* */
  BYTE   prc_bReturn;
  ULONG  prc_ulData;
} PciReadConfig_D;

#define PCI_PRC_DATA_SIZE sizeof( PciReadConfig_D )

#define OEM_PCI_WRITE_CONFIG  4

typedef struct PciWriteConfig_P { /* */
  BYTE   pwc_bPCIFunc;
  BYTE   pwc_bBusNum;
  BYTE   pwc_bDevFunc;
  BYTE   pwc_bConfigReg;
  BYTE   pwc_bSize;
  ULONG  pwc_ulData;
} PciWriteConfig_P;

#define PCI_PWC_PARM_SIZE sizeof( PciWriteConfig_P )

typedef struct PciWriteConfig_D { /* */
  BYTE   pwc_bReturn;
} PciWriteConfig_D;

#define PCI_PWC_DATA_SIZE sizeof( PciWriteConfig_D )


#define PCI_STACK_SIZE     1024
#define PCI_ROM_ADDR       0x000F0000
#define PCI_ENTRY_OFFSET   0xFE6E

#define PCI_BIOS_PRESENT        0xB101
#define PCI_FIND_DEVICE         0xB102
#define PCI_FIND_CLASS_CODE     0xB103
#define PCI_GENERATE_S_CYCLE    0xB106
#define PCI_READ_CONFIG_BYTE    0xB108
#define PCI_READ_CONFIG_WORD    0xB109
#define PCI_READ_CONFIG_DWORD   0xB10A
#define PCI_WRITE_CONFIG_BYTE   0xB10B
#define PCI_WRITE_CONFIG_WORD   0xB10C
#define PCI_WRITE_CONFIG_DWORD  0xB10D

/* only for 2.1 BIOS - unused now */
#define PCI_GET_IRQ_ROUTING     0xB10E
#define PCI_SET_IRQ             0xB10F

#define PCI_BAD_VID             0xFFFF
#define PCI_BAD_DID             0xFFFF
#define PCI_NO_INTERRUPT_PIN    0x0000
#define PCI_FUNC_MASK           0x0080
#define PCI_MULTI_FUNC          0x0007
#define PCI_SINGLE_FUNC         0x0000

#define PCI_BASE_ADDR_IO_SPACE  0x00000001                      /*@V4.0MNH21*/
#define PCI_BASE_ADDR_TYPE      0x00000006                      /*@V4.0MNH21*/
#define PCI_BASE_ADDR_32_BIT        0x00000000                  /*@V4.0MNH21*/
#define PCI_BASE_ADDR_BELOW_1M      0x00000002                  /*@V4.0MNH21*/
#define PCI_BASE_ADDR_64_BIT        0x00000004                  /*@V4.0MNH21*/
#define PCI_BASE_ADDR_PREFETCH  0x00000008                      /*@V4.0MNH21*/
#define PCI_BASE_ADDR_IO_ONLY   0xfffffffc                      /*@V4.0MNH21*/
#define PCI_BASE_ADDR_MEM_ONLY  0xfffffff0                      /*@V4.0MNH21*/

#define PCI_CFG_BASE_ADDR_COUNT 6                               /*@V4.0MNH21*/

typedef struct _SPCICONFIGHEADER { /* */
  USHORT pci_usVendorID;                                        /*@V4.0MNH21*/
  USHORT pci_usDeviceID;                                        /*@V4.0MNH21*/
  USHORT pci_usCmdReg;                                          /*@V4.0MNH21*/
  USHORT pci_usStatusReg;                                       /*@V4.0MNH21*/
  BYTE   pci_bRevisionID;                                       /*@V4.0MNH21*/
  BYTE   pci_bProgIF;                                           /*@V4.0MNH21*/
  BYTE   pci_bSubClassCode;                                     /*@V4.0MNH21*/
  BYTE   pci_bClassCode;                                        /*@V4.0MNH21*/
  BYTE   pci_bCacheLineSize;                                    /*@V4.0MNH21*/
  BYTE   pci_bLatencyTimer;                                     /*@V4.0MNH21*/
  BYTE   pci_bHeaderType;                                       /*@V4.0MNH21*/
  BYTE   pci_bBIST;                                             /*@V4.0MNH21*/
  ULONG  pci_aulBaseAddr [PCI_CFG_BASE_ADDR_COUNT];             /*@V4.0MNH21*/
  ULONG  pci_ulCardBusCISPtr;                                   /*@V4.0MNH21*/
  USHORT pci_usSubsystemVendorID;                               /*@V4.0MNH21*/
  USHORT pci_usSubsystemDeviceID;                               /*@V4.0MNH21*/
  ULONG  pci_ulExpansionROMBaseAddr;                            /*@V4.0MNH21*/
  ULONG  pci_ulReserved1;                                       /*@V4.0MNH21*/
  ULONG  pci_ulReserved2;                                       /*@V4.0MNH21*/
  BYTE   pci_bInterruptLine;                                    /*@V4.0MNH21*/
  BYTE   pci_bInterruptPin;                                     /*@V4.0MNH21*/
  BYTE   pci_bMin_Gnt;                                          /*@V4.0MNH21*/
  BYTE   pci_bMax_Lat;                                          /*@V4.0MNH21*/
} SPCICONFIGHEADER;                                             /*@V4.0MNH21*/

typedef SPCICONFIGHEADER *PSPCICONFIGHEADER;                    /*@V4.0MNH21*/

/* PCI Configuration Space */
#define PCI_CFG_VID             (offset pci_usVendorID)         /*@V4.0MNH21*/
#define PCI_CFG_DID             (offset pci_usDeviceID)         /*@V4.0MNH21*/
#define PCI_CFG_CMD_REG         (offset pci_usCmdReg)           /*@V4.0MNH21*/
#define PCI_CFG_STAT_REG        (offset pci_usStatusReg)        /*@V4.0MNH21*/
#define PCI_CFG_REV_ID          (offset pci_bRevisionID)        /*@V4.0MNH21*/
#define PCI_CFG_CLASS_CODE      (offset pci_bProgIF)            /*@V4.0MNH21*/
#define PCI_CFG_CACHE_LINE_SIZE (offset pci_bCacheLineSize)     /*@V4.0MNH21*/
#define PCI_CFG_LAT_TIMER       (offset pci_bLatencyTimer)      /*@V4.0MNH21*/
#define PCI_CFG_HEADER          (offset pci_bHeaderType)        /*@V4.0MNH21*/
#define PCI_CFG_BIST            (offset pci_bBIST)              /*@V4.0MNH21*/
#define PCI_CFG_INT_LEVEL       (offset pci_bInterruptLine)     /*@V4.0MNH21*/
#define PCI_CFG_INT_PIN         (offset pci_bInterruptPin)      /*@V4.0MNH21*/
#define PCI_CFG_MIN_GNT         (offset pci_bMin_Gnt)           /*@V4.0MNH21*/
#define PCI_CFG_MAX_LAT         (offset pci_bMax_Lat)           /*@V4.0MNH21*/

#define PCI_CFG_SPACE_SIZE      0x0100                          /*@V4.0MNH21*/
#define PCI_CFG_USER_DEF_SIZE   (PCI_CFG_SPACE_SIZE - sizeof( SPCICONFIGHEADER )) /*@V4.0MNH21*/

typedef struct _SPCICONFIGURATION { /* */
  SPCICONFIGHEADER pci_sPCIConfigHeader;                        /*@V4.0MNH21*/
  BYTE   pci_abPCIUserDefined [PCI_CFG_USER_DEF_SIZE];          /*@V4.0MNH21*/
} SPCICONFIGURATION;                                            /*@V4.0MNH21*/

typedef SPCICONFIGURATION *PSPCICONFIGURATION;                  /*@V4.0MNH21*/

#define PCI_MAX_NUM_DEV         0x20

#define PCI_FNNUMBER            0x0B

#define BIOS32_NAME             0x5f32335f
#define PCI_NAME                0x49435024

