/****************************** Module Header ******************************\
*
* Module Name: OS2NLSFD.H
*
*
* Copyright (C)  1988  IBM Corporation
* Copyright (C)  1988  Microsoft Corporation
*
\***************************************************************************/

/** font information for GET_INFO  **/

typedef struct _FONT_INFO {  /* font_info */
        PFOCAFONT font_info_ptr;
        ULONG     option;
        } FONT_INFO;
typedef FONT_INFO  FAR *PFONT_INFO;


/** font map for READ and WRITE **/

typedef struct _FONT_MAP {  /* font_map */
        USHORT    buffer_length;
        PUSHORT   buffer_ptr;
        USHORT    reserved1;
        PVOID     reserved2;
        ULONG     input_width;
        ULONG     input_height;
        ULONG     output_width;
        ULONG     output_height;
        } FONT_MAP;
typedef FONT_MAP  FAR *PFONT_MAP;


/** font driver version for GET_VERSION **/

typedef struct _FONT_DRIVER_VERSION { /* font_driver_version */
        ULONG     version_number;
        PFD_DESC  fd_desc;
        } FONT_DRIVER_VERSION;
typedef FONT_DRIVER_VERSION  FAR *PFONT_DRIVER_VERSION;



/**  Font Driver FinctionID  **/

#define DBE_FD_READ                0x00000002L
#define DBE_FD_WRITE               0x00000003L
#define DBE_FD_GET_INFO            0x00000004L
#define DBE_FD_GET_VERSION         0x00000006L


/** Font INFORMATION OPTION **/

#define DBE_FD_FONT_DEFAULT         0x00000000
#define DBE_FD_FONT_NO_CACHE        0x00000004


/**  Font Driver Return Code  **/

#define DBE_FD_NORMAL              0x00000000L
#define DBE_FD_NO_MORE_FONT        0x00000001L
#define DBE_FD_ERROR               0xFFFFFFFFL


/**  Font Driver Version  Number   **/

#define DBE_FD_VERSION_1           1100         /*  PM-J 1.1 */



#define DEVESC_DBE_FONTMANAGEMENT  24450


/** Extended Font Driver Interface   PMDBCS 1.2 **/

#define DBE_FD_VERSION_2           1200

#define DBE_FD_QUERY               0x00000005L
#define DBE_FD_OPEN                0x00000007L
#define DBE_FD_CLOSE               0x00000008L

#define DBE_FD_LESS_BUFFER         0x00000002L
#define DBE_FD_INVALID_FORMAT      0x00000003L

typedef struct _FONT_QUERY { /* Query data structure */
        ULONG     QueryID;
        ULONG     xCellWidth;
        ULONG     yCellHeight;
        ULONG     xCellA;
        ULONG     xCellB;
        ULONG     xCellC;
        ULONG     data_length;
        } FONT_QUERY;
typedef FONT_QUERY  FAR *PFONT_QUERY;

#define DBE_FD_QUERY_WIDTHHEIGHT   0x00000001L
#define DBE_FD_QUERY_ABC           0x00000002L
#define DBE_FD_QUERY_LENGTH        0x00000004L

