/*static char *SCCSID = "@(#)kbd.h      6.1 90/11/15";*/
/***    Keyboard Device Driver (KBD)
 *
 *      SCCSID = @(#)kbd.h       13.11 90/08/02
 *
 *      KBD public constants.
 *      Copyright (c) 1988,1989 Microsoft Corporation
 *
 *      MODIFICATION HISTORY
 *          01/30/89  MTS    Created.
 *          03/07/93  Kazumi Base code change to BORG (6L.514)          //@IBMJ
 */


// Ports (for both PC/AT and PS/2)

#define PORT_BUFFER             0x60
#define PORT_CMD                0x64
#define PORT_STATUS             0x64

// Output states for PORT_BUFFER (ie, which virtual byte it's pointing to)

#define PORTBUFF_KBD            0       //normal condition
#define PORTBUFF_COMMAND        1       //set by CMD_WRITECOMMAND
#define PORTBUFF_OUTPUT         2       //set by CMD_WRITEOUTPUT
#define PORTBUFF_KYBD_OUTPUT    3       //set by CMD_WRITE_KYBD_OUTPUT
#define PORTBUFF_KYBD_WRIMHI    4       //set by CMD_PS2_WRITEMEMHI     //@IBMJ

// Values that can be written to PORT_CMD

#define CMD_READCOMMAND         0x20    //supported
#define CMD_PS2_READMEMLO       0x21    //NOT SUPPORTED
#define CMD_PS2_READMEMHI       0x3f    //NOT SUPPORTED
#define CMD_WRITECOMMAND        0x60    //supported
#define CMD_PS2_WRITEMEMLO      0x61    //NOT SUPPORTED
#define CMD_PS2_WRITEMEMHI      0x7f    //NOT SUPPORTED
#define CMD_PS2_TESTPW          0xa4    //NOT SUPPORTED
#define CMD_PS2_LOADPW          0xa5    //NOT SUPPORTED
#define CMD_PS2_ENABLEPW        0xa6    //NOT SUPPORTED
#define CMD_AUXILIARYLO         0xa7    //NOT SUPPORTED
#define CMD_AUXILIARYHI         0xa9    //NOT SUPPORTED
#define CMD_SELFTEST            0xaa    //supported(always return SCAN_TESTDONE)
#define CMD_INTERFACETEST       0xab    //supported (always return ZERO)
#define CMD_DIAGNOSTICDUMP      0xac    //NOT SUPPORTED
#define CMD_DISABLEKBD          0xad    //supported
#define CMD_ENABLEKBD           0xae    //supported
#define CMD_READINPUT           0xc0    //supported
#define CMD_PS2_READINLO        0xc1    //NOT SUPPORTED
#define CMD_PS2_READINHI        0xc2    //NOT SUPPORTED
#define CMD_READOUTPUT          0xd0    //supported
#define CMD_WRITEOUTPUT         0xd1    //supported
#define CMD_WRITE_KYBD_OUTPUT   0xd2    //supported
#define CMD_PS2_WRITEOUTLO      0xd3    //NOT SUPPORTED
#define CMD_PS2_WRITEOUTHI      0xd4    //NOT SUPPORTED
#define CMD_READTESTINPUT       0xe0    //supported
#define CMD_PULSEOUTPUTLO       0xf0    //supported
#define CMD_PULSEOUTPUTHI       0xff    //supported


// Values that can be read from PORT_CMD (the Status byte)

#define STATUS_BUFFERFULL       0x01    //set when virtBuff is valid
#define STATUS_CMDFULL          0x02    //always clear
#define STATUS_SYSFLAG          0x04    //transferred from Command byte
#define STATUS_DATAEXPECTED     0x08    //set after write to PORT_CMD
#define STATUS_NOTINHIBITED     0x10    //keyboard is not inhibited (locked)
#define STATUS_XMITTIMEOUT      0x20    //always clear
#define STATUS_RECVTIMEOUT      0x40    //always clear
#define STATUS_PARITYERROR      0x80    //always clear

// Values that can be written to PORT_BUFFER (when it's the Kbd byte)

#define KBD_SETLEDS             0xed    //supported (responds SCAN_ACK)
#define KBD_ECHO                0xee    //supported (responds SCAN_ECHO)
#define KBD_NEW_SETSCAN         0xf0    //NOT SUPPORTED
#define KBD_REPORTID            0xf2    //supported (responds 1 or 2 ID bytes)
#define KBD_SETREPEAT           0xf3    //supported (responds SCAN_ACK)
#define KBD_ENABLE              0xf4    //supported (responds SCAN_ACK)
#define KBD_DEFDISABLE          0xf5    //supported (responds SCAN_ACK)
#define KBD_SETDEFAULT          0xf6    //supported (responds SCAN_ACK)
#define KBD_NEW_REPT            0xf7    //ignored   (responds SCAN_ACK)
#define KBD_NEW_MAKEBRK         0xf8    //ignored   (responds SCAN_ACK)
#define KBD_NEW_MAKEONLY        0xf9    //ignored   (responds SCAN_ACK)
#define KBD_NEW_REPTMAKEBRK     0xfa    //ignored   (responds SCAN_ACK)
#define KBD_NEW_KEYREPT         0xfb    //ignored   (responds SCAN_ACK)
#define KBD_NEW_KEYMAKEBRK      0xfc    //ignored   (responds SCAN_ACK)
#define KBD_NEW_KEYMAKEONLY     0xfd    //ignored   (responds SCAN_ACK)
#define KBD_RESEND              0xfe    //supported (responds w/last scan sent)
#define KBD_RESET               0xff    //supported (responds SCAN_ACK ...)
#define KBD_LOWEST              0xed    //lowest keyboard command code
#define KBD_HIGHEST             0xff    //highest keyboard command code

// Bit masks for the parameter of KBD_SETREPEAT

#define REPEAT_RATEMASK         0x1f    //typematic rate
#define REPEAT_DELAYMASK        0x60    //typematic delay

// Values returned by KBD_REPORTID

#define KBDID_ENHANCED1         0xab    //Common 1st ID byte for Enhanced.
#define KBDID_ENHANCED2         0x41    //Various 2nd ID bytes returned for
#define KBDID_ENHANCED2A        0x54    //  Enhanced keyboards.
#define KBDID_ENHANCED2B        0x85

// Values that can be written to PORT_BUFFER (when it's the Command byte)

#define COMMAND_INTENABLE       0x01    //controls interrupt simulation
#define COMMAND_SYSFLAG         0x04    //transferred to Status byte
#define COMMAND_NOINHIBIT       0x08    //ignored (but retained in Command byte)
#define COMMAND_DISABLEKBD      0x10    //disables further data
#define COMMAND_PCMODE          0x20    //NOT SUPPORTED
#define COMMAND_XLTMODE         0x40    //NOT SUPPORTED

// Values that can be read from PORT_BUFFER (when it's the Input byte)

#define INPUT_RESERVED          0x0f    //reserved bits
#define INPUT_256K              0x10    //generally always set (>=512k)
#define INPUT_NOJUMPER          0x20    //always set
#define INPUT_MONO              0x40    //always clear
#define INPUT_NOTINHIBITED      0x80    //set based on physical hardware

// Values that can be read/written via PORT_BUFFER (when it's the Output byte)

#define OUTPUT_CPURESET         0x01    //NOT SUPPORTED
#define OUTPUT_A20              0x02    //state depends on VDMM A20 flag
#define OUTPUT_RESERVED         0x0c    //reserved bits
#define OUTPUT_BUFFERFULL       0x10    //forces STATUS_BUFFERFULL to go high
#define OUTPUT_CMDEMPTY         0x20    //forces STATUS_CMDFULL to inverse
#define OUTPUT_KBDDATA          0x40    //keyboard data (output)
#define OUTPUT_KBDCLOCK         0x80    //keyboard clock (output)

// Bit masks of test inputs

#define TESTINPUT_T0            0x01
#define TESTINPUT_T1            0x02

// LED state codes

#define LED_SCROLLLOCK          0x01    //set Scroll lock indicator on
#define LED_NUMLOCK             0x02    //set Num lock indicator on
#define LED_CAPSLOCK            0x04    //set Cap lock indicator on
#define LED_ALL                 (LED_SCROLLLOCK + LED_NUMLOCK + LED_CAPSLOCK)

// Common scan codes

#define SCAN_TESTDONE           0x55    //???reply scan code after kbd test
#define SCAN_BATCOMPLETE        0xaa    //reply scan code after BAT
#define SCAN_HIGHESTKEY         0xe1    //highest that isn't treated specially
#define SCAN_E0PREFIX           0xe0    //send as a prefix to some extended keys
#define SCAN_E1PREFIX           0xe1    //send as a prefix to some extended keys
#define SCAN_ECHO               0xee    //reply scan code of an ECHO command
#define SCAN_ACK                0xfa    //send to acknowledge kbd commands
#define SCAN_BATFAIL            0xfc    //send if BAT failed (not use in VDD)
#define SCAN_RESEND             0xfe    //send resend req. if input was invalid
#define SCAN_OVERRUN            0xff    //send when exceed buffer capacity
#define SCAN_BREAKMASK          0x80    //key break mask of scan code

// Interface Test result codes

#define IFTEST_NOERROR          0x00    //no error detected
#define IFTEST_CLOCKLOW         0x01    //keyboard clock line is stuck low
#define IFTEST_CLOCKHIGH        0x02    //keyboard clock line is stuck high
#define IFTEST_DATALOW          0x03    //keyboard data line is stuck low
#define IFTEST_DATAHIGH         0x04    //keyboard data line is stuck high

// Miscellaneous constants

#define KBD_IRQ                 1       //keyboard IRQ number
#define KBDBEEP_FREQ            1000    //keyboard beep frequency in Hz
#define KBDBEEP_DURATION        13      //keyboard beep duration in ms
#define KBDID_UNKNOWN           0x0000
#define KBDID_PCAT              0x0100
#define KBDID_ENHANCED          0x41ab

//@IBMJ Start
// Asian Keyboard/Mouse unique constants

#define KBDID_ENHANCED_P        0x54ab  // Ferrari-P
#define KBDID_ENHANCED_P2       0x84ab  // Ferrari-P

#define KBDID_J001              0x92AB  // Ferrari-A
#define KBDID_J002              0x90AB  // Ferrari-G
#define KBDID_J003              0x91AB  // Ferrari-P
#define KBDID_JWILSON           0x9BAB  // Ricoh WILSON

#define KBD_TYPE_EN             0x0001  // Phuket
#define KBD_TYPE_JA             0x0005  // Ferrari-A
#define KBD_TYPE_JG             0x0006  // Ferrari-G/P

//  Values that can be written to PORT_BUFFER (when it's the Mouse byte)
#define MOU_READSTATUS          0xe9    //responds 3-byte status report
#define MOU_READDEVTYPE         0xf2    //responds always 0(ZERO)
#define MOU_ENABLE              0xf4    //responds SCAN_ACK
#define MOU_SETDEFAULT          0xf6    //responds SCAN_ACK

// Valuse for OEMKbdType
#define KBD_AX                0x4158   // 'AX'   AX-KBD
#define KBD_J3                0x4A33   // 'J3'   J3100-KBD
//@IBMJ End
