#=========================================================================
#Note: The following is the makefile template for header.mak
#      It is the template that was used to build the pmshapi component.
#      This file should not be altered in any way.
#      The entire tree for pmshapi is available  under
#      \\bcrssbs1\startool\devutil\makefile_template\example for reference.
#=========================================================================
#----------------------------------------------------------------------------
# HEADER.MAK
#
# SCCSID: 1.67 of header.mak, wp.pc, c.pc
#
# FUNCTIONS:
#
# CALLED FROM: Component makefile
#
# ORIGINS:
#
# (C) COPYRIGHT International Business Machines Corp. 1994
# All Rights Reserved
# Licensed Materials - Property of IBM
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
#----------------------------------------------------------------------------
# Change History:
# ---------------
# Defect No.     Date       By             Description
# -----------------------------------------------------------------------------
# 102637        10/16/94    D. Hoffman     Update for def 95355 and ppci415 to
#                                          integration merge.
# ??????        10/25/94    D. Hoffman     Update for PUBLIC5 and R_OS2_IDL macros
# 109328         2/27/95    M. Weber       add -Hoff=off_fp_reference for proper
#                                           debugging with IPMD & post 12/20 hcppc
# 121731         5/9/95     T.Greenberg    Added -Brogot to pns_lflags, added nlv
#                                          macros, changed toolsflag usage
# 124031        5/31/95     TG             Added preipfc.mak, dvcn macro
# 124369        6/2/95      TG             Changes for publicly built c run-times
# 128187        7/3/95      VS             Added REL_TOP_OBJ and RELMRI_TOP_OBJ
#               7/7/95      SK             redefined TARGET_MK
# 133000        8/14/95     TG             Added O_NLV to base_paths
# 132999        8/16/95     TG             Further mri changes
# 136763        9/13/95     MW             Added -Hoff=slash_file_names to
#                                           SYSTEM_CFLAGS for missing line#
#                                           debug data (w/ 8/23 compiler)
# 148121        2/7/95      TG             Added additional macros for leg stuff
# 170302        10/30/96    DMH            Fixed some minor quirks
# 400(Yamato)   8/12/96     EA             Fix version.mak include for clean build.
# 186332        9/24/97     tbw            add macros for ver2ver.100
# 190841        12/03/97    RandyH         Give each dep* erase its own 'if exist'
# 195944         4/22/98    RandyH         Common macro for MAKEDEP replacement
# 196531        04/29/98    DMH            Fix misc problems
#------------------------------------------------------------------------------
# This is to be used for WPOS Common Macros/Definitions etc
#
# The following is a list of the order in which header.mak is designed.
#
#     Define Primiary options
#                    - Host OS, Host Proc, Target PROC, Target Exe,
#                      BLD_TYPE
#                    - Please note that Host OS, Host Proc will be defined
#                      by the build lab
#                    - Determine the compiler. The sub-component makefile
#                      can over-ride the COMPILER Macro.
#
#
#     Set up paths for TOOLS and COMPILERS
#                      Include <COMPILER>.mak depending on the compiler.
#
#     Define Macros for SRC/OBJ/REL Trees to be used in the setting of
#                      various paths.
#                      Set up Paths for OUTPUT, RELEASE Trees.
#
#     Set up the country specific Definition/Macros
#                      Default is US
#
#     Set up the environment
#                      Compiler Location with Includes, Libs and Tools etc.
#                      LIB Environment Variable
#                      Compiler and Tools Macros
#     Additional Macros
#                      Put any additional macros here
#
#     Set up dot directives
#        Dot Directives - ie.
#          .SUFFIXES:
#          .SILENT:
#          .IGNORE:
#          .PRECIOUS:
#
#    Inference Rules Setup
#        .c.obj
#        .asm.obj
#        .exe.com
#
#    Common target information "common.mak" for dependency generation
#        Creation of dependencies using includes.
#
#    Make sure the base paths are created.
#
#      User Target Information
#         all
#         debug
#         retail
#         perf
#         private
#
# ******  NOTE  ******
#
#==================================================================
# First figure out what our host processor
# and operating system is so that we use the
# right tools. Host_Proc and Host_Os will be set by build lab
#==================================================================

!if "$(HOST_PROC)" == "" || "$(HOST_OS)" == ""
!error Environment variables "HOST_PROC" and/or "HOST_OS not set!  Please set\
"HOST_PROC" to the type of processor on which $(MAKE) was invoked \
(one of 386, PPC, RISC) and "HOST_OS" to the operating system in which \
$(MAKE) was invoked (one of OS2, WPOS2, AIX, OSF)!
!endif

#----------------------------------------------------------------------
# options.mak is a file that contains options for BLD_TYPE, EXE_FMT,
# and TARGET_PROC.  These variables will not be set up the first time
# through the makefile because of the recursion that we are using.  The
# next time through the makefile, these macros will be appropriately set.
#------------------------------------------------------------------------

!ifndef MAKEFILE_NAME
MAKEFILE_NAME = makefile
!endif

!include $(ROOT)\src\$(SUBSYS)\common\options.mak

#------------------------------------------------------------------------
# add versioning calls
#------------------------------------------------------------------------
#j-ea400D !if "$(SUBSYS)" != "CPC"
#j-ea400A 1 line
!if ("$(SUBSYS)" != "public") & ("$(SUBSYS)" != "PUBLIC") & ("$(SUBSYS)" != "cpc") & ("$(SUBSYS)" != "CPC")
!include $(ROOT)\rel\os2c\include\base\os2\16bit\version.mak
!endif


#--------------------------------------------------------------------------
# Do error checking on the macros set in options.mak.  Only give an error
# if OPT was also set.
#--------------------------------------------------------------------------

!ifndef TARGET_PROC
!ifdef OPT
!error TARGET_PROC not set
!endif
!endif


!ifndef BLD_TYPE
!ifdef OPT
!error BLD_TYPE not set
!endif
!endif


!ifndef EXE_FMT
!ifdef OPT
!error EXEFMT not set
!endif
!endif


#-------------------------------------------------------------------------
# The following are macros that are to be used as the install paths for
# wpos.  For example, in your component makefile you build a file that
# needs to installed into the os2\dll directory, you should have a target
# like:  $(DLL)\comp.dll:
#
# If you have a "makepath $(@D)" as your first command for the target,
# you can be sure that the path exists before you write to it.
#--------------------------------------------------------------------------

!ifndef NLV
NLV = en
!endif

INST_ROOT         = $(REL)
MACH              = $(INST_ROOT)\mk
OS2               = $(INST_ROOT)\os2
APPS              = $(INST_ROOT)\os2\apps
BITMAP            = $(INST_ROOT)\os2\bitmap
BOOK              = $(INST_ROOT)\os2\book
DLL               = $(INST_ROOT)\os2\dll
DRIVERS           = $(INST_ROOT)\os2\drivers
HELP              = $(INST_ROOT)\os2\help
INSTALL           = $(INST_ROOT)\os2\install
MDOS              = $(INST_ROOT)\os2\mdos
SYSTEM            = $(INST_ROOT)\os2\system
TEST              = $(INST_ROOT)\test\$(SUBSYS)
APPS_DLL          = $(INST_ROOT)\os2\apps\dll
DLL_DISPLAY       = $(INST_ROOT)\os2\dll\display
HELP_GLOSS        = $(INST_ROOT)\os2\help\gloss
HELP_TUTORIAL     = $(INST_ROOT)\os2\help\tutorial
INSTALL_APPN      = $(INST_ROOT)\os2\install\appn
INSTALL_LOCK      = $(INST_ROOT)\os2\install\lock
INSTALL_ABIOS     = $(INST_ROOT)\os2\install\ramabios
MDOS_WIN          = $(INST_ROOT)\os2\mdos\winos2
MDOS_WIN_SYS      = $(INST_ROOT)\os2\mdos\winos2\system
SYSTEM_TRACE      = $(INST_ROOT)\os2\system\trace
SYSTEM_RAS        = $(INST_ROOT)\os2\system\ras
BONUSPAK          = $(INST_ROOT)\bonuspak
DBGSRV            = $(INST_ROOT)\debug
DVCN              = $(INST_ROOT)\devcon
V2VTOOLS          = $(INST_ROOT)\tools


INST_ROOT_NLV         = $(REL_NLV)
MACH_NLV              = $(INST_ROOT_NLV)\mk
OS2_NLV               = $(INST_ROOT_NLV)\os2
APPS_NLV              = $(INST_ROOT_NLV)\os2\apps
BITMAP_NLV            = $(INST_ROOT_NLV)\os2\bitmap
BOOK_NLV              = $(INST_ROOT_NLV)\os2\book
DLL_NLV               = $(INST_ROOT_NLV)\os2\dll
DRIVERS_NLV           = $(INST_ROOT_NLV)\os2\drivers
HELP_NLV              = $(INST_ROOT_NLV)\os2\help
INSTALL_NLV           = $(INST_ROOT_NLV)\os2\install
MDOS_NLV              = $(INST_ROOT_NLV)\os2\mdos
SYSTEM_NLV            = $(INST_ROOT_NLV)\os2\system
TEST_NLV              = $(INST_ROOT_NLV)\test\$(SUBSYS)
APPS_DLL_NLV          = $(INST_ROOT_NLV)\os2\apps\dll
DLL_DISPLAY_NLV       = $(INST_ROOT_NLV)\os2\dll\display
HELP_GLOSS_NLV        = $(INST_ROOT_NLV)\os2\help\gloss
HELP_TUTORIAL_NLV     = $(INST_ROOT_NLV)\os2\help\tutorial
INSTALL_APPN_NLV      = $(INST_ROOT_NLV)\os2\install\appn
INSTALL_LOCK_NLV      = $(INST_ROOT_NLV)\os2\install\lock
INSTALL_ABIOS_NLV     = $(INST_ROOT_NLV)\os2\install\ramabios
MDOS_WIN_NLV          = $(INST_ROOT_NLV)\os2\mdos\winos2
MDOS_WIN_SYS_NLV      = $(INST_ROOT_NLV)\os2\mdos\winos2\system
SYSTEM_TRACE_NLV      = $(INST_ROOT_NLV)\os2\system\trace
SYSTEM_RAS_NLV        = $(INST_ROOT_NLV)\os2\system\ras
BONUSPAK_NLV          = $(INST_ROOT_NLV)\bonuspak
DVCN_NLV              = $(INST_ROOT_NLV)\devcon
V2VTOOLS_NLV          = $(INST_ROOT_NLV)\tools


I18N                  = $(INST_ROOT)\language
I18N_MESSAGE          = $(INST_ROOT)\language\message
I18N_CODEPAGE         = $(INST_ROOT)\language\codepage
I18N_KEYBOARD         = $(INST_ROOT)\language\keyboard
I18N_FONT             = $(INST_ROOT)\language\font
I18N_LOCALE           = $(INST_ROOT)\language\locale
I18N_HELP             = $(INST_ROOT)\language\help
I18N_BOOK             = $(INST_ROOT)\language\book

#----------------------------------------------------------------------------
#This is for the newmtools
#----------------------------------------------------------------------------

NEWMTOOLS=1

#----------------------------------------------------------------------------
# Set OBJ, REL and TOOLS root to allow for flexible input/output
#----------------------------------------------------------------------------

!ifndef OROOT
OROOT = $(ROOT)
!endif

#----------------------------------------------------------------------
# Set TROOT in your component makefile to be the location of the tools
# tree, if and only if the tools tree resides in a different place than
# the source code.
#---------------------------------------------------------------------

!ifndef TROOT
TROOT = $(ROOT)
!endif

#----------------------------------------------------------------------
# Set RROOT in your component makefile to be the location of the release
# tree, if and only if you want to read AND write to a release tree in a
# different place than the source code.
#-----------------------------------------------------------------------

!ifndef RROOT
RROOT = $(ROOT)
!endif

#-------------------------------------------------------------------------
# Set RROOT_R in your component makefile to be the location of the release
# tree, if and only if you want to read the release tree from a different
# place, and write to the release tree locally.
#-------------------------------------------------------------------------

!ifndef RROOT_R
RROOT_R = $(RROOT)
!endif

#------------------------------------------------------------------------
# Set RROOT_W in your component makefile to be the location of where you
# you want to write to the release tree, if and only if this place is
# different than the source code.
#----------------------------------------------------------------------

!ifndef RROOT_W
RROOT_W = $(RROOT)
!endif

#----------------------------------------------------------
# Set up compiler and tools paths accordingly
#----------------------------------------------------------

!ifdef EXE_FMT
!ifdef TARGET_PROC
TOOLS1 = $(TROOT)\tools\$(HOST_OS).$(HOST_PROC)\bin
TOOLS2 = $(TROOT)\tools\$(HOST_OS).$(HOST_PROC)\$(EXE_FMT).$(TARGET_PROC)\bin

#-----------------------------------------------------------------------------
# The next statement will include a .mak file which contains the definitions
# specific to the tools being used.  The tools being used are determined
# by Host OS.Host Proc and Exe Fmt.Target Proc
#-----------------------------------------------------------------------------

!include $(TOOLS2)\tools.mak
!include $(TOOLS1)\preipfc.mak
!endif
!endif


TOOLSPATH = $(TOOLS1);$(TOOLS2);$(TOOLSC)      # "TOOLSC" is set in tools.mak
IPFC      = $(TOOLS1)


#==========================================================================
# This sets up the paths for the header, includes, libraries, tools, and
# makepaths.
#
# Note:  SRC_PUB_LIB_OS2 is the directory that would be used for libraries
#        that are used to build.  If these libraries will be public or released,
#        then they need to copied to the release tree and used from there.
#==========================================================================

SRC_PUB         = $(ROOT)\src\public
SRC_PUB_LIB_OS2 = $(SRC_PUB)\lib\os2
SBASE           = $(ROOT)\src\$(SUBSYS)
SSCOMMON        = $(SBASE)\common
SUBSYS_HDR      = $(SBASE)\common\include
MAKFILES        = $(SBASE)\common;$(SRC_PUB)\makfiles
MAKEPATH1       = $(SRC_PUB)\makfiles

CBASE       = $(ROOT)\$(SRC_RELATIVE)
NLCBASE     = $(ROOT)\$(SRC_NL_RELATIVE)

#============================================================================
# Set up obj "PUBLIC" and subsystem paths and rel paths
#============================================================================
!if "$(TARGET_PROD)" == ""
TARGET_PROD = $(TARGET_MK)
!endif

OBASE       = $(OROOT)\obj\$(TARGET_PROD)\$(BLD_TYPE)\$(SUBSYS)

#---------------------------------------------------------------------------
# SUBSYS_LIB is a macro used to define the location where non-releaseable
# libraries that are built should be placed.
#----------------------------------------------------------------------------

SUBSYS_LIB      = $(SBASE)\common\lib
SUBSYS_LIB_GEN  = $(OBASE)\common\lib             #generated intermediate libraries
SUBSYS_HDR_GEN  = $(OBASE)\common\include         #generated intermediate include files

O           = $(OBASE)\$(SUBSYS_RELATIVE)
O_NLV       = $(O)\$(NLV)

RBASE_R         = $(RROOT_R)\rel\$(TARGET_PROD)
RBASE_W         = $(RROOT_W)\rel\$(TARGET_PROD)
REL_TOP_OBJ     = $(RBASE_W)\$(BLD_TYPE)\base\topobj
RELMRI_TOP_OBJ  = $(RBASE_W)\$(BLD_TYPE)\$(NLV)\topobj
!ifdef INSTPATH
REL                 = $(RBASE_W)\$(BLD_TYPE)\base\$(INSTPATH)
REL_NLV             = $(RBASE_W)\$(BLD_TYPE)\$(NLV)\$(INSTPATH)
!else
REL                 = $(RBASE_W)\$(BLD_TYPE)\base
REL_NLV             = $(RBASE_W)\$(BLD_TYPE)\$(NLV)
!endif

R_IBMMK_HDR     = $(RBASE_R)\include\ibmmk
PNS_RUNTIME_HDR = $(R_IBMMK_HDR)\pns_runtime
R_IBMMK_LIB     = $(RBASE_R)\lib\ibmmk
R_DYNAMIC_LIB   = $(RBASE_R)\lib\so
CD_SO_DIR       = echo *******  Linking $@ *******

R_CPS_HDR   = $(RBASE_R)\include\base\cps
R_CPS_HDR_NLV   = $(RBASE_R)\include\$(NLV)\cps
R_CPSP_HDR  = $(RBASE_R)\include\base\cps\priv
R_CPSP_HDR_NLV  = $(RBASE_R)\include\$(NLV)\priv
R_CPS_LIB   = $(RBASE_R)\lib\cps
R_CPSP_LIB  = $(RBASE_R)\lib\cps\priv

R_OS2_HDR   = $(RBASE_R)\include\base\os2
R_OS2_NET   = $(RBASE_R)\include\base\os2\net32
R_OS2_HDR_NLV   = $(RBASE_R)\include\$(NLV)\os2
R_OS2_LIB   = $(RBASE_R)\lib\os2
R_OS2P_HDR  = $(RBASE_R)\include\base\os2\priv
R_OS2P_HDR_NLV  = $(RBASE_R)\include\$(NLV)\os2\priv
R_OS2P_LIB  = $(RBASE_R)\lib\os2\priv


R_NETSCAPE_HDR   = $(RBASE_R)\include\base\netscape\v$(NS_VER)

R_OS2_IDL   = $(R_OS2_HDR)\idl

!ifndef CRT_VER
CRT_VER     = v3
!endif

R_CRT_HDR = $(RBASE_R)\include\os2\$(CRT_VER)crt
R_CRT_LIB = $(RBASE_R)\lib\os2\$(CRT_VER)crt

RW_CRT_HDR = $(RBASE_W)\include\os2\$(CRT_VER)crt
RW_CRT_LIB = $(RBASE_W)\lib\os2\$(CRT_VER)crt

R_OS2L_H = $(RBASE_R)\include\base\os2\16bit
R_OS2L_IBMH = $(RBASE_R)\include\os2l\ibmh
R_OS2L_INC = $(RBASE_R)\include\os2l\inc
R_OS2L_INC32 = $(RBASE_R)\include\os2l\inc32
R_OS2L_LIB = $(RBASE_R)\lib\os2l\lib

ICONPATH = $(RBASE_R)\include\base\icons
ICONPATH_NLV = $(RBASE_R)\include\$(NLV)\icons

NETSCAPE_PATH = $(RBASE_R)\include\base\netscape\v202

MRES_INC_PATHS  = -I $(ICONPATH) -I $(ROOT)\$(SRC_NL_RELATIVE)

# ===========================================================================
# PUBLIC1, PUBLIC2, ... are used to specify the ordering dependency
# to locate tools in the release tree. Please define PUBLIC1, PUBLIC2, .....
# in the sub-system makefile.
# ===========================================================================

!ifdef PUBLIC1
R_PUB_HDR1   = $(RBASE_R)\include\base\$(PUBLIC1)
R_PUB_LIB1   = $(RBASE_R)\lib\$(PUBLIC1)
R_PUB_LIB1_DBG   = $(RBASE_R)\lib\$(PUBLIC1)\$(BLD_TYPE)
R_PUBP_HDR1   = $(RBASE_R)\include\base\$(PUBLIC1)\priv
R_PUBP_LIB1   = $(RBASE_R)\lib\$(PUBLIC1)\priv
R_PUBP_LIB1_DBG   = $(RBASE_R)\lib\$(PUBLIC1)\priv\$(BLD_TYPE)
!   ifdef PUBLIC2
R_PUB_HDR2   = $(R_PUB_HDR1);$(RBASE_R)\include\base\$(PUBLIC2)
R_PUB_LIB2   = $(R_PUB_LIB1);$(RBASE_R)\lib\$(PUBLIC2)
R_PUB_LIB2_DBG   = $(R_PUB_LIB1_DBG);$(RBASE_R)\lib\$(PUBLIC2)\$(BLD_TYPE)
R_PUBP_HDR2   = $(R_PUBP_HDR1);$(RBASE_R)\include\base\$(PUBLIC2)\priv
R_PUBP_LIB2   = $(R_PUBP_LIB1);$(RBASE_R)\lib\$(PUBLIC2)\priv
R_PUBP_LIB2_DBG   = $(R_PUBP_LIB1_DBG);$(RBASE_R)\lib\$(PUBLIC2)\priv\$(BLD_TYPE)
!       ifdef PUBLIC3
R_PUB_HDR3   = $(R_PUB_HDR2);$(RBASE_R)\include\base\$(PUBLIC3)
R_PUB_LIB3   = $(R_PUB_LIB2);$(RBASE_R)\lib\$(PUBLIC3)
R_PUB_LIB3_DBG   = $(R_PUB_LIB2_DBG);$(RBASE_R)\lib\$(PUBLIC3)\$(BLD_TYPE)
R_PUBP_HDR3  = $(R_PUBP_HDR2);$(RBASE_R)\include\base\$(PUBLIC3)\priv
R_PUBP_LIB3  = $(R_PUBP_LIB2);$(RBASE_R)\lib\$(PUBLIC3)\priv
R_PUBP_LIB3_DBG  = $(R_PUBP_LIB2_DBG);$(RBASE_R)\lib\$(PUBLIC3)\priv\$(BLD_TYPE)
!           ifdef PUBLIC4
R_PUB_HDR4   = $(R_PUB_HDR3);$(RBASE_R)\include\base\$(PUBLIC4)
R_PUB_LIB4   = $(R_PUB_LIB3);$(RBASE_R)\lib\$(PUBLIC4)
R_PUB_LIB4_DBG   = $(R_PUB_LIB3_DBG);$(RBASE_R)\lib\$(PUBLIC4)\$(BLD_TYPE)
R_PUBP_HDR4  = $(R_PUBP_HDR3);$(RBASE_R)\include\base\$(PUBLIC4)\priv
R_PUBP_LIB4  = $(R_PUBP_LIB3);$(RBASE_R)\lib\$(PUBLIC4)\priv
R_PUBP_LIB4_DBG  = $(R_PUBP_LIB3_DBG);$(RBASE_R)\lib\$(PUBLIC4)\priv\$(BLD_TYPE)
!               ifdef PUBLIC5
R_PUB_HDR5   = $(R_PUB_HDR4);$(RBASE_R)\include\base\$(PUBLIC5)
R_PUB_LIB5   = $(R_PUB_LIB4);$(RBASE_R)\lib\$(PUBLIC5)
R_PUB_LIB5_DBG   = $(R_PUB_LIB4_DBG);$(RBASE_R)\lib\$(PUBLIC5)\$(BLD_TYPE)
R_PUBP_HDR5  = $(R_PUBP_HDR4);$(RBASE_R)\include\base\$(PUBLIC5)\priv
R_PUBP_LIB5  = $(R_PUBP_LIB4);$(RBASE_R)\lib\$(PUBLIC5)\priv
R_PUBP_LIB5_DBG  = $(R_PUBP_LIB4_DBG);$(RBASE_R)\lib\$(PUBLIC5)\priv\$(BLD_TYPE)
!                  ifdef PUBLIC6
R_PUB_HDR6   = $(R_PUB_HDR5);$(RBASE_R)\include\base\$(PUBLIC6)
R_PUB_LIB6   = $(R_PUB_LIB5);$(RBASE_R)\lib\$(PUBLIC6)
R_PUB_LIB6_DBG   = $(R_PUB_LIB5_DBG);$(RBASE_R)\lib\$(PUBLIC6)\$(BLD_TYPE)
R_PUBP_HDR6  = $(R_PUBP_HDR5);$(RBASE_R)\include\base\$(PUBLIC6)\priv
R_PUBP_LIB6  = $(R_PUBP_LIB5);$(RBASE_R)\lib\$(PUBLIC6)\priv
R_PUBP_LIB6_DBG  = $(R_PUBP_LIB5_DBG);$(RBASE_R)\lib\$(PUBLIC6)\priv\$(BLD_TYPE)
!                     ifdef PUBLIC7
R_PUB_HDR7   = $(R_PUB_HDR6);$(RBASE_R)\include\base\$(PUBLIC7)
R_PUB_LIB7   = $(R_PUB_LIB6);$(RBASE_R)\lib\$(PUBLIC7)
R_PUB_LIB7_DBG   = $(R_PUB_LIB6_DBG);$(RBASE_R)\lib\$(PUBLIC7)\$(BLD_TYPE)
R_PUBP_HDR7  = $(R_PUBP_HDR6);$(RBASE_R)\include\base\$(PUBLIC7)\priv
R_PUBP_LIB7  = $(R_PUBP_LIB6);$(RBASE_R)\lib\$(PUBLIC7)\priv
R_PUBP_LIB7_DBG  = $(R_PUBP_LIB6_DBG);$(RBASE_R)\lib\$(PUBLIC7)\priv\$(BLD_TYPE)
!                        ifdef PUBLIC8
R_PUB_HDR8   = $(R_PUB_HDR7);$(RBASE_R)\include\base\$(PUBLIC8)
R_PUB_LIB8   = $(R_PUB_LIB7);$(RBASE_R)\lib\$(PUBLIC8)
R_PUB_LIB8_DBG   = $(R_PUB_LIB7_DBG);$(RBASE_R)\lib\$(PUBLIC8)\$(BLD_TYPE)
R_PUBP_HDR8  = $(R_PUBP_HDR7);$(RBASE_R)\include\base\$(PUBLIC8)\priv
R_PUBP_LIB8  = $(R_PUBP_LIB7);$(RBASE_R)\lib\$(PUBLIC8)\priv
R_PUBP_LIB8_DBG  = $(R_PUBP_LIB7_DBG);$(RBASE_R)\lib\$(PUBLIC8)\priv\$(BLD_TYPE)
!                        endif
!                     endif
!                  endif
!               endif
!           endif
!       endif
!   endif
!endif

!undef R_PUB_HDR
!undef R_PUBP_HDR
!undef R_PUB_LIB
!undef R_PUBP_LIB

!ifndef R_PUB_HDR8
!  ifndef R_PUB_HDR7
!    ifndef R_PUB_HDR6
!      ifndef R_PUB_HDR5
!        ifndef R_PUB_HDR4
!          ifndef R_PUB_HDR3
!            ifndef R_PUB_HDR2
!              ifdef R_PUB_HDR1
R_PUB_HDR = $(R_PUB_HDR1)
R_PUB_LIB = $(R_PUB_LIB1)
R_PUB_LIB_DBG = $(R_PUB_LIB1_DBG)
R_PUBP_HDR = $(R_PUBP_HDR1)
R_PUBP_LIB = $(R_PUBP_LIB1)
R_PUBP_LIB_DBG = $(R_PUBP_LIB1_DBG)
!              endif
!            else
R_PUB_HDR = $(R_PUB_HDR2)
R_PUB_LIB = $(R_PUB_LIB2)
R_PUB_LIB_DBG = $(R_PUB_LIB2_DBG)
R_PUBP_HDR = $(R_PUBP_HDR2)
R_PUBP_LIB = $(R_PUBP_LIB2)
R_PUBP_LIB_DBG = $(R_PUBP_LIB2_DBG)
!            endif
!          else
R_PUB_HDR = $(R_PUB_HDR3)
R_PUB_LIB = $(R_PUB_LIB3)
R_PUB_LIB_DBG = $(R_PUB_LIB3_DBG)
R_PUBP_HDR = $(R_PUBP_HDR3)
R_PUBP_LIB = $(R_PUBP_LIB3)
R_PUBP_LIB_DBG = $(R_PUBP_LIB3_DBG)
!          endif
!        else
R_PUB_HDR = $(R_PUB_HDR4)
R_PUB_LIB = $(R_PUB_LIB4)
R_PUB_LIB_DBG = $(R_PUB_LIB4_DBG)
R_PUBP_HDR = $(R_PUBP_HDR4)
R_PUBP_LIB = $(R_PUBP_LIB4)
R_PUBP_LIB_DBG = $(R_PUBP_LIB4_DBG)
!        endif
!      else
R_PUB_HDR = $(R_PUB_HDR5)
R_PUB_LIB = $(R_PUB_LIB5)
R_PUB_LIB_DBG = $(R_PUB_LIB5_DBG)
R_PUBP_HDR = $(R_PUBP_HDR5)
R_PUBP_LIB = $(R_PUBP_LIB5)
R_PUBP_LIB_DBG = $(R_PUBP_LIB5_DBG)
!      endif
!    else
R_PUB_HDR = $(R_PUB_HDR6)
R_PUB_LIB = $(R_PUB_LIB6)
R_PUB_LIB_DBG = $(R_PUB_LIB6_DBG)
R_PUBP_HDR = $(R_PUBP_HDR6)
R_PUBP_LIB = $(R_PUBP_LIB6)
R_PUBP_LIB_DBG = $(R_PUBP_LIB6_DBG)
!    endif
!  else
R_PUB_HDR = $(R_PUB_HDR7)
R_PUB_LIB = $(R_PUB_LIB7)
R_PUB_LIB_DBG = $(R_PUB_LIB7_DBG)
R_PUBP_HDR = $(R_PUBP_HDR7)
R_PUBP_LIB = $(R_PUBP_LIB7)
R_PUBP_LIB_DBG = $(R_PUBP_LIB7_DBG)
!  endif
!else
R_PUB_HDR = $(R_PUB_HDR8)
R_PUB_LIB = $(R_PUB_LIB8)
R_PUB_LIB_DBG = $(R_PUB_LIB8_DBG)
R_PUBP_HDR = $(R_PUBP_HDR8)
R_PUBP_LIB = $(R_PUBP_LIB8)
R_PUBP_LIB_DBG = $(R_PUBP_LIB8_DBG)
!endif

#----------------------------------------------------------------------------
# LIB/INCLUDE Environment Variable
# Set the LIB and INCLUDE environment variables such that the proper tools
# are located. COMP_LIB_PREFIX/COMP_LIB_SUFFIX, COMP_HDR_PREFIX/COMP_HDR_SUFFIX
# are defined by the component makefile for flexibility.
#----------------------------------------------------------------------------

!undef LIBTMP1
!undef LIB1
!undef LIBTMP2


!if "$(CMP_LIB_PREFIX)" != ""
LIBTMP1   = ;$(CMP_LIB_PREFIX)
LIB1      = $(CMP_LIB_PREFIX);
!endif

!if "$(R_PUB_LIB)" != ""
LIBXXXX2  = ;$(R_PUB_LIB_DBG);$(R_PUB_LIB);$(R_PUBP_LIB_DBG);$(R_PUBP_LIB)
!endif

!if "$(CMP_LIB_SUFFIX)" != ""
LIBTMP2  = $(LIBXXXX2);$(CMP_LIB_SUFFIX)
!else
LIBTMP2  = $(LIBXXXX2)
!endif



LIBTMP = $(LIBTMP1);$(SUBSYS_LIB);$(SOM_COMP_LIB)$(LIBTMP2);$(COMPILER_LIB_PATH)
LIB = $(LIB1)$(SUBSYS_LIB);$(SOM_COMP_LIB)$(LIBTMP2);$(COMPILER_LIB_PATH)
HCLIB = $(LIBTMP:;=^
-L)


!undef INCTMP1
!undef INCLUDE1
!undef INCTMP2

!if "$(CMP_HDR_PREFIX)" != ""
INCTMP1  = ;$(CMP_HDR_PREFIX)
INCLUDE1 = $(CMP_HDR_PREFIX);
!endif

!if "$(R_PUB_HDR)" != ""
INCXXXX2 = ;$(R_PUB_HDR);$(R_PUBP_HDR)
!endif

!if "$(CMP_HDR_SUFFIX)" != ""
INCTMP2  = $(INCXXXX2);$(CMP_HDR_SUFFIX)
!else
INCTMP2  = $(INCXXXX2)
!endif


!if "$(MW_CRT_HDR)" != ""
INCTMP  = $(INCTMP1);$(SUBSYS_HDR)$(INCTMP2)
INCLUDE = $(INCLUDE1)$(SUBSYS_HDR)$(INCTMP2);$(MW_CRT_HDR)
!else
INCTMP  = $(INCTMP1);$(COMPILER_HDR);$(SUBSYS_HDR);$(SOM_COMP_HDR)$(INCTMP2)
INCLUDE = $(INCLUDE1)$(COMPILER_HDR);$(SUBSYS_HDR);$(SOM_COMP_HDR)$(INCTMP2);.
!endif

INCTMP  = $(INCTMP:;;;=;)         # Remove any possible ";;;" in macros
INCTMP  = $(INCTMP:;;=;)          # Remove any possible ";;" in macros
HCINC   = $(INCTMP:;= -I)

CINC    = $(SOM_COMP_HDR)

SOM_INCL_LIST = $(SOM_COMP_HDR);$(R_OS2P_HDR);$(R_OS2_HDR)


#-----------------------------------------------------------------------------
# Now we actually set our environment
#-----------------------------------------------------------------------------
!if "$(SAVEPATH)" != "1"
!  if [set ORIGINAL_PATH=$(PATH)] || [set ORIGINAL_DPATH=$(DPATH)]
!  endif
!endif

!ifdef TARGET_PROC
!  ifdef EXE_FMT
!    if [set PATH=$(TOOLSPATH);$(ORIGINAL_PATH)] || [set DPATH=$(TOOLSDPATH);$(ORIGINAL_DPATH)] || \
        [set SAVEPATH=1]
!    endif
!  endif
!endif

!if [set INCLUDE=$(INCLUDE)] || [set HCINC=$(HCINC)] || [set LIB=$(LIB)] ||\
    [set IPFC=$(IPFC)] || [set SMINCLUDE=$(SOM_INCL_LIST)] ||\
    [set SMTMP=$(TMP)]
!endif

#----------------------------------------------------------------------------
# Dot Directive Definitions
#----------------------------------------------------------------------------

# .SUFFIXES sets up the appropriate suffixes that make will recognize
.SUFFIXES:
.SUFFIXES: .c .asm .h .inc .bin .rc .res .obj .def .dll .cpp .hpp .ih .ph

#----------------------------------------------------------------------------
# Inference Rules Setup
#
# The $(O) macro specifies destination of object/intermediate files created.
#----------------------------------------------------------------------------

!if "$(TARGET_PROC)"=="ppc"

DLL_LFLAGS         = -G -zdefs -Brogotplt -dy -Bsymbolic -Bnocopyrel $(CMP_DLL_LFLAGS)
PNS_LFLAGS_SO      = -G -zdefs -Brogotplt -dy -Bnocopyrel -Bsymbolic -Bdynamic $(CMP_EXE_LFLAGS)
#PNS_LFLAGS         = -e __start -Brogot $(CMP_PNS_LFLAGS)
EXE_LFLAGS         = -zdefs -Brogotplt -dy -Bsymbolic $(CMP_EXE_LFLAGS)
PNS_LFLAGS         = -zdefs -e __start -Brogotplt -Bnocopyrel -Bsymbolic $(CMP_PNS_LFLAGS)
PNS_LFLAGS_USESO   = -dy -Bdynamic
MK_BOOTSTRP_LFLAGS = -Bpage_size=0x1000
OS2_TOOLS_FLAGS    =
PN_TOOLS_FLAGS     =
!if "$(BLD_TYPE)" == "debug"
DBG_CRT_FLAGS      = -D__DEBUG_ALLOC__
!else
DBG_CRT_FLAGS      =
!endif
!if "$(CRT_VER)" == "v2"
CRT_VER_FLAGS      =
CRT_VER_LIB        = -lspc
CPLUS_LIB          =
!else
CRT_VER_FLAGS      = -D__THW_PPC__ -D_T_HW_PPC -DMETAWARE \
                     -D_System=  -D_Seg16= -DLNK_CONV=  \
                     -D_Optlink= -D_Builtin=  \
                     -D__EXTENDED__ -D__OS2__  -D_OS2 -D_V3_CRT_
CRT_VER_LIB        = -lcmt
CPLUS_LIB          = -lmwcpp
!endif

MW_IBMC_DEFS       = -D__MW_EXT_ANSI__ -D__MULTI__ -DIBMC_RUNTIME -abi_va_arg $(OS2_TOOLS_FLAGS) $(DBG_CRT_FLAGS) $(CRT_VER_FLAGS)

MW_PNS_DEFS        = -DPNS_RUNTIME $(PN_TOOLS_FLAGS)
SYSTEM_CFLAGS      = -Hon=cpu_603 -Hoff=off_fp_reference -pic -Hoff=slash_file_names -Hon=zero_word_before_functions
SOM_SCFLAGS        = -mcl386 -maddstar -S128000 -C128000 -mnoint -mppc -D_PPC
SOM_CFLAGS         = -DSOM_METHOD_THUNKS -DSOM_DATA_THUNKS -DSOM_METHOD_STUBS -D__OS2__
MK_IMPLIB          = -lmkpn
MK_DD_DASD         = -ldd_dasd
#MK_IMPLIB          = -lmkimp

AFLAGS= -le -o $@

.asm{$(O)}.obj:
    $(AS) $(AFLAGS) $(*B).asm

!else

AFLAGS= -Z -Mx -I. $(DEFS)

.asm{$(O)}.obj:
    $(AS) $(AFLAGS) $(*B).asm,$(O)\$(*B).obj;

!endif

.c{$(O)}.obj:
        $(CC) $(CFLAGS) $(@B).c

.c{$(O)}.i:
        $(CC) $(CFLAGS) $(LISTFLAGS) $< ;

.rc{$(O)}.res:
        $(RC) $(RFLAGS) $< ;

.cpp{$(O)}.obj:
        $(CC) $(CFLAGS) $(@B).cpp

#---------------------------------------------------------------------------
# The BASE_PATHS macro is a list of paths that need to be created.
# Use the createpaths target to create the actual paths listed here.
#--------------------------------------------------------------------------
BASE_PATHS = $(O) $(O_NLV) $(REL) $(SUBSYS_HDR_GEN) $(SUBSYS_LIB_GEN)

#----------------------------------------------------------------------------
# Create Tree Structure
#----------------------------------------------------------------------------
# Use the following to create a directory structure that may not exist
#
# Variable BASE_PATHS must be defined before including this makefile
#
# A path can be any pathname valid for a filename {without the filename and
# no trailing "\"}.
#
# makepath is an utility to create all subdirectories in the path.
#
# Use the createpaths target to make sure paths are created before
# other dependencies
#--------------------------------------------------------------------------

createpaths:
        makepath $(BASE_PATHS)

#----------------------------------------------------------------------------
# The below macro allows you to create special paths dynamically when the
# target is being created.  If you want to use this, then place $(CREATE_PATH)
# in your component makefile.
#
#   Example,
#
#      rel/386/fred/wilma:
#            $(CREATE_PATH)
#----------------------------------------------------------------------------

CREATE_PATH = makepath $(@D)

#----------------------------------------------------------------------------
# Replacement string for MAKEDEP.  Change hardcoded root and MRI path to macro
#----------------------------------------------------------------------------
MAKEDEP_REP_FLAG   = -RT /$(ROOT)\/$$(ROOT)\/ -RT /\$(NLV)\/\$$(NLV)\/

#---------------------------------------------------------------------
# Depend.mak a file that is included in footer.mak.  It is used to check for
# dependancies.
# The following code is not called on the first pass.
#----------------------------------------------------------------------

!ifdef TARGET_PROC
!   ifdef EXE_FMT
!      if [ if exist $(O)\depchk  if exist $(O)\depend.mak del $(O)\depend.mak & \
            if exist $(O)\depchk  if exist $(O)\dephold    del $(O)\dephold    & \
            if exist $(O)\depchk  del $(O)\depchk ] || \
          [ if not exist $(O)\depend.mak makepath $(O) & \
            $(TOUCH) $(O)\depend.mak & $(MAKE) -f $(MAKEFILE_NAME) -a $(O)\depend.mak ]
!      endif
!      if [makepath $(BASE_PATHS) >nul]  || [makepath $(USER_PATHS) >nul]
!      endif
dep:   $(O)\depend.mak
        -del $(O)\dephold
!       endif
!endif

#---------------------------------------------------------------------------
# The End.
#
# Call the build lab at 3-7667 or 3-7668 if you have any questions.
#---------------------------------------------------------------------------
