#------------------------------------------------------------------------
#                         c.video MASTER MAKEFILE
#
# Change History:
# ---------------
# Defect # Date     By  Description
# -----------------------------------------------------------------------------
#         11/05/96  DMH Create
#------------------------------------------------------------------------------


#  Macro definitions

SHORTNAME      = ddkvideo
ROOT           = $(MAKEDIR)
LOGDIR         = $(ROOT)\bldlog\$(SHORTNAME)\$(NLV)
SRC            = src

# Macros for tools.

NSYNC          = nsync

# Build settings

CHECK_RELEASE  = c.video
HOST_PROC      = 386
HOST_OS        = os2

#!if "$(CMVC_RELEASE)" != "$(CHECK_RELEASE)"
#!error Not in proper session for $(CHECK_RELEASE) build
#!endif
#!if [set HOST_PROC=$(HOST_PROC)] || [set HOST_OS=$(HOST_OS)]
#!endif

# Specific Macro definitions

MAKEFILE_NAME    = makefile


# Subsystem components

!ifndef TARG
TARG = all
!endif



LEGACY_COMPS  = ibmdev32 svga256 ibmvga32 32bit xgabvh20 xgasys20 xgadmqs\

VDEV_COMPS    = vvideo vxga

BASE_COMPS    = screendd svdh vdh  svgautil

BBS_COMPS     = bbsinst

INST_COMPS    = dspinstl

GRADD_COMPS  = dbgfilt  gengradd \
               genpmi   s3gradd  \
               pmi5333

ALLCOMPS     = $(LEGACY_COMPS) $(VDEV_COMPS) $(BASE_COMPS) $(BBS_COMPS) \
               $(GRADD_COMPS)  $(INST_COMPS)




VGA32_OUTS   = $(LOGDIR)\ibmdev32.$(OUT_EXT) $(LOGDIR)\svga256.$(OUT_EXT) \
               $(LOGDIR)\ibmvga32.$(OUT_EXT)

PMVIDEO_OUTS = $(LOGDIR)\32bit.$(OUT_EXT) $(LOGDIR)\xgabvh20.$(OUT_EXT) \
               $(LOGDIR)\xgasys20.$(OUT_EXT) $(LOGDIR)\xgadmqs.$(OUT_EXT)

VDEV_OUTS    = $(LOGDIR)\vvideo.$(OUT_EXT) $(LOGDIR)\vxga.$(OUT_EXT)

BASE_OUTS    = $(LOGDIR)\screendd.$(OUT_EXT) $(LOGDIR)\svdh.$(OUT_EXT)     \
               $(LOGDIR)\vdh.$(OUT_EXT)

BBS_OUTS     = $(LOGDIR)\bbsinst.$(OUT_EXT)

INST_OUTS    = $(LOGDIR)\dspinstl.$(OUT_EXT)

GRADD_OUTS   = $(LOGDIR)\dbgfilt.$(OUT_EXT)  $(LOGDIR)\gengradd.$(OUT_EXT) \
               $(LOGDIR)\genpmi.$(OUT_EXT)   $(LOGDIR)\s3gradd.$(OUT_EXT)  \
               $(LOGDIR)\pmi5333.$(OUT_EXT)

MISC_OUTS    = $(LOGDIR)\svgautil.$(OUT_EXT)


# Targets for builds.

default:  retos2c

debug: dbgos2c

retail: retos2c

dekko: dekos2c

dbgos2c retos2c:
        $(MAKE) -f $(SHORTNAME).mak OUT_EXT=$@ TYPE=$@ allos2c

#dekos2c:
#        $(MAKE) -f $(SHORTNAME).mak OUT_EXT=$@ TYPE=retos2c alldekos2c


allos2c: $(ALLCOMPS)

#alldekos2c: $(SUBSYS_COMPS_DEKOS2C)


$(ALLCOMPS): path gettools $(LOGDIR)\$$@.$(OUT_EXT)


gradd: $(GRADD_COMPS)

vdev: $(VDEV_COMPS)



path:
        @-makepath $(LOGDIR)

gettools:
#        gettools -cbip

$(GRADD_OUTS):
        cd $(SRC)\video\$(@B)
        "$(MAKE) -i $(TYPE) 2>&1 |tee $@"
        cd $(MAKEDIR)

$(BASE_OUTS) $(BBS_OUTS):
        cd $(SRC)\video\$(@B)
        "$(MAKE) -i $(TYPE) 2>&1 |tee $@"
        cd $(MAKEDIR)

$(INST_OUTS):
        cd $(SRC)\install\$(@B)
        "$(MAKE) -i $(TYPE) 2>&1 |tee $@"
        cd $(MAKEDIR)

$(VGA32_OUTS):
        cd $(SRC)\video\vga32\$(@B)
        "$(MAKE) -i $(TYPE) 2>&1 |tee $@"
        cd $(MAKEDIR)

$(PMVIDEO_OUTS):
        cd $(SRC)\video\pmvideo\$(@B)
        "$(MAKE) -i $(TYPE) 2>&1 |tee $@"
        cd $(MAKEDIR)

$(VDEV_OUTS):
        cd $(SRC)\video\vdev\$(@B)
        "$(MAKE) -i $(TYPE) 2>&1 |tee $@"
        cd $(MAKEDIR)

$(LOGDIR)\svgautil.$(OUT_EXT):
        echo $(LOGDIR)
        echo $(VGA32_OUTS)
        cd $(SRC)\video\svdh\svgautil
        "$(MAKE) -i $(TYPE) 2>&1 |tee $@"
        cd $(MAKEDIR)

