/****************************************************************/
/* LINESTL.CPP                                                  */
/* Custom Line style demonstration code                         */
/* By Nick Hodapp, 1994                                         */
/*                                                              */
/* For OS/2 Developer Magazine                                  */
/*                                                              */
/****************************************************************/

#define INCL_WIN
#define INCL_GPI

#include <os2.h>

#include "linestl.h"
#include "custstl.h"

MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HAB   hab;
HWND  hWndFrame,
	  hWndClient;
CHAR  szTitle[64];

int main()
{
	HMQ   hmq;
	QMSG  qmsg;
	ULONG flFrameFlags    = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER |
                                FCF_MINMAX   | FCF_SHELLPOSITION | FCF_TASKLIST;

	CHAR  szClientClass[] = "CLIENT";

	hab = WinInitialize (0);
	hmq = WinCreateMsgQueue (hab, 0);

	WinRegisterClass (hab, szClientClass, (PFNWP)ClientWndProc, 0, 0);
	WinLoadString (hab, 0, ID_APPNAME, sizeof(szTitle), szTitle);

	hWndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
		&flFrameFlags, szClientClass, szTitle, 0, 0, ID_APPNAME, &hWndClient);

	while (WinGetMsg (hab, &qmsg, 0, 0, 0))
		WinDispatchMsg (hab, &qmsg);

	WinDestroyWindow (hWndFrame);
	WinDestroyMsgQueue (hmq);
	WinTerminate (hab);
	return (0);
}

MRESULT EXPENTRY ClientWndProc (HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
ULONG	i;
HPS     hps;
POINTL  line[2];
RECTL	rectl;

static LONG maxStyle;

	switch (msg)
	{
	case WM_CREATE:
		for (i = STYLE_RES_START ; i <= STYLE_RES_END ; i++)
			maxStyle = GpiLoadLineStyle(NULLHANDLE, i);

		break;

	case WM_PAINT:
		hps = WinBeginPaint (hWnd,0,0);


		WinQueryWindowRect(hWnd, &rectl);
		WinFillRect(hps, &rectl, CLR_WHITE);

		line[0].x = 50;
		line[0].y = 15;
		line[1].x = rectl.xRight - rectl.xLeft - 50;
		line[1].y = 15;

		for (i = 20 ; i <= maxStyle ; i++) {

			GpiSetLineType(hps, i);
			GpiMove(hps, &line[0]);
			GpiLine(hps, &line[1]);

			line[0].y += 20;
			line[1].y += 20;
		}

		WinEndPaint (hps);
		break;

	case WM_SIZE:
		WinInvalidateRect(hWnd, NULL, TRUE);
		break;

	case WM_ERASEBACKGROUND:
		return (MRESULT) TRUE;

	case WM_DESTROY:
		for (i = 10 ; i <= maxStyle ; i++)
			GpiFreeLineStyle(i);

		break;
	}

	return WinDefWindowProc (hWnd,msg,mp1,mp2);
}


