#ifndef _WINDOW_H_
#define _WINDOW_H_

#define INCL_PM
#include <objc/os2.h>
#include <objc/Object.h>

#define WINDOW_CLASS "ObjcWindow"

@interface Window : Object
{
  HWND    window;

  Window *child;
  Window *sibling;
}

// initializers and destructors
- init;
- associate: (HWND) hwnd;
- free;

// methods concerning window hierarchy
- createObjects;
- insertChild: aChild;
- insertSibling: aSibling;
- findFromID: (USHORT) anId;
- findFromHWND: (HWND) aHwnd;

// methods for access to window words
- (char *) text: (char *) buffer;
- (int) textLength;
- setText: (const char *) buffer;
- setSize: (USHORT) x : (USHORT) y : (USHORT) w : (USHORT) h;
- size: (PSWP) aSize;
- (USHORT) width;   // width of window
- (USHORT) height;  // height of window
- (USHORT) xoffset; // horizontal offset of lower left corner
- (USHORT) yoffset; // vertical offset of lower left corner

// methods for access to instance variables
- (HWND) window;
- (USHORT) pmId;

// methods for access to PM messages
- enable;     // enable window
- disable;    // disable window
- activate;   // activate window
- deactivate; // deactivate window

// message loop
- (MRESULT) handleMessage: (ULONG) msg
            withParams: (MPARAM) mp1 and: (MPARAM) mp2;

@end

MRESULT EXPENTRY __windowFunction (HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);

#endif
