// Revision: 50 1.7.2.1 source/ui/basectl/icombob1.cpp, listctls, ioc.v400 
/*******************************************************************************
* FILE NAME: icombob1.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in icombonh.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#pragma priority( -2147481324 )

extern "C" {
  #define INCL_WINENTRYFIELDS
  #include <iwindefs.h>
}

#ifdef IC_MOTIF
  #include <Xm/List.h>
#endif

#include <iwindow.hpp>
#include <icombobs.hpp>
#include <icombobx.hpp>
#include <icombonh.hpp>
#include <ievent.hpp>
#include <ictlevt.hpp>
#include <inotifev.hpp>
#include <icconst.h>

#if (!defined(IC_MOTIF) && !defined(_IWCNAME_))
  #include <iwcname.hpp>
#endif

// Segment definitions
#ifdef IC_PAGETUNE
  #define _ICOMBOB1_CPP_
  #include <ipagetun.h>
#endif

// Initialize static objects and notification strings.
INotificationId const IComboBox::addId    = "IComboBox::add";
INotificationId const IComboBox::removeId = "IComboBox::remove";
INotificationId const IBaseComboBox::enterId  = "IBaseComboBox::enter";
INotificationId const IBaseComboBox::selectId = "IBaseComboBox::select";
INotificationId const IBaseComboBox::itemChangedId = "IBaseComboBox::itemChangedId";
INotificationId const IBaseComboBox::itemsId = "IBaseComboBox::itemsId";


/*------------------------------------------------------------------------------
| IBaseComboBox::enableNotification                                                |
|                                                                              |
| Flags this part as being ready to accept notifications.  A Notifier, like    |
| IBaseComboBox, does not send notifications to observer objects until it is       |
| enabled.                                                                     |
|                                                                              |
| In the window hierarchy we override this function to allocate the correct    |
| notification handler.                                                        |
------------------------------------------------------------------------------*/
IBaseComboBox& IBaseComboBox::enableNotification (bool enabled)
{
  if (!notificationHandler())
  {
    setNotificationHandler( new IComboBoxNotifyHandler() );
  }
  IWindow::enableNotification(enabled);
  return *this;
}

/*------------------------------------------------------------------------------
| IComboBoxNotifyHandler::IComboBoxNotifyHandler                               |
|                                                                              |
| Default constructor.                                                         |
------------------------------------------------------------------------------*/
IComboBoxNotifyHandler::IComboBoxNotifyHandler()
{}

/*------------------------------------------------------------------------------
| IComboBoxNotifyHandler::~IComboBoxNotifyHandler                              |
|                                                                              |
| Destructor.                                                                  |
------------------------------------------------------------------------------*/
IComboBoxNotifyHandler::~IComboBoxNotifyHandler()
{}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IComboBoxNotifyHandler::dispatchHandlerEvent                                 |
|                                                                              |
| This notifies IBaseComboBox Windows of the following events:                     |
|                                                                              |
| select(Id)                                                                   |
------------------------------------------------------------------------------*/
bool IComboBoxNotifyHandler::dispatchHandlerEvent (IEvent& anEvent)
{
  IWindow* thisWindow = anEvent.window();

  switch (anEvent.eventId())
  {
    case WM_CONTROL:
    {
      IControlEvent ctlevt(anEvent);
      IWindow* pwndControl = ctlevt.controlWindow();
      unsigned long ulMsg  = ctlevt.parameter1().highNumber();
      IWindowHandle hwndControl;
#ifdef IC_PM
	
	if (ulMsg == EN_SETFOCUS)
	{
		thisWindow->notifyObservers(
                   INotificationEvent(IWindow::focusId,
                                      *thisWindow, false, (void*)true));
	}
	
	else if(ulMsg == EN_KILLFOCUS)
	{
		thisWindow->notifyObservers(
                   INotificationEvent(IWindow::focusId,
                                      *thisWindow, false, (void*)false));
	}
#endif

      if (pwndControl)
      {
        hwndControl = pwndControl->handle();
        thisWindow = pwndControl;
      }
      else
      {
        hwndControl = IWindow::handleWithParent(ctlevt.controlId(),
                                                ctlevt.handle());
        thisWindow = IWindow::windowWithOwner(ctlevt.controlId(),
                                              ctlevt.window());
      }

      if (hwndControl && thisWindow)
      {
        IWindowClassName className(hwndControl);
        if (className == WC_COMBOBOX)
        {
          if (ulMsg == CBN_LBSELECT)
          {
            thisWindow->notifyObservers(INotificationEvent(
                                        IBaseComboBox::selectId,
                                        *thisWindow));
          }
#ifdef IC_WIN
          else if (ulMsg == CBN_ENTER || ulMsg == IC_UM_CBN_ENTER)
#else
          else if (ulMsg == CBN_ENTER)
#endif
          {
            thisWindow->notifyObservers(INotificationEvent(
                                        IBaseComboBox::enterId,
                                        *thisWindow));
          }
#ifdef IC_WIN
          else if (ulMsg == CBN_SETFOCUS )
          {
          thisWindow->notifyObservers(
                   INotificationEvent(IWindow::focusId,
                                      *thisWindow, false, (void*)true));
          }
          else if ( ulMsg == CBN_KILLFOCUS )
          {
          thisWindow->notifyObservers(
                   INotificationEvent(IWindow::focusId,
                                      *thisWindow, false, (void*)false));
          }
#endif
        }
      }
    break;
    }

#ifdef IC_WIN
    case WM_CHAR:
    {
      if ((unsigned long)anEvent.parameter1() == VK_RETURN)
      {
        thisWindow->notifyObservers(INotificationEvent(
                                    IBaseComboBox::enterId,
                                    *thisWindow));
      }
    break;
    }
#endif

    default:
      break;
  }  /* end switch */

  return (Inherited::dispatchHandlerEvent(anEvent));
}

#endif // IC_PMWIN


#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| IComboBoxNotifyHandler::dispatchHandlerEvent                                 |
|                                                                              |
| This notifies IBaseComboBox Windows of the following events:                 |
|                                                                              |
| select(Id)                                                                   |
------------------------------------------------------------------------------*/
bool IComboBoxNotifyHandler::dispatchHandlerEvent(IEvent& anEvent)
{
     if (anEvent.eventId() == motifEvent(XmCR_BROWSE_SELECT))
     {
       IControlEvent ctlevt(anEvent);
       IWindow* pwndControl = ctlevt.controlWindow();
       IWindow* thisWindow;
       IWindowHandle hwndControl;

       if (pwndControl)
       {
         hwndControl = pwndControl->handle();
         thisWindow = pwndControl;
       }
       else
       {
         hwndControl = IWindow::handleWithParent(ctlevt.controlId(),
                                            ctlevt.handle());
         thisWindow = IWindow::windowWithOwner(ctlevt.controlId(),
                                            ctlevt.window());
       }
       if ( (thisWindow) && (hwndControl) )
       {
         if (!(XtIsSubclass((Widget)hwndControl,
           xmListWidgetClass)))
         {
           thisWindow->notifyObservers(INotificationEvent(
             IComboBox::selectId, *thisWindow));
         }
       }
     }  /* end if */

   return (Inherited::dispatchHandlerEvent(anEvent));
}

#endif // IC_MOTIF

