// Revision: 04 1.112.1.15 source/ui/baseapp/iwindow2.cpp, basewin, ioc.v400 
/*******************************************************************************
* FILE NAME: iwindow2.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iwindow.hpp that are common to all platforms.                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
// Priority INT_MIN (-2147483647 - 1) + 1024 + 512
#pragma priority( -2147482112 )

#define INCL_WIN
#define INCL_GPIERRORS
#define INCL_GPILOGCOLORTABLE
#define INCL_GPIPRIMITIVES
#define INCL_GPIREGIONS
#define INCL_WINERRORS
#define INCL_WINWINDOWMGR
extern "C"
{
  #include <iwindefs.h>
  #ifdef IC_MOTIF
    #include <Xm/Xm.h>
    #include <Xm/MainW.h>
    #include <Xm/AtomMgr.h>
    #include <Xm/BulletinB.h>
    #include <Xm/CascadeBG.h>
    #include <Xm/CascadeB.h>      // 27912
    #include <Xm/FileSB.h>
    #include <Xm/MenuShell.h>
    #include <Xm/RowColumn.h>
    #include <Xm/ToggleBG.h>
    #include <Xm/ScrolledW.h>
    #include <Xm/Text.h>
    #include <Xm/Label.h>
    #include <Xm/Form.h>
    #include <Xm/DrawingA.h>
    #include <X11/IntrinsicP.h>   // d8175 - for CoreP.h.
    #include <X11/CoreP.h>        // d8175 - for being_destroyed.
  #endif
}

#include <iwindow.hpp>
#include <iaccelhd.hpp>
#include <iacceltb.hpp>
#include <ibidiset.hpp>
#include <icoordsy.hpp>
#include <icconst.h>
#include <idefstyl.h>
#include <ievent.hpp>
#include <iexcept.hpp>
#include <ifont.hpp>
#include <iframe.hpp>
#include <iguilock.hpp>
#include <ihandler.hpp>
#include <ihelp.hpp>
#include <ihelpsta.hpp>
#include <iinhratt.hpp>
#include <inotifev.hpp>
#include <iperfset.hpp>
#include <iplatfrm.hpp>
#include <ipoint.hpp>
#include <irect.hpp>
#include <ireslib.hpp>
#include <istring.hpp>
#include <ithread.hpp>
#include <ithreadp.hpp>
#include <itrace.hpp>
#include <iwcname.hpp>
#include <iwinlsts.hpp>
#include <iwinnhdr.hpp>
#include <iwinpriv.hpp>
#include <imsgtext.hpp>
#include <icanvas.hpp>
#include <ifontprv.hpp>

#ifdef IC_WIN
  #include <ibrshmgr.hpp>
#endif
#ifdef IC_MOTIF
  #include <ibmpdata.hpp>
  #include <ibmpstat.hpp>
  #include <icolmap.hpp>
  #include <iss.h>
  #include <icnrobj.hpp>
	#include <cnr.h>
	#include <icnrrec.hpp>
	#include <icnrctl.hpp>
	#include <icnrctlm.hpp>
#endif

// Performance Analyser hooks.
#ifdef IC_PERF
  #ifdef IC_WIN
     #include <iperf.h>
  #endif
  #ifdef IC_PM
     #include <icsperf.h>
  #endif
#endif

// Segment definitions.
#ifdef IC_PAGETUNE
  #define _IWINDOW2_CPP_
  #include <ipagetun.h>
#endif

#ifdef IC_WIN
  #ifndef _ICLCCL_
   #include <iclccl.h>
  #endif
  #include <icctlsta.hpp>

  void* __stdcall  _pfnwpICWinProc2( HWND hwnd,
                                     unsigned long ulMsg,
                                     void* mp1, void* mp2 );

#endif
#ifdef IC_PM
  void* _System _pfnwpICWinProc2( INativeWindowHandle hwnd,
                                  unsigned long ulMsg,
                                  void* mp1, void* mp2 );

#endif

#ifdef IC_MOTIFWIN
  extern unsigned long propagationInProgress;
#endif

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| This is a dummy PM style window procedure.                                   |
------------------------------------------------------------------------------*/
  extern void* _System _pfnwpICWinProc( unsigned long, unsigned long,
                                        void*, void* );


  #define IDEFWINDOWPROC    _pfnwpICWinProc
  #define IIDOF(hwnd) \
            (IString(XtName( (Widget) hwnd )).asInt() )
  #define IENABLEWINDOWUPDATE(hwnd, enable)
  #define IISWINDOWENABLED(hwnd) \
            ( XtIsSensitive( (Widget) hwnd ) )
  #define IPARENTOF(hwnd) \
            ( XtParent( (Widget) hwnd ) )
  #define ISTYLEOF(hwnd) \
            0
//  #define IWINDOWFROMID(parent, ulId) \
//            ( XtNameToWidget( parent, (char *)IString(ulId) ))
  #define IQUERYCAPTURE \
            0
  #define ISETPOINTERPOSITION(x,y)
  #define IQUERYPOINTERPOSITION(x,y) \
            { x = 0; \
              y = 0; }

inline void* IQUERYUSERDATA( IWindowHandle::Value hwnd )
{
  XtPointer valu(0);
  XtVaGetValues( hwnd, XmNuserData, &valu, 0 );
  return (void*)valu;
}

inline void ISETUSERDATA( IWindowHandle::Value hwnd, void* valu )
{
  XtVaSetValues( hwnd, XmNuserData, (XtPointer)valu, 0 );
}

// the last button event is used for the capture time.
  extern XButtonPressedEvent  ithreadLastButtonEvent;

#endif // IC_MOTIF


#if 0  // Debug only
class Tracer {
public:
  Tracer() : fnested(0), fnotnested(0) { };
  ~Tracer()
 {
    ITRACE_RUNTIME(IString("Nested dispatches=") + IString(fnested));
    ITRACE_RUNTIME(IString("Not nested dispatches=") + IString(fnotnested));
 };
unsigned fnested;
unsigned fnotnested;
};
static Tracer tracer;
#endif  //Debug only

/***************************************************************/
/* Public window styles.                                       */
/***************************************************************/
const IWindow::Style
  IWindow::noStyle      ( 1, IWindow__noStyle),
  IWindow::visible      ( 1, IWindow__visible),
  IWindow::disabled     ( 1, IWindow__disabled),
  IWindow::clipChildren ( 1, IWindow__clipChildren),
  IWindow::clipSiblings ( 1, IWindow__clipSiblings),
  IWindow::clipToParent ( 1, IWindow__clipToParent),
  IWindow::saveBits     ( 1, IWindow__saveBits),
  IWindow::group        ( 1, IWindow__group),
  IWindow::tabStop      ( 1, IWindow__tabStop),
  IWindow::synchPaint   ( 1, IWindow__synchPaint),
  IWindow::leftToRight  ( 1, IWindow__leftToRight ),
  IWindow::rightToLeft  ( 1, IWindow__rightToLeft );

/***************************************************************/
/* Public event masks.                                         */
/***************************************************************/
const IWindow::EventMask
  IWindow::someMouseMoves    ( 1, IWindow__someMouseMoves ),
  IWindow::allMouseMoves     ( 1, IWindow__allMouseMoves ),
  IWindow::mouseEntersLeaves ( 1, IWindow__mouseEntersLeaves );

bool IWindowPrivateData::bProcessMsgsNoWait = false; // Normally false.
static bool desktopConstructionInProgress = false;


/*------------------------------------------------------------------------------
|ITheDesktopWindow::ITheDesktopWindow                                          |
------------------------------------------------------------------------------*/
ITheDesktopWindow::ITheDesktopWindow()
    : hwnd(0)
{
#ifdef IC_MOTIF
  if (  !IThread::current().isGUIInitialized() )
    IThread::current().initializeGUI();

  // On Motif, use the application shell as the desktop handle.
  this->hwnd = IThread::current().applicationShell();
#endif
#ifdef IC_PMWIN
  this->hwnd = IQUERYDESKTOPWINDOW(IThread::current().anchorBlock(),0);
#endif
}



/*------------------------------------------------------------------------------
| IWindow::desktopWindow                                                       |
|                                                                              |
| Return static ITheDesktopWindow pointer.                                     |
------------------------------------------------------------------------------*/
IWindow* IWindow::desktopWindow()

{
  if ( ( IWindowStaticData::desktopWindow == 0) &&
       ( desktopConstructionInProgress == false) )
  {
    desktopConstructionInProgress  = true;
    IWindowStaticData::desktopWindow = new ITheDesktopWindow();
    desktopConstructionInProgress  = false;
  } /* endif */
  return IWindowStaticData::desktopWindow;
}

/*------------------------------------------------------------------------------
| IWindow::objectWindow                                                        |
|                                                                              |
| Return static ITheObjectWindow pointer.                                      |
------------------------------------------------------------------------------*/
IWindow* IWindow::objectWindow()
{
   if (IWindowStaticData::objectWindow == 0)
   {
      IWindowStaticData::objectWindow = new ITheObjectWindow();
   }
  return IWindowStaticData::objectWindow;
}


/*------------------------------------------------------------------------------
| IWindow::IWindow                                                             |
|                                                                              |
| Constructor to create an instance for template window.                       |
------------------------------------------------------------------------------*/
IWindow::IWindow ( unsigned long id,
                   IWindow* parentDialog )
  : windowDataArray(0)
  , ulWindowDataArraySize(0)
  , pWindowData( new IWindowPrivateData( (IWinProc*)IDEFWINDOWPROC,
                                         IWindow::cacheMinimumSize )),
    hwnd( 0 )
{
  this->startHandlingEventsFor( id, parentDialog );

  // Add this object to the list of all valid IWindow objects.
  IAllAllocatedIWindows::add( this );
}

/*------------------------------------------------------------------------------
| IWindow::IWindow                                                             |
|                                                                              |
| Constructor to instantiate from an existing window handle.                   |
------------------------------------------------------------------------------*/
IWindow::IWindow ( const IWindowHandle& handle )
  : windowDataArray(0)
  , ulWindowDataArraySize(0)
  , pWindowData( new IWindowPrivateData( (IWinProc*)IDEFWINDOWPROC,
                                         IWindow::cacheMinimumSize )),
    hwnd( 0 )
{
  // Assertions on input parameters.
  IASSERTPARM( handle!=0 );
  this->startHandlingEventsFor( handle );

  // Add this object to the list of all valid IWindow objects.
  IAllAllocatedIWindows::add( this );
}

/*------------------------------------------------------------------------------
| IWindow::IWindow                                                             |
------------------------------------------------------------------------------*/
IWindow::IWindow ( )
  : windowDataArray(0)
  , ulWindowDataArraySize(0)
  , pWindowData( new IWindowPrivateData( (IWinProc*)IDEFWINDOWPROC,
                                         IWindow::autoDestroyWindow
                                         | IWindow::cacheMinimumSize )),
    hwnd( 0 )
{
  IMODTRACE_ALL( "Win::ctor" );

  #ifdef IC_DEVELOP
    IWindowList::incrementWindowAddedCount();
  #endif

  // Add this object to the list of all valid IWindow objects.
  IAllAllocatedIWindows::add( this );
}

/*------------------------------------------------------------------------------
| IWindow::~IWindow                                                            |
------------------------------------------------------------------------------*/
IWindow::~IWindow()
{
  IMODTRACE_ALL("Win::dtor");

  // Free the memory allocated by IWindow::addOrReplaceAttribute
  // for each attribute stored by the window.
  this->removeAllAttributes();

  // Catch attempts to delete an IWindow from within a handler attached
  // to the IWindow.  This can cause random traps since the dispatcher
  // will be accessing IWindow data which has been deleted/deallocated.
  if ( pWindowData->state & dispatchInProcess )
    {
    ITHROWLIBRARYERROR( IC_WINDOW_DELETE_FROM_CALLBACK,
                        IBaseErrorInfo::invalidRequest,
                        IException::recoverable);
    }

  notifyObservers(INotificationEvent(INotifier::deleteId, *this));

  #ifdef IC_DEVELOP
    IWindowList::incrementWindowDeletedCount();
  #endif

  // If the parent of this window is a frame window, attempt to remove
  // this window from the parent's frame extension list.  If this
  // window is not of frame extension, the call to removeExtension
  // will have no affect.
  if ( this->isValid() && this->isAutoDestroyWindow() )
  {
    IFrameWindow* fParent = dynamic_cast<IFrameWindow*> (this->parent());
    if ( fParent )
    {
      fParent -> removeExtension( this, false );
    }
  }

  //-------------------------------------------------------------------
  // DEFECT 24677/29093 : remove all handlers WAS HERE!!!
  //  cannot remove handlers BEFORE firing the destroyWindow,
  //  because some handlers trap WM_DESTROY for cleanup.
  //-------------------------------------------------------------------
  //-------------------------------------------------------------------
  // DEFECT 9811  : remove is added back for 1 case.
  //  The case is only if we are in an autoDestroyWindow mode:
  //  ie. the programmer is deleting the window object directly via
  //      C++ delete or the class has gone out of scope.
  //  why?.  We cannot rely on all the handlers attached at this point
  //         to be valid.  ie.  if we are deleting a frame, then the
  //         frame destructor fired followed by the iwindow destructor.
  //         Now the IDESTROYWINDOW will send a wm_destroy message to
  //         this window firing all handlers.  So an IFrameWindow
  //         handler could get control, and access the IFrameWindow elements
  //         that no longer exist.
  //  NOTE:  This will break users who are expecting a WM_DESTROY msg and
  //         the window is auto destroy.  At that point, the handlers
  //         may be unstable thus we have to remove them, but the user
  //         should be able to handle the condition in their window
  //         destructor.  ie. destructor cal means window is being destroyed.
  //-------------------------------------------------------------------
  if( isAutoDestroyWindow() )
  {
    // We are going to destroy the control, so get rid of any handlers.
    if (pWindowData->handlerList != 0)
    {
       IGUIResourceLock windowLock(IWindowList::libraryKey());

       // cursor the handler list and decrement the numWindows.
       IHandlerList::Cursor cursor(*pWindowData->handlerList);
       unsigned long index = 1;
       for(cursor.setToFirst();
           cursor.isValid() && index <= pWindowData->handlerList->numberOfElements();
           cursor.setToNext(), index++)
       {
           pWindowData->handlerList->elementAt(cursor).fHandler->numWindows--;
       }
       pWindowData->handlerList->removeAll();
       delete pWindowData->handlerList;
       pWindowData->handlerList = 0;
       pWindowData->fHandlerRemovePending = false;
    } /* endif */
  }

  if ( this->isValid() )
  {  // Window not destroyed yet.

     // Canvas can adjust itself for the destroyed IWindow.
     // We want to do this only if this->hwnd is still valid.
     // For ISubmenu, IFileDialog, and IFontDialog objects,
     // this->hwnd may be invalid since these don't do
     // startHandlingEventsFor.
     setLayoutDistorted(windowDestroyed, 0);  // Flag for canvases.

     // Destroy the window handle if autoDestroy, except if a delete
     // is in process, which would indicate that we are already
     // processing a WM_DESTROY.
     ITRACE_ALL("Valid window");
     if (isAutoDestroyWindow())
     {
       if (!deleteIsInProcess())
       {
          setDeleteInProcess();
          ITRACE_ALL(IString("WinDestroyWin ")+IString(this->hwnd).d2x());
#ifdef IC_WIN
          // If this is a frame window we are about to destroy, we
          // must unregister the unique frame class we registered
          // when we created the frame.  This will prevent a memory leak.
          if (this->isFrameWindow())
          {
            IWindowClassName wcName(this->handle());
            IDESTROYWINDOW(this->hwnd);
            // Only unregister the frame classes we create.
            // Do not unregister WC_DIALOG, which is a Windows global class
            if ((wcName.asString().indexOf(WC_FRAME) == 1) )
              UnregisterClass(wcName, GetModuleHandle(0));
          }
          else
            IDESTROYWINDOW(this->hwnd);
#endif // IC_WIN
#ifdef IC_PM
            IDESTROYWINDOW(this->hwnd);
#endif // IC_PM
#ifdef IC_MOTIF
           if ( XtIsWidget( (Widget) this->hwnd ) )
           {
              // If the widget we are destroying has focus then give focus to
              // someone else.
              if ( XmGetFocusWidget( (Widget) this->hwnd ) ==
                   (Widget) this->hwnd )
                XmProcessTraversal( (Widget) this->hwnd, XmTRAVERSE_RIGHT );

              // d7518 - Need to realize the shell widget of an IFrameWindow
              //         to avoid suspected bug in XtDestroy (AIX 4.1 MBCS only).
              if ( XtIsShell( (Widget) this->hwnd) )
                 XtRealizeWidget( (Widget) this->hwnd );

              // The destroy might actually be delayed because of the two phase
              // destroy ( See Xt-FAQ question 9 )
              XtUnmanageChild( (Widget) this->hwnd );
              pWindowData->motifState &= ~IWindowPrivateData::visible;

              XtDestroyWidget( (Widget) this->hwnd );
           }
#endif // IC_MOTIF
       }

     }
#ifdef IC_PMWIN
     else
     {
       // Reset the window procedure to its original value.
       // If we don't do this and this same HWND is wrappered again, we
       // would set pWindowData->defaultProc to our own ICLUI window
       // procedure and cause infinite loops.
       if ( pWindowData->defaultProc != 0  &&
            pWindowData->defaultProc != _pfnwpICWinProc &&
            pWindowData->defaultProc != _pfnwpICWinProc2 )
       {
          ITRACE_ALL( "Resetting winproc" );
          void*  pfnwpDefault = (void*)ISUBCLASSWINDOW( this->hwnd,
                                             pWindowData->defaultProc );
          if ( pfnwpDefault == 0 )
          {
             ITHROWGUIERROR( "WinSubclassWindow" );
          }
          else if (pfnwpDefault == _pfnwpICWinProc)
          {
             // The window was using the fastWindowWithHandle
             // optimization.  Clear out the user window word.
             ISETUSERDATA( (INativeWindowHandle)this->hwnd, 0);
          }
          pWindowData->defaultProc = 0;
       }
     } /* endif */
#endif  // IC_PMWIN
  }

  this->cleanUp();

  //-------------------------------------------------------------------
  // DEFECT 24677/29093 : remove all handlers IS NOW HERE!!!
  //  (moved to AFTER any call to IDESTROYWINDOW)
  //-------------------------------------------------------------------
  // We are going to destroy the control, so get rid of any handlers.
  if (pWindowData->handlerList != 0)
  {
     IGUIResourceLock windowLock(IWindowList::libraryKey());

     // cursor the handler list and decrement the numWindows.
     IHandlerList::Cursor cursor(*pWindowData->handlerList);
     unsigned long index = 1;
     for(cursor.setToFirst();
         cursor.isValid() && index <= pWindowData->handlerList->numberOfElements();
         cursor.setToNext(), index++)
     {
         pWindowData->handlerList->elementAt(cursor).fHandler->numWindows--;
     }
     pWindowData->handlerList->removeAll();
     delete pWindowData->handlerList;
     pWindowData->handlerList = 0;
     pWindowData->fHandlerRemovePending = false;
  } /* endif */


  delete pWindowData->_observerData;
  delete pWindowData;

  // Clean up all user supplied window data associated with the window
  // Must iterate through and call delete on all elements of the array
  if (windowDataArray)
  {
    for (int i=0; i < ulWindowDataArraySize; i++)
      {
        if (windowDataArray[i])
          delete windowDataArray[i];
      }
    delete [] windowDataArray;
  }

  // Remove this object from the list of all valid IWindow objects.
  IAllAllocatedIWindows::remove( this );
}


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::dispatch                                                            |
|                                                                              |
| Dispatch the event. First to the handler in the list,                        |
| then to handleWindow event and finally to defaultProcedure.                  |
------------------------------------------------------------------------------*/
bool IWindow::dispatch(IEvent& evt)
{
  IMODTRACE_ALL("Win::dispatch");

#ifdef IC_WIN
   switch (evt.eventId())
   {
      //-------------------------------------------------------------
      // Windows does not send double click messages for windows that
      // were not registered with the CS_DBLCLKS class style.  As a
      // result, we need to simulate the double click messages for
      // all other windows.
      //-------------------------------------------------------------
      case  WM_LBUTTONDOWN :
      case  WM_MBUTTONDOWN :
      case  WM_RBUTTONDOWN :
      {
        // If mouse button 1 pressed at same time as button 2,
        // generate a chord event in addition to a button event
        bool bChording = false;
        if ( (( evt.eventId() == WM_LBUTTONDOWN ) &&
             ((bool)HIBYTE(GetKeyState(VK_RBUTTON))) ) ||
             (( evt.eventId() == WM_RBUTTONDOWN ) &&
             ((bool)HIBYTE(GetKeyState(VK_LBUTTON))) ) )
        {
          // To be like OS/2, the chord message ONLY goes to the
          // originating control, so don't create it for other windows
          if ( evt.dispatchingWindow() == evt.controlWindow() )
          {
            evt.handle().postEvent( WM_CHORD,
                                    evt.parameter1(),
                                    evt.parameter2() );

            // Set last button time to 0 to suppress click message
            pWindowData->lastButtonTime = 0;
            bChording = true;
          }
        }

        pWindowData->eat_BN_CLICKED = false;
        long classStyle( GetClassLong( evt.handle(), GCL_STYLE ));

        if (!bChording)
        {
          if (!(classStyle & CS_DBLCLKS))
          {
            int maxXDelta(GetSystemMetrics( SM_CXDOUBLECLK));
            int maxYDelta(GetSystemMetrics( SM_CYDOUBLECLK));

            if (pWindowData->lastButtonTime)
            {
              if ( (evt.eventId() == pWindowData->lastButtonEventId) &&
                   (evt.handle() == pWindowData->lastButtonEventHandle) &&
                   (labs( pWindowData->lastButtonTime - GetMessageTime()) <
                         GetDoubleClickTime()) &&
                   (abs( (short)pWindowData->lastButtonPos.x() -
                           (short)evt.parameter2().lowNumber() ) < maxXDelta ) &&
                   (abs( (short)pWindowData->lastButtonPos.y() -
                           (short)evt.parameter2().highNumber() ) < maxYDelta ))
              {
                long newEventId;
                switch (evt.eventId())
                {
                  case WM_LBUTTONDOWN:
                    newEventId = WM_LBUTTONDBLCLK;
                    break;
                  case WM_MBUTTONDOWN:
                    newEventId = WM_MBUTTONDBLCLK;
                    break;
                  case WM_RBUTTONDOWN:
                    newEventId = WM_RBUTTONDBLCLK;
                    break;
                }
                evt = IEvent( evt.handle(),
                              newEventId,
                              evt.parameter1(),
                              evt.parameter2() );
                pWindowData->lastButtonTime = 0;
              }
              else
              {
                pWindowData->lastButtonTime = GetMessageTime();
              }
            }
            else
            {
              pWindowData->lastButtonTime = GetMessageTime();
            }
            pWindowData->lastButtonEventHandle = evt.handle();
            pWindowData->lastButtonEventId     = evt.eventId();
            pWindowData->lastButtonPos.setX( (long)evt.parameter2().lowNumber() );
            pWindowData->lastButtonPos.setY( (long)evt.parameter2().highNumber() );
          }
          else
          {
            // The last button time is set to 1 so that we can determine if
            // a button up message is part of a double click.  If a buttonup
            // message is the second message in a double click, then a click
            // message should not be posted.
            pWindowData->lastButtonTime = 1;
          }
        }
      }
      break;

      //-------------------------------------------------------------
      // Windows does not send click messages.  Post one to the window
      // if we are getting a button up message, and we didn't just
      // translate a double click message.
      //-------------------------------------------------------------
      case WM_LBUTTONUP :
      case WM_MBUTTONUP :
      case WM_RBUTTONUP :
      {
        //In Windows on a double-click of a button, the button changes
        //it's state on the button up, not the dblclick.  This hack is
        //used to post a private user message when we receive the button up
        //AFTER the dblclick.  This will have the effect of the select
        //handler calling enter() after receiving this posted message.
        if (pWindowData->eat_BN_CLICKED && !(pWindowData->lastButtonTime))
        {
          // We should send this message ONLY from the original double-click
          // up and should propagate the message (as per other mouse messages
          // so the event handles are correct for the select handler)
          if ( evt.dispatchingWindow() == evt.controlWindow() )
          {
            evt.handle().postEvent( IC_UM_LBUTTONDBLCLK,
                                    evt.parameter1(),
                                    evt.parameter2() );
          }
        }

        if (pWindowData->lastButtonTime != 0)
        {
          // To be like OS/2, the click message ONLY goes to the
          // originating control, so don't create it for other windows
          if ( evt.dispatchingWindow() == evt.controlWindow() )
          {
            unsigned long eventId;
            switch (evt.eventId())
            {
              case WM_LBUTTONUP:
                eventId = WM_BUTTON1CLICK;
              break;
              case WM_MBUTTONUP:
                eventId = WM_BUTTON3CLICK;
              break;
              case WM_RBUTTONUP:
                eventId = WM_BUTTON2CLICK;
              break;
            }
            evt.handle().postEvent( eventId,
                                    evt.parameter1(),
                                    evt.parameter2() );
          }
        }
      }
      break;

      //-------------------------------------------------------------
      // Set the last message time to 0 so that the next button up
      // message will not cause a click event to be posted.
      //-------------------------------------------------------------
      case WM_LBUTTONDBLCLK :
      case WM_MBUTTONDBLCLK :
      case WM_RBUTTONDBLCLK :
      {
        pWindowData->lastButtonTime = 0;
        pWindowData->eat_BN_CLICKED = true;
      }
      break;

      //-------------------------------------------------------------
      // It appears that Windows creates a BN_CLICK message right after
      // it creates a WM_XBUTTONDBLCLK for Windows with the CS_DBLCLKS
      // style. This is not the same behavior as PM. In a select handler
      // this will cause an extra selected call. If a BN_CLICK is detected
      // after an DBLCLK before a button down message then eat the event.
      //-------------------------------------------------------------
      case  WM_CONTROL:
      {
        unsigned long subMsg = evt.parameter1().number2();
        if ( subMsg == BN_CLICKED )
        {
          if ( pWindowData->eat_BN_CLICKED )
          {
            pWindowData->eat_BN_CLICKED = false;
            return true;
          }
        }
      }
      break;

      //-------------------------------------------------------------
      // Windows does not provide the old size on WM_WINDOWPOSCHANGED.
      // We save the old size in private data and use it on a user message
      // which is sent and processed by IResizeHandler.  User message is
      // as follows:
      //    msgid    IC_UM_WINDOWPOSCHANGED
      //    wparam   (unused)
      //    lparam   address of array of 2 SIZE structures with new size
      //             and old size in that order
      //-------------------------------------------------------------
      case  WM_WINDOWPOSCHANGED:
      {
        PWINDOWPOS pswp = (PWINDOWPOS)((char*)evt.parameter2());
        if (!(pswp->flags & SWP_NOSIZE))
        {
          // We could clone the PM message by using SWP instead of SIZE
          // structures, but this saves space and no need seen at this time.
          SIZE size[2];
          size[1].cx = pWindowData->oldWidth;
          size[1].cy = pWindowData->oldHeight;
          size[0].cx = pswp->cx;
          size[0].cy = pswp->cy;
          evt.handle().sendEvent( IC_UM_WINDOWPOSCHANGED,
                                 IEventData( 0 ),
                                 IEventData( (void*) size ) );
          pWindowData->oldWidth  = pswp->cx;
          pWindowData->oldHeight = pswp->cy;
        }
      }
      break;
   }  // switch
#endif

  //---------------------------------------------------------
  // We need to keep track of the top level entry to this
  // function so that we can be sure we have left all nested
  // calls prior to deleted the object on WM_DESTROY.
  //---------------------------------------------------------
  bool fNested = (int)((pWindowData->state & (int)dispatchInProcess));
  pWindowData->state |= dispatchInProcess;

  //---------------------------------------------------------
  // Dispatch event to Handler.
  //---------------------------------------------------------
  bool bStop = false;
  if ( pWindowData->handlerList != 0  &&
       this->isHandling( evt.eventId() ) )
  {
      try
      {
         //---------------------------------------------------------
         // Store the handler list in the event.  This is done so that
         // when dispatchRemainingHandlers is called, it will have access
         // to the handler list in which to iterate.
         //---------------------------------------------------------
         evt.setHandlerList(pWindowData->handlerList);
         if (fNested)
         {
             //DEBUG tracer.fnested++;
             //A nested dispatch.  Create a stack cursor object and use it
             //for dispatching the handlers.  The top level cursor position
             //must be preserved.
             IHandlerList::Cursor cursor(*pWindowData->handlerList);
             // Set cursor position to first element and store the cursor
             // in the event.  This is so dispatchRemainingHandlers()
             // will know where to start from.
             cursor.setToFirst();
             evt.setHandlerCursor(&cursor);
             bStop = dispatchRemainingHandlers(evt, false);
         }
         else
         {
             //DEBUG tracer.fnotnested++;
             //Not a nested dispatch.  Use the cursor in the HandlerList
             //object to avoid constructing/destructing the cursor object.

             // Set cursor position to first element and store the cursor
             // in the event.  This is so dispatchRemainingHandlers()
             // will know where to start from.
             pWindowData->handlerList->fcursor.setToFirst();
             evt.setHandlerCursor(&pWindowData->handlerList->fcursor);
             bStop = dispatchRemainingHandlers(evt, false);
         }
      }
      catch (IException &exc)
      {
          // Any exceptions which get to here have not been handled
          // by the handleException() function.  We need to cleanup
          // and get out.
          this->dispatchCleanup( evt, fNested );
          IRETHROW( exc );
      }
  }

#ifdef IC_WIN
  //---------------------------------------------------------
  // If color change, notify the window through the
  // setLayoutDistorted function.
  //---------------------------------------------------------
  if (evt.eventId() == WM_SYSCOLORCHANGE)
  {
    setLayoutDistorted( IWindow::colorChanged, 0);
  }
#endif //IC_WIN
#ifdef IC_PM
  //---------------------------------------------------------
  // If color or font change, notify the window through the
  // setLayoutDistorted function.
  //---------------------------------------------------------
  if (evt.eventId() == WM_PRESPARAMCHANGED)
  {
    if ( (evt.parameter1() == PP_FONTNAMESIZE) ||
         (evt.parameter1() == PP_FONTHANDLE) )
      setLayoutDistorted(IWindow::fontChanged, 0);
    else if(evt.parameter1() != PP_USER && evt.parameter1() != PP_RESERVED )
      setLayoutDistorted(IWindow::colorChanged, 0);
  }
  else if ( evt.eventId() == WM_SYSCOLORCHANGE )
  {               // System-wide scheme change.
    setLayoutDistorted( IWindow::colorChanged, 0 );
  }
#endif

  if ((evt.eventId() != WM_MOUSEMOVE) && (pWindowData->_observerData))
  {
    // Check for defaultProc being non-zero to skip this dispatching if
    // we are currently processing a message which has called DestroyWindow.
    // The dispatchCleanup function clears the defaultProc value when it
    // processes WM_DESTROY.
    if (isEnabledForNotification() && pWindowData->defaultProc)
    {
      pWindowData->_observerData->notifyHandler->dispatchHandlerEvent(evt);
    }
  }

   // Clean-up before normal termination.
  if ( this->dispatchCleanup( evt, fNested ) )
  {
     bStop = true;
  }

  return bStop;
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IWindow::dispatchRemainingHandlers                                           |
|                                                                              |
| Dispatch the event to all of the remaining handlers in the list that do not  |
| process the event (ie. return false).                                        |
| This function is used as the handler dispatcher by IWindow::dispatch.  It    |
| can also be called by a handler which wishes to modify the event processing  |
| sequence for a particular message.                                           |
| NOTE: This function assumes that the event passed to it is either the same   |
|       event passed to the dispatch() function, or a derived event constructed|
|       from the event passed to the dispatch() function.                      |
------------------------------------------------------------------------------*/
bool IWindow::dispatchRemainingHandlers(IEvent& evt, bool callDefProc)
{
  IMODTRACE_ALL("Win::dispatchRemainingHandlers");

  //-----------------------------------------------------------
  // Dispatch event to the remaining handlers.
  //-----------------------------------------------------------
  bool bStop = false;
  IHandlerList* remainingHandlerList = evt.handlerList();

  //-----------------------------------------------------------
  // We use a pointer to the cursor supplied in the event to avoid copying
  // of cursor objects.  IWindow::dispatch insures that a different cursor
  // object is used for each nested level of dispatch.
  //-----------------------------------------------------------
  IHandlerList::Cursor* pCursor = (IHandlerList::Cursor*)evt.handlerCursor();

  if (remainingHandlerList &&
      remainingHandlerList->numberOfElements() && pCursor)
  {
    ITRACE_ALL(IString("Win=")+IString((unsigned long)this).d2x()+
               IString(" HWND=")+IString(this->hwnd).d2x());
    ITRACE_ALL(IString("HWND=") + IString(evt.handle().asUnsigned()).d2x()+
               IString(", Msg=") + IString(evt.eventId()).d2x()+
               IString(", MP1=") + IString((unsigned long)evt.parameter1()).d2x()+
               IString(", MP2=") + IString((unsigned long)evt.parameter2()).d2x());
    ITRACE_ALL(IString("Handler count=")+
               IString(remainingHandlerList->numberOfElements()));


    //-----------------------------------------------------------
    // The current cursor is stored pointing to the next handler
    // (if any) to dispatch.  Begin dispatching from there.
    //-----------------------------------------------------------
    while ( bStop == false && pCursor->isValid() )
    {
      IHandlerListObject& listObj(remainingHandlerList->elementAt(*pCursor));
      IHandler* phandler = listObj.fHandler;

      // During handler dispatch, the cursor needs to point to the next
      // element to allow for calls to this routine from within the handler.
      pCursor->setToNext();
      if ( listObj.fRemovePending )
      {
        // The handler is being removed, so do not dispatch to it.
        phandler = 0L;
      }
      if (phandler)
      {
        //------------------------------------------------------
        // Note: we have added a bit of trickery here since
        // folks sometimes delete handlers, but leave them in
        // the list. We need to have the handler destructor
        // remove them from the list, but in the interim we
        // will rely on the value of the isEnabled field to
        // try to detect the majority of these cases.  The
        // handler destructor sets this field to a large
        // positive value (as opposed to the bool true(1)
        // for enabled or the bool false (0) for disabled.
        //------------------------------------------------------
        if (phandler->isEnabled()==true)
        {
          ITRACE_ALL(IString("Handler is: ")+
                    IString((unsigned long)phandler).d2x());

          //------------------------------------------------------
          // Store the current cursor postion in the event.  This
          // is stored for use by dispatchRemainingHandlers() so
          // it will know where to start from if it is called
          // again.
          //------------------------------------------------------
          evt.setHandlerCursor(pCursor);

          //------------------------------------------------------
          // This is where we try to catch exceptions at the
          // top of the dispatch chain.
          //------------------------------------------------------
          try
          {
            bStop = phandler->dispatchHandlerEvent(evt);
          }
          catch (IException& exc)
          {
            if (!handleException(exc, evt))
            {
              IRETHROW(exc);
            }
          }
        }
        else if (phandler->isEnabled())
        {
          IInvalidRequest exc(IMessageText(
                              IC_DISPATCHTO_INVALID_HANDLER),
                              IC_DISPATCHTO_INVALID_HANDLER,
                              IException::recoverable);

          if (!handleException(exc, evt))
          {
            ITHROW(exc);
          }
        }
        else
        {
          ITRACE_ALL("Handler is disabled");
        }
      } /* endif phandler */
    } /* end for */
  } /* endif */

  //------------------------------------------------------
  // If no handler returned true and we have been asked to call the
  // default procedure before exiting, do so.
  //------------------------------------------------------
  if (!bStop && callDefProc)
  {
#ifdef IC_WIN
    //------------------------------------------------------
    // Convert control message back to command before default proc.
    //------------------------------------------------------
    if (evt.eventId() == WM_CONTROL)
    {
      evt = IEvent( evt.handle(), WM_COMMAND, evt.parameter1(),
                    evt.parameter2() );
    }
#endif
    //------------------------------------------------------
    // Call defaultProcedure().  Note: We cannot just simply call
    // this->defaultProcedure().  This event could have been
    // generated via a WM_CONTROL, WM_CONTROLPOINTER, WM_DRAWITEM,
    // or WM_MEASUREITEM message and we need to call
    // defaultProcedure() on the owner of a control, not the
    // control itself.
    //------------------------------------------------------
    evt.window()->defaultProcedure(evt);
    bStop = true;
  }

  return bStop;
}

/*------------------------------------------------------------------------------
| IWindow::dispatchCleanup                                                     |
|                                                                              |
| Perform cleanup needed by IWindow::dispatch, needed before exiting that      |
| function.  This function is called both during normal termination of         |
| IWindow::dispatch and abnormal termination (for example, as a result of an   |
| exception thrown from a handler).                                            |
------------------------------------------------------------------------------*/
bool IWindow::dispatchCleanup ( IEvent& event, bool nested )
{
  IMODTRACE_ALL( "Win::dispatchCleanup" );

  bool calledWinProc = false;

#ifdef IC_PMWIN
  // clean any regions that we may have created. We no longer need the
  // regions for paint events after all of the handlers have been called.
  if (pWindowData->fInvalidatedRegion != IRegionHandle() )
  {
#ifdef IC_PM
    // Avoid generating a message by calling IWindow::presSpace.
    // Doing so could cause an out-of-stack exception (e.g. as a result
    // of it calling the IBidiSettings ctor, which calls WinGetLangInfo,
    // which sends a WM_QUERYBIDIATTR message, which causes another call
    // to dispatchCleanup, ad infinitum).  The danger in not calling
    // IWindow::presSpace, however, is the window may have overridden
    // the function to return a graphic context associated with a
    // device other than the screen.  Mismatching device contexts in the
    // graphic contexts used to create and destroy the region will cause
    // GpiDestroyRegion to fail.
    IPresSpaceHandle
      fPresSpace( WinGetScreenPS( HWND_DESKTOP ) );
    bool rc = GpiDestroyRegion( fPresSpace,
                                pWindowData->fInvalidatedRegion );
#ifdef IC_DEVELOP
    if ( ! rc )
    {
       ERRORID
         errorId = WinGetLastError( IThread::current().anchorBlock() );
       if ( ERRORIDERROR( errorId ) == PMERR_REGION_IS_CLIP_REGION )
       {  // Need to deselect it as the clip region first, but since
          // we don't have the PS that uses it, don't worry about
          // this error.  For the standard IPaintEvent case, we are
          // probably handling a message generated during processing
          // of the WM_PAINT, and the IPaintEvent dtor will eventually
          // do clean up of the region.
       }
    }
#endif // IC_DEVELOP
    this->releasePresSpace(fPresSpace);
#endif // IC_PM
#ifdef IC_WIN
    DeleteObject( pWindowData->fInvalidatedRegion );
#endif
    pWindowData->fInvalidatedRegion = IRegionHandle();
  }
#endif // IC_PMWIN
  //---------------------------------------------------------
  // If destroy is seen we want to:
  //  1) call cleanUp to remove handlers and such
  //  2) set the "needsDelete" state if isAutoDeleteObject
  //  3) call the default window procedure so that children
  //     get deleted as well.
  //---------------------------------------------------------
  if ( event.eventId() == WM_DESTROY )
  {
#ifdef IC_PMWIN
     IWinProc* pwinProc = this->pWindowData->defaultProc;
     IMODTRACE_ALL( "Win::dispatchCleanup(WM_DESTROY)" );
     ITRACE_ALL( IString( "Handle: ") + IString( this->hwnd ).d2x() );

     // Remove the ICLUI window procedure, because it seems there is a
     // slight delay between receiving this message and when the GUI
     // window is actually destroyed.  During the wait, we don't want
     // any handlers getting called, since they would probably trap
     // because event.window() will return 0.
     if ( pwinProc != 0  &&
          pwinProc != _pfnwpICWinProc &&
          pwinProc != _pfnwpICWinProc2 )
     {
        ITRACE_ALL( "Resetting winproc" );
#ifdef IC_WIN
        long
#endif
#ifdef IC_PM
        PFNWP
#endif //IC_PM
           pfnwpDefault = ISUBCLASSWINDOW( this->hwnd, pwinProc );
        if ( pfnwpDefault == 0 )
        {
           ITRACE_ALL( "Error unsubclassing _pfnwpICWinProc" );
        }

        this->pWindowData->defaultProc = 0;
     }  // endif reset winproc
#endif //IC_PMWIN

     // Remove ourselves from the list.
     this->cleanUp();

     // Delete this pointer if client set autoDeleteObject.
     if ( ! this->deleteIsInProcess() )
     {
        if ( this->isAutoDeleteObject() )
        {
           this->setDeleteInProcess();
           this->pWindowData->state |= needsDelete;
        }  // if autoDelete
     }  // if not delete in process

#ifdef IC_PMWIN
     if ( pwinProc )
     {
        void* result = (void*)
#ifdef IC_WIN
 #ifdef IC_WIN_STRICT
          CallWindowProc( (WNDPROC) pwinProc,
 #else
          CallWindowProc( (FARPROC) pwinProc,
 #endif
#endif //IC_WIN
#ifdef IC_PM
          pwinProc(
#endif //IC_PM
                          event.handle(), event.eventId(),
                          event.parameter1(), event.parameter2() );

        event.setResult( result );
        calledWinProc = true;
     }
#endif //IC_PMWIN

#ifdef IC_MOTIF
     calledWinProc = true;
#endif //IC_MOTIF

  } // endif WM_DESTROY

  //---------------------------------------------------------
  // Remove any handlers that are "pending," because they
  // could not safely be removed during message dispatch.
  //---------------------------------------------------------
  if ( !nested  &&  this->pWindowData->fHandlerRemovePending )
  {
     IGUIResourceLock windowLock( IWindowList::libraryKey() );
     IHandlerList::Cursor cursor( *this->pWindowData->handlerList );
     cursor.setToFirst();
     // Loop until we manage to read the end of the list.
     while ( cursor.isValid() )
     {
       if ( this->pWindowData->handlerList->elementAt( cursor ).fRemovePending )
       {
          // Ok, we want to remove this handler.
          this->pWindowData->handlerList->removeAt( cursor );
          // Since our cursor is now in limbo, reset it to the beginning
          // of the collection and start searching for more handlers to
          // be removed.
          cursor.setToFirst();
       }
       else
       {
          // We do not want to remove this handler, so just move to
          // the next handler in the list.
          cursor.setToNext();
       }
     }
     // All "pending" handlers should now be removed.
     this->pWindowData->fHandlerRemovePending = false;
  }

  //---------------------------------------------------------
  // If we have rolled back up through any nested calling,
  // and object deletion is necessary because a WM_DESTROY
  // was seen with AutoDelete=true, delete the object.
  //---------------------------------------------------------
  if ( !nested )
  {
     this->pWindowData->state &= (unsigned long)~dispatchInProcess;
     if ( this->pWindowData->state & needsDelete )
     {
        ITRACE_ALL( IString( "Delete this: " ) + IString( this->hwnd ).d2x() );
        this->pWindowData->state &= (unsigned long)~needsDelete;
        this->setAutoDeleteObject( false );
        delete this;
     }  // if needs delete
  }  // if not nested

  return calledWinProc;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| _pfnwpICWinProc2                                                             |
| This window procedure simply calls the standard IOC window procedure.        |
| It is used for windows which have an IWindow object for them but do          |
| not use the fastWindowWithHandle optimization.  The optimization uses        |
| the window procedure address to determine if it is enabled for a window.     |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
void* __stdcall
  _pfnwpICWinProc2( HWND hwnd,
                    unsigned long ulMsg,
                    void* mp1, void* mp2 )
#endif
#ifdef IC_PM
void* _System
  _pfnwpICWinProc2( INativeWindowHandle hwnd,
                    unsigned long ulMsg,
                    void* mp1, void* mp2 )
#endif
{
   return _pfnwpICWinProc( hwnd, ulMsg, mp1, mp2 );
}
#endif


/*------------------------------------------------------------------------------
| _pfnwpICWinProc                                                              |
|                                                                              |
| Common window procedure used in ICLUI.                                       |
|                                                                              |
| The purpose of this routine is to identify the IWindow dispatcher to be      |
| used to process a message. For certain messages (WM_CONTROL, WM_DRAWITEM,    |
| WM_MEASUREITEM and WM_NOTIFY), an attempt is made to identify the control    |
| that generated the message sent to its owner, and route the message back     |
| to the control.  If the control can't be found or chooses not to process     |
| the message, it is then routed to the owner (the normal system behavior).    |
| WM_NOTIFY is a new Win32 message that we must handle for the new common      |
| controls we support.                                                         |
|                                                                              |
| Attempts were made to optimize the window look up done by windowWithHandle   |
| by caching the last recipient of a message so that it doesn't need to be     |
| rediscovered.  The overhead of managing the cache offset the gain of         |
| avoiding lookups, and no measurable difference in performance was found.     |
------------------------------------------------------------------------------*/
#ifdef IC_WIN
void* __stdcall _pfnwpICWinProc(
                              HWND  hwnd,
                              unsigned long ulMsg,
                              void* mp1,
                              void* mp2)
#endif
#ifdef IC_MOTIFPM
void* _System _pfnwpICWinProc(
                              unsigned long hwnd,
                              unsigned long ulMsg,
                              void* mp1,
                              void* mp2)
#endif
{
  IMODTRACE_ALL("_pfnwpICWinProc");
#ifdef IC_PMWIN

#ifdef IC_PERF
  // Write the name of the message we are processing to the event log
  IWindowPrivateData::perfEventTrace( ulMsg );
#endif

  unsigned long   controlID(0);
  bool            controlNotify(false);
  HWND            hwndCtl;
  //-----------------------------------------------------------------
  // Message type specific processing.  Handle all message specific
  // processing that must occur before the event is dispatched.
  //-----------------------------------------------------------------
  switch (ulMsg)
  {
#ifdef IC_WIN
    //---------------------------------------------------------
    // Convert notification command messages in Windows to control
    // events.  In Windows,  control notification
    // messages are combined with WM_COMMAND messages.  In our
    // code, we redefine WM_CONTROL to be WM_COMMAND.  To ensure
    // that we only route the control notification messages on,
    // we check the control hwnd stored in lParam.  If not 0,
    // then it's a notification message.
    //---------------------------------------------------------
    case    IC_UM_COMMAND:
        ulMsg = WM_COMMAND;
       // Intentional fall through to next case (WM_COMMAND)
    case    WM_COMMAND:
        if (mp2 != 0)
        {
            ulMsg = WM_CONTROL;
            controlID = (unsigned long)mp1 & 0x0000ffff;
            hwndCtl = IWindow::handleWithParent( controlID, hwnd );
            controlNotify = true;
        }
        break;

    case    IC_UM_SYSCOMMAND:
        ulMsg = WM_SYSCOMMAND;
        break;
#endif //IC_WIN

    //---------------------------------------------------------
    // Identify control notification messages.
    // These control notification messages contain the id of
    // of the control in the low half of wParam.
    // Special case for Windows WM_COMMAND handled in WM_COMMAND
    // case above.
    //---------------------------------------------------------
    case             WM_CONTROL :
    case             WM_DRAWITEM :
    case             WM_MEASUREITEM :
#ifdef IC_WIN
    case             WM_NOTIFY :
#endif
#ifdef IC_PM
    case             WM_CONTROLPOINTER :
    case             WM_VSCROLL :
    case             WM_HSCROLL :
#endif
        controlID = (unsigned long)mp1 & 0x0000ffff;
        hwndCtl = IWindow::handleWithParent( controlID, hwnd );
        controlNotify = true;
        break;

#ifdef IC_WIN
    //---------------------------------------------------------
    // Identify control notification messages.
    // These control notification messages contain the handle
    // of the control in lParam.
    //---------------------------------------------------------
    case             WM_CTLCOLOREDIT :
    case             WM_CTLCOLORSTATIC :
    case             WM_CTLCOLORLISTBOX :
    case             WM_CTLCOLORSCROLLBAR :
    case             WM_CTLCOLORBTN :
    case             WM_VSCROLL :
    case             WM_HSCROLL :
        controlID = IIDOF( (HWND) mp2 );
        hwndCtl = (HWND) mp2;
        controlNotify = true;
        break;
#endif

  }   // switch

  //---------------------------------------------------------
  // Construct an IEvent from the system event data.
  //---------------------------------------------------------
  IEvent evt( IWindowHandle(hwnd),
              ulMsg,
              IEventParameter1(mp1),
              IEventParameter2(mp2));
  IWindow* pwin(0);

  if (controlNotify)
  {
      //---------------------------------------------------------
      // Route control notification to the control first.
      // If no action taken or not a window, message is routed to
      // the owner.
      //---------------------------------------------------------
      IWindow* pwinOwner = IWindow::windowWithHandle(hwnd,false);
      if (hwndCtl)
      {
          pwin = IWindow::windowWithHandle(hwndCtl,false);
#ifdef IC_WIN
          if (pwin)
          {
              //-----------------------------------------------------------
              // A window created with the WS_CHILD style does not have
              // an explicit owner; it is implicitly owned by its parent.
              // Therefore, we must check to see if an owner was identified
              // in the control's constructor, and if so, use it for event
              // dispatching, since the window we are using as the owner is
              // actually the parent.  This works fine if the parent and
              // owner of the control is the same window, but fails if they
              // are different.  We must handle the sceanrio of a different
              // parent and owner here to prevent porting problems, in order
              // to simulate the behavior that occurs in PM.
              //-----------------------------------------------------------
              if ( ( ISTYLEOF( pwin->handle() ) & WS_CHILD ) )
              {
                  IWindow* pwinRealOwner =
                      IWindow::windowWithHandle(pwin->pWindowData->fhwndOwner);
                  if (pwinRealOwner)
                  {
                     pwinOwner = pwinRealOwner;
                  }
              }
          }
#endif
      }
      else
      {
          if ( pwinOwner )
             pwin = IWindow::windowWithOwner(controlID, pwinOwner, false);
      }

      //---------------------------------------------------------------
      // If we found a control, dispatch the message to it. If the
      // control does not process the message or we couldn't find
      // a control, then try to route it to the owner.
      //---------------------------------------------------------------
      evt.setDispatchingWindow( pwin );
      if ( pwin != 0 && ( pwin->dispatch(evt) ) )
      {
          return evt.result();
      }
      else
      {
          pwin = pwinOwner;
          evt.setDispatchingWindow(pwin);
          if ( (pwinOwner!=0) && (pwinOwner->dispatch(evt) ) )
              return evt.result();    // event handled ... return
      }
  }   // if controlNotify
  else
  {
      //---------------------------------------------------------
      // Route event to the window.
      //---------------------------------------------------------
      pwin = IWindow::windowWithHandle(hwnd,false);

      // Call the dispatcher with the message
      evt.setDispatchingWindow( pwin );
      if (pwin != 0 && (pwin->dispatch(evt) ) )
      {
#ifdef IC_WIN
        if ( ulMsg == WM_SETFONT )
        {
          // Now that the window has presumably stored the font,
          // notify the IWindow object that the change has occurred.
          pwin->setLayoutDistorted( IWindow::fontChanged, 0 );
        }
#endif
        // event handled ... return
        return evt.result();
      } // endif
  }   // not controlNotify


  ITRACE_ALL(IString("WinP pWindow=") + IString((unsigned long)pwin).d2x());

  //-----------------------------------------------------------------
  // Message type specific processing.  Handle all message specific
  // processing that must occur after the event is dispatched to
  // our handlers but before it is passed to the default procedure
  //-----------------------------------------------------------------
#ifdef IC_WIN
  switch (ulMsg)
  {
      //-----------------------------------------------------------------
      // Convert control message back to command before default proc.
      //-----------------------------------------------------------------
      case    WM_CONTROL:
          evt = IEvent( evt.handle(),
                        WM_COMMAND,
                        evt.parameter1(),
                        evt.parameter2() );
          break;
      //-----------------------------------------------------------------
      // If it is one of the generated WM_SYSCOMMAND messages from
      // IFrameHandler::closed, eat it.  The default procedure causes
      // immediate destruction of the window if it sees this message.
      // This can cause unexpected behavior.
      //-----------------------------------------------------------------
      case    WM_SYSCOMMAND:
          if ( evt.parameter1().asUnsignedLong() ==
               IEventData( SC_CLOSE, 0x8000 | CMDSRC_OTHER ).asUnsignedLong() )
              return evt.result();
          break;
  }   // switch
#endif

  //-----------------------------------------------------------------
  // Route event to the default procedure
  //-----------------------------------------------------------------
  if (pwin != 0)
  {
    pwin->defaultProcedure(evt);

#ifdef IC_WIN
    //-----------------------------------------------------------------
    // Implement message specific IOC functionality which must be
    // processed after the default procedure.
    //-----------------------------------------------------------------
    switch (ulMsg)
    {
      //
      // We implement WM_QUERYFOCUSCHAIN partially as needed by the
      // library.  We handle it after the default proc, since the frame
      // window handler handles the message.
      case  WM_QUERYFOCUSCHAIN:
      {
        if (!evt.result().asUnsignedLong())
        {
          unsigned long fsCmd = LOWORD( (unsigned long)mp1 );
          switch (fsCmd)
          {
            case QFC_NEXTINCHAIN  :
              evt.setResult( IEventResult( hwnd ) );
              break;
            case QFC_PARTOFCHAIN  :
              if ( hwnd == (HWND)mp2 )
                evt.setResult( IEventResult(1) );
              break;
              //  Handled in frame handler
              //     case QFC_FRAME :
              //  These are not supported and not used by the Class Library
              //       case QFC_ACTIVE       :
              //       case QFC_SELECTACTIVE :
              default:
                break;
          }

          // If not handled yet, send to parent.
          if (!evt.result().asUnsignedLong())
          {
            IWindowHandle hwndParent = IPARENTOF(hwnd);
            if (hwndParent)
              evt.setResult( hwndParent.sendEvent( ulMsg, mp1, mp2 ) );
          }
        }  // switch
      }  // end WM_QUERYFOCUSCHAIN
      break;

      //
      // We implement WM_MATCHMNEMONIC to allow canvas and frame navigation.
      case  WM_MATCHMNEMONIC:
      {
        //
        // only child controls need to do anything
        evt.setResult( (bool)IWindowPrivateData::matchMnemonicHwnd(
                                           LOWORD( (unsigned long)mp1 ),
                                           hwnd ) );
      }
      break;

      case WM_SETFONT:
      {
        // Now that the window has stored the font, notify the
        // IWindow object that the change has occurred.
        pwin->setLayoutDistorted( IWindow::fontChanged, 0 );
      }
      break;

      default:
      {
        // In Windows, we need to route certain events to the owner if
        // they are not processed by the default procedure.
        // A check to determine if the window still exists is required
        // because the action of the default procedure may have
        // destroyed the window.
        ITRACE_ALL(
                IString("Not processed  HWND=") + IString((unsigned long)hwnd).d2x()+
                IString(", Msg=") + IString(ulMsg).d2x()+
                IString(", MP1=") + IString((unsigned long)mp1).d2x()+
                IString(", MP2=") + IString((unsigned long)mp2).d2x()+
                IString(" Result=") + IString(evt.result().asUnsignedLong() ) );
        // The control handle does not change as the event goes up the owner
        // chain.
        evt.setControlHandle( hwnd );

        IWindow* pwinOwner = pwin;
        // Use passEventToOwner to find out if this event should go up the
        // owner chain.  At this point pwinOwner is the current window.
        while (pwinOwner && pwinOwner->passEventToOwner( evt ) )
        {
           pwinOwner = pwinOwner->owner();
           if (!pwinOwner || (pwinOwner == IWindow::desktopWindow()) )
              pwinOwner = 0;
           else if (!evt.result().asUnsignedLong())
           {
              ITRACE_ALL(
                  IString("To Owner    HWND=") +
                  IString(pwinOwner->handle().asUnsigned()).d2x()+
                  IString(", Msg=") + IString(ulMsg).d2x()+
                  IString(", MP1=") + IString((unsigned long)mp1).d2x()+
                  IString(", MP2=") + IString((unsigned long)mp2).d2x()+
                  IString(" Result=") + IString(evt.result().asUnsignedLong() ) );

              // The points for the mouse events need to be mapped
              // relative to the window the event is being dispatched
              // to.
              if (ulMsg >= WM_MOUSEFIRST && ulMsg <= WM_MOUSELAST)
              {
                 POINT mousePoint;
                 mousePoint.x = evt.parameter2().number1();
                 mousePoint.y = evt.parameter2().number2();

                 IMAPWINDOWPOINTS( evt.handle(),
                                   pwinOwner->handle(), &mousePoint, 1 );

                 evt = IEvent( evt.handle(),
                               evt.eventId(),
                               evt.parameter1(),
                               IEventParameter2( (short)mousePoint.x,
                                                 (short)mousePoint.y ));
              }  // if mouse message

              // Dispatch to owner window.
              evt.setDispatchingWindow(pwinOwner);
              evt.setHandle(pwinOwner->handle());
              if ( pwinOwner->dispatch(evt) )
              {
                 return evt.result();       // Handled, get out.
              }
           }  // if not processed
        }   // while
        break;
      }
    }      // switch
#endif
    // return the result
    ITRACE_ALL(IString("Not processed ... returning ") +
               IString( evt.result().asUnsignedLong() ).d2x()  );
    return evt.result();
  }
  else
  {
    // No window found so call the default window procedure.
#ifdef IC_WIN
    return (void*)(IDEFWINDOWPROC(hwnd, (unsigned)ulMsg, (unsigned)mp1, (long)mp2));
#else
    return IDEFWINDOWPROC(hwnd, ulMsg, mp1, mp2);
#endif
  } // Else no window found.
#endif // IC_PMWIN
#ifdef IC_MOTIF
  return 0;
#endif
} /* end win proc */


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::convertToGUIStyle                                                   |
|                                                                              |
| Returns base/extended style for the underlying GUI.                          |
------------------------------------------------------------------------------*/
unsigned long IWindow::convertToGUIStyle(const IBitFlag& guiStyle,
                                               bool bExtOnly) const
{
  unsigned long ulStyle = 0;
  const IWindow::Style
   &bitStyle = (const IWindow::Style&) guiStyle;

  if ( ! bExtOnly )
  {
     if ( bitStyle & IWindow::visible )
       ulStyle |= WS_VISIBLE;
     if ( bitStyle & IWindow::disabled     )
       ulStyle |= WS_DISABLED;
     if ( bitStyle & IWindow::clipChildren )
       ulStyle |= WS_CLIPCHILDREN;
     if ( bitStyle & IWindow::clipSiblings )
       ulStyle |= WS_CLIPSIBLINGS;
     if ( bitStyle & IWindow::clipToParent )
       ulStyle |= WS_PARENTCLIP;
     if ( bitStyle & IWindow::saveBits     )
       ulStyle |= WS_SAVEBITS;
     if ( bitStyle & IWindow::group        )
       ulStyle |= WS_GROUP;
     if ( bitStyle & IWindow::tabStop      )
       ulStyle |= WS_TABSTOP;
     if ( bitStyle & IWindow::synchPaint   )
       ulStyle |= WS_SYNCPAINT;

     // Check for IWindow bidi styles.
     // Note that this code really belongs in
     // IWindow::create(...,const IBitFlag&,...), but it is here
     // for now because not all derived classes call that version
     // of create.  Also these styles aren't base window styles,
     // but we will process them as such (bExtOnly==false) because
     // but not all controls pass the style from their ctor to this
     // function with bExtOnly set to true (e.g. spin button and
     // combo box).
     if ( bitStyle & IWindow::rightToLeft )
     {
        pWindowData->fWindowDirection =
                       IWindowPrivateData::kRightToLeft;
     }
     else if ( bitStyle & IWindow::leftToRight )
     {
        pWindowData->fWindowDirection =
                       IWindowPrivateData::kLeftToRight;
     }
     else
     {
        pWindowData->fWindowDirection =
                       IWindowPrivateData::kDefaultDirection;
     }
  }
  return ulStyle;
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::isValid                                                             |
|                                                                              |
| Does the IWindow represent a valid presentation system window?               |
------------------------------------------------------------------------------*/
bool IWindow::isValid ( ) const
{
#ifdef IC_PM
  return IQUERYANCHOR( this->hwnd ) ? true : false;
  // (This is faster than getting the current thread and using IISWINDOW.)
#endif
#ifdef IC_WIN
  return IISWINDOW( 1, this->hwnd ) ? true : false;
#endif
#ifndef IC_PMWIN
  return IISWINDOW( IThread::current().anchorBlock(), this->hwnd )
                                               ? true : false;
#endif
}
#endif

/*------------------------------------------------------------------------------
| IWindow::isFrameWindow                                                       |
|                                                                              |
| Is window a frame window.                                                    |
------------------------------------------------------------------------------*/
bool IWindow::isFrameWindow() const
{
  IWindow *localThis = (IWindow *) this;
  IFrameWindow *frameWindow =
    dynamic_cast< IFrameWindow *>(localThis);
  if (frameWindow )
    return true;
  else
  {
    // The rtti check could fail in the case of an IFrameWindow that is
    // wrappered using an IWindow. Try to see if the window is an
    // IFrameWindow the old way of checking the class name. This way does not
    // work for user defined dialogs.
#ifdef IC_WIN
    IWindowClassName className( handle() );
    // We check substring as we create a new frame window class for
    // each frame to implement certain styles.
    if ((className.asString().indexOf(WC_FRAME) == 1) ||
        (className == (const char*)WC_DIALOG ) )
      return true;
#endif
#ifdef IC_PM
    IWindowClassName className( handle() );
    if (className == WC_FRAME)
      return true;
#endif
#ifdef IC_MOTIF
    // don't call handle or handleForChildCreation unless the window is still
    // valid.
    if (isValid())
    {
      // last shot on Motif, look for the main window. We don't look for the
      // top level shell because that will fail for the VB.
      IWindowHandle hwnd = this->handleForChildCreation();
      if ( (hwnd != IWindowHandle() ) && !((Widget)hwnd)->core.being_destroyed &&
           XmIsMainWindow( XtParent( (Widget)hwnd )))
      {
        return true;
      }
    }
#endif
  }
  // not a frame window.
  return false;
}

/*------------------------------------------------------------------------------
| IWindow::id                                                                  |
|                                                                              |
| Get the object identity.                                                     |
------------------------------------------------------------------------------*/
unsigned long IWindow::id() const
{
  unsigned long ulId = IIDOF( this->handle() );
  // No exception required because handle() validates the window handle.

  return ulId;
}

/*------------------------------------------------------------------------------
| IWindow::setId                                                               |
|                                                                              |
| Set the object identifier                                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::setId( unsigned long ulId )
{
  ITRACE_MOTIF_NOP();

  ISETIDOF( this->handle(), ulId );
  // No exception required because handle() validates the window handle.

  return *this;
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::presSpace                                                           |
|                                                                              |
| Grab the window cache presentation space.                                    |
------------------------------------------------------------------------------*/
IPresSpaceHandle IWindow::presSpace() const
{
  // No exception required because handle() validates the window handle.

  IMODTRACE_ALL("Win::presSpace");
  // Note: Caller is responsible for releasing the PS.

#ifdef IC_WIN
  HDC hps =
#else
  HPS hps =
#endif
            IGETPS(handle());

  if (!hps)
     ITHROWGUIERROR("WinGetPS");

#ifdef IC_PMWIN
  if ( IBidiSettings::isBidiSupported() )
  {
    IPresSpaceHandle ps(hps, handle());
    IBidiSettings bidi(*this);
    bidi.apply(ps);
    return ps;
  }
  else
#endif
    return IPresSpaceHandle(hps, handle());
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::releasePresSpace                                                    |
|                                                                              |
| Release the window cache presentation space.                                 |
------------------------------------------------------------------------------*/
void IWindow::releasePresSpace(const IPresSpaceHandle& hps) const
{
   IMODTRACE_ALL("Win::releasePresSpace");

   // Need to verify that handle() call is NOT made in OS/2 (since not needed).
   if (!IRELEASEPS(handle(),hps) ) {
      ITHROWLIBRARYERROR(IC_RELEASEPSFAIL,
                         IBaseErrorInfo::invalidRequest,
                         IException::recoverable);
   } /* endif */
}
#endif


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::show                                                                |
|                                                                              |
| Make the window visible.                                                     |
------------------------------------------------------------------------------*/
IWindow& IWindow::show(bool showWindow)
{
#ifdef IC_WIN
//  Following removed since it appears to cause problems when show is
//  done on child controls (e.g. button).  Windows never sends WM_SHOWWINDOW
//  with this code in.  Its removal does not seem to cause trouble
//  elsewhere either.
//   // Make sure we enable updates.
//   if (bShow && !isVisible())
//      {
//      ITRACE_DEVELOP("Show - enabling updates");
//      this->enableUpdate( true );
//      }
#endif
  ISHOWWINDOW( handle(), showWindow );

#ifdef IC_PM
  // set focus to shown window
  if( showWindow && isFrameWindow())
  {
    setFocus();
  }
#endif // IC_PM

  // No exception required because handle() validates the window handle.
  return *this;
}
#endif

/*------------------------------------------------------------------------------
| IWindow::enableUpdate                                                        |
|                                                                              |
| Cause further updates to the window to be painted to the display.            |
------------------------------------------------------------------------------*/
IWindow& IWindow::enableUpdate(bool enableWindow)
{
  pWindowData->fUpdateEnabled = enableWindow;
  ITRACE_MOTIF_NOP();
  if(enableWindow)
    IENABLEWINDOWUPDATE(handle(), true);
  else
    IENABLEWINDOWUPDATE(handle(), false);

  // No exception required because handle() validates the window handle.

#ifdef IC_MOTIF
  // This member function has the documented side effect of showing a hidden
  // window on OS/2 and Windows so we will add that side effect here as well.
  if (enableWindow)
  {
    if ( isShowing() )
      refresh();
    else
      this->show();
  }
#endif

  // Note that multicell and set canvas no longer run layout if
  // update is disabled. Enabling update causes a WM_PAINT message
  // on OS/2, WM_SETREDRAW on Windows (for which we call
  // IWindow::refresh to generate a WM_PAINT in the ICanvas window
  // procedure, and an expose message on Motif. The canvas will
  // run layout at that point if it has a layout pending (its
  // layoutChanged flag has been set).

  return *this;
}

#ifdef IC_PM
/*------------------------------------------------------------------------------
| IWindow::isVisible                                                           |
------------------------------------------------------------------------------*/
bool IWindow::isVisible() const
{
   return IISWINDOWVISIBLE(handle());
   // No exception required because handle() validates the window handle.
}
#endif

#ifdef IC_WIN
/*------------------------------------------------------------------------------
| IWindow::isVisible                                                           |
------------------------------------------------------------------------------*/
bool IWindow::isVisible() const
{
  // now check all the windows up to the frame.
  long flStyle(0);

  for ( IWindow *win = (IWindow *) this; win; win=win->parent())
  {
    flStyle = GetWindowLong( win->handle(), GWL_STYLE) ;

    if (! (flStyle & WS_VISIBLE) )
      return false;
    if ( win->isFrameWindow() )
      break;
  }
  return true;
}
#endif


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::setFocus                                                            |
|                                                                              |
| Make the window the focus window.                                            |
------------------------------------------------------------------------------*/
IWindow& IWindow::setFocus()
{
#ifdef IC_WIN
   // If the window to set the focus to is not created the current thread
   // or the current focus window is in another thread, SetForegroundWindow
   // must be used to changed the focus.
   IWindowHandle     fg = GetForegroundWindow();
   unsigned long winTID = GetWindowThreadProcessId( this->handle(), 0);
   if ((winTID != GetCurrentThreadId()) ||
       (winTID != GetWindowThreadProcessId(fg, 0) ) )
     {
     SetForegroundWindow( this->handle() );
     }
   else
     {
     ISETFOCUS(HWND_DESKTOP, handle());
     }
#endif
#ifdef IC_PM
   ISETFOCUS(HWND_DESKTOP, handle());
#endif
   // No exception required because handle() validates the window handle.

   return *this;
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::hasFocus                                                            |
|                                                                              |
| Is the window the focus window?                                              |
------------------------------------------------------------------------------*/
bool IWindow::hasFocus() const
{
   HWND hwndFocus = IQUERYFOCUS(HWND_DESKTOP);
   // No exception required because HWND_DESKTOP is default parameter.

   return (hwndFocus == handle());
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::enable                                                              |
|                                                                              |
| Enable the object to accept input.                                           |
------------------------------------------------------------------------------*/
IWindow& IWindow::enable(bool enableWindow)
{
   //--------------------------------------------------------
   // Check if the window to be disabled currently has focus
   //--------------------------------------------------------
   bool bResetFocus(false);
   if ( !enableWindow && hasFocus() )
        bResetFocus = true;

   IENABLEWINDOW( handle(), enableWindow );
   // No exception required because handle() validates the window handle.

   //--------------------------------------------------------
   // Attempt to locate a sibling that can have focus
   //--------------------------------------------------------
   if ( bResetFocus )
   {
      if ( owner() && owner()->isValid() )
         owner()->setFocus();
      else if ( parent() && parent()->isValid() )
         parent()->setFocus();
   }


   return *this;
}
#endif // IC_PMWIN

/*-----------------------------------------------------------------------------|
| IWindow::isEnabled                                                           |
|                                                                              |
| Is the object enabled?                                                       |
------------------------------------------------------------------------------*/
bool IWindow::isEnabled() const
{
   return IISWINDOWENABLED(handle());
   // No exception required because handle() validates the window handle.
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::refresh                                                             |
|                                                                              |
| Refresh the window.  If RefreshType calls for an immediate update, call      |
| IUPDATEWINDOW to force the window to paint synchronously (i.e. painting is   |
| completed before exiting this function and returning to the caller.          |
| If type calls for painting the whole window (instead of just the invalidated |
| region), then call IINVALIDATERECT to add the whole window to the            |
| area to be updated on the next paint.                                        |
------------------------------------------------------------------------------*/
IWindow& IWindow::refresh( RefreshType type )
{
  IMODTRACE_ALL("Win::refresh");

  if (( type == IWindow::paintAll ) || ( type == IWindow::paintAllImmediate ))
  {
    IINVALIDATERECT( handle(), 0, true );
    ITRACE_ALL("Invalidate the whole window");
  }

  if (( type == IWindow::immediate ) || ( type == IWindow::paintAllImmediate ))
  {
    IUPDATEWINDOW(handle());
    ITRACE_ALL("Paint immediately");
  }
  return *this;
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::refresh                                                             |
|                                                                              |
| Redraw a specific window rect. If immediate update is true, call             |
| IUPDATEWINDOW to force the window to paint synchronously...ie painting is    |
| completed before exiting this function and returning to the caller.          |
------------------------------------------------------------------------------*/
IWindow& IWindow::refresh(const IRectangle& rectArea, bool immediate)
{
  IMODTRACE_ALL("Win::refresh");

  IRectangle nativeRect = ICoordinateSystem::convertToNative(
                             rectArea,
                             size() );
#ifdef IC_PM
  RECTL rectl;
  rectl.xLeft   = nativeRect.minX();
  rectl.yBottom = nativeRect.minY();
  rectl.xRight  = nativeRect.maxX();
  rectl.yTop    = nativeRect.maxY();
#else
  RECT rectl;
  rectl.left   = nativeRect.minX();
  rectl.top    = nativeRect.minY();
  rectl.right  = nativeRect.maxX();
  rectl.bottom = nativeRect.maxY();
#endif

  IINVALIDATERECT(handle(), &rectl, true);
  if (immediate)
  {
    IUPDATEWINDOW(handle());
  }
  return *this;
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::setParent                                                           |
|                                                                              |
| Change the window's parent                                                   |
------------------------------------------------------------------------------*/
IWindow& IWindow::setParent(const IWindow* newParent)
{
   IASSERTPARM(newParent != 0);
   if ( IPARENTOF(this->handle()) != newParent->handle())
      {
      ISETPARENT(handle(), newParent->handle(), TRUE);

#ifdef IC_WIN
      // Ensure WS_CHILD is set appropriately for new parent.
      unsigned long style = ISTYLEOF(handle());
      unsigned long winId = this->id();
      if (newParent == IWindow::desktopWindow() )
         {
         if (style & WS_CHILD)
            {
            ISETWINDOWSTYLE(handle(), (style & (unsigned long)~WS_CHILD) );
            this->setId( winId );  // Ensure id is preserved.
            }
         }
      else
         {
         if (!(style & WS_CHILD))
            {
            ISETWINDOWSTYLE(handle(), (style | (unsigned long)WS_CHILD) );
            this->setId( winId );  // Ensure id is preserved.
            }
         }
#endif

#ifdef IC_PM
      IWindowHandle hwndOwner(IOWNEROF(handle()));
#endif
#ifdef IC_WIN
      IWindow*   winOwner = owner();
      IWindowHandle hwndOwner(0);
      if (winOwner)
        hwndOwner = winOwner->handle();
#endif

      IWindowHandle hwndParent( newParent->handle() );

      this->checkForPrimaryWindow( hwndParent, hwndOwner );

  }
  return *this;

   // No exception required because handle() validates the window handle.
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IWindow::parent                                                              |
|                                                                              |
| Return the window's parent.                                                  |
| Note: This probably needs to be enhanced because to aggregate contols        |
------------------------------------------------------------------------------*/

IWindow* IWindow::parent() const
{
  IMODTRACE_ALL("Win::parent");

  // We need to walk up the parent handles until we find an IWindow*
  ITRACE_ALL(IString("desktopWindow handle = ") +
                 IString(desktopWindow()->handle().asUnsigned()));
  ITRACE_ALL(IString("objectWindow handle = ") +
                 IString(objectWindow()->handle().asUnsigned()));

  IWindowHandle hwndParent = handle();
  while ( true )
  {
    // No exception required because handle() validates the window handle.
    hwndParent = IPARENTOF(hwndParent);

    ITRACE_ALL(IString("hwndParent = ") +
                 IString(hwndParent.asUnsigned()));
    if (hwndParent != 0)
    {
      if (hwndParent == desktopWindow()->handle())
        return desktopWindow();
      else if (hwndParent == objectWindow()->handle())
        return objectWindow();
      else
      {
        IWindow *win = IWindow::windowWithHandle(hwndParent);
        // the following is a temporary check until addRelated is removed
        // on Motif. This is protection against aggregates.
        if ( win && (win != this) )
          return win;
      }
    } /* endif */
    else
    {
       if ( (this == desktopWindow()) || (this == objectWindow()) )
          return 0;
       else
          return desktopWindow();
    }
  }
}


/*------------------------------------------------------------------------------
| IWindow::owner                                                               |
|                                                                              |
| Return the window's owner.                                                   |
------------------------------------------------------------------------------*/
IWindow* IWindow::owner() const
{
   IMODTRACE_ALL("Win::owner");
#ifdef IC_PM
   IWindowHandle hwndOwner = IOWNEROF(handle());
#endif
#ifdef IC_MOTIFWIN
   IWindowHandle hwndOwner = pWindowData->fhwndOwner;
#endif
#ifdef IC_WIN
   if ( ( ISTYLEOF( handle() ) & WS_CHILD ) == 0 )
      {
      hwndOwner = IOWNEROF( handle() );
      }
#endif
   // No exception required because handle() validates the window handle.

   ITRACE_ALL(IString("hwndOwner = ") +
                  IString(hwndOwner.asUnsigned()));
   ITRACE_ALL(IString("desktopWindow handle = ") +
                  IString(desktopWindow()->handle().asUnsigned()));
   ITRACE_ALL(IString("objectWindow handle = ") +
                  IString(objectWindow()->handle().asUnsigned()));

   if (hwndOwner == desktopWindow()->handle())
      return desktopWindow();
   else if (hwndOwner == objectWindow()->handle())
      return objectWindow();
   else if (hwndOwner != 0)
      return IWindow::windowWithHandle(hwndOwner);

   return 0;
}

/*------------------------------------------------------------------------------
| IWindow::style                                                               |
|                                                                              |
| Return unsigned long style flag.                                             |
------------------------------------------------------------------------------*/
unsigned long IWindow::style() const
{
#ifdef IC_PMWIN
  return (ISTYLEOF(handle()));
#endif
#ifdef IC_MOTIF
  return this->pWindowData->ulStyle;
#endif
}

/*------------------------------------------------------------------------------
| IWindow::extendedStyle                                                       |
|                                                                              |
| Return unsigned long extended GUI style flag.                                |
------------------------------------------------------------------------------*/
unsigned long IWindow::extendedStyle() const
{
  return ( this->pWindowData->ulExtGUIStyle );
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::setStyle                                                            |
------------------------------------------------------------------------------*/
IWindow& IWindow::setStyle(unsigned long flStyle)
{
   ISETWINDOWSTYLE(handle(), flStyle) ;
   // No exception required because handle() validates the window handle.
   return *this;
}
#endif

/*------------------------------------------------------------------------------
| IWindow::setExtendedStyle                                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::setExtendedStyle(unsigned long flExtStyle)
{
   this->pWindowData->ulExtGUIStyle = flExtStyle;
   return *this;
}

/*------------------------------------------------------------------------------
| IWindow::startHandlingEventsFor                                              |
|                                                                              |
| This function subclasses the PM window procedure to                          |
| begin dispatch events.                                                       |
| NOTE: in Motif, this method must be called before IWindow::setOwner(),       |
| since setOwner() requires a widget handle to work properly.                  |
------------------------------------------------------------------------------*/
IWindow& IWindow::startHandlingEventsFor(const IWindowHandle& windowHandle)
{
   IMODTRACE_ALL("Win::startHandlingEventsFor");
   ITRACE_ALL(IString("Handle: ")+IString(windowHandle.asUnsigned()).d2x());

   // Ensure this handle nonzero.  The addToWindowSet function detects
   // the case where the handle is already in the window list collection.
   IASSERTPARM(windowHandle!=0);

   IWindow::addToWindowSet( this, windowHandle );

#ifdef IC_MOTIF
  // Until this method is called we had to save the owner in private data. Now
  // that we are added to the window set call setOwner.
  if (pWindowData->fhwndOwner)
    setOwner( windowWithHandle(pWindowData->fhwndOwner) );
#endif

#ifdef IC_WIN
   // Save the current size of the window.  Needed for resize handler.
   RECT   rect;
   IQUERYWINDOWRECT(windowHandle, &rect);
   pWindowData->oldWidth  = rect.right - rect.left;
   pWindowData->oldHeight = rect.bottom - rect.top;
#endif

   // See if we have a primary window.
   IWindowHandle hwndParent = IPARENTOF(windowHandle);
#ifdef IC_PMWIN
   IWindowHandle hwndOwner = IOWNEROF(windowHandle);
#endif
#ifdef IC_MOTIF
   IWindowHandle hwndOwner(pWindowData->fhwndOwner);
#endif
   this->checkForPrimaryWindow( hwndParent, hwndOwner );

#ifdef IC_MOTIF
  // if we used IWindow::create then look for these styles and call the
  // appropriate member functions to set the behavior. Again, we couldn't
  // call these methods during the create because the handle was not set.
  if ( pWindowData->motifState & IWindowPrivateData::usedIWindowCreate )
  {
    // Process the style flags. These states are saved from the call to create.
    // What if they don't call create, may need a solution for that.
    if ( pWindowData->motifState & IWindowPrivateData::disabled )
      disable();
    else
      enable();

    if( pWindowData->motifState & IWindowPrivateData::visible)
      show();
    else
      hide();

    if( pWindowData->ulStyle & tabStop.asUnsignedLong())
    {
    	enableTabStop();
    }
    else
    {
    	disableTabStop();
    }


    // Store away the initial size we got from the create call.
    moveSizeTo( IRectangle( pWindowData->windowPosition,
                            pWindowData->windowSize) );
  }
  else
  {
    // We can't assume that we are going to see a map notify so clear the bit now
    pWindowData->motifState &= ~IWindowPrivateData::realized;
    Position fX, fY;
    Dimension fWidth, fHeight, fBorder;
    XtVaGetValues( (Widget)windowHandle,
                   XmNx, &fX,
                   XmNy, &fY,
                   XmNwidth, &fWidth,
                   XmNheight, &fHeight,
                   XmNborderWidth, &fBorder,
                   NULL );
    // prime the position and size for wrappered controls.
    pWindowData->nativeWindowPosition = IPoint( fX, fY );
    pWindowData->windowSize = ISize( fWidth - 2*fBorder, fHeight - 2*fBorder );
  }

  // prime the window size for the window handle.
  pWindowData->oldX      = pWindowData->windowPosition.x();
  pWindowData->oldY      = pWindowData->windowPosition.y();
  pWindowData->oldWidth  = pWindowData->windowSize.width();
  pWindowData->oldHeight = pWindowData->windowSize.height();

  // Register all of the iwindow callbacks that are common to all controls.
  pWindowData->registerCallbacks( this );

  // Send message so flyover help works if child windows are added after
  // the flyover help handler has been attached.
  if (!this->isPrimaryWindow())
  {
     IWindow* notifyWin = IWindow::windowWithHandle( hwndOwner );
     if (!notifyWin)
        notifyWin = IWindow::windowWithHandle( hwndParent );
     if (notifyWin)
        notifyWin->sendEvent(IC_UM_FLY_PAINT, this, 0);
  }

#endif // IC_MOTIF

   // Ensure that the window's distorted flag is set.
   setLayoutDistorted(windowCreated | colorChanged | fontChanged, 0);


#ifdef IC_PMWIN
  // Install the address of the IWindow in the user word of the
  // window if the useFastHandleProc optimization is enabled.
  // Note: Not used in Motif because the client_data of callbacks is
  // used in a similar fashion.
  if ( pWindowData->state & useFastHandleProc )
     {
     // In PM, The File and font dialog use the word for "convenience" to
     // store a dialog specific structure.  This is inconvenient for this
     // design, but is not too much of a problem because these dialogs do not
     // use the IOC subclass procedure. Help instances also use the user word
     // to store a structure.
     // Therefore, we do not overwrite a non-0 value already in the user
     // window word.
     unsigned long oldUserData = IQUERYUSERDATA( windowHandle );
     if (oldUserData == 0)
        {
        ISETUSERDATA( windowHandle, this );
        }
     else
        {
        // Disable further use of the optimization for this window.
        pWindowData->state &= (unsigned long) ~useFastHandleProc;
        }
     }

   // Subclass the window.  Select the procedure to use based on
   // whether fastWindowWithHandle is enabled.
   IWinProc* pfnwpDefault;
   if ( pWindowData->state & useFastHandleProc )
      {
      pfnwpDefault = (IWinProc*)ISUBCLASSWINDOW(windowHandle,
                                                _pfnwpICWinProc);
      }
   else
      {
      pfnwpDefault = (IWinProc*)ISUBCLASSWINDOW(windowHandle,
                                                _pfnwpICWinProc2);
      }

   // Ensure we don't get ourself back--looping will result.
   IASSERTSTATE(pfnwpDefault &&
                (pfnwpDefault != _pfnwpICWinProc) &&
                (pfnwpDefault != _pfnwpICWinProc2) );

   pWindowData->defaultProc = pfnwpDefault;
#endif //IC_PMWIN

#ifdef IC_WIN
   IColor fBackgroundColor(IColor::kWindowBgnd);
   // set up default colors.
   // If the frame window is a dialog then we need to use dialog as background.
   IWindow *fParentWindow = IWindow::windowWithHandle( hwndParent );
   while (fParentWindow && !fParentWindow->isFrameWindow() )
   {
     fParentWindow = fParentWindow->parent();
   }
   if (fParentWindow)
   {
     IFrameWindow *frameWindow =
       dynamic_cast< IFrameWindow *>(fParentWindow);
     if (frameWindow && frameWindow->usesDialogBackground())
     {
       fBackgroundColor = IColor( IColor::kDialogBgnd);
     }
   }
   // set up default colors
   if ( IWindowClassName(handle()) == WC_SCROLLBAR )
   {
      fBackgroundColor = IGUIColor::kScrollBar;
   }
   // increment the brush use count.
   pWindowData->clrbackground = fBackgroundColor;
   HBRUSH hBr = IBrushManager::findBrush( pWindowData->clrbackground );
   IBrushManager::useBrush(hBr);
#endif // IC_WIN

#ifdef IC_MOTIFWIN
   // Propogate the font to any children for which the font was not
   // explicitly set.
   IWindow *ancestor = this->parent();
   while (ancestor && ancestor != IWindow::desktopWindow())
   {
      if (ancestor->pWindowData->state & fontWasSet)
      {
         propagationInProgress++;
         // Propogate parent's font to child
         // this->setFont(this->parent()->font());
         this->setFont(ancestor->font()); // 27912 C
         propagationInProgress--;
         break;
      }
      else
         ancestor = ancestor->parent();
   }
#endif

   return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setOwner                                                            |
|                                                                              |
| Change the window's owner                                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::setOwner(const IWindow* newOwner)
{
  IWindowHandle hwndOwner(0);
  if (newOwner)
    hwndOwner = newOwner->handle();

#ifdef IC_PM
  WinSetOwner( handle(), hwndOwner );
#endif // IC_PM

#ifdef IC_WIN
  if ( ( ISTYLEOF( handle() ) & WS_CHILD )  )
  {
    // Simulated ownership used for child controls
    pWindowData->fhwndOwner = hwndOwner;
  }
  else
  {
    // You cannot change the ownership of a window which really has
    // an owner known to Windows ... that is, an overlapped or popup
    // window.  We ignore the change.
    hwndOwner = IOWNEROF( handle() );
  }
#endif // IC_WIN

#ifdef IC_MOTIF
  pWindowData->fhwndOwner = hwndOwner;
#endif // IC_MOTIF

  IWindowHandle hwndParent = IPARENTOF(handle());

  this->checkForPrimaryWindow( hwndParent, hwndOwner );

  return *this;

  // no exception required b'cos handle() check for valid
  // window handle
}

/*------------------------------------------------------------------------------
| IWindow::addToWindowSet                                                      |
|                                                                              |
| Add a window to a threads collection of windows.                             |
------------------------------------------------------------------------------*/
void IWindow::addToWindowSet ( IWindow* window,
                               const IWindowHandle& windowHandle )
{
  IASSERTPARM(window!=0 && windowHandle.isValid());

  // Save the window handle.
  window->hwnd = windowHandle.asUnsigned();

#ifdef IC_PMWIN
  unsigned long
    threadId,
    processId;
  IQUERYWINDOWPROCESS( windowHandle, &processId, &threadId );
#endif

  {
    // Lock resources for update.
    IGUIResourceLock windowLock(IWindowList::libraryKey());
#ifdef IC_PMWIN
    IWindowList* pwinlist = IWindowList::listForThread( threadId );
#endif
#ifdef IC_MOTIF
    IWindowList* pwinlist = IWindowList::current();
#endif
    // Throw an exception if the window already is in the collection.
    // This indicates an attempt to create 2 IWindow objects for the same
    // windowHandle.  The locateOrAddElementWithKey function returns false
    // if the new element was added, true if it already existed.

    IASSERTSTATE(pwinlist->locateOrAddElementWithKey(window) == false);
    window->pWindowData->state |= addedToList;

#ifdef IC_MOTIF
    // Also add the IWindow to a list that can be easily searched
    // by IWindow* for IWindow::isWindowValid.
    IWindowStaticData::fgAllIWindowsSet->add( window );
#ifdef IC_DEVELOP
    ITRACE_DEVELOP( "IWindow::addToWindowSet -- total count = "
                      + IString( IWindowStaticData::fgAllIWindowsSet
                                                     ->numberOfElements() ) );
#endif
#endif // IC_MOTIF
  }

}

/*------------------------------------------------------------------------------
| IWindow::removeFromWindowSet                                                 |
|                                                                              |
| Remove a window from a threads collection of windows.                        |
------------------------------------------------------------------------------*/
void IWindow::removeFromWindowSet ( IWindow* window )
{
  IASSERTPARM(window!=0);

  if ( window->pWindowData->state & addedToList )
  {
  // In a window list.
#ifdef IC_WIN
    // free brush for background color.
    IBrushManager::freeBrush( window->pWindowData->clrbackground );
#endif
#ifdef IC_MOTIF
    window->pWindowData->unregisterCallbacks( window );
#endif
    // Lock resources for update.
#ifdef IC_PMWIN
    IGUIResourceLock lock( IWindowThreadData::libraryKey() );
#endif
#ifdef IC_MOTIF
    IGUIResourceLock lock( IWindowList::libraryKey() );
#endif
    IWindowList* pwinlist;
#ifdef IC_PMWIN
    if ( window->isValid() )
    {            // Window handle is valid.
      unsigned long
          threadId,
          processId;
      IQUERYWINDOWPROCESS( window->handle(), &processId, &threadId );
      pwinlist = IWindowList::listForThread( threadId );

      // Disable the useFastHandleProc optimization if present.
      window->reserveUserWindowWord( true );

    }
    else         // GUI window already destroyed.
    {            // Clean-up should have already been done.
       pwinlist = IWindowList::current();
    }
#endif //IC_PMWIN
#ifdef IC_MOTIF
    pwinlist = IWindowList::current();
#endif

    pwinlist->removeElementWithKey( window->hwnd );
    window->pWindowData->state &= (unsigned long)~addedToList;

#ifdef IC_MOTIF
    // Also remove the IWindow from a list that can be easily searched
    // by IWindow* for IWindow::isWindowValid.
    IWindowStaticData::fgAllIWindowsSet->remove( window );
#ifdef IC_DEVELOP
    ITRACE_DEVELOP( "IWindow::removeFromWindowSet -- total count = "
                      + IString( IWindowStaticData::fgAllIWindowsSet
                                                     ->numberOfElements() ) );
#endif

    window->pWindowData->motifState &= ~IWindowPrivateData::checkedValidity;
    window->pWindowData->motifState &= ~IWindowPrivateData::handleValid;
    window->hwnd = 0;           // since it's removed from the set, remove this reference
#endif // IC_MOTIF

  }   // if addedToList
}

/*------------------------------------------------------------------------------
| IWindow::isWindowValid                                                       |
|                                                                              |
| Searches the internal collections for the iwindow to ensure it is valid.     |
------------------------------------------------------------------------------*/
bool IWindow::isWindowValid ( const IWindow* window )
{
  // Lock resources for cross thread search.
  IGUIResourceLock lock( IWindowThreadData::libraryKey() );

#ifdef IC_PMWIN
  IWindow* pwin;
  IWindowList* pwinlist;
  IWindowThreadDataList* list = IWindowThreadData::list();
  if ( list )
  {
     IWindowThreadDataList::Cursor cursor( *list );
     for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
     {
        pwinlist = cursor.element()->windowList();
        IWindowList::Cursor wlcursor( *pwinlist );
        for ( wlcursor.setToFirst(); wlcursor.isValid(); wlcursor.setToNext() )
        {
           pwin = pwinlist->elementAt( wlcursor );
           if ( pwin == window )
           {
              return true;
           }
        } /* endfor */
     }
  }
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if ( IWindowStaticData::fgAllIWindowsSet->contains( window ) )
  {
     return true;
  }
#endif // IC_MOTIF
  return false;
}

/*------------------------------------------------------------------------------
| IAllAllocatedIWindows::IAllAllocatedIWindows                                 |
------------------------------------------------------------------------------*/
IAllAllocatedIWindows::IAllAllocatedIWindows ( )
{ }

/*------------------------------------------------------------------------------
| IAllAllocatedIWindows::~IAllAllocatedIWindows                                |
------------------------------------------------------------------------------*/
IAllAllocatedIWindows::~IAllAllocatedIWindows ( )
{ }

/*------------------------------------------------------------------------------
| IAllAllocatedIWindows::add                                                   |
|                                                                              |
| Add a window to the collection of all allocated (not yet destructed)         |
| IWindow objects. This differs from IWindowList and the AIX-only              |
| IWindowStaticData::fgAllIWindowsSet, both of which hold IWindow objects      |
| until the IWindow objects are either destructed or their operating system    |
| windows/widgets are destroyed. The collection                                |
| IWindowStaticData::fgAllAllocatedIWindowsSet, on the other hand, only cares  |
| about the lifetime of the IWindow object, not the window or widget it        |
| represents.                                                                  |
------------------------------------------------------------------------------*/
void IAllAllocatedIWindows::add ( const IWindow* window )
{
  IASSERTPARM( window != 0 );

  {
    // Lock resources for update. Use the same resource lock as
    // IWindowList.
    IGUIResourceLock
      lock( IWindowList::libraryKey() );

    // Throw an exception if the window already is in the collection.
    // This should never happen, since only the IWindow ctors should
    // be calling this function.
    IASSERTSTATE( IWindowStaticData::fgAllAllocatedIWindowsSet
                                      ->contains( window ) == false );

    // Add the IWindow to the collection.
    IWindowStaticData::fgAllAllocatedIWindowsSet->add( window );
  }
}

/*------------------------------------------------------------------------------
| IAllAllocatedIWindows::remove                                                |
|                                                                              |
| Remove a window from the collection of all allocated (not yet destructed)    |
| IWindow objects.                                                             |
------------------------------------------------------------------------------*/
bool IAllAllocatedIWindows::remove ( const IWindow* window )
{
  IASSERTPARM( window != 0 );

  bool removed = false;
  {
    // Lock resources for update. Use the same resource lock as
    // IWindowList.
    IGUIResourceLock
      lock( IWindowList::libraryKey() );

    removed =
      IWindowStaticData::fgAllAllocatedIWindowsSet->remove( window );
  }

  return removed;
}

/*------------------------------------------------------------------------------
| IAllAllocatedIWindows::isValid                                               |
|                                                                              |
| Search for an IWindow object in the collection of all allocated (not yet     |
| destructed) IWindow objects. This search should reflect if the object is     |
| still a valid C++ object (note that whether the window or widget that the    |
| object represents may not be valid, however).                                |
------------------------------------------------------------------------------*/
bool IAllAllocatedIWindows::isValid ( const IWindow* window )
{
  // Lock resources for cross-thread search.
  IGUIResourceLock
    lock( IWindowList::libraryKey() );

  return IWindowStaticData::fgAllAllocatedIWindowsSet->contains( window );
}

/*------------------------------------------------------------------------------
| IWindow::reserveUserWindowWord                                               |
|  Controls use of the USER DATA field of the window word by IOC.              |
|  This function sets the flag useFastHandleProc in the IWindow private        |
|  data state member.  The startHandlingEventsFor function checks this         |
|  flag when it subclasses the HWND.                                           |
|  Additionally, if the current IWindow has a valid HWND, the                  |
|  USER DATA field and window procedure of the window are inspected and        |
|  adjusted to reflect the requested state.  Note that requests to enable      |
|  the optimization are ignored if the USER DATA field is non 0 or             |
|  the window procedure is not the non-optimized IOC procedure.                |
------------------------------------------------------------------------------*/
IWindow& IWindow::reserveUserWindowWord( bool reserve )
{
#ifdef IC_PMWIN
   if (!reserve && IWindowPrivateData::fgFastWindowProcEnabled)
      {
      // Requesting to enable optimization.
      if (this->isValid())
         {
         // The window is valid.  If the user data word is 0,
         // store the IWindow* in there and set the window procedure
         // to be the "optimized" one.  Otherwise, ignore this
         // request.
         unsigned long oldUserData = IQUERYUSERDATA( this->handle() );
         void* winProc = IQUERYWINDOWPROCEDURE( this->handle() );
         if ((oldUserData == 0) && (winProc == _pfnwpICWinProc2))
            {
            this->pWindowData->state |= useFastHandleProc;
            // Store the IWindow* in the user window word and
            // set the optimized IOC window procedure
            ISETUSERDATA( this->handle(), this );
            ISUBCLASSWINDOW(this->handle(),  _pfnwpICWinProc);
            }
         else if (winProc != _pfnwpICWinProc)
            {
            // Could not apply the optimization and it is not already
            // in place.  Turn off flag.
            this->pWindowData->state &= (unsigned long) ~useFastHandleProc;
            }
         }
      else
         {
         // Window not valid.  Just set the flag for possible later
         // use.
         this->pWindowData->state |= useFastHandleProc;
         }
      }  // requesting to enable optimization.
   else
      {
      // Set the flag off.
      this->pWindowData->state &= (unsigned long) ~useFastHandleProc;
      if (this->isValid())
         {
         void* winProc = IQUERYWINDOWPROCEDURE( this->handle() );
         if (winProc == _pfnwpICWinProc)
            {
            // Set to use the non-optimized IOC window procedure and
            // clear out the window word.
            ISUBCLASSWINDOW(this->handle(),  _pfnwpICWinProc2);
            ISETUSERDATA( this->handle(), 0 );
            }
         }
      }  // requesting to disable optimization.
#endif //IC_PMWIN
   return *this;
}

/*------------------------------------------------------------------------------
| IWindow::isUserWindowWordReserved                                            |
------------------------------------------------------------------------------*/
bool IWindow::isUserWindowWordReserved( ) const
{
#ifdef IC_PMWIN
   bool result;
   if (this->isValid())
      {
      void* winProc = IQUERYWINDOWPROCEDURE( this->handle() );
      result = (winProc != _pfnwpICWinProc);
      }
   else
      {
      result = !(this->pWindowData->state & useFastHandleProc);
      }
   return result;
#endif
#ifdef IC_MOTIF
   return true;
#endif
}


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::create                                                              |
|                                                                              |
| Call the presentation system to create the window. This create takes care of |
| using the correct parent's handle for the creation of child controls.        |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::create( unsigned long         id,
                               const char*           text,
                               const IBitFlag&       style,
                               const char*           windowClass,
                               const IWindow*        parent,
                               const IWindow*        owner,
                               const IRectangle&     initRect,
                               const void*           ctlData,
                               const void*           presParams,
                               IWindow::SiblingOrder order )
{
  return this->create( id,
                       text,
                       convertToGUIStyle( style, false ),
                       windowClass,
                       parent->handleForChildCreation(),
                       owner->handle(),
                       initRect,
                       ctlData,
                       presParams,
                       order,
                       convertToGUIStyle( style, true) );
}

/*------------------------------------------------------------------------------
| IWindow::create                                                              |
|                                                                              |
| Call the presentation system to create the window.                           |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::create( unsigned long        id,
                               const char*          text,
                               unsigned long        style,
                               const char*          windowClass,
                               const IWindowHandle& parent,
                               const IWindowHandle& owner,
                               const IRectangle&    initRect,
                               const void*          ctlData,
                               const void*          presParams,
                               IWindow::SiblingOrder order,
                               unsigned long        extendedStyle)
{
  HWND behind = HWND_TOP;
  if (order == IWindow::behindSiblings)
    behind = HWND_BOTTOM;

  ITRACE_ALL( IString("create initRect=") + initRect.asString() );
  unsigned long width = initRect.width();
  unsigned long height = initRect.height();

  // Need to obtain the parent size inline here, since we have't created
  // the window yet to use the ICoordinateSystem functions.
#ifdef IC_WIN
  RECT parentRect;
  if (!parent)
     {
     GetClientRect( IWindow::desktopWindow()->handle(),
                    &parentRect );
     }
  else
     {
     GetClientRect(parent, &parentRect);
     }
  ISize parentSize = ISize(parentRect.right - parentRect.left,
                           parentRect.bottom - parentRect.top);
#endif
#ifdef   IC_PM
  RECTL parentRect;
  if (!parent)
     {
     WinQueryWindowRect( IWindow::desktopWindow()->handle(),
                         &parentRect );
     }
  else
     {
     WinQueryWindowRect(parent, &parentRect);
     }
  ISize parentSize = ISize(parentRect.xRight - parentRect.xLeft,
                           parentRect.yTop - parentRect.yBottom);
#endif   //IC_PM

  IPoint position =
     ICoordinateSystem::convertToNative( initRect,
                                         parentSize).minXMinY();
#ifdef IC_WIN
  // check for any pass thru special flags
  if ((initRect.minX() == CW_USEDEFAULT) &&
      (initRect.minY() == CW_USEDEFAULT) &&
      (initRect.width() == (0x7FFFFFFF)) &&
      (initRect.height() == (0x7FFFFFFF)))
     {
     width =  (unsigned long)CW_USEDEFAULT;
     height = (unsigned long)CW_USEDEFAULT;
     }

  // Provide bidi enablement here.  Here on Windows, we emulate the way
  // a window inherits bidi attributes on OS/2.  Note that derived classes
  // are responsible for passing control-specific bidi styles to this
  // function, using a similar check to determine whether the control
  // should be right-to-left or left-to-right (unfortunately, no single
  // function has access to the styles and parent window being used at
  // window creation time).
  if ( IBidiSettings::isBidiSupported() )
  {
     // IWindow bidi styles take precedence over inherited bidi
     // attributes.  Presumably, IWindow::convertToGUIStyle has
     // stored an IWindow bidi style in IWindowPrivateData.
     IBidiSettings
       bidiSettings = IBidiSettings::applicationDefaults();
     if ( pWindowData->fWindowDirection ==
                         IWindowPrivateData::kRightToLeft )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutRightToLeft )
         .setTextOrientation( IBidiSettings::textRightToLeft );
     }
     else if ( pWindowData->fWindowDirection ==
                              IWindowPrivateData::kLeftToRight )
     {
        bidiSettings
         .setWindowLayout( IBidiSettings::layoutLeftToRight )
         .setTextOrientation( IBidiSettings::textLeftToRight );
     }
     else if ( parent  &&
               parent != IWindow::desktopWindow()->handle() )
     {  // No bidi styles specified, so look for default bidi
        // attributes now.
        // A window inherits the bidi attributes of its parent
        // window, unless it is parented to the desktop window,
        // in which case it uses application-wide bidi settings.
        bidiSettings = IBidiSettings( parent );
     }

     // Add the appropriate bidi styles when creating the window.
     if ( bidiSettings.windowLayout() ==
                         IBidiSettings::layoutRightToLeft )
     {
        extendedStyle |= ( WS_EX_RIGHT | WS_EX_LEFTSCROLLBAR );
     }
     if ( bidiSettings.textOrientation() ==
                         IBidiSettings::textRightToLeft )
     {
        extendedStyle |= WS_EX_RTLREADING;
     }
  }

  // Store the owner information for PM msg routing simulation.  Child
  // windows can't be owned in base Windows.
  IWindowHandle realParent = parent;
  if ( style & WS_CHILD )
     {
     // Owner is simulated.
     pWindowData->fhwndOwner = owner;
     }
  else
     {
     // Owner is real.  The ICREATEWINDOW macro ignores the owner parameter,
     // but Windows interprets parent as owner if WS_CHILD is not set.
     // Note also that if the owner window has WS_CHILD set, Windows will
     // assign ownership to the top-level parent of the child, since a
     // child can't be an owner.
     pWindowData->fhwndOwner = 0;
     realParent = owner;
     }

  HINSTANCE hInst = (HINSTANCE)presParams;
  if (!hInst)
     hInst = GetModuleHandle(0);

  ITRACE_ALL( IString("ICREATEWINDOW style=") + IString(style).d2x() +
              IString(" parent=") + IString(realParent.asUnsigned()).d2x() +
              IString(" position=") + position.asString() +
              IString(" size=") + ISize(width, height).asString() +
              IString(" id=") + IString(id) );
  IWindowHandle
    hwnd = ICREATEWINDOW(
               realParent,
               windowClass,
               text,
               style,
               (int)position.x(),
               (int)position.y(),
               (int)width,
               (int)height,
               owner,
               behind,
               id,
               (void*)ctlData,
               extendedStyle,
               hInst );
#endif   //IC_WIN
#ifdef IC_PM
  // Check for IWindow bidi styles and convert these into
  // presentation parameters to take precedence over PM's built-in
  // inheritance of bidi attributes.  Other bidi attributes should
  // continue to be inherited.  Presumably, IWindow::convertToGUIStyle
  // has stored an IWindow bidi style in IWindowPrivateData.
  const PRESPARAMS
   *origPresParams = (const PRESPARAMS*) presParams;
  PRESPARAMS
   *augmentedPresParams = (PRESPARAMS*) origPresParams;
  if ( IBidiSettings::isBidiSupported()  &&
       ( pWindowData->fWindowDirection !=
                         IWindowPrivateData::kDefaultDirection ) )
  {
     // The following structure is the same as _PARAM in pmwin.h,
     // but the data value is not of unspecified length.
     struct BidiParam {
       unsigned long
         id,
         length,
         value;
     };

     // Set up window orientation and text orientation.
     BidiParam
       bidiPresParams[ 2 ] =
         { { PP_BDATTR_WND_ORIENTATION,
             sizeof( BidiParam::value ),
             BDA_WND_ORIENT_RTL },
           { PP_BDATTR_TEXT_ORIENTATION,
             sizeof( BidiParam::value ),
             BDA_TEXT_ORIENT_RTL } };
     if ( pWindowData->fWindowDirection == IWindowPrivateData::kLeftToRight )
     {
        bidiPresParams[ 0 ].value = BDA_WND_ORIENT_LTR;
        bidiPresParams[ 1 ].value = BDA_TEXT_ORIENT_LTR;
     }

     unsigned long
       bidiPresParamsSize = sizeof( bidiPresParams ),
       paramsSize = bidiPresParamsSize;
     if ( origPresParams )
     {  // Other presentation parameters ma have been passed into
        // this call too, so add them in now.
        paramsSize += origPresParams->cb;
     }
     augmentedPresParams =
       (PRESPARAMS*) new char[ sizeof( PRESPARAMS ) -
                               sizeof( PARAM ) +
                               paramsSize ];
     augmentedPresParams->cb = paramsSize;
     char
      *copyPtr = (char*) augmentedPresParams->aparam;
     if ( origPresParams )
     {
        memcpy( copyPtr,
                (const char*) origPresParams->aparam,
                (size_t) origPresParams->cb );
        copyPtr += origPresParams->cb;
     }
     memcpy( copyPtr, (char*) bidiPresParams, (size_t) bidiPresParamsSize );
  }

  IWindowHandle
    hwnd = ICREATEWINDOW(
               parent,
               windowClass,
               text,
               style,
               position.x(),
               position.y(),
               width,
               height,
               owner,
               behind,
               id,
               (void*)ctlData,
               (void*) augmentedPresParams,
               0 );

  if ( augmentedPresParams != origPresParams )
  {  // Bidi clean up.
     delete [] (char*) augmentedPresParams;
  }
#endif

  if ( hwnd == 0) { // Error: throw exception.
    ITHROWGUIERROR(IString("WinCreateWindow: Id=")+IString(id)+
           IString(" Class=")+IString((unsigned short)(unsigned long)windowClass));
  }

  // If fastWindowWithHandle is enabled. turn on the flag for this
  // IWindow to use the optimized window with handle.
  if (IWindowPrivateData::fgFastWindowProcEnabled)
     {
     pWindowData->state |= useFastHandleProc;
     }


  return hwnd;

}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IWindow::addHandler                                                          |
|                                                                              |
| Add a Handler to the top of the list.                                        |
------------------------------------------------------------------------------*/
IWindow& IWindow::addHandler(IHandler* pshNew)
{
   IMODTRACE_DEVELOP("Win::addHandler");
   IASSERTPARM(pshNew != 0);
   ITRACE_ALL(IString("Win is: ")+IString((unsigned long)this).d2x() +
              IString(" Handler is: ")+IString((unsigned long)pshNew).d2x());

   IGUIResourceLock windowLock(IWindowList::libraryKey());
   if (pWindowData->handlerList == 0)
      pWindowData->handlerList = new IHandlerList();

   bool
     found = false;

   // If handler is handling another window...
   if ( pshNew->numWindows || pWindowData->fHandlerRemovePending )
     {
     IHandlerList::Cursor cursor( *pWindowData->handlerList );
     // Examine all handlers for this window.
     for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
       {
       // If one of them is this handler, don't add it again.
       if ( pshNew == pWindowData->handlerList->elementAt(cursor).fHandler )
         {
         found = true;
         if ( pWindowData->handlerList->elementAt(cursor).fRemovePending )
           {
           pWindowData->handlerList->elementAt(cursor).fRemovePending = false;
           pshNew->numWindows++;
           }
         break;
         }
       }
     }

   if ( !found )
     {
     pWindowData->handlerList->addAsFirst(pshNew);
     pshNew->numWindows++;

     #ifdef IC_DEVELOP
     pWindowData->handlerList->totalHandlers++;
     unsigned long ulCount=pWindowData->handlerList->numberOfElements();
     if(ulCount>pWindowData->handlerList->maxHandlers)
        pWindowData->handlerList->maxHandlers = ulCount;
     #endif
     }

   return *this;
}

/*------------------------------------------------------------------------------
| IWindow::removeHandler                                                       |
------------------------------------------------------------------------------*/
IWindow& IWindow::removeHandler(IHandler* pshOld)
{
  IMODTRACE_DEVELOP("Win::removeHandler");

  ITRACE_ALL(IString("Win is: ")+IString((unsigned long)this).d2x() +
             IString(" Handler is: ")+IString((unsigned long)pshOld).d2x());

   if (pWindowData->handlerList != 0) {
      IGUIResourceLock windowLock(IWindowList::libraryKey());
      IHandlerList::Cursor cursor(*pWindowData->handlerList);
      unsigned long index = 1;
      for(cursor.setToFirst();
          cursor.isValid() && index <= pWindowData->handlerList->numberOfElements();
          cursor.setToNext(), index++) {
             if (pWindowData->handlerList->elementAt(cursor).fHandler == pshOld)
             {
                // If we are currently dispatching messages to this handler,
                // then we cannot safely delete it, so set the remove-pending
                // flag.  We will clean it up later.
                if ( pWindowData->state & dispatchInProcess )
                {
                  pWindowData->handlerList->elementAt(cursor).fRemovePending = true;
                  pWindowData->fHandlerRemovePending = true;
                }
                else
                {
                  // We are not dispatching, so remove the handler from the
                  // list.
                  pWindowData->handlerList->removeAt(cursor);
                }
                pshOld->numWindows--;
                break;
             } /* endif */
      }/* end for */
   } /* endif */
   return *this;
}

/*------------------------------------------------------------------------------
| IWindow::windowWithHandle                                                    |
|                                                                              |
| Search the internal collection for the IWindow with the passed handle.       |
------------------------------------------------------------------------------*/
IWindow* IWindow::windowWithHandle ( const IWindowHandle& wndh,
                                     bool allThreads )
{

    // Attempt to retrieve the IWindow pointer from the user data
    // window word of the control.  The use of the user data word in
    // this manner is indicated by the window procedure address.
    // If it is anything other than _pfnwpICWinProc, assume that the
    // window word is being used in another fashion and search the
    // collection to find the IWindow.
    // Note: Not used in Motif, because the client_data field of the
    // callback contains the IWindow*.
#ifdef IC_PMWIN
    #ifdef IC_DEVELOP
    static unsigned long hitCount = 0;
    #endif
    void* winProc = IQUERYWINDOWPROCEDURE( wndh );
    if (winProc == _pfnwpICWinProc)
    {
       #ifdef IC_DEVELOP
       hitCount++;
       #endif
       return (IWindow*) IQUERYUSERDATA( wndh );
    }
    #ifdef IC_ALL
    else
    {
       ITRACE_ALL(
           IString("IWindow::windowWithHandle - not in window word, hwnd=") +
           wndh.asString().d2x() +
           IString(" hitCount=") + IString(hitCount) );
       hitCount = 0;
    }
    #endif //IC_DEVELOP
#endif


  // If the use of the window word is disabled or we could not find the
  // IWindow pointer there, search the window list collection for
  // a key matching the given handle.
  unsigned long ulHandle = wndh.asUnsigned();
  if ( allThreads )
  {
    // Lock resources for cross thread search.
    IGUIResourceLock lock( IWindowThreadData::libraryKey() );
    IWindowThreadDataList* list = IWindowThreadData::list();
    if (list)
    {
      IWindowThreadDataList::Cursor cursor( *list );
      for (cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
      {
        IWindowList* pwinlist = cursor.element()->windowList();
        IWindowList::Cursor wlcursor( *pwinlist );
        if ( pwinlist->locateElementWithKey( ulHandle, wlcursor ) )
        {
          return pwinlist->elementAt( wlcursor );
        }
      }
    }
  }
  else
  {
    IWindowList* pwinlist = IWindowList::current();
    if (pwinlist->numberOfElements() != 0 )
    {
      IWindowList::Cursor cursor( *pwinlist );
      if ( pwinlist->locateElementWithKey( ulHandle, cursor ) )
      {
        return pwinlist->elementAt( cursor );
      }
    }
  }

  ITRACE_ALL( "IWindow::windowWithHandle - hwnd " +
                   wndh.asString().d2x()  + " not found" );
  return 0;
}

/*------------------------------------------------------------------------------
| IWindow::handleWithParent                                                    |
|                                                                              |
| Return the window handle with the passed id and parent.                      |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::handleWithParent( unsigned long ulId,
                                         const IWindowHandle& parent)
{
   IASSERTPARM(parent!=0);
   IWindowHandle hwnd = IWINDOWFROMID(parent, ulId);
   return hwnd;
}

/*------------------------------------------------------------------------------
| IWindow::handleWithPointerCaptured                                           |
|                                                                              |
| Return the window handle that currently has the mouse capture.               |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::handleWithPointerCaptured( )
{
  ITRACE_MOTIF_NOP();
  return IWindowHandle(IQUERYCAPTURE);
}

/*------------------------------------------------------------------------------
| IWindow::postEvent                                                           |
|                                                                              |
| Construct an IEvent from the arguments and post it to this window.           |
------------------------------------------------------------------------------*/
const IWindow& IWindow::postEvent ( EventType           eventType,
                                    const IEventParameter1 &parm1,
                                    const IEventParameter2 &parm2 ) const
{
  unsigned long eventId;
#ifdef IC_PMWIN
  IWindowHandle postTo=handle();
#endif
#ifdef IC_MOTIF
  IWindowHandle postTo=handle();
#endif
  switch (eventType) {
  case command:
     eventId = WM_COMMAND;
     break;
  case systemCommand:
     eventId = WM_SYSCOMMAND;
     break;
  case control:
#ifdef IC_WIN
     eventId = WM_COMMAND;
#endif
#ifdef IC_MOTIFPM
     eventId = WM_CONTROL;
#endif
     break;
  case help:
#ifdef IC_WIN
  {
     ITRACE_ALL("IWindow::postEvent(help) called...");
     eventId = IC_UM_CONTEXT_HELP;
     IFrameWindow *frame = ihelpwindowSearchChain(postTo,0);
     if (frame)
       postTo = frame->handle();
     ITRACE_ALL("IWindow::postTo="+IString((unsigned long)(HWND)postTo));
  }
#endif
#ifdef IC_MOTIFPM
     eventId = WM_HELP;
#endif
     break;
  case character:
#ifdef IC_PMWIN
     eventId = WM_CHAR;
#endif
#ifdef IC_MOTIF
     // if parameter 2 is not an x event for a key press or
     // release this will cause the keyboard handler to die.
     return *this;
#endif
     break;
  } /* endswitch */

  postTo.postEvent(eventId, parm1, parm2);
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::sendEvent                                                           |
|                                                                              |
| Construct an IEvent from the arguments and send it to this window.  Return   |
| the event result.                                                            |
------------------------------------------------------------------------------*/
IEventResult IWindow::sendEvent ( EventType          eventType,
                                  const IEventParameter1 &parm1,
                                  const IEventParameter2 &parm2 ) const
{
  unsigned long eventId;
  IWindowHandle sendTo=handle();
  switch (eventType) {
  case command:
     eventId = WM_COMMAND;
     break;
  case systemCommand:
     eventId = WM_SYSCOMMAND;
     break;
  case control:
#ifdef IC_WIN
     eventId = WM_COMMAND;
#endif
#ifdef IC_MOTIFPM
     eventId = WM_CONTROL;
#endif
     break;
  case help:
#ifdef IC_WIN
  {
     ITRACE_ALL("IWindow::sendEvent(help) called...");
     eventId = IC_UM_CONTEXT_HELP;
     IFrameWindow *frame = ihelpwindowSearchChain(sendTo,0);
     if (frame)
       sendTo = frame->handle();
  }
#endif
#ifdef IC_MOTIFPM
     eventId = WM_HELP;
#endif
     break;
  case character:
#ifdef IC_PMWIN
     eventId = WM_CHAR;
#endif
#ifdef IC_MOTIF
     // if parameter 2 is not an x event for a key press or
     // release this will cause the keyboard handler to die.
     return 0;
#endif
     break;
  } /* endswitch */

  return sendTo.sendEvent(eventId, parm1, parm2);
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::cleanUp                                                             |
|                                                                              |
| Remove the window from the window list.  If this is a primary window and     |
| there are no remaining primary windows in the window list, post a WM_QUIT    |
| to the message queue.                                                        |
------------------------------------------------------------------------------*/
IWindow& IWindow::cleanUp()
{
  IMODTRACE_ALL("Win::cleanUp");
  IWindow::removeFromWindowSet( this );

  // Find the window list for the window's thread.
  unsigned long threadId;
  if ( this->isValid() )
  {           // Window handle is valid.
     IHandle::Value processId;
     IQUERYWINDOWPROCESS( this->hwnd, &processId, &threadId );
  }
  else        // GUI window already destroyed.
  {           // Clean-up should have already been done.
     threadId = IThread::currentId();
  }
  IThread windowThread( threadId );
  IWindowThreadData* data = IWindowThreadData::dataForThread(threadId);

  // See if the last bound window has been closed.
  if ( this->isBoundToMessageQueue() && data )
  {
     data->removeBoundWindow();
     // insure we don't treat this one as bound again.
     pWindowData->state &=
        (unsigned long) ~(primaryWindow | boundToMessageQueue);
     if ( windowThread.isProcessingMsgs()  &&  !data->hasBoundWindow() )
     {
        ITRACE_ALL("No primary windows, posting quit");
#ifdef IC_PM
        IMessageQueueHandle::postEvent( windowThread.messageQueue(),
                                        WM_QUIT );
#endif
#ifdef IC_WIN
        windowThread.stopProcessingMsgs();
#endif

     } // end !found
  } // end isBoundToMessageQueue

  return *this;
} // end cleanUp

#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IWindow::setLayoutDistorted                                                  |
|                                                                              |
| Virtual function used in canvas classes. If a window has been created,       |
| or its font has been changed, or its minimum size requirements have          |
| changed, notify its parent by calling setLayoutDistorted.                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::setLayoutDistorted( unsigned long layoutAttributeOn,
                                      unsigned long layoutAttributeOff )
{
  pWindowData->layoutChange &= ~layoutAttributeOff;  // Remove deleted flags.
  pWindowData->layoutChange |= layoutAttributeOn;  // Add in new flags.

  unsigned long ulParentFlags = 0;
  if (layoutAttributeOn & windowCreated)
  {                               // Notify parent window.
     ulParentFlags |= childWindowCreated;
  }
  if (layoutAttributeOn & windowDestroyed)
  {                               // Notify parent window.
     ulParentFlags |= childWindowDestroyed;
  }

  bool parentInitialized = false;
  IWindow* pwinParent = 0;
  if ((layoutAttributeOn & fontChanged)  &&
      !(layoutAttributeOn & windowCreated))
  {                     // Font change (allow parent to buffer these).
     pwinParent = this->parent();
     parentInitialized = true;
     if (pwinParent  &&
         pwinParent != desktopWindow()  &&
         pwinParent != objectWindow())
     {                 // Someone to pass change to.
#ifdef IC_PMWIN
        if (pwinParent == owner())
        {                    // WM_PRESPARAMCHANGED from owner window.
#ifdef IC_PM
           char achChildFont[16];      // Buffer size doesn't matter.
           unsigned long ulChildFontLen =   // Has own font?
              WinQueryPresParam(handle(), PP_FONTNAMESIZE, 0, 0,
                                sizeof(achChildFont), &achChildFont,
                                QPF_NOINHERIT);
           if (ulChildFontLen == 0)    // No font presentation parameter.
#else
           if ( ! ( pWindowData->state & fontWasSet ) )
#endif
           {            // Font must have been changed further up chain.
              ulParentFlags |= fontPropogated;
           }
        }
#endif // IC_PMWIN
     }                                 // End have a good parent.
     pWindowData->layoutChange &= (unsigned long)~fontPropogated;
                         // Done waiting for font change to bubble up.
  }
  if (layoutAttributeOn & minimumSizeChanged)
  {                               // Notify parent canvas.
     // If a minimum size has explicity been set, do not tell the
     // parent that a child minimum size changed
     if ( pWindowData->fSetMinSizeInProgress ||
       (( pWindowData->minimumSize.width()  == -1 ) &&
        ( pWindowData->minimumSize.height() == -1 )))
     {
        ulParentFlags |= childMinimumSizeChanged;
     }
  }

  /*****************************************************************/
  /* Send layout distortion notification to parent, if applicable. */
  /*****************************************************************/
  if (ulParentFlags)
  {                               // Notify parent now.
     if ( ! parentInitialized )
     {             // Get parent window now if not gotten already.
        pwinParent = this->parent();
     }

     if (pwinParent  &&
         pwinParent != desktopWindow()  &&
         pwinParent != objectWindow())
     {                            // Someone to pass change to.
        pwinParent->setLayoutDistorted(ulParentFlags, 0);
     }                            // End have a good parent.
  }                               // End have notify flags for parent.

  return *this;
}


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::mapPoint                                                            |
|                                                                              |
| Remap points from one coordinate space to another.                           |
------------------------------------------------------------------------------*/
IPoint IWindow::mapPoint ( const IPoint        &aPoint,
                           const IWindowHandle &from,
                           const IWindowHandle &to )
{
   POINTL pt = aPoint.asPOINTL();
   if ( ICoordinateSystem::isConversionNeeded() )
   {
#ifdef   IC_WIN
      RECT rect;
      if (from)
        GetWindowRect(from, &rect);
      else
        GetWindowRect(GetDesktopWindow(), &rect);
      ISize size(rect.right - rect.left, rect.bottom - rect.top );
#endif   //IC_WIN
#ifdef   IC_PM
      SWP swp;
      WinQueryWindowPos(from, &swp);
      ISize size(swp.cx,swp.cy);
#endif   //IC_PM
      pt = ICoordinateSystem::convertToNative( aPoint, size ).asPOINTL() ;
   }
   IMAPWINDOWPOINTS(from, to, &pt, 1);

#ifdef IC_WIN
   // Windows map points routine only maps using client rect of window
   // This works for child windows, but not for frame windows
   // Need to adjust rectangle so first check from window
   if (from)
   {
     IWindowClassName fromClass( from );
     if (fromClass.asString().indexOf(WC_FRAME) == 1)
     {
       // If a frame window, adjust window mapping by title, border and
       //  any menu area (if frame has a menu)
       unsigned long frameDeltaX = GetSystemMetrics( SM_CXFRAME );
       unsigned long frameDeltaY = GetSystemMetrics( SM_CYCAPTION ) +
                                           GetSystemMetrics( SM_CYFRAME );
       unsigned long ulStyle = ISTYLEOF( from );
       if ( !(ulStyle & WS_CHILD) && GetMenu( from ) )
         frameDeltaY += GetSystemMetrics( SM_CYMENU );
       pt.x = pt.x - frameDeltaX;
       pt.y = pt.y - frameDeltaY;
     }
     else
     {
       // If the handle mapping from has any border around it, then
       // the point needs to be adjusted to compensate.  This adjustment
       // is necessary becuase the point is mapped from the client area
       // of a window instead of the size of the entire window.
       unsigned long style;

       // If running of the NT newshell or 95 then check for the extended
       // styles that draw a 3d border.
       if (IPlatform::isNTNewShell() || IPlatform::isWin9x())
       {
         style = GetWindowLong( from, GWL_EXSTYLE );

         if (style & WS_EX_CLIENTEDGE)
         {
           pt.x -= 3;
           pt.y -= 3;
         }
         else if (style & WS_EX_STATICEDGE)
         {
           pt.x -= 1;
           pt.y -= 1;
         }
         else
         {
           style = GetWindowLong( from, GWL_STYLE );
           if (style & WS_BORDER)
           {
             pt.x -= 1;
             pt.y -= 1;
           }
         }
       }
       // Not running on NT newshell or 95.  Simply check
       // for the WS_BORDER style.
       else
       {
         style = GetWindowLong( from, GWL_STYLE );
         if (style & WS_BORDER)
         {
           pt.x -= 1;
           pt.y -= 1;
         }
       }
     }
   }

   // Now check to window to see if it was a frame window
   if (to)
   {
     IWindowClassName toClass( to );
     if (toClass.asString().indexOf(WC_FRAME) == 1)
     {
       // If a frame window, adjust window mapping by title, border and
       //  any menu area (if frame has a menu)
       unsigned long frameDeltaX = GetSystemMetrics( SM_CXFRAME );
       unsigned long frameDeltaY = GetSystemMetrics( SM_CYCAPTION ) +
                                           GetSystemMetrics( SM_CYFRAME );
       unsigned long ulStyle = ISTYLEOF( to );
       if ( !(ulStyle & WS_CHILD) && GetMenu( to ) )
         frameDeltaY += GetSystemMetrics( SM_CYMENU );
       pt.x = pt.x + frameDeltaX;
       pt.y = pt.y + frameDeltaY;
     }
   }
#endif

   if ( ICoordinateSystem::isConversionNeeded() )
   {
#ifdef IC_WIN
      RECT rect;
      if (to)
        GetWindowRect(to, &rect);
      else
        GetWindowRect(GetDesktopWindow(), &rect);
      ISize size(rect.right - rect.left, rect.bottom - rect.top );
#endif //IC_WIN
#ifdef IC_PM
      SWP swp;
      WinQueryWindowPos(to, &swp);
      ISize size(swp.cx,swp.cy);
#endif //IC_PM
      pt = ICoordinateSystem::convertToApplication(
                                 IPoint(pt), size ).asPOINTL();
   }
   return pt;
}
#endif // IC_PMWIN

/*------------------------------------------------------------------------------
| IWindow::matchForMnemonic                                                    |
|                                                                              |
| let canvas do the work                                                       |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::matchForMnemonic ( unsigned short ) const
{
  return 0;
}


#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::windowUShort                                                        |
|                                                                              |
| Fetch the window ushort at given index.                                      |
------------------------------------------------------------------------------*/
unsigned short IWindow::windowUShort ( long index ) const
{
  unsigned short
    result = IQUERYWINDOWUSHORT( this->handle(), index );
  return result;
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::windowULong                                                         |
|                                                                              |
| Fetch the window ulong at given index.                                       |
------------------------------------------------------------------------------*/
unsigned long IWindow::windowULong ( long index ) const
{
  unsigned long
    result = IQUERYWINDOWULONG( this->handle(), index );
  return result;
}
#endif

/*------------------------------------------------------------------------------
| IWindow::messageQueue                                                        |
|                                                                              |
| Return the message queue handle extracted from QWL_HMQ window word.          |
------------------------------------------------------------------------------*/
IMessageQueueHandle IWindow::messageQueue ( ) const
{
#ifdef IC_PM
  return IMessageQueueHandle( this->windowULong( QWL_HMQ ) );
#endif
#ifdef IC_WIN
  return IMessageQueueHandle( IMessageQueueHandle::Value(IThread::current().id().asUnsigned()) );
#endif
#ifdef IC_MOTIF
  return IMessageQueueHandle( (void*)IThread::current().id().asUnsigned() );
#endif
}

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::setWindowData                                                       |
|                                                                              |
| Set the appropriate unsigned short window word.                              |
------------------------------------------------------------------------------*/
IWindow& IWindow::setWindowData ( long index, unsigned short ushort )
{
  if ( !ISETWINDOWUSHORT( this->handle(), index, ushort ) )
  {
    // Error, throw exception.
    ITHROWGUIERROR("WinSetWindowUShort");
  }
  return *this;
}
#endif

#ifdef IC_PMWIN
/*------------------------------------------------------------------------------
| IWindow::setWindowData                                                       |
|                                                                              |
| Set the appropriate unsigned long window word.                               |
------------------------------------------------------------------------------*/
IWindow& IWindow::setWindowData ( long index, unsigned long ulong )
{
  if ( !ISETWINDOWULONG( this->handle(), index, ulong ) )
  {
    // Error, throw exception.
    ITHROWGUIERROR("WinSetWindowULong");
  }
  return *this;
}
#endif

#ifdef IC_MOTIF
/*------------------------------------------------------------------------------
| ifontSetRCFontList                                                           |
| Sets the font list for row column children.                                  |
------------------------------------------------------------------------------*/
void IWindow::ifontSetRCFontList( IWindow* piwParent, Widget rc, XmFontList fontList )
{
   unsigned   char  rcType = XmWORK_AREA;
   XtVaGetValues( rc,
                  XmNrowColumnType, &rcType,
                  NULL);

   Cardinal   numChildren = 0;
   WidgetList children = 0;
   XtVaGetValues(   rc,
                    XmNnumChildren, &numChildren,
                    XmNchildren, &children,
                    NULL );
   IWindow* piwChild=0;
   int i;
   for ( i = 0; i < numChildren; i++)
      {
      // d8175 - check for child being destroyed.
      if ( !children[i]->core.being_destroyed )
       {
        // d7294
        if ( piwParent )
          piwChild = IWindow::windowWithHandle( children[i] );
        // Menu related rowColumns have to be handled in a special
        // way to find all the logical children
        if ( (rcType == XmMENU_BAR)   ||
             (rcType == XmMENU_POPUP) ||
             (rcType == XmMENU_PULLDOWN) )
           {
           // Set the font for the individual buttons or labels
           ifontSetWidgetFontList( piwChild, children[i], fontList );
           if ( XmIsCascadeButtonGadget( children[i] ) ||
                XmIsCascadeButton( children[i] ) )          // 27912
              {
              Widget submenu = 0;
              XtVaGetValues( children[i],
                             XmNsubMenuId, &submenu,
                             NULL);
              if (  (submenu) && XmIsRowColumn(submenu) )
                 {
                 // d7294
                 IWindow* piwGrandChild=0;
                 // If menu shell is found start setting its resources.
                 // Otherwise start at the row column
                 Widget  menushell = XtParent(submenu);
                 if (menushell)
                  {
                    if ( piwChild )
                      piwGrandChild = IWindow::windowWithHandle( menushell );
                    ifontSetWidgetFontList( piwGrandChild, menushell, fontList );
                  }
                 else
                  {
                    if ( piwChild )
                      piwGrandChild = IWindow::windowWithHandle( submenu );
                    ifontSetWidgetFontList( piwGrandChild, submenu, fontList );
                  }
                 // d7294
                 if ( piwGrandChild && ( piwGrandChild != piwChild ) )
                   piwGrandChild->setLayoutDistorted( IWindow::fontChanged
                                                    | IWindow::minimumSizeChanged,
                                                      0);

                 }  // is rowColumn
              }  // if cascade button
           }  // if menu RowColumn
        else
           {
           // Non menu rowcolumn child
           ifontSetWidgetFontList( piwChild, children[i], fontList );
           }
        // d7294 - set layout distorted on a child IWindow.
        if ( piwChild && ( piwChild != piwParent ) )
          piwChild->setLayoutDistorted( IWindow::fontChanged
                                      | IWindow::minimumSizeChanged, 0);
       } // !being_destroyed
      }  // for
}


/*------------------------------------------------------------------------------
| ifontSetChildFontList                                                        |
| Sets the font resources of the children of root.  Motif apparently           |
| only uses the labelFontList, buttonFontList, or textFontList of              |
| parent widgets at creation time.  To get behavior we need we set both        |
| those resources and the font resources of the children.                      |
------------------------------------------------------------------------------*/
void IWindow::ifontSetChildFontList( IWindow* piwParent,Widget root,XmFontList fontList )
{
   Cardinal   numChildren = 0;
   WidgetList children = 0;
   XtVaGetValues(   root,
                    XmNnumChildren, &numChildren,
                    XmNchildren, &children,
                    NULL );
   IWindow* piwChild=0;
   IFont fontParent( fontList );
   int i;

   for ( i = 0; i < numChildren; i++)
      {
      // d8175 - check for child being destroyed.
      if ( !children[i]->core.being_destroyed )
       {
        if ( piwParent )
          piwChild = IWindow::windowWithHandle( children[i] );

        // If the child is an IWindow, call setFont.  This will prevent
        // us from overlaying the font of a window with an explicitly set
        // font.
        if( (piwChild && (piwChild != piwParent)) )
        {
           if ( !(piwChild->pWindowData->state & fontWasSet) )
            piwChild->setFont( fontParent );
        }
        else
           ifontSetWidgetFontList( piwChild, children[i], fontList );
        // d7294 - set layout distorted on a child IWindow.
        if ( piwChild && ( piwChild != piwParent ) )
          piwChild->setLayoutDistorted( IWindow::fontChanged
                                      | IWindow::minimumSizeChanged, 0);
       }
      }
}

/*------------------------------------------------------------------------------
| ifontSetWidgetFontList                                                       |
| Sets the font resources of this widget.  If a composite widget,              |
| ifontSetChildFontList is called.                                             |
------------------------------------------------------------------------------*/
void IWindow::ifontSetWidgetFontList( IWindow* pwin,Widget current,XmFontList fontList )
{
   if ( XtIsComposite( current ) )
      {
      if ( XmIsBulletinBoard( current ) )
         {
         XtVaSetValues(current,
                       XmNtextFontList,   fontList,
                       XmNlabelFontList,  fontList,
                       XmNbuttonFontList, fontList,
                       NULL);

         }  // if BulletinBoard
      else if ( XtIsVendorShell( current ) )
         {
         XtVaSetValues(current,
                       XmNdefaultFontList, 0,   // obsolete in 1.2
                       XmNtextFontList,   fontList,
                       XmNlabelFontList,  fontList,
                       XmNbuttonFontList, fontList,
                       NULL);

         }  // if VendorShell
      else if ( XmIsMenuShell( current ) )
         {
         XtVaSetValues(current,
                       XmNdefaultFontList, 0,   // obsolete in 1.2
                       XmNlabelFontList,  fontList,
                       XmNbuttonFontList, fontList,
                       NULL);
         }  // menushell
      else if ( XmIsContainer(current) )
         {
         // set the fontList for the Container
         XtVaSetValues(current,
                       XmNfontList, fontList,
                       NULL);

         // set the fontList for the iconGadgets
         ifontSetChildFontList( 0, current, fontList );

         // Now call private container method updateFont to render
         // the headings and text in the container, and to update the title font

         ICnrControlData::updateFont( IWindowHandle(current), fontList );

         }  // container
      else
         {
         XtVaSetValues(current,
                       XmNfontList, fontList,
                       NULL);
         }

      // Set font resources for non-container children. (Container already
      // dealt with.)  Rowcolumn is special case because of menus.
      if ( XmIsRowColumn(current ) )
         {
         ifontSetRCFontList( pwin, current, fontList );
         }
      else if (!XtIsSubclass(current,xmContainerWidgetClass))
         {
         propagationInProgress++;
         ifontSetChildFontList( pwin, current, fontList );
         propagationInProgress--;
         }
      }  // is composite
   else
      {
         XtVaSetValues(current,
                       XmNfontList, fontList,
                       NULL);
      }
}
#endif  //IC_MOTIF

/*------------------------------------------------------------------------------
| IWindowPrivateData::setFontImp                                                         |
|                                                                              |
| Used by IWindow::setFont()
------------------------------------------------------------------------------*/
bool IWindow :: setFontImp(IFont& font)
{
   IMODTRACE_DEVELOP("IWindow::setWindowFont");
   bool result = True;
#ifdef IC_PM
   // Build string to pass on WinSetPresParam call
   IString presParm( font.pointSize() );
   presParm += ".";
   presParm += font.name();

   if ( font.isBold() )
     presParm += ".Bold";

   if ( font.isItalic() )
     presParm += ".Italic";

   if ( font.isOutline() )
     presParm += ".Outline";
   if ( font.isUnderscore() )
     presParm += ".Underscore";
   if ( font.isStrikeout() )
     presParm += ".Strikeout";

   result = WinSetPresParam( this->handle(),
                   PP_FONTNAMESIZE,
                   presParm.length()+1,
                   (char*)presParm );
   if (result == false)
     ITHROWGUIERROR("WinSetPresParam");
#endif

#ifdef IC_WIN
   if (!propagationInProgress)
   {
     this->pWindowData->state |= this->fontWasSet;
     if ( this->pWindowData->fFont )
     {             // Clean up the prior font.
        delete this->pWindowData->fFont;
     }
     this->pWindowData->fFont = new IFont(font);
   }

   this->sendEvent( WM_SETFONT,
                       IEventParameter1( *(font.ppd->fpFontHandle) ),
                       IEventParameter2( true ) );
#endif

#ifdef IC_MOTIF
   Widget  hwnd = this->handle();

   if (!propagationInProgress)
   {
      this->pWindowData->state |= this->fontWasSet;
   }

   // save the size so we can restore it later.
   Dimension fWidth, fHeight;
   XtVaGetValues( hwnd,
                  XmNwidth, &fWidth,
                  XmNheight, &fHeight,
                  NULL );

   XmFontList fontList = font.ppd->xmFontList();

   if ( this->isFrameWindow() )
     {
     // Set the font resources in the frame window
     // shell widget.
     		Widget shell = this->handleForChildCreation();
     		if (shell)
		 		{

        	ifontSetWidgetFontList( this, shell, fontList);
				}
     }
   else
     {
     		ifontSetWidgetFontList( this, hwnd, fontList);
     }

   // Setting the font on certain windows causes motif to resize the window?
   // The mle is an example of this problem. So we save the size and restore
   // it here so we can set the font without resizing the control.
   XtVaSetValues( hwnd,
                  XmNwidth,  fWidth,
                  XmNheight, fHeight,
                  NULL );
   // d7294 - treat a font change as a change in the minimum size.
//   pwindow->setLayoutDistorted(IWindow::fontChanged, 0);
   this->setLayoutDistorted( IWindow::fontChanged
                              | IWindow::minimumSizeChanged, 0);
#endif
   return result;
}

/*------------------------------------------------------------------------------
| IWindow::setFont                                                             |
|                                                                              |
| Sets the font for the window.                                                |
------------------------------------------------------------------------------*/
IWindow& IWindow::setFont (const IFont& fm)
{
#ifdef IC_MOTIFWIN
  if ((!propagationInProgress) || !(pWindowData->state & fontWasSet))
#endif
  {
    IFont* tmpFont = (IFont*) &fm;
    setFontImp(*tmpFont);
    pWindowData->sizClChar.setWidth(fm.avgCharWidth());
    pWindowData->sizClChar.setHeight(fm.maxCharHeight());

//Propagate font
#ifdef IC_WIN
  		// Bump in propagation static by 1 (since nested calls could occur).
  		propagationInProgress++;

  		// Now lets propagate this font to all of the children of the window.
  		// This is to give it similar behavior to OS/2 pres-params support.
  		IWindowHandle hwndChild = 0;
  		IWindow::ChildCursor cursor( *(IWindow*)this );

  		// Enumerate all child windows.
  		for ( cursor.setToFirst(); cursor.isValid(); cursor.setToNext() )
  		{
    		// Get the IWindow object for each child found
    		bool bNewChild = false;
    		IWindowHandle hwndChild = this->childAt( cursor );
    		IWindow* pwndChild = IWindow::windowWithHandle( hwndChild );

    		// If no IWindow object exists, create one temporarily
    		if ( !pwndChild )
    		{
       		pwndChild = new IWindow( hwndChild );
       		bNewChild = true;
    		}

    		// Set the font for that window
    		pwndChild->setFont( fm );

    		// Delete any temporary IWindow object created (if one was needed)
    		if ( bNewChild )
       		delete pwndChild;
  		}
  		propagationInProgress--;
#endif // IC_WIN

#ifdef IC_MOTIF
    this->notifyObservers(INotificationEvent(IWindow::fontId, *this));
#endif
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetFont                                                           |
|                                                                              |
| Causes the window to use the default font.                                   |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetFont ( )
{
#ifdef IC_PMWIN
#ifndef IC_WIN
  WinRemovePresParam( this->handle(), PP_FONTNAMESIZE );
      // Don't care if window has no such presentation parameter.
#endif
#ifdef IC_WIN
  // Check if this window has had a font explicitly set
  if (pWindowData->state & fontWasSet)
  {
      // If so then delete it, reset value and clear flag
      delete pWindowData->fFont;
      pWindowData->fFont = 0;
      pWindowData->state &= (unsigned long)~fontWasSet;
  }

  // Now we need to look if it should inherit any fonts from parents.
  bool bFound = false;
  IWindow* current = this->parent();

  while (current && (current != IWindow::desktopWindow()) && !bFound)
  {
      // Check if any parent has had a font explicitly set.
      if (current->pWindowData->state & fontWasSet)
      {
          // If one had, then set this window to that font.  Set the
          // propagation flag to prevent making a copy of that font.
          propagationInProgress++;
          setFont( current->font() );
          propagationInProgress--;
          bFound = true;
      }
      else
          // Go up chain until found or desktop/no IWindow wrapper
          current = current->parent();
  }  // while
  // If no font found, then set font to system default font.
  if (!bFound)
  {

      this->sendEvent( WM_SETFONT,
                       IEventParameter1( GetStockObject(SYSTEM_FONT) ),
                       IEventParameter2( true ) );

      // make sure virtual processing takes place
      setFont( font() );
  }
#endif

  // Update current character size information.
  IFont defaultFont = this->font();

#ifdef IC_PM
   // make sure virtual processing takes place
   setFont( defaultFont );
#endif

  this->pWindowData->sizClChar.setWidth( defaultFont.avgCharWidth() );
  this->pWindowData->sizClChar.setHeight( defaultFont.maxCharHeight() );
#endif
  return *this;
}

#ifdef IC_MOTIF
static bool
is_text_widget(Widget wh)  { return XmIsText(wh) ? true : false; }

static bool
is_label_widget(Widget wh) { return XmIsLabel(wh) ? true : false; }

static bool
is_menu_button_gadget(Widget wh)
{
    if (XmIsCascadeButtonGadget(wh) || XmIsToggleButtonGadget(wh))
        return true;
    else
        return false;
}

void
findFontListFromParents(Widget wh, XmFontList *fontList, bool (*criteria)(Widget) = 0)
{
    if (*fontList != 0 || wh == NULL)
        return;

    if (criteria == 0 || criteria(wh))
        XtVaGetValues(wh, XmNfontList, fontList, NULL);

    if (*fontList == 0)
        findFontListFromParents(XtParent(wh), fontList, criteria);
}

void
findFontListInChildren(Widget wh, XmFontList *fontList, bool (*criteria)(Widget) = 0)
{
    if (*fontList != 0 || wh == NULL)
        return;

    if (XmIsManager(wh)) {

        Cardinal numChildren;
        WidgetList children;
        int i;

        XtVaGetValues(wh, XmNnumChildren, &numChildren,
                      XmNchildren, &children, NULL);

        for (i = 0; (i < numChildren) && (*fontList == 0); i++)
            if (! children[i]->core.being_destroyed)
                findFontListInChildren(children[i], fontList, criteria);
    } else {
        if (criteria == 0 || criteria(wh))
            XtVaGetValues(wh, XmNfontList, fontList, NULL);
    }
}
#endif

/*------------------------------------------------------------------------------
| IWindow::font                                                                |
|                                                                              |
| Returns the font used for the window.                                        |
------------------------------------------------------------------------------*/
IFont IWindow::font() const
{
#ifdef IC_PM
    return IFont(this);
#endif
#ifdef IC_WIN
    if (pWindowData->state & fontWasSet)
        return (*(pWindowData->fFont));
    else
        return IFont(this);
#endif
#ifdef IC_MOTIF
    Widget wh = (Widget)handle();
    XmFontList fontList = 0;

    // Manager does not have a font by itself... so we are making some
    // assumptions here.
    if (XmIsManager(wh)) {

        if (XmIsScrolledWindow(wh) || XmIsForm(wh)) {
            // If it is a scrolled window (MLE) or Form (Combo box or Spin button),
            // get the text widget and use its font list resoruce
            ITRACE_DEVELOP("Found scrolled window or form widget");
            findFontListInChildren(wh, &fontList, is_text_widget);

        } else if (XmIsRowColumn(wh)) {
            // This is a menu.  Find a child and use the fontlist
            // resource from a child.
            ITRACE_DEVELOP("Found a row column widget");
            findFontListInChildren(wh, &fontList, is_menu_button_gadget);

        } else if (XmIsDrawingArea(wh)) {
            // Possibly a Group box / Outline box
            ITRACE_DEVELOP("Found a drawing area widget");
            findFontListInChildren(wh, &fontList, is_label_widget);
        }

        if (fontList == 0) {
            ITRACE_DEVELOP("Found a misc. manager widget");
            findFontListFromParents((Widget)wh, &fontList);
        }

    } else {

        // For most widgets, either return the fontList resource
        // or its parent's resource
        ITRACE_DEVELOP("Found a general widget");
        XtVaGetValues((Widget)wh, XmNfontList, &fontList, NULL);
        if (fontList == 0)
            findFontListFromParents(XtParent((Widget)wh), &fontList);
    }
    // If found a font List then create font data
    if (fontList)
        return IFont(fontList);
    else
        return IFont((IWindow*)0);
#endif // IC_MOTIF
}

/*------------------------------------------------------------------------------
| IWindow::characterSize                                                       |
|                                                                              |
| Return the average character width and maximum character height for the      |
| window.                                                                      |
------------------------------------------------------------------------------*/
ISize IWindow::characterSize () const
{
  if ((pWindowData->sizClChar.width() == 0) ||
      (isLayoutDistorted(IWindow::fontChanged)))
  {                               // needs initializing
     IFont fontmgr(this);         // get current font information
     pWindowData->sizClChar.setWidth(fontmgr.avgCharWidth());
     pWindowData->sizClChar.setHeight(fontmgr.maxCharHeight());
     ((IWindow *)this)->setLayoutDistorted(0,IWindow::fontChanged);
  }
  return pWindowData->sizClChar;
}

/*------------------------------------------------------------------------------
| IWindow::enableTabStop                                                       |
|                                                                              |
| Allow keyboard navigation to the window via the Tab key.  (This function     |
| has no effect on Motif.)                                                     |
------------------------------------------------------------------------------*/
IWindow& IWindow::enableTabStop ( bool enable )
{
  unsigned long
    ulStyle = this->style(),
    ulOldStyle = ulStyle;

  if ( enable )
  {
     ulStyle |= tabStop.asUnsignedLong();
  }
  else
  {
     ulStyle &= ~tabStop.asUnsignedLong();
  }

  if ( ulStyle != ulOldStyle )
  {
     this->setStyle( ulStyle );

#ifdef IC_MOTIF
     if (enable)
     {
        // Set the navigation type for any canvas parent.
        ICanvas *fParentCanvas = dynamic_cast<ICanvas*>(this->parent());
        if (fParentCanvas)
        {
           XtVaSetValues( fParentCanvas->handle(),
                          XmNnavigationType, XmTAB_GROUP,
                          NULL );
        }
     }
     else
     {
        // Disable navigation for a canvas parent if it has no other tabbable
        // children.
        ICanvas *fCanvas = dynamic_cast<ICanvas*>(this);
        if (fCanvas && !fCanvas->isTabStop())
        {
           XtVaSetValues( handle(),
                          XmNnavigationType, XmNONE,
                          NULL );
        }
        else
        {
           ICanvas *fParentCanvas = dynamic_cast<ICanvas*>(this->parent());
           if (fParentCanvas && !fParentCanvas->isTabStop())
           {
              XtVaSetValues( fParentCanvas->handle(),
                             XmNnavigationType, XmNONE,
                             NULL );
           }
        }
     }
#endif // IC_MOTIF
  }

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::disableTabStop                                                      |
|                                                                              |
| Prevent keyboard navigation to the window via the Tab key.  (This function   |
| has no effect on Motif.)                                                     |
------------------------------------------------------------------------------*/
IWindow& IWindow::disableTabStop ( )
{
  return this->enableTabStop( false );
}

/*------------------------------------------------------------------------------
| IWindow::isTabStop                                                           |
|                                                                              |
| Return if the Tab key can be used to navigate to the window.  (This function |
| is meaningful only for child windows of a frame window or canvas.)           |
------------------------------------------------------------------------------*/
bool IWindow::isTabStop ( ) const
{
  unsigned long ulStyle = style();
  if (ulStyle & WS_TABSTOP)
    return true;
  return false;

}

/*------------------------------------------------------------------------------
| IWindow::enableGroup                                                         |
|                                                                              |
| Mark this window as the first in a group (the arrow keys allow you to move   |
| between windows in a group).  (This function has no effect on Motif.)        |
------------------------------------------------------------------------------*/
IWindow& IWindow::enableGroup ( bool enable )
{
  unsigned long
    ulStyle = this->style(),
    ulOldStyle = ulStyle;

  if ( enable )
  {
     ulStyle |= group.asUnsignedLong();
  }
  else
  {
     ulStyle &= ~group.asUnsignedLong();
  }

  if ( ulStyle != ulOldStyle )
  {
     this->setStyle( ulStyle );
  }
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::disableGroup                                                        |
|                                                                              |
| Combine this window with the preceding group of windows (the arrow keys      |
| allow you to move between windows in a group).  (This function has no effect |
| on Motif.)                                                                   |
------------------------------------------------------------------------------*/
IWindow& IWindow::disableGroup ( )
{
  return this->enableGroup( false );
}

/*------------------------------------------------------------------------------
| IWindow::isGroup                                                             |
|                                                                              |
| Return if the window is the first in a group of sibling windows.  Typically  |
| this defines keyboard navigation rules for the arrow keys, and other dialog  |
| like behavior.  (This function is meaningful only for child windows of a     |
| frame window or canvas.)                                                     |
------------------------------------------------------------------------------*/
bool IWindow::isGroup ( ) const
{
  unsigned long ulStyle = style();
  if (ulStyle & WS_GROUP)
     return true;
  return false;
}

/*------------------------------------------------------------------------------
| IWindow::capturePointer                                                      |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IWindow& IWindow::capturePointer( bool capture )
{
#ifdef IC_PMWIN
  if (capture)
  {
    if (IQUERYCAPTURE == 0)
    {
      bool rc;
      ISETCAPTURE(rc, this->handle());
    }
    else
    {
      ITHROWGUIERROR("WinSetCapture");
    }
  }
  else
  {
    if (IQUERYCAPTURE == this->handle())
    {
      IRELEASECAPTURE;
    }
  }
#endif
#ifdef IC_MOTIF
  if ( capture )
  {
    Time fTime = CurrentTime;

    if (ithreadLastButtonEvent.display )
    {
      fTime = ithreadLastButtonEvent.time;
    }
    int rv = XtGrabPointer( this->handle(),
                   False, /* onwer events */
                   ButtonPressMask |  /* event mask */
                   ButtonReleaseMask |
                   EnterWindowMask |
                   LeaveWindowMask |
                   PointerMotionMask,
                   GrabModeAsync,      /* pointer_mode */
                   GrabModeAsync,      /* keyboard_mode */
                   None,               /* confine_to */
                   None,               /* cursor */
                   fTime);       /* time */
    if (rv == GrabSuccess )
    {
      pWindowData->windowGrabbed = true;  // can't figure out how to ask X windows
                                       // for this info yet.
    }
    else
    {
      pWindowData->windowGrabbed = false;  // can't figure out how to ask X windows
      /* add some exeptions */
    }
  }
  else
  {
    XtUngrabPointer( this->handle(), CurrentTime );
    pWindowData->windowGrabbed = false;  // can't figure out how to ask X windows
  }

#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::releasePointer                                                      |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IWindow& IWindow::releasePointer( )
{
   return (capturePointer( false ));
}

/*------------------------------------------------------------------------------
| IWindow::hasPointerCaptured                                                  |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
bool IWindow::hasPointerCaptured( ) const
{
#ifdef IC_PMWIN
  return (IQUERYCAPTURE == this->handle());
#endif
#ifdef IC_MOTIF
  // have not figured out a way to ask X who has grabbed the pointer, so for
  // now we will use local data to keep track. Must document that if native
  // X calls are used we can get out of sync.
  return ( pWindowData->windowGrabbed );
#endif
}

/*------------------------------------------------------------------------------
| IWindow::movePointerTo                                                       |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
void IWindow::movePointerTo ( const IPoint& position )
{
  IPoint nativePoint = ICoordinateSystem::convertToNative(
                          position,
                          desktopWindow()->size() );
  long x = nativePoint.x();
  long y = nativePoint.y();
#ifdef IC_PMWIN
  ISETPOINTERPOSITION(x,y);
#endif
#ifdef IC_MOTIF
  if ( IWindow::desktopWindow() )
  {
    Display *display = XtDisplayOfObject( IWindow::desktopWindow()->handle());
    XWarpPointer( display,
                  None,
                  RootWindow( display, DefaultScreen(display)),
                  0, 0,   /* src position */
                  0, 0,   /* src width and height */
                  x, y ); /* Destination, global coordinates */
  }
#endif
}

/*------------------------------------------------------------------------------
| IWindow::pointerPosition                                                     |
|                                                                              |
|                                                                              |
------------------------------------------------------------------------------*/
IPoint IWindow::pointerPosition ( )
{
  long x,y;
#ifdef IC_PMWIN
  IQUERYPOINTERPOSITION(x,y);
#endif
#ifdef IC_MOTIF
  int root_x, root_y;
  int child_x, child_y;
  Window root_return, child_return;
  unsigned int mask;

  if ( IWindow::desktopWindow() )
  {
    Display *theDisplay =
      XtDisplayOfObject( IWindow::desktopWindow()->handle() );
    XQueryPointer( theDisplay,
                   RootWindow( theDisplay, DefaultScreen(theDisplay )),
                  &root_return,
                  &child_return,
                  &root_x,
                  &root_y,
                  &child_x,
                  &child_y,
                  &mask );
    x = root_x;
    y = root_y;
  }
#endif
  return ICoordinateSystem::convertToApplication(
                               IPoint(x,y),
                               desktopWindow()->size() );
}

/*------------------------------------------------------------------------------
| IWindow::setAcceleratorTable                                                 |
|                                                                              |
| Store the accelerator table for a window.                                    |
------------------------------------------------------------------------------*/
IWindow&
  IWindow::setAcceleratorTable ( const IAcceleratorTable* acceleratorTable )
{
  IAccelTblHandle handle( 0 );
  if ( acceleratorTable )
  {
     handle = acceleratorTable->handle();
  }
  return this->setAcceleratorHandle( handle );
}

/*------------------------------------------------------------------------------
| IWindow::acceleratorTable                                                    |
|                                                                              |
| Return the accelerator table for the window.                                 |
------------------------------------------------------------------------------*/
IAcceleratorTable IWindow::acceleratorTable ( ) const
{
  // Construct the IAcceleratorTable using the IWindow* constructor,
  // so that the object will support immediate updates on changes to
  // the contents of the table
  IAcceleratorTable table( this );
  return table;
}

/*------------------------------------------------------------------------------
| IWindow::setAcceleratorHandle                                                |
|                                                                              |
| Store the accelerator table for a window.                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::setAcceleratorHandle ( const IAccelTblHandle& handle )
{
  // Clean-up the last one.
  if ( pWindowData->fAccelHandle )
  {  // Ignore any errors, since the application could have already
     // found and destroyed this using system APIs.
     IAcceleratorTable::destroyHandle( pWindowData->fAccelHandle );
  }

  // Store the new accelerator table handle now.
  pWindowData->fAccelHandle = handle;

#ifdef IC_PM
  if ( this->isFrameWindow() )
  {  // Keep the accelerator table handles maintained by IWindow and PM
     // in synch.  We do this to allow the application to mix in PM APIs.
     // Note that PM stores accelerator tables only for frames.
     if ( ! ISETACCELTABLE( handle, this->handle() ) )
     {
        ITHROWGUIERROR( "ISETACCELTABLE" );
     }
  }
  else
  {  // Need special handler for non-frame windows, since PM only supports
     // accelerator tables for frames.  The handler emulates frame window
     // behavior by processing WM_TRANSLATEACCEL messages using the
     // accelerator table we store in this function.
     if ( handle )
     {  // Accelerator table being added to window.
        // Add the special handler to use the accelerator table.
        IAcceleratorKeyHandler::defaultHandler()->handleEventsFor( this );
     }
     else
     {  // The window isn't to use any accelerator table.
        // Remove the special handler, assuming that the window had one
        // of these.
        IAcceleratorKeyHandler::defaultHandler()->stopHandlingEventsFor( this );
     }
  }
#endif // IC_PM

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::acceleratorHandle                                                   |
|                                                                              |
| Return the accelerator table for a window.                                   |
------------------------------------------------------------------------------*/
IAccelTblHandle IWindow::acceleratorHandle ( ) const
{
  IAccelTblHandle accelTbl = pWindowData->fAccelHandle;
#ifdef IC_PM
  if ( this->isFrameWindow() )
  {  // Keep the accelerator table handles maintained by IWindow and PM
     // in synch.  We do this to allow the application to mix in PM APIs.
     // Note that PM stores accelerator tables only for frames.
     IAccelTblHandle presAccelTbl = IQUERYACCELTABLE( this->handle() );
     if ( presAccelTbl != accelTbl )
     {  // The IWindow and PM accelerator tables are not the same.
        // Assume the one maintained by PM is more current (it must have
        // been updated through a PM API later than any calls to
        // setAcceleratorTable or setAcceleratorHandle), so replace the
        // one being maintained by IWindow.
        IAcceleratorTable::destroyHandle( accelTbl );
        accelTbl = presAccelTbl;
        ((IWindow *)this)->setAcceleratorHandle( accelTbl );
     }
  }
#endif
  return accelTbl;
}

#ifdef IC_MOTIFWIN
/*------------------------------------------------------------------------------
| IWindow::borderColor                                                         |
|                                                                              |
| Returns the border color of the window.                                      |
------------------------------------------------------------------------------*/
IColor IWindow::borderColor () const
{
  return (IGUIColor(IGUIColor::frameBorder));
}

/*------------------------------------------------------------------------------
| IWindow::shadowColor                                                         |
|                                                                              |
| Returns the shadow color of the window.                                      |
------------------------------------------------------------------------------*/
IColor IWindow::shadowColor () const
{
  return (IGUIColor(IGUIColor::dialogShadow));
}

/*------------------------------------------------------------------------------
| IWindow::disabledForegroundColor                                             |
|                                                                              |
| Returns the disabled foreground color of the window.                         |
------------------------------------------------------------------------------*/
IColor IWindow::disabledForegroundColor () const
{
  return (IGUIColor(IGUIColor::defaultControl));
}

/*------------------------------------------------------------------------------
| IWindow::disabledBackgroundColor                                             |
|                                                                              |
| Returns the disabled background color of the window.                         |
------------------------------------------------------------------------------*/
IColor IWindow::disabledBackgroundColor () const
{
  return (IGUIColor(IGUIColor::windowBgnd));
}

/*------------------------------------------------------------------------------
| IWindow::hilitedForegroundColor                                              |
|                                                                              |
| Returns the hilite foreground color of the window.                           |
------------------------------------------------------------------------------*/
IColor IWindow::hiliteForegroundColor () const
{
  return (IGUIColor(IGUIColor::hiliteFgnd));
}

/*------------------------------------------------------------------------------
| IWindow::hilitedBackgroundColor                                              |
|                                                                              |
| Returns the hilite background color of the window.                           |
------------------------------------------------------------------------------*/
IColor IWindow::hiliteBackgroundColor () const
{
  return (IGUIColor(IGUIColor::hiliteBgnd));
}

/*------------------------------------------------------------------------------
| IWindow::activeColor                                                         |
|                                                                              |
| Returns the active color of the window.                                      |
------------------------------------------------------------------------------*/
IColor IWindow::activeColor () const
{
  return (IGUIColor(IGUIColor::activeFrameBorder));
}

/*------------------------------------------------------------------------------
| IWindow::inactiveColor                                                       |
|                                                                              |
| Returns the inactive color of the window.                                    |
------------------------------------------------------------------------------*/
IColor IWindow::inactiveColor () const
{
  return (IGUIColor(IGUIColor::inactiveFrameBorder));
}

/*------------------------------------------------------------------------------
| IWindow::setBorderColor (NOPed for Windows)                                  |
|                                                                              |
| Sets the border color of the window.                                         |
------------------------------------------------------------------------------*/
IWindow& IWindow::setBorderColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setShadowColor (NOPed for Windows)                                  |
|                                                                              |
| Sets the shadow color of the window.                                         |
------------------------------------------------------------------------------*/
IWindow& IWindow::setShadowColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setDisabledForegroundColor (NOPed for Windows)                      |
|                                                                              |
| Sets the disabled foreground color of the window.                            |
------------------------------------------------------------------------------*/
IWindow& IWindow::setDisabledForegroundColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setDisabledBackgroundColor (NOPed for Windows)                      |
|                                                                              |
| Sets the disabled background color of the window.                            |
------------------------------------------------------------------------------*/
IWindow& IWindow::setDisabledBackgroundColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setHiliteForegroundColor (NOPed for Windows)                        |
|                                                                              |
| Sets the hilite foreground color of the window.                              |
------------------------------------------------------------------------------*/
IWindow& IWindow::setHiliteForegroundColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setHiliteBackgroundColor (NOPed for Windows)                        |
|                                                                              |
| Sets the hilite background color of the window.                              |
------------------------------------------------------------------------------*/
IWindow& IWindow::setHiliteBackgroundColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setActiveColor (NOPed for Windows)                                  |
|                                                                              |
| Sets the active color of the window.                                         |
------------------------------------------------------------------------------*/
IWindow& IWindow::setActiveColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setInactiveColor (NOPed for Windows)                                |
|                                                                              |
| Sets the inactive color of the window.                                       |
------------------------------------------------------------------------------*/
IWindow& IWindow::setInactiveColor (const IColor &color)
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}


/*------------------------------------------------------------------------------
| IWindow::resetForegroundColor (NOPed for Windows)                            |
|                                                                              |
| Resets the foreground color by undoing a previous set.                       |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetForegroundColor ()
{
  resetColor( PP_FOREGROUNDCOLOR );
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetBackgroundColor                                                |
|                                                                              |
| Resets the background color by undoing a previous set.                       |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetBackgroundColor ()
{
  resetColor( PP_BACKGROUNDCOLOR );
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetBorderColor (NOPed for Windows)                                |
|                                                                              |
| Resets the border color by undoing a previous set.                           |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetBorderColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetShadowColor (NOPed for Windows)                                |
|                                                                              |
| Resets the shadow color by undoing a previous set.                           |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetShadowColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetDisabledForegroundColor (NOPed for Windows)                    |
|                                                                              |
| Resets the disabled foreground color by undoing a previous set.              |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetDisabledForegroundColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetDisabledBackgroundColor (NOPed for Windows)                    |
|                                                                              |
| Resets the disabled background color by undoing a previous set.              |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetDisabledBackgroundColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetHiliteForegroundColor (NOPed for Windows)                      |
|                                                                              |
| Resets the hilite foreground color by undoing a previous set.                |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetHiliteForegroundColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetHiliteBackgroundColor (NOPed for Windows)                      |
|                                                                              |
| Resets the hilite background color by undoing a previous set.                |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetHiliteBackgroundColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetActiveColor (NOPed for Windows)                                |
|                                                                              |
| Resets the active color by undoing a previous set.                           |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetActiveColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetInactiveColor (NOPed for Windows)                              |
|                                                                              |
| Resets the inactive color by undoing a previous set.                         |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetInactiveColor ()
{
  ITRACE_MOTIF_NOP();
  ITRACE_WIN_NOP();
  return *this;
}

#endif // IC_MOTIFWIN


/*------------------------------------------------------------------------------
| IWindowPrivateData::perfEventTrace                                           |
------------------------------------------------------------------------------*/
void IWindowPrivateData::perfEventTrace( unsigned long ulMsg )
{
#ifdef IC_PMWIN
#ifdef IC_PERF
   #define IPERF_MSG(msg)  case msg: msgtext=#msg ; break;
   // Performance Analyser user trace of messages.  Note that the strings
   // to be written to the trace must exist in storage when the program
   // terminates for them to be written properly.
   char*   msgtext = 0;
   switch (ulMsg)
      {
      #ifdef IC_WIN
        IPERF_MSG( DM_RENDERPREPARE           )
        IPERF_MSG( DM_RENDERCOMPLETE          )
        IPERF_MSG( DM_RENDER                  )
        IPERF_MSG( DM_ENDCONVERSATION         )
        IPERF_MSG( DM_DISCARDOBJECT           )
        IPERF_MSG( DM_PRINTOBJECT             )
        IPERF_MSG( DM_DRAGOVER                )
        IPERF_MSG( DM_DROPHELP                )
        IPERF_MSG( DM_DRAGLEAVE               )
        IPERF_MSG( DM_DROP                    )
        IPERF_MSG( DM_REGISTER                )
        IPERF_MSG( WM_CHORD                   )
        IPERF_MSG( IC_UM_CONTEXT_HELP         )
        IPERF_MSG( IC_UM_LN_SELECT            )
        IPERF_MSG( IC_UM_QUERY_HELP_WINDOW    )
        IPERF_MSG( IC_UM_REQUEST_CANVASFONT   )
        IPERF_MSG( IC_UM_LBUTTONDBLCLK        )
        IPERF_MSG( HM_HELPSUBITEM_NOT_FOUND   )
        IPERF_MSG( WM_MENUEND                 )
        IPERF_MSG( IC_UM_COMMAND              )
        IPERF_MSG( IC_UM_SYSCOMMAND           )
        IPERF_MSG( WM_CONTROL                 )
        IPERF_MSG( WM_MATCHMNEMONIC           )
        IPERF_MSG( IC_UM_QUERYFRAMECTLCOUNT   )
        IPERF_MSG( IC_UM_FORMATFRAME          )
        IPERF_MSG( IC_UM_UPDATEFRAME          )
        IPERF_MSG( IC_UM_CALCFRAMERECT        )
        IPERF_MSG( WM_QUERYFOCUSCHAIN         )
        IPERF_MSG( IC_UM_32TO16               )
        IPERF_MSG( WM_BUTTON1CLICK            )
        IPERF_MSG( WM_BUTTON2CLICK            )
        IPERF_MSG( WM_BUTTON3CLICK            )
        IPERF_MSG( WM_TRACKFRAME              )
        IPERF_MSG( IC_UM_SLIDER_SCROLL        )
        IPERF_MSG( WM_BEGINDRAG               )
        IPERF_MSG( IC_UM_VSCROLL              )
        IPERF_MSG( IC_UM_QUIT                 )
      #endif  // IC_WIN
      IPERF_MSG( IC_UM_DRAGDROP_RENDER      )
      IPERF_MSG( IC_UM_CANVAS_SETFOCUS      )
      IPERF_MSG( IC_UM_CANVAS_PAINT         )
      IPERF_MSG( IC_UM_CREATED              )
      IPERF_MSG( IC_UM_DESTROY_MENU         )
      IPERF_MSG( IC_UM_UNLATCH              )
      IPERF_MSG( IC_UM_QRY_BMP_VISIBLE      )
      IPERF_MSG( IC_UM_QRY_TXT_VISIBLE      )
      IPERF_MSG( IC_UM_FLY_PAINT            )
      IPERF_MSG( IC_UM_TOOLBAR              )
      IPERF_MSG( IC_UM_DRAW_DOWN            )
      IPERF_MSG( IC_UM_QRY_PREVENTUPDATE    )
      IPERF_MSG( IC_UM_WINDOWPOSCHANGED     )
      IPERF_MSG( IC_UM_DELAYNOTIFY          )
      IPERF_MSG( IC_UM_CLOSE                )
      IPERF_MSG( IC_UM_BIDI_CHANGE          )
      IPERF_MSG( IC_UM_DLG_APPLY_PRESSED    )
      IPERF_MSG( IC_UM_MEDIA_LOADED         )
      IPERF_MSG( IC_UM_MEDIA_UNLOADED       )
      IPERF_MSG( IC_UM_MM_MCI_CMDNOTIFY     )
      IPERF_MSG( IC_UM_CBN_ENTER            )
      IPERF_MSG( IC_UM_CBN_EFCHANGE         )
      IPERF_MSG( IC_UM_DESTROY_FRAME        )
      IPERF_MSG( IC_UM_MM_MCI_POSITIONCHANGE)
      IPERF_MSG( IC_UM_IS_AGGREGATE_CTRL    )
      IPERF_MSG( IC_UM_TCM_SIZE             )

      // System defined messages
      #ifdef IC_WIN
        IPERF_MSG( WM_NULL                  )
        IPERF_MSG( WM_CREATE                )
        IPERF_MSG( WM_DESTROY               )
        IPERF_MSG( WM_MOVE                  )
        IPERF_MSG( WM_SIZE                  )
        IPERF_MSG( WM_ACTIVATE              )
        IPERF_MSG( WM_SETFOCUS              )
        IPERF_MSG( WM_KILLFOCUS             )
        IPERF_MSG( WM_ENABLE                )
        IPERF_MSG( WM_SETREDRAW             )
        IPERF_MSG( WM_SETTEXT               )
        IPERF_MSG( WM_GETTEXT               )
        IPERF_MSG( WM_GETTEXTLENGTH         )
        IPERF_MSG( WM_PAINT                 )
        IPERF_MSG( WM_CLOSE                 )
        IPERF_MSG( WM_QUERYENDSESSION       )
        IPERF_MSG( WM_QUIT                  )
        IPERF_MSG( WM_QUERYOPEN             )
        IPERF_MSG( WM_ERASEBKGND            )
        IPERF_MSG( WM_SYSCOLORCHANGE        )
        IPERF_MSG( WM_ENDSESSION            )
        IPERF_MSG( WM_SHOWWINDOW            )
        IPERF_MSG( WM_WININICHANGE          )
        IPERF_MSG( WM_DEVMODECHANGE         )
        IPERF_MSG( WM_ACTIVATEAPP           )
        IPERF_MSG( WM_FONTCHANGE            )
        IPERF_MSG( WM_TIMECHANGE            )
        IPERF_MSG( WM_CANCELMODE            )
        IPERF_MSG( WM_SETCURSOR             )
        IPERF_MSG( WM_MOUSEACTIVATE         )
        IPERF_MSG( WM_CHILDACTIVATE         )
        IPERF_MSG( WM_QUEUESYNC             )
        IPERF_MSG( WM_GETMINMAXINFO         )
        IPERF_MSG( WM_PAINTICON             )
        IPERF_MSG( WM_ICONERASEBKGND        )
        IPERF_MSG( WM_NEXTDLGCTL            )
        IPERF_MSG( WM_SPOOLERSTATUS         )
        IPERF_MSG( WM_DRAWITEM              )
        IPERF_MSG( WM_MEASUREITEM           )
        IPERF_MSG( WM_DELETEITEM            )
        IPERF_MSG( WM_VKEYTOITEM            )
        IPERF_MSG( WM_CHARTOITEM            )
        IPERF_MSG( WM_SETFONT               )
        IPERF_MSG( WM_GETFONT               )
        IPERF_MSG( WM_SETHOTKEY             )
        IPERF_MSG( WM_GETHOTKEY             )
        IPERF_MSG( WM_QUERYDRAGICON         )
        IPERF_MSG( WM_COMPAREITEM           )
        IPERF_MSG( WM_COMPACTING            )
        IPERF_MSG( WM_COMMNOTIFY            )
        IPERF_MSG( WM_WINDOWPOSCHANGING     )
        IPERF_MSG( WM_WINDOWPOSCHANGED      )
        IPERF_MSG( WM_POWER                 )
        IPERF_MSG( WM_COPYDATA              )
        IPERF_MSG( WM_CANCELJOURNAL         )
        IPERF_MSG( WM_NOTIFY                )
        IPERF_MSG( WM_INPUTLANGCHANGEREQUEST)
        IPERF_MSG( WM_INPUTLANGCHANGE       )
        IPERF_MSG( WM_TCARD                 )
        IPERF_MSG( WM_HELP                  )
        IPERF_MSG( WM_USERCHANGED           )
        IPERF_MSG( WM_NOTIFYFORMAT          )
        IPERF_MSG( WM_CONTEXTMENU           )
        IPERF_MSG( WM_STYLECHANGING         )
        IPERF_MSG( WM_STYLECHANGED          )
        IPERF_MSG( WM_DISPLAYCHANGE         )
        IPERF_MSG( WM_GETICON               )
        IPERF_MSG( WM_SETICON               )
        IPERF_MSG( WM_NCCREATE              )
        IPERF_MSG( WM_NCDESTROY             )
        IPERF_MSG( WM_NCCALCSIZE            )
        IPERF_MSG( WM_NCHITTEST             )
        IPERF_MSG( WM_NCPAINT               )
        IPERF_MSG( WM_NCACTIVATE            )
        IPERF_MSG( WM_GETDLGCODE            )
        IPERF_MSG( WM_NCMOUSEMOVE           )
        IPERF_MSG( WM_NCLBUTTONDOWN         )
        IPERF_MSG( WM_NCLBUTTONUP           )
        IPERF_MSG( WM_NCLBUTTONDBLCLK       )
        IPERF_MSG( WM_NCRBUTTONDOWN         )
        IPERF_MSG( WM_NCRBUTTONUP           )
        IPERF_MSG( WM_NCRBUTTONDBLCLK       )
        IPERF_MSG( WM_NCMBUTTONDOWN         )
        IPERF_MSG( WM_NCMBUTTONUP           )
        IPERF_MSG( WM_NCMBUTTONDBLCLK       )
        IPERF_MSG( WM_KEYDOWN               )
        IPERF_MSG( WM_KEYUP                 )
        IPERF_MSG( WM_CHAR                  )
        IPERF_MSG( WM_DEADCHAR              )
        IPERF_MSG( WM_SYSKEYDOWN            )
        IPERF_MSG( WM_SYSKEYUP              )
        IPERF_MSG( WM_SYSCHAR               )
        IPERF_MSG( WM_SYSDEADCHAR           )
        IPERF_MSG( WM_IME_STARTCOMPOSITION  )
        IPERF_MSG( WM_IME_ENDCOMPOSITION    )
        IPERF_MSG( WM_IME_COMPOSITION       )
        IPERF_MSG( WM_INITDIALOG            )
        IPERF_MSG( WM_COMMAND               )
        IPERF_MSG( WM_SYSCOMMAND            )
        IPERF_MSG( WM_TIMER                 )
        IPERF_MSG( WM_HSCROLL               )
        IPERF_MSG( WM_VSCROLL               )
        IPERF_MSG( WM_INITMENU              )
        IPERF_MSG( WM_INITMENUPOPUP         )
        IPERF_MSG( WM_MENUSELECT            )
        IPERF_MSG( WM_MENUCHAR              )
        IPERF_MSG( WM_ENTERIDLE             )
        IPERF_MSG( WM_CTLCOLORMSGBOX        )
        IPERF_MSG( WM_CTLCOLOREDIT          )
        IPERF_MSG( WM_CTLCOLORLISTBOX       )
        IPERF_MSG( WM_CTLCOLORBTN           )
        IPERF_MSG( WM_CTLCOLORDLG           )
        IPERF_MSG( WM_CTLCOLORSCROLLBAR     )
        IPERF_MSG( WM_CTLCOLORSTATIC        )
        IPERF_MSG( WM_MOUSEMOVE             )
        IPERF_MSG( WM_LBUTTONDOWN           )
        IPERF_MSG( WM_LBUTTONUP             )
        IPERF_MSG( WM_LBUTTONDBLCLK         )
        IPERF_MSG( WM_RBUTTONDOWN           )
        IPERF_MSG( WM_RBUTTONUP             )
        IPERF_MSG( WM_RBUTTONDBLCLK         )
        IPERF_MSG( WM_MBUTTONDOWN           )
        IPERF_MSG( WM_MBUTTONUP             )
        IPERF_MSG( WM_MBUTTONDBLCLK         )
        IPERF_MSG( WM_PARENTNOTIFY          )
        IPERF_MSG( WM_ENTERMENULOOP         )
        IPERF_MSG( WM_EXITMENULOOP          )
        IPERF_MSG( WM_NEXTMENU              )
        IPERF_MSG( WM_SIZING                )
        IPERF_MSG( WM_CAPTURECHANGED        )
        IPERF_MSG( WM_MOVING                )
        IPERF_MSG( WM_POWERBROADCAST        )
        IPERF_MSG( WM_DEVICECHANGE          )
        IPERF_MSG( WM_IME_SETCONTEXT        )
        IPERF_MSG( WM_IME_NOTIFY            )
        IPERF_MSG( WM_IME_CONTROL           )
        IPERF_MSG( WM_IME_COMPOSITIONFULL   )
        IPERF_MSG( WM_IME_SELECT            )
        IPERF_MSG( WM_IME_CHAR              )
        IPERF_MSG( WM_IME_KEYDOWN           )
        IPERF_MSG( WM_IME_KEYUP             )
        IPERF_MSG( WM_MDICREATE             )
        IPERF_MSG( WM_MDIDESTROY            )
        IPERF_MSG( WM_MDIACTIVATE           )
        IPERF_MSG( WM_MDIRESTORE            )
        IPERF_MSG( WM_MDINEXT               )
        IPERF_MSG( WM_MDIMAXIMIZE           )
        IPERF_MSG( WM_MDITILE               )
        IPERF_MSG( WM_MDICASCADE            )
        IPERF_MSG( WM_MDIICONARRANGE        )
        IPERF_MSG( WM_MDIGETACTIVE          )
        IPERF_MSG( WM_MDISETMENU            )
        IPERF_MSG( WM_ENTERSIZEMOVE         )
        IPERF_MSG( WM_EXITSIZEMOVE          )
        IPERF_MSG( WM_DROPFILES             )
        IPERF_MSG( WM_MDIREFRESHMENU        )
        IPERF_MSG( WM_CUT                   )
        IPERF_MSG( WM_COPY                  )
        IPERF_MSG( WM_PASTE                 )
        IPERF_MSG( WM_CLEAR                 )
        IPERF_MSG( WM_UNDO                  )
        IPERF_MSG( WM_RENDERFORMAT          )
        IPERF_MSG( WM_RENDERALLFORMATS      )
        IPERF_MSG( WM_DESTROYCLIPBOARD      )
        IPERF_MSG( WM_DRAWCLIPBOARD         )
        IPERF_MSG( WM_PAINTCLIPBOARD        )
        IPERF_MSG( WM_VSCROLLCLIPBOARD      )
        IPERF_MSG( WM_SIZECLIPBOARD         )
        IPERF_MSG( WM_ASKCBFORMATNAME       )
        IPERF_MSG( WM_CHANGECBCHAIN         )
        IPERF_MSG( WM_HSCROLLCLIPBOARD      )
        IPERF_MSG( WM_QUERYNEWPALETTE       )
        IPERF_MSG( WM_PALETTEISCHANGING     )
        IPERF_MSG( WM_PALETTECHANGED        )
        IPERF_MSG( WM_HOTKEY                )
        IPERF_MSG( WM_PRINT                 )
        IPERF_MSG( WM_PRINTCLIENT           )
        IPERF_MSG( WM_HANDHELDFIRST         )
        IPERF_MSG( WM_HANDHELDLAST          )
        IPERF_MSG( WM_AFXFIRST              )
        IPERF_MSG( WM_AFXLAST               )
        IPERF_MSG( WM_PENWINFIRST           )
        IPERF_MSG( WM_PENWINLAST            )
      #endif //IC_WIN
      #ifdef IC_PM
        IPERF_MSG( WM_NULL                    )
        IPERF_MSG( WM_CREATE                  )
        IPERF_MSG( WM_DESTROY                 )
        IPERF_MSG( WM_ENABLE                  )
        IPERF_MSG( WM_SHOW                    )
        IPERF_MSG( WM_MOVE                    )
        IPERF_MSG( WM_SIZE                    )
        IPERF_MSG( WM_ADJUSTWINDOWPOS         )
        IPERF_MSG( WM_CALCVALIDRECTS          )
        IPERF_MSG( WM_SETWINDOWPARAMS         )
        IPERF_MSG( WM_QUERYWINDOWPARAMS       )
        IPERF_MSG( WM_HITTEST                 )
        IPERF_MSG( WM_ACTIVATE                )
        IPERF_MSG( WM_SETFOCUS                )
        IPERF_MSG( WM_SETSELECTION            )
        IPERF_MSG( WM_PPAINT                  )
        IPERF_MSG( WM_PSETFOCUS               )
        IPERF_MSG( WM_PSYSCOLORCHANGE         )
        IPERF_MSG( WM_PSIZE                   )
        IPERF_MSG( WM_PACTIVATE               )
        IPERF_MSG( WM_PCONTROL                )
        IPERF_MSG( WM_COMMAND                 )
        IPERF_MSG( WM_SYSCOMMAND              )
        IPERF_MSG( WM_HELP                    )
        IPERF_MSG( WM_PAINT                   )
        IPERF_MSG( WM_CLOSE                   )
        IPERF_MSG( WM_QUIT                    )
        IPERF_MSG( WM_SYSCOLORCHANGE          )
        IPERF_MSG( WM_SYSVALUECHANGED         )
        IPERF_MSG( WM_APPTERMINATENOTIFY      )
        IPERF_MSG( WM_PRESPARAMCHANGED        )
        IPERF_MSG( WM_CONTROL                 )
        IPERF_MSG( WM_VSCROLL                 )
        IPERF_MSG( WM_HSCROLL                 )
        IPERF_MSG( WM_INITMENU                )
        IPERF_MSG( WM_MENUSELECT              )
        IPERF_MSG( WM_MENUEND                 )
        IPERF_MSG( WM_DRAWITEM                )
        IPERF_MSG( WM_MEASUREITEM             )
        IPERF_MSG( WM_CONTROLPOINTER          )
        IPERF_MSG( WM_QUERYDLGCODE            )
        IPERF_MSG( WM_INITDLG                 )
        IPERF_MSG( WM_SUBSTITUTESTRING        )
        IPERF_MSG( WM_MATCHMNEMONIC           )
        IPERF_MSG( WM_SAVEAPPLICATION         )
        IPERF_MSG( WM_MOUSEMOVE               )
        IPERF_MSG( WM_BUTTON1DOWN             )
        IPERF_MSG( WM_BUTTON1UP               )
        IPERF_MSG( WM_BUTTON1DBLCLK           )
        IPERF_MSG( WM_BUTTON2DOWN             )
        IPERF_MSG( WM_BUTTON2UP               )
        IPERF_MSG( WM_BUTTON2DBLCLK           )
        IPERF_MSG( WM_CHAR                    )
        IPERF_MSG( WM_VIOCHAR                 )
        IPERF_MSG( SM_SETHANDLE               )
        IPERF_MSG( SM_QUERYHANDLE             )
        IPERF_MSG( WM_MSGBOXINIT              )
        IPERF_MSG( WM_MSGBOXDISMISS           )
        IPERF_MSG( BM_CLICK                   )
        IPERF_MSG( BM_QUERYCHECKINDEX         )
        IPERF_MSG( BM_QUERYHILITE             )
        IPERF_MSG( BM_SETHILITE               )
        IPERF_MSG( BM_QUERYCHECK              )
        IPERF_MSG( BM_SETCHECK                )
        IPERF_MSG( BM_SETDEFAULT              )
        IPERF_MSG( CBM_SHOWLIST               )
        IPERF_MSG( CBM_HILITE                 )
        IPERF_MSG( CBM_ISLISTSHOWING          )
        IPERF_MSG( EM_QUERYCHANGED            )
        IPERF_MSG( EM_QUERYSEL                )
        IPERF_MSG( EM_SETSEL                  )
        IPERF_MSG( EM_SETTEXTLIMIT            )
        IPERF_MSG( EM_CLEAR                   )
        IPERF_MSG( EM_QUERYFIRSTCHAR          )
        IPERF_MSG( EM_SETFIRSTCHAR            )
        IPERF_MSG( LM_QUERYITEMCOUNT          )
        IPERF_MSG( LM_INSERTITEM              )
        IPERF_MSG( LM_SETTOPINDEX             )
        IPERF_MSG( LM_DELETEITEM              )
        IPERF_MSG( LM_SELECTITEM              )
        IPERF_MSG( LM_QUERYSELECTION          )
        IPERF_MSG( LM_SETITEMTEXT             )
        IPERF_MSG( LM_QUERYITEMTEXTLENGTH     )
        IPERF_MSG( LM_QUERYITEMTEXT           )
        IPERF_MSG( LM_SETITEMHANDLE           )
        IPERF_MSG( LM_QUERYITEMHANDLE         )
        IPERF_MSG( LM_SEARCHSTRING            )
        IPERF_MSG( LM_SETITEMHEIGHT           )
        IPERF_MSG( LM_QUERYTOPINDEX           )
        IPERF_MSG( LM_DELETEALL               )
        IPERF_MSG( LM_INSERTMULTITEMS         )
        IPERF_MSG( LM_SETITEMWIDTH            )
        IPERF_MSG( MM_INSERTITEM              )
        IPERF_MSG( MM_DELETEITEM              )
        IPERF_MSG( MM_QUERYITEM               )
        IPERF_MSG( MM_SETITEM                 )
        IPERF_MSG( MM_QUERYITEMCOUNT          )
        IPERF_MSG( MM_STARTMENUMODE           )
        IPERF_MSG( MM_ENDMENUMODE             )
        IPERF_MSG( MM_REMOVEITEM              )
        IPERF_MSG( MM_SELECTITEM              )
        IPERF_MSG( MM_QUERYSELITEMID          )
        IPERF_MSG( MM_QUERYITEMTEXT           )
        IPERF_MSG( MM_QUERYITEMTEXTLENGTH     )
        IPERF_MSG( MM_SETITEMHANDLE           )
        IPERF_MSG( MM_SETITEMTEXT             )
        IPERF_MSG( MM_ITEMPOSITIONFROMID      )
        IPERF_MSG( MM_ITEMIDFROMPOSITION      )
        IPERF_MSG( MM_QUERYITEMATTR           )
        IPERF_MSG( MM_SETITEMATTR             )
        IPERF_MSG( MM_ISITEMVALID             )
        IPERF_MSG( MM_QUERYITEMRECT           )
        IPERF_MSG( MM_QUERYDEFAULTITEMID      )
        IPERF_MSG( MM_SETDEFAULTITEMID        )
        IPERF_MSG( SBM_SETSCROLLBAR           )
        IPERF_MSG( SBM_SETPOS                 )
        IPERF_MSG( SBM_QUERYPOS               )
        IPERF_MSG( SBM_QUERYRANGE             )
        IPERF_MSG( SBM_SETTHUMBSIZE           )
        IPERF_MSG( WM_FLASHWINDOW             )
        IPERF_MSG( WM_FORMATFRAME             )
        IPERF_MSG( WM_UPDATEFRAME             )
        IPERF_MSG( WM_FOCUSCHANGE             )
        IPERF_MSG( WM_SETBORDERSIZE           )
        IPERF_MSG( WM_TRACKFRAME              )
        IPERF_MSG( WM_MINMAXFRAME             )
        IPERF_MSG( WM_SETICON                 )
        IPERF_MSG( WM_QUERYICON               )
        IPERF_MSG( WM_SETACCELTABLE           )
        IPERF_MSG( WM_QUERYACCELTABLE         )
        IPERF_MSG( WM_TRANSLATEACCEL          )
        IPERF_MSG( WM_QUERYTRACKINFO          )
        IPERF_MSG( WM_QUERYBORDERSIZE         )
        IPERF_MSG( WM_NEXTMENU                )
        IPERF_MSG( WM_ERASEBACKGROUND         )
        IPERF_MSG( WM_QUERYFRAMEINFO          )
        IPERF_MSG( WM_QUERYFOCUSCHAIN         )
        IPERF_MSG( WM_OWNERPOSCHANGE          )
        IPERF_MSG( WM_CALCFRAMERECT           )
        IPERF_MSG( WM_WINDOWPOSCHANGED        )
        IPERF_MSG( WM_ADJUSTFRAMEPOS          )
        IPERF_MSG( WM_QUERYFRAMECTLCOUNT      )
        IPERF_MSG( WM_RENDERFMT               )
        IPERF_MSG( WM_RENDERALLFMTS           )
        IPERF_MSG( WM_DESTROYCLIPBOARD        )
        IPERF_MSG( WM_PAINTCLIPBOARD          )
        IPERF_MSG( WM_SIZECLIPBOARD           )
        IPERF_MSG( WM_HSCROLLCLIPBOARD        )
        IPERF_MSG( WM_VSCROLLCLIPBOARD        )
        IPERF_MSG( WM_DRAWCLIPBOARD           )
        IPERF_MSG( WM_DDE_INITIATE            )
        IPERF_MSG( WM_DDE_REQUEST             )
        IPERF_MSG( WM_DDE_ACK                 )
        IPERF_MSG( WM_DDE_DATA                )
        IPERF_MSG( WM_DDE_ADVISE              )
        IPERF_MSG( WM_DDE_UNADVISE            )
        IPERF_MSG( WM_DDE_POKE                )
        IPERF_MSG( WM_DDE_EXECUTE             )
        IPERF_MSG( WM_DDE_TERMINATE           )
        IPERF_MSG( WM_DDE_INITIATEACK         )
        IPERF_MSG( WM_QUERYCONVERTPOS         )
      #endif //IC_PM
      }
   if (msgtext)
     PERF( msgtext );
#endif
#endif //IC_PMWIN
}

/*------------------------------------------------------------------------------
| IWindow::handleForChildCreation                                              |
------------------------------------------------------------------------------*/
IWindowHandle IWindow::handleForChildCreation( ) const
{
  return handle();
}

#ifdef IC_MOTIFWIN
// Common color code, windows and motif
/*------------------------------------------------------------------------------
| IWindow::setForegroundColor                                                  |
|                                                                              |
| Sets the foreground color of the window.                                     |
------------------------------------------------------------------------------*/
IWindow& IWindow::setForegroundColor (const IColor &color )
{
  // set flag that color has been set..
  pWindowData->state |= frgndColorWasSet;
  // save the previous color for a reset.
  pWindowData->fPrevForegroundColor = foregroundColor();

  // setColor will set the color and also push the color changes down to the
  // children.
  setColor( PP_FOREGROUNDCOLOR, color );

  /**************************************************************/
  /* Visually update the window                                 */
  /**************************************************************/
  setLayoutDistorted(IWindow::colorChanged, 0);
#ifdef IC_WIN
  refresh();
#endif
  /**************************************************************/
  /* Send private message to support window notify handler      */
  /* because Windows does not have presparam messages           */
  /**************************************************************/
  this->sendEvent( IC_UM_DELAYNOTIFY,
                   IEventParameter1( (unsigned long) PP_FOREGROUNDCOLOR ),
                   IEventParameter2( IC_NOTDEL_WINDOW_COLOR ));

#ifdef IC_MOTIF
  // notify observers.
  //this->notifyObservers(INotificationEvent(IWindow::foregroundColorId, *this));
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::setBackgroundColor                                                  |
|                                                                              |
| Sets the background color of the window.                                     |
------------------------------------------------------------------------------*/
IWindow& IWindow::setBackgroundColor (const IColor &color )
{
  ITRACE_DEVELOP("IWindow::setBackgroundColor(" +
                    IString(color.asRGBLong()).d2x());

  // save the previous color for a reset.
  pWindowData->fPrevBackgroundColor = backgroundColor();
  // set flag that color has been set..
  pWindowData->state |= bkgndColorWasSet;


  // setColor will set the color and also push the color changes down to the
  // children.
  setColor( PP_BACKGROUNDCOLOR, color );

  /**************************************************************/
  /* Visually update the window                                 */
  /**************************************************************/
  setLayoutDistorted(IWindow::colorChanged, 0);
#ifdef IC_WIN
  refresh();
#endif
  /**************************************************************/
  /* Send private message to support window notify handler      */
  /* because Windows does not have presparam messages           */
  /**************************************************************/
  this->sendEvent( IC_UM_DELAYNOTIFY,
                   IEventParameter1( (unsigned long) PP_BACKGROUNDCOLOR ),
                   IEventParameter2( IC_NOTDEL_WINDOW_COLOR ));

#ifdef IC_MOTIF
  // notify observers.
  //this->notifyObservers(INotificationEvent(IWindow::backgroundColorId, *this));
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::propagateColorToChildren                                  |
|                                                                              |
------------------------------------------------------------------------------*/
void IWindow::propagateColorToChildren (unsigned long colorArea,
                                        const IColor &color )
{
  // recursively call the setBacgroundColor member function on the children
  // to give them the chance to inherit the color.
  IWindow::ChildCursor cursor( *this );
  for (cursor.setToFirst();cursor.isValid();cursor.setToNext() )
  {
    IWindow *win = childWindowAt( cursor );
    if (win)
    {
      switch( colorArea )
      {
        case PP_FOREGROUNDCOLOR:
          if ( !(win->pWindowData->state & frgndColorWasSet ) )
          {
            const IInheritColorAttribute* inheritColorAttr;

            const IAttribute *attr =
              win->attributeWithName( IAttributeName("IInheritColorAttribute") );
            if (attr)
            {
              inheritColorAttr =
                dynamic_cast<const IInheritColorAttribute*>(attr);
              if (inheritColorAttr)    // Process window alignment attribute
              {
                // we have found an inheritColorAttribute. Now lets see what
                // colors the control inherits.
                IInheritColorAttribute::EInheritColor fInheritedColors =
                  inheritColorAttr->inheritColor();
                if ( (fInheritedColors ==
                          IInheritColorAttribute::kForegroundColor) ||
                     (fInheritedColors ==
                          IInheritColorAttribute::kForegroundAndBackgroundColor ))
                {
                  win->setColor( PP_FOREGROUNDCOLOR, color );
                }
              }
            }
            else
            {
              // if the InheritAttribute in not found then we assume that all
              // supported colors are inherited.
              win->setColor( PP_FOREGROUNDCOLOR, color );
            }
          }
          break;
        case PP_BACKGROUNDCOLOR:
          if ( !(win->pWindowData->state & bkgndColorWasSet ) )
          {
            const IInheritColorAttribute* inheritColorAttr;

            const IAttribute *attr =
              win->attributeWithName( IAttributeName("IInheritColorAttribute") );
            if (attr)
            {
              inheritColorAttr =
                dynamic_cast<const IInheritColorAttribute*>(attr);
              if (inheritColorAttr)    // Process window alignment attribute
              {
                // we have found an inheritColorAttribute. Now lets see what
                // colors the control inherits.
                IInheritColorAttribute::EInheritColor fInheritedColors =
                  inheritColorAttr->inheritColor();
                if ( (fInheritedColors ==
                          IInheritColorAttribute::kBackgroundColor) ||
                     (fInheritedColors ==
                          IInheritColorAttribute::kForegroundAndBackgroundColor ))
                {
                  win->setColor( PP_BACKGROUNDCOLOR, color );
                }
              }
            }
            else
            {
              // if the InheritAttribute in not found then we assume that all
              // supported colors are inherited.
              win->setColor( PP_BACKGROUNDCOLOR, color );
            }
          }
          break;
      }
    }
  }
}


/*------------------------------------------------------------------------------
| IWindow::setColor                                                            |
|                                                                              |
| Change the window attribute color using Red, Green and                       |
| Blue mix.                                                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::setColor(unsigned long ulColorArea, const IColor& color)
{

  if (ulColorArea == PP_FOREGROUNDCOLOR)
  {
#ifdef IC_MOTIF
    // now set the color.
    XtVaSetValues( this->handle(),
                   XmNforeground, color.index(),
                   NULL );
#endif
#ifdef IC_WIN
    this->pWindowData->clrforeground = color;
#endif
    // setForegroundColor( color );
  }
  if (ulColorArea == PP_BACKGROUNDCOLOR)
  {
#ifdef IC_MOTIF
    // now set the color.
    IXmColor::setBackgroundColor( this->handle(), color.index() );
#endif // IC_MOITF
#ifdef IC_WIN

    // free old color.
    IBrushManager::freeBrush( pWindowData->clrbackground );

    // save color for paint handler.
    pWindowData->clrbackground = color;

    // and increment use count for new brush
    HBRUSH hBr = IBrushManager::findBrush( color );
    IBrushManager::useBrush( hBr );

#endif
  }
  propagateColorToChildren( ulColorArea, color );

  /**************************************************************/
  /* Visually update the window                                 */
  /**************************************************************/
  setLayoutDistorted(IWindow::colorChanged, 0);
#ifdef IC_WIN
  //refresh();
#endif
  /**************************************************************/
  /* Send private message to support window notify handler      */
  /* because Windows does not have presparam messages           */
  /**************************************************************/
  this->sendEvent( IC_UM_DELAYNOTIFY,
                   IEventParameter1( ulColorArea ),
                   IEventParameter2( IC_NOTDEL_WINDOW_COLOR ));
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::resetColor                                                            |
|                                                                              |
| Change the window attribute color using Red, Green and                       |
| Blue mix.                                                                    |
------------------------------------------------------------------------------*/
IWindow& IWindow::resetColor( unsigned long colorArea )
{
  switch (colorArea)
  {
    case PP_FOREGROUNDCOLOR:
    {
      // if the color was set then reset it and remove the flag
      if (pWindowData->state & frgndColorWasSet)
      {
        // now set the color to the previous color and propagate the
        // changes down.
        IColor fColor = pWindowData->fPrevForegroundColor;
        setForegroundColor( fColor );
        // since this color is reset remove flag that it was set.
        pWindowData->state &= ~(unsigned long) frgndColorWasSet;
      }
      break;
    }
    case PP_BACKGROUNDCOLOR:
    {
      if (pWindowData->state & bkgndColorWasSet)
      {

        // now set the color to the previous color and propagate the
        // changes down.
        IColor fColor = pWindowData->fPrevBackgroundColor;
        setBackgroundColor( fColor );
        // since this color is reset remove flag that it was set.
        pWindowData->state &= ~(unsigned long )bkgndColorWasSet;
      }
      break;
    }
  }
  return *this;
}


/*------------------------------------------------------------------------------
| IWindow::color                                                               |
|                                                                              |
| Return the color of window attribute.                                        |
------------------------------------------------------------------------------*/
IColor IWindow::color(unsigned long ulColorArea) const
{
   IColor clr( 0, 0, 0 );

   if (ulColorArea == PP_FOREGROUNDCOLOR)
   {
     clr = pWindowData->clrforeground;
   }
   else if ( ulColorArea == PP_BACKGROUNDCOLOR )
   {
     clr = pWindowData->clrbackground;
   }
   return clr;
}

/*------------------------------------------------------------------------------
| IWindow::color                                                               |
|                                                                              |
| Return the color of window attribute.                                        |
------------------------------------------------------------------------------*/
IColor IWindow::color(unsigned long ulColorArea, const IColor& defaultColor) const
{
  return this->color( ulColorArea );
/*
  if ( ulColorArea == PP_FOREGROUNDCOLOR )
  {
    if ( pWindowData->state & frgndColorWasSet )
      return (pWindowData->clrforeground);
    else
      return defaultColor;
  }
  else if ( ulColorArea == PP_BACKGROUNDCOLOR )
  {
    if ( pWindowData->state & bkgndColorWasSet )
      return (pWindowData->clrbackground);
    else
      return defaultColor;
  }
  else
  {
    return defaultColor;
  }
*/
}

#endif // IC_MOTIFWIN

/*------------------------------------------------------------------------------
| IWindow::startHandling                                                       |
|                                                                              |
| Enable event processing on the window for the specified event type.          |
------------------------------------------------------------------------------*/
IWindow& IWindow::startHandling ( const EventMask& events )
{
  // Serialize this function with IWindow::stopHandling.
  IGUIResourceLock
    windowLock( IWindowList::libraryKey() );

#ifdef IC_MOTIF
  long
    newEvents = 0;
#endif

  if ( events & IWindow::someMouseMoves )
  {
     pWindowData->fSomeMouseMovesCount++;
#ifdef IC_MOTIF
     if ( pWindowData->fSomeMouseMovesCount == 1 )
     {  // Enabled for the first time.
        long
          eventMask = XtBuildEventMask( (Widget) this->handle() );
        if ( !( eventMask & PointerMotionHintMask )  &&
             ( eventMask & ( PointerMotionMask |
                             Button1MotionMask |
                             Button2MotionMask |
                             Button3MotionMask |
                             Button4MotionMask |
                             Button5MotionMask ) ) )
        {  // Widget expects to process all mouse motion events
           // (either with or without a mouse button pressed).
           // Don't select pointer-motion-hint, because this
           // prevents the widget from receiving these motion events.
           if ( pWindowData->fAllMouseMovesCount == 0 )
           {
              newEvents |= PointerMotionMask;
           }
        }
        else
        {  // Select pointer-motion-hint events.
           newEvents |= ( PointerMotionMask | PointerMotionHintMask );
        }
     }
#endif
  }

  if ( events & IWindow::allMouseMoves )
  {
     pWindowData->fAllMouseMovesCount++;
#ifdef IC_MOTIF
     if ( pWindowData->fAllMouseMovesCount ==  1 )
     {  // Enabled for the first time.
        newEvents |= PointerMotionMask;
        if ( newEvents & PointerMotionHintMask )
        {  // We want all events, not just some.
           newEvents &= ~PointerMotionHintMask;
        }
     }
#endif
  }

  if ( events & IWindow::mouseEntersLeaves )
  {
     pWindowData->fMouseEntersLeavesCount++;
#ifdef IC_MOTIF
     if ( pWindowData->fMouseEntersLeavesCount == 1 )
     {  // Enabled for the first time.
        newEvents |= ( EnterWindowMask | LeaveWindowMask );
     }
#endif
  }

#ifdef IC_MOTIF
  // Ensure that the IWindow callback routine is called to process the
  // new mouse-movement messages (it already is called to handle other
  // types of events, routing them to IWindow::dispatch).
  if ( newEvents )
  {
     // Remove the hint mask if we want to see all mouse-movement
     // events.  Otherwise we will only see some of them.
     if ( ( newEvents & PointerMotionMask )  &&
          ( ! ( newEvents & PointerMotionHintMask ) ) )
     {
        long
          oldEvents = XtBuildEventMask( (Widget) this->handle() );
        if ( oldEvents & PointerMotionHintMask )
        {
           XtRemoveEventHandler( (Widget) this->handle(),
                                 PointerMotionHintMask,
                                 False,
                                 iwindowXEventCallback,
                                 (XtPointer*) this );
        }
     }

     XtAddEventHandler( (Widget) this->handle(),
                        newEvents,
                        False,
                        iwindowXEventCallback,
                        (XtPointer*) this );
  }
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::stopHandling                                                        |
|                                                                              |
| Disable event processing on the window for the specified event type.         |
------------------------------------------------------------------------------*/
IWindow& IWindow::stopHandling ( const EventMask& events )
{
  // Serialize this function with IWindow::startHandling.
  IGUIResourceLock
    windowLock( IWindowList::libraryKey() );

#ifdef IC_MOTIF
  long
    eventsToStop = 0;
#endif

  if ( events & IWindow::someMouseMoves )
  {
     if ( pWindowData->fSomeMouseMovesCount )
     {
        pWindowData->fSomeMouseMovesCount--;
     }
#ifdef IC_MOTIF
     if ( pWindowData->fSomeMouseMovesCount == 0 )
     {  // Time to disable processing of the events.
        eventsToStop |= ( PointerMotionMask | PointerMotionHintMask );
     }
#endif
  }

  if ( events & IWindow::allMouseMoves )
  {
     if ( pWindowData->fAllMouseMovesCount )
     {
        pWindowData->fAllMouseMovesCount--;
     }
#ifdef IC_MOTIF
     if ( pWindowData->fAllMouseMovesCount == 0 )
     {  // Time to disable processing of the events (also disable
        // someMouseMoves).
        eventsToStop |= ( PointerMotionMask | PointerMotionHintMask );
     }
#endif
  }

  if ( events & IWindow::mouseEntersLeaves )
  {
     if ( pWindowData->fMouseEntersLeavesCount )
     {
        pWindowData->fMouseEntersLeavesCount--;
     }
#ifdef IC_MOTIF
     if ( pWindowData->fMouseEntersLeavesCount == 0 )
     {  // Time to disable processing of the events.
        eventsToStop |= ( EnterWindowMask | LeaveWindowMask );
     }
#endif
  }

#ifdef IC_MOTIF
  if ( eventsToStop )
  {
    if (this->isValid() )
    {
       XtRemoveEventHandler( (Widget) this->handle(),
                             eventsToStop,
                             False,
                             iwindowXEventCallback,
                             (XtPointer*) this );
    }
  }
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::isHandling                                                          |
|                                                                              |
| Queries if any event handler objects attached to the window will be called   |
| to process any of the specified event types.                                 |
------------------------------------------------------------------------------*/
bool IWindow::isHandling ( const EventMask& events ) const
{
  bool
    handlingEvent = false;

  if ( ( events & IWindow::someMouseMoves )  &&
       pWindowData->fSomeMouseMovesCount )
  {
     handlingEvent = true;
  }

  else if ( ( events & IWindow::allMouseMoves )  &&
            pWindowData->fAllMouseMovesCount )
  {
     handlingEvent = true;
  }
  else if ( ( events & IWindow::mouseEntersLeaves )  &&
            pWindowData->fMouseEntersLeavesCount )
  {
     handlingEvent = true;
  }

  return handlingEvent;
}

/*------------------------------------------------------------------------------
| IWindow::isHandling                                                          |
|                                                                              |
| Queries if any event handler objects attached to the window will be called   |
| to process the specified event type.                                         |
------------------------------------------------------------------------------*/
bool IWindow::isHandling ( unsigned long eventId ) const
{
  bool
    handlingEvent = true;

  switch ( eventId )
  {
#ifdef IC_PMWIN
     case WM_MOUSEMOVE:
#endif
#ifdef IC_MOTIF
     case xEvent( MotionNotify ):
#endif
     {
        handlingEvent = this->isHandling( IWindow::someMouseMoves
                                           | IWindow::allMouseMoves );
        break;
     }
#ifdef IC_PM
     case WM_MOUSEENTER:
     case WM_MOUSELEAVE:
#endif
#ifdef IC_WIN
     case WM_MOUSEENTER:
     case IC_UM_MOUSELEAVE:
#endif
#ifdef IC_MOTIF
     case xEvent( EnterNotify ):
     case xEvent( LeaveNotify ):
#endif
     {
        handlingEvent = this->isHandling( IWindow::mouseEntersLeaves );
        break;
     }
     default:
        break;
  }

  return handlingEvent;
}


/*------------------------------------------------------------------------------
| IWindow::invalidateRect()                                                    |
|                                                                              |
------------------------------------------------------------------------------*/
IRectangle IWindow::invalidatedRect() const
{
  IRectangle fNativeRect;
#ifdef IC_WIN
  RECT rct;
  GetUpdateRect( this->handle(), &rct, false );
  fNativeRect = IRectangle( rct.left, rct.top, rct.right, rct.bottom );
#endif
#ifdef IC_PM
  RECTL rcl;
  WinQueryUpdateRect( this->handle(), &rcl );
  if ( (rcl.xLeft != rcl.xRight )  &&  ( rcl.yBottom != rcl.yTop ) )
  {  // Non-null rectangle.
     fNativeRect = IRectangle( rcl.xLeft, rcl.yBottom,
                               rcl.xRight, rcl.yTop );
  }
#endif
#ifdef IC_MOTIF
  XRectangle fClipBox;
  if (pWindowData->fInvalidatedRegion != IRegionHandle() )
  {
    XClipBox( (Region)(void *)pWindowData->fInvalidatedRegion.asUnsigned(),
              &fClipBox );
    fNativeRect= IRectangle( IPoint( fClipBox.x,fClipBox.y),
                           ISize(fClipBox.width,fClipBox.height ));
  }
#endif
  return fNativeRect;
}

/*------------------------------------------------------------------------------
| IWindow::invalidateRegion()                                                    |
|                                                                              |
------------------------------------------------------------------------------*/
IRegionHandle IWindow::invalidatedRegion() const
{
  IRegionHandle fInvalidatedRegion;
#ifdef IC_WIN
    if (pWindowData->fInvalidatedRegion == IRegionHandle() )
    {
      pWindowData->fInvalidatedRegion = IRegionHandle( CreateRectRgn ( 0,0,0,0 ));
      GetUpdateRgn( this->handle(),
                    pWindowData->fInvalidatedRegion,
                    false );
    }
#endif
#ifdef IC_PM
    RECTL rcl;
    long int fStatus;
    IPresSpaceHandle fPresSpace(presSpace() );
    pWindowData->fInvalidatedRegion = IRegionHandle(
        GpiCreateRegion( fPresSpace , 0, &rcl ));
    releasePresSpace(fPresSpace);

    if (pWindowData->fInvalidatedRegion == RGN_ERROR )
        ITHROWGUIERROR( "GpiCreateRegion" );
    fStatus = WinQueryUpdateRegion( this->handle(),
                                      pWindowData->fInvalidatedRegion );
    if (fStatus == RGN_ERROR )
        ITHROWGUIERROR( "WinQueryUpdateRegion" );
#endif
  return pWindowData->fInvalidatedRegion;
}

/*------------------------------------------------------------------------------
| IWindow::validateRect()                                                    |
|                                                                              |
------------------------------------------------------------------------------*/
IWindow& IWindow::validateRect( const IRectangle &validatedRectangle)
{
#ifdef IC_WIN
  RECTL  rct = validatedRectangle.asRECTL();
  IVALIDATERECT(this->handle(),(RECT*)(&rct) );
#endif
#ifdef IC_PM
  RECTL  rct = validatedRectangle.asRECTL();
  IVALIDATERECT(this->handle(), &rct );
#endif
#ifdef IC_MOTIF
  if (pWindowData->fInvalidatedRegion != IRegionHandle() )
  {
    Region fUnionRegion( XCreateRegion() );
    IRectangle fValidatedRectangle( validatedRectangle );

    if ( ICoordinateSystem::isConversionNeeded() )
    {
      // convert the rect to native coordinates
      ISize fParentSize = parentSize();
      fValidatedRectangle = ICoordinateSystem::convertToNative( fValidatedRectangle,
                                                              size() );
    }

    XRectangle fXValidatedRect;
    fXValidatedRect.x      = fValidatedRectangle.minX();
    fXValidatedRect.y      = fValidatedRectangle.minY();
    fXValidatedRect.width  = fValidatedRectangle.size().width();
    fXValidatedRect.height = fValidatedRectangle.size().height();
    XUnionRectWithRegion( &fXValidatedRect,
                          fUnionRegion,
                          fUnionRegion );

    validateRegion( fUnionRegion );
    XDestroyRegion( fUnionRegion );
  }
#endif

  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::validateRegion()                                                    |
|                                                                              |
------------------------------------------------------------------------------*/
IWindow &IWindow::validateRegion( const IRegionHandle &validatedRegion)
{
#ifdef IC_WIN
#endif
#ifdef IC_PM
#endif
#ifdef IC_MOTIF
  if (pWindowData->fInvalidatedRegion != IRegionHandle() )
  {
    XIntersectRegion( (Region)pWindowData->fInvalidatedRegion.asUnsigned(),
                      (Region)validatedRegion.asUnsigned(),
                      (Region)pWindowData->fInvalidatedRegion.asUnsigned());
  }
#endif
  return *this;
}

/*------------------------------------------------------------------------------
| IWindow::mousePointer                                                        |
|                                                                              |
| Return the handle used to set the mouse pointer when it is over the window.  |
------------------------------------------------------------------------------*/
IPointerHandle IWindow::mousePointer ( ) const
{
  return pWindowData->fMousePtr;
}

/*------------------------------------------------------------------------------
| IWindow::setMousePointer                                                     |
|                                                                              |
| Set the handle of the mouse pointer to use when the pointer is over the      |
| window.                                                                      |
------------------------------------------------------------------------------*/
IWindow& IWindow::setMousePointer ( const IPointerHandle& mousePointer )
{
  pWindowData->fMousePtr = mousePointer;

#ifdef IC_PMWIN
  if ( mousePointer )
  {
     // Attach a handler that processes WM_CONTROLPOINTER / WM_SETCURSOR
     // messages, so we can always give the mouse pointer the right pointer.
     IWindowMousePointerHandler
      *mousePointerHandler = pWindowData->fMousePointerHandler;
     if ( ! mousePointerHandler )
     {
        mousePointerHandler = new IWindowMousePointerHandler();
     }
     mousePointerHandler->handleEventsFor( this );

     // If the mouse pointer is within the window, consider changing it
     // immediately to the specified pointer (rather than wait for the
     // change to occur on the next mouse-move event).
     unsigned long
       mouseX,
       mouseY;
     IQUERYPOINTERPOSITION( mouseX, mouseY );
     IPoint
       mousePosition( mouseX, mouseY );
     if ( this->nativeRect().contains( mousePosition ) )
     {
        // Don't change the mouse pointer if it is over a window that is
        // not related to this window (our window may be covered by a
        // window from another application).  Assume that if the window
        // under the mouse pointer is a descendant window (child at any
        // level) of our window in the window hierarchy, it is ok to
        // change the mouse pointer.
        POINTL
          pt( mousePosition.asPOINTL() );
        IWindowHandle
          thisWindow( this->handle() ),
          desktopHandle( IWindow::desktopWindow()->handle() ),
          handleWithMouse( IWINDOWFROMPOINT( desktopHandle, &pt, true ) );
        bool
          done = false;
        while ( ! done )
        {
           if ( thisWindow == handleWithMouse )
           {  // The window under the mouse pointer is either this window
              // or a descendant, so change the mouse pointer now.
              ISETPOINTER( mousePointer );
              done = true;
           }
           else if ( handleWithMouse == 0  ||  handleWithMouse == desktopHandle )
           {  // We didn't find our window after walking the parent chain,
              // so don't change the mouse pointer.
              done = true;
           }
           else
           {
              handleWithMouse = IPARENTOF( handleWithMouse );
           }
        }
     }
  }
  else
  {
     // Remove the mouse pointer handler, if it exists.
     IWindowMousePointerHandler
      *mousePointerHandler = pWindowData->fMousePointerHandler;
     if ( mousePointerHandler )
     {
        mousePointerHandler->stopHandlingEventsFor( this );
     }
  }
#endif // IC_PMWIN
#ifdef IC_MOTIF
  if ( ! XtIsRealized( this->handle() ) )
  {  // Defer until the first MapNotify.
  }
  else
  {
     Display *display = XtDisplay( (Widget) this->handle() );

     Widget
       pointerWidget = (Widget) this->handleForChildCreation();
     if ( this->isFrameWindow() )
     {
        pointerWidget = XtParent( pointerWidget );
     }

     if ( mousePointer.asUnsigned() == 0 )
     {  // Remove any previously-assigned pointers.
        XUndefineCursor( display, XtWindow( pointerWidget ) );
     }
     else
     {
        IPointerData* node = IBitmapStaticPtr::pointerSet().find( mousePointer );
        if ( node )
        {
           ISize fImageSize( node->imageSize() );

           unsigned int bestWidth, bestHeight;
           if ( XQueryBestCursor( display,
                                  XtWindow( pointerWidget ),
                                  fImageSize.width(),
                                  fImageSize.height(),
                                  &bestWidth,
                                  &bestHeight ) )
           {
#ifdef IC_DEVELOP
              if ( fImageSize != ISize( bestWidth, bestHeight ) )
              {
                ITRACE_DEVELOP( "Image sizes do not match: " +
                                 fImageSize.asString() +
                                 " and the best size is " +
                                 ISize( bestWidth, bestHeight ).asString() );
              }
#endif
           }

           XColor background, foreground;
           Colormap colorMap = IApplication::current().colorMap().nativeColorMap();
           foreground.pixel = IColor( IColor::kWhite ).index();
           XQueryColor( display, colorMap, &foreground );
           background.pixel = IColor( IColor::kBlack ).index();
           XQueryColor( display, colorMap, &background );
           IPoint hotSpot( node->hotSpot() );

           Cursor
             cursor = XCreatePixmapCursor( display,
                                           (Pixmap) node->handle(),
                                           node->maskPixmap(),
                                           &foreground,
                                           &background,
                                           hotSpot.x(), hotSpot.y() );

           if ( cursor )
           {
              XDefineCursor( display, XtWindow( pointerWidget ), cursor );
              XFreeCursor( display, cursor );
           }
        }  // End have a pointer.
     }  // End setting a pointer.
  }  // End widget is realized.
#endif // IC_MOTIF

  return *this;
}
