// Revision: 45 1.52.1.4 source/ui/baseapp/iframhdr.cpp, frame, ioc.v400 
/*******************************************************************************
* FILE NAME: iframhdr.cpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the implementation of classes/functions declared        *
*   in iframhdr.hpp.                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
extern "C"
  {
  #define INCL_WINFRAMEMGR
  #define INCL_WINTRACKRECT
  #define INCL_WINWINDOWMGR
  #define INCL_WININPUT
  #define INCL_WINDIALOGS
  #include <iwindefs.h>
  #ifdef IC_PM
    #include <pmbidi.h>      // For WM_SETBIDIATTR
  #endif
  #ifdef IC_MOTIF
    #include <X11/IntrinsicP.h>
    #include <X11/Composite.h>
    #include <Xm/Protocols.h>
    #include <Xm/MwmUtil.h>
    #include <canvas.h>
    #include <Xm/MainW.h>
    #include <Xm/MainWP.h>
  #endif //IC_MOTIF
  }

#include <iframhdr.hpp>
#include <iframprv.hpp>
#include <iframevt.hpp>
#include <iswp.hpp>
#include <itrace.hpp>
#include <ibidiset.hpp>
#include <icconst.h>
#include <icolor.hpp>
#include <icontrol.hpp>
#include <iexcept.hpp>
#include <ihandle.hpp>
#include <ihelp.hpp>
#include <icmdevt.hpp>
#include <iframe.hpp>
#include <inotifev.hpp>
#include <icoordsy.hpp>
#include <isysmenu.hpp>
#include <iplatfrm.hpp>
#include <ititle.hpp>
#ifdef IC_WIN
  #include <icvhdr.hpp>
  #include <ithread.hpp>
  #include <iwcname.hpp>
  #include <iwinlsts.hpp>
#endif
#ifdef IC_MOTIF
  #include <ipushbut.hpp>
  #include <isizrect.hpp>
  #include <ikeyevt.hpp>
  #include <icmnfun.hpp>
#endif //IC_MOTIF

// Segment definitions
#ifdef IC_PAGETUNE
  #define _IFRAMHDR_CPP_
  #include <ipagetun.h>
#endif

/*------------------------------------------------------------------------------
| IFrameHandler::dispatchHandlerEvent                                          |
|                                                                              |
| Intercepts all window events and dispatches frame-specific events to the     |
| various handle event functions.                                              |
| Note: The following messages are of interest:                                |
|    For WM_CALCFRAMERECT:                                                     |
|      Dispatch the calcRect function.                                         |
|                                                                              |
|    For WM_QUERYFRAMECTLCOUNT:                                                |
|      1. Get the number of standard controls by invoking the default frame    |
|         window procedure.                                                    |
|      2. Get the number of frame extensions via a call to numberOfExtensions()|
|      3. Return the sum in the event result.                                  |
|                                                                              |
|    For WM_FORMATFRAME:                                                       |
|      Dispatch the format() function.                                         |
|                                                                              |
|    For WM_CLOSE:                                                             |
|      Dispatch the closed() function.                                         |
|                                                                              |
|    For WM_ACTIVATE:                                                          |
|      Dispatch either activated() or deactivated() based on mp1.              |
|                                                                              |
|    For WM_SAVEAPPLICATION:                                                   |
|      Dispatch saved().                                                       |
|                                                                              |
|    For WM_PAINT:                                                             |
|      Dispatch draw().                                                        |
|                                                                              |
|    For WM_COMMAND:                                                           |
|      Dispatch command();                                                     |
|                                                                              |
|    For WM_DESTROY:                                                           |
|      Call frame->removeFromWindowList();                                     |
|                                                                              |
|    For WM_DRAWITEM: or WM_MEASUREITEM:                                       |
|      Return true if already sent to client.                                  |
|                                                                              |
|    For WM_CONTROLPOINTER:                                                    |
|      Return the handle of the mouse pointer to use in the event result.      |
|                                                                              |
|    For WM_HELP:                                                              |
|      Display help for dynamically-assigned help IDs.                         |
|                                                                              |
|    This handler returns false for all other events.                          |
------------------------------------------------------------------------------*/
bool IFrameHandler::dispatchHandlerEvent ( IEvent &event )
{
  IMODTRACE_ALL("IFrameHandler::dispatchHandlerEvent");
  bool
    result = false;

  switch( event.eventId() )
  {
#ifdef IC_WIN
      case IC_UM_DLGCNTL_SETFOCUS:
      {
        //set focus

        // a control in a dialog got focus, and passed the setfocus
        // msg up to this dialog frame for review.
        //
        // if its a button then give button the focus and highlight.
        // otherwise, give default button the defstyle

        // if the user has wrappered the control with a IWindow type object
        // then we do not processes since it may be a pushbutton control
        // and its handled there.
        HWND hwndPb = (HWND)event.parameter2().asUnsignedLong();
        IWindowHandle butHnd(hwndPb);

        // does control have a wrapper
        if (IWindow::windowWithHandle(
                        hwndPb,
                        false ) )
            // yes its wrappered so do not process
            return false;

         // ok, its not wrappered, so lets do our checking.
         // Is it a button thats getting focus
         unsigned long dlgcde=  SendMessage( hwndPb, WM_QUERYDLGCODE, 0, 0 );
         if (( dlgcde & DLGC_DEFPUSHBUTTON ) ||
              ( dlgcde & DLGC_PUSHBUTTON ))
         {
            IFrameWindow* frmWnd = (IFrameWindow*)IWindow::windowWithHandle( IPARENTOF(hwndPb ));
            IWindowHandle defHnd = frmWnd->defaultEmphasisButton();
            frmWnd->setDefaultEmphasisButton(hwndPb, true);
             // set new button up as default.
            unsigned long ulStyle = ISTYLEOF(defHnd);
            defHnd.sendEvent( BM_SETSTYLE,
               (ulStyle & ~((unsigned long)BS_PRIMARYSTYLES)) |
                                           BS_PUSHBUTTON, true );

            unsigned long ulStyle1 = ISTYLEOF(hwndPb);
            butHnd.sendEvent( BM_SETSTYLE,
               (ulStyle1 & ~((unsigned long)BS_PRIMARYSTYLES)) |
                                           BS_DEFPUSHBUTTON, true );
         }
         else
         {
            IFrameWindow* frmWnd = (IFrameWindow*)IWindow::windowWithHandle( IPARENTOF(hwndPb ));
            IWindowHandle defHnd = frmWnd->defaultPushButton();
            frmWnd->setDefaultEmphasisButton(defHnd, true);
             // set new button up as default.

            unsigned long ulStyle = ISTYLEOF(defHnd);
            defHnd.sendEvent( BM_SETSTYLE,
            (ulStyle & ~((unsigned long)BS_PRIMARYSTYLES)) |
                                       BS_DEFPUSHBUTTON, true );
         }

         return true;
      }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     /* endcase*/
      break;

      case IC_UM_DLGCNTL_KILLFOCUS:
      {
         //kill focus
         HWND hwndPb = (HWND)event.parameter2().asUnsignedLong();
         IWindowHandle butHnd1(hwndPb);

         IWindowClassName msgClassName(butHnd1);
         IFrameWindow* frmWnd = (IFrameWindow*)IWindow::windowWithHandle( IPARENTOF(hwndPb ));
         IWindowHandle defHnd = frmWnd->defaultPushButton();

         unsigned long dlgcde=  SendMessage( hwndPb, WM_QUERYDLGCODE, 0, 0 );
         if (( dlgcde & DLGC_DEFPUSHBUTTON ) ||
              ( dlgcde & DLGC_PUSHBUTTON ))
         {
            if( defHnd != butHnd1)
            {
              unsigned long ulStyle = ISTYLEOF(butHnd1);
              butHnd1.sendEvent( BM_SETSTYLE,
                (ulStyle & ~((unsigned long)BS_PRIMARYSTYLES)) |
                                         BS_PUSHBUTTON, true );
            }
         }

         return true;
      }
      break;
#endif   //IC_WIN

#ifdef   IC_MOTIFWIN
    case IC_UM_CALCFRAMERECT:
      // This message is sent by the ICalcFrameRect function to compute
      // size of the frame rectangle.  Parameter1 is a Windows RECT
      // structure, Parameter2 is 0 if the RECT is a client rectangle,
      // otherwise the RECT is a window rectangle.  Message similar to
      // PM WM_CALCFRAMERECT
#endif   //IC_MOTIFWIN
#ifdef IC_PM
    case WM_CALCFRAMERECT:
#endif
    {
      IMODTRACE_DEVELOP( "IFrameHandler WM_CALCFRAMERECT" );

      IFrameEvent
        frameEvent( event );

      // Dispatch virtual function...
      result = this -> calcRect( frameEvent );

      // If handled, copy result to input event structure...
      if ( result )
      {
        event.setResult( frameEvent.result() );
      }
    }
    break;

#ifdef IC_MOTIFWIN
    case IC_UM_UPDATEFRAME:
    {
      IMODTRACE_DEVELOP( "IFrameHandler IC_UM_UPDATEFRAME" );

      // In Windows, the frame extension formatting is driven by
      // this IC_UM_UPDATEFRAME message.  It is generated by the
      // IFrameWindow::update function.

      IFrameWindow* frame = ((IFrameWindow*)(event.window()));

#ifdef IC_WIN
      // Handle initializing the dialog template unwrappered children list.
      // For IWindow objects, we insure via default handlers that keystroke
      // messages make it to the canvas or frame window to provide
      // keyboard navigation.  With dialogs created via a dialog template,
      // however, we have unwrappered controls in the dialog which by
      // default simply eat keyboard events,  perhaps after doing something
      // with them.  We create an IDialogControls object and keep in it a list
      // of the children of the dialog and their window procedures.  We subclass
      // each control so that we can intercept keyboard events as needed.
      // The subclass window procedure is pfnICControlProc.
      if ( frame->fFrameWindowData->flags & IFrameWindowData::fromDlgTemplate )
      {
        if (!( frame->fFrameWindowData->flags & IFrameWindowData::dlgInitialized ))
        {
          // Get a pointer to the controls list for this thread
          IDialogControls* dialogControls =
              IDialogControls::listForThread(IThread::currentId());
          // Enumerate the children of the dialog.
          IWindow::ChildCursor child(*frame);
          for (child.setToFirst(); child.isValid(); child.setToNext() )
          {
            IWindowHandle childhwnd = frame->childAt( child );

            // Special case for combobox.  Need to find the entryfield
            // child of the combobox.
            if ( (IWindowClassName(childhwnd) == WC_COMBOBOX) &&
                   (IWindow::windowWithHandle(childhwnd, false) == 0) )
            {
              // Find the edit control child of the combobox.
              childhwnd = GetWindow(childhwnd, GW_CHILD);
              while ( (childhwnd) &&
                         (IWindowClassName(childhwnd) != WC_ENTRYFIELD))
                childhwnd = GetWindow(childhwnd, GW_HWNDNEXT);
            }

            unsigned long dlgCode =
                 childhwnd.sendEvent(WM_GETDLGCODE, 0, 0);
            //
            // It is possible that we could call this more than once.
            // In that case the control is already in the collection
            // and we don't do anything.   We also skip adding to
            // the collection anything that is an IWindow.  It will
            // still work if an IWindow wrapper is created later, but not
            // if the control is an IWindow now.

            if ( (dlgCode & (DLGC_WANTARROWS | DLGC_WANTCHARS | DLGC_BUTTON | DLGC_STATIC | DLGC_RADIOBUTTON))
                   &&
                !(dialogControls->containsElementWithKey(
                                        childhwnd.asUnsigned() ) ||
                  IWindow::windowWithHandle(childhwnd, false) ) )
            {
              IDialogControl control;
              control.fHwnd = childhwnd.asUnsigned();
              control.fOriginalProc = (void*)
                 ISUBCLASSWINDOW(childhwnd,
                                  (unsigned long)pfnwpICControlProc);
              control.fDialog = frame->handle();
              // check here for infinite loop or possible traps
              IASSERTSTATE(control.fOriginalProc &&
                           control.fOriginalProc != pfnwpICControlProc);
              dialogControls->add( control );
              ITRACE_DEVELOP( IString("adding control hwnd=") +
                              IString(control.fHwnd).d2x() );

              if ( dlgCode & DLGC_DEFPUSHBUTTON )
              {
                  frame->setDefaultPushButton(childhwnd);
              }

            }

          } //end of for
          frame->fFrameWindowData->flags |= IFrameWindowData::dlgInitialized;
        }

      }  // end of dialog template case
#endif // IC_WIN

#ifdef IC_WIN
      // get the client rectangle
      RECT clientRect;
      GetClientRect( event.handle(), &clientRect );
#endif // IC_WIN
#ifdef IC_MOTIF
      Dimension width, height, border;
      XtVaGetValues( event.window()->handleForChildCreation(),
        XmNwidth, &width,
        XmNheight, &height,
        XmNborderWidth, &border,
        NULL );
      IRectangle clientRect( IPoint( 0, 0), ISize( width + 2*border,
                                                   height + 2*border) );
#endif
      // prepare and send an IC_UM_FORMATFRAME message to the frame.
      // all of the frame extensions need to be located
      unsigned long
        frameControls = event.handle().sendEvent( IC_UM_QUERYFRAMECTLCOUNT );
      ISWP* swp = new ISWP[ frameControls ];

      // Create ChildCursor to get handles of all child windows,
      // adding them to the ISWP array.  For "standard" frame
      // components, query their position and size and also stuff
      // that information in.  Note that position/size are in native
      // system coordinates, not ICLUI interface coordinates.
      // We only support client attachment at this time.   The client
      // is the only control whose position is filled in in
      // the SWP array.  Extensions are positioned by the format()
      // function later.

      unsigned long index = 0;
#ifdef IC_WIN
      // Now check for scrollbar controls within the frame window.  We need
      // to put these in the ISWP array first since they are handled like
      // "standard" controls.
      IWindowHandle
         hwndHorzScroll = IWINDOWFROMID( event.handle(), FID_HORZSCROLL ),
         hwndVertScroll = IWINDOWFROMID( event.handle(), FID_VERTSCROLL );
      if (hwndHorzScroll)
      {
         swp[index].hwnd = hwndHorzScroll;
         index++;
      }
      if (hwndVertScroll)
      {
         swp[index].hwnd = hwndVertScroll;
         index++;
      }
#endif // IC_WIN

      IWindow::ChildCursor cursor(*frame);
      for ( cursor.setToFirst();
            cursor.isValid() ;
            cursor.setToNext())
      {
        IWindowHandle child = frame->childAt( cursor );
        if ( (IIDOF( child ) != FID_CLIENT ) &&
#ifdef IC_WIN
             (IIDOF( child ) != FID_HORZSCROLL) &&
             (IIDOF( child ) != FID_VERTSCROLL) &&
#endif // IC_WIN
             (index < frameControls) )
        {
          swp[index].hwnd = child;
          index++;
        }
      }

      // Construct & send frame format event.  parameter1 is a pointer to
      // the SWP array, parameter2 is the current client rectangle.
      // Event handled in this handler below.  The format() function is
      // called to position the extensions.
      event.handle().sendEvent( IC_UM_FORMATFRAME,
                                IEventData( swp ),
                                IEventData( &clientRect)  );
#ifdef IC_WIN
      // set the positions of the frame controls
      HDWP  hdwp = BeginDeferWindowPos( (int)frameControls );
      if (!hdwp)
      {
         ITHROWGUIERROR2("BeginDeferWindowPos",
                         IBaseErrorInfo::outOfSystemResource,
                         IException::unrecoverable);
      }
      // set the position of the client window, if any
      IWindowHandle clientHwnd = frame->clientHandle();
      if (clientHwnd != 0)
      {
         // positioning and sizing done in native coordinates
         ISize clientSize(clientRect.right - clientRect.left,
                          clientRect.bottom - clientRect.top );
         ITRACE_ALL( IString("DeferWindowPos clientHwnd=") +
                     IString(clientHwnd.asUnsigned()).d2x() +
                     IString(" position=") +
                     IString(clientRect.left) + IString(",") +
                     IString(clientRect.top) +
                     IString(" size=") +
                     clientSize.asString() );
         hdwp = DeferWindowPos(hdwp,
                               clientHwnd, 0,
                               (int)clientRect.left,
                               (int)clientRect.top,
                               (int)clientSize.width(),
                               (int)clientSize.height(),
                               SWP_NOZORDER );
      }  // if client
      // set position of extensions
      for (index=0;  index < frameControls;  index++)
      {
        ISWP* extSWP = &swp[index];
        if ( extSWP->isMove() || extSWP->isSize() )
        {
          // place child windows.  Note that we work in native coordinates
          // to position extensions so no recoordination is done.
          ITRACE_ALL( IString("DeferWindowPos hwnd=") +
                      IString(extSWP->windowHandle().asUnsigned()).d2x() +
                      IString(" position=") + extSWP->position().asString() +
                      IString(" size=") +
                      extSWP->size().asString() );
          hdwp = DeferWindowPos(hdwp,
                                extSWP->windowHandle(), 0,
                                (int)extSWP->position().x(),
                                (int)extSWP->position().y(),
                                (int)extSWP->size().width(),
                                (int)extSWP->size().height(),
                                extSWP->flags() );
        }  // if move or size
      }  // for

      if ( !EndDeferWindowPos(hdwp) )
      {
         ITHROWGUIERROR2("EndDeferWindowPos",
                         IBaseErrorInfo::invalidParameter,
                         IException::unrecoverable);
      }
      // delete the SWP array
#endif
#ifdef IC_MOTIF
      // set the position of the client window, if any
      IWindowHandle clientHwnd = frame->clientHandle();
      if (clientHwnd != 0)
      {
        // positioning and sizing done in native coordinates
        Dimension border;
        XtVaGetValues( clientHwnd,
          XmNborderWidth, &border,
          NULL);

        ISize clientSize = clientRect.size();
        Dimension width, height;
        width = clientRect.size().width() - 2 * border;
        height = clientRect.size().height() - 2 * border;

        // Make sure the client has width and height. If not then unmanage it.
        if ( width && height )
        {
          // Make sure the client is managed. If it is not managed then it
          // was sized to zero at some point.
          if ( !XtIsManaged( (Widget)clientHwnd ) )
            XtManageChild( clientHwnd );
          Position x, y;
          x = clientRect.minXMinY().x();
          y = clientRect.minXMinY().y();
          XtVaSetValues( clientHwnd,
            XmNx, x,
            XmNy, y,
            XmNwidth, width,
            XmNheight, height,
            NULL );
        }
        else
          XtUnmanageChild( clientHwnd );
      }  // if client
      for ( index = 0; index < frameControls; index++ )
      {
        ISWP* extSWP = &swp[index];
        if (extSWP->isMove() || extSWP->isSize() )
        {
          Dimension border;
          XtVaGetValues( extSWP->hwnd,
            XmNborderWidth, &border,
            NULL);

          Dimension width, height;
          width = extSWP->cx - 2 * border;
          height = extSWP->cy - 2 * border;

          // Make sure the extension has width and height.
          if ( width && height )
          {
            // Make sure the extension is managed. If it is not then it was
            // sized to 0 at some point.
            XtVaSetValues( extSWP->hwnd,
              XmNx, extSWP->x,
              XmNy, extSWP->y,
              XmNwidth, width,
              XmNheight, height,
              NULL );
            if ( !XtIsManaged( (Widget) extSWP->hwnd ) )
              XtManageChild( extSWP->hwnd );
#ifdef IC_TRACE_ALL
            Position newX, newY, newWidth, newHeight;
            XtVaGetValues( extSWP->hwnd,
              XmNx, &newX,
              XmNy, &newY,
              XmNwidth, &newWidth,
              XmNheight, &newHeight,
              NULL );
            ITRACE_ALL("new extSWP is "
                                   + IPoint(newX,newY).asString()
                                   + ISize( newWidth,newHeight).asString() );
            ITRACE_ALL("expected extSWP is "
                                   + IPoint(extSWP->x,extSWP->y).asString()
                                   + ISize( width,height).asString() );

#endif // IC_TRACE_ALL
          }
          else
            XtUnmanageChild( extSWP->hwnd );
        }
      }
#endif // IC_MOTIF
      delete [] swp;

      // if there is a client size it to the frame
//      IWindow*  clientWin = frame->client();
//      if (clientWin)
//         clientWin->moveSizeTo( frame->clientRectFor( IRectangle() ) );
      result = true;
    }
    break;
#endif //IC_MOTIFWIN

#ifdef IC_MOTIFWIN
    case IC_UM_QUERYFRAMECTLCOUNT:
      {
      IMODTRACE_DEVELOP( "IFrameHandler IC_UM_QUERYFRAMECTLCOUNT" );

      unsigned long
        stdControls = 0;           // No additional standard extensions
#ifdef IC_WIN
      // In Windows, we count the scrollbars as standard controls in order
      // to position them in IFrameWindow::format.
      if (IWINDOWFROMID( event.handle(), FID_HORZSCROLL ))
         stdControls++;
      if (IWINDOWFROMID( event.handle(), FID_VERTSCROLL ))
         stdControls++;
#endif // IC_WIN
#endif //IC_MOTIFWIN
#ifdef IC_PM
    case WM_QUERYFRAMECTLCOUNT:
      {
      IMODTRACE_DEVELOP( "IFrameHandler WM_QUERYFRAMECTLCOUNT" );

      // Call default procedure to get number of standard controls...
      unsigned long
        stdControls = this -> defaultProcedure( event );
#endif  //IC_PM

      // Compute additional controls count...
      unsigned long
        extensions = this -> numberOfExtensions(
                                         (IFrameWindow*)event.window() );

      // Result is the sum...
      event.setResult( IEventResult( stdControls + extensions ) );

      result = true;
      }
      break;

#ifdef IC_WIN
    // Size handler code for Windows to perform client area resizing
    // whenever frame is resized
    case WM_SIZE:
    {
      IMODTRACE_DEVELOP( "IFrameHandler WM_SIZE" );

      IFrameWindow* frame = ((IFrameWindow*)(event.window()));

      frame->fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
      frame->update();
    }
    break;
#endif  // IC_WIN

#ifdef IC_MOTIF
    case xEvent(ConfigureNotify):
    {
      // Look for a frame window size change
      // Parameter 1 is pointer to an array of 2 window rectangles. Rectangle 0
      // is the old rectangle and rectangle 1 is the new rect.
      ISizeRectangle *sizeRect =
        (ISizeRectangle *) event.parameter1().asUnsignedLong();
      if ( sizeRect->sizeChanged() )
      {
        IMODTRACE_DEVELOP( "IFrameHandler WM_SIZE" );

        IFrameWindow* frame = ((IFrameWindow*)(event.window()));

        frame->fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
        // delay the update until the main window gets shown.
        frame->update();
      }
    }
    break;

    case xEvent(MapNotify):
    {

      if (event.parameter1().asUnsignedLong() == true ) // first time window is
                                                      //   shown
      {
        IMODTRACE_DEVELOP( "IFrameHandler WM_SIZE - first time shown" );

        // We had problems with inital focus because most of the time
        // people are calling it before we are managed and realized. We
        // save the inital focus widget in the XmNinitalFocus resource of
        // of the manager widget. Let's try to give focus to that widget
        // the first time we are shown. I also reset the focus widget
        IFrameWindow* frame = ((IFrameWindow*)(event.window()));

        WidgetList children = NULL;
        Cardinal numChildren = 0;
        XtVaGetValues( (Widget)frame->handle(),
                       XmNchildren    , &children,
                       XmNnumChildren , &numChildren,
                       NULL );
        // look for the main window.
        int i=0;
        while (! XmIsMainWindow(children[i]) && i<numChildren)
        {
          i++;
        }

        // found main window, now set focus.
        if (i < numChildren)
        {
          Widget focusWidget;
          XtVaGetValues( children[i],
                          XmNinitialFocus, &focusWidget,
                          NULL);
          if (focusWidget && IWindow::windowWithHandle(focusWidget))
          {
            XmProcessTraversal( focusWidget,
                          XmTRAVERSE_CURRENT );
          }
          // Believe it or not, reseting the initial focus widget
          // after the shell has been realized seems to fix the focus
          // problem.
          XtVaSetValues( children[i],
                         XmNinitialFocus, &focusWidget,
                         NULL );
          // We have trouble with the menubar getting sized so nudge the
          // main window.
          (children[i]->core.widget_class->core_class.resize)(children[i]);

        }

        frame->fFrameWindowData->flags |= IFrameWindowData::needsUpdating;
        // delay the update until the main window gets shown.
        //frame->update();
      }
    }
    break;

#endif

#ifdef IC_MOTIFWIN
    case IC_UM_FORMATFRAME:
#endif  //IC_MOTIFWIN
#ifdef IC_PM
    case WM_FORMATFRAME:
#endif  //IC_PM
      {
      IMODTRACE_DEVELOP( "IFrameHandler WM_FORMATFRAME" );

      IFrameFormatEvent
        fmtEvent( event );

      // Dispatch virtual function...
      result = this -> format( fmtEvent );

      // If handled, copy result to input event structure...
      if ( result )
        event.setResult( fmtEvent.result() );
      }
      break;

    case WM_SYSCOMMAND:
    case WM_CLOSE:
    {
      IMODTRACE_DEVELOP( "IFrameHandler WM_SYSCOMMAND/WM_CLOSE" );
      bool processClose = false;    // Don't treat most syscmds as close.

      if ( event.eventId() == WM_CLOSE )
      {       // Always close window on WM_CLOSE.
         processClose = true;
      }
#ifdef IC_WIN
      else if ( (((unsigned long)event.parameter1()) & 0xFFF0) == SC_CLOSE )
#else
      else if ( event.parameter1().number1() == SC_CLOSE )
#endif
      {       // Close system command (e.g. from system menu or accelerator).
         processClose = true;   // Almost always close the window.

         // Check if the "Close" system menu choice is disabled.
         // If so, ignore the close request.
         IFrameWindow
          *pFrame = dynamic_cast<IFrameWindow*>( event.window() );

#ifdef IC_PMWIN
         if ( pFrame
  #ifdef IC_WIN
             && ( ISTYLEOF(event.handle()) & WS_SYSMENU )
  #endif //IC_WIN
  #ifdef IC_PM
             && pFrame->handleFor( IFrameWindow::systemMenu )
  #endif //IC_PM
            )
         {
            // Possible multiple ISystemMenu objects OK since menus
            // are not a window
            ISystemMenu sysMenu( pFrame );
            try
            {
               if ( !sysMenu.isItemEnabled(ISystemMenu::idClose) )
               {      // "Close" choice is disabled, ignore the request.
                  processClose = false;
                  result = true;
               }
            }
            catch (IInvalidRequest&)
            {
               // The close menu item has been removed...same as disabled.
               processClose = false;
               result = true;
            }
         }
      }
#endif //IC_PMWIN
#ifdef IC_MOTIF

		 if( pFrame )
		 {
			// ignore close if close disabled
            int WMFunctions;

            XtVaGetValues( pFrame->handle(), XmNmwmFunctions,
					&WMFunctions, NULL );
            if( !(WMFunctions & MWM_FUNC_CLOSE) )
            {
               processClose = false;
               result = true;
            }
		 }
	  }
      else
      {
         // This processing for SC_HELP... messages is very similar to
         // that done for Windows under the WM_COMMAND case.  The
         // difference is that in Motif we get WM_SYSCOMMAND messages
         // instead of WM_COMMAND messages.  This is because the resource
         // compiler supports the MIS_... style flags.

         IHelpWindow::HelpType helptype;
         bool      sendToHelp = false;
         // See if the event is a help display message.  If so, set
         // type indicator.  Otherwise, ignore it
         switch ( event.parameter1().number1() )
         {
           case SC_HELPEXTENDED:
              helptype = IHelpWindow::general;
              sendToHelp = true;
              break;
           case SC_HELPKEYS:
              helptype = IHelpWindow::keys;
              sendToHelp = true;
              break;
           case SC_HELPINDEX:
              helptype = IHelpWindow::index;
              sendToHelp = true;
              break;
         }      //switch
         if (sendToHelp)
         {
           // If there is an associated help instance, show the
           // requested help window and indicate message handled.
           IHelpWindow *hwin =
                          IHelpWindow::helpWindow(event.dispatchingWindow());
           if (hwin)
           {
             hwin->show( helptype );
             result = true;
           }
         }  // if sendToHelp
      } // else
#endif   //IC_MOTIF

      if ( processClose )
      {
        IFrameEvent
          frameEvent( event );

        frameEvent.frame()->fFrameWindowData->flags |=
                                        IFrameWindowData::hasBeenClosed;

        result = this -> closed( frameEvent );

        if ( result )
          event.setResult( frameEvent.result() );
      }
#ifdef IC_WIN
      // If this is a system command message
      else if ( event.eventId() == WM_SYSCOMMAND )
      { // and not a close message
        if ( (((unsigned long)event.parameter1()) & 0xFFF0) != SC_CLOSE )
        {
          // Need to call default procedure here and strip off high order
          // bit potentially added earlier for routing purposes.
          IEvent newEvent( event.handle(),
                           event.eventId(),
                           event.parameter1() & 0x7FFFFFFF,
                           event.parameter2() );

          this->defaultProcedure( newEvent );

          // Event handled so don't route on.
          event.setResult( true );
          result = true;
        }
      }
#endif
      break;
    }

#ifdef IC_PMWIN
#ifdef IC_WIN
    // This is to help behavior of child MDI style windows, athough we
    // don't currently fully support MDI
    case WM_CHILDACTIVATE:
#endif
    case WM_ACTIVATE:
      {
      IFrameEvent
        frameEvent( event );

#ifdef IC_WIN
      if ( ( (unsigned long)frameEvent.parameter1() ) ||
           ( frameEvent.eventId() == WM_CHILDACTIVATE ) )
#endif //IC_WIN
#ifdef IC_PM
      if ( (unsigned long)frameEvent.parameter1() )
#endif //IC_PM
        {
        ITRACE_ALL(IString("ACTIVATE frame=")+
                   IString( (unsigned long)(void*)frameEvent.frame()).d2x() );
        frameEvent.frame() -> update();
        result = this -> activated( frameEvent );
        }
      else
        {
#ifdef IC_WIN
        // Save the handle of the window with focus.  We use this when
        // the frame gains focus again to set the focus back to the same
        // control.
        frameEvent.frame()->fFrameWindowData->fLastFocus =
           IQUERYFOCUS(IWindow::desktopWindow()->handle());
#endif
        result = this -> deactivated( frameEvent );
        }

      if ( result )
        event.setResult( frameEvent.result() );
      }
      break;
#endif // IC_PMWIN

#ifdef IC_PM
    case WM_SETFOCUS:
       // In Windows we attach an ICVKeyboardHandler to the frame which
       // will handle this message.   We need to handle it here in PM.
       {                   // Assign to first/last tab-able control.
       ITRACE_ALL( IString( "WM_SETFOCUS hwnd=" ) +
                   IString( event.handle().asUnsigned() ).d2x() +
                   IString( " wParam=" ) +
                   IString( event.parameter1().asUnsignedLong() ).d2x() +
                   IString( " lParam=" ) +
                   IString( event.parameter2().asUnsignedLong() ).d2x() );
       if (event.parameter2().number1())
          {                             // Frame window getting focus.
          /*******************************************************/
          /* Post the IC_UM_CANVAS_SETFOCUS message to avoid     */
          /* changing the window with the input focus during     */
          /* processing of a WM_SETFOCUS message.                */
          /*******************************************************/
          event.handle().postEvent(IC_UM_CANVAS_SETFOCUS, 0, 0);
          result = true;
          }
       } /* endcase */
       break;
#endif

#ifdef IC_PMWIN
    case IC_UM_CANVAS_SETFOCUS:
       // This message is posted by the ICVKeyboardHandler attached to
       // the window when WM_SETFOCUS is seen.  We intercept it here
       // to set the focus back to the original focus window in cases
       // where the frame is being reactivated.
       // In PM, the frame handler generates this message
       {
       IFrameWindow* frame = (IFrameWindow *)event.window();
       if (frame)
          {
          IWindowHandle hwndFocus =
            IQUERYFOCUS(IWindow::desktopWindow()->handle());
          if ( hwndFocus == event.handle() )
             {
#ifdef IC_WIN
             IWindowHandle lastFocus(frame->fFrameWindowData->fLastFocus);
#endif
#ifdef IC_PM
             IWindowHandle lastFocus( frame->windowULong(QWL_HWNDFOCUSSAVE));
#endif
             if ( lastFocus == event.handle() )
                lastFocus = 0;      // if it is the frame invalidate

             if ( lastFocus.asUnsigned() && lastFocus.isValid() )
                {
                // We still have the focus after Windows has completed SETFOCUS
                // processing.  This means that focus has been given to the
                // frame itself ... such as by clicking on the title bar or
                // selecting the application from the task bar.
                // Give focus to the last window with focus when we were
                // deactivated.
                ISETFOCUS(IWindow::desktopWindow()->handle(), lastFocus);
                result = true;      // Don't need the ICVKeyboardHandler to handle.
                }
#ifdef IC_PM
             // In Windows, ICVKeyboardHandler handles the case were we
             // have the focus but there is no previous focus.
             else
                {
                // Set the focus to the client if there is one.
                lastFocus = frame->clientHandle();
                if (! lastFocus){
                   lastFocus = WinEnumDlgItem(frame->handle(), 0, EDI_FIRSTTABITEM);
		   }
                if (lastFocus)
                   {
                   ISETFOCUS(IWindow::desktopWindow()->handle(), lastFocus);
                   }
                frame->setWindowData( QWL_HWNDFOCUSSAVE, lastFocus );
                }
#endif
             }  // frame has focus
          }  // frame found
       }
       break;
#endif // IC_PMWIN

#ifdef IC_PM
    case WM_SAVEAPPLICATION:
      {
      IFrameEvent
        frameEvent( event );

      result = this -> saved( frameEvent );

      if ( result )
        event.setResult( frameEvent.result() );
      }
      break;
#endif

#ifdef IC_PMWIN
    case WM_PAINT:
#endif
#ifdef IC_MOTIF
    case xEvent(Expose):
#endif
      {
      IFrameEvent
        frameEvent( event );

      result = this -> draw( frameEvent );

      if ( result )
        event.setResult( frameEvent.result() );
      }
      break;

    case WM_COMMAND:
    {
      IMODTRACE_DEVELOP( "IFrameHandler WM_COMMAND" );
      ICommandEvent cmdEvent( event );
#ifdef IC_MOTIFPM
      result = this -> command( cmdEvent );
      if ( result )
        event.setResult( cmdEvent.result() );
#endif   //IC_MOTIFPM
#ifdef IC_WIN
      /*---------------------------------------------------------------------
      | Here we are emulating PM system behavior for certain WM_SYSCOMMAND  |
      | messages which tend to be used in applications.  Unfortunately,     |
      | there is no MIS_SYSCOMMAND resource symbol, so we have to process   |
      | the SC_HELP id's as reserved command values.                        |
      ---------------------------------------------------------------------*/
      // This processing for SC_HELP... messages is very similar to
      // that done for Motif under the WM_SYSCOMMAND case.  The
      // difference is that in Motif we get WM_SYSCOMMAND messages
      // instead of WM_COMMAND messages.  This is because the Motif resource
      // compiler supports the MIS_... style flags.
      IHelpWindow::HelpType helptype;
      bool      sendToHelp = false;
      bool      convertClose = false;
      // See if the event is a help display message.  If so, set
      // type indicator.  Otherwise, ignore it
      switch ( cmdEvent.commandId() )
      {
        case SC_HELPEXTENDED:
           helptype = IHelpWindow::general;
           sendToHelp = true;
           break;
        case SC_HELPKEYS:
           helptype = IHelpWindow::keys;
           sendToHelp = true;
           break;
        case SC_HELPINDEX:
           helptype = IHelpWindow::index;
           sendToHelp = true;
           break;
        case SC_CLOSE:
           convertClose = true;
           break;
      }
      if (sendToHelp)
      {
        // If there is an associated help instance, show the
        // requested help window and indicate message handled.
        IHelpWindow *hwin =
                       IHelpWindow::helpWindow(cmdEvent.dispatchingWindow());
        if (hwin)
        {
          hwin->show( helptype );
          result = true;
        }
      }
      // If SC_CLOSE received, convert to a system command and resend
      // and prevent this message from being passed on.
      else if (convertClose)
      {
        event.handle().sendEvent( WM_SYSCOMMAND,
                                  IEventParameter1( SC_CLOSE, CMDSRC_OTHER ),
                                  IEventParameter2( 0 ) );
        result = true;
      }
      else
      {
        // Normal command so call overload function and save result returned.
        result = this -> command( cmdEvent );
        if ( result )
          event.setResult( cmdEvent.result() );
      }
#endif // IC_WIN
    }
    break;

    case WM_DESTROY:
      {
      IMODTRACE_DEVELOP( "IFrameHandler WM_DESTROY" );
      IFrameWindow
       *pFrame = (IFrameWindow*)( event.window() );
      // If frame wasn't "closed", do so now.
      if ( !( pFrame->fFrameWindowData->flags & IFrameWindowData::hasBeenClosed ) )
        {
        pFrame -> setDestroyOnClose( false ); // Prevent recursion.
        IFrameEvent
          frameEvent( event );
        this -> closed( frameEvent );
        }
#ifdef IC_WIN
      if (!(IPlatform::isWin9x() || IPlatform::isNTNewShell()))
        RemoveProp( pFrame->handle(), PROP_MENUBAR_OBJECT );
#endif  // !IC_WIN
      pFrame -> removeFromWindowList();

      //-----------------------------------------------------------------
      // Without special processing, the combination of
      // IFrameWindow::showModally and IWindow::setAutoDeleteObject
      // will cause a trap, during manipulation of the deleted frame
      // object at the end of showModally.  This code causes the
      // auto-delete processing in IWindow to be bypassed, so the object
      // deletion can be done by IFrameWindow instead.  By delaying the
      // setting of the private data flag until now, there should be no
      // out-of-synch conditions between the flag and the auto-delete
      // setting of the frame object (for example, caused by handlers
      // attached to the frame object).
      //-----------------------------------------------------------------
      if ( pFrame->fFrameWindowData->flags & IFrameWindowData::modal  &&
           pFrame->isAutoDeleteObject() )
        {
         pFrame->fFrameWindowData->flags |= IFrameWindowData::modalAutoDelete;
         pFrame->setAutoDeleteObject( false );
        }
      }
      break;

#ifdef IC_PMWIN
    case WM_DRAWITEM:
    case WM_MEASUREITEM:
      result = ( (unsigned long)event.parameter1() == FID_CLIENT );
      break;
#endif // IC_PMWIN

#ifdef IC_PM
    case WM_CONTROLPOINTER:
      {
      // Always return true, so that the frame window procedure does
      // not route the message to a client window.  Allowing this
      // with a canvas client would result in an infinite loop,
      // because the canvas window procedure routes this message to
      // the owner window of the canvas, even if it is a frame window.
      event.setResult( (unsigned long) event.parameter2() );
      result = true;
      }
      break;
#endif // IC_PM

#ifdef IC_PMWIN
    case WM_WINDOWPOSCHANGED:
      // If the frame is becoming active and this is a secondary window,
      // be sure that the owner window not minimized.  This is needed to
      // work around the PM behavior for primary and secondary windows
      // being restored from the task list.
      if ((event.window() != 0) &&
#ifdef IC_WIN
         (!(((PWINDOWPOS)(char*)event.parameter2())->flags & SWP_NOACTIVATE)))
#endif //IC_WIN
#ifdef IC_PM
         (((unsigned long) event.parameter2()) & AWP_ACTIVATE))
#endif //IC_PM
      {
         IWindow* pOwner = event.window()->owner();
         if (pOwner && pOwner->isFrameWindow() &&
            ((IFrameWindow*)pOwner)->isMinimized())
         {
            ((IFrameWindow*)pOwner)->restore();
         }
      }
      break;
#endif // IC_PMWIN

#ifdef IC_WIN
    case WM_QUERYFOCUSCHAIN:
       {
       ITRACE_ALL( IString( "WM_QUERYFOCUSCHAIN " ) );
       switch (event.parameter1().lowNumber())
          {
          case QFC_NEXTINCHAIN  :
          case QFC_FRAME        :
              event.setResult( IEventResult(event.handle().asUnsigned()) );
              result = true;
              break;
          case QFC_PARTOFCHAIN  :
              result = (event.handle().asUnsigned() ==
                        event.parameter2().asUnsignedLong() );
              event.setResult( result );
              break;
//          These are not supported and not used by the Class Library
//            case QFC_ACTIVE       :
//            case QFC_SELECTACTIVE :
          default:
             break;
          }
       }
       break;

    case WM_SETREDRAW:
       {
       ITRACE_DEVELOP(IString("IFrameHandler WM_SETREDRAW flag=") +
                      IString(event.parameter1().asUnsignedLong())  );
       if ( event.parameter1().asUnsignedLong() )
          {
          bool wasVisible = event.window()->isVisible();
          if (!wasVisible)
            {
            ITRACE_DEVELOP("was not visible");
            defaultProcedure(event);

            // RDW_ALLCHILDREN may be too much.  Seem to need
            // it to get everything to paint.
            unsigned int rdFlags = RDW_ERASE | RDW_FRAME | RDW_ALLCHILDREN |
                                   RDW_INVALIDATE;
            RedrawWindow( event.handle(),         // this window
                          0,                      // entire window (rect)
                          0,                      // entire window (region)
                          rdFlags );              // flags

            result = true;
            }
          else
            {
            ITRACE_DEVELOP("was visible");
            }
          }
       }
       break;


    // If the frame window has a client, the frame window should not try to
    // paint its background using its background brush.
    case WM_ERASEBKGND:
      if (((IFrameWindow*)event.window())->clientHandle())
      {
        event.setResult( true );
        result = true;
      }
      break;

    case WM_NCPAINT:
    case WM_NCACTIVATE:
       {
       IFrameWindow* frame = (IFrameWindow*)event.window();
       if (frame)
          {
          bool drawInactive = false;
          if (event.eventId() == WM_NCACTIVATE)
             {
             if (event.parameter1().asUnsignedLong() == 0)
                drawInactive = true;
             }
          else
             {
               if ((HWND)event.handle() != GetForegroundWindow())
                 {
                 drawInactive = true;
                 }
             }
          if (frame->fFrameWindowData->fhFont)
          {
             // have font set

             // let Windows do its thing...but first need to arrange it
             // so Windows will think text is null.  It will send us
             // a WM_GETTEXT which we handle below.
             frame->fFrameWindowData->flags |=
               IFrameWindowData::inTitlePaint;

             this->defaultProcedure( event );

             if ( ( ISTYLEOF( frame->handle() ) & WS_CAPTION ) == WS_CAPTION )
             {
             		frame->fFrameWindowData->flags &=
               	~IFrameWindowData::inTitlePaint;

               	IWindowHandle hwnd = event.handle();
               	HDC hdc = GetWindowDC( hwnd );
               	if (!hdc)
                 		ITHROWGUIERROR("GetWindowDC");

               	// Get rectangle for title.  It is already in WindowRect coordinates.
               	// We can create ITitle without worrying about existing
               	// user ITitle object since it does not do startHandlingEventsFor
               	ITitle title(frame);
               	RECTL drawRect =
                 		title.nativeRect().asRECTL();

               	drawRect.left += 2;   // Add a pad between system menu and text

               	// Setup draw flags
               	unsigned int dtFlags = DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER;
	       			if (IPlatform::isWin9x() || IPlatform::isNTNewShell())
                 		dtFlags |= DT_LEFT;
               	else
                 		dtFlags |= DT_CENTER;

               	// If this frame window is to draw text from right to left,
               	// add in a right-to-left drawing style for use in drawing
               	// the title bar text.
               	if ( IBidiSettings::isBidiSupported() )
               	{
                  	IBidiSettings
                    		bidiSettings( *frame );
                  	if ( bidiSettings.textOrientation() ==
                            IBidiSettings::textRightToLeft )
                  	{
                     	dtFlags |= DT_RTLREADING;
                  	}
               	}

               	// setup colors
               	COLORREF oldfg, oldbg;
               	if (drawInactive)
               	{
                		oldbg = SetBkColor(hdc,
                            IColor(IColor::inactiveTitleTextBgnd).asRGBLong());
                 		oldfg = SetTextColor(hdc,
                              IColor(IColor::inactiveTitleText).asRGBLong());
               	}
               	else
               	{
                 		oldbg = SetBkColor(hdc,
                            IColor(IColor::activeTitleTextBgnd).asRGBLong());
                 		oldfg = SetTextColor(hdc,
                              IColor(IColor::activeTitleText).asRGBLong());
               	}

               	// get title text
               	IString titleText( title.text() );

               	// setup font
               	HFONT prevFont = (HFONT)
                            SelectObject( hdc,
                                          frame->fFrameWindowData->fhFont);
               	// draw the text
               	DrawText(hdc,
                        (const char* )titleText,
                        (int)titleText.length(),
                        (RECT*)&drawRect,
                        dtFlags );

               	// cleanup
               	SelectObject( hdc, prevFont );
               	SetBkColor( hdc, oldbg );
               	SetTextColor( hdc, oldfg );
               	ReleaseDC( hwnd, hdc );

             		// event handled
		            event.setResult( true );
             		result = true;
                } // if has a titlebar
             }  // if has font set
          } // if frame
       }
       break;

    case WM_SETFONT:
       {
       IFrameWindow* frame = ((IFrameWindow*)(event.window()));
       if ( frame )
          {
          // Store a copy of the HFONT object (IWindow/IFont handle refcounting)
          frame->fFrameWindowData->fhFont = (HFONT)event.parameter1();

          // redraw if specified
          if (event.parameter2().asUnsignedLong())
             RedrawWindow( frame->handle(), 0, 0,
                           RDW_FRAME | RDW_INVALIDATE | RDW_ERASENOW );
          result = true;
          }
       }
       break;

    case WM_GETFONT:
       {
       IFrameWindow* frame = ((IFrameWindow*)(event.window()));
       if ( frame && frame->fFrameWindowData->fhFont )
          {
          // Been changed...return our value
          event.setResult( IEventData(frame->fFrameWindowData->fhFont) );
          result = true;
          }
       }
       break;

	case WM_SETTEXT:
	{
		IFrameWindow* frame = ((IFrameWindow*)(event.window()));
		if ( frame && frame->fFrameWindowData->fhFont )
		{
			// let windows set the actual text for the window title
			frame->defaultProcedure( event );

			// redraw and we'll make sure the font is right
			RedrawWindow( frame->handle(), 0, 0,
					RDW_FRAME | RDW_INVALIDATE | RDW_ERASENOW );
			result = true;
		}
		else
		{
			result = false;
		}
	}
	break;

    case WM_GETTEXT:
       {
       IFrameWindow* frame = ((IFrameWindow*)(event.window()));
       if ( frame && frame->fFrameWindowData->fhFont )
          {
          // Font set ... need to make sure default procedure gets null string
          unsigned long length = event.parameter1().asUnsignedLong();
          if (frame->fFrameWindowData->flags & IFrameWindowData::inTitlePaint)
             {
             // We are in our title paint routine and the default procedure
             // is asking for the text.  Give it a null string.
             *((char*)event.parameter2()) = '\0';
             length = 0;
             event.setResult( IEventData(length) );
             result = true;
             }
          }
       }
       break;

    case WM_GETTEXTLENGTH:
       {
       IFrameWindow* frame = ((IFrameWindow*)(event.window()));
       if ( frame && frame->fFrameWindowData->fhFont )
          {
          // Font set ... need to make sure default procedure gets null string
          if (frame->fFrameWindowData->flags & IFrameWindowData::inTitlePaint)
             {
             // We are in our title paint routine and the default procedure
             // is asking for the text.  Give it a null string.
             event.setResult(0);
             result = true;
             }
          }
       }
       break;

    case IC_UM_CONTEXT_HELP:
       {
         // construct HELPINFO structure needed for WM_HELP message

        ITRACE_DEVELOP("IC_UM_CONTEXT_HELP");
         POINT nullPoint;
         HELPINFO helpInfo;
         helpInfo.cbSize = sizeof(HELPINFO);
         helpInfo.MousePos = nullPoint;
         helpInfo.dwContextId  = 0;

         // parm2 of IC_UM_CONTEXT_HELP may contain the
         // handle of the window for which help was requested,
         // else, use window with focus

         if ( event.parameter2().asUnsignedLong() )
           helpInfo.hItemHandle = event.parameter2();
         else
           helpInfo.hItemHandle = IQUERYFOCUS(NULL);


         // for combobox, entryfield or list will be returned on GetFocus instead of the control.
         // If so, change the item handle to that of the combo box

         HWND parentHwnd = IPARENTOF( (HWND) helpInfo.hItemHandle );
         if (parentHwnd)
         {
           IWindowClassName className(parentHwnd);
           if (className == WC_COMBOBOX)
           {
             helpInfo.hItemHandle = parentHwnd;
           }
         }
         IWindowHandle sendTo = (HWND) helpInfo.hItemHandle;

         // low word of parm1 of IC_UM_CONTEXT_HELP may contain the
         // control id for which help was requested

         if ( event.parameter1().lowNumber() )
           helpInfo.iCtrlId = event.parameter1().lowNumber();
         else
           helpInfo.iCtrlId = IIDOF( (HWND) helpInfo.hItemHandle );

         if ( IsMenu( (HMENU) helpInfo.hItemHandle ) )
         {
           helpInfo.iContextType = HELPINFO_MENUITEM;
           IMenu *tempMenu = new IMenu( (HMENU) helpInfo.hItemHandle );
           if (tempMenu && tempMenu->owner())
             sendTo = tempMenu->owner()->handle();
           else
             sendTo = event.handle();
         }
         else
           helpInfo.iContextType = HELPINFO_WINDOW;

         // send the WM_HELP message.

         IEventResult helpRc;
         bool helpProcessed=false;
         while ( !helpProcessed && sendTo != 0 )
         {
           ITRACE_DEVELOP("Sending Generated WM_HELP Event");
           helpRc = sendTo.sendEvent( WM_HELP, 0, (LPHELPINFO)&helpInfo );

           helpProcessed = true;
         }
       }
       break;
#endif //IC_WIN

    case IC_UM_DESTROY_FRAME:
       {
       IMODTRACE_DEVELOP( "IFrameHandler IC_UM_DESTROY_FRAME" );
#ifdef IC_WIN
         // Be sure to unregister the unique frame class after we destroy
         // the frame window.  This will prevent a memory leak since each
         // time we create a frame window, we register a new unique class
         // name.
         IWindowClassName wcName(event.handle());
         if ( !IDESTROYWINDOW( event.handle() ) )
         {
           ITHROWGUIERROR("IDESTROYWINDOW");
         }
         else
         {
           // Only unregister the frame classes we create.
           // Do not unregister WC_DIALOG, which is a Windows global class
           if ((wcName.asString().indexOf(WC_FRAME) == 1) )
             UnregisterClass(wcName, GetModuleHandle(0));
         }
#endif
#ifdef IC_PM
         if ( !IDESTROYWINDOW( event.handle() ) )
         {
           ITHROWGUIERROR("IDESTROYWINDOW");
         }
#endif //IC_PM

#ifdef IC_MOTIF
         // Need to realize the shell widget of an IFrameWindow
         // to avoid suspected bug in XtDestroy (AIX 4.1 MBCS only).
         if ( !XtIsRealized( event.handle() ) )
             XtRealizeWidget( event.handle() );

         // IWindow takes care of stopping primary message loop
         XtDestroyWidget( event.handle() );
#endif //IC_MOTIF

         result = true;
       }
       break;

#if 0
    // Test if the below code is really needed.  IC_NOTYET
#ifdef IC_PM
    //---------------------------------------------------------------
    // Watch for private class library message to disable the
    // automatic update of frame extensions when the BIDI attributes
    // for the window change or for command to update extensions
    //---------------------------------------------------------------
    case IC_UM_BIDI_CHANGE:
       {
         IFrameWindow *pFrame = (IFrameWindow*)( event.window() );
         if ( event.parameter1().asUnsignedLong() == 0 )
         {
           // Set flag to disable frame extension update
           pFrame->fFrameWindowData->disableBidiChildUpdate = true;
         }
         else
         {
           // Frame extension should be updated
           IBidiSettings bidi(*pFrame);
           IWindow::ChildCursor cwCursor( *pFrame );
           for ( cwCursor.setToFirst(); cwCursor.isValid();
                 cwCursor.setToNext() )
           {
             IWindowHandle whChild = pFrame->childAt( cwCursor );
             IWindow* pwinChild = IWindow::windowWithHandle( whChild );
             if ( pwinChild && ( pwinChild->id() != FID_CLIENT ))
             {
               bidi.apply(*pwinChild);
             }
           }
         }
       }
       break;

    //---------------------------------------------------------------
    // Look for changes to the BIDI attributes by watching for the
    // WM_SETBIDIATTR message.
    //---------------------------------------------------------------
    case WM_SETBIDIATTR:
       {
         if (event.window()->isFrameWindow())
         {
           IFrameWindow *pFrame = (IFrameWindow*)( event.window() );
           if ( pFrame->fFrameWindowData->disableBidiChildUpdate )
           {
             // Frame extensions should not be updated
             pFrame->fFrameWindowData->disableBidiChildUpdate = false;
           }
           else
           {
             // Frame extension should be updated
             pFrame->postEvent(IC_UM_BIDI_CHANGE,true);
           }
         }
       }
       break;
#endif //IC_PM
#endif // 0

#ifdef IC_WIN
    // We need to forward this message on to all child controls.  Windows
    // only sends it to top level windows.  The Windows common controls (tab,
    // listview, etc) are documented as needing it.  In addition, our toolbar
    // button painting code needs to see this message.
    case WM_SYSCOLORCHANGE:
       {
       IWindowHandle hwndFrame( event.handle() );
       if ( !(ISTYLEOF( hwndFrame ) & WS_CHILD) )
          {
          // is top level window
          hwndFrame.sendEvents( event.eventId(),
                                event.parameter1(),
                                event.parameter2(),
                                IWindowHandle::descendants );
          }
       }
       break;
#endif
#ifdef IC_PM
    case WM_ADJUSTFRAMEPOS:
      {
         ITRACE_DEVELOP("WM_ADJUSTFRAMEPOS") ;
         IFrameWindow *pFrame = (IFrameWindow *) event.window() ;
         PSWP pSWP = (PSWP) (char *) event.parameter1() ;
         if (pFrame->fFrameWindowData->bMaxFrameSizeSet && ((pSWP->fl & SWP_MAXIMIZE) | (pSWP->fl & SWP_SIZE))) {
            pSWP->cx = min(pSWP->cx, (pFrame->fFrameWindowData->maximumFrameSize).width()) ;
            pSWP->cy = min(pSWP->cy, (pFrame->fFrameWindowData->maximumFrameSize).height()) ;
         }
      }
      break ;

    case WM_HELP:
    {
       ITRACE_DEVELOP( "WM_HELP" );
       // Search the parent window chain beginning from the focus window for
       // a window with a dynamically-assigned help panel ID.
       unsigned long
         helpPanelId = 0;
       IWindowHandle
         windowToCheck( IQUERYFOCUS( IWindow::desktopWindow()->handle() ) ),
         frameWindow( event.dispatchingWindow()->handle() );
       while ( ! helpPanelId  &&  windowToCheck )
       {
          IWindow
           *window = IWindow::windowWithHandle( windowToCheck );
          if ( window  &&  window->helpId() )
          {        // Found a help panel to display.
             helpPanelId = window->helpId();
          }
          else if ( windowToCheck == frameWindow )
          {        // Exhausted the parent window chain.
             break;
          }
          else
          {
             windowToCheck = IPARENTOF( windowToCheck );
          }
       }

       if ( helpPanelId )
       {  // Have contextual help to display.

          // Let other handlers see the WM_HELP, since they may have dependencies
          // on it (like calling IHelpWindow::setActiveWindow).
          result = event.dispatchingWindow()->dispatchRemainingHandlers( event, false );
          if ( ! result )
          {  // Help request not handled yet.
             IHelpWindow
              *helpWindow = IHelpWindow::helpWindow( event.dispatchingWindow() );
             helpWindow->show( IResourceId( helpPanelId ) );
          }
          result = true;
       }
       // Else allow help table processing occur.

       break;
    }
#endif

#ifdef IC_PMWIN
#ifdef IC_WIN
    case WM_GETMINMAXINFO:
#endif
#ifdef IC_PM
    case WM_QUERYTRACKINFO:
#endif
       {
          ITRACE_DEVELOP("WM_QUERYTRACKINFO WM_GETMINMAXINFO") ;
          IFrameWindow *pFrame = (IFrameWindow *) event.window() ;
#ifdef IC_PM
          IEvent trackingSizeEvent(event) ;
          result = defaultProcedure(trackingSizeEvent).asUnsignedLong();
          PTRACKINFO pTrackingSizeInfo =
             (PTRACKINFO) (char *) trackingSizeEvent.parameter2() ;
#endif
#ifdef IC_WIN
          PMINMAXINFO pTrackingSizeInfo =
             (PMINMAXINFO) (char *) event.parameter2() ;
#endif
          if (pFrame->fFrameWindowData->bMaxFrameSizeSet)
             {
             long maxWidth((pFrame->fFrameWindowData->maximumFrameSize).width()) ;
             long maxHeight((pFrame->fFrameWindowData->maximumFrameSize).height()) ;
#ifdef IC_WIN
             pTrackingSizeInfo->ptMaxSize.x = maxWidth ;
             pTrackingSizeInfo->ptMaxSize.y = maxHeight ;
             pTrackingSizeInfo->ptMaxTrackSize.x = maxWidth ;
             pTrackingSizeInfo->ptMaxTrackSize.y = maxHeight ;
             result = true ;
#endif
#ifdef IC_PM
             pTrackingSizeInfo->ptlMaxTrackSize.x = maxWidth ;
             pTrackingSizeInfo->ptlMaxTrackSize.y = maxHeight ;
#endif
             }
          if (pFrame->fFrameWindowData->bMinFrameSizeSet)
             {
             long minWidth((pFrame->fFrameWindowData->minimumFrameSize).width()) ;
             long minHeight((pFrame->fFrameWindowData->minimumFrameSize).height()) ;
#ifdef IC_WIN
             pTrackingSizeInfo->ptMinTrackSize.x = minWidth ;
             pTrackingSizeInfo->ptMinTrackSize.y = minHeight ;
             result = true ;
#endif
#ifdef IC_PM
             pTrackingSizeInfo->ptlMinTrackSize.x = minWidth ;
             pTrackingSizeInfo->ptlMinTrackSize.y = minHeight ;
#endif
             }
#ifdef IC_PM
          if (result)
             event.setResult(trackingSizeEvent.result()) ;
#endif
       }
       break ;
#endif //IC_PMWIN


#ifdef IC_MOTIF
    case xEvent(ClientMessage):
    {
      XClientMessageEvent
        *xevent = (XClientMessageEvent *)event.parameter2().asUnsignedLong();
      if (xevent->type == ClientMessage)
      {
        if (xevent->data.l[0] == IFrameWindowData::wmSaveYourself)
        {
          IFrameEvent frameEvent(event);
          result = this->saved( frameEvent );

          if ( result )
            event.setResult( frameEvent.result());
        } // if wmSaveYourSelf
        else if (xevent->data.l[0] == IFrameWindowData::wmTakeFocus)
        {
          IFrameEvent frameEvent( event );
          result = this -> activated( frameEvent );

          if ( result )
            event.setResult ( frameEvent.result() );
        } // if wmTakeFocus
      } // if ClientMessage

    }
    break;
#endif //IC_MOTIF

#ifdef IC_PMWIN
    case WM_CHAR:
#endif // IC_PMWIN
#ifdef IC_WIN
  	case WM_KEYDOWN:
	  case WM_SYSCHAR:
#endif // IC_WIN
#ifdef IC_PMWIN
	  {
		  IKeyboardEvent keyEvent(event);
		  if( keyEvent.isVirtual())
		  	{
			  	switch( keyEvent.virtualKey())
				  {
					  case IKeyboardEvent::enter:
					  case IKeyboardEvent::newLine:

  						// don't pass on 'enter' because there is special
	  					// processing for that.
              result = event.dispatchingWindow()->dispatchRemainingHandlers( event, false );
			  			event.setResult(true);
		  				result = true;
				  	break;
					  default:
		  			break;
		  		}
		  	}
  	} /* endcase */
  	break;
#endif // IC_PMWIN
#ifdef IC_MOTIF
    case xEvent(KeyPress):
    {
        IKeyboardEvent keyEvent( event );
        if (keyEvent.isVirtual() )
        {
          if (keyEvent.virtualKey() == IKeyboardEvent::enter )
          {
            // Get the frame window's default button and click it.
            IWindow *pFrame = event.window();
            IWindowHandle hwndDefault =
               pFrame ? pFrame->defaultEmphasisButton() : IWindowHandle(0);

            if (hwndDefault && XtIsSensitive( (Widget)hwndDefault ) )
            {
              clickButton( hwndDefault );
              // Event is processed.
              result = true;
            }
          }
        }
      }
      break;
#endif // IC_MOTIF

    default:
      break;
    }

  return result;
}

/*------------------------------------------------------------------------------
| IFrameHandler::numberOfExtensions                                            |
|                                                                              |
| Return the number of frame extensions that the argument frame possesses.     |
------------------------------------------------------------------------------*/
// Moved to iframe.cpp

/*------------------------------------------------------------------------------
| IFrameHandler::format                                                        |
|                                                                              |
| Fills an array of window position structures, one for each frame control.    |
| This function does this for the frame extensions that have been added to the |
| frame using IFrameWindow::addExtension.                                      |
------------------------------------------------------------------------------*/
// Moved to iframe.cpp

/*------------------------------------------------------------------------------
| IFrameHandler::closed                                                        |
|                                                                              |
| Called when the frame window is closed.                                      |
| Notes:  If the frame is modal, dismiss it (presuming DID_CANCEL).            |
|         If there is a client, send it a WM_SYSCOMMAND/SC_CLOSE so that a     |
|           command handler attached to the client window can process the      |
|           close (but first turn on a special bit indicating that the event   |
|           is dispatched from the frame, so a canvas client will not route    |
|           the command event back to the frame).                              |
|         If the frame indicates it should destroy the window on close, then   |
|           WinDestroyWindow.                                                  |
|         Return true (so default window procedure never gets called)          |
------------------------------------------------------------------------------*/
bool IFrameHandler::closed ( IFrameEvent &frameEvent )
  {
  IMODTRACE_DEVELOP( "IFrameHandler::closed" );

  IFrameWindow* frame = frameEvent.frame();

#ifdef IC_MOTIF
  int n = 0;
  Arg args[1];
  // We will explicitly call XtDestroyWidget.  Set the VendorShell
  // resource XmNdeleteResponse accordingly.
  XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING ); n++;
  XtSetValues( frame->fFrameWindowData->shell,
               args,
               n);
#endif //IC_MOTIF

  // Return the current result.  This value is initialized to DID_CANCEL so if
  // the application has not explicitly set a result we return DID_CANCEL.
  if ( frame->isModal() )
      frame->dismiss( frame->result() );


  /********************************************/
  /* Notify that the frame window is closing. */
  /********************************************/
  frameEvent.window()->notifyObservers(INotificationEvent(
                                       IFrameWindow::closeId,
                                       *(frameEvent.window()), false));

  IWindowHandle
     client =  frame->clientHandle();
  if ( client )
  {                          // Client area to route events back to
#ifdef IC_MOTIFPM
    IEventParameter1 ul1( SC_CLOSE );
    // Route event with special flag in mp2 on to client
    IEventParameter2 ul2(
        (unsigned short)( (frameEvent.eventId() == WM_SYSCOMMAND) ?
           frameEvent.parameter2().lowNumber() : CMDSRC_OTHER ) | 0x8000,
        false);
#endif
#ifdef  IC_WIN
    // Route event with special flag in wparam high order word on to client
    // The high word of wparam is not used by Windows.
    IEventParameter1 ul1(SC_CLOSE, 0x8000 | CMDSRC_OTHER );
    IEventParameter2 ul2(frameEvent.parameter2());
#endif
    client.sendEvent(WM_SYSCOMMAND, ul1, ul2);
  }

#ifdef IC_MOTIF
  // Handle close of owned windows.

  // Enumerate the children of the application shell.
  Widget     w           (IWindow::desktopWindow()->handle());
  Cardinal   numChildren (w->core.num_popups);
  if (numChildren)
  {
      // Make a copy of the popup list.
      WidgetList  popupList = new Widget[numChildren];
      Cardinal    i;
      for (i = 0 ; i < numChildren; i++)
         popupList[i] = w->core.popup_list[i];
      // Iterate the list to see if we need to act on any of the popups
      for (i = 0; i < numChildren; i++)
      {
          // If the top level window is owned by this one then send it
          // a WM_CLOSE message.
          Widget child(popupList[i]);
          if ((child != frame->handle()) && !child->core.being_destroyed)
          {
              IWindow* win = IWindow::windowWithHandle( child );
              if (win && win->isValid() && (win->owner() == frame))
              {
                  // Send and not post to get close of ownee to happen
                  // before this window finishes closing.
                  ITRACE_DEVELOP( IString("Closing ownee ") +
                                  IString( win->handle().asUnsigned() ).d2x());
                  win->sendEvent(WM_CLOSE);
              }
          }
      }
      delete [] popupList;
  }
#endif

#ifdef IC_MOTIFWIN
  IWindow* pOwner = frame->owner();
  if( pOwner )
  {
  	pOwner->setFocus();
  }
#endif  // IC_WIN


  if ( frame->willDestroyOnClose() )
  {
      frame->postEvent(IC_UM_DESTROY_FRAME);
  }

  return true;
  }

/*------------------------------------------------------------------------------
| IFrameHandler::activated                                                     |
|                                                                              |
| Called when the frame window is activated.                                   |
| Notes:  The default implementation simply returns false.                     |
------------------------------------------------------------------------------*/
bool IFrameHandler::activated ( IFrameEvent &frameEvent )
  {
  return false;
  }

/*------------------------------------------------------------------------------
| IFrameHandler::deactivated                                                   |
|                                                                              |
| Called when the frame is asked to give up the input focus.                   |
| Notes:  The default implementation simply returns false.                     |
------------------------------------------------------------------------------*/
bool IFrameHandler::deactivated ( IFrameEvent &frameEvent )
  {
  return false;
  }

/*------------------------------------------------------------------------------
| IFrameHandler::saved                                                         |
|                                                                              |
| Called when the application statis is to be saved.                           |
| Notes:  The default implementation simply returns false.                     |
------------------------------------------------------------------------------*/
bool IFrameHandler::saved ( IFrameEvent &frameEvent )
  {
  return false;
  }

/*------------------------------------------------------------------------------
| IFrameHandler::draw                                                          |
|                                                                              |
| Called when the frame window needs to be redrawn.  This function draws the   |
| separator lines between frame extensions and returns false.                  |
| Notes: Iterate extensions, drawing each via IFrameExtension::drawSeparator.  |
------------------------------------------------------------------------------*/
// Moved to iframe.cpp

/*------------------------------------------------------------------------------
| IFrameHandler::command                                                       |
|                                                                              |
| Called when the frame window receives a command event.  This function checks |
| to see if the frame has a client.  If so, it returns false (so the client    |
| can receive the event).  Otherwise, it returns true.                         |
| Notes:  If there's a client, send it the WM_COMMAND with a special bit       |
|           turned on indicating that the event is dispatched from the frame,  |
|           so that a canvas client area won't route it back to the frame.     |
|         Always return true so PM's frame window procedure won't try to route |
|           it again to the client  (without the bit turn on).                 |
------------------------------------------------------------------------------*/
bool IFrameHandler::command ( ICommandEvent &cmdEvent )
{
  if ( cmdEvent.commandId() == IC_ID_HELP )
     {
     // Command to request help.
     // Hopefully the client isn't expecting to see this command routed
     // from the frame window.  Since there is no standard protocol for
     // a window procedure to indicate whether it has processed a
     // WM_COMMAND message, we cannot first route it to the client with
     // plans to provide default processing if the client does nothing.
     // The application can always override this default processing if
     // it attaches a command handler to the frame window.
#ifdef IC_WIN
     cmdEvent.dispatchingWindow()->sendEvent( IC_UM_CONTEXT_HELP );
#endif //IC_WIN
#ifdef IC_MOTIFPM
     cmdEvent.dispatchingWindow()->sendEvent( WM_HELP );
#endif //IC_MOTIFPM
     }
  else
     {  // Some other unprocessed command that we'll route to the client.

     // Dispatch the event to any handlers after this one in
     // then handler list.  If none handle it pass the event
     // on to the client.
     if ( !cmdEvent.dispatchingWindow()->dispatchRemainingHandlers(
                                            cmdEvent, false) )
         {
#ifdef IC_PMWIN
         IWindowHandle
            client = IWINDOWFROMID( cmdEvent.handle(), FID_CLIENT );
#endif // IC_PMWIN
#ifdef IC_MOTIF
         IFrameWindow *frame = (IFrameWindow *)cmdEvent.window();
         IWindowHandle
           client = frame->clientHandle();
#endif //IC_MOTIF
         if ( client )
             {     // Tinker with WM_COMMAND before sending it to client.
#ifdef IC_WIN
             unsigned long wparam = (unsigned long)cmdEvent.parameter1();
             IEventResult evtres =
               client.sendEvent( WM_COMMAND,
                                 IEventParameter1( 0x80000000ul | wparam ),
                                 cmdEvent.parameter2() );
                                       // Turn on special flag in wNotifyCode.
#endif //IC_WIN
#ifdef IC_MOTIFPM
             unsigned long ul2 = (unsigned long)cmdEvent.parameter2();

             IEventResult evtres =
               client.sendEvent( WM_COMMAND,
                                 cmdEvent.parameter1(),
                                 IEventParameter2( (unsigned short)(ul2 | 0x8000),
                                                   false ) );
                                       // Turn on special flag in mp2.
#endif //IC_MOTIFPM
             cmdEvent.setResult(evtres);
             }    // has client
        }   // not handled by remaining handlers
     }   // not help
  return true;   // Don't let WC_FRAME winproc also forward to client.
}

/*------------------------------------------------------------------------------
| IFrameHandler::calcRect                                                      |
|                                                                              |
| Iterate extensions, expand frame rectangle by height and width of            |
| each extension if given a client rectangle, shrink client rectangle          |
| by height and width of each extension if given a frame rectangle.            |
------------------------------------------------------------------------------*/
// Moved to iframe.cpp

/*------------------------------------------------------------------------------
| IFrameHandler::IFrameHandler                                                 |
|                                                                              |
| Empty constructor here for page tuning.                                      |
------------------------------------------------------------------------------*/
IFrameHandler::IFrameHandler ( )
  {
  }

/*------------------------------------------------------------------------------
| IFrameHandler::~IFrameHandler                                                |
|                                                                              |
| Empty destructor here for page tuning.                                       |
------------------------------------------------------------------------------*/
IFrameHandler::~IFrameHandler ( )
  {
  }

