/*
** Module   :BUILD.CMD
** Abstract :
**
** Copyright (C) Sergey I. Yevtushenko
** Last Update :Wed  10-04-96
**      Update :Mon  08-04-96
*/

'@echo off'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
WATCOM=VALUE('WATCOM',,'OS2ENVIRONMENT')

parse upper arg comp_mode rest

comp_mode=translate(comp_mode)

if comp_mode = '-?'
then do
    say 'Usage: build <mode>'
    say ' Modes list:'
    say '   WC  - Watcom C'
    say '   WCD - Watcom C with debug'
    say '   EMX - gcc '
    say '   BC  - Borland'
    say '   BCD - Borland with debug'
    say '   VA  - VAC++'
    say '   VAD - VAC++ with debug'
    exit
end

if comp_mode = ''
    then comp_mode='WC'

say 'Using mode <'comp_mode'>'

if wordpos(comp_mode,'WC WCD BC BCD EMX VA VAD') = 0
then do
    say 'Unknow mode' comp_mode
    exit
end

if left(comp_mode, 1) = 'B'
then do
    if right(comp_mode, 1) = 'D'
    then CC = "bcc -v -y -I..\include "
    else CC = "bcc -I..\include -Ox"
end
if left(comp_mode, 1) = 'E'
then do
    CC="gcc -I..\include -Zstack 5120 -Zomf -Zsys -fno-rtti -O6 -fomit-frame-pointer -fpeephole -fexpensive-optimizations -mpentium -s "
end
if left(comp_mode, 1) = 'V'
then do
    CC='icc -O+ -Ss+ -Gs+ -G5 -Tl- -I..\include -B"/ST:327680 /NOE /PMTYPE:PM"'
    if right(comp_mode, 1) = 'D'
        then CC=CC '-Tm+ -Ti+ -Fm+'
end
if left(comp_mode, 1) = 'W'
then do
    if right(comp_mode, 1) = 'D'
    then
        CC='wcl386 -i=$(WATCOM)\h;$(WATCOM)\h\os2;..\include -K327680 -d2 -"op symf"';
    else
        CC='wcl386 -i=$(WATCOM)\h;$(WATCOM)\h\os2;..\include -zq -zm -5r -onatx -K327680 -"op eliminate"';
end

instrm = "library.dep"
outstrm = "library.mk"
path.backup='.\backup'
path.obj='.\obj'
path.lib=path.obj
path.exe=path.obj
path.cpp='.\source'
path.h='.\include'

if fileexist(path.backup, 'D') <> 1
    then 'mkdir 'path.backup
if fileexist(path.obj, 'D') <> 1
    then 'mkdir 'path.obj

'cd 'path.cpp
'makedep -i.'path.h' -s *.c* | grep -v .cmd >..\source.dep'
'grep -l main.*( *.c* >..\targets.tmp'
'grep -v -f ..\targets.tmp ..\source.dep > ..\library.dep'
'cd ..'
'mv library.rsp library.rsp.bak'

call lineout outstrm, "# Makefile generated by BUILD.CMD", 1
call lineout outstrm, "#" date() 'at' time()
call lineout outstrm, "# Mode "comp_mode
call lineout outstrm, ""
call lineout outstrm, "# Compiler"
call lineout outstrm, 'CC='CC
call lineout outstrm, ""
call lineout outstrm, "# Librarian"
call lineout outstrm, "LIBRARIAN=tlib"
call lineout outstrm, ""
call lineout outstrm, "# Resource compiler"
call lineout outstrm, "RC=rc -i ..\include"
call lineout outstrm, ""
call lineout outstrm, "# Rules"
call lineout outstrm, ""
call lineout outstrm, ".path.obj="path.obj
call lineout outstrm, ".path.lib="path.lib
call lineout outstrm, ".path.exe="path.exe
call lineout outstrm, ".path.cpp="path.cpp
call lineout outstrm, ".path.res="path.cpp
call lineout outstrm, ".path.rc="path.cpp
call lineout outstrm, ".path.c="path.cpp
call lineout outstrm, ".path.h="path.h
call lineout outstrm, ""
call lineout outstrm, ".c.obj:"
call lineout outstrm, "09"x"@cd "path.obj
call lineout outstrm, "09"x"$(CC) -c .$<"
call lineout outstrm, "09"x"@cd .."
call lineout outstrm, ""
call lineout outstrm, ".cpp.obj:"
call lineout outstrm, "09"x"@cd "path.obj
call lineout outstrm, "09"x"$(CC) -c .$<"
call lineout outstrm, "09"x"@cd .."
call lineout outstrm, ""
call lineout outstrm, ".rc.res:"
call lineout outstrm, "09"x"@cd "path.cpp
call lineout outstrm, "09"x"$(RC) -r .$<"
call lineout outstrm, "09"x"@cd .."
call lineout outstrm, ""
call lineout outstrm, "# Libary dependencyes"
call lineout outstrm, ""
call lineout outstrm, "OBJS = \"

do while lines(instrm) <> 0
    parse value linein(instrm) with name ':' rest
    name = substr(strip(name),lastpos('\',name)+1)
    if lines(instrm) <> 0
    then call lineout outstrm, "  " name " \"
    else call lineout outstrm, "  " name
end

call lineout outstrm, ""
call lineout outstrm, "# Targets "

instrm = 'targets.tmp'
targlist = 'ALL : '

do while lines(instrm) <> 0
    name = linein(instrm)
    name = substr(strip(name),lastpos('\',name)+1)
    parse value name with name '.' ext
    targlist = targlist  name'.EXE'
end

call linein instrm, 1, 0

call lineout outstrm, targlist
call lineout outstrm, ""
call lineout outstrm, 'COMMON.LIB : $(OBJS)'
call lineout outstrm, "09"x"@cd "path.obj
call lineout outstrm, '09'x'@$(LIBRARIAN) COMMON.LIB @..\library.rsp'
call lineout outstrm, "09"x"@cd .."
call lineout outstrm, ""

do while lines(instrm) <> 0
    name=linein(instrm)
    name=strip(substr(strip(name),lastpos('\',name)+1))
    parse value name with name '.' ext

    call lineout outstrm, name'.EXE : COMMON.LIB' name'.obj' name'.res'
    call lineout outstrm, "09"x"@cd "path.obj
    call lineout outstrm, '09'x'@$(CC) 'name'.obj COMMON.LIB'
    call lineout outstrm, '09'x'@$(RC) ..\source\'name'.res 'name'.exe'
    call lineout outstrm, '09'x'@exehdr 'name'.exe /PMTYPE:PM >nul'
    call lineout outstrm, "09"x"@cd .."
    call lineout outstrm, ""
end

call lineout outstrm, "# Special 'backup' target"
call lineout outstrm, "backup:"
call lineout outstrm, '09'x"@backup.cmd"
call lineout outstrm, ""
call lineout outstrm, "# Special 'clean' target"
call lineout outstrm, "clean:"
call lineout outstrm, '09'x"-@del "path.obj"\*.obj >nul 2>nul"
call lineout outstrm, '09'x"-@del "path.obj"\*.lib >nul 2>nul"
call lineout outstrm, '09'x"-@del "path.obj"\*.bak >nul 2>nul"
call lineout outstrm, ""
call lineout outstrm, "# Individual dependencies"
call lineout outstrm, ""

instrm = "source.dep"

do while lines(instrm) <> 0
    name=linein(instrm)
    name=strip(substr(strip(name),lastpos('\',name)+1))
    call lineout outstrm, name
end


call lineout outstrm, ""
call lineout outstrm, "# End"
call lineout outstrm

rc = stream('library.dep', 'c', 'close')
instrm = "library.dep"
outstrm= "library.rsp"

do while lines(instrm) <> 0
    name=linein(instrm)
    name=strip(substr(strip(name),lastpos('\',name)+1))
    parse value name with name ':' rest
    name = strip(name)
    if lines(instrm) <> 0
    then call lineout outstrm, "-+"name "&"
    else call lineout outstrm, "-+"name
end
call lineout outstrm

/* Close streams */

rc = stream('source.dep' , 'c', 'close')
rc = stream('targets.tmp', 'c', 'close')
rc = stream('library.dep', 'c', 'close')
rc = stream('library.rsp', 'c', 'close')
rc = stream('library.mk', 'c', 'close')

/* Cleanup */

'del source.dep      >nul 2>nul'
'del targets.tmp     >nul 2>nul'
'del library.dep     >nul 2>nul'
'del library.rsp.bak >nul 2>nul'
'del .\obj\*.obj /N'
/* Last step */
'mv library.mk makefile >nul 2>nul'
/* Processing done  */

exit

fileexist:
    call SysFileTree ARG(1), stem, ARG(2)
return stem.0;

