<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html-40/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="author" content="Ullrich von Bassewitz">
<title>CC65 - known bugs</title>
</head>


<body bgcolor="#FFFFFF" text="#000000" link="#0000FF" vlink="#000080" alink="#FF0000" background="cc65-bg.png">


<!-- GO -->
<table align="left" border="0" cellpadding="0" cellspacing="0" width="100%">
<tr><td><img  src="null.gif" width="110" alt=""></td><td>

<table width="100%">
<tr><td>
        <img width="290" height="50"  src="knownbugs.png" alt="Known Bugs">
    </td><td align="right">
        <img width="300" height="150"  src="cc65.png" alt="">
    </td>
</tr>
</table>

<hr size=1 noshade><p><br><p>


<h2>Version 2.6.1</h2>

<center>
<table border="0" width="100%">
<tr><td><img width="10" alt="" src="null.gif"></td><td>
<table width="100%" border="1" cellspacing="0" cellpadding="0">
<tr>
    <td align="center"><table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td><strong>Component</strong></td></tr></table></td>
    <td align="center"><table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td><strong>Description</strong></td></tr></table></td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Compiler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The compiler will crash after a function declaration that uses two
        or more identical parameter names, and a call to this function.
        This input is of course wrong, but the compiler shouldn't crash.<br>
        <strong>Workaround: </strong>Don't do it:-)<br>
        <strong>Fix: </strong>Is fixed in the development version.
        </td></tr></table>
    </td>
</tr>
</table>
</td><td><img width="10" alt="" src="null.gif"></td></table></center>
<p><br><p>


<h2>Version 2.6.0</h2>

<center>
<table border="0" width="100%">
<tr><td><img width="10" alt="" src="null.gif"></td><td>
<table width="100%" border="1" cellspacing="0" cellpadding="0">
<tr>
    <td align="center"><table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td><strong>Component</strong></td></tr></table></td>
    <td align="center"><table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td><strong>Description</strong></td></tr></table></td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Assembler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Absolute long addressing does not work in 65816 mode. This is a problem
        that was introduced some time ago with a change in the handling of
        pseudo instructions (assembler commands). The problem is that the
        dot (which is needed to separate bank and address in long addressing
        mode) is not handled as a separate token by the scanner, but as part
        of an (illegal) pseudo instruction.<br>
        <strong>Workaround: </strong>You may use a macro that encodes the
        necessary instructions by emitting literal bytes. Here is an example:
        <pre>
            .macro  ldaf    addr
                    .byte           $AF
                    .faraddr        addr
            .endmacro
        </pre>
        <strong>Fix: </strong>Download and apply the
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/patch-2.6.0-03.txt">patch</a>,
        then recompile the assembler. Please note that this patch is not a
        complete solution for the problem. If the intra bank address is a
        symbol, you will have to enclose it in parenthesis to make it work.<br>
        <strong>Bug found by: </strong>John Weidman &lt;jweidman@slip.net&gt;<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Runtime library
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Several small subroutines that increment the primary register (ax)
        have errors.<br>
        <strong>Workaround: </strong>None<br>
        <strong>Fix: </strong>Download the replacement modules
        <ul>
        <li><a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/incax3.s">incax3.s</a>
        <li><a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/incax5.s">incax5.s</a>
        <li><a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/incax6.s">incax6.s</a>
        <li><a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/incax7.s">incax7.s</a>
        <li><a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/incax8.s">incax8.s</a>
        </ul>
        from the patch directory, and recompile the library. You may also add
        these files to your project, so they are used instead of the ones from
        the library when linking.<br>
        <strong>Bug found by: </strong>Eric Au &lt;eric_au@hotmail.com&gt;<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Compiler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        In 65C02 mode (that is, with an explicit <code>--cpu 65C02</code> given
        on the command line) with optimization enabled, the optimizer
        generates several dangling pointers when trying to translate bit
        operations into the 65C02 <code>TRB</code> and <code>TSB</code>
        instructions. The results differ from platform to platform but are
        usually unpleasant: The Linux version often generates wrong code,
        the Windows version will crash with a segmentation violation.<br>
        <strong>Please note </strong>that this bug is <strong>only</strong>
        triggered in 65C02 mode with optimization enabled. If you use 6502
        mode (the default) or disable optimizations, you don't need to care
        about it.<br>
        <strong>Workaround: </strong>Disable the buggy optimizer step by using
        the (undocumented) <code>-Of</code> option. Add
        <pre>
                -Of0x1000
        </pre>
        to the compiler command line. You may also disable optimization
        completely, but this is often not desirable.<br>
        <strong>Fix: </strong>Apply
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/patch-2.6.0-01.txt">this patch</a>
        to the <code>optimize.c</code> module and and recompile the compiler.<br>
        <strong>Bug found by: </strong>Dennis Lin &lt;dennis@mosart.com.tw&gt;<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Linker
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Using separate <code>load</code> and <code>run</code> areas
        does not work correctly.<br>
        <strong>Note: </strong>None of the predefined system uses this feature,
        you have to supply a configuration file to the linker to make use of
        it.<br>
        <strong>Workaround: </strong>In the linker configuration file, place
        all memory areas that are used as <code>load</code> areas before
        those used as <code>run</code> areas. That is, place the lines
        describing ROM areas before those describing RAM areas.<br>
        <strong>Fix: </strong>Apply
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/patch-2.6.0-02.txt">this patch</a>
        and recompile the linker.<br>
        <strong>Bug found by: </strong>Eric Bacher &lt;ebacher@teaser.fr&gt;<br>
        </td></tr></table>
    </td>
</tr>
</table>
</td><td><img width="10" alt="" src="null.gif"></td></table></center>
<p><br><p>


<h2>Version 2.5.0</h2>

<center>
<table border="0" width="100%">
<tr><td><img width="10" alt="" src="null.gif"></td><td>
<table width="100%" border="1" cellspacing="0" cellpadding="0">
<tr>
    <td align="center"><table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td><strong>Component</strong></td></tr></table></td>
    <td align="center"><table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td><strong>Description</strong></td></tr></table></td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Assembler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The <code>.IFP02</code>, <code>.IFPC02</code> and <code>.IFP816</code>
        instructions described in the docs are not available.<br>
        <strong>Workaround: </strong>Use
        <pre>
                .if     .cpu = x
        </pre>
        instead.<br>
        <strong>Fix: </strong>Is fixed in the development version.<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Standard C library
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The '+' and ' ' (space) flags in any of the printf functions do not
        work correctly. A plus or space character is added, even if the value
        is negative.<br>
        <strong>Workaround: </strong>None.<br>
        <strong>Fix: </strong>Apply the
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/patch-2.5.0-04.txt">patch</a>
        to the _printf.c module and and recompile the library.<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Linker
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The linker does not accept the <code>-h</code> command line option.<br>
        <strong>Workaround: </strong>Use <code>--help</code> instead.<br>
        <strong>Fix: </strong>Is fixed in the development version.<br>
        <strong>Bug found by: </strong>Christian Groessler, cpg@aladdin.de<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Compiler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Macro redefinitions are not detected and flagged as an error.<br>
        <strong>Workaround: </strong>None.<br>
        <strong>Fix: </strong>Is fixed in the development version.<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Compiler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The code generated for explicit type casts is sometimes wrong.<br>
        <strong>Workaround: </strong>Don't use explicit type casts if you don't
        need them.<br>
        <strong>Fix: </strong>I'm currently testing replacement code and will
        post a patch as soon as I'm confident that it works.<br>
        <strong>Bug found by: </strong>Eric Au, eric_au@hotmail.com<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Standard C library
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The <code>memcmp()</code> function does not work correctly.<br>
        <strong>Workaround: </strong>None available.<br>
        <strong>Fix: </strong>Use
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/memcmp.s">this</a>
        replacement function. Be sure to recompile the library or use it as
        part of your project (in this case the buggy one from the library
        will not be used).<br>
        <strong>Bug found by: </strong>Eric Au, eric_au@hotmail.com<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Runtime library
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The routine that handles <code>switch</code> statements for longs
        has a bug. There is a high chance that a label is not found, and
        the program may even crash.<br>
        <strong>Workaround: </strong>None available.<br>
        <strong>Fix: </strong>Apply the
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/patch-2.5.0-03.txt">patch</a>
        to the lswitch.s module and and recompile the library.<br>
        <strong>Bug found by: </strong>Greg King, gngking@erols.com<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        conio library
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        A change in the newline handling applied to v2.5 broke the
        <code>cvline</code> and <code>cvlinexy</code> functions. After
        output of the first character, the X position is reset to zero.<br>
        <strong>Workaround: </strong>Use calls to <code>cputc</code> or
        <code>cputcxy</code> to draw vertical lines.<br>
        <strong>Fix: </strong>There is currently no fix available.<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Assembler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        When using 65SC02 mode, the <code>BIT</code> instruction has a wrong
        encoding in immidiate mode. Both, 6502 mode and 65816 mode, as well as
        the other addressing modes are ok.<br>
        <strong>Workaround: </strong>Temporarily switch to 816 mode.<br>
        <strong>Fix: </strong>Apply the
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/patch-2.5.0-02.txt">patch</a>
        and recompile the assembler.<br>
        <strong>Bug found by: </strong>C. N. Wong, superufo@netvigator.com<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Compiler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Subtracting zero from a variable will compile but not link:
        <pre><code>
        Unresolved external `decax0' in ...
        </code></pre>
        <strong>Workaround: </strong>Don't do it:-)<br>
        <strong>Bug found by: </strong>Christian Groessler, cpg@aladdin.de<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        RedHat&nbsp;RPMs
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The header files needed for GEOS programs are not installed by the
        source RPMs and they are not included in the binary RPMs. In the
        second version of the RPMs, the geos subdirectory has the wrong
        permissions (I didn't notice because I tested it as root :-().<br>
        <strong>Fix: </strong>If you have the -2 RPMs, just fix the permissions
        of the <code>/usr/lib/cc65/include/geos</code> directory. If you have
        the -1 RPMs and if you want to create GEOS programs, download the
        updated -3 RPMs. Otherwise don't care.-)<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Assembler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        The <code>.ERROR</code> directive does not work. The error message
        "String constant expected" is displayed instead of the requested
        one.<br>
        <strong>Workaround: </strong>None. You may use <code>.OUT</code>
        instead, but you cannot avoid generation of the resulting binary.<br>
        <strong>Fix: </strong>Apply the
        <a href="ftp://ftp.musoftware.de/pub/uz/cc65/patches/patch-2.5.0-01.txt">patch</a>
        and recompile the assembler.<br>
        <strong>Bug found by: </strong>Dagan Galarneau, dagan@dnai.com<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Assembler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Defining a macro with <code>.DEFINE</code> in a <code>.IF...</code>
        sequence that is assembled more than once (for example because you
        writing an idempotent include file) will fail if the macro takes
        parameters. Here is an example:<br>
        <pre>
        .define foo(bar)        fubar, bar
        .if     0
        .define foo(bar)        fubar, bar
        .endif
        </pre>
        Defining the macro twice should not matter since the second definition
        should get skipped. Unfortunately, <code>.DEFINE</code> style macros
        are expanded when transforming the input into tokens. This is needed
        because you may also replace keywords by using these macros. So, when
        seeing the second "foo", the assembler tries to expand the macro
        <code>foo</code> and expects a parameter, but in fact a left paren
        follows, so it prints an error message, even if the resulting token
        would be skipped later.<br>
        <strong>Workaround: </strong>Try to avoid redefining
        <code>.DEFINE</code> style macros, even if the second definition is
        inside a <code>.IF...</code> statement. You may also use a classic
        macro instead.<br>
        <strong>Fix: </strong>This problem is inherent in the design and I'm
        not sure if it is possible to fix it.<br>
        <strong>Bug found by: </strong>Dagan Galarneau, dagan@dnai.com<br>
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Standard&nbsp;Headers
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        <code>time.h</code> contains a wrong definition. The macro
        <code>CLOCKS_PER_TICK</code> should be named
        <code>CLOCKS_PER_SEC</code>. One of the sample programs (nachtm.c)
        is using this wrong identifier.<br>
        <strong>Fix: </strong>Replace the identifier by
        <code>CLOCKS_PER_SEC</code>.
        </td></tr></table>
    </td>
</tr><tr>
    <td align="center">
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        Compiler
        </td></tr></table>
    </td><td>
        <table bgcolor="#ffffff" border="0" cellspacing="2"><tr><td>
        A local, static, uninitialized variable declaration, immidiately
        followed by the declaration of an initialized auto variable inside
        a function will cause the compiler to emit wrong code. What happens
        is that the segment is not switched, so the code to initialize the
        auto variable is emitted into the BSS segment.<br>
        The error is easily detected since the linker will emit a warning.<br>
        <strong>Workaround: </strong>Change the order of declarations, declare
        the static variable after the auto one, or place the declaration of an
        uninitialized auto varable between the two other decls.<br>
        <strong>Fix: </strong>Is fixed in the development version.<br>
        </td></tr></table>
    </td>
</tr>
</table>
</td><td><img width="10" alt="" src="null.gif"></td></table></center>
<p><br><p>


<!-- ------------------------- -->
<a href="oldbugs.php">Old bugs</a>
<p><br><p>

<table><tr>
    <td><a href="http://www.cc65.org/"><img border=0 width=35 height=32 alt=""  src="back.png"></a></td>
    <td><a href="http://www.cc65.org/">Back to the cc65 Main Page</a>.</td>
</tr></table>
<p>

<!-- Footer -->

<hr size=1 noshade>
<address>
    <a href="http://validator.w3.org/check?uri=http%3A%2F%2Fwww.cc65.org%2Fbugs.php">       <img border=0 src="http://validator.w3.org/images/vh40"
       alt="Valid HTML 4.0!" height=31 width=88 align=right></a>
    bugs.php; last change: 22-Mar-2001<br>
    <a href="mailto:webmaster@cc65.org">webmaster@cc65.org</a>
</address>

</td><td><img src="null.gif" width="20" alt=""></td></tr></table>

</body>
</html>

