/******************************************************************************/
/* DISCLAIMER OF WARRANTIES:                                                  */
/*   The following [enclosed] code is sample code created by IBM              */
/*   Corporation.  This sample code is not part of any standard IBM product   */
/*   and is provided to you solely for the purpose of assisting you in the    */
/*   development of your applications.  The code is provided "AS IS",         */
/*   without warranty of any kind.  IBM shall not be liable for any damages   */
/*   arising out of your use of the sample code, even if they have been       */
/*   advised of the possibility of such damages.                              */
/******************************************************************************/
#define INCL_WINFRAMEMGR
#include <os2.h>

#include <iframe.hpp>
#include <ipushbut.hpp>
#include <igraphbt.hpp>
#include <imcelcv.hpp>
#include <isetcv.hpp>
#include <iapp.hpp>
#include "buttons.h"

void main ()
{
   IFrameWindow frame ("Push Button Example");
   IMultiCellCanvas client (ID_MCELL, &frame, &frame);
   ISetCanvas buttonHolder (ID_BUTTONS, &client, &client);
   IPushButton
      okPushButton (ID_OK, &buttonHolder, &buttonHolder),
      cancelPushButton (SC_CLOSE, &buttonHolder, &buttonHolder);
   IResourceLibrary resLibrary;
   IPointerHandle iconHandle = resLibrary.loadIcon (ID_ICONBUTTON);
   IGraphicPushButton
      bitmapPushButton (ID_BITMAPBUTTON, &buttonHolder, &buttonHolder,
                        ISystemBitmapHandle (ISystemBitmapHandle::program)),
      iconPushButton (ID_ICONBUTTON, &buttonHolder, &buttonHolder,
                      iconHandle);
   IPushButton helpButton (ID_HELP, &buttonHolder, &buttonHolder, IRectangle(),
                           IPushButton::defaultStyle() | IPushButton::noPointerFocus);
   okPushButton.enableDefault()
               .setText ("OK")
               .enableTabStop()
               .enableGroup();

   cancelPushButton.enableSystemCommand()
                   .setText("Cancel");

   helpButton.enableHelp()
             .setText ("Help");

   client.addToCell (&buttonHolder, 2,6,3,1);
   client.setRowHeight (1,20,true);
   frame.setClient (&client)
        .setFocus()
        .show();
   IApplication::current().run();
}
