(* ====================================================== *)
(*                     VIOCALLS.PAS                       *)
(* ====================================================== *)
(*   Implementation of the funcions of VIOCALLS.DLL       *)
(* Only functions no 55 to 65 of the DLL are defined.     *)
(* Functions not yet implemented are commented in the     *)
(* implementation part of this unit.                      *)
(* ====================================================== *)
(*        Translation to Pascal by wr/toolbox mag         *)
(* ====================================================== *)

{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT VioCalls;

INTERFACE

USES
  Os2Def;

TYPE
  hVPs  = WORD;                (* hpvs *)
  pHVPS = ^hVPs; (* phpvs *)

CONST
  NULL = 0;

(* VIOCreatePS format constants *)

  FORMAT_CGA   = $00001;
  FORMAT_4BYTE = $00003;

(* Options for VIOQueryFonts *)

  VQF_PUBLIC   = $00001;
  VQF_PRIVATE  = $00002;

{ Die Funktionen VIOxxx und VIO16xxx sind identisch und    }
{ nur aus Kompatibilittsgrnden doppelt benamt mit dem    }
{ gleichen Einsprung in die DLL vorhanden.                 }

  FUNCTION VioAssociate  (h1 : hDC; h2 : hVPs) : WORD;
  FUNCTION Vio16Associate(h1 : hDC; h2 : hVPs) : WORD;

  FUNCTION VioCreateLogFont(  VAR f  : fAttrs;
                                  l1 : LongInt;
                                  l2 : LongInt;
                              VAR s  : Str8;
                                  h1 : hVPs): WORD;
  FUNCTION VIO16CreateLogFont(VAR f  : fAttrs;
                                  l1 : LongInt;
                                  l2 : LongInt;
                              VAR s  : Str8;
                                  h1 : hVPs): WORD;

  FUNCTION VioCreatePS(  VAR ahvps : hVPs;
                             a2    : WORD;
                             a3    : WORD;
                             a4    : WORD;
                             a5    : WORD;
                             hvps2 : hVPs): WORD;
  FUNCTION Vio16CreatePS(VAR ahvps : hVPs;
                             a2    : WORD;
                             a3    : WORD;
                             a4    : WORD;
                             a5    : WORD;
                             hvps2 : hVPs): WORD;

  FUNCTION VioDestroyPS  (h : hVPs) : WORD;
  FUNCTION Vio16DestroyPS(h : hVPs) : WORD;

  FUNCTION VioDeleteSetId  (a1: LongInt; a2: hVPs): WORD;
  FUNCTION Vio16DeleteSetId(a1: LongInt; a2: hVPs): WORD;

  FUNCTION VioGetDeviceCellSize(  VAR a1 : LongInt;
                                  VAR a2 : LongInt;
                                      a3 : hVPs): WORD;
  FUNCTION Vio16GetDeviceCellSize(VAR a1 : LongInt;
                                  VAR a2 : LongInt;
                                      a3 : hVPs): WORD;

  FUNCTION VioGetOrg(  VAR a1 : LongInt;
                       VAR a2 : LongInt;
                           h1 : hVPs): WORD;
  FUNCTION Vio16GetOrg(VAR a1 : LongInt;
                       VAR a2 : LongInt;
                           h1 : hVPs): WORD;

  FUNCTION VioQueryFonts(  VAR a1       : LongInt;
                           VAR f        : FontMetrics;
                               a3       : LongInt;
                           VAR a4       : LongInt;
                               CharAddr : pChar;
                               a6       : LongInt;
                               a7       : hVPs): WORD;
  FUNCTION Vio16QueryFonts(VAR a1       : LongInt;
                           VAR f        : FontMetrics;
                               a3       : LongInt;
                           VAR a4       : LongInt;
                               CharAddr : pChar;
                               a6       : LongInt;
                               a7       : hVPs): WORD;

  FUNCTION VioQuerySetIds(  VAR p1   : LongInt;
                            VAR Str8 : Str8;
                            VAR p3   : LongInt;
                                p4   : LongInt;
                                p5   : hVPs): WORD;
  FUNCTION Vio16QuerySetIds(VAR p1   : LongInt;
                            VAR Str8 : Str8;
                            VAR p3   : LongInt;
                                p4   : LongInt;
                                p5   : hVPs): WORD;

  FUNCTION VioSetDeviceCellSize  (a1 : WORD;
                                  a2 : WORD;
                                  a3 : hVPs): WORD;
  FUNCTION Vio16SetDeviceCellSize(a1 : WORD;
                                  a2 : WORD;
                                  a3 : hVPs): WORD;

  FUNCTION VioSetOrg  (a1, a2: WORD; a3: hVPs): WORD;
  FUNCTION Vio16SetOrg(a1, a2: WORD; a3: hVPs): WORD;

  FUNCTION VioShowPS  (a1, a2, a3: WORD; h1: hVPs): WORD;
  FUNCTION Vio16ShowPS(a1, a2, a3: WORD; h1: hVPs): WORD;


IMPLEMENTATION

{ **********************************************************

  FUNCTION VIOEndPopup(* ------------- *);
    External 'VIOCalls' INDEX  1;
  FUNCTION VIO16EndPopup(* ------------- *);
    External 'VIOCalls' INDEX  1;

  FUNCTION VIOGetPhysBuf(* ------------- *);
    External 'VIOCalls' INDEX   2;
  FUNCTION VIO16GetPhysBuf(* ------------- *);
    External 'VIOCalls' INDEX   2;

  FUNCTION VIOGetANSI(* ------------- *);
    External 'VIOCalls' INDEX   3;
  FUNCTION VIO16GetANSI(* ------------- *);
    External 'VIOCalls' INDEX   3;

(* ===================================================== *)

  FUNCTION VIOSetANSI(* ------------- *);
    External 'VIOCalls' INDEX   5;
  FUNCTION VIO16SetANSI(* ------------- *);
    External 'VIOCalls' INDEX   5;

  FUNCTION VIODeRegister(* ------------- *);
    External 'VIOCalls' INDEX   6;
  FUNCTION VIO16DeRegister(* ------------- *);
    External 'VIOCalls' INDEX   6;

  FUNCTION VIOScrollUp(* ------------- *);
    External 'VIOCalls' INDEX   7;
  FUNCTION VIO16ScrollUp(* ------------- *);
    External 'VIOCalls' INDEX   7;

  FUNCTION VIOPrtSC(* ------------- *);
    External 'VIOCalls' INDEX   8;
  FUNCTION VIO16PrtSC(* ------------- *);
    External 'VIOCalls' INDEX   8;

  FUNCTION VIOGetCurPos(* ------------- *);
    External 'VIOCalls' INDEX   9;
  FUNCTION VIO16GetCurPos(* ------------- *);
    External 'VIOCalls' INDEX   9;

  FUNCTION VIOWRTCellStr(* ------------- *);
    External 'VIOCalls' INDEX  10;
  FUNCTION VIO16WRTCellStr(* ------------- *);
    External 'VIOCalls' INDEX  10;

  FUNCTION VIOPopup(* ------------- *);
    External 'VIOCalls' INDEX  11;
  FUNCTION VIO16Popup(* ------------- *);
    External 'VIOCalls' INDEX  11;

  FUNCTION VIOScrollRT(* ------------- *);
    External 'VIOCalls' INDEX  12;
  FUNCTION VIO16ScrollRT(* ------------- *);
    External 'VIOCalls' INDEX  12;

  FUNCTION VIOWRTCharStr(* ------------- *);
    External 'VIOCalls' INDEX  13;
  FUNCTION VIO16WRTCharStr(* ------------- *);
    External 'VIOCalls' INDEX  13;

(* ===================================================== *)

  FUNCTION VIOSetCurPos(* ------------- *);
    External 'VIOCalls' INDEX  15;
  FUNCTION VIO16SetCurPos(* ------------- *);
    External 'VIOCalls' INDEX  15;

(* ===================================================== *)

  FUNCTION VIOScrUnlock(* ------------- *);
    External 'VIOCalls' INDEX  18;
  FUNCTION VIO16ScrUnlock(* ------------- *);
    External 'VIOCalls' INDEX  18;

  FUNCTION VIOWrtTTY(* ------------- *);
    External 'VIOCalls' INDEX  19;
  FUNCTION VIO16WrtTTY(* ------------- *);
    External 'VIOCalls' INDEX  19;

  FUNCTION VIOGetMode(* ------------- *);
    External 'VIOCalls' INDEX  21;
  FUNCTION VIO16GetMode(* ------------- *);
    External 'VIOCalls' INDEX  21;

  FUNCTION VIOSetMode(* ------------- *);
    External 'VIOCalls' INDEX  22;
  FUNCTION VIO16SetMode(* ------------- *);
    External 'VIOCalls' INDEX  22;

  FUNCTION VIOScrLock(* ------------- *);
    External 'VIOCalls' INDEX  23;
  FUNCTION VIO16ScrLock(* ------------- *);
    External 'VIOCalls' INDEX  23;

  FUNCTION VIOReadCellStr(* ------------- *);
    External 'VIOCalls' INDEX  24;
  FUNCTION VIO16ReadCellStr(* ------------- *);
    External 'VIOCalls' INDEX  24;

  FUNCTION VIOSavRedrawWait(* ------------- *);
    External 'VIOCalls' INDEX  25;
  FUNCTION VIO16SavRedrawWait(* ------------- *);
    External 'VIOCalls' INDEX  25;

  FUNCTION VIOWRTNAttr(* ------------- *);
    External 'VIOCalls' INDEX  26;
  FUNCTION VIO16WRTNAttr(* ------------- *);
    External 'VIOCalls' INDEX  26;

  FUNCTION VIOGetCurType(* ------------- *);
    External 'VIOCalls' INDEX  27;
  FUNCTION VIO16GetCurType(* ------------- *);
    External 'VIOCalls' INDEX  27;

  FUNCTION VIOSavRedrawUnDo(* ------------- *);
    External 'VIOCalls' INDEX  28;
  FUNCTION VIO16SavRedrawUnDo(* ------------- *);
    External 'VIOCalls' INDEX  28;

  FUNCTION VIOGetFont(* ------------- *);
    External 'VIOCalls' INDEX  29;
  FUNCTION VIO16GetFont(* ------------- *);
    External 'VIOCalls' INDEX  29;

  FUNCTION VIOReadCharStr(* ------------- *);
    External 'VIOCalls' INDEX  30;
  FUNCTION VIO16ReadCharStr(* ------------- *);
    External 'VIOCalls' INDEX  30;

  FUNCTION VIOGetBuf(* ------------- *);
    External 'VIOCalls' INDEX  31;
  FUNCTION VIO16GetBuf(* ------------- *);
    External 'VIOCalls' INDEX  31;

  FUNCTION VIOSetCurType(* ------------- *);
    External 'VIOCalls' INDEX  32;
  FUNCTION VIO16SetCurType(* ------------- *);
    External 'VIOCalls' INDEX  32;

  FUNCTION VIOSetFont(* ------------- *);
    External 'VIOCalls' INDEX  33;
  FUNCTION VIO16SetFont(* ------------- *);
    External 'VIOCalls' INDEX  33;

(* ===================================================== *)

  FUNCTION VIOModeUnDo(* ------------- *);
    External 'VIOCalls' INDEX  35;
  FUNCTION VIO16ModeUnDo(* ------------- *);
    External 'VIOCalls' INDEX  35;

(* ===================================================== *)

  FUNCTION VIOModeWait(* ------------- *);
    External 'VIOCalls' INDEX  37;
  FUNCTION VIO16ModeWait(* ------------- *);
    External 'VIOCalls' INDEX  37;

(* ===================================================== *)

  FUNCTION VIOGetCP(* ------------- *);
    External 'VIOCalls' INDEX  40;
  FUNCTION VIO16GetCP(* ------------- *);
    External 'VIOCalls' INDEX  40;

(* ===================================================== *)

  FUNCTION VIOSetCP(* ------------- *);
    External 'VIOCalls' INDEX  42;
  FUNCTION VIO16SetCP(* ------------- *);
    External 'VIOCalls' INDEX  42;

  FUNCTION VIOShowBuf(* ------------- *);
    External 'VIOCalls' INDEX  43;
  FUNCTION VIO16ShowBuf(* ------------- *);
    External 'VIOCalls' INDEX  43;

  FUNCTION VIOScrollLf(* ------------- *);
    External 'VIOCalls' INDEX  44;
  FUNCTION VIO16ScrollLf(* ------------- *);
    External 'VIOCalls' INDEX  44;

  FUNCTION VIORegister(* ------------- *);
    External 'VIOCalls' INDEX  45;
  FUNCTION VIO16Register(* ------------- *);
    External 'VIOCalls' INDEX  45;

  FUNCTION VIOGetConfig(* ------------- *);
    External 'VIOCalls' INDEX  46;
  FUNCTION VIO16GetConfig(* ------------- *);
    External 'VIOCalls' INDEX  46;

  FUNCTION VIOScrollDn(* ------------- *);
    External 'VIOCalls' INDEX  47;
  FUNCTION VIO16ScrollDn(* ------------- *);
    External 'VIOCalls' INDEX  47;

  FUNCTION VIOWRTCharStrAtt(* ------------- *);
    External 'VIOCalls' INDEX  48;
  FUNCTION VIO16WRTCharStrAtt(* ------------- *);
    External 'VIOCalls' INDEX  48;

  FUNCTION VIOGetState(* ------------- *);
    External 'VIOCalls' INDEX  49;
  FUNCTION VIO16GetState(* ------------- *);
    External 'VIOCalls' INDEX  49;

  FUNCTION VIOPrtSCToggle(* ------------- *);
    External 'VIOCalls' INDEX  50;
  FUNCTION VIO16PrtSCToggle(* ------------- *);
    External 'VIOCalls' INDEX  50;

  FUNCTION VIOSetState(* ------------- *);
    External 'VIOCalls' INDEX  51;
  FUNCTION VIO16SetState(* ------------- *);
    External 'VIOCalls' INDEX  51;

  FUNCTION VIOWrtNCell(* ------------- *);
    External 'VIOCalls' INDEX  52;
  FUNCTION VIO16WrtNCell(* ------------- *);
    External 'VIOCalls' INDEX  52;

  FUNCTION VIOWrtNChar(* ------------- *);
    External 'VIOCalls' INDEX  53;
  FUNCTION VIO16WrtNChar(* ------------- *);
    External 'VIOCalls' INDEX  53;

********************************************************** }

(* ===================================================== *)

  FUNCTION VioAssociate;       EXTERNAL 'VIOCalls' INDEX 55;
  FUNCTION Vio16Associate;     EXTERNAL 'VIOCalls' INDEX 55;

  FUNCTION VioCreatePS;        EXTERNAL 'VIOCalls' INDEX 56;
  FUNCTION Vio16CreatePS;      EXTERNAL 'VIOCalls' INDEX 56;

  FUNCTION VioDeleteSetId;     EXTERNAL 'VIOCalls' INDEX 57;
  FUNCTION Vio16DeleteSetId;   EXTERNAL 'VIOCalls' INDEX 57;

  FUNCTION VioGetDeviceCellSize;
  EXTERNAL 'VIOCalls' INDEX 58;
  FUNCTION Vio16GetDeviceCellSize;
  EXTERNAL 'VIOCalls' INDEX 58;

  FUNCTION VioGetOrg;          EXTERNAL 'VIOCalls' INDEX 59;
  FUNCTION Vio16GetOrg;        EXTERNAL 'VIOCalls' INDEX 59;

  FUNCTION VioCreateLogFont;   EXTERNAL 'VIOCalls' INDEX 60;
  FUNCTION VIO16CreateLogFont; EXTERNAL 'VIOCalls' INDEX 60;

  FUNCTION VioDestroyPS;       EXTERNAL 'VIOCalls' INDEX 61;
  FUNCTION Vio16DestroyPS;     EXTERNAL 'VIOCalls' INDEX 61;

  FUNCTION VioQuerySetIds;     EXTERNAL 'VIOCalls' INDEX 62;
  FUNCTION Vio16QuerySetIds;   EXTERNAL 'VIOCalls' INDEX 62;

  FUNCTION VioSetOrg;          EXTERNAL 'VIOCalls' INDEX 63;
  FUNCTION Vio16SetOrg;        EXTERNAL 'VIOCalls' INDEX 63;

  FUNCTION VioQueryFonts;      EXTERNAL 'VIOCalls' INDEX 64;
  FUNCTION Vio16QueryFonts;    EXTERNAL 'VIOCalls' INDEX 64;

  FUNCTION VioSetDeviceCellSize;
  EXTERNAL 'VIOCalls' INDEX 65;
  FUNCTION Vio16SetDeviceCellSize;
  EXTERNAL 'VIOCalls' INDEX 65;

  FUNCTION VioShowPS;         EXTERNAL 'VIOCalls' INDEX 66;
  FUNCTION Vio16ShowPS;       EXTERNAL 'VIOCalls' INDEX 66;

{ **********************************************************

  FUNCTION VIOGetPSAddress(* ------------- *);
    External 'VIOCalls' INDEX  67;
  FUNCTION VIO16GetPSAddress(* ------------- *);
    External 'VIOCalls' INDEX  67;

(* ===================================================== *)

  FUNCTION VIOGlobalReg(* ------------- *);
    External 'VIOCalls' INDEX  70;
  FUNCTION VIO16GlobalReg(* ------------- *);
    External 'VIOCalls' INDEX  70;

  FUNCTION XVIOSetCAState(* ------------- *);
    External 'VIOCalls' INDEX  71;
  FUNCTION XVIO16SetCAState(* ------------- *);
    External 'VIOCalls' INDEX  71;

  FUNCTION XVIOCheckCharType(* ------------- *);
    External 'VIOCalls' INDEX  72;
  FUNCTION XVIO16CheckCharType(* ------------- *);
    External 'VIOCalls' INDEX  72;

  FUNCTION XVIODestroyCA(* ------------- *);
    External 'VIOCalls' INDEX  73;
  FUNCTION XVIO16DestroyCA(* ------------- *);
    External 'VIOCalls' INDEX  73;

  FUNCTION XVIOCreateCA(* ------------- *);
    External 'VIOCalls' INDEX  74;
  FUNCTION XVIO16CreateCA(* ------------- *);
    External 'VIOCalls' INDEX  74;

  FUNCTION VIOCheckCharType(* ------------- *);
    External 'VIOCalls' INDEX  75;
  FUNCTION VIO16CheckCharType(* ------------- *);
    External 'VIOCalls' INDEX  75;

  FUNCTION XVIOGetCAState(* ------------- *);
    External 'VIOCalls' INDEX  76;
  FUNCTION XVIO16GetCAState(* ------------- *);
    External 'VIOCalls' INDEX  76;
}

END.

(* ===================================================== *)
