(* ====================================================== *)
(*                        SESMGR.PAS                      *)
(*    Implementation of the functions of SESMGR.DLL       *)
(*          Translated to Pascal by wr/toolbox mag        *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT SesMgr;

INTERFACE

USES
  Os2Def;
(* Start a new session and run a program in it *)

(* Record used to start a session *)
TYPE
  StartData = RECORD
    cb           : WORD;     (* length of data including itself   *)
    related      : WORD;     (* 0 -> not related, 1 -> is a child *)
    FgBg         : WORD;     (* 0 -> foreground, 1 -> background  *)
    TraceOpt     : WORD;     (* 0 -> no tracing, 1 -> tracing     *)
    PgmTitle     : pChar;    (* address of ASCIIZ program title   *)
    PgmName      : pChar;    (* address of ASCIIZ program name    *)
    PgmInputs    : pChar;    (* address of ASCIIZ progrm inputs   *)
    TermQ        : pChar;    (* name of queue to send terminate   *)
                             (* message to                        *)
    Environment  : pChar;
    InheritOpt   : WORD;
    SessionType  : WORD;
    IconFile     : pChar;
    PgmHandle    : LongInt (* LONGCARD *);
    PgmControl   : WORD;
    InitXPos     : WORD;
    InitYPos     : WORD;
    InitXSize    : WORD;
    InitYSize    : WORD;
  END;

(* The status info for sessions *)

TYPE
  StatusData = RECORD
    cb        : WORD;     (* length of info               *)
    SelectInd : WORD;     (* 0 -> unchanged               *)
                          (* 1 -> selectable              *)
                          (* 2 -> not selectable          *)
    BindInd   : WORD;     (* 0 -> unchanged               *)
                          (* 1 -> bring to foreground     *)
                          (*      when parent selected    *)
                          (* 2 -> break bind              *)
  END;

FUNCTION DosStartSession(
    StartData           : StartData;    (* parameters to start session *)
    VAR SessID          : WORD;     (* returned session ID *)
    VAR ProcessID       : WORD      (* returned process ID *)
    ) : WORD;
FUNCTION Dos16StartSession(
    StartData           : StartData;    (* parameters to start session *)
    VAR SessID          : WORD;     (* returned session ID *)
    VAR ProcessID       : WORD      (* returned process ID *)
    ) : WORD;

(* Stop a child session *)

FUNCTION DosStopSession(
    TargetOpton         : WORD;     (* 0 -> terminate specified session *)
                                        (* 1 -> terminate all sessions *)
    SessID              : WORD;     (* session ID of session to stop *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16StopSession(
    TargetOpton         : WORD;     (* 0 -> terminate specified session *)
                                        (* 1 -> terminate all sessions *)
    SessID              : WORD;     (* session ID of session to stop *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;


(* Switch a child session to the foreground *)

FUNCTION DosSelectSession(
    SessID              : WORD;     (* session ID to make foreground *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;
FUNCTION Dos16SelectSession(
    SessID              : WORD;     (* session ID to make foreground *)
    Reserved            : LongInt       (* must be zero *)
    ) : WORD;

(* Sets the status of a child session *)

FUNCTION DosSetSession(
    SessID              : WORD;     (* the session ID of the child *)
    StatData            : StatusData    (* the new status data *)
    ) : WORD;
FUNCTION Dos16SetSession(
    SessID              : WORD;     (* the session ID of the child *)
    StatData            : StatusData    (* the new status data *)
    ) : WORD;


IMPLEMENTATION

(* ====================================================== *)

  FUNCTION DosStopSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX   8;
  FUNCTION Dos16StopSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX   8;

  FUNCTION DosSelectSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX   9;
  FUNCTION Dos16SelectSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX   9;

(* ====================================================== *)

  FUNCTION DosSetSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX  14;
  FUNCTION Dos16SetSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX  14;

(* ====================================================== *)

  FUNCTION DosStartSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX  17;
  FUNCTION Dos16StartSession(* ------------- *);
    EXTERNAL 'SESMGR'   INDEX  17;

(* ====================================================== *)
{
  FUNCTION DosSMRegisterDD(* ------------- *);
    External 'SESMGR'   INDEX  29;
  FUNCTION Dos16SMRegisterDD(* ------------- *);
    External 'SESMGR'   INDEX  29;
}
(* ====================================================== *)
(*                       32 Bit                           *)
{
  FUNCTION Dos32StartSession(* ------------- *);
    External 'SESMGR'   INDEX  37;

  FUNCTION Dos32SelectSession(* ------------- *);
    External 'SESMGR'   INDEX  38;

  FUNCTION Dos32SetSession(* ------------- *);
    External 'SESMGR'   INDEX  39;

  FUNCTION Dos32StopSession(* ------------- *);
    External 'SESMGR'   INDEX  40;
}
END.

(* ===================================================== *)
