(* ====================================================== *)
(*                        QUECALLS.PAS                    *)
(*    Implementation of the functions of QUECALLS.DLL     *)
(*       Translated to Pascal by jb+wr/toolbox mag        *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT QueCalls;

INTERFACE

USES
  Os2Def;

TYPE
  (* Request data identifies the sending process and *)
  (* type of data retrieved from a queue.            *)
  RequestData = RECORD
    ProcessID : WORD;     (* process ID of sender *)
    Request   : WORD;     (* request type         *)
  END;

(* Purge all elements from a queue *)
FUNCTION DosPurgeQueue(
    QueueHandle         : WORD      (* the queue handle *)
    ) : WORD;
FUNCTION Dos16PurgeQueue(
    QueueHandle         : WORD      (* the queue handle *)
    ) : WORD;
FUNCTION DosOpenQueue(
    VAR OwnerPID        : WORD;     (* returned process id of owner *)
    VAR QueueHandle     : WORD;     (* returned que handle *)
    QueueName           : pChar         (* prefix with \QUEUES\ *)
    ) : WORD;
FUNCTION Dos16OpenQueue(
    VAR OwnerPID        : WORD;     (* returned process id of owner *)
    VAR QueueHandle     : WORD;     (* returned que handle *)
    QueueName           : pChar         (* prefix with \QUEUES\ *)
    ) : WORD;

(* Get and element from a queue without removing it *)

FUNCTION DosPeekQueue(
    QueueHandle         : WORD;     (* handle of the queue to read *)
    VAR Request         : RequestData;  (* returned info about the item *)
    VAR DataLength      : WORD;     (* returned length of data *)
    VAR DataAddress     : Pointer;      (* returned address of data *)
    VAR ElementCode     : WORD;     (* 0 to start, non zero gets next *)
    NoWait              : BOOLEAN;      (* whether to wait if empty *)
    VAR ElemPriority    : BYTE;         (* returned priority of item *)
    SemHandle           : SemaPhore     (* semaphore to use if notwait spec *)
    ) : WORD;
FUNCTION Dos16PeekQueue(
    QueueHandle         : WORD;     (* handle of the queue to read *)
    VAR Request         : RequestData;  (* returned info about the item *)
    VAR DataLength      : WORD;     (* returned length of data *)
    VAR DataAddress     : Pointer;      (* returned address of data *)
    VAR ElementCode     : WORD;     (* 0 to start, non zero gets next *)
    NoWait              : BOOLEAN;      (* whether to wait if empty *)
    VAR ElemPriority    : BYTE;         (* returned priority of item *)
    SemHandle           : SemaPhore     (* semaphore to use if notwait spec *)
    ) : WORD;

(* Get the number of elements in a queue *)

FUNCTION DosQueryQueue(
    QueueHandle         : WORD;     (* the handle of the queue *)
    VAR NumberElements  : WORD      (* returned number of elements *)
    ) : WORD;
FUNCTION Dos16QueryQueue (
    QueueHandle         : WORD;     (* the handle of the queue *)
    VAR NumberElements  : WORD      (* returned number of elements *)
    ) : WORD;

(* Read an element from a queue *)

FUNCTION DosReadQueue(
    QueueHandle         : WORD;     (* handle of the queue to read *)
    VAR Request         : RequestData;  (* returned info about the item *)
    VAR DataLength      : WORD;     (* returned length of data *)
    VAR DataAddress     : Pointer;      (* returned address of data *)
    ElementCode         : WORD;     (* 0 to start, non zero gets next *)
    NoWait              : BOOLEAN;      (* whether to wait if empty *)
    VAR ElemPriority    : WORD;     (* returned priority of item *)
    SemHandle           : SemaPhore     (* semaphore to use if notwait spec *)
    ) : WORD;
FUNCTION Dos16ReadQueue(
    QueueHandle         : WORD;     (* handle of the queue to read *)
    VAR Request         : RequestData;  (* returned info about the item *)
    VAR DataLength      : WORD;     (* returned length of data *)
    VAR DataAddress     : Pointer;      (* returned address of data *)
    ElementCode         : WORD;     (* 0 to start, non zero gets next *)
    NoWait              : BOOLEAN;      (* whether to wait if empty *)
    VAR ElemPriority    : WORD;     (* returned priority of item *)
    SemHandle           : SemaPhore     (* semaphore to use if notwait spec *)
    ) : WORD;

(* Write an element to a queue *)

FUNCTION DosWriteQueue(
    QueueHandle         : WORD;     (* handle of queue to write to *)
    Request             : WORD;     (* parameter sent with entry *)
    DataLength          : WORD;     (* length of data to write *)
    DataBuffer          : Pointer;      (* address of data buffer *)
    ElemPriority        : WORD      (* priority of element *)
    ) : WORD;
FUNCTION Dos16WriteQueue(
    QueueHandle         : WORD;     (* handle of queue to write to *)
    Request             : WORD;     (* parameter sent with entry *)
    DataLength          : WORD;     (* length of data to write *)
    DataBuffer          : Pointer;      (* address of data buffer *)
    ElemPriority        : WORD      (* priority of element *)
    ) : WORD;

(* close a queue *)

FUNCTION DosCloseQueue(hqueue: WORD   (* handle returned by create or open queue *)
                           ) : WORD;
FUNCTION Dos16CloseQueue(hqueue: WORD   (* handle returned by create or open queue *)
                             ) : WORD;

(* create a queue *)

CONST
  QUE_FIFO            = 0;
  QUE_LIFO            = 1;
  QUE_PRIORITY        = 2;

FUNCTION DosCreateQueue(
    VAR QueueHandle     : WORD;   (* returned handle for the queue *)
    QueuePrty           : WORD; (* how the queue is ordered *)
    QueueName           : pChar      (* name of queue, prefix with \QUEUES\ *)
    ) : WORD;

FUNCTION Dos16CreateQueue(
    VAR QueueHandle     : WORD;   (* returned handle for the queue *)
    QueuePrty           : WORD; (* how the queue is ordered *)
    QueueName           : pChar      (* name of queue, prefix with \QUEUES\ *)
    ) : WORD;


IMPLEMENTATION

  FUNCTION DosReadQueue;    EXTERNAL 'QueCalls' INDEX   1;
  FUNCTION Dos16ReadQueue;  EXTERNAL 'QueCalls' INDEX   1;

  FUNCTION DosPurgeQueue;    EXTERNAL 'QueCalls' INDEX   2;
  FUNCTION Dos16PurgeQueue;  EXTERNAL 'QueCalls' INDEX   2;

  FUNCTION DosCloseQueue;    EXTERNAL 'QueCalls' INDEX   3;
  FUNCTION Dos16CloseQueue;  EXTERNAL 'QueCalls' INDEX   3;

  FUNCTION DosQueryQueue;    EXTERNAL 'QueCalls' INDEX   4;
  FUNCTION Dos16QueryQueue;  EXTERNAL 'QueCalls' INDEX   4;

  FUNCTION DosPeekQueue;     EXTERNAL 'QueCalls' INDEX   5;
  FUNCTION Dos16PeekQueue;   EXTERNAL 'QueCalls' INDEX   5;

  FUNCTION DosWriteQueue;    EXTERNAL 'QueCalls' INDEX   6;
  FUNCTION Dos16WriteQueue;  EXTERNAL 'QueCalls' INDEX   6;

  FUNCTION DosOpenQueue;     EXTERNAL 'QueCalls' INDEX   7;
  FUNCTION Dos16OpenQueue;   EXTERNAL 'QueCalls' INDEX   7;

  FUNCTION DosCreateQueue;   EXTERNAL 'QueCalls' INDEX   8;
  FUNCTION Dos16CreateQueue; EXTERNAL 'QueCalls' INDEX   8;

(* ====================================================== *)
(*                         32 Bit                         *)
{
  FUNCTION Dos32ReadQueue;   External 'QueCalls' INDEX   9;
  FUNCTION Dos32PurgeQueue;  External 'QueCalls' INDEX  10;
  FUNCTION Dos32CloseQueue;  External 'QueCalls' INDEX  11;
  FUNCTION Dos32QueryQueue;  External 'QueCalls' INDEX  12;
  FUNCTION Dos32PeekQueue;   External 'QueCalls' INDEX  13;
  FUNCTION Dos32WriteQueue;  External 'QueCalls' INDEX  14;
  FUNCTION Dos32OpenQueue;   External 'QueCalls' INDEX  15;
  FUNCTION Dos32CreateQueue; External 'QueCalls' INDEX  16;
}

END.

(* ====================================================== *)
