(* ====================================================== *)
(*                         PMPIC.PAS                      *)
(*     Implementation of the functions of PMPIC.DLL       *)
(*            Translation to Pascal by jb/toolbox mag     *)
(* ====================================================== *)

{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT PMPic;

INTERFACE

USES
  Os2Def;

CONST
  PIP_MF        = 1;
  PIP_PIF       = 2;

  PIC_PIFTOMET  = 0;
  PIC_SSTOFONT  = 2;

  FUNCTION PicPrint(  a : HAB;
                      b : pChar;
                      c : LongInt;
                      d : pChar) : BOOL;
  FUNCTION Pic16Print(a : HAB;
                      b : pChar;
                      c : LongInt;
                      d : pChar) : BOOL;

  FUNCTION PicIchg(  a : HAB;
                     b : pChar;
                     c : pChar;
                     d : LongInt) : BOOL;
  FUNCTION Pic16Ichg(a : HAB;
                     b : pChar;
                     c : pChar;
                     d : LongInt) : BOOL;


IMPLEMENTATION

  FUNCTION PicPrint;     EXTERNAL 'PMPIC' INDEX  1;
  FUNCTION Pic16Print;   EXTERNAL 'PMPIC' INDEX  1;

  FUNCTION PicIchg;      EXTERNAL 'PMPIC' INDEX  2;
  FUNCTION Pic16Ichg;    EXTERNAL 'PMPIC' INDEX  2;


(* ====================================================== *)
(*                         32 Bit                         *)
{                 nicht implementiert

  FUNCTION Pic32Print;   External 'PMPIC' INDEX 11;
  FUNCTION Pic32Ichg;    External 'PMPIC' INDEX 12;
  FUNCTION Prf32Pif2Met; External 'PMPIC' INDEX 13;
}

END.

(* ====================================================== *)
(*                     Ende von PMPIC.PAS                 *)
