(* ====================================================== *)
(*                      PMGPI.PAS                         *)
(*      Implementation of the functions of PMGPI.DLL      *)
(* Functions not (yet) implemented are commented in the   *)
(*           implementation part of the unit.             *)
(*         Translation to Pascal by jb/toolbox mag        *)
(* ====================================================== *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT PMGpi;

INTERFACE

USES Os2Def;

(* General GPI return values *)
CONST
  GPI_ERROR    = 0;
  GPI_OK       = 1;
  GPI_ALTERROR = -1;

(* fixed point number - implicit binary point between 2 and 3 hex digits *)
TYPE
  Fixed   = LongInt;  (* fx *)
  pFixed  = ^Fixed;

(* fixed point number - implicit binary point between 1st and 2nd hex digits *)
  Fixed88 = WORD;  (* fx88 *)

(* fixed point signed number - implicit binary point between bits 14 and 13. *)
(*                             Bit 15 is the sign bit.                       *)
(*                             Thus 1.0 is represented by 16384 (0x4000)     *)
(*                             and -1.0 is represented by -16384 (0xc000)    *)
  Fixed114 = WORD; (* fx114 *)

(* make FIXED number from SHORT integer part and USHORT fractional part *)

  FUNCTION MakeFixed(IntPart: INTEGER; FractPart: WORD) : Fixed;

(* extract fractional part from a fixed quantity *)

  FUNCTION FixedFrac(fx: Fixed): WORD;

(* extract integer part from a fixed quantity *)

  FUNCTION FixedInt(fx: Fixed): INTEGER;

(* structure for size parameters e.g. for GpiCreatePS *)
TYPE
  SizeL = RECORD          (* sizl *)
    cx : LongInt;
    cy : LongInt;
  END;
  pSizeL = ^SizeL;

(* return code on GpiQueryLogColorTable,GpiQueryRealColors and GpiQueryPel *)
CONST
  CLR_NOINDEX              =  -254;

(* units for GpiCreatePS and others *)
  PU_ARBITRARY             = $00004;
  PU_PELS                  = $00008;
  PU_LOMETRIC              = $0000C;
  PU_HIMETRIC              = $00010;
  PU_LOENGLISH             = $00014;
  PU_HIENGLISH             = $00018;
  PU_TWIPS                 = $0001C;

(* format for GpiCreatePS *)
  GPIF_DEFAULT             = 0;
  GPIF_SHORT               = $00100;
  GPIF_LONG                = $00200;

(* PS type for GpiCreatePS *)
  GPIT_NORMAL              = 0;
  GPIT_MICRO               = $01000;

(* implicit associate flag for GpiCreatePS *)
  GPIA_NOASSOC             = 0;
  GPIA_ASSOC               = $04000;

(* return error for GpiQueryDevice *)
  HDC_ERROR                = -1;

(*** common GPICONTROL functions *)

  FUNCTION GpiCreatePS(    ahab       : HAB;
                           ahdc       : hDC;
                       VAR pSizeLSize : { LONG } SizeL;
                           u1         : LongInt) : hPs;
  FUNCTION Gpi16CreatePS(    ahab       : HAB;
                             ahdc       : hDC;
                         VAR pSizeLSize : { LONG } SizeL;
                             u1         : LongInt) : hPs;

  FUNCTION GpiDestroyPS(  ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16DestroyPS(ahps : hPs) : BOOLEAN;

  FUNCTION GpiAssociate  (ahps : hPs; ahdc : hDC) : BOOLEAN;
  FUNCTION Gpi16Associate(ahps : hPs; ahdc : hDC) : BOOLEAN;

  FUNCTION GpiRestorePS  (ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16RestorePS(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiSavePS  (ahps : hPs) : LongInt;
  FUNCTION Gpi16SavePS(ahps : hPs) : LongInt;

  FUNCTION GpiErase  (ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16Erase(ahps : hPs) : BOOLEAN;

  FUNCTION GpiQueryDevice  (ahps : hPs) : hDC;
  FUNCTION Gpi16QueryDevice(ahps : hPs) : hDC;

(* options for GpiResetPS *)
CONST
  GRES_ATTRS               = $00001;
  GRES_SEGMENTS            = $00002;
  GRES_ALL                 = $00004;

(* option masks for PS options used by GpiQueryPs *)
  PS_UNITS                 = $000FC;
  PS_FORMAT                = $00F00;
  PS_TYPE                  = $01000;
  PS_MODE                  = $02000;
  PS_ASSOCIATE             = $04000;
  PS_NORESET               = $08000;

(* error context returned by GpiErrorSegmentData *)
  GPIE_SEGMENT             = 0;
  GPIE_ELEMENT             = 1;
  GPIE_DATA                = 2;

(* control parameter for GpiSetDrawControl *)
  DCTL_ERASE               = 1;
  DCTL_DISPLAY             = 2;
  DCTL_BOUNDARY            = 3;
  DCTL_DYNAMIC             = 4;
  DCTL_CORRELATE           = 5;

(* constants for GpiSet/QueryDrawControl *)
  DCTL_ERROR = -1;
  DCTL_OFF =    0;
  DCTL_ON =     1;

(* constants for GpiSet/QueryStopDraw *)
  SDW_ERROR = -1;
  SDW_OFF =    0;
  SDW_ON =     1;

(* drawing for GpiSet/QueryDrawingMode *)
  DM_ERROR =         0;
  DM_DRAW =          1;
  DM_RETAIN =        2;
  DM_DRAWANDRETAIN = 3;

(*** other GPICONTROL functions *)

  FUNCTION GpiResetPS(ahps : hPs; u : LongInt) : BOOLEAN;
  FUNCTION Gpi16ResetPS(ahps : hPs; u : LongInt) : BOOLEAN;

  FUNCTION GpiSetPS(      ahps : hPs;
                      VAR P    : { LONG } SizeL;
                          u    : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetPS(    ahps : hPs;
                      VAR P    : { LONG } SizeL;
                          u    : LongInt) : BOOLEAN;

  FUNCTION GpiQueryPS(      ahps : hPs;
                        VAR P    : { LONG } SizeL) : LongInt;
  FUNCTION Gpi16QueryPS(    ahps : hPs;
                      VAR P    : { LONG } SizeL) : LongInt;

  FUNCTION GpiErrorSegmentData(    ahps : hPs;
                               VAR l    : { LONG } LongInt;
                               VAR l2   : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16ErrorSegmentData(    ahps : hPs;
                                 VAR l    : { LONG } LongInt;
                                 VAR l2   : { LONG } LongInt) : LongInt;

  FUNCTION GpiQueryDrawControl(  ahps : hPs; l : LongInt) : LongInt;
  FUNCTION Gpi16QueryDrawControl(ahps : hPs; l : LongInt) : LongInt;

  FUNCTION GpiSetDrawControl(  ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetDrawControl(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiQueryDrawingMode(  ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryDrawingMode(ahps : hPs) : LongInt;

  FUNCTION GpiSetDrawingMode(  ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetDrawingMode(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryStopDraw(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryStopDraw(ahps : hPs) : LongInt;

  FUNCTION GpiSetStopDraw(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetStopDraw(ahps : hPs; l : LongInt) : BOOLEAN;

(* options for GpiSetPickApertureSize *)
CONST
  PICKAP_DEFAULT =          0;
  PICKAP_REC =              2;

(* type of correlation for GpiCorrelateChain *)
  PICKSEL_VISIBLE =         0;
  PICKSEL_ALL =             1;

(* return code to indicate correlate hit(s) *)
  GPI_HITS =    2;

(*** picking,  correlation and boundary functions *)

  FUNCTION GpiCorrelateChain(    ahps   : hPs;
                                 l1     : LongInt;
                                 PointL : { LONG } PointL;
                                 l2     : LongInt;
                                 l6     : LongInt;
                             VAR l7     : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16CorrelateChain(  ahps   : hPs;
                                 l1     : LongInt;
                                 PointL : { LONG } PointL;
                                 l2     : LongInt;
                                 l6     : LongInt;
                             VAR l7     : { LONG } LongInt) : LongInt;

  FUNCTION GpiQueryTag(  ahps : hPs; VAR l2 : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16QueryTag(ahps : hPs; VAR l2 : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiSetTag(  ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetTag(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryPickApertureSize(    ahps : hPs;
                                    VAR P    : { LONG } SizeL) : BOOLEAN;
  FUNCTION Gpi16QueryPickApertureSize(    ahps : hPs;
                                      VAR P    : { LONG } SizeL) : BOOLEAN;

  FUNCTION GpiSetPickApertureSize(hPs   : hPs;
                                  l1    : LongInt;
                                  SizeL : { LONG } SizeL) : BOOLEAN;
  FUNCTION Gpi16SetPickApertureSize(hPs   : hPs;
                                    l1    : LongInt;
                                    SizeL : { LONG } SizeL) : BOOLEAN;

  FUNCTION GpiQueryPickAperturePosition(    ahps    : hPs;
                                        VAR aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16QueryPickAperturePosition(    ahps    : hPs;
                                          VAR aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiSetPickAperturePosition(ahps    : hPs;
                                      aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16SetPickAperturePosition(ahps    : hPs;
                                        aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryBoundaryData(    ahps   : hPs;
                                VAR aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16QueryBoundaryData(    ahps   : hPs;
                                  VAR aRectl : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiResetBoundaryData(  ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16ResetBoundaryData(ahps : hPs) : BOOLEAN;

  FUNCTION GpiCorrelateFrom(    ahps, l2 : LongInt;
                                l3, l4   : LongInt;
                                aPointL  : { LONG } PointL;
                                l5, l6   : LongInt;
                            VAR l7       : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16CorrelateFrom(    ahps, l2 : LongInt;
                                  l3, l4   : LongInt;
                                  aPointL  : { LONG } PointL;
                                  l5, l6   : LongInt;
                              VAR l7       : { LONG } LongInt) : LongInt;

  FUNCTION GpiCorrelateSegment(   ahps    : hPs;
                                  l1, l3  : LongInt;
                                  aPointL : { LONG } PointL;
                                  l2, l6  : LongInt;
                              VAR l7      : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16CorrelateSegment( ahps    : hPs;
                                  l1, l3  : LongInt;
                                  aPointL : { LONG } PointL;
                                  l2, l6  : LongInt;
                              VAR l7      : { LONG } LongInt) : LongInt;

(* data formats for GpiPutData and GpiGetData *)
CONST
  DFORM_NOCONV =    0;
  DFORM_S370SHORT = 1;
  DFORM_PCSHORT =   2;
  DFORM_PCLONG =    4;

(* segment attributes used by GpiSet/QuerySegmentAttrs and others *)
  ATTR_DETECTABLE =      1;
  ATTR_VISIBLE =         2;
  ATTR_CHAINED =         6;
  ATTR_DYNAMIC =         8;
  ATTR_FASTCHAIN =       9;
  ATTR_PROP_DETECTABLE = 10;
  ATTR_PROP_VISIBLE =    11;

(* attribute on/off values *)
  ATTR_OFF =  0;
  ATTR_ON =   1;

(* segment priority used by GpiSetSegmentPriority and others *)
  LOWER_PRI =      -1;
  HIGHER_PRI =      1;

(*** segment control functions *)

  FUNCTION GpiOpenSegment(  ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16OpenSegment(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiCloseSegment(ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16CloseSegment(ahps : hPs) : BOOLEAN;

  FUNCTION GpiDeleteSegment(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16DeleteSegment(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryInitialSegmentAttrs(ahps : hPs; l : LongInt) : LongInt;
  FUNCTION Gpi16QueryInitialSegmentAttrs(ahps : hPs; l : LongInt) : LongInt;

  FUNCTION GpiSetInitialSegmentAttrs(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetInitialSegmentAttrs(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiQuerySegmentAttrs(ahps : hPs; l1, l2 : LongInt) : LongInt;
  FUNCTION Gpi16QuerySegmentAttrs(ahps : hPs; l1, l2 : LongInt) : LongInt;

  FUNCTION GpiSetSegmentAttrs(ahps       : hPs;
                              l1, l6, l8 : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetSegmentAttrs(ahps       : hPs;
                                l1, l6, l8 : LongInt) : BOOLEAN;

  FUNCTION GpiQuerySegmentPriority(ahps   : hPs;
                                   l1, l2 : LongInt) : LongInt;
  FUNCTION Gpi16QuerySegmentPriority(ahps   : hPs;
                                   l1, l2 : LongInt) : LongInt;

  FUNCTION GpiSetSegmentPriority(ahps       : hPs;
                                 l1, l6, l8 : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetSegmentPriority(ahps       : hPs;
                                   l1, l6, l8 : LongInt) : BOOLEAN;

  FUNCTION GpiDeleteSegments(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16DeleteSegments(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiQuerySegmentNames(    ahps       : hPs;
                                    l1, l6, l2 : LongInt;
                                VAR l7         : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16QuerySegmentNames(    ahps       : hPs;
                                    l1, l6, l2 : LongInt;
                                VAR l7         : { LONG } LongInt) : LongInt;

(*** draw functions for segments *)

  FUNCTION GpiGetData(    ahps   : hPs;
                          l1     : LongInt;
                      VAR l9     : { LONG } LongInt;
                          l2, l6 : LongInt;
                          aByte  : Pointer) : LongInt;
  FUNCTION Gpi16GetData(  ahps   : hPs;
                          l1     : LongInt;
                      VAR l9     : { LONG } LongInt;
                          l2, l6 : LongInt;
                          aByte  : Pointer) : LongInt;

  FUNCTION GpiPutData(    ahps  : hPs;
                          l1    : LongInt;
                      VAR l9    : { LONG } LongInt;
                          aByte : Pointer) : LongInt;
  FUNCTION Gpi16PutData(    ahps  : hPs;
                            l1    : LongInt;
                        VAR l9    : { LONG } LongInt;
                            aByte : Pointer) : LongInt;

  FUNCTION GpiDrawChain(ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16DrawChain(ahps : hPs) : BOOLEAN;

  FUNCTION GpiDrawFrom(  ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16DrawFrom(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiDrawSegment(  ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16DrawSegment(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiDrawDynamics(  ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16DrawDynamics(ahps : hPs) : BOOLEAN;

  FUNCTION GpiRemoveDynamics(  ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16RemoveDynamics(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

(* edit modes used by GpiSet/QueryEditMode *)
CONST
  SEGEM_ERROR =     0;
  SEGEM_INSERT =    1;
  SEGEM_REPLACE =   2;

(*** segment editing by element functions *)

  FUNCTION GpiBeginElement(ahps : hPs; l1 : LongInt; aPsz : pChar) : BOOLEAN;
  FUNCTION Gpi16BeginElement(ahps : hPs; l1 : LongInt; aPsz : pChar) : BOOLEAN;

  FUNCTION GpiEndElement(ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16EndElement(ahps : hPs) : BOOLEAN;

  FUNCTION GpiLabel(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16Label(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiElement(ahps  : hPs;
                      l1    : LongInt;
                      pSZ   : pChar;
                      l2    : LongInt;
                      aByte : Pointer) : LongInt;
  FUNCTION Gpi16Element(ahps  : hPs;
                        l1    : LongInt;
                        pSZ   : pChar;
                        l2    : LongInt;
                        aByte : Pointer) : LongInt;

  FUNCTION GpiQueryElement(ahps   : hPs;
                           l1, l6 : LongInt;
                           aByte  : Pointer) : LongInt;
  FUNCTION Gpi16QueryElement(ahps   : hPs;
                             l1, l6 : LongInt;
                             aByte  : Pointer) : LongInt;

  FUNCTION GpiDeleteElement(ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16DeleteElement(ahps : hPs) : BOOLEAN;

  FUNCTION GpiDeleteElementRange(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16DeleteElementRange(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiDeleteElementsBetweenLabels(ahps   : hPs;
                                          l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16DeleteElementsBetweenLabels(ahps   : hPs;
                                          l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiQueryEditMode(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryEditMode(ahps : hPs) : LongInt;

  FUNCTION GpiSetEditMode(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetEditMode(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryElementPointer(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryElementPointer(ahps : hPs) : LongInt;

  FUNCTION GpiSetElementPointer(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetElementPointer(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiOffsetElementPointer(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16OffsetElementPointer(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryElementType(    ahps : hPs;
                               VAR l    : { LONG } LongInt;
                                   l1   : LongInt;
                                   pSZ  : pChar) : LongInt;
  FUNCTION Gpi16QueryElementType(    ahps : hPs;
                               VAR l    : { LONG } LongInt;
                                   l1   : LongInt;
                                   pSZ  : pChar) : LongInt;

  FUNCTION GpiSetElementPointerAtLabel(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetElementPointerAtLabel(ahps : hPs; l : LongInt) : BOOLEAN;

(* co-ordinates space for GpiConvert *)
CONST
  CVTC_WORLD =              1;
  CVTC_MODEL =              2;
  CVTC_DEFAULTPAGE =        3;
  CVTC_PAGE =               4;
  CVTC_DEVICE =             5;

(* type of transformation for GpiSetSegmentTransformMatrix *)
  TRANSFORM_REPLACE =       0;
  TRANSFORM_ADD =           1;
  TRANSFORM_PREEMPT =       2;

(* transform matrix *)
TYPE
  MATRIXLF = RECORD      (* matlf *)
    fxM11 : Fixed;
    fxM12 : Fixed;
    lM13  : LongInt;
    fxM21 : Fixed;
    fxM22 : Fixed;
    lM23  : LongInt;
    lM31  : LongInt;
    lM32  : LongInt;
    lM33  : LongInt;
  END;
  pMatrixLf = ^MATRIXLF;

(*** transform and transform conversion functions *)

  FUNCTION GpiQuerySegmentTransformMatrix(    ahps     : hPs;
                                              l1, l6   : LongInt;
                                          VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
  FUNCTION Gpi16QuerySegmentTransformMatrix(    ahps     : hPs;
                                                l1, l6   : LongInt;
                                            VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;

  FUNCTION GpiSetSegmentTransformMatrix(    ahps     : hPs;
                                            l1, l6   : LongInt;
                                            MATRIXLF : { LONG } MATRIXLF;
                                        VAR l11      : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16SetSegmentTransformMatrix(    ahps     : hPs;
                                              l1, l6   : LongInt;
                                              MATRIXLF : { LONG } MATRIXLF;
                                          VAR l11      : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiConvert(    ahps       : hPs;
                          l1, l6, l2 : LongInt;
                      VAR aPointL    : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16Convert(    ahps       : hPs;
                            l1, l6, l2 : LongInt;
                        VAR aPointL    : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryModelTransformMatrix(    ahps     : hPs;
                                            l1       : LongInt;
                                        VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
  FUNCTION Gpi16QueryModelTransformMatrix(    ahps     : hPs;
                                            l1       : LongInt;
                                        VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;

  FUNCTION GpiSetModelTransformMatrix(    ahps     : hPs;
                                          l1       : LongInt;
                                          MATRIXLF : { LONG } MATRIXLF;
                                      VAR l11      : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16SetModelTransformMatrix(  ahps     : hPs;
                                          l1       : LongInt;
                                          MATRIXLF : { LONG } MATRIXLF;
                                      VAR l11      : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiCallSegmentMatrix(    ahps     : hPs;
                                    l1, l6   : LongInt;
                                    MATRIXLF : { LONG } MATRIXLF;
                                VAR l11      : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16CallSegmentMatrix(    ahps     : hPs;
                                      l1, l6   : LongInt;
                                      MATRIXLF : { LONG } MATRIXLF;
                                VAR l11      : { LONG } LongInt) : LongInt;

  FUNCTION GpiQueryDefaultViewMatrix(    ahps     : hPs;
                                         l1       : LongInt;
                                     VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
  FUNCTION Gpi16QueryDefaultViewMatrix(  ahps     : hPs;
                                         l1       : LongInt;
                                     VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;

  FUNCTION GpiSetDefaultViewMatrix(    ahps     : hPs;
                                       l1       : LongInt;
                                       MATRIXLF : { LONG } MATRIXLF;
                                   VAR l11      : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16SetDefaultViewMatrix(  ahps     : hPs;
                                       l1       : LongInt;
                                       MATRIXLF : { LONG } MATRIXLF;
                                   VAR l11      : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiQueryPageViewport(    hPs    : hPs;
                                VAR aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16QueryPageViewport(    hPs    : hPs;
                                  VAR aRectl : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiSetPageViewport(  ahps : hPs; aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16SetPageViewport(ahps : hPs; aRectl : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiQueryViewingTransformMatrix(    ahps     : hPs;
                                              l1       : LongInt;
                                          VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
  FUNCTION Gpi16QueryViewingTransformMatrix(    ahps     : hPs;
                                                l1       : LongInt;
                                            VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
  FUNCTION xGpiQueryViewingTransformMatrix(    ahps     : hPs;
                                              l1       : LongInt;
                                          VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
  FUNCTION xGpi16QueryViewingTransformMatrix(    ahps     : hPs;
                                                l1       : LongInt;
                                            VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;

  FUNCTION GpiSetViewingTransformMatrix(    ahps     : hPs;
                                            l1       : LongInt;
                                            MATRIXLF : { LONG } MATRIXLF;
                                        VAR l11      : { LONG } LongInt): BOOLEAN;
  FUNCTION Gpi16SetViewingTransformMatrix(    ahps     : hPs;
                                              l1       : LongInt;
                                              MATRIXLF : { LONG } MATRIXLF;
                                          VAR l11      : { LONG } LongInt): BOOLEAN;

  FUNCTION GpiTranslate(a : hPs;
                        b : MATRIXLF;
                        c : LongInt;
                        d : PointL) : BOOLEAN;
  FUNCTION Gpi16Translate(a : hPs;
                          b : MATRIXLF;
                          c : LongInt;
                          d : PointL) : BOOLEAN;

  FUNCTION GpiScale(a : hPs;
                    b : MATRIXLF;
                    c : LongInt;
                    d : Fixed;
                    e : PointL) : BOOLEAN;
  FUNCTION Gpi16Scale(a : hPs;
                      b : MATRIXLF;
                      c : LongInt;
                      d : Fixed;
                      e : PointL) : BOOLEAN;

  FUNCTION GpiRotate(a : hPs;
                     b : MATRIXLF;
                     c : LongInt;
                     d : Fixed;
                     e : PointL) : BOOLEAN;
  FUNCTION Gpi16Rotate(a : hPs;
                       b : MATRIXLF;
                       c : LongInt;
                       d : Fixed;
                       e : PointL) : BOOLEAN;

(*** general clipping functions *)

  FUNCTION GpiSetGraphicsField(ahps   : hPs;
                               aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16SetGraphicsField(ahps   : hPs;
                                 aRectl : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiQueryGraphicsField(    ahps   : hPs;
                                 VAR aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16QueryGraphicsField(    ahps   : hPs;
                                 VAR aRectl : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiSetViewingLimits(ahps   : hPs;
                               aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16SetViewingLimits(ahps   : hPs;
                               aRectl : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiQueryViewingLimits(    ahps   : hPs;
                                 VAR aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16QueryViewingLimits(    ahps   : hPs;
                                 VAR aRectl : { LONG } RectL) : BOOLEAN;

(* modes for GpiModifyPath *)
CONST
  MPATH_STROKE =            6;

(* modes for GpiFillPath *)
  FPATH_ALTERNATE =         0;
  FPATH_WINDING =           2;

(* modes for GpiSetClipPath *)
  SCP_ALTERNATE =           0;
  SCP_WINDING =             2;
  SCP_AND =                 4;
  SCP_RESET =               0;


(*** Path and Clip Path functions *)

  FUNCTION GpiBeginPath(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16BeginPath(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiEndPath(ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16EndPath(ahps : hPs) : BOOLEAN;

  FUNCTION GpiCloseFigure(ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16CloseFigure(ahps : hPs) : BOOLEAN;

  FUNCTION GpiModifyPath(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16ModifyPath(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiFillPath(ahps : hPs; l1, l2 : LongInt) : LongInt;
  FUNCTION Gpi16FillPath(ahps : hPs; l1, l2 : LongInt) : LongInt;

  FUNCTION GpiSetClipPath(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetClipPath(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;

  FUNCTION GpiOutlinePath(ahps : hPs; l1, l2 : LongInt) : LongInt;
  FUNCTION Gpi16OutlinePath(ahps : hPs; l1, l2 : LongInt) : LongInt;

  FUNCTION GpiStrokePath(ahps : hPs; l1 : LongInt; c : LongInt) : LongInt;
  FUNCTION Gpi16StrokePath(ahps : hPs; l1 : LongInt; c : LongInt) : LongInt;

(* options for GpiCreateLogColorTable and others *)
CONST
  LCOL_RESET =              $00001;
  LCOL_REALIZABLE =         $00002;
  LCOL_PURECOLOR =          $00004;

(* format of logical lColor table for GpiCreateLogColorTable and others *)
  LCOLF_DEFAULT =           0;
  LCOLF_INDRGB =            1;
  LCOLF_CONSECRGB =         2;
  LCOLF_RGB =               3;

(* options for GpiQueryRealColors and others *)
  LCOLOPT_REALIZED =        $0001;
  LCOLOPT_INDEX =           $0002;

(* return codes from GpiQueryLogColorTable to indicate it is in RGB mode *)
  QLCT_ERROR   = (-1);
  QLCT_RGB     = (-2);

(* GpiQueryLogColorTable index returned for colors not explicitly loaded *)
  QLCT_NOTLOADED = -1;

(* return codes for GpiQueryColorData *)
  QCD_LCT_FORMAT =    0;
  QCD_LCT_LOINDEX =   1;
  QCD_LCT_HIINDEX =   2;

(*** logical lColor table functions *)

  FUNCTION GpiCreateLogColorTable(    ahps       : hPs;
                                      c1         : LongInt;
                                      l1, l2, l3 : LongInt;
                                  VAR l7         : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16CreateLogColorTable(    ahps       : hPs;
                                        c1         : LongInt;
                                        l1, l2, l3 : LongInt;
                                    VAR l7         : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiRealizeColorTable(  ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16RealizeColorTable(ahps : hPs) : BOOLEAN;

  FUNCTION GpiUnrealizeColorTable(ahps : hPs) : BOOLEAN;
  FUNCTION Gpi16UnrealizeColorTable(ahps : hPs) : BOOLEAN;

  FUNCTION GpiQueryColorData(    ahps : hPs;
                                 l1   : LongInt;
                             VAR l7   : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16QueryColorData(    ahps : hPs;
                                   l1   : LongInt;
                               VAR l7   : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiQueryLogColorTable(    ahps   : hPs;
                                     c1     : LongInt;
                                     l1, l2 : LongInt;
                                 VAR l7     : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16QueryLogColorTable(  ahps   : hPs;
                                     c1     : LongInt;
                                     l1, l2 : LongInt;
                                 VAR l7     : { LONG } LongInt) : LongInt;

  FUNCTION GpiQueryRealColors(    ahps   : hPs;
                                  c1     : LongInt;
                                  l2, l6 : LongInt;
                              VAR l7     : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16QueryRealColors(  ahps   : hPs;
                                  c1     : LongInt;
                                  l2, l6 : LongInt;
                              VAR l7     : { LONG } LongInt) : LongInt;

  FUNCTION GpiQueryNearestColor(ahps : hPs;
                                c1   : LongInt;
                                i1   : LongInt) : LongInt;
  FUNCTION Gpi16QueryNearestColor(ahps : hPs;
                                  c1   : LongInt;
                                  i1   : LongInt) : LongInt;

  FUNCTION GpiQueryColorIndex(ahps : hPs;
                              c1   : LongInt;
                              l1   : LongInt) : LongInt;
  FUNCTION Gpi16QueryColorIndex(ahps : hPs;
                                c1   : LongInt;
                                l1   : LongInt) : LongInt;

  FUNCTION GpiQueryRGBColor(ahps : hPs;
                            c1   : LongInt;
                            l2   : LongInt) : LongInt;
  FUNCTION Gpi16QueryRGBColor(ahps : hPs;
                              c1   : LongInt;
                              l2   : LongInt) : LongInt;

(* default color table indices *)

CONST
  CLR_FALSE               =(-5);
  CLR_TRUE                =(-4);
  CLR_ERROR =            (-255);
  CLR_DEFAULT             =(-3);
  CLR_WHITE               =(-2);
  CLR_BLACK               =(-1);
  CLR_BACKGROUND =          0;
  CLR_BLUE =                1;
  CLR_RED =                 2;
  CLR_PINK =                3;
  CLR_GREEN =               4;
  CLR_CYAN =                5;
  CLR_YELLOW =              6;
  CLR_NEUTRAL =             7;
  CLR_DARKGRAY =            8;
  CLR_DARKBLUE =            9;
  CLR_DARKRED =            10;
  CLR_DARKPINK =           11;
  CLR_DARKGREEN =          12;
  CLR_DARKCYAN =           13;
  CLR_BROWN =              14;
  CLR_PALEGRAY =           15;

(* rgb colors *)
  RGB_ERROR               = (-255);
  RGB_BLACK =               $000000000;
  RGB_BLUE =                $0000000FF;
  RGB_GREEN =               $00000FF00;
  RGB_CYAN =                $00000FFFF;
  RGB_RED =                 $000FF0000;
  RGB_PINK =                $000FF00FF;
  RGB_YELLOW =              $000FFFF00;
  RGB_WHITE =               $000FFFFFF;

(* control flags used by GpiBeginArea *)
  BA_NOBOUNDARY =   0;
  BA_BOUNDARY =     $00001;

  BA_ALTERNATE =    0;
  BA_WINDING =      $00002;

(* fill options for GpiBox/GpiFullArc *)
CONST DRO_FILL =        1;
CONST DRO_OUTLINE =     2;
CONST DRO_OUTLINEFILL = 3;

(* basic pattern symbols *)
CONST PATSYM_ERROR   =        -1;
CONST PATSYM_DEFAULT =         0;
CONST PATSYM_DENSE1 =          1;
CONST PATSYM_DENSE2 =          2;
CONST PATSYM_DENSE3 =          3;
CONST PATSYM_DENSE4 =          4;
CONST PATSYM_DENSE5 =          5;
CONST PATSYM_DENSE6 =          6;
CONST PATSYM_DENSE7 =          7;
CONST PATSYM_DENSE8 =          8;
CONST PATSYM_VERT =            9;
CONST PATSYM_HORIZ =           10;
CONST PATSYM_DIAG1 =           11;
CONST PATSYM_DIAG2 =           12;
CONST PATSYM_DIAG3 =           13;
CONST PATSYM_DIAG4 =           14;
CONST PATSYM_NOSHADE =         15;
CONST PATSYM_SOLID =           16;
CONST PATSYM_BLANK =           64;
CONST PATSYM_HALFTONE =        17;

(* lcid values for GpiSet/QueryPattern and others *)
CONST LCID_ERROR           =  -1;
CONST LCID_DEFAULT =           0;

(*** global primitive functions *)

  FUNCTION GpiSetColor(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetColor(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryColor(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryColor(ahps : hPs) : LongInt;

(*** line primitive functions *)

  FUNCTION GpiBox(hPs     : hPs;
                  l1      : LongInt;
                  aPointL : { LONG } PointL;
                  l2, l8  : LongInt) : LongInt;
  FUNCTION Gpi16Box(hPs   : hPs;
                  l1      : LongInt;
                  aPointL : { LONG } PointL;
                  l2, l8  : LongInt) : LongInt;

  FUNCTION GpiMove(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16Move(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiLine(  hPs : hPs; aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16Line(hPs : hPs; aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiPolyLine(ahps   : hPs;
                       l1     : LongInt;
                       PointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16PolyLine(ahps   : hPs;
                         l1     : LongInt;
                         PointL : { LONG } PointL) : LongInt;

(*** area primitive functions *)

  FUNCTION GpiSetPattern(  ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetPattern(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryPattern(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryPattern(ahps : hPs) : LongInt;

  FUNCTION GpiBeginArea(ahps : hPs; u : LongInt) : BOOLEAN;
  FUNCTION Gpi16BeginArea(ahps : hPs; u : LongInt) : BOOLEAN;

  FUNCTION GpiEndArea(ahps : hPs) : LongInt;
  FUNCTION Gpi16EndArea(ahps : hPs) : LongInt;

(*** character primitive functions *)

  FUNCTION GpiCharString(ahps : hPs; l1 : LongInt; P : pCh) : LongInt;
  FUNCTION Gpi16CharString(ahps : hPs; l1 : LongInt; P : pCh) : LongInt;

  FUNCTION GpiCharStringAt(ahps    : hPs;
                           aPointL : { LONG } pPointL;
                           l2      : LongInt;
                           P       : pCh) : LongInt;
  FUNCTION Gpi16CharStringAt(ahps  : hPs;
                           aPointL : { LONG } pPointL;
                           l2      : LongInt;
                           P       : pCh) : LongInt;

(* mode for GpiSetAttrMode *)
CONST
  AM_ERROR    =      -1;
  AM_PRESERVE =       0;
 AM_NOPRESERVE =     1;

(* foreground mixes *)
 FM_ERROR   =            -1;
 FM_DEFAULT =             0;
 FM_OR =                  1;
 FM_OVERPAINT =           2;
 FM_LEAVEALONE =          5;


 FM_XOR =                 4;
 FM_AND =                 6;
 FM_SUBTRACT =            7;
 FM_MASKSRCNOT =          8;
 FM_ZERO =                9;
 FM_NOTMERGESRC =         10;
 FM_NOTXORSRC =           11;
 FM_INVERT =              12;
 FM_MERGESRCNOT =         13;
 FM_NOTCOPYSRC =          14;
 FM_MERGENOTSRC =         15;
 FM_NOTMASKSRC =          16;
 FM_ONE =                 17;

(* background mixes *)
 BM_ERROR              = -1;
 BM_DEFAULT =             0;
 BM_OVERPAINT =           2;
 BM_LEAVEALONE =          5;

 BM_OR =                  1;
 BM_XOR =                 4;

(* basic line type styles *)
 LINETYPE_ERROR        =  -1;
 LINETYPE_DEFAULT =        0;
 LINETYPE_DOT =            1;
 LINETYPE_SHORTDASH =      2;
 LINETYPE_DASHDOT =        3;
 LINETYPE_LONGDASH      = 5;
 LINETYPE_DASHDOUBLEDOT = 6;
 LINETYPE_SOLID         = 7;
 LINETYPE_INVISIBLE     = 8;
 LINETYPE_ALTERNATE     = 9;

(* cosmetic line widths *)
 LINEWIDTH_ERROR       = -1;
 LINEWIDTH_DEFAULT     =  0;
 LINEWIDTH_NORMAL      = $000010000;   (* MAKEFIXED(1,0) *)

(* actual line widths *)
 LINEWIDTHGEOM_ERROR     =-1;

(* line end styles *)
 LINEEND_ERROR       =   -1;
 LINEEND_DEFAULT     =    0;
 LINEEND_FLAT        =    1;
 LINEEND_SQUARE      =    2;
 LINEEND_ROUND       =    3;

(* line join styles *)
 LINEJOIN_ERROR      =    -1;
 LINEJOIN_DEFAULT    =    0;
 LINEJOIN_BEVEL      =    1;
 LINEJOIN_ROUND      =    2;
 LINEJOIN_MITRE      =    3;

(* character directions *)
 CHDIRN_ERROR         =   -1;
 CHDIRN_DEFAULT       =   0;
 CHDIRN_LEFTRIGHT     =   1;
 CHDIRN_TOPBOTTOM     =   2;
 CHDIRN_RIGHTLEFT     =   3;
 CHDIRN_BOTTOMTOP     =   4;

(* character modes *)
 CM_ERROR             =  -1;
 CM_DEFAULT           =   0;
 CM_MODE1             =   1;
 CM_MODE2             =   2;
 CM_MODE3             =   3;

(* basic marker symbols *)
 MARKSYM_ERROR         = -1;
 MARKSYM_DEFAULT       =  0;
 MARKSYM_CROSS         =  1;
 MARKSYM_PLUS          =  2;
 MARKSYM_DIAMOND       =  3;
 MARKSYM_SQUARE        =  4;
 MARKSYM_SIXPOINTSTAR  =  5;
CONST MARKSYM_EIGHTPOINTSTAR = 6;
CONST MARKSYM_SOLIDDIAMOND   = 7;
CONST MARKSYM_SOLIDSQUARE    = 8;
CONST MARKSYM_DOT            = 9;
CONST MARKSYM_SMALLCIRCLE    = 10;
CONST MARKSYM_BLANK          = 64;

(* formatting options for GpiCharStringPosAt *)
CONST CHS_OPAQUE           =   $00001;
CONST CHS_VECTOR           =   $00002;
CONST CHS_LEAVEPOS         =   $00008;
CONST CHS_CLIP             =   $00010;

(* bundle codes for GpiSetAttributes and GpiQueryAttributes *)
CONST PRIM_LINE            =   1;
CONST PRIM_CHAR            =   2;
CONST PRIM_MARKER          =   3;
CONST PRIM_AREA            =   4;
CONST PRIM_IMAGE           =   5;

(* line bundle mask bits *)
CONST LBB_COLOR           =    $00001;
CONST LBB_MIX_MODE        =    $00004;
CONST LBB_WIDTH           =    $00010;
CONST LBB_GEOM_WIDTH      =    $00020;
CONST LBB_TYPE            =    $00040;
CONST LBB_END             =    $00080;
CONST LBB_JOIN            =    $00100;

(* character bundle mask bits *)
CONST CBB_COLOR           =    $00001;
CONST CBB_BACK_COLOR      =    $00002;
CONST CBB_MIX_MODE        =    $00004;
CONST CBB_BACK_MIX_MODE   =    $00008;
CONST CBB_SET             =    $00010;
CONST CBB_MODE            =    $00020;
CONST CBB_BOX             =    $00040;
CONST CBB_ANGLE           =    $00080;
CONST CBB_SHEAR           =    $00100;
CONST CBB_DIRECTION       =    $00200;

(* marker bundle mask bits *)
CONST MBB_COLOR           =    $00001;
CONST MBB_BACK_COLOR      =    $00002;
CONST MBB_MIX_MODE        =    $00004;
CONST MBB_BACK_MIX_MODE   =    $00008;
CONST MBB_SET             =    $00010;
CONST MBB_SYMBOL          =    $00020;
CONST MBB_BOX             =    $00040;

(* pattern bundle mask bits *)
CONST ABB_COLOR           =    $00001;
CONST ABB_BACK_COLOR      =    $00002;
CONST ABB_MIX_MODE        =    $00004;
CONST ABB_BACK_MIX_MODE   =    $00008;
CONST ABB_SET             =    $00010;
CONST ABB_SYMBOL          =    $00020;
CONST ABB_REF_POINT       =    $00040;

(* image bundle mask bits *)
CONST IBB_COLOR           =    $00001;
CONST IBB_BACK_COLOR      =    $00002;
CONST IBB_MIX_MODE        =    $00004;
CONST IBB_BACK_MIX_MODE   =    $00008;

(* structure for GpiSetArcParams and GpiQueryArcParams *)
TYPE
  ArcParams = RECORD     (* arcp *)
    lP : LongInt;
    lQ : LongInt;
    lR : LongInt;
    lS : LongInt;
  END;
  Params = ^ArcParams;

   (* variation of SIZE used for FIXEDs *)
   SizeF = RECORD        (* sizfx *)
     cx : Fixed;
     cy : Fixed;
   END;
   pSizeF = ^SizeF;

(* structure for gradient parameters e.g. for GpiSetCharAngle *)
   GradientL = RECORD      (* gradl *)
     x : LongInt;
     y : LongInt;
   END;
   pGradientL = ^GradientL;

(* line bundle for GpiSetAttributes and GpiQueryAttributes *)
TYPE
  LineBundlE = RECORD     (* lbnd *)
    lColor     : LongInt;
    lReserved  : LongInt;
    usMixMode  : WORD;
    usReserved : WORD;
    fxWidth    : Fixed;
    lGeomWidth : LongInt;
    usType     : WORD;
    usEnd      : WORD;
    usJoin     : WORD;
  END;

(* character bundle for GpiSetAttributes and GpiQueryAttributes *)
TYPE
  CharBundle = RECORD     (* cbnd *)
    lColor        : LongInt;
    lBackColor    : LongInt;
    usMixMode     : WORD;
    usBackMixMode : WORD;
    usSet         : WORD;
    usPrecision   : WORD;
    sizfxCell     : SizeF;
    ptlAngle      : PointL;
    ptlShear      : PointL;
    usDirection   : WORD;
  END;

(* marker bundle for GpiSetAttributes and GpiQueryAttributes *)
TYPE
  MarkerBundle = RECORD   (* mbnd *)
    lColor        : LongInt;
    lBackColor    : LongInt;
    usMixMode     : WORD;
    usBackMixMode : WORD;
    usSet         : WORD;
    usSymbol      : WORD;
    sizfxCell     : SizeF;
  END;

(* pattern bundle for GpiSetAttributes and GpiQueryAttributes *)
TYPE
  AreaBundle = RECORD  (* pbnd *)
    lColor        : LongInt;
    lBackColor    : LongInt;
    usMixMode     : WORD;
    usBackMixMode : WORD;
    usSet         : WORD;
    usSymbol      : WORD;
    ptlRefPoint   : PointL;
  END;

(* image bundle for GpiSetAttributes and GpiQueryAttributes *)
TYPE
  ImageBundle = RECORD    (* ibmd *)
    lColor        : LongInt;
    lBackColor    : LongInt;
    usMixMode     : WORD;
    usBackMixMode : WORD;
  END;

(* pointer to any bundle used by GpiSet/QueryAttrs *)
  pBundle = Pointer;  (* typedef PVOID PBUNDLE; *)

(* array indices for GpiQueryTextBox *)
CONST
  TXTBOX_TOPLEFT    =  0;
  TXTBOX_BOTTOMLEFT =  1;
  TXTBOX_TOPRIGHT   =  2;
  TXTBOX_BOTTOMRIGHT = 3;
  TXTBOX_CONCAT     =  4;

(* array count for GpiQueryTextBox *)
  TXTBOX_COUNT      =  5;

(* return codes for GpiPtVisible *)
  PVIS_ERROR     =  0;
  PVIS_INVISIBLE =  1;
  PVIS_VISIBLE   =  2;

(* return codes for GpiRectVisible *)
  RVIS_ERROR      = 0;
  RVIS_INVISIBLE  = 1;
  RVIS_PARTIAL    = 2;
  RVIS_VISIBLE    = 3;

(*** attribute mode functions *)

  FUNCTION GpiSetAttrMode(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetAttrMode(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryAttrMode(hPs : hPs) : LongInt;
  FUNCTION Gpi16QueryAttrMode(hPs : hPs) : LongInt;

(*** bundle primitive functions *)

  FUNCTION GpiSetAttrs(ahps  : hPs;
                       l1    : LongInt;
                       c1    : LongInt;
                       u     : LongInt;
                       P {?} : pBundle) : BOOLEAN;
  FUNCTION Gpi16SetAttrs(ahps  : hPs;
                         l1    : LongInt;
                         c1    : LongInt;
                         u     : LongInt;
                         P {?} : pBundle) : BOOLEAN;

  FUNCTION GpiQueryAttrs(ahps   : hPs;
                         l1, l2 : LongInt;
                         P {?}  : pBundle) : LongInt;
  FUNCTION Gpi16QueryAttrs(ahps   : hPs;
                           l1, l2 : LongInt;
                           P {?}  : pBundle) : LongInt;

(*** global primitive functions *)

  FUNCTION GpiSetBackColor(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetBackColor(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryBackColor(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryBackColor(ahps : hPs) : LongInt;

  FUNCTION GpiSetMix(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetMix(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryMix(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryMix(ahps : hPs) : LongInt;

  FUNCTION GpiSetBackMix(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetBackMix(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryBackMix(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryBackMix(ahps : hPs) : LongInt;

(*** line primitive functions *)

  FUNCTION GpiSetLineType(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetLineType(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryLineType(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryLineType(ahps : hPs) : LongInt;

  FUNCTION GpiSetLineWidth(ahps : hPs; f : Fixed) : BOOLEAN;
  FUNCTION Gpi16SetLineWidth(ahps : hPs; f : Fixed) : BOOLEAN;

  FUNCTION GpiQueryLineWidth(ahps : hPs) : Fixed;
  FUNCTION Gpi16QueryLineWidth(ahps : hPs) : Fixed;

  FUNCTION GpiSetLineWidthGeom(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetLineWidthGeom(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryLineWidthGeom(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryLineWidthGeom(ahps : hPs) : LongInt;

  FUNCTION GpiSetLineEnd(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetLineEnd(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryLineEnd(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryLineEnd(ahps : hPs) : LongInt;

  FUNCTION GpiSetLineJoin(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetLineJoin(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryLineJoin(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryLineJoin(ahps : hPs) : LongInt;

  FUNCTION GpiSetCurrentPosition(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16SetCurrentPosition(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryCurrentPosition(    ahps    : hPs;
                                   VAR aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16QueryCurrentPosition(    ahps    : hPs;
                                     VAR aPointL : { LONG } PointL) : BOOLEAN;

(*** arc primitive functions *)

  FUNCTION GpiSetArcParams(ahps : hPs;
                           P    : { LONG } ArcParams) : BOOLEAN;
  FUNCTION Gpi16SetArcParams(ahps : hPs;
                             P    : { LONG } ArcParams) : BOOLEAN;

  FUNCTION GpiQueryArcParams(    ahps : hPs;
                             VAR P    : { LONG } ArcParams) : BOOLEAN;
  FUNCTION Gpi16QueryArcParams(    ahps : hPs;
                               VAR P    : { LONG } ArcParams) : BOOLEAN;

  FUNCTION GpiPointArc(ahps    : hPs;
                       aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16PointArc(ahps    : hPs;
                         aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiFullArc(ahps : hPs;
                      l1   : LongInt;
                      f    : Fixed) : LongInt;
  FUNCTION Gpi16FullArc(ahps : hPs;
                        l1   : LongInt;
                        f    : Fixed) : LongInt;

  FUNCTION GpiPartialArc(ahps       : hPs;
                         aPointL    : { LONG } PointL;
                         f1, f2, f3 : Fixed) : LongInt;
  FUNCTION Gpi16PartialArc(ahps       : hPs;
                         aPointL    : { LONG } PointL;
                         f1, f2, f3 : Fixed) : LongInt;

  FUNCTION GpiPolyFilletSharp(ahps    : hPs;
                              l1      : LongInt;
                              aPointL : { LONG } PointL;
                              f4      : { LONG } Fixed) : LongInt;
  FUNCTION Gpi16PolyFilletSharp(ahps    : hPs;
                              l1      : LongInt;
                              aPointL : { LONG } PointL;
                              f4      : { LONG } Fixed) : LongInt;

  FUNCTION GpiPolySpline(ahps    : hPs;
                         l1      : LongInt;
                         aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16PolySpline(ahps    : hPs;
                         l1      : LongInt;
                         aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiPolyFillet(ahps   : hPs;
                         l1     : LongInt;
                         PointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16PolyFillet(ahps   : hPs;
                         l1     : LongInt;
                         PointL : { LONG } PointL) : LongInt;

(*** area primitive functions *)

  FUNCTION GpiSetPatternSet(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetPatternSet(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryPatternSet(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryPatternSet(ahps : hPs) : LongInt;

  FUNCTION GpiSetPatternRefPoint(ahps    : hPs;
                                 aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16SetPatternRefPoint(ahps    : hPs;
                                 aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryPatternRefPoint(    ahps   : hPs;
                                   VAR PointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16QueryPatternRefPoint(    ahps   : hPs;
                                   VAR PointL : { LONG } PointL) : BOOLEAN;
(*** character primitive functions *)

  FUNCTION GpiQueryCharStringPos(    ahps    : hPs;
                                     c1      : LongInt;
                                     l2      : LongInt;
                                     P       : pCh;
                                 VAR i1      : { LONG } LongInt;
                                 VAR aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16QueryCharStringPos(  ahps    : hPs;
                                     c1      : LongInt;
                                     l2      : LongInt;
                                     P       : pCh;
                                 VAR i1      : { LONG } LongInt;
                                 VAR aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryCharStringPosAt(    hPs     : hPs;
                                       aPointL : { LONG } PointL;
                                       c3      : LongInt;
                                       l2      : LongInt;
                                       P       : pCh;
                                   VAR i1      : { LONG } LongInt;
                                   VAR aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16QueryCharStringPosAt(  hPs     : hPs;
                                       aPointL : { LONG } PointL;
                                       c3      : LongInt;
                                       l2      : LongInt;
                                       P       : pCh;
                                   VAR i1      : { LONG } LongInt;
                                   VAR aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryTextBox(    ahps    : hPs;
                               l1      : LongInt;
                               P       : pCh;
                               l2      : LongInt;
                           VAR aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16QueryTextBox(  ahps    : hPs;
                               l1      : LongInt;
                               P       : pCh;
                               l2      : LongInt;
                           VAR aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryDefCharBox(    ahps : hPs;
                              VAR P    : { LONG } SizeL) : BOOLEAN;
  FUNCTION Gpi16QueryDefCharBox(  ahps : hPs;
                              VAR P    : { LONG } SizeL) : BOOLEAN;

  FUNCTION GpiSetCharSet(  ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetCharSet(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryCharSet(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryCharSet(ahps : hPs) : LongInt;

  FUNCTION GpiSetCharBox(  ahps : hPs; SizeF : { LONG } SizeF) : BOOLEAN;
  FUNCTION Gpi16SetCharBox(ahps : hPs; SizeF : { LONG } SizeF) : BOOLEAN;

  FUNCTION GpiQueryCharBox(    ahps  : hPs;
                           VAR SizeF : { LONG } SizeF) : BOOLEAN;
  FUNCTION Gpi16QueryCharBox(    ahps  : hPs;
                             VAR SizeF : { LONG } SizeF) : BOOLEAN;

  FUNCTION GpiSetCharAngle(ahps       : hPs;
                           aGradientL : { LONG } GradientL) : BOOLEAN;
  FUNCTION Gpi16SetCharAngle(ahps       : hPs;
                           aGradientL : { LONG } GradientL) : BOOLEAN;

  FUNCTION GpiQueryCharAngle(    ahps       : hPs;
                             VAR aGradientL : { LONG } GradientL) : BOOLEAN;
  FUNCTION Gpi16QueryCharAngle(    ahps       : hPs;
                             VAR aGradientL : { LONG } GradientL) : BOOLEAN;

  FUNCTION GpiSetCharShear(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16SetCharShear(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiQueryCharShear(    ahps    : hPs;
                             VAR aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16QueryCharShear(    ahps    : hPs;
                               VAR aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiSetCharDirection(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetCharDirection(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryCharDirection(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryCharDirection(ahps : hPs) : LongInt;

  FUNCTION GpiSetCharMode(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetCharMode(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryCharMode(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryCharMode(ahps : hPs) : LongInt;

  FUNCTION GpiCharStringPos(    ahps : hPs;
                                ectl : { LONG } RectL;
                                c4   : LongInt;
                                l2   : LongInt;
                                P    : pCh;
                            VAR i1   : { LONG } LongInt) : LongInt;
  FUNCTION Gpi16CharStringPos(  ahps : hPs;
                                ectl : { LONG } RectL;
                                c4   : LongInt;
                                l2   : LongInt;
                                P    : pCh;
                            VAR i1   : { LONG } LongInt) : LongInt;

  FUNCTION GpiCharStringPosAt(ahps    : hPs;
                              aPointL : { LONG } PointL;
                              aRectl  : { LONG } RectL;
                              c4      : LongInt;
                              l2      : LongInt;
                              P       : pCh;
                              i6      : LongInt) : LongInt;
  FUNCTION Gpi16CharStringPosAt(ahps  : hPs;
                              aPointL : { LONG } PointL;
                              aRectl  : { LONG } RectL;
                              c4      : LongInt;
                              l2      : LongInt;
                              P       : pCh;
                              i6      : LongInt) : LongInt;

(*** marker primitive functions *)

  FUNCTION GpiSetMarkerSet(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetMarkerSet(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryMarkerSet(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryMarkerSet(ahps : hPs) : LongInt;

  FUNCTION GpiSetMarker(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetMarker(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryMarker(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryMarker(ahps : hPs) : LongInt;

  FUNCTION GpiSetMarkerBox(ahps : hPs; aSizeF : { LONG } SizeF) : BOOLEAN;
  FUNCTION Gpi16SetMarkerBox(ahps : hPs; aSizeF : { LONG } SizeF) : BOOLEAN;

  FUNCTION GpiQueryMarkerBox(ahps : hPs; VAR aSizeF : { LONG } SizeF) : BOOLEAN;
  FUNCTION Gpi16QueryMarkerBox(ahps : hPs; VAR aSizeF : { LONG } SizeF) : BOOLEAN;

  FUNCTION GpiMarker(ahps : hPs; aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16Marker(ahps : hPs; aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiPolyMarker(ahps    : hPs;
                         l1      : LongInt;
                         aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16PolyMarker(ahps    : hPs;
                           l1      : LongInt;
                           aPointL : { LONG } PointL) : LongInt;

(*** image primitive functions *)

  FUNCTION GpiImage(ahps   : hPs;
                    l1     : LongInt;
                    aSizeL : { LONG } SizeL;
                    c7     : LongInt;
                    aByte  : Pointer) : LongInt;
  FUNCTION Gpi16Image(ahps : hPs;
                    l1     : LongInt;
                    aSizeL : { LONG } SizeL;
                    c7     : LongInt;
                    aByte  : Pointer) : LongInt;

(*** miscellaneous primitive functions *)

  FUNCTION GpiPop(  ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16Pop(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiPtVisible(ahps : hPs; aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16PtVisible(ahps : hPs; aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiRectVisible(ahps : hPs; aRectl : { LONG } RectL) : LongInt;
  FUNCTION Gpi16RectVisible(ahps : hPs; aRectl : { LONG } RectL) : LongInt;

  FUNCTION GpiComment(ahps  : hPs;
                      l1    : LongInt;
                      aByte : Pointer) : BOOLEAN;
  FUNCTION Gpi16Comment(ahps  : hPs;
                        l1    : LongInt;
                        aByte : Pointer) : BOOLEAN;

(* return codes from GpiCreateLogFont *)
CONST
  FONT_DEFAULT   =  1;
  FONT_MATCH     =  2;

(* lcid type for GpiQuerySetIds *)
  LCIDT_FONT     =  6;

  LCIDT_BITMAP   =  7;

(* constant used to delete all lcids by GpiDeleteSetId *)
  LCID_ALL       =  -1;

(* kerning data returned by GpiQueryKerningPairs *)
TYPE
  KerningPairs = RECORD   (* krnpr *)
    sFirstChar     : INTEGER;
    sSecondChar    : INTEGER;
    sKerningAmount : INTEGER;
  END;
  pKerningPairs = ^KerningPairs;

(* options for GpiQueryFonts *)
CONST
  QF_PUBLIC       =        $00001;
  QF_PRIVATE      =        $00002;

(* font file descriptions for GpiQueryFontFileDescriptions *)
TYPE
  FFDescs  = ARRAY [0..1, 0..FACESIZE-1] OF CHAR; (* ffdescs *)
  pFFDescs = ^FFDescs;

(*** physical and logical font functions *)

  FUNCTION GpiDeleteSetId(ahps : hPs; l : LongInt) : BOOLEAN;
  FUNCTION Gpi16DeleteSetId(ahps : hPs; l : LongInt) : BOOLEAN;

  FUNCTION GpiQueryNumberSetIds(ahps : hPs) : LongInt;
  FUNCTION Gpi16QueryNumberSetIds(ahps : hPs) : LongInt;

  FUNCTION GpiQuerySetIds(    ahps : hPs;
                              l1   : LongInt;
                          VAR l9   : { LONG } LongInt;
                          VAR aStr8: { LONG } Str8;
                          VAR i3   : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16QuerySetIds(  ahps : hPs;
                              l1   : LongInt;
                          VAR l9   : { LONG } LongInt;
                          VAR aStr8: { LONG } Str8;
                          VAR i3   : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiLoadFonts(  ahab : HAB; P : pChar) : BOOLEAN;
  FUNCTION Gpi16LoadFonts(ahab : HAB; P : pChar) : BOOLEAN;

  FUNCTION GpiUnloadFonts(  ahab : HAB; P : pChar) : BOOLEAN;
  FUNCTION Gpi16UnloadFonts(ahab : HAB; P : pChar) : BOOLEAN;

  FUNCTION GpiCreateLogFont(    ahps    : hPs;
                            VAR aStr8   : { LONG } Str8;
                                i5      : LongInt;
                            VAR aFAttrs : { LONG } fAttrs) : LongInt;
  FUNCTION Gpi16CreateLogFont(    ahps    : hPs;
                              VAR aStr8   : { LONG } Str8;
                                  i5      : LongInt;
                              VAR aFAttrs : { LONG } fAttrs) : LongInt;

  FUNCTION GpiQueryFonts(    ahps         : hPs;
                             l1           : LongInt;
                             P            : pChar;
                         VAR c2           : { LONG } LongInt;
                             c3           : LongInt;
                         VAR aFontMetrics : { LONG } FontMetrics) : LongInt;
  FUNCTION Gpi16QueryFonts(    ahps         : hPs;
                               l1           : LongInt;
                               P            : pChar;
                           VAR c2           : { LONG } LongInt;
                               c3           : LongInt;
                           VAR aFontMetrics : { LONG } FontMetrics) : LongInt;

  FUNCTION GpiQueryFontMetrics(    ahps         : hPs;
                                   l1           : LongInt;
                               VAR aFontMetrics : { LONG } FontMetrics) : BOOLEAN;
  FUNCTION Gpi16QueryFontMetrics(  ahps         : hPs;
                                   l1           : LongInt;
                               VAR aFontMetrics : { LONG } FontMetrics) : BOOLEAN;

  FUNCTION GpiQueryKerningPairs(    ahps          : hPs;
                                    l1            : LongInt;
                                VAR aKerningPairs : { LONG } KerningPairs) : LongInt;
  FUNCTION Gpi16QueryKerningPairs(  ahps          : hPs;
                                    l1            : LongInt;
                                VAR aKerningPairs : { LONG } KerningPairs) : LongInt;

  FUNCTION GpiQueryWidthTable(    ahps      : hPs;
                                  l1        : LongInt;
                                  l6        : LongInt;
                              VAR LongArray : LongInt) : BOOLEAN;
  FUNCTION Gpi16QueryWidthTable(  ahps      : hPs;
                                  l1        : LongInt;
                                  l6        : LongInt;
                              VAR LongArray : LongInt) : BOOLEAN;

  FUNCTION GpiSetCp(ahps : hPs; c8 : WORD) : BOOLEAN;
  FUNCTION Gpi16SetCp(ahps : hPs; c8 : WORD) : BOOLEAN;

  FUNCTION GpiQueryCp(ahps : hPs) : WORD;
  FUNCTION Gpi16QueryCp(ahps : hPs) : WORD;

  FUNCTION GpiQueryFontFileDescriptions(    ahab     : HAB;
                                            P        : pChar;
                                        VAR c2       : { LONG } LongInt;
                                        VAR aFFDescs : { LONG } FFDescs) : LongInt;
  FUNCTION Gpi16QueryFontFileDescriptions(  ahab     : HAB;
                                            P        : pChar;
                                        VAR c2       : { LONG } LongInt;
                                        VAR aFFDescs : { LONG } FFDescs) : LongInt;

(* rastor operations defined for GpiBitBlt *)
CONST
  ROP_SRCCOPY      =       $000CC;
  ROP_SRCPAINT     =       $000EE;
  ROP_SRCAND       =       $00088;
  ROP_SRCINVERT    =       $00066;
  ROP_SRCERASE     =       $00044;
  ROP_NOTSRCCOPY   =       $00033;
  ROP_NOTSRCERASE  =       $00011;
  ROP_MERGECOPY    =       $000C0;
  ROP_MERGEPAINT   =       $000BB;
  ROP_PATCOPY      =       $000F0;
  ROP_PATPAINT     =       $000FB;
  ROP_PATINVERT    =       $0005A;
  ROP_DSTINVERT    =       $00055;
  ROP_ZERO         =       $00000;
  ROP_ONE          =       $000FF;

(* Blt options for GpiBitBlt *)
  BBO_OR           =   0;
  BBO_AND          =   1;
  BBO_IGNORE       =   2;

(* error return for GpiSetBitmap *)
  HBM_ERROR        =  -1;

(*** bitmap and pel functions *)

  FUNCTION GpiDeleteBitmap(  aHBitmap : hBitmap) : BOOLEAN;
  FUNCTION Gpi16DeleteBitmap(aHBitmap : hBitmap) : BOOLEAN;

  FUNCTION GpiSetBitmap(ahps : hPs; aHBitmap : hBitmap) : hBitmap;
  FUNCTION Gpi16SetBitmap(ahps : hPs; aHBitmap : hBitmap) : hBitmap;

  FUNCTION GpiBitBlt(ahps    : hPs;
                     ahps    : hPs;
                     c3      : LongInt;
                     aPointL : { LONG } PointL;
                     c4      : LongInt;
                     i9      : LongInt) : LongInt;
  FUNCTION Gpi16BitBlt(ahps    : hPs;
                     ahps    : hPs;
                     c3      : LongInt;
                     aPointL : { LONG } PointL;
                     c4      : LongInt;
                     i9      : LongInt) : LongInt;

  FUNCTION GpiWCBitBlt(ahps     : hPs;
                       aHBitmap : hBitmap;
                       ac3      : LongInt;
                       aPointL  : { LONG } PointL;
                       c3       : LongInt;
                       i9       : LongInt) : LongInt;
  FUNCTION Gpi16WCBitBlt(ahps     : hPs;
                         aHBitmap : hBitmap;
                         ac3      : LongInt;
                       aPointL  : { LONG } PointL;
                       c3       : LongInt;
                       i9       : LongInt) : LongInt;

(* usage flags for GpiCreateBitmap *)
CONST
  CBM_INIT   =     $00004;

(* bitmap parameterization used by GpiCreateBitmap and others *)
TYPE
  BitmapInfoHeader = RECORD       (* bmp *)
    cbFix     : LongInt;
    cx        : WORD;
    cy        : WORD;
    cPlanes   : WORD;
    cBitCount : WORD;
  END;
  pBitmapInfoHeader = ^BitmapInfoHeader;

(* RGB data for _BITMAPINFO struct *)
TYPE
  RGB = RECORD            (* rgb *)
    bBlue  : BYTE;
    bGreen : BYTE;
    bRed   : BYTE;
  END;

(* bitmap data used by GpiSetBitmapBits and others *)
  BitmapInfo = RECORD
    cbFix     : LongInt;
    cx        : WORD;
    cy        : WORD;
    cPlanes   : WORD;
    cBitCount : WORD;
    argbColor : ARRAY [0..0] OF RGB;
  END;
  pBitmapInfo = ^BitmapInfo;

(* error return code for GpiSet/QueryBitmapBits *)
CONST
  BMB_ERROR   =    (-1);

(*** bitmap and pel functions *)

  FUNCTION GpiCreateBitmap(ahps              : hPs;
                           aBitMapInfoHeader : { LONG } BitmapInfoHeader;
                           i8                : LongInt;
                           aByte             : Pointer;
                           aBitMapInfo       : { LONG } BitmapInfo) : hBitmap;
  FUNCTION Gpi16CreateBitmap(ahps            : hPs;
                           aBitMapInfoHeader : { LONG } BitmapInfoHeader;
                           i8                : LongInt;
                           aByte             : Pointer;
                           aBitMapInfo       : { LONG } BitmapInfo) : hBitmap;

  FUNCTION GpiSetBitmapDimension(aHBitmap : hBitmap;
                                 aPSizeL  : { LONG } SizeL) : BOOLEAN;
  FUNCTION Gpi16SetBitmapDimension(aHBitmap : hBitmap;
                                   aPSizeL  : { LONG } SizeL) : BOOLEAN;

  FUNCTION GpiQueryBitmapDimension(    aHBitmap : hBitmap;
                                   VAR aPSizeL  : { LONG } SizeL) : BOOLEAN;
  FUNCTION Gpi16QueryBitmapDimension(  aHBitmap : hBitmap;
                                   VAR aPSizeL  : { LONG } SizeL) : BOOLEAN;

  FUNCTION GpiQueryDeviceBitmapFormats(    ahps : hPs;
                                           l1   : LongInt;
                                       VAR l7   : { LONG } LongInt) : BOOLEAN;
  FUNCTION Gpi16QueryDeviceBitmapFormats(  ahps : hPs;
                                           l1   : LongInt;
                                       VAR l7   : { LONG } LongInt) : BOOLEAN;

  FUNCTION GpiQueryBitmapParameters(    aHBitmap          : hBitmap;
                                    VAR aBitMapInfoHeader : { LONG } BitmapInfoHeader) : BOOLEAN;
  FUNCTION Gpi16QueryBitmapParameters(  aHBitmap          : hBitmap;
                                    VAR aBitMapInfoHeader : { LONG } BitmapInfoHeader) : BOOLEAN;

  FUNCTION GpiQueryBitmapBits(    ahps        : hPs;
                                  l1          : LongInt;
                                  l6          : LongInt;
                                  aByte       : Pointer;
                              VAR aBitMapInfo : { LONG } BitmapInfo) : LongInt;
  FUNCTION Gpi16QueryBitmapBits(  ahps        : hPs;
                                  l1          : LongInt;
                                  l6          : LongInt;
                                  aByte       : Pointer;
                              VAR aBitMapInfo : { LONG } BitmapInfo) : LongInt;

  FUNCTION GpiSetBitmapBits(ahps        : hPs;
                            l1          : LongInt;
                            l6          : LongInt;
                            aByte       : Pointer;
                            aBitMapInfo : { LONG } BitmapInfo) : LongInt;
  FUNCTION Gpi16SetBitmapBits(ahps      : hPs;
                            l1          : LongInt;
                            l6          : LongInt;
                            aByte       : Pointer;
                            aBitMapInfo : { LONG } BitmapInfo) : LongInt;

  FUNCTION GpiSetPel(  ahps : hPs; aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16SetPel(ahps : hPs; aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiQueryPel(    ahps    : hPs;
                       VAR aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16QueryPel(    ahps    : hPs;
                       VAR aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiSetBitmapId(ahps : hPs; aHBitmap : hBitmap; c4 : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetBitmapId(ahps : hPs; aHBitmap : hBitmap; c4 : LongInt) : BOOLEAN;

  FUNCTION GpiQueryBitmapHandle(ahps : hPs; l : LongInt) : hBitmap;
  FUNCTION Gpi16QueryBitmapHandle(ahps : hPs; l : LongInt) : hBitmap;

(* options for GpiCombineRegion *)
CONST
  CRGN_OR      =           1;
  CRGN_COPY    =           2;
  CRGN_XOR     =           4;
  CRGN_AND     =           6;
  CRGN_DIFF    =           7;

(* usDirection of returned region data for GpiQueryRegionRects *)
  RECTDIR_LFRT_TOPBOT  =   1;
  RECTDIR_RTLF_TOPBOT  =   2;
  RECTDIR_LFRT_BOTTOP  =   3;
  RECTDIR_RTLF_BOTTOP  =   4;

(* control data for GpiQueryRegionRects *)
TYPE
  rgnRect = RECORD        (* rgnrc *)
    ircStart    : WORD;
    Crc         : WORD;
    CrcReturned : WORD;
    usDirection : WORD;
  END;
  pRGNRect = ^rgnRect;

(* return code to indicate type of region for GpiCombineRegion and others *)
CONST
  RGN_ERROR    =   0;
  RGN_NULL     =   1;
  RGN_RECT     =   2;
  RGN_COMPLEX  =   3;

(* return codes for GpiPtInRegion *)
  PRGN_ERROR    =  0;
  PRGN_OUTSIDE  =  1;
  PRGN_INSIDE   =  2;

(* return codes for GpiRectInRegion *)
  RRGN_ERROR    =  0;
  RRGN_OUTSIDE  =  1;
  RRGN_PARTIAL  =  2;
  RRGN_INSIDE   =  3;

(* return codes for GpiEqualRegion *)
  EQRGN_ERROR   =  0;
  EQRGN_NOTEQUAL =  1;
  EQRGN_EQUAL   =  2;

(* error return code for GpiSetRegion *)
  HRGN_ERROR    =  -1;

(*** main region functions *)

  FUNCTION GpiCreateRegion(ahps   : hPs;
                           l1     : LongInt;
                           aRectl : { LONG } RectL) : HRGN;
  FUNCTION Gpi16CreateRegion(ahps   : hPs;
                             l1     : LongInt;
                             aRectl : { LONG } RectL) : HRGN;

  FUNCTION GpiSetRegion(ahps   : hPs;
                        ahRGN  : HRGN;
                        c3     : LongInt;
                        aRectl : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16SetRegion(ahps : hPs;
                        ahRGN  : HRGN;
                        c3     : LongInt;
                        aRectl : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiDestroyRegion(ahps : hPs; hRGN1 : HRGN) : BOOLEAN;
  FUNCTION Gpi16DestroyRegion(ahps : hPs; hRGN1 : HRGN) : BOOLEAN;

  FUNCTION GpiCombineRegion(ahps  : hPs;
                            hRGN1 : HRGN;
                            hRGN2 : HRGN;
                            hRGN3 : HRGN;
                            c4    : LongInt) : LongInt;
  FUNCTION Gpi16CombineRegion(ahps: hPs;
                            hRGN1 : HRGN;
                            hRGN2 : HRGN;
                            hRGN3 : HRGN;
                            c4    : LongInt) : LongInt;

  FUNCTION GpiEqualRegion(ahps  : hPs;
                          hRGN1 : HRGN;
                          hRGN2 : HRGN) : LongInt;
  FUNCTION Gpi16EqualRegion(ahps  : hPs;
                            hRGN1 : HRGN;
                            hRGN2 : HRGN) : LongInt;

  FUNCTION GpiOffsetRegion(ahps    : hPs;
                           ahRGN   : HRGN;
                           aPointL : { LONG } PointL) : BOOLEAN;
  FUNCTION Gpi16OffsetRegion(ahps    : hPs;
                             ahRGN   : HRGN;
                             aPointL : { LONG } PointL) : BOOLEAN;

  FUNCTION GpiPtInRegion(ahps    : hPs;
                         ahRGN   : HRGN;
                         aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16PtInRegion(ahps    : hPs;
                         ahRGN   : HRGN;
                         aPointL : { LONG } PointL) : LongInt;

  FUNCTION GpiRectInRegion(ahps   : hPs;
                           ahRGN  : HRGN;
                           aRectl : { LONG } RectL) : LongInt;
  FUNCTION Gpi16RectInRegion(ahps   : hPs;
                             ahRGN  : HRGN;
                             aRectl : { LONG } RectL) : LongInt;

  FUNCTION GpiQueryRegionBox(    ahps   : hPs;
                                 ahRGN  : HRGN;
                             VAR aRectl : { LONG } RectL) : LongInt;
  FUNCTION Gpi16QueryRegionBox(    ahps   : hPs;
                                   ahRGN  : HRGN;
                               VAR aRectl : { LONG } RectL) : LongInt;

  FUNCTION GpiQueryRegionRects(    ahps     : hPs;
                                   ahRGN    : HRGN;
                                   aRectl   : { LONG } RectL;
                                   aRGNRect : { LONG } rgnRect;
                               VAR aRectl   : { LONG } RectL) : BOOLEAN;
  FUNCTION Gpi16QueryRegionRects(    ahps     : hPs;
                                     ahRGN    : HRGN;
                                     aRectl   : { LONG } RectL;
                                     aRGNRect : { LONG } rgnRect;
                                 VAR aRectl   : { LONG } RectL) : BOOLEAN;

  FUNCTION GpiPaintRegion(  ahps : hPs; ahRGN : HRGN) : LongInt;
  FUNCTION Gpi16PaintRegion(ahps : hPs; ahRGN : HRGN) : LongInt;

(*** clip region functions *)

  FUNCTION GpiSetClipRegion(ahps  : hPs;
                            ahRGN : HRGN;
                            ahRGN : { LONG } HRGN) : LongInt;
  FUNCTION Gpi16SetClipRegion(ahps  : hPs;
                              ahRGN : HRGN;
                              ahRGN : { LONG } HRGN) : LongInt;

  FUNCTION GpiQueryClipRegion(ahps : hPs) : HRGN;
  FUNCTION Gpi16QueryClipRegion(ahps : hPs) : HRGN;

  FUNCTION GpiQueryClipBox(    ahps   : hPs;
                           VAR aRectl : { LONG } RectL) : LongInt;
  FUNCTION Gpi16QueryClipBox(  ahps   : hPs;
                           VAR aRectl : { LONG } RectL) : LongInt;

  FUNCTION GpiIntersectClipRectangle(ahps   : hPs;
                                     aRectl : { LONG } RectL) : LongInt;
  FUNCTION Gpi16IntersectClipRectangle(ahps   : hPs;
                                       aRectl : { LONG } RectL) : LongInt;

  FUNCTION GpiExcludeClipRectangle(ahps   : hPs;
                                   aRectl : { LONG } RectL) : LongInt;
  FUNCTION Gpi16ExcludeClipRectangle(ahps   : hPs;
                                     aRectl : { LONG } RectL) : LongInt;

  FUNCTION GpiOffsetClipRegion(ahps    : hPs;
                               aPointL : { LONG } PointL) : LongInt;
  FUNCTION Gpi16OffsetClipRegion(ahps    : hPs;
                               aPointL : { LONG } PointL) : LongInt;

(* constants for index values of options array for GpiPlayMetafile *)
CONST
  PMF_SEGBASE    =        0;
  PMF_LOADTYPE   =        1;
  PMF_RESOLVE    =        2;
  PMF_LCIDS      =        3;
  PMF_RESET      =        4;
  PMF_SUPPRESS   =        5;
  PMF_COLORTABLES =       6;
  PMF_COLORREALIZABLE =   7;
  PMF_DEFAULTS =   8;

(* options for GpiPlayMetafile *)
  RS_DEFAULT     = 0;
  RS_NODISCARD   = 1;
  LC_DEFAULT     = 0;
  LC_NOLOAD      = 1;
  LC_LOADDISC    = 3;
  LT_DEFAULT     = 0;
  LT_NOMODIFY    = 1;
  LT_ORIGINALVIEW= 4;
  RES_DEFAULT    = 0;
  RES_NORESET    = 1;
  RES_RESET      = 2;
  SUP_DEFAULT    = 0;
  SUP_NOSUPPRESS = 1;
  SUP_SUPPRESS   = 2;
  CTAB_DEFAULT   = 0;
  CTAB_NOMODIFY  = 1;
  CTAB_REPLACE   = 3;
  CREA_DEFAULT   = 0;
  CREA_REALIZE   = 1;
  CREA_NOREALIZE = 2;
  DDEF_DEFAULT  = 0;
  DDEF_IGNORE    = 1;
  DDEF_LOADDISC  = 3;
  RSP_DEFAULT    = 0;
  RSP_NODISCARD  = 1;

(*** metafile functions *)

  FUNCTION GpiLoadMetaFile(ahab : HAB; P : pChar) : hMF;
  FUNCTION Gpi16LoadMetaFile(ahab : HAB; P : pChar) : hMF;

  FUNCTION GpiPlayMetaFile(    ahps : hPs;
                               aHMF : hMF;
                               c3   : LongInt;
                           VAR c2   : { LONG } LongInt;
                           VAR c1   : { LONG } LongInt;
                               c4   : LongInt;
                               P    : pChar) : LongInt;
  FUNCTION Gpi16PlayMetaFile(  ahps : hPs;
                               aHMF : hMF;
                               c3   : LongInt;
                           VAR c2   : { LONG } LongInt;
                           VAR c1   : { LONG } LongInt;
                               c4   : LongInt;
                               P    : pChar) : LongInt;

  FUNCTION GpiSaveMetaFile(  aHMF : hMF; P : pChar) : BOOLEAN;
  FUNCTION Gpi16SaveMetaFile(aHMF : hMF; P : pChar) : BOOLEAN;

  FUNCTION GpiDeleteMetaFile(aHMF : hMF) : BOOLEAN;
  FUNCTION Gpi16DeleteMetaFile(aHMF : hMF) : BOOLEAN;

  FUNCTION GpiCopyMetaFile(aHMF : hMF) : hMF;
  FUNCTION Gpi16CopyMetaFile(aHMF : hMF) : hMF;

  FUNCTION GpiQueryMetaFileLength(aHMF : hMF) : LongInt;
  FUNCTION Gpi16QueryMetaFileLength(aHMF : hMF) : LongInt;

  FUNCTION GpiQueryMetaFileBits(aHMF   : hMF;
                                c1, c3 : LongInt;
                                aByte  : Pointer) : BOOLEAN;
  FUNCTION Gpi16QueryMetaFileBits(aHMF   : hMF;
                                c1, c3 : LongInt;
                                aByte  : Pointer) : BOOLEAN;

  FUNCTION GpiSetMetaFileBits(aHMF   : hMF;
                              c1, c3 : LongInt;
                              aByte  : Pointer) : BOOLEAN;
  FUNCTION Gpi16SetMetaFileBits(aHMF   : hMF;
                                c1, c3 : LongInt;
                                aByte  : Pointer) : BOOLEAN;

  FUNCTION GpiQueryDefArcParams(a : hPs; VAR b : ArcParams) : BOOLEAN;
  FUNCTION Gpi16QueryDefArcParams(a : hPs; VAR b : ArcParams) : BOOLEAN;

  FUNCTION GpiQueryDefAttrs(a : hPs;
                            b : LongInt;
                            c : LongInt;
                            d : pBundle) : BOOLEAN;
  FUNCTION Gpi16QueryDefAttrs(a : hPs;
                              b : LongInt;
                              c : LongInt;
                              d : pBundle) : BOOLEAN;

  FUNCTION GpiQueryDefTag(a : hPs; VAR b : LongInt) : BOOLEAN;
  FUNCTION Gpi16QueryDefTag(a : hPs; VAR b : LongInt) : BOOLEAN;

  FUNCTION GpiQueryDefViewingLimits(a : hPs; VAR b : RectL) : BOOLEAN;
  FUNCTION Gpi16QueryDefViewingLimits(a : hPs; VAR b : RectL) : BOOLEAN;

  FUNCTION GpiSetDefArcParams(a : hPs; b : ArcParams) : BOOLEAN;
  FUNCTION Gpi16SetDefArcParams(a : hPs; b : ArcParams) : BOOLEAN;

  FUNCTION GpiSetDefAttrs(a : hPs;
                          b : LongInt;
                          c : LongInt;
                          d : pBundle) : BOOLEAN;
  FUNCTION Gpi16SetDefAttrs(a : hPs;
                            b : LongInt;
                            c : LongInt;
                            d : pBundle) : BOOLEAN;

  FUNCTION GpiSetDefTag(a : hPs; b : LongInt) : BOOLEAN;
  FUNCTION Gpi16SetDefTag(a : hPs; b : LongInt) : BOOLEAN;

  FUNCTION GpiSetDefViewingLimits(a : hPs; b : RectL) : BOOLEAN;
  FUNCTION Gpi16SetDefViewingLimits(a : hPs; b : RectL) : BOOLEAN;


(* AAB error codes for the GPI *)
CONST
  PMERR_OK                          = $00000;
  PMERR_ALREADY_IN_AREA             = $02001;
  PMERR_ALREADY_IN_ELEMENT          = $02002;
  PMERR_ALREADY_IN_PATH             = $02003;
  PMERR_ALREADY_IN_SEG              = $02004;
  PMERR_AREA_INCOMPLETE             = $02005;
  PMERR_BASE_ERROR                  = $02006;
  PMERR_BITBLT_LENGTH_EXCEEDED      = $02007;
  PMERR_BITMAP_IN_USE               = $02008;
  PMERR_BITMAP_IS_SELECTED          = $02009;
  PMERR_BITMAP_NOT_FOUND            = $0200A;
  PMERR_BITMAP_NOT_SELECTED         = $0200B;
  PMERR_BOUNDS_OVERFLOW             = $0200C;
  PMERR_CALLED_SEG_IS_CHAINED       = $0200D;
  PMERR_CALLED_SEG_IS_CURRENT       = $0200E;
  PMERR_CALLED_SEG_NOT_FOUND        = $0200F;
  PMERR_CANNOT_DELETE_ALL_DATA      = $02010;
  PMERR_CANNOT_REPLACE_ELEMENT_0    = $02011;
  PMERR_COL_TABLE_NOT_REALIZABLE    = $02012;
  PMERR_COL_TABLE_NOT_REALIZED      = $02013;
  PMERR_COORDINATE_OVERFLOW         = $02014;
  PMERR_CORR_FORMAT_MISMATCH        = $02015;
  PMERR_DATA_TOO_LONG               = $02016;
  PMERR_DC_IS_ASSOCIATED            = $02017;
  PMERR_DESC_STRING_TRUNCATED       = $02018;
  PMERR_DEVICE_DRIVER_ERROR_1       = $02019;
  PMERR_DEVICE_DRIVER_ERROR_2       = $0201A;
  PMERR_DEVICE_DRIVER_ERROR_3       = $0201B;
  PMERR_DEVICE_DRIVER_ERROR_4       = $0201C;
  PMERR_DEVICE_DRIVER_ERROR_5       = $0201D;
  PMERR_DEVICE_DRIVER_ERROR_6       = $0201E;
  PMERR_DEVICE_DRIVER_ERROR_7       = $0201F;
  PMERR_DEVICE_DRIVER_ERROR_8       = $02020;
  PMERR_DEVICE_DRIVER_ERROR_9       = $02021;
  PMERR_DEVICE_DRIVER_ERROR_10      = $02022;
  PMERR_DEV_FUNC_NOT_INSTALLED      = $02023;
  PMERR_DOSOPEN_FAILURE             = $02024;
  PMERR_DOSREAD_FAILURE             = $02025;
  PMERR_DRIVER_NOT_FOUND            = $02026;
  PMERR_DUP_SEG                     = $02027;
  PMERR_DYNAMIC_SEG_SEQ_ERROR       = $02028;
  PMERR_DYNAMIC_SEG_ZERO_INV        = $02029;
  PMERR_ELEMENT_INCOMPLETE          = $0202A;
  PMERR_ESC_CODE_NOT_SUPPORTED      = $0202B;
  PMERR_EXCEEDS_MAX_SEG_LENGTH      = $0202C;
  PMERR_FONT_AND_MODE_MISMATCH      = $0202D;
  PMERR_FONT_FILE_NOT_LOADED        = $0202E;
  PMERR_FONT_NOT_LOADED             = $0202F;
  PMERR_FONT_TOO_BIG                = $02030;
  PMERR_HARDWARE_INIT_FAILURE       = $02031;
  PMERR_HBITMAP_BUSY                = $02032;
  PMERR_HDC_BUSY                    = $02033;
  PMERR_HRGN_BUSY                   = $02034;
  PMERR_HUGE_FONTS_NOT_SUPPORTED    = $02035;
  PMERR_ID_HAS_NO_BITMAP            = $02036;
  PMERR_IMAGE_INCOMPLETE            = $02037;
  PMERR_INCOMPAT_COLOR_FORMAT       = $02038;
  PMERR_INCOMPAT_COLOR_OPTIONS      = $02039;
  PMERR_INCOMPATIBLE_BITMAP         = $0203A;
  PMERR_INCOMPATIBLE_METAFILE       = $0203B;
  PMERR_INCORRECT_DC_TYPE           = $0203C;
  PMERR_INSUFFICIENT_DISK_SPACE     = $0203D;
  PMERR_INSUFFICIENT_MEMORY         = $0203E;
  PMERR_INV_ANGLE_PARM              = $0203F;
  PMERR_INV_ARC_CONTROL             = $02040;
  PMERR_INV_AREA_CONTROL            = $02041;
  PMERR_INV_ARC_POINTS              = $02042;
  PMERR_INV_ATTR_MODE               = $02043;
  PMERR_INV_BACKGROUND_COL_ATTR     = $02044;
  PMERR_INV_BACKGROUND_MIX_ATTR     = $02045;
  PMERR_INV_BITBLT_MIX              = $02046;
  PMERR_INV_BITBLT_STYLE            = $02047;
  PMERR_INV_BITMAP_DIMENSION        = $02048;
  PMERR_INV_BOX_CONTROL             = $02049;
  PMERR_INV_BOX_ROUNDING_PARM       = $0204A;
  PMERR_INV_CHAR_ANGLE_ATTR         = $0204B;
  PMERR_INV_CHAR_DIRECTION_ATTR     = $0204C;
  PMERR_INV_CHAR_MODE_ATTR          = $0204D;
  PMERR_INV_CHAR_POS_OPTIONS        = $0204E;
  PMERR_INV_CHAR_SET_ATTR           = $0204F;
  PMERR_INV_CHAR_SHEAR_ATTR         = $02050;
  PMERR_INV_CLIP_PATH_OPTIONS       = $02051;
  PMERR_INV_CODEPAGE                = $02052;
  PMERR_INV_COLOR_ATTR              = $02053;
  PMERR_INV_COLOR_DATA              = $02054;
  PMERR_INV_COLOR_FORMAT            = $02055;
  PMERR_INV_COLOR_INDEX             = $02056;
  PMERR_INV_COLOR_OPTIONS           = $02057;
  PMERR_INV_COLOR_START_INDEX       = $02058;
  PMERR_INV_COORD_OFFSET            = $02059;
  PMERR_INV_COORD_SPACE             = $0205A;
  PMERR_INV_COORDINATE              = $0205B;
  PMERR_INV_CORRELATE_DEPTH         = $0205C;
  PMERR_INV_CORRELATE_TYPE          = $0205D;
  PMERR_INV_CURSOR_BITMAP           = $0205E;
  PMERR_INV_DC_DATA                 = $0205F;
  PMERR_INV_DC_TYPE                 = $02060;
  PMERR_INV_DEVICE_NAME             = $02061;
  PMERR_INV_DEV_MODES_OPTIONS       = $02062;
  PMERR_INV_DRAW_CONTROL            = $02063;
  PMERR_INV_DRAW_VALUE              = $02064;
  PMERR_INV_DRAWING_MODE            = $02065;
  PMERR_INV_DRIVER_DATA             = $02066;
  PMERR_INV_DRIVER_NAME             = $02067;
  PMERR_INV_DRAW_BORDER_OPTION      = $02068;
  PMERR_INV_EDIT_MODE               = $02069;
  PMERR_INV_ELEMENT_OFFSET          = $0206A;
  PMERR_INV_ELEMENT_POINTER         = $0206B;
  PMERR_INV_END_PATH_OPTIONS        = $0206C;
  PMERR_INV_ESC_CODE                = $0206D;
  PMERR_INV_ESCAPE_DATA             = $0206E;
  PMERR_INV_EXTENDED_LCID           = $0206F;
  PMERR_INV_FILL_PATH_OPTIONS       = $02070;
  PMERR_INV_FIRST_CHAR              = $02071;
  PMERR_INV_FONT_ATTRS              = $02072;
  PMERR_INV_FONT_FILE_DATA          = $02073;
  PMERR_INV_FOR_THIS_DC_TYPE        = $02074;
  PMERR_INV_FORMAT_CONTROL          = $02075;
  PMERR_INV_FORMS_CODE              = $02076;
  PMERR_INV_FONTDEF                 = $02077;
  PMERR_INV_GEOM_LINE_WIDTH_ATTR    = $02078;
  PMERR_INV_GETDATA_CONTROL         = $02079;
  PMERR_INV_GRAPHICS_FIELD          = $0207A;
  PMERR_INV_HBITMAP                 = $0207B;
  PMERR_INV_HDC                     = $0207C;
  PMERR_INV_HJOURNAL                = $0207D;
  PMERR_INV_HMF                     = $0207E;
  PMERR_INV_HPS                     = $0207F;
  PMERR_INV_HRGN                    = $02080;
  PMERR_INV_ID                      = $02081;
  PMERR_INV_IMAGE_DATA_LENGTH       = $02082;
  PMERR_INV_IMAGE_DIMENSION         = $02083;
  PMERR_INV_IMAGE_FORMAT            = $02084;
  PMERR_INV_IN_AREA                 = $02085;
  PMERR_INV_IN_CALLED_SEG           = $02086;
  PMERR_INV_IN_CURRENT_EDIT_MODE    = $02087;
  PMERR_INV_IN_DRAW_MODE            = $02088;
  PMERR_INV_IN_ELEMENT              = $02089;
  PMERR_INV_IN_IMAGE                = $0208A;
  PMERR_INV_IN_PATH                 = $0208B;
  PMERR_INV_IN_RETAIN_MODE          = $0208C;
  PMERR_INV_IN_SEG                  = $0208D;
  PMERR_INV_IN_VECTOR_SYMBOL        = $0208E;
  PMERR_INV_INFO_TABLE              = $0208F;
  PMERR_INV_JOURNAL_OPTION          = $02090;
  PMERR_INV_KERNING_FLAGS           = $02091;
  PMERR_INV_LENGTH_OR_COUNT         = $02092;
  PMERR_INV_LINE_END_ATTR           = $02093;
  PMERR_INV_LINE_JOIN_ATTR          = $02094;
  PMERR_INV_LINE_TYPE_ATTR          = $02095;
  PMERR_INV_LINE_WIDTH_ATTR         = $02096;
  PMERR_INV_LOGICAL_ADDRESS         = $02097;
  PMERR_INV_MARKER_BOX_ATTR         = $02098;
  PMERR_INV_MARKER_SET_ATTR         = $02099;
  PMERR_INV_MARKER_SYMBOL_ATTR      = $0209A;
  PMERR_INV_MATRIX_ELEMENT          = $0209B;
  PMERR_INV_MAX_HITS                = $0209C;
  PMERR_INV_METAFILE                = $0209D;
  PMERR_INV_METAFILE_LENGTH         = $0209E;
  PMERR_INV_METAFILE_OFFSET         = $0209F;
  PMERR_INV_MICROPS_DRAW_CONTROL    = $020A0;
  PMERR_INV_MICROPS_FUNCTION        = $020A1;
  PMERR_INV_MICROPS_ORDER           = $020A2;
  PMERR_INV_MIX_ATTR                = $020A3;
  PMERR_INV_MODE_FOR_OPEN_DYN       = $020A4;
  PMERR_INV_MODE_FOR_REOPEN_SEG     = $020A5;
  PMERR_INV_MODIFY_PATH_MODE        = $020A6;
  PMERR_INV_MULTIPLIER              = $020A7;
  PMERR_INV_NESTED_FIGURES          = $020A8;
  PMERR_INV_OR_INCOMPAT_OPTIONS     = $020A9;
  PMERR_INV_ORDER_LENGTH            = $020AA;
  PMERR_INV_ORDERING_PARM           = $020AB;
  PMERR_INV_OUTSIDE_DRAW_MODE       = $020AC;
  PMERR_INV_PAGE_VIEWPORT           = $020AD;
  PMERR_INV_PATH_ID                 = $020AE;
  PMERR_INV_PATH_MODE               = $020AF;
  PMERR_INV_PATTERN_ATTR            = $020B0;
  PMERR_INV_PATTERN_REF_PT_ATTR     = $020B1;
  PMERR_INV_PATTERN_SET_ATTR        = $020B2;
  PMERR_INV_PATTERN_SET_FONT        = $020B3;
  PMERR_INV_PICK_APERTURE_OPTION    = $020B4;
  PMERR_INV_PICK_APERTURE_POSN      = $020B5;
  PMERR_INV_PICK_APERTURE_SIZE      = $020B6;
  PMERR_INV_PICK_NUMBER             = $020B7;
  PMERR_INV_PLAY_METAFILE_OPTION    = $020B8;
  PMERR_INV_PRIMITIVE_TYPE          = $020B9;
  PMERR_INV_PS_SIZE                 = $020BA;
  PMERR_INV_PUTDATA_FORMAT          = $020BB;
  PMERR_INV_QUERY_ELEMENT_NO        = $020BC;
  PMERR_INV_RECT                    = $020BD;
  PMERR_INV_REGION_CONTROL          = $020BE;
  PMERR_INV_REGION_MIX_MODE         = $020BF;
  PMERR_INV_REPLACE_MODE_FUNC       = $020C0;
  PMERR_INV_RESERVED_FIELD          = $020C1;
  PMERR_INV_RESET_OPTIONS           = $020C2;
  PMERR_INV_RGBCOLOR                = $020C3;
  PMERR_INV_SCAN_START              = $020C4;
  PMERR_INV_SEG_ATTR                = $020C5;
  PMERR_INV_SEG_ATTR_VALUE          = $020C6;
  PMERR_INV_SEG_CH_LENGTH           = $020C7;
  PMERR_INV_SEG_NAME                = $020C8;
  PMERR_INV_SEG_OFFSET              = $020C9;
  PMERR_INV_SETID                   = $020CA;
  PMERR_INV_SETID_TYPE              = $020CB;
  PMERR_INV_SET_VIEWPORT_OPTION     = $020CC;
  PMERR_INV_SHARPNESS_PARM          = $020CD;
  PMERR_INV_SOURCE_OFFSET           = $020CE;
  PMERR_INV_STOP_DRAW_VALUE         = $020CF;
  PMERR_INV_TRANSFORM_TYPE          = $020D0;
  PMERR_INV_USAGE_PARM              = $020D1;
  PMERR_INV_VIEWING_LIMITS          = $020D2;
  PMERR_JFILE_BUSY                  = $020D3;
  PMERR_JNL_FUNC_DATA_TOO_LONG      = $020D4;
  PMERR_KERNING_NOT_SUPPORTED       = $020D5;
  PMERR_LABEL_NOT_FOUND             = $020D6;
  PMERR_MATRIX_OVERFLOW             = $020D7;
  PMERR_METAFILE_INTERNAL_ERROR     = $020D8;
  PMERR_METAFILE_IN_USE             = $020D9;
  PMERR_METAFILE_LIMIT_EXCEEDED     = $020DA;
  PMERR_NAME_STACK_FULL             = $020DB;
  PMERR_NOT_CREATED_BY_DEVOPENDC    = $020DC;
  PMERR_NOT_IN_AREA                 = $020DD;
  PMERR_NOT_IN_DRAW_MODE            = $020DE;
  PMERR_NOT_IN_ELEMENT              = $020DF;
  PMERR_NOT_IN_IMAGE                = $020E0;
  PMERR_NOT_IN_PATH                 = $020E1;
  PMERR_NOT_IN_RETAIN_MODE          = $020E2;
  PMERR_NOT_IN_SEG                  = $020E3;
  PMERR_NO_BITMAP_SELECTED          = $020E4;
  PMERR_NO_CURRENT_ELEMENT          = $020E5;
  PMERR_NO_CURRENT_SEG              = $020E6;
  PMERR_NO_METAFILE_RECORD_HANDLE   = $020E7;
  PMERR_ORDER_TOO_BIG               = $020E8;
  PMERR_OTHER_SET_ID_REFS           = $020E9;
  PMERR_OVERRAN_SEG                 = $020EA;
  PMERR_OWN_SET_ID_REFS             = $020EB;
  PMERR_PATH_INCOMPLETE             = $020EC;
  PMERR_PATH_LIMIT_EXCEEDED         = $020ED;
  PMERR_PATH_UNKNOWN                = $020EE;
  PMERR_PEL_IS_CLIPPED              = $020EF;
  PMERR_PEL_NOT_AVAILABLE           = $020F0;
  PMERR_PRIMITIVE_STACK_EMPTY       = $020F1;
  PMERR_PROLOG_ERROR                = $020F2;
  PMERR_PROLOG_SEG_ATTR_NOT_SET     = $020F3;
  PMERR_PS_BUSY                     = $020F4;
  PMERR_PS_IS_ASSOCIATED            = $020F5;
  PMERR_RAM_JNL_FILE_TOO_SMALL      = $020F6;
  PMERR_REALIZE_NOT_SUPPORTED       = $020F7;
  PMERR_REGION_IS_CLIP_REGION       = $020F8;
  PMERR_RESOURCE_DEPLETION          = $020F9;
  PMERR_SEG_AND_REFSEG_ARE_SAME     = $020FA;
  PMERR_SEG_CALL_RECURSIVE          = $020FB;
  PMERR_SEG_CALL_STACK_EMPTY        = $020FC;
  PMERR_SEG_CALL_STACK_FULL         = $020FD;
  PMERR_SEG_IS_CURRENT              = $020FE;
  PMERR_SEG_NOT_CHAINED             = $020FF;
  PMERR_SEG_NOT_FOUND               = $02100;
  PMERR_SEG_STORE_LIMIT_EXCEEDED    = $02101;
  PMERR_SETID_IN_USE                = $02102;
  PMERR_SETID_NOT_FOUND             = $02103;
  PMERR_STARTDOC_NOT_ISSUED         = $02104;
  PMERR_STOP_DRAW_OCCURRED          = $02105;
  PMERR_TOO_MANY_METAFILES_IN_USE   = $02106;
  PMERR_TRUNCATED_ORDER             = $02107;
  PMERR_UNCHAINED_SEG_ZERO_INV      = $02108;
  PMERR_UNSUPPORTED_ATTR            = $02109;
  PMERR_UNSUPPORTED_ATTR_VALUE      = $0210A;

(* General DEV return values *)
CONST
  DEV_ERROR = 0;
  DEV_OK    = 1;

(* pointer data for DevOpenDC *)
TYPE
  PDEVOPENDATA = ^pChar;

(* DC type for DevOpenDC *)
CONST
  OD_QUEUED =               2;
  OD_DIRECT =               5;
  OD_INFO =                 6;
  OD_METAFILE =             7;
  OD_MEMORY =               8;
  OD_METAFILE_NOQUERY  = 9;

(* codes for DevQueryCaps *)
  CAPS_FAMILY =                      0;
  CAPS_IO_CAPS =                     1;
  CAPS_TECHNOLOGY =                  2;
  CAPS_DRIVER_VERSION =              3;
  CAPS_WIDTH =                       4;      (* pels            *)
  CAPS_HEIGHT =                      5;      (* pels            *)
  CAPS_WIDTH_IN_CHARS =              6;
  CAPS_HEIGHT_IN_CHARS =             7;
  CAPS_HORIZONTAL_RESOLUTION =       8;      (* pels per meter  *)
  CAPS_VERTICAL_RESOLUTION =         9;      (* pels per meter  *)
  CAPS_CHAR_WIDTH =                 10;      (* pels            *)
  CAPS_CHAR_HEIGHT =                11;      (* pels            *)
  CAPS_SMALL_CHAR_WIDTH =           12;      (* pels            *)
  CAPS_SMALL_CHAR_HEIGHT =          13;      (* pels            *)
  CAPS_COLORS =                     14;
  CAPS_COLOR_PLANES =               15;
  CAPS_COLOR_BITCOUNT =             16;
  CAPS_COLOR_TABLE_SUPPORT =        17;
  CAPS_MOUSE_BUTTONS =              18;
  CAPS_FOREGROUND_MIX_SUPPORT =     19;
  CAPS_BACKGROUND_MIX_SUPPORT =     20;
  CAPS_DEVICE_WINDOWING =           31;
  CAPS_ADDITIONAL_GRAPHICS =        32;
  CAPS_VIO_LOADABLE_FONTS =         21;
  CAPS_WINDOW_BYTE_ALIGNMENT =      22;
  CAPS_BITMAP_FORMATS =             23;
  CAPS_RASTER_CAPS =                24;
  CAPS_MARKER_HEIGHT =              25;      (* pels            *)
  CAPS_MARKER_WIDTH =               26;      (* pels            *)
  CAPS_DEVICE_FONTS =               27;
  CAPS_GRAPHICS_SUBSET =            28;
  CAPS_GRAPHICS_VERSION =           29;
  CAPS_GRAPHICS_VECTOR_SUBSET =     30;
  CAPS_PHYS_COLORS =                33;
  CAPS_COLOR_INDEX =                34;
  CAPS_GRAPHICS_CHAR_WIDTH =        35;
  CAPS_GRAPHICS_CHAR_HEIGHT =       36;
  CAPS_HORIZONTAL_FONT_RES =        37;
  CAPS_VERTICAL_FONT_RES =          38;
  CAPS_DEVICE_FONT_SIM =    39;

(* Constants for CAPS_IO_CAPS *)
  CAPS_IO_DUMMY =                   1;
  CAPS_IO_SUPPORTS_OP =             2;
  CAPS_IO_SUPPORTS_IP =             3;
  CAPS_IO_SUPPORTS_IO =             4;

(* Constants for CAPS_TECHNOLOGY *)
  CAPS_TECH_UNKNOWN =               0;
  CAPS_TECH_VECTOR_PLOTTER =        1;
  CAPS_TECH_RASTER_DISPLAY =        2;
  CAPS_TECH_RASTER_PRINTER =        3;
  CAPS_TECH_RASTER_CAMERA =         4;
  CAPS_TECH_POSTSCRIPT =            5;

(* Constants for CAPS_COLOR_TABLE_SUPPORT *)
  CAPS_COLTABL_RGB_8 =              1;
  CAPS_COLTABL_RGB_8_PLUS =         2;
  CAPS_COLTABL_TRUE_MIX =           4;
  CAPS_COLTABL_REALIZE =            8;

(* Constants for CAPS_FOREGROUND_MIX_SUPPORT *)
  CAPS_FM_OR =                      1;
  CAPS_FM_OVERPAINT =               2;
  CAPS_FM_XOR =                     8;
  CAPS_FM_LEAVEALONE =             16;
  CAPS_FM_AND =                    32;
  CAPS_FM_GENERAL_BOOLEANEAN =        64;

(* Constants for CAPS_BACKGROUND_MIX_SUPPORT *)
  CAPS_BM_OR =                      1;
  CAPS_BM_OVERPAINT =               2;
  CAPS_BM_XOR =                     8;
  CAPS_BM_LEAVEALONE =             16;

(* Constants for CAPS_DEVICE_WINDOWING *)
  CAPS_DEV_WINDOWING_SUPPORT =      1;

(* Constants for CAPS_ADDITIONAL_GRAPHICS *)
  CAPS_GRAPHICS_KERNING_SUPPORT =   2;
  CAPS_FONT_OUTLINE_DEFAULT =       4;
  CAPS_FONT_IMAGE_DEFAULT =         8;
  CAPS_SCALED_DEFAULT_MARKERS =    16;

(* Constants for CAPS_WINDOW_BYTE_ALIGNMENT *)
  CAPS_BYTE_ALIGN_REQUIRED =       0;
  CAPS_BYTE_ALIGN_RECOMMENDED =    1;
  CAPS_BYTE_ALIGN_NOT_REQUIRED =   2;

(* Constants for CAPS_RASTER_CAPS *)
  CAPS_RASTER_BITBLT =              1;
  CAPS_RASTER_BANDING =             2;
  CAPS_RASTER_BITBLT_SCALING =      4;
  CAPS_RASTER_SET_PEL =            16;
  CAPS_RASTER_FONTS =              32;

  FUNCTION DevOpenDC(    ahab : HAB;
                          c1   : LongInt;
                          P    : pChar;
                          c2   : LongInt;
                      VAR pDev : pChar (*??? PDEVOPENDATA *);
                          hDC  : hDC) : hDC;
  FUNCTION Dev16OpenDC(    ahab : HAB;
                           c1   : LongInt;
                           P    : pChar;
                           c2   : LongInt;
                       VAR pDev : pChar (*??? PDEVOPENDATA *);
                           hDC  : hDC) : hDC;

  FUNCTION DevCloseDC(ahdc : hDC) : hMF;
  FUNCTION Dev16CloseDC(ahdc : hDC) : hMF;

  FUNCTION DevQueryCaps(    ahdc   : hDC;
                             c1, c2 : LongInt;
                         VAR c3     : { LONG } LongInt) : BOOLEAN;
  FUNCTION Dev16QueryCaps(    ahdc   : hDC;
                             c1, c2 : LongInt;
                         VAR c3     : { LONG } LongInt) : BOOLEAN;

TYPE
  VioSizeCount = RECORD
    MaxCount : LongInt;
    count    : LongInt;
  END;

  VioFontCellSize = RECORD
    cx : LongInt;
    cy : LongInt;
  END;

  EscGetCp = RECORD
    Options  : LongInt;  (* LONGCARD *)
    codepage : WORD;
    fontid   : WORD;
  END;

(* return codes for DevEscape *)
CONST
  DEVESC_ERROR             = -1;
  DEVESC_NOTIMPLEMENTED    =  0;

(* codes for DevEscape *)
  DEVESC_QUERYESCSUPPORT   = 0;
  DEVESC_GETSCALINGFACTOR  = 1;
  DEVESC_QUERYVIOCELLSIZES = 2;
  DEVESC_GETCP             = $8000;

  DEVESC_STARTDOC          =  8150;
  DEVESC_ENDDOC            =  8151;
  DEVESC_NEXTBAND          =  8152;
  DEVESC_ABORTDOC          =  8153;
  DEVESC_NEWFRAME          = 16300;
  DEVESC_DRAFTMODE         = 16301;
  DEVESC_FLUSHOUTPUT       = 16302;
  DEVESC_RAWDATA           = 16303;

  DEVESC_DBE_FIRST         = $24450;
  DEVESC_DBE_LAST          = $24455;
  DEVESC_CHAR_EXTRA        = $16998;
  DEVESC_BREAK_EXTRA       = $16999;

(* codes for DevEscape PM_Q_ESC spool files *)
  DEVESC_STD_JOURNAL       =  32600;

(* return codes for DevPostDeviceModes *)
  DPDM_ERROR               = -1;
  DPDM_NONE                = 0;

  DPDM_POSTJOBPROP         = 0;
  DPDM_CHANGEPROP          = 1;
  DPDM_QUERYJOBPROP        = 2;

(* string types for DevQueryDeviceNames *)
TYPE
  Str16  = ARRAY [0..15] OF CHAR;   (* str16 *)
  pSTR16 = ^Str16;
  Str32  = ARRAY [0..31] OF CHAR;   (* str32 *)
  pSTR32 = ^Str32;
  Str64  = ARRAY [0..63] OF CHAR;   (* str64 *)
  pSTR64 = ^Str64;

(* return code for DevQueryHardcopyCaps *)
CONST
  DQHC_ERROR               = -1;

(* codes for DevQueryHardcopyCaps *)
  HCAPS_CURRENT            = 1;
  HCAPS_SELECTABLE         = 2;

(* structure for DevQueryHardcopyCaps *)
TYPE
  HcInfo = RECORD
    szFormname   : ARRAY [0..31] OF CHAR;
    cx           : LongInt;
    cy           : LongInt;
    xLeftClip    : LongInt;
    yBottomClip  : LongInt;
    xRightClip   : LongInt;
    yTopClip     : LongInt;
    xPels        : LongInt;
    yPels        : LongInt;
    flAttributes : LongInt;
  END;

  pHCInfo = ^HcInfo;

(*** Device Context Functions *)
  FUNCTION DevEscape(    ahdc   : hDC;
                          l1, l2 : LongInt;
                          p1     : pBYTE;
                      VAR p2     : { LONG } LongInt;
                          p3     : pBYTE) : LongInt;
  FUNCTION Dev16Escape(   ahdc   : hDC;
                          l1, l2 : LongInt;
                          p1     : pBYTE;
                      VAR p2     : { LONG } LongInt;
                          p3     : pBYTE) : LongInt;

  FUNCTION DevQueryDeviceNames(    ahab  : HAB;
                                    p1    : pChar;
                                VAR p2    : { LONG } LongInt;
                                VAR p3    : { LONG } Str32;
                                VAR p4    : { LONG } Str64;
                                VAR p5    : { LONG } LongInt;
                                VAR Str16 : { LONG } Str16) : BOOLEAN;
  FUNCTION Dev16QueryDeviceNames(    ahab  : HAB;
                                      p1    : pChar;
                                  VAR p2    : { LONG } LongInt;
                                  VAR p3    : { LONG } Str32;
                                  VAR p4    : { LONG } Str64;
                                  VAR p5    : { LONG } LongInt;
                                  VAR Str16 : { LONG } Str16) : BOOLEAN;

  FUNCTION DevQueryHardcopyCaps(      ahdc    : hDC;
                                      l1, l2  : LongInt;
                                  VAR pHCInfo : { LONG } HcInfo) : LongInt;
  FUNCTION Dev16QueryHardcopyCaps(    ahdc    : hDC;
                                      l1, l2  : LongInt;
                                  VAR pHCInfo : { LONG } HcInfo) : LongInt;


  FUNCTION DevPostDeviceModes(    HAB        : HAB;
                              VAR DrivData   : { LONG } DrivData;
                                  p2, p3, p4 : pChar;
                                  i          : LongInt) : LongInt;
  FUNCTION Dev16PostDeviceModes(    HAB        : HAB;
                                VAR DrivData   : { LONG } DrivData;
                                    p2, p3, p4 : pChar;
                                    i          : LongInt) : LongInt;

TYPE
  BitmapFileHeader = RECORD  (* bfh *)
    usType   : WORD;
    cbSize   : LongInt;
    xHotspot : INTEGER;
    yHotspot : INTEGER;
    offBits  : LongInt;
    bmp      : BitmapInfoHeader;
  END;

  pBitMapFileHeader = ^BitmapFileHeader;

  BitmapArrayFileHeader = RECORD
    usType      : WORD;
    cbSize      : LongInt;
    offNext     : LongInt;
    cxDisplay   : WORD;
    cyDisplay   : WORD;
    bfh         : BitmapFileHeader;
  END;

  pBitmapArrayFileHeader = ^BitmapArrayFileHeader;

(*
 * These are the identifying values that go in the wType field of the
 * BITMAPFILEHEADER.  (BFT_ => Bitmap File Type)
 *)

CONST
  BFT_ICON         = $04349;   (* 'IC' *)
  BFT_BMAP         = $04D42;   (* 'BM' *)
  BFT_POINTER      = $05450;   (* 'PT' *)
  BFT_COLORICON    = $04943;
  BFT_COLORPOINTER = $05043;
  BFT_BITMAPARRAY  = $04142;

(* Font-Definitions *)

TYPE
   FocaMetrics = RECORD
     ulIdentity         : LongInt;
     ulSize             : LongInt;
     szFamilyname       : ARRAY [0..31] OF CHAR;
     szFacename         : ARRAY [0..31] OF CHAR;
     usRegistryId       : INTEGER;
     usCodePage         : INTEGER;
     yEmHeight          : INTEGER;
     yXHeight           : INTEGER;
     yMaxAscender       : INTEGER;
     yMaxDescender      : INTEGER;
     yLowerCaseAscent   : INTEGER;
     yLowerCaseDescent  : INTEGER;
     yInternalLeading   : INTEGER;
     yExternalLeading   : INTEGER;
     xAveCharWidth      : INTEGER;
     xMaxCharInc        : INTEGER;
     xEmInc             : INTEGER;
     yMaxBaselineExt    : INTEGER;
     sCharSlope         : INTEGER;
     sInlineDir         : INTEGER;
     sCharRot           : INTEGER;
     usWeightClass      : WORD;
     usWidthClass       : WORD;
     xDeviceRes         : INTEGER;
     yDeviceRes         : INTEGER;
     usFirstChar        : INTEGER;
     usLastChar         : INTEGER;
     usDefaultChar      : INTEGER;
     usBreakChar        : INTEGER;
     usNominalPointSize : INTEGER;
     usMinimumPointSize : INTEGER;
     usMaximumPointSize : INTEGER;
     fsTypeFlags        : INTEGER;
     fsDefn             : INTEGER;
     fsSelectionFlags   : INTEGER;
     fsCapabilities     : INTEGER;
     ySubscriptXSize    : INTEGER;
     ySubscriptYSize    : INTEGER;
     ySubscriptXOffset  : INTEGER;
     ySubscriptYOffset  : INTEGER;
     ySuperscriptXSize  : INTEGER;
     ySuperscriptYSize  : INTEGER;
     ySuperscriptXOffset: INTEGER;
     ySuperscriptYOffset: INTEGER;
     yUnderscoreSize    : INTEGER;
     yUnderscorePosition: INTEGER;
     yStrikeoutSize     : INTEGER;
     yStrikeoutPosition : INTEGER;
     usKerningPairs     : INTEGER;
     usKerningTracks    : INTEGER;
     pszDeviceNameOffset: pChar;
   END;
   pFocaMetrics = ^FocaMetrics;

   FontDefinitionHeader = RECORD  (* fdh *)
     ulIdentity       : LongInt;
     ulSize           : LongInt;
     fsFontdef        : INTEGER;
     fsChardef        : INTEGER;
     usCellSize       : INTEGER;
     xCellWidth       : INTEGER;
     yCellHeight      : INTEGER;
     xCellIncrement   : INTEGER;
     xCellA           : INTEGER;
     xCellB           : INTEGER;
     xCellC           : INTEGER;
     pCellBaseOffset  : INTEGER;
   END;
   pFontDefinitionHeader = ^FontDefinitionHeader;

CONST
  FONTDEFFONT1 = $00047; (* set width, height, inc. & base offset *)
  FONTDEFFONT2 = $00042; (* set height & base offset              *)
  FONTDEFFONT3 = $00042; (* set height & base offset              *)
  FONTDEFCHAR1 = $00081; (* set char offset and width             *)
  FONTDEFCHAR2 = $00081; (* set char offset and width             *)
  FONTDEFCHAR3 = $000B8; (* set char offset, A, B, and C space    *)
  SPACE_UNDEF  = $08000; (* space undefined = take default        *)

TYPE
  FontSignature = RECORD
    ulIdentity    :   LongInt;
    ulSize        :   LongInt;
    achSignature  : ARRAY [0..11] OF CHAR;
  END;
  pFontSignature = ^FontSignature;

  FocaFont = RECORD  (* ff *)
    fsSignature   : FontSignature;
    fmMetrics     : FocaMetrics;
    fdDefinitions : FontDefinitionHeader;
  END;
  pFocaFont = ^FocaFont;

CONST
  FONT_SIGNATURE  =  $0FFFFFFFE; (* Identity header start *)
  FONT_METRICS    =  $000000001; (* Identity metrics *)
  FONT_DEFINITION =  $000000002; (* Identity definition *)
  FONT_ENDRECORD  =  $0FFFFFFFF; (* Identity record end *)

(* Options for QueryFonts *)

CONST
  QUERY_PUBLIC_FONTS  = $00001;
  QUERY_PRIVATE_FONTS = $00002;

  CDEF_GENERIC        = $00001;
  CDEF_BOLD           = $00002;
  CDEF_ITALIC         = $00004;
  CDEF_UNDERSCORE     = $00008;
  CDEF_STRIKEOUT      = $00010;
  CDEF_OUTLINE        = $20;

IMPLEMENTATION

  FUNCTION MakeFixed (IntPart: INTEGER; FractPart: WORD) : Fixed;
  BEGIN
    MakeFixed := LongInt(IntPart SHL 16) + FractPart;
{   MakeFixed := Os2Def.MakeLong(IntPart, fractpart); }
  END;

  FUNCTION FixedFrac(fx: Fixed): WORD;
  BEGIN
    FixedFrac := HiWord(fx);
  END;

  FUNCTION FixedInt(fx: Fixed): INTEGER;
  BEGIN
    FixedInt := LoWord(fx);
  END;

  FUNCTION GpiBeginPath(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 234;

  FUNCTION GpiEndPath(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 235;

  FUNCTION GpiCloseFigure(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 236;

  FUNCTION GpiModifyPath(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 237;

  FUNCTION GpiFillPath(ahps : hPs; l1, l2 : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 238;

  FUNCTION GpiSetClipPath(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 233;

  FUNCTION GpiOutlinePath(ahps : hPs; l1, l2 : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 274;

  FUNCTION GpiStrokePath(ahps : hPs; l1 : LongInt; c : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 270;

  FUNCTION  GpiCreatePS(    ahab       : HAB;
                            ahdc       : hDC;
                        VAR pSizeLSize : { LONG } SizeL;
                            u1         : LongInt) : hPs;
    EXTERNAL 'PMGPI' INDEX 7;

  FUNCTION GpiDestroyPS(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 10;

  FUNCTION GpiAssociate(ahps : hPs; ahdc : hDC) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 14;

  FUNCTION GpiRestorePS(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 13;

  FUNCTION GpiSavePS(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 12;

  FUNCTION GpiErase(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 16;

  FUNCTION GpiQueryDevice(ahps : hPs) : hDC;
    EXTERNAL 'PMGPI' INDEX 240;

  FUNCTION GpiResetPS(ahps : hPs; u : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 11;

  FUNCTION GpiSetPS(    ahps : hPs;
                    VAR P    : { LONG } SizeL;
                        u    : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 248;

  FUNCTION GpiQueryPS(    ahps : hPs;
                      VAR P    : { LONG } SizeL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 9;

  FUNCTION GpiErrorSegmentData(    ahps : hPs;
                               VAR l    : { LONG } LongInt;
                               VAR l2   : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 15;

  FUNCTION GpiQueryDrawControl(ahps : hPs; l : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 18;

  FUNCTION GpiSetDrawControl(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 17;

  FUNCTION GpiQueryDrawingMode(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 27;

  FUNCTION GpiSetDrawingMode(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 26;

  FUNCTION GpiQueryStopDraw(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 22;

  FUNCTION GpiSetStopDraw(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 22;

  FUNCTION GpiCorrelateChain(    ahps   : hPs;
                                 l1     : LongInt;
                                 PointL : { LONG } PointL;
                                 l2     : LongInt;
                                 l6     : LongInt;
                             VAR l7     : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 36;

  FUNCTION GpiQueryTag(ahps : hPs; VAR l2 : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 35;

  FUNCTION GpiSetTag(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 34;

  FUNCTION GpiQueryPickApertureSize(    ahps : hPs;
                                    VAR P    : { LONG } SizeL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 31;

  FUNCTION GpiSetPickApertureSize(hPs   : hPs;
                                  l1    : LongInt;
                                  SizeL : { LONG } SizeL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 30;

  FUNCTION GpiQueryPickAperturePosition(    ahps    : hPs;
                                        VAR aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 33;

  FUNCTION GpiSetPickAperturePosition(ahps    : hPs;
                                      aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 32;

  FUNCTION GpiQueryBoundaryData(    ahps   : hPs;
                                VAR aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 43;

  FUNCTION GpiResetBoundaryData(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 42;

  FUNCTION GpiCorrelateFrom(    ahps, l2 : LongInt;
                                l3, l4   : LongInt;
                                aPointL  : { LONG } PointL;
                                l5, l6   : LongInt;
                            VAR l7       : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 37;

  FUNCTION GpiCorrelateSegment(   ahps    : hPs;
                                  l1, l3  : LongInt;
                                  aPointL : { LONG } PointL;
                                  l2, l6  : LongInt;
                              VAR l7      : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 38;

  FUNCTION GpiOpenSegment(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 44;

  FUNCTION GpiCloseSegment(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 46;

  FUNCTION GpiDeleteSegment(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 47;

  FUNCTION GpiQueryInitialSegmentAttrs(ahps : hPs; l : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 52;

  FUNCTION GpiSetInitialSegmentAttrs(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 51;

  FUNCTION GpiQuerySegmentAttrs(ahps : hPs; l1, l2 : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 54;

  FUNCTION GpiSetSegmentAttrs(ahps       : hPs;
                              l1, l6, l8 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 53;

  FUNCTION GpiQuerySegmentPriority(ahps   : hPs;
                                   l1, l2 : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 56;

  FUNCTION GpiSetSegmentPriority(ahps       : hPs;
                                 l1, l6, l8 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 55;

  FUNCTION GpiDeleteSegments(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 48;

  FUNCTION GpiQuerySegmentNames(    ahps       : hPs;
                                    l1, l6, l2 : LongInt;
                                VAR l7         : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 49;

{*** draw functions for segments *}

  FUNCTION GpiGetData(    ahps   : hPs;
                          l1     : LongInt;
                      VAR l9     : { LONG } LongInt;
                          l2, l6 : LongInt;
                          aByte  : Pointer) : LongInt;
    EXTERNAL 'PMGPI' INDEX 28;

  FUNCTION GpiPutData(    ahps  : hPs;
                          l1    : LongInt;
                      VAR l9    : { LONG } LongInt;
                          aByte : Pointer) : LongInt;
    EXTERNAL 'PMGPI' INDEX 29;

  FUNCTION GpiDrawChain(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 19;

  FUNCTION GpiDrawFrom(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 20;

  FUNCTION GpiDrawSegment(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 21;

  FUNCTION GpiDrawDynamics(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 25;

  FUNCTION GpiRemoveDynamics(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 24;

  FUNCTION GpiBeginElement(ahps : hPs; l1 : LongInt; aPsz : pChar) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 70;

  FUNCTION GpiEndElement(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 71;

  FUNCTION GpiLabel(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 64;

  FUNCTION GpiElement(ahps  : hPs;
                      l1    : LongInt;
                      pSZ   : pChar;
                      l2    : LongInt;
                      aByte : Pointer) : LongInt;
    EXTERNAL 'PMGPI' INDEX 69;

  FUNCTION GpiQueryElement(ahps   : hPs;
                           l1, l6 : LongInt;
                           aByte  : Pointer) : LongInt;
    EXTERNAL 'PMGPI' INDEX 68;

  FUNCTION GpiDeleteElement(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 62;

  FUNCTION GpiDeleteElementRange(ahps : hPs; l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 63;

  FUNCTION GpiDeleteElementsBetweenLabels(ahps   : hPs;
                                          l1, l2 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 66;

  FUNCTION GpiQueryEditMode(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 58;

  FUNCTION GpiSetEditMode(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 57;

  FUNCTION GpiQueryElementPointer(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 60;

  FUNCTION GpiSetElementPointer(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 59;

  FUNCTION GpiOffsetElementPointer(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 61;

  FUNCTION GpiQueryElementType(    ahps : hPs;
                               VAR l    : { LONG } LongInt;
                                   l1   : LongInt;
                                   pSZ  : pChar) : LongInt;
    EXTERNAL 'PMGPI' INDEX 67;

  FUNCTION GpiSetElementPointerAtLabel(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 65;

  FUNCTION GpiQuerySegmentTransformMatrix(    ahps     : hPs;
                                              l1, l6   : LongInt;
                                          VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 79;

  FUNCTION GpiSetSegmentTransformMatrix(    ahps     : hPs;
                                            l1, l6   : LongInt;
                                            MATRIXLF : { LONG } MATRIXLF;
                                        VAR l11      : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 78;

  FUNCTION GpiConvert(    ahps       : hPs;
                          l1, l6, l2 : LongInt;
                      VAR aPointL    : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 93;

  FUNCTION GpiQueryModelTransformMatrix(    ahps     : hPs;
                                            l1       : LongInt;
                                        VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 81;

  FUNCTION GpiSetModelTransformMatrix(    ahps     : hPs;
                                          l1       : LongInt;
                                          MATRIXLF : { LONG } MATRIXLF;
                                      VAR l11      : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 80;

  FUNCTION GpiCallSegmentMatrix(    ahps     : hPs;
                                    l1, l6   : LongInt;
                                    MATRIXLF : { LONG } MATRIXLF;
                                VAR l11      : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 82;

  FUNCTION GpiQueryDefaultViewMatrix(    ahps     : hPs;
                                         l1       : LongInt;
                                     VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 84;

  FUNCTION GpiSetDefaultViewMatrix(    ahps     : hPs;
                                       l1       : LongInt;
                                       MATRIXLF : { LONG } MATRIXLF;
                                   VAR l11      : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 83;

  FUNCTION GpiQueryPageViewport(    hPs    : hPs;
                                VAR aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 86;

  FUNCTION GpiSetPageViewport(ahps : hPs; aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 85;

  FUNCTION GpiQueryViewingTransformMatrix(    ahps     : hPs;
                                              l1       : LongInt;
                                          VAR MATRIXLF : { LONG } MATRIXLF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 88;

  FUNCTION GpiSetViewingTransformMatrix(    ahps     : hPs;
                                            l1       : LongInt;
                                            MATRIXLF : { LONG } MATRIXLF;
                                        VAR l11      : { LONG } LongInt): BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 87;

  FUNCTION GpiTranslate(a : hPs;
                        b : MATRIXLF;
                        c : LongInt;
                        d : PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 283;

  FUNCTION GpiScale(a : hPs;
                    b : MATRIXLF;
                    c : LongInt;
                    d : Fixed;
                    e : PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 284;

  FUNCTION GpiRotate(a : hPs;
                     b : MATRIXLF;
                     c : LongInt;
                     d : Fixed;
                     e : PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 285;

{*** general clipping functions *}

  FUNCTION GpiSetGraphicsField(ahps   : hPs;
                               aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 89;

  FUNCTION GpiQueryGraphicsField(    ahps   : hPs;
                                 VAR aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 90;

  FUNCTION GpiSetViewingLimits(ahps   : hPs;
                               aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 91;

  FUNCTION GpiQueryViewingLimits(    ahps   : hPs;
                                 VAR aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 92;

  FUNCTION GpiCreateLogColorTable(    ahps       : hPs;
                                      c1         : LongInt;
                                      l1, l2, l3 : LongInt;
                                  VAR l7         : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 99;

  FUNCTION GpiRealizeColorTable(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 100;

  FUNCTION GpiUnrealizeColorTable(ahps : hPs) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 101;

  FUNCTION GpiQueryColorData(    ahps : hPs;
                                 l1   : LongInt;
                             VAR l7   : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 102;

  FUNCTION GpiQueryLogColorTable(    ahps   : hPs;
                                     c1     : LongInt;
                                     l1, l2 : LongInt;
                                 VAR l7     : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 103;

  FUNCTION GpiQueryRealColors(    ahps   : hPs;
                                  c1     : LongInt;
                                  l2, l6 : LongInt;
                              VAR l7     : { LONG } LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 104;

  FUNCTION GpiQueryNearestColor(ahps : hPs;
                                c1   : LongInt;
                                i1   : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 105;

  FUNCTION GpiQueryColorIndex(ahps : hPs;
                              c1   : LongInt;
                              l1   : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 106;

  FUNCTION GpiQueryRGBColor(ahps : hPs;
                            c1   : LongInt;
                            l2   : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 107;

  FUNCTION GpiSetColor(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 108;

  FUNCTION GpiQueryColor(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 109;

{*** line primitive functions *}

  FUNCTION GpiBox(hPs     : hPs;
                  l1      : LongInt;
                  aPointL : { LONG } PointL;
                  l2, l8  : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 131;

  FUNCTION GpiMove(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 128;

  FUNCTION GpiLine(hPs : hPs; aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 129;

  FUNCTION GpiPolyLine(ahps   : hPs;
                       l1     : LongInt;
                       PointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 130;

{*** area primitive functions *}

  FUNCTION GpiSetPattern(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 146;

  FUNCTION GpiQueryPattern(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 147;

  FUNCTION GpiBeginArea(ahps : hPs; u : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 150;

  FUNCTION GpiEndArea(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 151;

{*** character primitive functions *}

  FUNCTION GpiCharString;     EXTERNAL 'PMGPI' INDEX 180;

  FUNCTION GpiCharStringAt;   EXTERNAL 'PMGPI' INDEX 181;

  FUNCTION GpiSetAttrMode;    EXTERNAL 'PMGPI' INDEX 94;

  FUNCTION GpiQueryAttrMode;  EXTERNAL 'PMGPI' INDEX 95;

{*** bundle primitive functions *}

  FUNCTION GpiSetAttrs(ahps  : hPs;
                       l1    : LongInt;
                       c1    : LongInt;
                       u     : LongInt;
                       P {?} : pBundle) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 97;

  FUNCTION GpiQueryAttrs(ahps   : hPs;
                         l1, l2 : LongInt;
                         P {?}  : pBundle) : LongInt;
    EXTERNAL 'PMGPI' INDEX 98;

{*** global primitive functions *}

  FUNCTION GpiSetBackColor(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 110;

  FUNCTION GpiQueryBackColor(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 111;

  FUNCTION GpiSetMix(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 112;

  FUNCTION GpiQueryMix(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 113;

  FUNCTION GpiSetBackMix(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 114;

  FUNCTION GpiQueryBackMix(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 115;

{*** line primitive functions *}

  FUNCTION GpiSetLineType(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 116;

  FUNCTION GpiQueryLineType(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 117;

  FUNCTION GpiSetLineWidth(ahps : hPs; f : Fixed) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 118;

  FUNCTION GpiQueryLineWidth(ahps : hPs) : Fixed;
    EXTERNAL 'PMGPI' INDEX 119;

  FUNCTION GpiSetLineWidthGeom(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 120;

  FUNCTION GpiQueryLineWidthGeom(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 121;

  FUNCTION GpiSetLineEnd(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 122;

  FUNCTION GpiQueryLineEnd(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 123;

  FUNCTION GpiSetLineJoin(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 124;

  FUNCTION GpiQueryLineJoin(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 125;

  FUNCTION GpiSetCurrentPosition(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 126;

  FUNCTION GpiQueryCurrentPosition(    ahps    : hPs;
                                   VAR aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 127;

{*** arc primitive functions *}

  FUNCTION GpiSetArcParams(ahps : hPs;
                           P    : { LONG } ArcParams) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 134;

  FUNCTION GpiQueryArcParams(    ahps : hPs;
                             VAR P    : { LONG } ArcParams) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 135;

  FUNCTION GpiPointArc(ahps    : hPs;
                       aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 136;

  FUNCTION GpiFullArc(ahps : hPs;
                      l1   : LongInt;
                      f    : Fixed) : LongInt;
    EXTERNAL 'PMGPI' INDEX 137;

  FUNCTION GpiPartialArc(ahps       : hPs;
                         aPointL    : { LONG } PointL;
                         f1, f2, f3 : Fixed) : LongInt;
    EXTERNAL 'PMGPI' INDEX 138;

  FUNCTION GpiPolyFilletSharp(ahps    : hPs;
                              l1      : LongInt;
                              aPointL : { LONG } PointL;
                              f4      : { LONG } Fixed) : LongInt;
    EXTERNAL 'PMGPI' INDEX 140;

  FUNCTION GpiPolySpline(ahps    : hPs;
                         l1      : LongInt;
                         aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 141;

  FUNCTION GpiPolyFillet(ahps   : hPs;
                         l1     : LongInt;
                         PointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 139;

{*** area primitive functions *}

  FUNCTION GpiSetPatternSet(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 144;

  FUNCTION GpiQueryPatternSet(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 145;

  FUNCTION GpiSetPatternRefPoint(ahps    : hPs;
                                 aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 148;

  FUNCTION GpiQueryPatternRefPoint(    ahps   : hPs;
                                   VAR PointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 149;

{*** character primitive functions *}

  FUNCTION GpiQueryCharStringPos; EXTERNAL 'PMGPI' INDEX 245;

  FUNCTION GpiQueryCharStringPosAt;  EXTERNAL 'PMGPI' INDEX 246;

  FUNCTION GpiQueryTextBox;
    EXTERNAL 'PMGPI' INDEX 164;

  FUNCTION GpiQueryDefCharBox;
    EXTERNAL 'PMGPI' INDEX 166;

  FUNCTION GpiSetCharSet;   EXTERNAL 'PMGPI' INDEX 168;

  FUNCTION GpiQueryCharSet;
    EXTERNAL 'PMGPI' INDEX 169;

  FUNCTION GpiSetCharBox(ahps : hPs; SizeF : { LONG } SizeF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 170;

  FUNCTION GpiQueryCharBox(    ahps  : hPs;
                           VAR SizeF : { LONG } SizeF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 171;

  FUNCTION GpiSetCharAngle(ahps       : hPs;
                           aGradientL : { LONG } GradientL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 172;

  FUNCTION GpiQueryCharAngle(    ahps       : hPs;
                             VAR aGradientL : { LONG } GradientL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 173;

  FUNCTION GpiSetCharShear(ahps : hPs; aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 174;

  FUNCTION GpiQueryCharShear(    ahps    : hPs;
                             VAR aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 175;

  FUNCTION GpiSetCharDirection(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 176;

  FUNCTION GpiQueryCharDirection(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 177;

  FUNCTION GpiSetCharMode(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 178;

  FUNCTION GpiQueryCharMode(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 179;

  FUNCTION GpiCharStringPos;
    EXTERNAL 'PMGPI' INDEX 182;

  FUNCTION GpiCharStringPosAt;
    EXTERNAL 'PMGPI' INDEX 183;

{*** marker primitive functions *}

  FUNCTION GpiSetMarkerSet(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 184;

  FUNCTION GpiQueryMarkerSet(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 185;

  FUNCTION GpiSetMarker(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 186;

  FUNCTION GpiQueryMarker(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 187;

  FUNCTION GpiSetMarkerBox(ahps : hPs; aSizeF : { LONG } SizeF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 188;

  FUNCTION GpiQueryMarkerBox(ahps : hPs; VAR aSizeF : { LONG } SizeF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 189;

  FUNCTION GpiMarker(ahps : hPs; aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 190;

  FUNCTION GpiPolyMarker(ahps    : hPs;
                         l1      : LongInt;
                         aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 191;

{*** image primitive functions *}

  FUNCTION GpiImage(ahps   : hPs;
                    l1     : LongInt;
                    aSizeL : { LONG } SizeL;
                    c7     : LongInt;
                    aByte  : Pointer) : LongInt;
    EXTERNAL 'PMGPI' INDEX 192;

{*** miscellaneous primitive functions *}

  FUNCTION GpiPop(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 96;

  FUNCTION GpiPtVisible(ahps : hPs; aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 132;

  FUNCTION GpiRectVisible(ahps : hPs; aRectl : { LONG } RectL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 133;

  FUNCTION GpiComment(ahps  : hPs;
                      l1    : LongInt;
                      aByte : Pointer) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 268;

  FUNCTION GpiDeleteSetId(ahps : hPs; l : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 155;

  FUNCTION GpiQueryNumberSetIds(ahps : hPs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 156;

  FUNCTION GpiQuerySetIds(    ahps : hPs;
                              l1   : LongInt;
                          VAR l9   : { LONG } LongInt;
                          VAR aStr8: { LONG } Str8;
                          VAR i3   : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 157;

  FUNCTION GpiLoadFonts(ahab : HAB; P : pChar) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 152;

  FUNCTION GpiUnloadFonts(ahab : HAB; P : pChar) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 153;

  FUNCTION GpiCreateLogFont(    ahps    : hPs;
                            VAR aStr8   : { LONG } Str8;
                                i5      : LongInt;
                            VAR aFAttrs : { LONG } fAttrs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 154;

  FUNCTION GpiQueryFonts(    ahps         : hPs;
                             l1           : LongInt;
                             P            : pChar;
                         VAR c2           : { LONG } LongInt;
                             c3           : LongInt;
                         VAR aFontMetrics : { LONG } FontMetrics) : LongInt;
    EXTERNAL 'PMGPI' INDEX 158;

  FUNCTION GpiQueryFontMetrics(    ahps         : hPs;
                                   l1           : LongInt;
                               VAR aFontMetrics : { LONG } FontMetrics) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 159;

  FUNCTION GpiQueryKerningPairs(    ahps          : hPs;
                                    l1            : LongInt;
                                VAR aKerningPairs : { LONG } KerningPairs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 160;

  FUNCTION GpiQueryWidthTable(    ahps      : hPs;
                                  l1        : LongInt;
                                  l6        : LongInt;
                              VAR LongArray : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 161;

  FUNCTION GpiSetCp(ahps : hPs; c8 : WORD) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 162;

  FUNCTION GpiQueryCp(ahps : hPs) : WORD;
    EXTERNAL 'PMGPI' INDEX 163;

  FUNCTION GpiQueryFontFileDescriptions(    ahab     : HAB;
                                            P        : pChar;
                                        VAR c2       : { LONG } LongInt;
                                        VAR aFFDescs : { LONG } FFDescs) : LongInt;
    EXTERNAL 'PMGPI' INDEX 167;

  FUNCTION GpiDeleteBitmap(aHBitmap : hBitmap) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 197;

  FUNCTION GpiSetBitmap(ahps : hPs; aHBitmap : hBitmap) : hBitmap;
    EXTERNAL 'PMGPI' INDEX 198;

  FUNCTION GpiBitBlt(ahps    : hPs;
                     ahps    : hPs;
                     c3      : LongInt;
                     aPointL : { LONG } PointL;
                     c4      : LongInt;
                     i9      : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 205;

  FUNCTION GpiWCBitBlt(ahps     : hPs;
                       aHBitmap : hBitmap;
                       ac3      : LongInt;
                       aPointL  : { LONG } PointL;
                       c3       : LongInt;
                       i9       : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 269;

  FUNCTION GpiCreateBitmap(ahps              : hPs;
                           aBitMapInfoHeader : { LONG } BitmapInfoHeader;
                           i8                : LongInt;
                           aByte             : Pointer;
                           aBitMapInfo       : { LONG } BitmapInfo) : hBitmap;
    EXTERNAL 'PMGPI' INDEX 196;

  FUNCTION GpiSetBitmapDimension(aHBitmap : hBitmap;
                                 aPSizeL  : { LONG } SizeL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 199;

  FUNCTION GpiQueryBitmapDimension(    aHBitmap : hBitmap;
                                   VAR aPSizeL  : { LONG } SizeL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 200;

  FUNCTION GpiQueryDeviceBitmapFormats(    ahps : hPs;
                                           l1   : LongInt;
                                       VAR l7   : { LONG } LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 201;

  FUNCTION GpiQueryBitmapParameters(    aHBitmap          : hBitmap;
                                    VAR aBitMapInfoHeader : { LONG } BitmapInfoHeader) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 202;

  FUNCTION GpiQueryBitmapBits(    ahps        : hPs;
                                  l1          : LongInt;
                                  l6          : LongInt;
                                  aByte       : Pointer;
                              VAR aBitMapInfo : { LONG } BitmapInfo) : LongInt;
    EXTERNAL 'PMGPI' INDEX 204;

  FUNCTION GpiSetBitmapBits(ahps        : hPs;
                            l1          : LongInt;
                            l6          : LongInt;
                            aByte       : Pointer;
                            aBitMapInfo : { LONG } BitmapInfo) : LongInt;
    EXTERNAL 'PMGPI' INDEX 203;

  FUNCTION GpiSetPel(ahps : hPs; aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 206;

  FUNCTION GpiQueryPel(    ahps    : hPs;
                       VAR aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 207;

  FUNCTION GpiSetBitmapId(ahps : hPs; aHBitmap : hBitmap; c4 : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 142;

  FUNCTION GpiQueryBitmapHandle(ahps : hPs; l : LongInt) : hBitmap;
    EXTERNAL 'PMGPI' INDEX 143;

  FUNCTION GpiCreateRegion(ahps   : hPs;
                           l1     : LongInt;
                           aRectl : { LONG } RectL) : HRGN;
    EXTERNAL 'PMGPI' INDEX 208;

  FUNCTION GpiSetRegion(ahps   : hPs;
                        ahRGN  : HRGN;
                        c3     : LongInt;
                        aRectl : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 209;

  FUNCTION GpiDestroyRegion(ahps : hPs; hRGN1 : HRGN) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 210;

  FUNCTION GpiCombineRegion(ahps  : hPs;
                            hRGN1 : HRGN;
                            hRGN2 : HRGN;
                            hRGN3 : HRGN;
                            c4    : LongInt) : LongInt;
    EXTERNAL 'PMGPI' INDEX 211;

  FUNCTION GpiEqualRegion(ahps  : hPs;
                          hRGN1 : HRGN;
                          hRGN2 : HRGN) : LongInt;
    EXTERNAL 'PMGPI' INDEX 212;

  FUNCTION GpiOffsetRegion(ahps    : hPs;
                           ahRGN   : HRGN;
                           aPointL : { LONG } PointL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 213;

  FUNCTION GpiPtInRegion(ahps    : hPs;
                         ahRGN   : HRGN;
                         aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 214;

  FUNCTION GpiRectInRegion(ahps   : hPs;
                           ahRGN  : HRGN;
                           aRectl : { LONG } RectL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 215;

  FUNCTION GpiQueryRegionBox(    ahps   : hPs;
                                 ahRGN  : HRGN;
                             VAR aRectl : { LONG } RectL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 216;

  FUNCTION GpiQueryRegionRects(    ahps     : hPs;
                                   ahRGN    : HRGN;
                                   aRectl   : { LONG } RectL;
                                   aRGNRect : { LONG } rgnRect;
                               VAR aRectl   : { LONG } RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 217;

  FUNCTION GpiPaintRegion(ahps : hPs; ahRGN : HRGN) : LongInt;
    EXTERNAL 'PMGPI' INDEX 224;

{*** clip region functions *}

  FUNCTION GpiSetClipRegion(ahps  : hPs;
                            ahRGN : HRGN;
                            ahRGN : { LONG } HRGN) : LongInt;
    EXTERNAL 'PMGPI' INDEX 218;

  FUNCTION GpiQueryClipRegion(ahps : hPs) : HRGN;
    EXTERNAL 'PMGPI' INDEX 219;

  FUNCTION GpiQueryClipBox(    ahps   : hPs;
                           VAR aRectl : { LONG } RectL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 220;

  FUNCTION GpiIntersectClipRectangle(ahps   : hPs;
                                     aRectl : { LONG } RectL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 221;

  FUNCTION GpiExcludeClipRectangle(ahps   : hPs;
                                   aRectl : { LONG } RectL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 222;

  FUNCTION GpiOffsetClipRegion(ahps    : hPs;
                               aPointL : { LONG } PointL) : LongInt;
    EXTERNAL 'PMGPI' INDEX 223;

  FUNCTION GpiLoadMetaFile(ahab : HAB; P : pChar) : hMF;
    EXTERNAL 'PMGPI' INDEX 225;

  FUNCTION GpiPlayMetaFile(    ahps : hPs;
                               aHMF : hMF;
                               c3   : LongInt;
                           VAR c2   : { LONG } LongInt;
                           VAR c1   : { LONG } LongInt;
                               c4   : LongInt;
                               P    : pChar) : LongInt;
    EXTERNAL 'PMGPI' INDEX 227;

  FUNCTION GpiSaveMetaFile(aHMF : hMF; P : pChar) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 228;

  FUNCTION GpiDeleteMetaFile(aHMF : hMF) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 229;

  FUNCTION GpiCopyMetaFile(aHMF : hMF) : hMF;
    EXTERNAL 'PMGPI' INDEX 226;

  FUNCTION GpiQueryMetaFileLength(aHMF : hMF) : LongInt;
    EXTERNAL 'PMGPI' INDEX 232;

  FUNCTION GpiQueryMetaFileBits(aHMF   : hMF;
                                c1, c3 : LongInt;
                                aByte  : Pointer) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 230;

  FUNCTION GpiSetMetaFileBits(aHMF   : hMF;
                              c1, c3 : LongInt;
                              aByte  : Pointer) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 231;

  FUNCTION GpiQueryDefArcParams(a : hPs; VAR b : ArcParams) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 282;

  FUNCTION GpiQueryDefAttrs(a : hPs;
                            b : LongInt;
                            c : LongInt;
                            d : pBundle) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 278;

  FUNCTION GpiQueryDefTag(a : hPs; VAR b : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 276;

  FUNCTION GpiQueryDefViewingLimits(a : hPs; VAR b : RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 280;

  FUNCTION GpiSetDefArcParams(a : hPs; b : ArcParams) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 281;

  FUNCTION GpiSetDefAttrs(a : hPs;
                          b : LongInt;
                          c : LongInt;
                          d : pBundle) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 277;

  FUNCTION GpiSetDefTag(a : hPs; b : LongInt) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 275;

  FUNCTION GpiSetDefViewingLimits(a : hPs; b : RectL) : BOOLEAN;
    EXTERNAL 'PMGPI' INDEX 279;

  FUNCTION DevOpenDC;             EXTERNAL 'PMGPI' INDEX  1;
  FUNCTION Dev16OpenDC;           EXTERNAL 'PMGPI' INDEX  1;

  FUNCTION DevCloseDC;            EXTERNAL 'PMGPI' INDEX  2;
  FUNCTION Dev16CloseDC;          EXTERNAL 'PMGPI' INDEX  2;

  FUNCTION DevPostDeviceModes;    EXTERNAL 'PMGPI' INDEX  3;
  FUNCTION Dev16PostDeviceModes;  EXTERNAL 'PMGPI' INDEX  3;

  FUNCTION DevEscape;             EXTERNAL 'PMGPI' INDEX  4;
  FUNCTION Dev16Escape;           EXTERNAL 'PMGPI' INDEX  4;

  FUNCTION DevQueryHardcopyCaps;  EXTERNAL 'PMGPI' INDEX  5;
  FUNCTION Dev16QueryHardcopyCaps;EXTERNAL 'PMGPI' INDEX  5;

  FUNCTION DevQueryCaps;          EXTERNAL 'PMGPI' INDEX  6;
  FUNCTION Dev16QueryCaps;        EXTERNAL 'PMGPI' INDEX  6;

  FUNCTION Gpi16CreatePS;         EXTERNAL 'PMGPI' INDEX  7;
  FUNCTION Gpi16QueryPS;          EXTERNAL 'PMGPI' INDEX  9;
  FUNCTION Gpi16DestroyPS;        EXTERNAL 'PMGPI' INDEX 10;
  FUNCTION Gpi16ResetPS;          EXTERNAL 'PMGPI' INDEX 11;
  FUNCTION Gpi16SavePS;           EXTERNAL 'PMGPI' INDEX 12;
  FUNCTION Gpi16RestorePS;        EXTERNAL 'PMGPI' INDEX 13;
  FUNCTION Gpi16Associate;        EXTERNAL 'PMGPI' INDEX 14;
  FUNCTION Gpi16ErrorSegmentData; EXTERNAL 'PMGPI' INDEX 15;
  FUNCTION Gpi16Erase;            EXTERNAL 'PMGPI' INDEX 16;
  FUNCTION Gpi16SetDrawControl;   EXTERNAL 'PMGPI' INDEX 17;
  FUNCTION Gpi16QueryDrawControl; EXTERNAL 'PMGPI' INDEX 18;
  FUNCTION Gpi16DrawChain;        EXTERNAL 'PMGPI' INDEX 19;
  FUNCTION Gpi16DrawFrom;         EXTERNAL 'PMGPI' INDEX 20;
  FUNCTION Gpi16DrawSegment;      EXTERNAL 'PMGPI' INDEX 21;
  FUNCTION Gpi16SetStopDraw;      EXTERNAL 'PMGPI' INDEX 22;
  FUNCTION Gpi16QueryStopDraw;    EXTERNAL 'PMGPI' INDEX 23;
  FUNCTION Gpi16RemoveDynamics;   EXTERNAL 'PMGPI' INDEX 24;
  FUNCTION Gpi16DrawDynamics;     EXTERNAL 'PMGPI' INDEX 25;
  FUNCTION Gpi16SetDrawingMode;   EXTERNAL 'PMGPI' INDEX 26;
  FUNCTION Gpi16QueryDrawingMode; EXTERNAL 'PMGPI' INDEX 27;
  FUNCTION Gpi16GetData;          EXTERNAL 'PMGPI' INDEX 28;
  FUNCTION Gpi16PutData;          EXTERNAL 'PMGPI' INDEX 29;
  FUNCTION Gpi16SetPickApertureSize;
  EXTERNAL 'PMGPI' INDEX 30;
  FUNCTION Gpi16QueryPickApertureSize;
  EXTERNAL 'PMGPI' INDEX 31;
  FUNCTION Gpi16SetPickAperturePosition;
  EXTERNAL 'PMGPI' INDEX 32;
  FUNCTION Gpi16QueryPickAperturePosition;
  EXTERNAL 'PMGPI' INDEX 33;
  FUNCTION Gpi16SetTag;           EXTERNAL 'PMGPI' INDEX 34;
  FUNCTION Gpi16QueryTag;         EXTERNAL 'PMGPI' INDEX 35;
  FUNCTION Gpi16CorrelateChain;   EXTERNAL 'PMGPI' INDEX 36;
  FUNCTION Gpi16CorrelateFrom;    EXTERNAL 'PMGPI' INDEX 37;
  FUNCTION Gpi16CorrelateSegment; EXTERNAL 'PMGPI' INDEX 38;

(* ==================================================== *)

  FUNCTION Gpi16ResetBoundaryData;EXTERNAL 'PMGPI' INDEX 42;
  FUNCTION Gpi16QueryBoundaryData;EXTERNAL 'PMGPI' INDEX 43;
  FUNCTION Gpi16OpenSegment;      EXTERNAL 'PMGPI' INDEX 44;

(* ====================================================== *)

  FUNCTION Gpi16CloseSegment;     EXTERNAL 'PMGPI' INDEX 46;
  FUNCTION Gpi16DeleteSegment;    EXTERNAL 'PMGPI' INDEX 47;
  FUNCTION Gpi16DeleteSegments;   EXTERNAL 'PMGPI' INDEX 48;
  FUNCTION Gpi16QuerySegmentNames;EXTERNAL 'PMGPI' INDEX 49;

(* ====================================================== *)

  FUNCTION Gpi16SetInitialSegmentAttrs;
  EXTERNAL 'PMGPI' INDEX 51;
  FUNCTION Gpi16QueryInitialSegmentAttrs;
  EXTERNAL 'PMGPI' INDEX 52;
  FUNCTION Gpi16SetSegmentAttrs;  EXTERNAL 'PMGPI' INDEX 53;
  FUNCTION Gpi16QuerySegmentAttrs;EXTERNAL 'PMGPI' INDEX 54;
  FUNCTION Gpi16SetSegmentPriority;
  EXTERNAL 'PMGPI' INDEX 55;
  FUNCTION Gpi16QuerySegmentPriority;
  EXTERNAL 'PMGPI' INDEX 56;
  FUNCTION Gpi16SetEditMode;      EXTERNAL 'PMGPI' INDEX 57;
  FUNCTION Gpi16QueryEditMode;    EXTERNAL 'PMGPI' INDEX 58;
  FUNCTION Gpi16SetElementPointer;EXTERNAL 'PMGPI' INDEX 59;
  FUNCTION Gpi16QueryElementPointer;
  EXTERNAL 'PMGPI' INDEX 60;
  FUNCTION Gpi16OffsetElementPointer;
  EXTERNAL 'PMGPI' INDEX 61;
  FUNCTION Gpi16DeleteElement;    EXTERNAL 'PMGPI' INDEX 62;
  FUNCTION Gpi16DeleteElementRange;
  EXTERNAL 'PMGPI' INDEX 63;
  FUNCTION Gpi16Label;            EXTERNAL 'PMGPI' INDEX 64;
  FUNCTION Gpi16SetElementPointerAtLabel;
  EXTERNAL 'PMGPI' INDEX 65;
  FUNCTION Gpi16DeleteElementsBetweenLabels;
  EXTERNAL 'PMGPI' INDEX 66;
  FUNCTION Gpi16QueryElementType; EXTERNAL 'PMGPI' INDEX 67;
  FUNCTION Gpi16QueryElement;     EXTERNAL 'PMGPI' INDEX 68;
  FUNCTION Gpi16Element;          EXTERNAL 'PMGPI' INDEX 69;
  FUNCTION Gpi16BeginElement;     EXTERNAL 'PMGPI' INDEX 70;
  FUNCTION Gpi16EndElement;       EXTERNAL 'PMGPI' INDEX 71;

(* ====================================================== *)

  FUNCTION Gpi16SetSegmentTransformMatrix;
  EXTERNAL 'PMGPI' INDEX  78;
  FUNCTION Gpi16QuerySegmentTransformMatrix;
  EXTERNAL 'PMGPI' INDEX 79;
  FUNCTION Gpi16SetModelTransformMatrix;
  EXTERNAL 'PMGPI' INDEX 80;
  FUNCTION Gpi16QueryModelTransformMatrix;
  EXTERNAL 'PMGPI' INDEX 81;
  FUNCTION Gpi16CallSegmentMatrix;EXTERNAL 'PMGPI' INDEX 82;
  FUNCTION Gpi16SetDefaultViewMatrix;
  EXTERNAL 'PMGPI' INDEX 83;
  FUNCTION Gpi16QueryDefaultViewMatrix;
  EXTERNAL 'PMGPI' INDEX 84;
  FUNCTION Gpi16SetPageViewport;  EXTERNAL 'PMGPI' INDEX 85;
  FUNCTION Gpi16QueryPageViewport;EXTERNAL 'PMGPI' INDEX 86;
  FUNCTION Gpi16SetViewingTransformMatrix;
  EXTERNAL 'PMGPI' INDEX 87;
  FUNCTION Gpi16QueryViewingTransformMatrix;
  EXTERNAL 'PMGPI' INDEX 88;
  FUNCTION xGpiQueryViewingTransformMatrix;
  EXTERNAL 'PMGPI' INDEX 88;
  FUNCTION xGpi16QueryViewingTransformMatrix;
  EXTERNAL 'PMGPI' INDEX 88;
  FUNCTION Gpi16SetGraphicsField; EXTERNAL 'PMGPI' INDEX 89;
  FUNCTION Gpi16QueryGraphicsField;
  EXTERNAL 'PMGPI' INDEX 90;
  FUNCTION Gpi16SetViewingLimits; EXTERNAL 'PMGPI' INDEX 91;
  FUNCTION Gpi16QueryViewingLimits;
  EXTERNAL 'PMGPI' INDEX 92;
  FUNCTION Gpi16Convert;          EXTERNAL 'PMGPI' INDEX 93;
  FUNCTION Gpi16SetAttrMode;      EXTERNAL 'PMGPI' INDEX 94;
  FUNCTION Gpi16QueryAttrMode;    EXTERNAL 'PMGPI' INDEX 95;
  FUNCTION Gpi16Pop;              EXTERNAL 'PMGPI' INDEX 96;
  FUNCTION Gpi16SetAttrs;         EXTERNAL 'PMGPI' INDEX 97;
  FUNCTION Gpi16QueryAttrs;       EXTERNAL 'PMGPI' INDEX 98;
  FUNCTION Gpi16CreateLogColorTable;
  EXTERNAL 'PMGPI' INDEX 99;
  FUNCTION Gpi16RealizeColorTable;
  EXTERNAL 'PMGPI' INDEX 100;
  FUNCTION Gpi16UnrealizeColorTable;
  EXTERNAL 'PMGPI' INDEX 101;
  FUNCTION Gpi16QueryColorData;  EXTERNAL 'PMGPI' INDEX 102;
  FUNCTION Gpi16QueryLogColorTable;
  EXTERNAL 'PMGPI' INDEX 103;
  FUNCTION Gpi16QueryRealColors; EXTERNAL 'PMGPI' INDEX 104;
  FUNCTION Gpi16QueryNearestColor;
  EXTERNAL 'PMGPI' INDEX 105;
  FUNCTION Gpi16QueryColorIndex; EXTERNAL 'PMGPI' INDEX 106;
  FUNCTION Gpi16QueryRGBColor;   EXTERNAL 'PMGPI' INDEX 107;
  FUNCTION Gpi16SetColor;        EXTERNAL 'PMGPI' INDEX 108;
  FUNCTION Gpi16QueryColor;      EXTERNAL 'PMGPI' INDEX 109;
  FUNCTION Gpi16SetBackColor;    EXTERNAL 'PMGPI' INDEX 110;
  FUNCTION Gpi16QueryBackColor;  EXTERNAL 'PMGPI' INDEX 111;
  FUNCTION Gpi16SetMix;          EXTERNAL 'PMGPI' INDEX 112;
  FUNCTION Gpi16QueryMix;        EXTERNAL 'PMGPI' INDEX 113;
  FUNCTION Gpi16SetBackMix;      EXTERNAL 'PMGPI' INDEX 114;
  FUNCTION Gpi16QueryBackMix;    EXTERNAL 'PMGPI' INDEX 115;
  FUNCTION Gpi16SetLineType;     EXTERNAL 'PMGPI' INDEX 116;
  FUNCTION Gpi16QueryLineType;   EXTERNAL 'PMGPI' INDEX 117;
  FUNCTION Gpi16SetLineWidth;    EXTERNAL 'PMGPI' INDEX 118;
  FUNCTION Gpi16QueryLineWidth;  EXTERNAL 'PMGPI' INDEX 119;
  FUNCTION Gpi16SetLineWidthGeom;EXTERNAL 'PMGPI' INDEX 120;
  FUNCTION Gpi16QueryLineWidthGeom;
  EXTERNAL 'PMGPI' INDEX 121;
  FUNCTION Gpi16SetLineEnd;      EXTERNAL 'PMGPI' INDEX 122;
  FUNCTION Gpi16QueryLineEnd;    EXTERNAL 'PMGPI' INDEX 123;
  FUNCTION Gpi16SetLineJoin;     EXTERNAL 'PMGPI' INDEX 124;
  FUNCTION Gpi16QueryLineJoin;   EXTERNAL 'PMGPI' INDEX 125;
  FUNCTION Gpi16SetCurrentPosition;
  EXTERNAL 'PMGPI' INDEX 126;
  FUNCTION Gpi16QueryCurrentPosition;
  EXTERNAL 'PMGPI' INDEX 127;
  FUNCTION Gpi16Move;            EXTERNAL 'PMGPI' INDEX 128;
  FUNCTION Gpi16Line;            EXTERNAL 'PMGPI' INDEX 129;
  FUNCTION Gpi16PolyLine;        EXTERNAL 'PMGPI' INDEX 130;
  FUNCTION Gpi16Box;             EXTERNAL 'PMGPI' INDEX 131;
  FUNCTION Gpi16PtVisible;       EXTERNAL 'PMGPI' INDEX 132;
  FUNCTION Gpi16RectVisible;     EXTERNAL 'PMGPI' INDEX 133;
  FUNCTION Gpi16SetArcParams;    EXTERNAL 'PMGPI' INDEX 134;
  FUNCTION Gpi16QueryArcParams;  EXTERNAL 'PMGPI' INDEX 135;
  FUNCTION Gpi16PointArc;        EXTERNAL 'PMGPI' INDEX 136;
  FUNCTION Gpi16FullArc;         EXTERNAL 'PMGPI' INDEX 137;
  FUNCTION Gpi16PartialArc;      EXTERNAL 'PMGPI' INDEX 138;
  FUNCTION Gpi16PolyFillet;      EXTERNAL 'PMGPI' INDEX 139;
  FUNCTION Gpi16PolyFilletSharp; EXTERNAL 'PMGPI' INDEX 140;
  FUNCTION Gpi16PolySpline;      EXTERNAL 'PMGPI' INDEX 141;
  FUNCTION Gpi16SetBitmapId;     EXTERNAL 'PMGPI' INDEX 142;
  FUNCTION Gpi16QueryBitmapHandle;
  EXTERNAL 'PMGPI' INDEX 143;
  FUNCTION Gpi16SetPatternSet;   EXTERNAL 'PMGPI' INDEX 144;
  FUNCTION Gpi16QueryPatternSet; EXTERNAL 'PMGPI' INDEX 145;
  FUNCTION Gpi16SetPattern;      EXTERNAL 'PMGPI' INDEX 146;
  FUNCTION Gpi16QueryPattern;    EXTERNAL 'PMGPI' INDEX 147;
  FUNCTION Gpi16SetPatternRefPoint;
  EXTERNAL 'PMGPI' INDEX 148;
  FUNCTION Gpi16QueryPatternRefPoint;
  EXTERNAL 'PMGPI' INDEX 149;
  FUNCTION Gpi16BeginArea;       EXTERNAL 'PMGPI' INDEX 150;
  FUNCTION Gpi16EndArea;         EXTERNAL 'PMGPI' INDEX 151;
  FUNCTION Gpi16LoadFonts;       EXTERNAL 'PMGPI' INDEX 152;
  FUNCTION Gpi16UnloadFonts;     EXTERNAL 'PMGPI' INDEX 153;
  FUNCTION Gpi16CreateLogFont;   EXTERNAL 'PMGPI' INDEX 154;
  FUNCTION Gpi16DeleteSetId;     EXTERNAL 'PMGPI' INDEX 155;
  FUNCTION Gpi16QueryNumberSetIds;
  EXTERNAL 'PMGPI' INDEX 156;
  FUNCTION Gpi16QuerySetIds;     EXTERNAL 'PMGPI' INDEX 157;
  FUNCTION Gpi16QueryFonts;      EXTERNAL 'PMGPI' INDEX 158;
  FUNCTION Gpi16QueryFontMetrics;EXTERNAL 'PMGPI' INDEX 159;
  FUNCTION Gpi16QueryKerningPairs;
  EXTERNAL 'PMGPI' INDEX 160;
  FUNCTION Gpi16QueryWidthTable; EXTERNAL 'PMGPI' INDEX 161;
  FUNCTION Gpi16SetCp;           EXTERNAL 'PMGPI' INDEX 162;
  FUNCTION Gpi16QueryCp;         EXTERNAL 'PMGPI' INDEX 163;
  FUNCTION Gpi16QueryTextBox;    EXTERNAL 'PMGPI' INDEX 164;
  FUNCTION DevQueryDeviceNames;  EXTERNAL 'PMGPI' INDEX 165;
  FUNCTION Dev16QueryDeviceNames;EXTERNAL 'PMGPI' INDEX 165;
  FUNCTION Gpi16QueryDefCharBox; EXTERNAL 'PMGPI' INDEX 166;
  FUNCTION Gpi16QueryFontFileDescriptions;
  EXTERNAL 'PMGPI' INDEX 167;
  FUNCTION Gpi16SetCharSet;      EXTERNAL 'PMGPI' INDEX 168;
  FUNCTION Gpi16QueryCharSet;    EXTERNAL 'PMGPI' INDEX 169;
  FUNCTION Gpi16SetCharBox;      EXTERNAL 'PMGPI' INDEX 170;
  FUNCTION Gpi16QueryCharBox;    EXTERNAL 'PMGPI' INDEX 171;
  FUNCTION Gpi16SetCharAngle;    EXTERNAL 'PMGPI' INDEX 172;
  FUNCTION Gpi16QueryCharAngle;  EXTERNAL 'PMGPI' INDEX 173;
  FUNCTION Gpi16SetCharShear;    EXTERNAL 'PMGPI' INDEX 174;
  FUNCTION Gpi16QueryCharShear;  EXTERNAL 'PMGPI' INDEX 175;
  FUNCTION Gpi16SetCharDirection;EXTERNAL 'PMGPI' INDEX 176;
  FUNCTION Gpi16QueryCharDirection;
  EXTERNAL 'PMGPI' INDEX 177;
  FUNCTION Gpi16SetCharMode;     EXTERNAL 'PMGPI' INDEX 178;
  FUNCTION Gpi16QueryCharMode;   EXTERNAL 'PMGPI' INDEX 179;
  FUNCTION Gpi16CharString;      EXTERNAL 'PMGPI' INDEX 180;
  FUNCTION Gpi16CharStringAt;    EXTERNAL 'PMGPI' INDEX 181;
  FUNCTION Gpi16CharStringPos;   EXTERNAL 'PMGPI' INDEX 182;
  FUNCTION Gpi16CharStringPosAt; EXTERNAL 'PMGPI' INDEX 183;
  FUNCTION Gpi16SetMarkerSet;    EXTERNAL 'PMGPI' INDEX 184;
  FUNCTION Gpi16QueryMarkerSet;  EXTERNAL 'PMGPI' INDEX 185;
  FUNCTION Gpi16SetMarker;       EXTERNAL 'PMGPI' INDEX 186;
  FUNCTION Gpi16QueryMarker;     EXTERNAL 'PMGPI' INDEX 187;
  FUNCTION Gpi16SetMarkerBox;    EXTERNAL 'PMGPI' INDEX 188;
  FUNCTION Gpi16QueryMarkerBox;  EXTERNAL 'PMGPI' INDEX 189;
  FUNCTION Gpi16Marker;          EXTERNAL 'PMGPI' INDEX 190;
  FUNCTION Gpi16PolyMarker;      EXTERNAL 'PMGPI' INDEX 191;
  FUNCTION Gpi16Image;           EXTERNAL 'PMGPI' INDEX 192;

(* ====================================================== *)

  FUNCTION Gpi16CreateBitmap;    EXTERNAL 'PMGPI' INDEX 196;
  FUNCTION Gpi16DeleteBitmap;    EXTERNAL 'PMGPI' INDEX 197;
  FUNCTION Gpi16SetBitmap;       EXTERNAL 'PMGPI' INDEX 198;
  FUNCTION Gpi16SetBitmapDimension;
  EXTERNAL 'PMGPI' INDEX 199;
  FUNCTION Gpi16QueryBitmapDimension;
  EXTERNAL 'PMGPI' INDEX 200;
  FUNCTION Gpi16QueryDeviceBitmapFormats;
  EXTERNAL 'PMGPI' INDEX 201;
  FUNCTION Gpi16QueryBitmapParameters;
  EXTERNAL 'PMGPI' INDEX 202;
  FUNCTION Gpi16SetBitmapBits;   EXTERNAL 'PMGPI' INDEX 203;
  FUNCTION Gpi16QueryBitmapBits; EXTERNAL 'PMGPI' INDEX 204;
  FUNCTION Gpi16BitBlt;          EXTERNAL 'PMGPI' INDEX 205;
  FUNCTION Gpi16SetPel;          EXTERNAL 'PMGPI' INDEX 206;
  FUNCTION Gpi16QueryPel;        EXTERNAL 'PMGPI' INDEX 207;
  FUNCTION Gpi16CreateRegion;    EXTERNAL 'PMGPI' INDEX 208;
  FUNCTION Gpi16SetRegion;       EXTERNAL 'PMGPI' INDEX 209;
  FUNCTION Gpi16DestroyRegion;   EXTERNAL 'PMGPI' INDEX 210;
  FUNCTION Gpi16CombineRegion;   EXTERNAL 'PMGPI' INDEX 211;
  FUNCTION Gpi16EqualRegion;     EXTERNAL 'PMGPI' INDEX 212;
  FUNCTION Gpi16OffsetRegion;    EXTERNAL 'PMGPI' INDEX 213;
  FUNCTION Gpi16PtInRegion;      EXTERNAL 'PMGPI' INDEX 214;
  FUNCTION Gpi16RectInRegion;    EXTERNAL 'PMGPI' INDEX 215;
  FUNCTION Gpi16QueryRegionBox;  EXTERNAL 'PMGPI' INDEX 216;
  FUNCTION Gpi16QueryRegionRects;EXTERNAL 'PMGPI' INDEX 217;
  FUNCTION Gpi16SetClipRegion;   EXTERNAL 'PMGPI' INDEX 218;
  FUNCTION Gpi16QueryClipRegion; EXTERNAL 'PMGPI' INDEX 219;
  FUNCTION Gpi16QueryClipBox;    EXTERNAL 'PMGPI' INDEX 220;
  FUNCTION Gpi16IntersectClipRectangle;
  EXTERNAL 'PMGPI' INDEX 221;
  FUNCTION Gpi16ExcludeClipRectangle;
  EXTERNAL 'PMGPI' INDEX 222;
  FUNCTION Gpi16OffsetClipRegion;EXTERNAL 'PMGPI' INDEX 223;
  FUNCTION Gpi16PaintRegion;     EXTERNAL 'PMGPI' INDEX 224;
  FUNCTION Gpi16LoadMetaFile;    EXTERNAL 'PMGPI' INDEX 225;
  FUNCTION Gpi16CopyMetaFile;    EXTERNAL 'PMGPI' INDEX 226;
  FUNCTION Gpi16PlayMetaFile;    EXTERNAL 'PMGPI' INDEX 227;
  FUNCTION Gpi16SaveMetaFile;    EXTERNAL 'PMGPI' INDEX 228;
  FUNCTION Gpi16DeleteMetaFile;  EXTERNAL 'PMGPI' INDEX 229;
  FUNCTION Gpi16QueryMetaFileBits;
  EXTERNAL 'PMGPI' INDEX 230;
  FUNCTION Gpi16SetMetaFileBits; EXTERNAL 'PMGPI' INDEX 231;
  FUNCTION Gpi16QueryMetaFileLength;
  EXTERNAL 'PMGPI' INDEX 232;
  FUNCTION Gpi16SetClipPath;     EXTERNAL 'PMGPI' INDEX 233;
  FUNCTION Gpi16BeginPath;       EXTERNAL 'PMGPI' INDEX 234;
  FUNCTION Gpi16EndPath;         EXTERNAL 'PMGPI' INDEX 235;
  FUNCTION Gpi16CloseFigure;     EXTERNAL 'PMGPI' INDEX 236;
  FUNCTION Gpi16ModifyPath;      EXTERNAL 'PMGPI' INDEX 237;
  FUNCTION Gpi16FillPath;        EXTERNAL 'PMGPI' INDEX 238;
{ -----------------> not implemented ---------------------->
  FUNCTION GPIStartRequest;       EXTERNAL 'PMGPI' INDEX 239;
  FUNCTION GPI16StartRequest;     EXTERNAL 'PMGPI' INDEX 239;
  ------------------------------------------                }
  FUNCTION Gpi16QueryDevice;     EXTERNAL 'PMGPI' INDEX 240;

(* ====================================================== *)

{ -----------------> not implemented ---------------------->
  FUNCTION DevStdOpen;            EXTERNAL 'PMGPI' INDEX 244;
  FUNCTION Dev16StdOpen;          EXTERNAL 'PMGPI' INDEX 244;
}
  FUNCTION Gpi16QueryCharStringPos;
  EXTERNAL 'PMGPI' INDEX 245;
  FUNCTION Gpi16QueryCharStringPosAt;
  EXTERNAL 'PMGPI' INDEX 246;

(* ====================================================*)

  FUNCTION Gpi16SetPS;           EXTERNAL 'PMGPI' INDEX 248;

{ -----------------> not implemented ---------------------->
  FUNCTION SegSGWOpenSegmentWindow;
    EXTERNAL 'PMGPI' INDEX 249;

  FUNCTION SegS16GWOpenSegmentWindow;
    EXTERNAL 'PMGPI' INDEX 249;

  FUNCTION MTEndReadRequest;
    EXTERNAL 'PMGPI' INDEX 250;
  FUNCTION MT16EndReadRequest;
    EXTERNAL 'PMGPI' INDEX 250;

  FUNCTION MTGetDescription;
    EXTERNAL 'PMGPI' INDEX 251;
  FUNCTION MT16GetDescription;
    EXTERNAL 'PMGPI' INDEX 251;

  FUNCTION FmtOrderTable;
    EXTERNAL 'PMGPI' INDEX 252;
  FUNCTION Fmt16OrderTable;
    EXTERNAL 'PMGPI' INDEX 252;

  FUNCTION MTGetCodepage;
    EXTERNAL 'PMGPI' INDEX 253;
  FUNCTION MT16GetCodepage;
    EXTERNAL 'PMGPI' INDEX 253;

  FUNCTION MTGetLCT;
    EXTERNAL 'PMGPI' INDEX 254;
  FUNCTION MT16GetLCT;
    EXTERNAL 'PMGPI' INDEX 254;

  FUNCTION MTGetGDDInfo;
    EXTERNAL 'PMGPI' INDEX 255;
  FUNCTION MT16GetGDDInfo;
    EXTERNAL 'PMGPI' INDEX 255;

  FUNCTION FmtConvertGoCapoly;
    EXTERNAL 'PMGPI' INDEX 256;
  FUNCTION Fmt16ConvertGoCaPoly;
    EXTERNAL 'PMGPI' INDEX 256;

  FUNCTION MTGetFirstFont;
    EXTERNAL 'PMGPI' INDEX 257;
  FUNCTION MT16GetFirstFont;
    EXTERNAL 'PMGPI' INDEX 257;

  FUNCTION SegSGWNewPartData;
    EXTERNAL 'PMGPI' INDEX 258;
  FUNCTION SegS16GWNewPartData;
    EXTERNAL 'PMGPI' INDEX 258;

  FUNCTION MTStartReadRequest;
    EXTERNAL 'PMGPI' INDEX 259;
  FUNCTION MT16StartReadRequest;
    EXTERNAL 'PMGPI' INDEX 259;

  FUNCTION MTGetFirstGraphicsData;
    EXTERNAL 'PMGPI' INDEX 260;
  FUNCTION MT16GetFirstGraphicsData;
    EXTERNAL 'PMGPI' INDEX 260;

  FUNCTION MTGetNextFont;
    EXTERNAL 'PMGPI' INDEX 261;
  FUNCTION MT16GetNextFont;
    EXTERNAL 'PMGPI' INDEX 261;

  FUNCTION MTGetNextGraphicsData;
    EXTERNAL 'PMGPI' INDEX 262;
  FUNCTION MT16GetNextGraphicsData;
    EXTERNAL 'PMGPI' INDEX 262;

  FUNCTION GPILoadPublicFonts;
    EXTERNAL 'PMGPI' INDEX 263;
  FUNCTION GPI16LoadPublicFonts;
    EXTERNAL 'PMGPI' INDEX 263;

  FUNCTION GPIUnLoadPublicFonts;
    EXTERNAL 'PMGPI' INDEX 264;
  FUNCTION GPI16UnLoadPublicFonts;
    EXTERNAL 'PMGPI' INDEX 264;

  ------------------------------------------------         }

  FUNCTION Gpi16Comment;         EXTERNAL 'PMGPI' INDEX 268;
  FUNCTION Gpi16WCBitBlt;        EXTERNAL 'PMGPI' INDEX 269;
  FUNCTION Gpi16StrokePath;      EXTERNAL 'PMGPI' INDEX 270;

{ -----------------> not implemented ---------------------->

  FUNCTION SegSGWNextOrderF;     EXTERNAL 'PMGPI' INDEX 271;
  FUNCTION SegS16GWNextOrderF;   EXTERNAL 'PMGPI' INDEX 271;
 --------------------------------------------------------- }

(* ====================================================== *)

  FUNCTION Gpi16OutlinePath;     EXTERNAL 'PMGPI' INDEX 274;
  FUNCTION Gpi16SetDefTag;       EXTERNAL 'PMGPI' INDEX 275;
  FUNCTION Gpi16QueryDefTag;     EXTERNAL 'PMGPI' INDEX 276;
  FUNCTION Gpi16SetDefAttrs;     EXTERNAL 'PMGPI' INDEX 277;
  FUNCTION Gpi16QueryDefAttrs;   EXTERNAL 'PMGPI' INDEX 278;
  FUNCTION Gpi16SetDefViewingLimits;
  EXTERNAL 'PMGPI' INDEX 279;
  FUNCTION Gpi16QueryDefViewingLimits;
  EXTERNAL 'PMGPI' INDEX 280;
  FUNCTION Gpi16SetDefArcParams; EXTERNAL 'PMGPI' INDEX 281;
  FUNCTION Gpi16QueryDefArcParams;
  EXTERNAL 'PMGPI' INDEX 282;
  FUNCTION Gpi16Translate;       EXTERNAL 'PMGPI' INDEX 283;
  FUNCTION Gpi16Scale;           EXTERNAL 'PMGPI' INDEX 284;
  FUNCTION Gpi16Rotate;          EXTERNAL 'PMGPI' INDEX 285;

{ -----------------> not implemented ---------------------->

  FUNCTION GPIPolyLineDisjoint;  EXTERNAL 'PMGPI' INDEX 286;
  FUNCTION GPI16PolyLineDisjoint;EXTERNAL 'PMGPI' INDEX 286;

  FUNCTION GPIPathToRegion;      EXTERNAL 'PMGPI' INDEX 287;
  FUNCTION GPI16PathToRegion;    EXTERNAL 'PMGPI' INDEX 287;
}

(* ====================================================== *)

{  -------------> not implemented ------------>

  FUNCTION GPIFloodFill;
    EXTERNAL 'PMGPI' INDEX 289;
  FUNCTION GPI16FloodFill;
    EXTERNAL 'PMGPI' INDEX 289;

  FUNCTION GPIDrawBits;
    EXTERNAL 'PMGPI' INDEX 290;
  FUNCTION GPI16DrawBits;
    EXTERNAL 'PMGPI' INDEX 290;

  FUNCTION GPIQueryBitmapInfoHeader;
    EXTERNAL 'PMGPI' INDEX 291;
  FUNCTION GPI16QueryBitmapInfoHeader;
    EXTERNAL 'PMGPI' INDEX 291;

  FUNCTION GPIQueryLogicalFont;
    EXTERNAL 'PMGPI' INDEX 292;
  FUNCTION GPI16QueryLogicalFont;
    EXTERNAL 'PMGPI' INDEX 292;

  FUNCTION GPIQueryFaceString;
    EXTERNAL 'PMGPI' INDEX 293;
  FUNCTION GPI16QueryFaceString;
    EXTERNAL 'PMGPI' INDEX 293;

  FUNCTION GPIQueryFontAction;
    EXTERNAL 'PMGPI' INDEX 294;
  FUNCTION GPI16QueryFontAction;
    EXTERNAL 'PMGPI' INDEX 294;

  FUNCTION GPICreatePalette;
    EXTERNAL 'PMGPI' INDEX 295;
  FUNCTION GPI16CreatePalette;
    EXTERNAL 'PMGPI' INDEX 295;

  FUNCTION GPIDeletePalette;
    EXTERNAL 'PMGPI' INDEX 296;
  FUNCTION GPI16DeletePalette;
    EXTERNAL 'PMGPI' INDEX 296;

  FUNCTION GPISelectPalette;
    EXTERNAL 'PMGPI' INDEX 297;
  FUNCTION GPI16SelectPalette;
    EXTERNAL 'PMGPI' INDEX 297;

  FUNCTION GPIAnimatePalette;
    EXTERNAL 'PMGPI' INDEX 298;
  FUNCTION GPI16AnimatePalette;
    EXTERNAL 'PMGPI' INDEX 298;

  FUNCTION GPISetPaletteEntries;
    EXTERNAL 'PMGPI' INDEX 299;
  FUNCTION GPI16SetPaletteEntries;
    EXTERNAL 'PMGPI' INDEX 299;

  FUNCTION GPIQueryPalette;
    EXTERNAL 'PMGPI' INDEX 300;
  FUNCTION GPI16QueryPalette;
    EXTERNAL 'PMGPI' INDEX 300;

  FUNCTION GPIQueryPaletteInfo;
    EXTERNAL 'PMGPI' INDEX 301;
  FUNCTION GPI16QueryPaletteInfo;
    EXTERNAL 'PMGPI' INDEX 301;

  FUNCTION GPIQueryCharExtra;
    EXTERNAL 'PMGPI' INDEX 302;
  FUNCTION GPI16QueryCharExtra;
    EXTERNAL 'PMGPI' INDEX 302;

  FUNCTION GPISetCharExtra;
    EXTERNAL 'PMGPI' INDEX 303;
  FUNCTION GPI16SetCharExtra;
    EXTERNAL 'PMGPI' INDEX 303;

  FUNCTION GPIQueryCharBreakExtra;
    EXTERNAL 'PMGPI' INDEX 304;
  FUNCTION GPI16QueryCharBreakExtra;
    EXTERNAL 'PMGPI' INDEX 304;

  FUNCTION GPISetCharBreakExtra;
    EXTERNAL 'PMGPI' INDEX 305;
  FUNCTION GPI16SetCharBreakExtra;
    EXTERNAL 'PMGPI' INDEX 305;

  FUNCTION GPIFrameRegion;
    EXTERNAL 'PMGPI' INDEX 306;
  FUNCTION GPI16FrameRegion;
    EXTERNAL 'PMGPI' INDEX 306;

  FUNCTION GPIConvertWithMatrix;
    EXTERNAL 'PMGPI' INDEX 307;
  FUNCTION GPI16ConvertWithMatrix;
    EXTERNAL 'PMGPI' INDEX 307;

}
{* ====================================================== *)
(*                         32 Bit                         *)
{*        Diese Funktionen sind nicht implementiert

  FUNCTION Gpi32Associate;
    EXTERNAL 'PMGPI' INDEX 351;

  FUNCTION Gpi32BeginArea;
    EXTERNAL 'PMGPI' INDEX 352;

  FUNCTION Gpi32BeginElement;
    EXTERNAL 'PMGPI' INDEX 353;

  FUNCTION Gpi32BeginPath;
    EXTERNAL 'PMGPI' INDEX 354;

  FUNCTION Gpi32BitBlt;
    EXTERNAL 'PMGPI' INDEX 355;

  FUNCTION Gpi32Box;
    EXTERNAL 'PMGPI' INDEX 356;

  FUNCTION Gpi32CallsegmentMatrix;
    EXTERNAL 'PMGPI' INDEX 357;

  FUNCTION Gpi32CharString;
    EXTERNAL 'PMGPI' INDEX 358;

  FUNCTION Gpi32CharStringAt;
    EXTERNAL 'PMGPI' INDEX 359;

  FUNCTION Gpi32CloseFigure;
    EXTERNAL 'PMGPI' INDEX 360;

  FUNCTION Gpi32CloseSegment;
    EXTERNAL 'PMGPI' INDEX 361;

  FUNCTION Gpi32CombineRegion;
    EXTERNAL 'PMGPI' INDEX 362;

  FUNCTION Gpi32Comment;
    EXTERNAL 'PMGPI' INDEX 363;

  FUNCTION Gpi32Convert;
    EXTERNAL 'PMGPI' INDEX 364;

  FUNCTION Gpi32CopyMetaFile;
    EXTERNAL 'PMGPI' INDEX 365;

  FUNCTION Gpi32CorrelateChain;
    EXTERNAL 'PMGPI' INDEX 366;

  FUNCTION Gpi32CorrelateFrom;
    EXTERNAL 'PMGPI' INDEX 367;

  FUNCTION Gpi32CreateLogFont;
    EXTERNAL 'PMGPI' INDEX 368;

  FUNCTION Gpi32CreatePS;
    EXTERNAL 'PMGPI' INDEX 369;

  FUNCTION Gpi32CreateRegion;
    EXTERNAL 'PMGPI' INDEX 370;

  FUNCTION Gpi32DeleteBitmap;
    EXTERNAL 'PMGPI' INDEX 371;

  FUNCTION Gpi32DeleteElement;
    EXTERNAL 'PMGPI' INDEX 372;

  FUNCTION Gpi32DeleteElementRange;
    EXTERNAL 'PMGPI' INDEX 373;

  FUNCTION Gpi32DeleteElementsBetweenLabels;
    EXTERNAL 'PMGPI' INDEX 374;

  FUNCTION Gpi32DeleteMetaFile;
    EXTERNAL 'PMGPI' INDEX 375;

  FUNCTION Gpi32DeleteSegment;
    EXTERNAL 'PMGPI' INDEX 376;

  FUNCTION Gpi32DeleteSegments;
    EXTERNAL 'PMGPI' INDEX 377;

  FUNCTION Gpi32DeleteSetId;
    EXTERNAL 'PMGPI' INDEX 378;

  FUNCTION Gpi32DestroyPS;
    EXTERNAL 'PMGPI' INDEX 379;

  FUNCTION Gpi32DrawChain;
    EXTERNAL 'PMGPI' INDEX 380;

  FUNCTION Gpi32DrawDynamics;
    EXTERNAL 'PMGPI' INDEX 381;

  FUNCTION Gpi32DrawFrom;
    EXTERNAL 'PMGPI' INDEX 382;

  FUNCTION Gpi32DrawSegment;
    EXTERNAL 'PMGPI' INDEX 383;

  FUNCTION Gpi32Element;
    EXTERNAL 'PMGPI' INDEX 384;

  FUNCTION Gpi32EndArea;
    EXTERNAL 'PMGPI' INDEX 385;

  FUNCTION Gpi32EndElement;
    EXTERNAL 'PMGPI' INDEX 386;

  FUNCTION Gpi32EndPath;
    EXTERNAL 'PMGPI' INDEX 387;

  FUNCTION Gpi32EqualRegion;
    EXTERNAL 'PMGPI' INDEX 388;

  FUNCTION Gpi32Erase;
    EXTERNAL 'PMGPI' INDEX 389;

  FUNCTION Gpi32ErrorSegmentData;
    EXTERNAL 'PMGPI' INDEX 390;

  FUNCTION Gpi32ExcludeClipRectangle;
    EXTERNAL 'PMGPI' INDEX 391;

  FUNCTION Gpi32FillPath;
    EXTERNAL 'PMGPI' INDEX 392;

  FUNCTION Gpi32FullArc;
    EXTERNAL 'PMGPI' INDEX 393;

  FUNCTION Gpi32GetData;
    EXTERNAL 'PMGPI' INDEX 394;

  FUNCTION Gpi32Image;
    EXTERNAL 'PMGPI' INDEX 395;

  FUNCTION Gpi32IntersectClipRectangle;
    EXTERNAL 'PMGPI' INDEX 396;

  FUNCTION Gpi32Label;
    EXTERNAL 'PMGPI' INDEX 397;

  FUNCTION Gpi32Line;
    EXTERNAL 'PMGPI' INDEX 398;

  FUNCTION Gpi32LoadBitmap;
    EXTERNAL 'PMGPI' INDEX 399;

  FUNCTION Gpi32LoadFonts;
    EXTERNAL 'PMGPI' INDEX 400;

  FUNCTION Gpi32LoadMetaFile;
    EXTERNAL 'PMGPI' INDEX 401;

  FUNCTION Gpi32Marker;
    EXTERNAL 'PMGPI' INDEX 402;

  FUNCTION Gpi32ModifyPath;
    EXTERNAL 'PMGPI' INDEX 403;

  FUNCTION Gpi32Move;
    EXTERNAL 'PMGPI' INDEX 404;

  FUNCTION Gpi32OffSetClipRegion;
    EXTERNAL 'PMGPI' INDEX 405;

  FUNCTION Gpi32OffSetElementPointer;
    EXTERNAL 'PMGPI' INDEX 406;

  FUNCTION Gpi32OffSetRegion;
    EXTERNAL 'PMGPI' INDEX 407;

  FUNCTION Gpi32OpenSegment;
    EXTERNAL 'PMGPI' INDEX 408;

  FUNCTION Gpi32PaintRegion;
    EXTERNAL 'PMGPI' INDEX 409;

(* ====================================================== *)

  FUNCTION Gpi32PlayMetaFile;
    EXTERNAL 'PMGPI' INDEX 411;

  FUNCTION Gpi32PointArc;
    EXTERNAL 'PMGPI' INDEX 412;

  FUNCTION Gpi32PolyFillet;
    EXTERNAL 'PMGPI' INDEX 413;

  FUNCTION Gpi32PolyFilletSharp;
    EXTERNAL 'PMGPI' INDEX 414;

  FUNCTION Gpi32PolyLine;
    EXTERNAL 'PMGPI' INDEX 415;

  FUNCTION Gpi32PolyMarker;
    EXTERNAL 'PMGPI' INDEX 416;

  FUNCTION Gpi32PolySpline;
    EXTERNAL 'PMGPI' INDEX 417;

  FUNCTION Gpi32Pop;
    EXTERNAL 'PMGPI' INDEX 418;

  FUNCTION Gpi32PtInRegion;
    EXTERNAL 'PMGPI' INDEX 419;

  FUNCTION Gpi32PtVisible;
    EXTERNAL 'PMGPI' INDEX 420;

  FUNCTION Gpi32PutData;
    EXTERNAL 'PMGPI' INDEX 421;

  FUNCTION Gpi32QueryArcParams;
    EXTERNAL 'PMGPI' INDEX 422;

  FUNCTION Gpi32QueryAttrMode;
    EXTERNAL 'PMGPI' INDEX 423;

  FUNCTION Gpi32QueryBackColor;
    EXTERNAL 'PMGPI' INDEX 424;

  FUNCTION Gpi32QueryBackMix;
    EXTERNAL 'PMGPI' INDEX 425;

  FUNCTION Gpi32QueryBitmapDimension;
    EXTERNAL 'PMGPI' INDEX 426;

  FUNCTION Gpi32QueryBitmapHandle;
    EXTERNAL 'PMGPI' INDEX 427;

  FUNCTION Gpi32QueryBoundaryData;
    EXTERNAL 'PMGPI' INDEX 428;

  FUNCTION Gpi32QueryCharAngle;
    EXTERNAL 'PMGPI' INDEX 429;

  FUNCTION Gpi32QueryCharBox;
    EXTERNAL 'PMGPI' INDEX 430;

  FUNCTION Gpi32QueryCharDirection;
    EXTERNAL 'PMGPI' INDEX 431;

  FUNCTION Gpi32QueryCharMode;
    EXTERNAL 'PMGPI' INDEX 432;

  FUNCTION Gpi32QueryCharSet;
    EXTERNAL 'PMGPI' INDEX 433;

  FUNCTION Gpi32QueryCharShear;
    EXTERNAL 'PMGPI' INDEX 434;

  FUNCTION Gpi32QueryClipBox;
    EXTERNAL 'PMGPI' INDEX 435;

  FUNCTION Gpi32QueryClipRegion;
    EXTERNAL 'PMGPI' INDEX 436;

  FUNCTION Gpi32QueryColor;
    EXTERNAL 'PMGPI' INDEX 437;

  FUNCTION Gpi32QueryColorData;
    EXTERNAL 'PMGPI' INDEX 438;

  FUNCTION Gpi32QueryColorIndex;
    EXTERNAL 'PMGPI' INDEX 439;

  FUNCTION Gpi32QueryCp;
    EXTERNAL 'PMGPI' INDEX 440;

  FUNCTION Gpi32QueryCurrentPosition;
    EXTERNAL 'PMGPI' INDEX 441;

  FUNCTION Gpi32QueryDefCharBox;
    EXTERNAL 'PMGPI' INDEX 442;

  FUNCTION Gpi32QueryDefaultViewMatrix;
    EXTERNAL 'PMGPI' INDEX 443;

  FUNCTION Gpi32QueryDevice;
    EXTERNAL 'PMGPI' INDEX 444;

  FUNCTION Gpi32QueryDeviceBitmapFormats;
    EXTERNAL 'PMGPI' INDEX 445;

  FUNCTION Gpi32QueryDrawControl;
    EXTERNAL 'PMGPI' INDEX 446;

  FUNCTION Gpi32QueryDrawingMode;
    EXTERNAL 'PMGPI' INDEX 447;

  FUNCTION Gpi32QueryEditMode;
    EXTERNAL 'PMGPI' INDEX 448;

  FUNCTION Gpi32QueryElement;
    EXTERNAL 'PMGPI' INDEX 449;

  FUNCTION Gpi32QueryElementPointer;
    EXTERNAL 'PMGPI' INDEX 450;

  FUNCTION Gpi32QueryElementType;
    EXTERNAL 'PMGPI' INDEX 451;

  FUNCTION Gpi32QueryFontFileDescriptions;
    EXTERNAL 'PMGPI' INDEX 452;

  FUNCTION Gpi32QueryFontMetrics;
    EXTERNAL 'PMGPI' INDEX 453;

  FUNCTION Gpi32QueryGraphicsField;
    EXTERNAL 'PMGPI' INDEX 454;

  FUNCTION Gpi32QueryInitialSegmentAttrs;
    EXTERNAL 'PMGPI' INDEX 455;

  FUNCTION Gpi32QueryKerningPairs;
    EXTERNAL 'PMGPI' INDEX 456;

  FUNCTION Gpi32QueryLineEnd;
    EXTERNAL 'PMGPI' INDEX 457;

  FUNCTION Gpi32QueryLineJoin;
    EXTERNAL 'PMGPI' INDEX 458;

  FUNCTION Gpi32QueryLineType;
    EXTERNAL 'PMGPI' INDEX 459;

  FUNCTION Gpi32QueryLineWidth;
    EXTERNAL 'PMGPI' INDEX 460;

  FUNCTION Gpi32QueryLineWidthGeom;
    EXTERNAL 'PMGPI' INDEX 461;

  FUNCTION Gpi32QueryMarker;
    EXTERNAL 'PMGPI' INDEX 462;

  FUNCTION Gpi32QueryMarkerBox;
    EXTERNAL 'PMGPI' INDEX 463;

  FUNCTION Gpi32QueryMarkerSet;
    EXTERNAL 'PMGPI' INDEX 464;

  FUNCTION Gpi32QueryMetaFileBits;
    EXTERNAL 'PMGPI' INDEX 465;

  FUNCTION Gpi32QueryMetaFileLength;
    EXTERNAL 'PMGPI' INDEX 466;

  FUNCTION Gpi32QueryMix;
    EXTERNAL 'PMGPI' INDEX 467;

  FUNCTION Gpi32QueryModelTransformMatrix;
    EXTERNAL 'PMGPI' INDEX 468;

  FUNCTION Gpi32QueryNearestColor;
    EXTERNAL 'PMGPI' INDEX 469;

  FUNCTION Gpi32QueryNumberSetIds;
    EXTERNAL 'PMGPI' INDEX 470;

  FUNCTION Gpi32QueryPS;
    EXTERNAL 'PMGPI' INDEX 471;

  FUNCTION Gpi32QueryPageViewport;
    EXTERNAL 'PMGPI' INDEX 472;

  FUNCTION Gpi32QueryPattern;
    EXTERNAL 'PMGPI' INDEX 473;

  FUNCTION Gpi32QueryPatternRefPoint;
    EXTERNAL 'PMGPI' INDEX 474;

  FUNCTION Gpi32QueryPatternSet;
    EXTERNAL 'PMGPI' INDEX 475;

  FUNCTION Gpi32QueryPel;
    EXTERNAL 'PMGPI' INDEX 476;

  FUNCTION Gpi32QueryPickAperaturePosition;
    EXTERNAL 'PMGPI' INDEX 477;

  FUNCTION Gpi32QueryPickAperatureSize;
    EXTERNAL 'PMGPI' INDEX 478;

  FUNCTION Gpi32QueryRGBColor;
    EXTERNAL 'PMGPI' INDEX 479;

  FUNCTION Gpi32QueryRealColors;
    EXTERNAL 'PMGPI' INDEX 480;

  FUNCTION Gpi32QueryRegionBox;
    EXTERNAL 'PMGPI' INDEX 481;

  FUNCTION Gpi32QuerySegmentAttrs;
    EXTERNAL 'PMGPI' INDEX 482;

  FUNCTION Gpi32QuerySegmentNames;
    EXTERNAL 'PMGPI' INDEX 483;

  FUNCTION Gpi32QuerySegmentPriority;
    EXTERNAL 'PMGPI' INDEX 484;

  FUNCTION Gpi32QuerySegmentTransformMatr;
    EXTERNAL 'PMGPI' INDEX 485;

  FUNCTION XGpi32QuerySegmentTransformMatrix;
    EXTERNAL 'PMGPI' INDEX 485;

  FUNCTION Gpi32QuerySetIds;
    EXTERNAL 'PMGPI' INDEX 486;

  FUNCTION Gpi32QueryStopDraw;
    EXTERNAL 'PMGPI' INDEX 487;

  FUNCTION Gpi32QueryTag;
    EXTERNAL 'PMGPI' INDEX 488;

  FUNCTION Gpi32QueryTextBox;
    EXTERNAL 'PMGPI' INDEX 489;

  FUNCTION Gpi32QueryViewingLimits;
    EXTERNAL 'PMGPI' INDEX 490;

  FUNCTION Gpi32QueryViewingTransformMatr;
    EXTERNAL 'PMGPI' INDEX 491;

  FUNCTION XGpi32QueryViewingTransformMatrix;
    EXTERNAL 'PMGPI' INDEX 491;

  FUNCTION Gpi32QueryWidthTable;
    EXTERNAL 'PMGPI' INDEX 492;

(* ====================================================== *)

  FUNCTION Gpi32RectInRegion;
    EXTERNAL 'PMGPI' INDEX 494;

  FUNCTION Gpi32RectVisible;
    EXTERNAL 'PMGPI' INDEX 495;

  FUNCTION Gpi32RemoveDynamics;
    EXTERNAL 'PMGPI' INDEX 496;

  FUNCTION Gpi32ReSetBoundaryData;
    EXTERNAL 'PMGPI' INDEX 497;

  FUNCTION Gpi32ReSetPS;
    EXTERNAL 'PMGPI' INDEX 498;

  FUNCTION Gpi32RestorePS;
    EXTERNAL 'PMGPI' INDEX 499;

  FUNCTION Gpi32SaveMetaFile;
    EXTERNAL 'PMGPI' INDEX 500;

  FUNCTION Gpi32SavePS;
    EXTERNAL 'PMGPI' INDEX 501;

  FUNCTION Gpi32SetArcParams;
    EXTERNAL 'PMGPI' INDEX 502;

  FUNCTION Gpi32SetAttrMode;
    EXTERNAL 'PMGPI' INDEX 503;

  FUNCTION Gpi32SetBackColor;
    EXTERNAL 'PMGPI' INDEX 504;

  FUNCTION Gpi32SetBackMix;
    EXTERNAL 'PMGPI' INDEX 505;

  FUNCTION Gpi32SetBitmap;
    EXTERNAL 'PMGPI' INDEX 506;

  FUNCTION Gpi32SetBitmapDimension;
    EXTERNAL 'PMGPI' INDEX 507;

  FUNCTION Gpi32SetBitmapId;
    EXTERNAL 'PMGPI' INDEX 508;

  FUNCTION Gpi32SetCharAngle;
    EXTERNAL 'PMGPI' INDEX 509;

  FUNCTION Gpi32SetCharBox;
    EXTERNAL 'PMGPI' INDEX 510;

  FUNCTION Gpi32SetCharDirection;
    EXTERNAL 'PMGPI' INDEX 511;

  FUNCTION Gpi32SetCharMode;
    EXTERNAL 'PMGPI' INDEX 512;

  FUNCTION Gpi32SetCharSet;
    EXTERNAL 'PMGPI' INDEX 513;

  FUNCTION Gpi32SetCharShear;
    EXTERNAL 'PMGPI' INDEX 514;

  FUNCTION Gpi32SetClipPath;
    EXTERNAL 'PMGPI' INDEX 515;

  FUNCTION Gpi32SetClipRegion;
    EXTERNAL 'PMGPI' INDEX 516;

  FUNCTION Gpi32SetColor;
    EXTERNAL 'PMGPI' INDEX 517;

  FUNCTION Gpi32SetCp;
    EXTERNAL 'PMGPI' INDEX 518;

  FUNCTION Gpi32SetCurrentPosition;
    EXTERNAL 'PMGPI' INDEX 519;

  FUNCTION Gpi32SetDefaultViewMatrix;
    EXTERNAL 'PMGPI' INDEX 520;

  FUNCTION Gpi32SetDrawControl;
    EXTERNAL 'PMGPI' INDEX 521;

  FUNCTION Gpi32SetDrawingMode;
    EXTERNAL 'PMGPI' INDEX 522;

  FUNCTION Gpi32SetEditMode;
    EXTERNAL 'PMGPI' INDEX 523;

  FUNCTION Gpi32SetElementPointer;
    EXTERNAL 'PMGPI' INDEX 524;

  FUNCTION Gpi32SetElementPointerAtLabel;
    EXTERNAL 'PMGPI' INDEX 525;

  FUNCTION Gpi32SetGraphicsField;
    EXTERNAL 'PMGPI' INDEX 526;

  FUNCTION Gpi32SetInitialSegmentAttrs;
    EXTERNAL 'PMGPI' INDEX 527;

  FUNCTION Gpi32SetLineEnd;
    EXTERNAL 'PMGPI' INDEX 528;

  FUNCTION Gpi32SetLineJoin;
    EXTERNAL 'PMGPI' INDEX 529;

  FUNCTION Gpi32SetLineType;
    EXTERNAL 'PMGPI' INDEX 530;

  FUNCTION Gpi32SetLineWidth;
    EXTERNAL 'PMGPI' INDEX 531;

  FUNCTION Gpi32SetLineWidthGeom;
    EXTERNAL 'PMGPI' INDEX 532;

  FUNCTION Gpi32SetMarker;
    EXTERNAL 'PMGPI' INDEX 533;

  FUNCTION Gpi32SetMarkerBox;
    EXTERNAL 'PMGPI' INDEX 534;

  FUNCTION Gpi32SetMarkerSet;
    EXTERNAL 'PMGPI' INDEX 535;

  FUNCTION Gpi32SetMetaFileBits;
    EXTERNAL 'PMGPI' INDEX 536;

  FUNCTION GPI32SetMix;
    EXTERNAL 'PMGPI' INDEX 537;

  FUNCTION GPI32SetModelTransformMatrix;
    EXTERNAL 'PMGPI' INDEX 538;

  FUNCTION GPI32SetPS;
    EXTERNAL 'PMGPI' INDEX 539;

  FUNCTION GPI32SetPageViewport;
    EXTERNAL 'PMGPI' INDEX 540;

  FUNCTION GPI32SetPattern;
    EXTERNAL 'PMGPI' INDEX 541;

  FUNCTION GPI32SetPatternRefPoint;
    EXTERNAL 'PMGPI' INDEX 542;

  FUNCTION GPI32SetPatternSet;
    EXTERNAL 'PMGPI' INDEX 543;

  FUNCTION GPI32SetPel;
    EXTERNAL 'PMGPI' INDEX 544;

  FUNCTION GPI32SetPickAperaturePosition;
    EXTERNAL 'PMGPI' INDEX 545;

  FUNCTION GPI32SetRegion;
    EXTERNAL 'PMGPI' INDEX 546;

  FUNCTION GPI32SetSegmentAttrs;
    EXTERNAL 'PMGPI' INDEX 547;

  FUNCTION GPI32SetSegmentPriority;
    EXTERNAL 'PMGPI' INDEX 548;

  FUNCTION GPI32SetSegmentTransformMatrix;
    EXTERNAL 'PMGPI' INDEX 549;

  FUNCTION GPI32SetStopDraw;
    EXTERNAL 'PMGPI' INDEX 550;

  FUNCTION GPI32SetTag;
    EXTERNAL 'PMGPI' INDEX 551;

  FUNCTION GPI32SetViewingLimits;
    EXTERNAL 'PMGPI' INDEX 552;

  FUNCTION GPI32SetViewingTransformMatrix;
    EXTERNAL 'PMGPI' INDEX 553;

  FUNCTION GPI32StrokePath;
    EXTERNAL 'PMGPI' INDEX 554;

  FUNCTION GPI32UnloadFonts;
    EXTERNAL 'PMGPI' INDEX 555;

  FUNCTION GPI32WCBitBlt;
    EXTERNAL 'PMGPI' INDEX 557;

  FUNCTION GPI32PolyLineDisjoint;
    EXTERNAL 'PMGPI' INDEX 558;

  FUNCTION GPI32PathToRegion;
    EXTERNAL 'PMGPI' INDEX 559;

  FUNCTION GPI32FloodFill;
    EXTERNAL 'PMGPI' INDEX 560;

  FUNCTION GPI32SuspendPlay;
    EXTERNAL 'PMGPI' INDEX 561;

  FUNCTION GPI32ResumePlay;
    EXTERNAL 'PMGPI' INDEX 562;

  FUNCTION GPI32OutlinePath;
    EXTERNAL 'PMGPI' INDEX 563;

  FUNCTION GPI32Translate;
    EXTERNAL 'PMGPI' INDEX 564;

  FUNCTION GPI32Scale;
    EXTERNAL 'PMGPI' INDEX 565;

  FUNCTION GPI32Rotate;
    EXTERNAL 'PMGPI' INDEX 566;

  FUNCTION GPI32QueryDefArcParams;
    EXTERNAL 'PMGPI' INDEX 567;

  FUNCTION GPI32QueryDefTag;
    EXTERNAL 'PMGPI' INDEX 568;

  FUNCTION GPI32QueryDefViewingLimits;
    EXTERNAL 'PMGPI' INDEX 569;

  FUNCTION GPI32SetDefArcParams;
    EXTERNAL 'PMGPI' INDEX 570;

  FUNCTION GPI32SetDefTag;
    EXTERNAL 'PMGPI' INDEX 571;

  FUNCTION GPI32SetDefViewingLimits;
    EXTERNAL 'PMGPI' INDEX 572;

  FUNCTION GPI32QueryBitmapParameters;
    EXTERNAL 'PMGPI' INDEX 573;

  FUNCTION GPI32QueryLogicalFont;
    EXTERNAL 'PMGPI' INDEX 574;

  FUNCTION GPI32QueryFaceString;
    EXTERNAL 'PMGPI' INDEX 575;

  FUNCTION GPI32QueryFontAction;
    EXTERNAL 'PMGPI' INDEX 576;

  FUNCTION GPI32DeletePalette;
    EXTERNAL 'PMGPI' INDEX 577;

  FUNCTION GPI32SelectPalette;
    EXTERNAL 'PMGPI' INDEX 578;

  FUNCTION GPI32QueryPalette;
    EXTERNAL 'PMGPI' INDEX 579;

  FUNCTION GPI32CharStringPos;
    EXTERNAL 'PMGPI' INDEX 580;

  FUNCTION GPI32CharStringPosAt;
    EXTERNAL 'PMGPI' INDEX 581;

  FUNCTION GPI32CorrelateSegment;
    EXTERNAL 'PMGPI' INDEX 582;

  FUNCTION GPI32QueryAttrs;
    EXTERNAL 'PMGPI' INDEX 583;

  FUNCTION GPI32QueryCharStringPos;
    EXTERNAL 'PMGPI' INDEX 584;

  FUNCTION GPI32QueryCharStringPosAt;
    EXTERNAL 'PMGPI' INDEX 585;

  FUNCTION GPI32QueryFonts;
    EXTERNAL 'PMGPI' INDEX 586;

  FUNCTION GPI32QueryRegionRects;
    EXTERNAL 'PMGPI' INDEX 587;

  FUNCTION GPI32SetAttrs;
    EXTERNAL 'PMGPI' INDEX 588;

  FUNCTION GPI32SetPickAperatureSize;
    EXTERNAL 'PMGPI' INDEX 589;

  FUNCTION GPI32QueryDefAttrs;
    EXTERNAL 'PMGPI' INDEX 590;

  FUNCTION GPI32SetDefAttrs;
    EXTERNAL 'PMGPI' INDEX 591;

  FUNCTION GPI32CreateLogColorTable;
    EXTERNAL 'PMGPI' INDEX 592;

  FUNCTION GPI32QueryLogColorTable;
    EXTERNAL 'PMGPI' INDEX 593;

  FUNCTION GPI32CreatePalette;
    EXTERNAL 'PMGPI' INDEX 594;

  FUNCTION GPI32AnimatePalette;
    EXTERNAL 'PMGPI' INDEX 595;

  FUNCTION GPI32SetPaletteEntries;
    EXTERNAL 'PMGPI' INDEX 596;

  FUNCTION GPI32QueryPaletteInfo;
    EXTERNAL 'PMGPI' INDEX 597;

  FUNCTION GPI32CreateBitmap;
    EXTERNAL 'PMGPI' INDEX 598;

  FUNCTION GPI32QueryBitmapBits;
    EXTERNAL 'PMGPI' INDEX 599;

(* ====================================================== *)

  FUNCTION GPI32QueryBitmapInfoHeader;
    EXTERNAL 'PMGPI' INDEX 601;

  FUNCTION GPI32SetBitmapBits;
    EXTERNAL 'PMGPI' INDEX 602;

  FUNCTION GPI32DrawBits;
    EXTERNAL 'PMGPI' INDEX 603;

  FUNCTION Dev32CloseDC;
    EXTERNAL 'PMGPI' INDEX 604;

  FUNCTION Dev32Escape;
    EXTERNAL 'PMGPI' INDEX 605;

  FUNCTION Dev32QueryCaps;
    EXTERNAL 'PMGPI' INDEX 606;

  FUNCTION Dev32QueryDeviceNames;
    EXTERNAL 'PMGPI' INDEX 607;

  FUNCTION Dev32QueryHardcopyCaps;
    EXTERNAL 'PMGPI' INDEX 608;

  FUNCTION Dev32PostDeviceModes;
    EXTERNAL 'PMGPI' INDEX 609;

  FUNCTION Dev32OpenDC;
    EXTERNAL 'PMGPI' INDEX 610;

  FUNCTION GPI32DestroyRegion;
    EXTERNAL 'PMGPI' INDEX 611;

  FUNCTION GPI32PartialArc;
    EXTERNAL 'PMGPI' INDEX 612;

  FUNCTION GPI32QueryCharExtra;
    EXTERNAL 'PMGPI' INDEX 613;

  FUNCTION GPI32SetCharExtra;
    EXTERNAL 'PMGPI' INDEX 614;

  FUNCTION GPI32QueryCharBreakExtra;
    EXTERNAL 'PMGPI' INDEX 615;

  FUNCTION GPI32SetCharBreakExtra;
    EXTERNAL 'PMGPI' INDEX 616;

  FUNCTION GPI32FrameRegion;
    EXTERNAL 'PMGPI' INDEX 617;

  FUNCTION GPI32ConvertWithMatrix;
    EXTERNAL 'PMGPI' INDEX 618;

(* ====================================================== *)

  FUNCTION GPI32LoadPublicFonts;
    EXTERNAL 'PMGPI' INDEX 622;

  FUNCTION GPI32UnloadPublicFonts;
    EXTERNAL 'PMGPI' INDEX 623;

  FUNCTION GPI32QueryTextAlignment;
    EXTERNAL 'PMGPI' INDEX 648;

  FUNCTION GPI32SetTextAlignment;
    EXTERNAL 'PMGPI' INDEX 649;

  FUNCTION GPI32Polygons;
    EXTERNAL 'PMGPI' INDEX 650;

  FUNCTION GPI32QueryFullFontFileDescs;
    EXTERNAL 'PMGPI' INDEX 657;
}

END.

(* ====================================================== *)
(*                  Ende von PMGPI.PAS                    *)
