(* ====================================================== *)
(*                       MOUCALLS.PAS                     *)
(*     Implementation of the functions of MOUCALLS.DLL    *)
(*           Translation to Pascal by jb / toolbox mag    *)
(* =====================================================  *)
{$IFNDEF OS2}
  Error: Wrong target/Compiler not patched
{$ENDIF}

UNIT MouCalls;

INTERFACE

USES
  Os2Def;

CONST
  MR_MOUGETNUMBUTTONS    = $00000001;
  MR_MOUGETNUMMICKEYS    = $00000002;
  MR_MOUGETDEVSTATUS     = $00000004;
  MR_MOUGETNUMQUEEL      = $00000008;
  MR_MOUREADEVENTQUE     = $00000010;
  MR_MOUGETSCALEFACT     = $00000020;
  MR_MOUGETEVENTMASK     = $00000040;
  MR_MOUSETSCALEFACT     = $00000080;
  MR_MOUSETEVENTMASK     = $00000100;
  MR_MOUOPEN             = $00000800;
  MR_MOUCLOSE            = $00001000;
  MR_MOUGETPTRSHAPE      = $00002000;
  MR_MOUSETPTRSHAPE      = $00004000;
  MR_MOUDRAWPTR          = $00008000;
  MR_MOUREMOVEPTR        = $00010000;
  MR_MOUGETPTRPOS        = $00020000;
  MR_MOUSETPTRPOS        = $00040000;
  MR_MOUINITREAL         = $00080000;
  MR_MOUSETDEVSTATUS     = $00100000;

  MHK_BUTTON1            = 1;
  MHK_BUTTON2            = 2;
  MHK_BUTTON3            = 4;

  MOUSE_QUEUEBUSY        = $0001;
  MOUSE_BLOCKREAD        = $0002;
  MOUSE_FLUSH            = $0004;
  MOUSE_UNSUPPORTED_MODE = $0008;
  MOUSE_DISABLED         = $0100;
  MOUSE_MICKEYS          = $0200;

  MOU_NODRAW             = $0001;
  MOU_DRAW               = $0000;
  MOU_MICKEYS            = $0002;
  MOU_PELS               = $0000;

TYPE
  MouQueInfo = RECORD
    cEvents     : WORD;
    cmaxEvents  : WORD;
  END;

  PtrLoc = RECORD
    row   : WORD;
    col   : WORD;
  END;

  PtrShape = RECORD
    cb     : WORD;       (* size in bytes of the bitmasks *)
    col    : WORD;       (* width of the masks            *)
    row    : WORD;       (* height of the masks           *)
    colHot : WORD;       (* x coordinate of hot spot      *)
    rowHot : WORD;       (* y coordinate of hot spot      *)
  END;

  ScaleFact = RECORD
    rowScale      : WORD;
    colScale      : WORD;
  END;

  MouEventInfo = RECORD
    fs            : WORD;
    time          : LongInt;
    row           : WORD;
    col           : WORD;
  END;

  NoPtrRect = RECORD
    row   : WORD;
    col   : WORD;
    cRow  : WORD;
    cCol  : WORD;
  END;


FUNCTION MouClose(Handle   : WORD) : WORD;
FUNCTION Mou16Close(Handle : WORD) : WORD;

FUNCTION MouDeRegister  : WORD;
FUNCTION Mou16DeRegister: WORD;

FUNCTION MouDrawPtr(Handle   : WORD) : WORD;
FUNCTION Mou16DrawPtr(Handle : WORD) : WORD;

FUNCTION MouFlushQue(Handle   : WORD) : WORD;
FUNCTION Mou16FlushQue(Handle : WORD) : WORD;

FUNCTION MouGetDevStatus(  VAR Status : WORD;
                               Handle : WORD) : WORD;
FUNCTION Mou16GetDevStatus(VAR Status : WORD;
                               Handle : WORD) : WORD;

TYPE
  MouseEvent = (
    MotionOnly,
    MotionAndButton1,
    Button1,
    MotionAndButton2,
    Button2,
    MotionAndButton3,
    Button3,
    Reserved1,
    Reserved2,
    Reserved3,
    Reserved4,
    Reserved5,
    Reserved6,
    Reserved7,
    Reserved8,
    Reserved9);

TYPE
  MouseEventSet = SET OF MouseEvent;

FUNCTION MouGetEventMask(  VAR Mask   : WORD;
                               Handle : WORD) : WORD;
FUNCTION Mou16GetEventMask(VAR Mask   : WORD;
                               Handle : WORD) : WORD;

FUNCTION MouGetNumButtons(  VAR NumButtons : WORD;
                                Handle     : WORD) : WORD;
FUNCTION Mou16GetNumButtons(VAR NumButtons : WORD;
                                Handle     : WORD) : WORD;

FUNCTION MouGetNumMickeys(  VAR MickeysPerCentimeter : WORD;
                                Handle               : WORD
                                                    ): WORD;
FUNCTION Mou16GetNumMickeys(VAR MickeysPerCentimeter : WORD;
                                Handle               : WORD
                                                   ) : WORD;

FUNCTION MouGetNumQueEl(  VAR Status : MouQueInfo;
                              Handle : WORD) : WORD;
FUNCTION Mou16GetNumQueEl(VAR Status : MouQueInfo;
                              Handle : WORD) : WORD;

(* Mouse pointer location data structure *)

FUNCTION MouGetPtrPos(  VAR Position : PtrLoc;
                            Handle   : WORD) : WORD;
FUNCTION Mou16GetPtrPos(VAR Position : PtrLoc;
                            Handle   : WORD) : WORD;

FUNCTION MouGetPtrShape(      Buffer    : Pointer;
                          VAR ShapeInfo : PtrShape;
                              Handle    : WORD) : WORD;
FUNCTION Mou16GetPtrShape(    Buffer    : Pointer;
                          VAR ShapeInfo : PtrShape;
                              Handle    : WORD) : WORD;

FUNCTION MouGetScaleFact(  VAR Scale  : ScaleFact;
                               Handle : WORD) : WORD;
FUNCTION Mou16GetScaleFact(VAR Scale  : ScaleFact;
                               Handle : WORD) : WORD;

FUNCTION MouOpen(     DrawDeviceName : Pointer;
                   VAR Handle        : WORD) : WORD;
FUNCTION Mou16Open(   DrawDeviceName : Pointer;
                   VAR Handle        : WORD) : WORD;

FUNCTION MouReadEventQue(  VAR Event  : MouEventInfo;
                           VAR Wait   : WORD;
                               Handle : WORD) : WORD;
FUNCTION Mou16ReadEventQue(VAR Event  : MouEventInfo;
                           VAR Wait   : WORD;
                               Handle : WORD) : WORD;

FUNCTION MouRegister(  aLibrary,
                       EntryPoint : Pointer;
                       Mask       : LongInt) : WORD;
FUNCTION Mou16Register(aLibrary,
                       EntryPoint : Pointer;
                       Mask       : LongInt) : WORD;

FUNCTION MouRemovePtr(  Area   : NoPtrRect;
                        Handle : WORD) : WORD;
FUNCTION Mou16RemovePtr(Area   : NoPtrRect;
                        Handle : WORD) : WORD;

FUNCTION MouSetDevStatus(  VAR Status : WORD;
                               Handle : WORD) : WORD;
FUNCTION Mou16SetDevStatus(VAR Status : WORD;
                               Handle : WORD) : WORD;

FUNCTION MouSetEventMask(  VAR Mask   : WORD;
                               Handle : WORD) : WORD;
FUNCTION Mou16SetEventMask(VAR Mask   : WORD;
                               Handle : WORD) : WORD;

FUNCTION MouSetPtrPos(  VAR Pos    : PtrLoc;
                            Handle : WORD) : WORD;
FUNCTION Mou16SetPtrPos(VAR Pos    : PtrLoc;
                            Handle : WORD) : WORD;

FUNCTION MouSetPtrShape(  Buffer    : Pointer;
                          ShapeInfo : PtrShape;
                          Handle    : WORD) : WORD;
FUNCTION Mou16SetPtrShape(Buffer    : Pointer;
                          ShapeInfo : PtrShape;
                          Handle    : WORD) : WORD;

FUNCTION MouSetScaleFact(  VAR Scale  : ScaleFact;
                               Handle : WORD) : WORD;
FUNCTION Mou16SetScaleFact(VAR Scale  : ScaleFact;
                               Handle : WORD) : WORD;

FUNCTION MouInitReal(  a : Pointer) : WORD;
FUNCTION Mou16InitReal(a : Pointer) : WORD;

FUNCTION MouSynch(  a : WORD) : WORD;
FUNCTION Mou16Synch(a : WORD) : WORD;

IMPLEMENTATION

  FUNCTION MouGetPtrShape;     EXTERNAL 'MouCalls' INDEX  1;
  FUNCTION Mou16GetPtrShape;   EXTERNAL 'MouCalls' INDEX  1;

  FUNCTION MouSetPtrShape;     EXTERNAL 'MouCalls' INDEX  2;
  FUNCTION Mou16SetPtrShape;   EXTERNAL 'MouCalls' INDEX  2;

  FUNCTION MouGetNumMickeys;   EXTERNAL 'MouCalls' INDEX  3;
  FUNCTION Mou16GetNumMickeys; EXTERNAL 'MouCalls' INDEX  3;

{                     NOT IMPLEMENTED
  FUNCTION MouGetHotkey;       External 'MouCalls' INDEX  4;
  FUNCTION Mou16GetHotkey;     External 'MouCalls' INDEX  4;
}

(* ====================================================== *)

  FUNCTION MouGetScaleFact;    EXTERNAL 'MouCalls' INDEX  6;
  FUNCTION Mou16GetScaleFact;  EXTERNAL 'MouCalls' INDEX  6;

  FUNCTION MouFlushQue;        EXTERNAL 'MouCalls' INDEX  7;
  FUNCTION Mou16FlushQue;      EXTERNAL 'MouCalls' INDEX  7;

  FUNCTION MouGetNumButtons;   EXTERNAL 'MouCalls' INDEX  8;
  FUNCTION Mou16GetNumButtons; EXTERNAL 'MouCalls' INDEX  8;

  FUNCTION MouClose;           EXTERNAL 'MouCalls' INDEX  9;
  FUNCTION Mou16Close;         EXTERNAL 'MouCalls' INDEX  9;

{                      NOT IMPLEMENTED
  FUNCTION MouSetHotkey;       External 'MouCalls' INDEX 10;
  FUNCTION Mou16SetHotkey;     External 'MouCalls' INDEX 10;
}
  FUNCTION MouSetScaleFact;    EXTERNAL 'MouCalls' INDEX 11;
  FUNCTION Mou16SetScaleFact;  EXTERNAL 'MouCalls' INDEX 11;

(* ====================================================== *)

  FUNCTION MouGetNumQueEl;     EXTERNAL 'MouCalls' INDEX 13;
  FUNCTION Mou16GetNumQueEl;   EXTERNAL 'MouCalls' INDEX 13;

  FUNCTION MouDeRegister;      EXTERNAL 'MouCalls' INDEX 14;
  FUNCTION Mou16DeRegister;    EXTERNAL 'MouCalls' INDEX 14;

  FUNCTION MouGetEventMask;    EXTERNAL 'MouCalls' INDEX 15;
  FUNCTION Mou16GetEventMask;  EXTERNAL 'MouCalls' INDEX 15;

  FUNCTION MouSetEventMask;    EXTERNAL 'MouCalls' INDEX 16;
  FUNCTION Mou16SetEventMask;  EXTERNAL 'MouCalls' INDEX 16;

  FUNCTION MouOpen;            EXTERNAL 'MouCalls' INDEX 17;
  FUNCTION Mou16Open;          EXTERNAL 'MouCalls' INDEX 17;

  FUNCTION MouRemovePtr;       EXTERNAL 'MouCalls' INDEX 18;
  FUNCTION Mou16RemovePtr;     EXTERNAL 'MouCalls' INDEX 18;

  FUNCTION MouGetPtrPos;       EXTERNAL 'MouCalls' INDEX 19;
  FUNCTION Mou16GetPtrPos;     EXTERNAL 'MouCalls' INDEX 19;

  FUNCTION MouReadEventQue;    EXTERNAL 'MouCalls' INDEX 20;
  FUNCTION Mou16ReadEventQue;  EXTERNAL 'MouCalls' INDEX 20;

  FUNCTION MouSetPtrPos;       EXTERNAL 'MouCalls' INDEX 21;
  FUNCTION Mou16SetPtrPos;     EXTERNAL 'MouCalls' INDEX 21;

  FUNCTION MouGetDevStatus;    EXTERNAL 'MouCalls' INDEX 22;
  FUNCTION Mou16GetDevStatus;  EXTERNAL 'MouCalls' INDEX 22;

  FUNCTION MouSynch;           EXTERNAL 'MouCalls' INDEX 23;
  FUNCTION Mou16Synch;         EXTERNAL 'MouCalls' INDEX 23;

  FUNCTION MouRegister;        EXTERNAL 'MouCalls' INDEX 24;
  FUNCTION Mou16Register;      EXTERNAL 'MouCalls' INDEX 24;

  FUNCTION MouSetDevStatus;    EXTERNAL 'MouCalls' INDEX 25;
  FUNCTION Mou16SetDevStatus;  EXTERNAL 'MouCalls' INDEX 25;

  FUNCTION MouDrawPtr;         EXTERNAL 'MouCalls' INDEX 26;
  FUNCTION Mou16DrawPtr;       EXTERNAL 'MouCalls' INDEX 26;

  FUNCTION MouInitReal;        EXTERNAL 'MouCalls' INDEX 27;
  FUNCTION Mou16InitReal;      EXTERNAL 'MouCalls' INDEX 27;

(* ====================================================== *)

{                         NOT IMPLEMENTED:
  FUNCTION MouSetThreshold;    External 'MouCalls' INDEX 29;
  FUNCTION Mou16SetThreshold;  External 'MouCalls' INDEX 29;

  FUNCTION MouGetThreshold;    External 'MouCalls' INDEX 30;
  FUNCTION Mou16GetThreshold;  External 'MouCalls' INDEX 30;
}

END.

(* ====================================================== *)
(*                  Ende von MOUCALLS.PAS                 *)
