(* ====================================================== *)
(*                         MONCALLS.PAS                   *)
(*     Implementation of the functions of MONCALLS.DLL    *)
(*           Translation to Pascal by jb/toolbox mag      *)
(* ====================================================== *)
{$IFNDef OS2}
  Error: Wrong target/Compiler not patched
{$EndIF}

UNIT MonCalls;

INTERFACE

USES
  Os2Def;

(* Terminate device monitoring                            *)
FUNCTION DosMonClose(  Handle: WORD) : WORD;
                    (* ^^^ handle from DosMonOpen *)
FUNCTION Dos16MonClose(Handle: WORD) : WORD;

(* Open a device monitor                                  *)
FUNCTION DosMonOpen(    DevName: pChar;        (* ASCIIZ: the device name *)
                    VAR Handle : WORD          (* returned monitor handle *)
                             ) : WORD;
FUNCTION Dos16MonOpen(    DevName : pChar;     (* ASCIIZ: the device name *)
                      VAR Handle  : WORD       (* returned monitor handle *)
                                ) : WORD;

(* Read from device monitor stream                        *)
FUNCTION DosMonRead(    BufferI    : Pointer;  (* address of input buffer *)
                        WaitFlag   : WORD;     (* 0 => wait, 1 => nowait  *)
                        DataBuffer : Pointer;  (* buffer to read into     *)
                    VAR ByteCnt    : WORD      (* In out byte count       *)
                                 ) : WORD;
FUNCTION Dos16MonRead(   BufferI   : Pointer;  (* address of input buffer *)
                         WaitFlag  : WORD;     (* 0 => wait, 1 => nowait  *)
                         DataBuffer: Pointer;  (* buffer to read into     *)
                      VAR ByteCnt  : WORD      (* In out byte count       *)
                                 ) : WORD;


(* Register device monitor buffers.  First word in each   *)
(* buffer must be the total length of buffer 128 bytes    *)
(* recommended                                            *)
FUNCTION DosMonReg(  Handle  : WORD;    (* handle from DosMonOpen           *)
                     BufferI : Pointer; (* input buffer to register         *)
                     BufferO : Pointer; (* output buffer to register        *)
                     PosFlag : WORD;    (* 0=>don't care, 1=>first, 2=>last *)
                     usIndex : WORD
                           ) : WORD;
FUNCTION Dos16MonReg(Handle  : WORD;    (* handle from DosMonOpen           *)
                     BufferI : Pointer; (* input buffer to register         *)
                     BufferO : Pointer; (* output buffer to register        *)
                     PosFlag : WORD;    (* 0=>don't care, 1=>first, 2=>last *)
                     usIndex : WORD
                           ) : WORD;


(* Write to device monitor stream                         *)
FUNCTION DosMonWrite(  BufferO   : Pointer; (* address of monitor output buffer *)
                       DataBuffer: Pointer; (* address of data to write     *)
                       ByteCnt   : WORD     (* length of data to write      *)
                               ) : WORD;
FUNCTION Dos16MonWrite(BufferO   : Pointer; (* address of monitor output buffer *)
                       DataBuffer: Pointer; (* address of data to write     *)
                       ByteCnt   : WORD     (* length of data to write      *)
                               ) : WORD;


IMPLEMENTATION

  FUNCTION DosMonWrite;   EXTERNAL 'MonCalls' INDEX   1;
  FUNCTION Dos16MonWrite; EXTERNAL 'MonCalls' INDEX   1;

  FUNCTION DosMonRead;    EXTERNAL 'MonCalls' INDEX   2;
  FUNCTION Dos16MonRead;  EXTERNAL 'MonCalls' INDEX   2;

  FUNCTION DosMonClose;   EXTERNAL 'MonCalls' INDEX   3;
  FUNCTION Dos16MonClose; EXTERNAL 'MonCalls' INDEX   3;

  FUNCTION DosMonOpen;    EXTERNAL 'MonCalls' INDEX   4;
  FUNCTION Dos16MonOpen;  EXTERNAL 'MonCalls' INDEX   4;

  FUNCTION DosMonReg;     EXTERNAL 'MonCalls' INDEX   5;
  FUNCTION Dos16MonReg;   EXTERNAL 'MonCalls' INDEX   5;

END.

(* ====================================================== *)
