/*  stdlib.h

    Definitions for common types, variables, and functions.

*/

/*
 *      C/C++ Run Time Library - Version 1.5
 *
 *      Copyright (c) 1987, 1994 by Borland International
 *      All Rights Reserved.
 *
 */

#ifndef __STDLIB_H
#define __STDLIB_H

#if !defined(___DEFS_H)
#include <_defs.h>
#endif

#ifndef NULL
#include <_null.h>
#endif


#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn -nak
#endif

#pragma option -a-

#endif  /* !RC_INVOKED */


#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

#ifndef _DIV_T
#define _DIV_T
typedef struct {
        int     quot;
        int     rem;
} div_t;
#endif

#ifndef _LDIV_T
#define _LDIV_T
typedef struct {
        long    quot;
        long    rem;
} ldiv_t;
#endif

#ifndef __cplusplus
#ifndef _WCHAR_T
#define _WCHAR_T
typedef unsigned short wchar_t;
#endif
#endif

#define MB_CUR_MAX 1

/* Maximum value returned by "rand" function
*/
#define RAND_MAX 0x7FFFU

#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1

typedef void (_USERENTRY * atexit_t)(void);

/*
  These 2 constants are defined in MS's stdlib.h.
*/

#define DOS_MODE    0  /* DOS 16-bit */
#define OS2_MODE    1  /* OS/2 16-bit */



#ifdef __cplusplus
extern "C" {
#endif

void        _RTLENTRY _EXPFUNC abort(void);

#if !defined(__ABS_DEFINED)
#define __ABS_DEFINED

int         _RTLENTRY __abs__(int);
#ifdef __cplusplus
inline int _RTLENTRY  abs(int __x) { return __abs__(__x); }
#else
int         _RTLENTRYF _EXPFUNC abs(int __x);
#  define abs(x)   __abs__(x)
#endif

#endif /* __ABS_DEFINED */

int         _RTLENTRY   _EXPFUNC atexit(void (_USERENTRY * __func)(void));
double      _RTLENTRY   _EXPFUNC atof(const char * __s);
int         _RTLENTRYF  _EXPFUNC atoi(const char * __s);
long        _RTLENTRYF  _EXPFUNC atol(const char * __s);
void *      _RTLENTRYF  _EXPFUNC bsearch(const void * __key, const void * __base,
                           size_t __nelem, size_t __width,
                           int (_USERENTRY *fcmp)(const void *,
                           const void *));
void *      _RTLENTRY _EXPFUNC   calloc(size_t __nitems, size_t __size);
div_t       _RTLENTRY _EXPFUNC   div(int __numer, int __denom);
void        _RTLENTRY _EXPFUNC   exit(int __status);
void        _RTLENTRY _EXPFUNC   free(void * __block);
char *      _RTLENTRYF _EXPFUNC  getenv(const char * __name);
long        _RTLENTRY _EXPFUNC   labs(long __x);
ldiv_t      _RTLENTRY _EXPFUNC   ldiv(long __numer, long __denom);
void *      _RTLENTRY _EXPFUNC   malloc(size_t __size);
int         _RTLENTRY _EXPFUNC   mblen(const char * __s, size_t __n);
size_t      _RTLENTRY _EXPFUNC   mbstowcs(wchar_t *__pwcs, const char * __s,
                           size_t __n);
int         _RTLENTRY _EXPFUNC   mbtowc(wchar_t *__pwc, const char * __s, size_t __n);
void        _RTLENTRYF _EXPFUNC  qsort(void * __base, size_t __nelem, size_t __width,
                           int (_USERENTRY *__fcmp)(const void *, const void *));
int         _RTLENTRY _EXPFUNC   rand(void);
void *      _RTLENTRY _EXPFUNC   realloc(void * __block, size_t __size);
void        _RTLENTRY _EXPFUNC   srand(unsigned __seed);
double      _RTLENTRY _EXPFUNC   strtod(const char * __s, char * *__endptr);
long        _RTLENTRY _EXPFUNC   strtol(const char * __s, char * *__endptr,
                           int __radix);
long double _RTLENTRY _EXPFUNC   _strtold(const char * __s, char * *__endptr);
unsigned long _RTLENTRY _EXPFUNC strtoul(const char * __s, char * *__endptr,
                           int __radix);
int         _RTLENTRY _EXPFUNC   system(const char * __command);
size_t      _RTLENTRY _EXPFUNC   wcstombs(char * __s, const wchar_t *__pwcs,
                           size_t __n);
int         _RTLENTRY _EXPFUNC   wctomb(char * __s, wchar_t __wc);

#ifdef __cplusplus
}
#endif

/* Variables */

#ifdef _MT

#ifdef __cplusplus
extern "C" {
#endif
extern  int * _RTLENTRY _EXPFUNC __errno(void);
extern  int * _RTLENTRY _EXPFUNC __doserrno(void);
#ifdef  __cplusplus
}
#endif
#define errno (*__errno())
#define _doserrno (*__doserrno())

#else   /* MT */

extern  int   _RTLENTRY _EXPDATA errno;
extern  int   _RTLENTRY _EXPDATA _doserrno;

#endif  /* MT */

#if !defined(__STDC__)

/* Values for _osmode */

#define _WIN_MODE    2  /* Windows 16- or 32-bit */
#define _OS2_20_MODE 3  /* OS/2 32-bit */
#define _DOSX32_MODE 4  /* DOS 32-bit */

#define environ  _environ

#endif /* __STDC__ */

extern  char          **_RTLENTRY _EXPDATA _environ;
extern  int             _RTLENTRY _EXPDATA _fileinfo;
extern  int             _RTLENTRY          _fmode;
extern  unsigned char   _RTLENTRY _EXPDATA _osmajor;
extern  unsigned char   _RTLENTRY _EXPDATA _osminor;
extern  unsigned char   _RTLENTRY _EXPDATA _osmode;
extern  unsigned int    _RTLENTRY _EXPDATA _osversion;

#if !defined(__STDC__)
#ifdef __cplusplus
   inline int _RTLENTRY atoi(const char *__s) { return (int)atol(__s); }
#else
#  define atoi(s)((int) atol(s))
#endif
#endif

#if !__STDC__
#define sys_nerr     _sys_nerr
#define sys_errlist  _sys_errlist
#endif

extern  char          * _RTLENTRY _EXPDATA _sys_errlist[];
extern  int             _RTLENTRY _EXPDATA _sys_nerr;


/* Constants for MSC pathname functions */

#define _MAX_PATH       260
#define _MAX_DRIVE      3
#define _MAX_DIR        256
#define _MAX_FNAME      256
#define _MAX_EXT        256

#ifdef __cplusplus
extern "C" {
#endif

long double   _RTLENTRY  _EXPFUNC _atold(const char * __s);

unsigned char _RTLENTRY  _EXPFUNC _crotl(unsigned char __value, int __count);
unsigned char _RTLENTRY  _EXPFUNC _crotr(unsigned char __value, int __count);

char *        _RTLENTRY  _EXPFUNC ecvt(double __value, int __ndig, int * __dec,
                                       int * __sign);
void          _RTLENTRY  _EXPFUNC _exit(int __status);
char *        _RTLENTRY  _EXPFUNC fcvt(double __value, int __ndig, int * __dec,
                                       int * __sign);
char *        _RTLENTRYF _EXPFUNC _fullpath(char * __buf, const char * __path,
                                            size_t __maxlen);
char *        _RTLENTRY  _EXPFUNC gcvt(double __value, int __ndec,
                                       char * __buf);
char *        _RTLENTRYF _EXPFUNC itoa(int __value, char * __string,
                                       int __radix);
void *        _RTLENTRY  _EXPFUNC lfind(const void * __key,
                                        const void * __base,
                                        size_t *__num, size_t __width,
                                        int (_USERENTRY *fcmp)(const void *, const void *));

long          _RTLENTRY  _EXPFUNC _lrand(void);
unsigned long _RTLENTRY  _EXPFUNC _lrotl(unsigned long __val, int __count);
unsigned long _RTLENTRY  _EXPFUNC _lrotr(unsigned long __val, int __count);

void *        _RTLENTRY  _EXPFUNC lsearch(const void * __key, void * __base,
                                          size_t *__num, size_t __width,
                                          int (_USERENTRY *fcmp)(const void *, const void *));

char *        _RTLENTRYF _EXPFUNC ltoa(long __value, char * __string,
                                       int __radix);
void          _RTLENTRY  _EXPFUNC _makepath(char * __path,
                                            const char * __drive,
                                            const char * __dir,
                                            const char * __name,
                                            const char * __ext );
int           _RTLENTRY  _EXPFUNC putenv(const char * __name);

unsigned short _RTLENTRY _EXPFUNC _rotl(unsigned short __value, int __count);
unsigned short _RTLENTRY _EXPFUNC _rotr(unsigned short __value, int __count);

void          _RTLENTRY  _EXPFUNC _searchenv(const char * __file,
                                             const char * __varname,
                                             char *__pathname);
void          _RTLENTRY  _EXPFUNC _searchstr(const char * __file,
                                             const char * __ipath,
                                             char *__pathname);
void          _RTLENTRY  _EXPFUNC _splitpath(const char * __path,
                                             char * __drive,
                                             char * __dir,
                                             char * __name,
                                             char * __ext );
void          _RTLENTRY  _EXPFUNC swab(char * __from, char * __to, int __nbytes);
char *        _RTLENTRYF _EXPFUNC ultoa(unsigned long __value, char * __string,
                                        int __radix);

/* Intrinsic functions */

unsigned char _RTLENTRY  ___crotl__(unsigned char __value, int __count);
unsigned char _RTLENTRY  ___crotr__(unsigned char __value, int __count);
unsigned long _RTLENTRY  ___lrotl__(unsigned long __val, int __count);
unsigned long _RTLENTRY  ___lrotr__(unsigned long __val, int __count);
unsigned short _RTLENTRY ___rotl__ (unsigned short __value, int __count);
unsigned short _RTLENTRY ___rotr__ (unsigned short __value, int __count);

#ifdef __cplusplus
}
#endif

#if !defined(__STDC__)

#if defined(__cplusplus)
inline int  _RTLENTRY random(int __num)
                       { return __num ? (int)(_lrand()%(__num)) : 0; }
#else /* __cplusplus */
#define random(num) (num ? (int)(_lrand()%(num)) : 0)
#endif  /* __cplusplus  */

#endif /* __STDC__ */


#if defined(__cplusplus)
extern "C" long _RTLENTRY _EXPFUNC time(long _FAR *);
#endif

#if !defined(__STDC__)

#if defined(__cplusplus)

/* Need prototype of time() for C++ randomize() */
inline void _RTLENTRY randomize(void) { srand((unsigned) time(NULL)); }

#ifndef __MINMAX_DEFINED
#define __MINMAX_DEFINED
template <class T> inline const T& min( const T& t1, const T& t2 )
{
    return t1>t2 ? t2 : t1;
}

template <class T> inline const T& max( const T& t1, const T& t2 )
{
    return t1>t2 ? t1 : t2;
}
#endif

#else /* __cplusplus */

#define randomize() srand((unsigned)time(NULL))
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

#define  MB_CUR_MAX              1

#endif /* __STDC__ */

#if defined(__MSC)
#define _itoa(__value, __string, __radix) itoa(__value, __string, __radix)
#endif


#if !defined(RC_INVOKED)

#pragma option -a.  /* restore default packing */

#if defined(__STDC__)
#pragma warn .nak
#endif

#endif  /* !RC_INVOKED */


#endif  /* __STDLIB_H */

