/*  mem.h

    Memory manipulation functions

*/

/*
 *      C/C++ Run Time Library - Version 1.5
 *
 *      Copyright (c) 1987, 1994 by Borland International
 *      All Rights Reserved.
 *
 */

#if !defined(__MEM_H)
#define __MEM_H

#if !defined(___DEFS_H)
#include <_defs.h>
#endif

#ifndef NULL
#include <_null.h>
#endif


#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn -nak
#endif

#endif  /* !RC_INVOKED */


#ifndef _STDDEF
#define _STDDEF
#ifndef _PTRDIFF_T
#define _PTRDIFF_T
#if defined(__LARGE__) || defined(__HUGE__) || defined(__COMPACT__)
   typedef long    ptrdiff_t;
#else
   typedef int ptrdiff_t;
#endif
#endif
#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif
#endif


#ifdef __cplusplus
extern "C" {
#endif



void * _RTLENTRY  _EXPFUNC memccpy(void * __dest, const void * __src,
                                  int __c, size_t __n);
int    _RTLENTRY  _EXPFUNC memcmp(const void * __s1, const void * __s2,
                                  size_t __n);
void * _RTLENTRY  _EXPFUNC memcpy(void * __dest, const void * __src,
                                  size_t __n);
int    _RTLENTRY  _EXPFUNC memicmp(const void * __s1, const void * __s2,
                                   size_t __n);
void * _RTLENTRYF _EXPFUNC memmove(void * __dest, const void * __src,
                                   size_t __n);
void * _RTLENTRYF _EXPFUNC memset(void * __s, int __c, size_t __n);

#define movmem(src,dest,length) (void)memmove(dest,src,length)
#define setmem(dest,length,value) (void)memset(dest,value,length)


#ifdef __cplusplus
}
#endif

#if defined(__cplusplus)
extern "C++" {
      void _FAR * _RTLENTRY _EXPFUNC32 memchr(void _FAR *__s, int __c, size_t __n);
const void _FAR * _RTLENTRY _EXPFUNC32 memchr(const void _FAR *__s, int __c, size_t __n);
}
#else
      void _FAR * _RTLENTRY _EXPFUNC32 memchr(const void _FAR *__s, int __c, size_t __n);
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(__STRING_H)
/* Intrinsic functions */

void _FAR * _RTLENTRY  _EXPFUNC16 __memchr__(const void _FAR * __s, int __c, size_t __n);
int         _RTLENTRY  _EXPFUNC16 __memcmp__(const void _FAR * __s1, const void _FAR * __s2, size_t __n);
void _FAR * _RTLENTRY  _EXPFUNC16 __memcpy__(void _FAR * __dest, const void _FAR * __src, size_t __n);
void _FAR * _RTLENTRYF _EXPFUNC16 __memset__(void _FAR * __s, int __c, size_t __n);
#endif

#ifdef __cplusplus
}
#endif


#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn .nak
#endif

#endif  /* !RC_INVOKED */


#endif  /* __MEM_H */
