/*  malloc.h

    memory management functions and variables.

*/

/*
 *      C/C++ Run Time Library - Version 1.5
 *
 *      Copyright (c) 1991, 1994 by Borland International
 *      All Rights Reserved.
 *
 */

#ifndef __MALLOC_H
#define __MALLOC_H

#include <alloc.h>

#ifdef __cplusplus
extern "C" {
#endif


#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn -nak
#endif

#endif  /* !RC_INVOKED */


#ifndef _SIZE_T
  #define _SIZE_T
  typedef unsigned size_t;
#endif

/* _HEAPINFO structure returned by heapwalk */


#if !defined(RC_INVOKED)
#pragma option -a-
#endif


typedef struct _heapinfo
{
    int     *_pentry;
    size_t  _size;
    int     _useflag;
} _HEAPINFO;


#if !defined(RC_INVOKED)
#pragma option -a.
#endif





/* Prototypes */

void *      __cdecl   _EXPFUNC alloca( size_t __size );
void *      __cdecl            __alloca__ (size_t __size);

size_t      _RTLENTRY _EXPFUNC stackavail  (void);
int         _RTLENTRY _EXPFUNC _heapadd    (void * __block, size_t __size);
int         _RTLENTRY _EXPFUNC _heapchk    (void);
int         _RTLENTRY _EXPFUNC _heapmin    (void);
int         _RTLENTRY _EXPFUNC _heapset    (unsigned int __fill);
int         _RTLENTRY _EXPFUNC _heapwalk   (_HEAPINFO *__entry);
int         _RTLENTRY _EXPFUNC _rtl_heapwalk (_HEAPINFO *__entry);
void *      _RTLENTRY _EXPFUNC _expand     (void * __block, size_t __size);
size_t      _RTLENTRY _EXPFUNC _msize      (void * __block );



#ifdef __cplusplus
}
#endif

/* Obsolete functions */


#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn .nak
#endif

#endif  /* !RC_INVOKED */


#endif  /* __MALLOC_H */
